/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */

(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("pdfjs-dist/build/pdf.worker", [], factory);
	else if(typeof exports === 'object')
		exports["pdfjs-dist/build/pdf.worker"] = factory();
	else
		root["pdfjs-dist/build/pdf.worker"] = root.pdfjsWorker = factory();
})(this, function() {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WorkerTask = exports.WorkerMessageHandler = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

var _pdf_manager = __w_pdfjs_require__(115);

var _writer = __w_pdfjs_require__(172);

var _is_node = __w_pdfjs_require__(6);

var _message_handler = __w_pdfjs_require__(197);

var _worker_stream = __w_pdfjs_require__(198);

var _core_utils = __w_pdfjs_require__(117);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var WorkerTask = /*#__PURE__*/function () {
  function WorkerTask(name) {
    _classCallCheck(this, WorkerTask);

    this.name = name;
    this.terminated = false;
    this._capability = (0, _util.createPromiseCapability)();
  }

  _createClass(WorkerTask, [{
    key: "finished",
    get: function get() {
      return this._capability.promise;
    }
  }, {
    key: "finish",
    value: function finish() {
      this._capability.resolve();
    }
  }, {
    key: "terminate",
    value: function terminate() {
      this.terminated = true;
    }
  }, {
    key: "ensureNotTerminated",
    value: function ensureNotTerminated() {
      if (this.terminated) {
        throw new Error("Worker task was terminated");
      }
    }
  }]);

  return WorkerTask;
}();

exports.WorkerTask = WorkerTask;

var WorkerMessageHandler = /*#__PURE__*/function () {
  function WorkerMessageHandler() {
    _classCallCheck(this, WorkerMessageHandler);
  }

  _createClass(WorkerMessageHandler, null, [{
    key: "setup",
    value: function setup(handler, port) {
      var testMessageProcessed = false;
      handler.on("test", function wphSetupTest(data) {
        if (testMessageProcessed) {
          return;
        }

        testMessageProcessed = true;

        if (!(data instanceof Uint8Array)) {
          handler.send("test", null);
          return;
        }

        var supportTransfers = data[0] === 255;
        handler.postMessageTransfers = supportTransfers;
        handler.send("test", {
          supportTransfers: supportTransfers
        });
      });
      handler.on("configure", function wphConfigure(data) {
        (0, _util.setVerbosityLevel)(data.verbosity);
      });
      handler.on("GetDocRequest", function wphSetupDoc(data) {
        return WorkerMessageHandler.createDocumentHandler(data, port);
      });
    }
  }, {
    key: "createDocumentHandler",
    value: function createDocumentHandler(docParams, port) {
      var pdfManager;
      var terminated = false;
      var cancelXHRs = null;
      var WorkerTasks = [];
      var verbosity = (0, _util.getVerbosityLevel)();
      var apiVersion = docParams.apiVersion;
      var workerVersion = '2.9.359';

      if (apiVersion !== workerVersion) {
        throw new Error("The API version \"".concat(apiVersion, "\" does not match ") + "the Worker version \"".concat(workerVersion, "\"."));
      }

      var enumerableProperties = [];

      for (var property in []) {
        enumerableProperties.push(property);
      }

      if (enumerableProperties.length) {
        throw new Error("The `Array.prototype` contains unexpected enumerable properties: " + enumerableProperties.join(", ") + "; thus breaking e.g. `for...in` iteration of `Array`s.");
      }

      var docId = docParams.docId;
      var docBaseUrl = docParams.docBaseUrl;
      var workerHandlerName = docParams.docId + "_worker";
      var handler = new _message_handler.MessageHandler(workerHandlerName, docId, port);
      handler.postMessageTransfers = docParams.postMessageTransfers;

      function ensureNotTerminated() {
        if (terminated) {
          throw new Error("Worker was terminated");
        }
      }

      function startWorkerTask(task) {
        WorkerTasks.push(task);
      }

      function finishWorkerTask(task) {
        task.finish();
        var i = WorkerTasks.indexOf(task);
        WorkerTasks.splice(i, 1);
      }

      function loadDocument(_x) {
        return _loadDocument.apply(this, arguments);
      }

      function _loadDocument() {
        _loadDocument = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(recoveryMode) {
          var _yield$Promise$all, _yield$Promise$all2, numPages, fingerprint, isPureXfa, task;

          return _regenerator["default"].wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return pdfManager.ensureDoc("checkHeader");

                case 2:
                  _context.next = 4;
                  return pdfManager.ensureDoc("parseStartXRef");

                case 4:
                  _context.next = 6;
                  return pdfManager.ensureDoc("parse", [recoveryMode]);

                case 6:
                  if (recoveryMode) {
                    _context.next = 9;
                    break;
                  }

                  _context.next = 9;
                  return pdfManager.ensureDoc("checkFirstPage");

                case 9:
                  _context.next = 11;
                  return Promise.all([pdfManager.ensureDoc("numPages"), pdfManager.ensureDoc("fingerprint"), pdfManager.ensureDoc("isPureXfa")]);

                case 11:
                  _yield$Promise$all = _context.sent;
                  _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 3);
                  numPages = _yield$Promise$all2[0];
                  fingerprint = _yield$Promise$all2[1];
                  isPureXfa = _yield$Promise$all2[2];

                  if (!isPureXfa) {
                    _context.next = 21;
                    break;
                  }

                  task = new WorkerTask("loadXfaFonts");
                  startWorkerTask(task);
                  _context.next = 21;
                  return pdfManager.loadXfaFonts(handler, task)["catch"](function (reason) {}).then(function () {
                    return finishWorkerTask(task);
                  });

                case 21:
                  return _context.abrupt("return", {
                    numPages: numPages,
                    fingerprint: fingerprint,
                    isPureXfa: isPureXfa
                  });

                case 22:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));
        return _loadDocument.apply(this, arguments);
      }

      function getPdfManager(data, evaluatorOptions, enableXfa) {
        var pdfManagerCapability = (0, _util.createPromiseCapability)();
        var newPdfManager;
        var source = data.source;

        if (source.data) {
          try {
            newPdfManager = new _pdf_manager.LocalPdfManager(docId, source.data, source.password, evaluatorOptions, enableXfa, docBaseUrl);
            pdfManagerCapability.resolve(newPdfManager);
          } catch (ex) {
            pdfManagerCapability.reject(ex);
          }

          return pdfManagerCapability.promise;
        }

        var pdfStream,
            cachedChunks = [];

        try {
          pdfStream = new _worker_stream.PDFWorkerStream(handler);
        } catch (ex) {
          pdfManagerCapability.reject(ex);
          return pdfManagerCapability.promise;
        }

        var fullRequest = pdfStream.getFullReader();
        fullRequest.headersReady.then(function () {
          if (!fullRequest.isRangeSupported) {
            return;
          }

          var disableAutoFetch = source.disableAutoFetch || fullRequest.isStreamingSupported;
          newPdfManager = new _pdf_manager.NetworkPdfManager(docId, pdfStream, {
            msgHandler: handler,
            password: source.password,
            length: fullRequest.contentLength,
            disableAutoFetch: disableAutoFetch,
            rangeChunkSize: source.rangeChunkSize
          }, evaluatorOptions, enableXfa, docBaseUrl);

          for (var i = 0; i < cachedChunks.length; i++) {
            newPdfManager.sendProgressiveData(cachedChunks[i]);
          }

          cachedChunks = [];
          pdfManagerCapability.resolve(newPdfManager);
          cancelXHRs = null;
        })["catch"](function (reason) {
          pdfManagerCapability.reject(reason);
          cancelXHRs = null;
        });
        var loaded = 0;

        var flushChunks = function flushChunks() {
          var pdfFile = (0, _util.arraysToBytes)(cachedChunks);

          if (source.length && pdfFile.length !== source.length) {
            (0, _util.warn)("reported HTTP length is different from actual");
          }

          try {
            newPdfManager = new _pdf_manager.LocalPdfManager(docId, pdfFile, source.password, evaluatorOptions, enableXfa, docBaseUrl);
            pdfManagerCapability.resolve(newPdfManager);
          } catch (ex) {
            pdfManagerCapability.reject(ex);
          }

          cachedChunks = [];
        };

        var readPromise = new Promise(function (resolve, reject) {
          var readChunk = function readChunk(_ref) {
            var value = _ref.value,
                done = _ref.done;

            try {
              ensureNotTerminated();

              if (done) {
                if (!newPdfManager) {
                  flushChunks();
                }

                cancelXHRs = null;
                return;
              }

              loaded += (0, _util.arrayByteLength)(value);

              if (!fullRequest.isStreamingSupported) {
                handler.send("DocProgress", {
                  loaded: loaded,
                  total: Math.max(loaded, fullRequest.contentLength || 0)
                });
              }

              if (newPdfManager) {
                newPdfManager.sendProgressiveData(value);
              } else {
                cachedChunks.push(value);
              }

              fullRequest.read().then(readChunk, reject);
            } catch (e) {
              reject(e);
            }
          };

          fullRequest.read().then(readChunk, reject);
        });
        readPromise["catch"](function (e) {
          pdfManagerCapability.reject(e);
          cancelXHRs = null;
        });

        cancelXHRs = function cancelXHRs(reason) {
          pdfStream.cancelAllRequests(reason);
        };

        return pdfManagerCapability.promise;
      }

      function setupDoc(data) {
        function onSuccess(doc) {
          ensureNotTerminated();
          handler.send("GetDoc", {
            pdfInfo: doc
          });
        }

        function onFailure(ex) {
          ensureNotTerminated();

          if (ex instanceof _util.PasswordException) {
            var task = new WorkerTask("PasswordException: response ".concat(ex.code));
            startWorkerTask(task);
            handler.sendWithPromise("PasswordRequest", ex).then(function (_ref2) {
              var password = _ref2.password;
              finishWorkerTask(task);
              pdfManager.updatePassword(password);
              pdfManagerReady();
            })["catch"](function () {
              finishWorkerTask(task);
              handler.send("DocException", ex);
            });
          } else if (ex instanceof _util.InvalidPDFException || ex instanceof _util.MissingPDFException || ex instanceof _util.UnexpectedResponseException || ex instanceof _util.UnknownErrorException) {
            handler.send("DocException", ex);
          } else {
            handler.send("DocException", new _util.UnknownErrorException(ex.message, ex.toString()));
          }
        }

        function pdfManagerReady() {
          ensureNotTerminated();
          loadDocument(false).then(onSuccess, function (reason) {
            ensureNotTerminated();

            if (!(reason instanceof _core_utils.XRefParseException)) {
              onFailure(reason);
              return;
            }

            pdfManager.requestLoadedStream();
            pdfManager.onLoadedStream().then(function () {
              ensureNotTerminated();
              loadDocument(true).then(onSuccess, onFailure);
            });
          });
        }

        ensureNotTerminated();
        var evaluatorOptions = {
          maxImageSize: data.maxImageSize,
          disableFontFace: data.disableFontFace,
          ignoreErrors: data.ignoreErrors,
          isEvalSupported: data.isEvalSupported,
          fontExtraProperties: data.fontExtraProperties
        };
        getPdfManager(data, evaluatorOptions, data.enableXfa).then(function (newPdfManager) {
          if (terminated) {
            newPdfManager.terminate(new _util.AbortException("Worker was terminated."));
            throw new Error("Worker was terminated");
          }

          pdfManager = newPdfManager;
          pdfManager.onLoadedStream().then(function (stream) {
            handler.send("DataLoaded", {
              length: stream.bytes.byteLength
            });
          });
        }).then(pdfManagerReady, onFailure);
      }

      handler.on("GetPage", function wphSetupGetPage(data) {
        return pdfManager.getPage(data.pageIndex).then(function (page) {
          return Promise.all([pdfManager.ensure(page, "rotate"), pdfManager.ensure(page, "ref"), pdfManager.ensure(page, "userUnit"), pdfManager.ensure(page, "view")]).then(function (_ref3) {
            var _ref4 = _slicedToArray(_ref3, 4),
                rotate = _ref4[0],
                ref = _ref4[1],
                userUnit = _ref4[2],
                view = _ref4[3];

            return {
              rotate: rotate,
              ref: ref,
              userUnit: userUnit,
              view: view
            };
          });
        });
      });
      handler.on("GetPageIndex", function wphSetupGetPageIndex(_ref5) {
        var ref = _ref5.ref;

        var pageRef = _primitives.Ref.get(ref.num, ref.gen);

        return pdfManager.ensureCatalog("getPageIndex", [pageRef]);
      });
      handler.on("GetDestinations", function wphSetupGetDestinations(data) {
        return pdfManager.ensureCatalog("destinations");
      });
      handler.on("GetDestination", function wphSetupGetDestination(data) {
        return pdfManager.ensureCatalog("getDestination", [data.id]);
      });
      handler.on("GetPageLabels", function wphSetupGetPageLabels(data) {
        return pdfManager.ensureCatalog("pageLabels");
      });
      handler.on("GetPageLayout", function wphSetupGetPageLayout(data) {
        return pdfManager.ensureCatalog("pageLayout");
      });
      handler.on("GetPageMode", function wphSetupGetPageMode(data) {
        return pdfManager.ensureCatalog("pageMode");
      });
      handler.on("GetViewerPreferences", function (data) {
        return pdfManager.ensureCatalog("viewerPreferences");
      });
      handler.on("GetOpenAction", function (data) {
        return pdfManager.ensureCatalog("openAction");
      });
      handler.on("GetAttachments", function wphSetupGetAttachments(data) {
        return pdfManager.ensureCatalog("attachments");
      });
      handler.on("GetJavaScript", function wphSetupGetJavaScript(data) {
        return pdfManager.ensureCatalog("javaScript");
      });
      handler.on("GetDocJSActions", function wphSetupGetDocJSActions(data) {
        return pdfManager.ensureCatalog("jsActions");
      });
      handler.on("GetPageJSActions", function (_ref6) {
        var pageIndex = _ref6.pageIndex;
        return pdfManager.getPage(pageIndex).then(function (page) {
          return pdfManager.ensure(page, "jsActions");
        });
      });
      handler.on("GetPageXfa", function wphSetupGetXfa(_ref7) {
        var pageIndex = _ref7.pageIndex;
        return pdfManager.getPage(pageIndex).then(function (page) {
          return pdfManager.ensure(page, "xfaData");
        });
      });
      handler.on("GetOutline", function wphSetupGetOutline(data) {
        return pdfManager.ensureCatalog("documentOutline");
      });
      handler.on("GetOptionalContentConfig", function (data) {
        return pdfManager.ensureCatalog("optionalContentConfig");
      });
      handler.on("GetPermissions", function (data) {
        return pdfManager.ensureCatalog("permissions");
      });
      handler.on("GetMetadata", function wphSetupGetMetadata(data) {
        return Promise.all([pdfManager.ensureDoc("documentInfo"), pdfManager.ensureCatalog("metadata")]);
      });
      handler.on("GetMarkInfo", function wphSetupGetMarkInfo(data) {
        return pdfManager.ensureCatalog("markInfo");
      });
      handler.on("GetData", function wphSetupGetData(data) {
        pdfManager.requestLoadedStream();
        return pdfManager.onLoadedStream().then(function (stream) {
          return stream.bytes;
        });
      });
      handler.on("GetStats", function wphSetupGetStats(data) {
        return pdfManager.ensureXRef("stats");
      });
      handler.on("GetAnnotations", function (_ref8) {
        var pageIndex = _ref8.pageIndex,
            intent = _ref8.intent;
        return pdfManager.getPage(pageIndex).then(function (page) {
          return page.getAnnotationsData(intent);
        });
      });
      handler.on("GetFieldObjects", function (data) {
        return pdfManager.ensureDoc("fieldObjects");
      });
      handler.on("HasJSActions", function (data) {
        return pdfManager.ensureDoc("hasJSActions");
      });
      handler.on("GetCalculationOrderIds", function (data) {
        return pdfManager.ensureDoc("calculationOrderIds");
      });
      handler.on("SaveDocument", function (_ref9) {
        var numPages = _ref9.numPages,
            annotationStorage = _ref9.annotationStorage,
            filename = _ref9.filename;
        pdfManager.requestLoadedStream();
        var promises = [pdfManager.onLoadedStream(), pdfManager.ensureCatalog("acroForm"), pdfManager.ensureDoc("xref"), pdfManager.ensureDoc("startXRef")];

        var _loop = function _loop(pageIndex) {
          promises.push(pdfManager.getPage(pageIndex).then(function (page) {
            var task = new WorkerTask("Save: page ".concat(pageIndex));
            startWorkerTask(task);
            return page.save(handler, task, annotationStorage)["finally"](function () {
              finishWorkerTask(task);
            });
          }));
        };

        for (var pageIndex = 0; pageIndex < numPages; pageIndex++) {
          _loop(pageIndex);
        }

        return Promise.all(promises).then(function (_ref10) {
          var _ref11 = _toArray(_ref10),
              stream = _ref11[0],
              acroForm = _ref11[1],
              xref = _ref11[2],
              startXRef = _ref11[3],
              refs = _ref11.slice(4);

          var newRefs = [];

          var _iterator = _createForOfIteratorHelper(refs),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var ref = _step.value;
              newRefs = ref.filter(function (x) {
                return x !== null;
              }).reduce(function (a, b) {
                return a.concat(b);
              }, newRefs);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          if (newRefs.length === 0) {
            return stream.bytes;
          }

          var xfa = acroForm instanceof _primitives.Dict && acroForm.get("XFA") || [];
          var xfaDatasets = null;

          if (Array.isArray(xfa)) {
            for (var i = 0, ii = xfa.length; i < ii; i += 2) {
              if (xfa[i] === "datasets") {
                xfaDatasets = xfa[i + 1];
              }
            }
          } else {
            (0, _util.warn)("Unsupported XFA type.");
          }

          var newXrefInfo = Object.create(null);

          if (xref.trailer) {
            var infoObj = Object.create(null);
            var xrefInfo = xref.trailer.get("Info") || null;

            if (xrefInfo instanceof _primitives.Dict) {
              xrefInfo.forEach(function (key, value) {
                if ((0, _util.isString)(key) && (0, _util.isString)(value)) {
                  infoObj[key] = (0, _util.stringToPDFString)(value);
                }
              });
            }

            newXrefInfo = {
              rootRef: xref.trailer.getRaw("Root") || null,
              encryptRef: xref.trailer.getRaw("Encrypt") || null,
              newRef: xref.getNewRef(),
              infoRef: xref.trailer.getRaw("Info") || null,
              info: infoObj,
              fileIds: xref.trailer.get("ID") || null,
              startXRef: startXRef,
              filename: filename
            };
          }

          xref.resetNewRef();
          return (0, _writer.incrementalUpdate)({
            originalData: stream.bytes,
            xrefInfo: newXrefInfo,
            newRefs: newRefs,
            xref: xref,
            datasetsRef: xfaDatasets
          });
        });
      });
      handler.on("GetOperatorList", function wphSetupRenderPage(data, sink) {
        var pageIndex = data.pageIndex;
        pdfManager.getPage(pageIndex).then(function (page) {
          var task = new WorkerTask("GetOperatorList: page ".concat(pageIndex));
          startWorkerTask(task);
          var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
          page.getOperatorList({
            handler: handler,
            sink: sink,
            task: task,
            intent: data.intent,
            renderInteractiveForms: data.renderInteractiveForms,
            annotationStorage: data.annotationStorage
          }).then(function (operatorListInfo) {
            finishWorkerTask(task);

            if (start) {
              (0, _util.info)("page=".concat(pageIndex + 1, " - getOperatorList: time=") + "".concat(Date.now() - start, "ms, len=").concat(operatorListInfo.length));
            }

            sink.close();
          }, function (reason) {
            finishWorkerTask(task);

            if (task.terminated) {
              return;
            }

            handler.send("UnsupportedFeature", {
              featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
            });
            sink.error(reason);
          });
        });
      });
      handler.on("GetTextContent", function wphExtractText(data, sink) {
        var pageIndex = data.pageIndex;

        sink.onPull = function (desiredSize) {};

        sink.onCancel = function (reason) {};

        pdfManager.getPage(pageIndex).then(function (page) {
          var task = new WorkerTask("GetTextContent: page " + pageIndex);
          startWorkerTask(task);
          var start = verbosity >= _util.VerbosityLevel.INFOS ? Date.now() : 0;
          page.extractTextContent({
            handler: handler,
            task: task,
            sink: sink,
            normalizeWhitespace: data.normalizeWhitespace,
            includeMarkedContent: data.includeMarkedContent,
            combineTextItems: data.combineTextItems
          }).then(function () {
            finishWorkerTask(task);

            if (start) {
              (0, _util.info)("page=".concat(pageIndex + 1, " - getTextContent: time=") + "".concat(Date.now() - start, "ms"));
            }

            sink.close();
          }, function (reason) {
            finishWorkerTask(task);

            if (task.terminated) {
              return;
            }

            sink.error(reason);
          });
        });
      });
      handler.on("GetStructTree", function wphGetStructTree(data) {
        return pdfManager.getPage(data.pageIndex).then(function (page) {
          return pdfManager.ensure(page, "getStructTree");
        });
      });
      handler.on("FontFallback", function (data) {
        return pdfManager.fontFallback(data.id, handler);
      });
      handler.on("Cleanup", function wphCleanup(data) {
        return pdfManager.cleanup(true);
      });
      handler.on("Terminate", function wphTerminate(data) {
        terminated = true;
        var waitOn = [];

        if (pdfManager) {
          pdfManager.terminate(new _util.AbortException("Worker was terminated."));
          var cleanupPromise = pdfManager.cleanup();
          waitOn.push(cleanupPromise);
          pdfManager = null;
        } else {
          (0, _primitives.clearPrimitiveCaches)();
        }

        if (cancelXHRs) {
          cancelXHRs(new _util.AbortException("Worker was terminated."));
        }

        var _iterator2 = _createForOfIteratorHelper(WorkerTasks),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var task = _step2.value;
            waitOn.push(task.finished);
            task.terminate();
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return Promise.all(waitOn).then(function () {
          handler.destroy();
          handler = null;
        });
      });
      handler.on("Ready", function wphReady(data) {
        setupDoc(docParams);
        docParams = null;
      });
      return workerHandlerName;
    }
  }, {
    key: "initializeFromPort",
    value: function initializeFromPort(port) {
      var handler = new _message_handler.MessageHandler("worker", "main", port);
      WorkerMessageHandler.setup(handler, port);
      handler.send("ready", null);
    }
  }]);

  return WorkerMessageHandler;
}();

exports.WorkerMessageHandler = WorkerMessageHandler;

function isMessagePort(maybePort) {
  return typeof maybePort.postMessage === "function" && "onmessage" in maybePort;
}

if (typeof window === "undefined" && !_is_node.isNodeJS && typeof self !== "undefined" && isMessagePort(self)) {
  WorkerMessageHandler.initializeFromPort(self);
}

/***/ }),
/* 2 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";


module.exports = __w_pdfjs_require__(3);

/***/ }),
/* 3 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";
/* module decorator */ module = __w_pdfjs_require__.nmd(module);


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var runtime = function (exports) {
  "use strict";

  var Op = Object.prototype;
  var hasOwn = Op.hasOwnProperty;
  var undefined;
  var $Symbol = typeof Symbol === "function" ? Symbol : {};
  var iteratorSymbol = $Symbol.iterator || "@@iterator";
  var asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator";
  var toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";

  function define(obj, key, value) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
    return obj[key];
  }

  try {
    define({}, "");
  } catch (err) {
    define = function define(obj, key, value) {
      return obj[key] = value;
    };
  }

  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator;
    var generator = Object.create(protoGenerator.prototype);
    var context = new Context(tryLocsList || []);
    generator._invoke = makeInvokeMethod(innerFn, self, context);
    return generator;
  }

  exports.wrap = wrap;

  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }

  var GenStateSuspendedStart = "suspendedStart";
  var GenStateSuspendedYield = "suspendedYield";
  var GenStateExecuting = "executing";
  var GenStateCompleted = "completed";
  var ContinueSentinel = {};

  function Generator() {}

  function GeneratorFunction() {}

  function GeneratorFunctionPrototype() {}

  var IteratorPrototype = {};

  IteratorPrototype[iteratorSymbol] = function () {
    return this;
  };

  var getProto = Object.getPrototypeOf;
  var NativeIteratorPrototype = getProto && getProto(getProto(values([])));

  if (NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol)) {
    IteratorPrototype = NativeIteratorPrototype;
  }

  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  GeneratorFunction.prototype = Gp.constructor = GeneratorFunctionPrototype;
  GeneratorFunctionPrototype.constructor = GeneratorFunction;
  GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction");

  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }

  exports.isGeneratorFunction = function (genFun) {
    var ctor = typeof genFun === "function" && genFun.constructor;
    return ctor ? ctor === GeneratorFunction || (ctor.displayName || ctor.name) === "GeneratorFunction" : false;
  };

  exports.mark = function (genFun) {
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(genFun, GeneratorFunctionPrototype);
    } else {
      genFun.__proto__ = GeneratorFunctionPrototype;
      define(genFun, toStringTagSymbol, "GeneratorFunction");
    }

    genFun.prototype = Object.create(Gp);
    return genFun;
  };

  exports.awrap = function (arg) {
    return {
      __await: arg
    };
  };

  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);

      if (record.type === "throw") {
        reject(record.arg);
      } else {
        var result = record.arg;
        var value = result.value;

        if (value && _typeof(value) === "object" && hasOwn.call(value, "__await")) {
          return PromiseImpl.resolve(value.__await).then(function (value) {
            invoke("next", value, resolve, reject);
          }, function (err) {
            invoke("throw", err, resolve, reject);
          });
        }

        return PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped;
          resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
    }

    var previousPromise;

    function enqueue(method, arg) {
      function callInvokeWithMethodAndArg() {
        return new PromiseImpl(function (resolve, reject) {
          invoke(method, arg, resolve, reject);
        });
      }

      return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
    }

    this._invoke = enqueue;
  }

  defineIteratorMethods(AsyncIterator.prototype);

  AsyncIterator.prototype[asyncIteratorSymbol] = function () {
    return this;
  };

  exports.AsyncIterator = AsyncIterator;

  exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    if (PromiseImpl === void 0) PromiseImpl = Promise;
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  };

  function makeInvokeMethod(innerFn, self, context) {
    var state = GenStateSuspendedStart;
    return function invoke(method, arg) {
      if (state === GenStateExecuting) {
        throw new Error("Generator is already running");
      }

      if (state === GenStateCompleted) {
        if (method === "throw") {
          throw arg;
        }

        return doneResult();
      }

      context.method = method;
      context.arg = arg;

      while (true) {
        var delegate = context.delegate;

        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);

          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }

        if (context.method === "next") {
          context.sent = context._sent = context.arg;
        } else if (context.method === "throw") {
          if (state === GenStateSuspendedStart) {
            state = GenStateCompleted;
            throw context.arg;
          }

          context.dispatchException(context.arg);
        } else if (context.method === "return") {
          context.abrupt("return", context.arg);
        }

        state = GenStateExecuting;
        var record = tryCatch(innerFn, self, context);

        if (record.type === "normal") {
          state = context.done ? GenStateCompleted : GenStateSuspendedYield;

          if (record.arg === ContinueSentinel) {
            continue;
          }

          return {
            value: record.arg,
            done: context.done
          };
        } else if (record.type === "throw") {
          state = GenStateCompleted;
          context.method = "throw";
          context.arg = record.arg;
        }
      }
    };
  }

  function maybeInvokeDelegate(delegate, context) {
    var method = delegate.iterator[context.method];

    if (method === undefined) {
      context.delegate = null;

      if (context.method === "throw") {
        if (delegate.iterator["return"]) {
          context.method = "return";
          context.arg = undefined;
          maybeInvokeDelegate(delegate, context);

          if (context.method === "throw") {
            return ContinueSentinel;
          }
        }

        context.method = "throw";
        context.arg = new TypeError("The iterator does not provide a 'throw' method");
      }

      return ContinueSentinel;
    }

    var record = tryCatch(method, delegate.iterator, context.arg);

    if (record.type === "throw") {
      context.method = "throw";
      context.arg = record.arg;
      context.delegate = null;
      return ContinueSentinel;
    }

    var info = record.arg;

    if (!info) {
      context.method = "throw";
      context.arg = new TypeError("iterator result is not an object");
      context.delegate = null;
      return ContinueSentinel;
    }

    if (info.done) {
      context[delegate.resultName] = info.value;
      context.next = delegate.nextLoc;

      if (context.method !== "return") {
        context.method = "next";
        context.arg = undefined;
      }
    } else {
      return info;
    }

    context.delegate = null;
    return ContinueSentinel;
  }

  defineIteratorMethods(Gp);
  define(Gp, toStringTagSymbol, "Generator");

  Gp[iteratorSymbol] = function () {
    return this;
  };

  Gp.toString = function () {
    return "[object Generator]";
  };

  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };

    if (1 in locs) {
      entry.catchLoc = locs[1];
    }

    if (2 in locs) {
      entry.finallyLoc = locs[2];
      entry.afterLoc = locs[3];
    }

    this.tryEntries.push(entry);
  }

  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal";
    delete record.arg;
    entry.completion = record;
  }

  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }];
    tryLocsList.forEach(pushTryEntry, this);
    this.reset(true);
  }

  exports.keys = function (object) {
    var keys = [];

    for (var key in object) {
      keys.push(key);
    }

    keys.reverse();
    return function next() {
      while (keys.length) {
        var key = keys.pop();

        if (key in object) {
          next.value = key;
          next.done = false;
          return next;
        }
      }

      next.done = true;
      return next;
    };
  };

  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];

      if (iteratorMethod) {
        return iteratorMethod.call(iterable);
      }

      if (typeof iterable.next === "function") {
        return iterable;
      }

      if (!isNaN(iterable.length)) {
        var i = -1,
            next = function next() {
          while (++i < iterable.length) {
            if (hasOwn.call(iterable, i)) {
              next.value = iterable[i];
              next.done = false;
              return next;
            }
          }

          next.value = undefined;
          next.done = true;
          return next;
        };

        return next.next = next;
      }
    }

    return {
      next: doneResult
    };
  }

  exports.values = values;

  function doneResult() {
    return {
      value: undefined,
      done: true
    };
  }

  Context.prototype = {
    constructor: Context,
    reset: function reset(skipTempReset) {
      this.prev = 0;
      this.next = 0;
      this.sent = this._sent = undefined;
      this.done = false;
      this.delegate = null;
      this.method = "next";
      this.arg = undefined;
      this.tryEntries.forEach(resetTryEntry);

      if (!skipTempReset) {
        for (var name in this) {
          if (name.charAt(0) === "t" && hasOwn.call(this, name) && !isNaN(+name.slice(1))) {
            this[name] = undefined;
          }
        }
      }
    },
    stop: function stop() {
      this.done = true;
      var rootEntry = this.tryEntries[0];
      var rootRecord = rootEntry.completion;

      if (rootRecord.type === "throw") {
        throw rootRecord.arg;
      }

      return this.rval;
    },
    dispatchException: function dispatchException(exception) {
      if (this.done) {
        throw exception;
      }

      var context = this;

      function handle(loc, caught) {
        record.type = "throw";
        record.arg = exception;
        context.next = loc;

        if (caught) {
          context.method = "next";
          context.arg = undefined;
        }

        return !!caught;
      }

      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        var record = entry.completion;

        if (entry.tryLoc === "root") {
          return handle("end");
        }

        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc");
          var hasFinally = hasOwn.call(entry, "finallyLoc");

          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            } else if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) {
              return handle(entry.catchLoc, true);
            }
          } else if (hasFinally) {
            if (this.prev < entry.finallyLoc) {
              return handle(entry.finallyLoc);
            }
          } else {
            throw new Error("try statement without catch or finally");
          }
        }
      }
    },
    abrupt: function abrupt(type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }

      if (finallyEntry && (type === "break" || type === "continue") && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc) {
        finallyEntry = null;
      }

      var record = finallyEntry ? finallyEntry.completion : {};
      record.type = type;
      record.arg = arg;

      if (finallyEntry) {
        this.method = "next";
        this.next = finallyEntry.finallyLoc;
        return ContinueSentinel;
      }

      return this.complete(record);
    },
    complete: function complete(record, afterLoc) {
      if (record.type === "throw") {
        throw record.arg;
      }

      if (record.type === "break" || record.type === "continue") {
        this.next = record.arg;
      } else if (record.type === "return") {
        this.rval = this.arg = record.arg;
        this.method = "return";
        this.next = "end";
      } else if (record.type === "normal" && afterLoc) {
        this.next = afterLoc;
      }

      return ContinueSentinel;
    },
    finish: function finish(finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.finallyLoc === finallyLoc) {
          this.complete(entry.completion, entry.afterLoc);
          resetTryEntry(entry);
          return ContinueSentinel;
        }
      }
    },
    "catch": function _catch(tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];

        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;

          if (record.type === "throw") {
            var thrown = record.arg;
            resetTryEntry(entry);
          }

          return thrown;
        }
      }

      throw new Error("illegal catch attempt");
    },
    delegateYield: function delegateYield(iterable, resultName, nextLoc) {
      this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      };

      if (this.method === "next") {
        this.arg = undefined;
      }

      return ContinueSentinel;
    }
  };
  return exports;
}(( false ? 0 : _typeof(module)) === "object" ? module.exports : {});

try {
  regeneratorRuntime = runtime;
} catch (accidentalStrictMode) {
  Function("r", "regeneratorRuntime = r")(runtime);
}

/***/ }),
/* 4 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.arrayByteLength = arrayByteLength;
exports.arraysToBytes = arraysToBytes;
exports.assert = assert;
exports.bytesToString = bytesToString;
exports.createObjectURL = createObjectURL;
exports.createPromiseCapability = createPromiseCapability;
exports.createValidAbsoluteUrl = createValidAbsoluteUrl;
exports.escapeString = escapeString;
exports.getModificationDate = getModificationDate;
exports.getVerbosityLevel = getVerbosityLevel;
exports.info = info;
exports.isArrayBuffer = isArrayBuffer;
exports.isArrayEqual = isArrayEqual;
exports.isAscii = isAscii;
exports.isBool = isBool;
exports.isNum = isNum;
exports.isSameOrigin = isSameOrigin;
exports.isString = isString;
exports.objectFromMap = objectFromMap;
exports.objectSize = objectSize;
exports.removeNullCharacters = removeNullCharacters;
exports.setVerbosityLevel = setVerbosityLevel;
exports.shadow = shadow;
exports.string32 = string32;
exports.stringToBytes = stringToBytes;
exports.stringToPDFString = stringToPDFString;
exports.stringToUTF16BEString = stringToUTF16BEString;
exports.stringToUTF8String = stringToUTF8String;
exports.unreachable = unreachable;
exports.utf8StringToString = utf8StringToString;
exports.warn = warn;
exports.VerbosityLevel = exports.Util = exports.UNSUPPORTED_FEATURES = exports.UnknownErrorException = exports.UnexpectedResponseException = exports.TextRenderingMode = exports.StreamType = exports.PermissionFlag = exports.PasswordResponses = exports.PasswordException = exports.PageActionEventType = exports.OPS = exports.MissingPDFException = exports.IsLittleEndianCached = exports.IsEvalSupportedCached = exports.InvalidPDFException = exports.ImageKind = exports.IDENTITY_MATRIX = exports.FormatError = exports.FontType = exports.FONT_IDENTITY_MATRIX = exports.DocumentActionEventType = exports.CMapCompressionType = exports.BaseException = exports.AnnotationType = exports.AnnotationStateModelType = exports.AnnotationReviewState = exports.AnnotationReplyType = exports.AnnotationMarkedState = exports.AnnotationFlag = exports.AnnotationFieldFlag = exports.AnnotationBorderStyleType = exports.AnnotationActionEventType = exports.AbortException = void 0;

__w_pdfjs_require__(5);

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var IDENTITY_MATRIX = [1, 0, 0, 1, 0, 0];
exports.IDENTITY_MATRIX = IDENTITY_MATRIX;
var FONT_IDENTITY_MATRIX = [0.001, 0, 0, 0.001, 0, 0];
exports.FONT_IDENTITY_MATRIX = FONT_IDENTITY_MATRIX;
var PermissionFlag = {
  PRINT: 0x04,
  MODIFY_CONTENTS: 0x08,
  COPY: 0x10,
  MODIFY_ANNOTATIONS: 0x20,
  FILL_INTERACTIVE_FORMS: 0x100,
  COPY_FOR_ACCESSIBILITY: 0x200,
  ASSEMBLE: 0x400,
  PRINT_HIGH_QUALITY: 0x800
};
exports.PermissionFlag = PermissionFlag;
var TextRenderingMode = {
  FILL: 0,
  STROKE: 1,
  FILL_STROKE: 2,
  INVISIBLE: 3,
  FILL_ADD_TO_PATH: 4,
  STROKE_ADD_TO_PATH: 5,
  FILL_STROKE_ADD_TO_PATH: 6,
  ADD_TO_PATH: 7,
  FILL_STROKE_MASK: 3,
  ADD_TO_PATH_FLAG: 4
};
exports.TextRenderingMode = TextRenderingMode;
var ImageKind = {
  GRAYSCALE_1BPP: 1,
  RGB_24BPP: 2,
  RGBA_32BPP: 3
};
exports.ImageKind = ImageKind;
var AnnotationType = {
  TEXT: 1,
  LINK: 2,
  FREETEXT: 3,
  LINE: 4,
  SQUARE: 5,
  CIRCLE: 6,
  POLYGON: 7,
  POLYLINE: 8,
  HIGHLIGHT: 9,
  UNDERLINE: 10,
  SQUIGGLY: 11,
  STRIKEOUT: 12,
  STAMP: 13,
  CARET: 14,
  INK: 15,
  POPUP: 16,
  FILEATTACHMENT: 17,
  SOUND: 18,
  MOVIE: 19,
  WIDGET: 20,
  SCREEN: 21,
  PRINTERMARK: 22,
  TRAPNET: 23,
  WATERMARK: 24,
  THREED: 25,
  REDACT: 26
};
exports.AnnotationType = AnnotationType;
var AnnotationStateModelType = {
  MARKED: "Marked",
  REVIEW: "Review"
};
exports.AnnotationStateModelType = AnnotationStateModelType;
var AnnotationMarkedState = {
  MARKED: "Marked",
  UNMARKED: "Unmarked"
};
exports.AnnotationMarkedState = AnnotationMarkedState;
var AnnotationReviewState = {
  ACCEPTED: "Accepted",
  REJECTED: "Rejected",
  CANCELLED: "Cancelled",
  COMPLETED: "Completed",
  NONE: "None"
};
exports.AnnotationReviewState = AnnotationReviewState;
var AnnotationReplyType = {
  GROUP: "Group",
  REPLY: "R"
};
exports.AnnotationReplyType = AnnotationReplyType;
var AnnotationFlag = {
  INVISIBLE: 0x01,
  HIDDEN: 0x02,
  PRINT: 0x04,
  NOZOOM: 0x08,
  NOROTATE: 0x10,
  NOVIEW: 0x20,
  READONLY: 0x40,
  LOCKED: 0x80,
  TOGGLENOVIEW: 0x100,
  LOCKEDCONTENTS: 0x200
};
exports.AnnotationFlag = AnnotationFlag;
var AnnotationFieldFlag = {
  READONLY: 0x0000001,
  REQUIRED: 0x0000002,
  NOEXPORT: 0x0000004,
  MULTILINE: 0x0001000,
  PASSWORD: 0x0002000,
  NOTOGGLETOOFF: 0x0004000,
  RADIO: 0x0008000,
  PUSHBUTTON: 0x0010000,
  COMBO: 0x0020000,
  EDIT: 0x0040000,
  SORT: 0x0080000,
  FILESELECT: 0x0100000,
  MULTISELECT: 0x0200000,
  DONOTSPELLCHECK: 0x0400000,
  DONOTSCROLL: 0x0800000,
  COMB: 0x1000000,
  RICHTEXT: 0x2000000,
  RADIOSINUNISON: 0x2000000,
  COMMITONSELCHANGE: 0x4000000
};
exports.AnnotationFieldFlag = AnnotationFieldFlag;
var AnnotationBorderStyleType = {
  SOLID: 1,
  DASHED: 2,
  BEVELED: 3,
  INSET: 4,
  UNDERLINE: 5
};
exports.AnnotationBorderStyleType = AnnotationBorderStyleType;
var AnnotationActionEventType = {
  E: "Mouse Enter",
  X: "Mouse Exit",
  D: "Mouse Down",
  U: "Mouse Up",
  Fo: "Focus",
  Bl: "Blur",
  PO: "PageOpen",
  PC: "PageClose",
  PV: "PageVisible",
  PI: "PageInvisible",
  K: "Keystroke",
  F: "Format",
  V: "Validate",
  C: "Calculate"
};
exports.AnnotationActionEventType = AnnotationActionEventType;
var DocumentActionEventType = {
  WC: "WillClose",
  WS: "WillSave",
  DS: "DidSave",
  WP: "WillPrint",
  DP: "DidPrint"
};
exports.DocumentActionEventType = DocumentActionEventType;
var PageActionEventType = {
  O: "PageOpen",
  C: "PageClose"
};
exports.PageActionEventType = PageActionEventType;
var StreamType = {
  UNKNOWN: "UNKNOWN",
  FLATE: "FLATE",
  LZW: "LZW",
  DCT: "DCT",
  JPX: "JPX",
  JBIG: "JBIG",
  A85: "A85",
  AHX: "AHX",
  CCF: "CCF",
  RLX: "RLX"
};
exports.StreamType = StreamType;
var FontType = {
  UNKNOWN: "UNKNOWN",
  TYPE1: "TYPE1",
  TYPE1C: "TYPE1C",
  CIDFONTTYPE0: "CIDFONTTYPE0",
  CIDFONTTYPE0C: "CIDFONTTYPE0C",
  TRUETYPE: "TRUETYPE",
  CIDFONTTYPE2: "CIDFONTTYPE2",
  TYPE3: "TYPE3",
  OPENTYPE: "OPENTYPE",
  TYPE0: "TYPE0",
  MMTYPE1: "MMTYPE1"
};
exports.FontType = FontType;
var VerbosityLevel = {
  ERRORS: 0,
  WARNINGS: 1,
  INFOS: 5
};
exports.VerbosityLevel = VerbosityLevel;
var CMapCompressionType = {
  NONE: 0,
  BINARY: 1,
  STREAM: 2
};
exports.CMapCompressionType = CMapCompressionType;
var OPS = {
  dependency: 1,
  setLineWidth: 2,
  setLineCap: 3,
  setLineJoin: 4,
  setMiterLimit: 5,
  setDash: 6,
  setRenderingIntent: 7,
  setFlatness: 8,
  setGState: 9,
  save: 10,
  restore: 11,
  transform: 12,
  moveTo: 13,
  lineTo: 14,
  curveTo: 15,
  curveTo2: 16,
  curveTo3: 17,
  closePath: 18,
  rectangle: 19,
  stroke: 20,
  closeStroke: 21,
  fill: 22,
  eoFill: 23,
  fillStroke: 24,
  eoFillStroke: 25,
  closeFillStroke: 26,
  closeEOFillStroke: 27,
  endPath: 28,
  clip: 29,
  eoClip: 30,
  beginText: 31,
  endText: 32,
  setCharSpacing: 33,
  setWordSpacing: 34,
  setHScale: 35,
  setLeading: 36,
  setFont: 37,
  setTextRenderingMode: 38,
  setTextRise: 39,
  moveText: 40,
  setLeadingMoveText: 41,
  setTextMatrix: 42,
  nextLine: 43,
  showText: 44,
  showSpacedText: 45,
  nextLineShowText: 46,
  nextLineSetSpacingShowText: 47,
  setCharWidth: 48,
  setCharWidthAndBounds: 49,
  setStrokeColorSpace: 50,
  setFillColorSpace: 51,
  setStrokeColor: 52,
  setStrokeColorN: 53,
  setFillColor: 54,
  setFillColorN: 55,
  setStrokeGray: 56,
  setFillGray: 57,
  setStrokeRGBColor: 58,
  setFillRGBColor: 59,
  setStrokeCMYKColor: 60,
  setFillCMYKColor: 61,
  shadingFill: 62,
  beginInlineImage: 63,
  beginImageData: 64,
  endInlineImage: 65,
  paintXObject: 66,
  markPoint: 67,
  markPointProps: 68,
  beginMarkedContent: 69,
  beginMarkedContentProps: 70,
  endMarkedContent: 71,
  beginCompat: 72,
  endCompat: 73,
  paintFormXObjectBegin: 74,
  paintFormXObjectEnd: 75,
  beginGroup: 76,
  endGroup: 77,
  beginAnnotations: 78,
  endAnnotations: 79,
  beginAnnotation: 80,
  endAnnotation: 81,
  paintJpegXObject: 82,
  paintImageMaskXObject: 83,
  paintImageMaskXObjectGroup: 84,
  paintImageXObject: 85,
  paintInlineImageXObject: 86,
  paintInlineImageXObjectGroup: 87,
  paintImageXObjectRepeat: 88,
  paintImageMaskXObjectRepeat: 89,
  paintSolidColorImageMask: 90,
  constructPath: 91
};
exports.OPS = OPS;
var UNSUPPORTED_FEATURES = {
  unknown: "unknown",
  forms: "forms",
  javaScript: "javaScript",
  signatures: "signatures",
  smask: "smask",
  shadingPattern: "shadingPattern",
  font: "font",
  errorTilingPattern: "errorTilingPattern",
  errorExtGState: "errorExtGState",
  errorXObject: "errorXObject",
  errorFontLoadType3: "errorFontLoadType3",
  errorFontState: "errorFontState",
  errorFontMissing: "errorFontMissing",
  errorFontTranslate: "errorFontTranslate",
  errorColorSpace: "errorColorSpace",
  errorOperatorList: "errorOperatorList",
  errorFontToUnicode: "errorFontToUnicode",
  errorFontLoadNative: "errorFontLoadNative",
  errorFontBuildPath: "errorFontBuildPath",
  errorFontGetPath: "errorFontGetPath",
  errorMarkedContent: "errorMarkedContent"
};
exports.UNSUPPORTED_FEATURES = UNSUPPORTED_FEATURES;
var PasswordResponses = {
  NEED_PASSWORD: 1,
  INCORRECT_PASSWORD: 2
};
exports.PasswordResponses = PasswordResponses;
var verbosity = VerbosityLevel.WARNINGS;

function setVerbosityLevel(level) {
  if (Number.isInteger(level)) {
    verbosity = level;
  }
}

function getVerbosityLevel() {
  return verbosity;
}

function info(msg) {
  if (verbosity >= VerbosityLevel.INFOS) {
    console.log("Info: ".concat(msg));
  }
}

function warn(msg) {
  if (verbosity >= VerbosityLevel.WARNINGS) {
    console.log("Warning: ".concat(msg));
  }
}

function unreachable(msg) {
  throw new Error(msg);
}

function assert(cond, msg) {
  if (!cond) {
    unreachable(msg);
  }
}

function isSameOrigin(baseUrl, otherUrl) {
  var base;

  try {
    base = new URL(baseUrl);

    if (!base.origin || base.origin === "null") {
      return false;
    }
  } catch (e) {
    return false;
  }

  var other = new URL(otherUrl, base);
  return base.origin === other.origin;
}

function _isValidProtocol(url) {
  if (!url) {
    return false;
  }

  switch (url.protocol) {
    case "http:":
    case "https:":
    case "ftp:":
    case "mailto:":
    case "tel:":
      return true;

    default:
      return false;
  }
}

function createValidAbsoluteUrl(url, baseUrl) {
  if (!url) {
    return null;
  }

  try {
    var absoluteUrl = baseUrl ? new URL(url, baseUrl) : new URL(url);

    if (_isValidProtocol(absoluteUrl)) {
      return absoluteUrl;
    }
  } catch (ex) {}

  return null;
}

function shadow(obj, prop, value) {
  Object.defineProperty(obj, prop, {
    value: value,
    enumerable: true,
    configurable: true,
    writable: false
  });
  return value;
}

var BaseException = function BaseExceptionClosure() {
  function BaseException(message) {
    if (this.constructor === BaseException) {
      unreachable("Cannot initialize BaseException.");
    }

    this.message = message;
    this.name = this.constructor.name;
  }

  BaseException.prototype = new Error();
  BaseException.constructor = BaseException;
  return BaseException;
}();

exports.BaseException = BaseException;

var PasswordException = /*#__PURE__*/function (_BaseException) {
  _inherits(PasswordException, _BaseException);

  var _super = _createSuper(PasswordException);

  function PasswordException(msg, code) {
    var _this;

    _classCallCheck(this, PasswordException);

    _this = _super.call(this, msg);
    _this.code = code;
    return _this;
  }

  return PasswordException;
}(BaseException);

exports.PasswordException = PasswordException;

var UnknownErrorException = /*#__PURE__*/function (_BaseException2) {
  _inherits(UnknownErrorException, _BaseException2);

  var _super2 = _createSuper(UnknownErrorException);

  function UnknownErrorException(msg, details) {
    var _this2;

    _classCallCheck(this, UnknownErrorException);

    _this2 = _super2.call(this, msg);
    _this2.details = details;
    return _this2;
  }

  return UnknownErrorException;
}(BaseException);

exports.UnknownErrorException = UnknownErrorException;

var InvalidPDFException = /*#__PURE__*/function (_BaseException3) {
  _inherits(InvalidPDFException, _BaseException3);

  var _super3 = _createSuper(InvalidPDFException);

  function InvalidPDFException() {
    _classCallCheck(this, InvalidPDFException);

    return _super3.apply(this, arguments);
  }

  return InvalidPDFException;
}(BaseException);

exports.InvalidPDFException = InvalidPDFException;

var MissingPDFException = /*#__PURE__*/function (_BaseException4) {
  _inherits(MissingPDFException, _BaseException4);

  var _super4 = _createSuper(MissingPDFException);

  function MissingPDFException() {
    _classCallCheck(this, MissingPDFException);

    return _super4.apply(this, arguments);
  }

  return MissingPDFException;
}(BaseException);

exports.MissingPDFException = MissingPDFException;

var UnexpectedResponseException = /*#__PURE__*/function (_BaseException5) {
  _inherits(UnexpectedResponseException, _BaseException5);

  var _super5 = _createSuper(UnexpectedResponseException);

  function UnexpectedResponseException(msg, status) {
    var _this3;

    _classCallCheck(this, UnexpectedResponseException);

    _this3 = _super5.call(this, msg);
    _this3.status = status;
    return _this3;
  }

  return UnexpectedResponseException;
}(BaseException);

exports.UnexpectedResponseException = UnexpectedResponseException;

var FormatError = /*#__PURE__*/function (_BaseException6) {
  _inherits(FormatError, _BaseException6);

  var _super6 = _createSuper(FormatError);

  function FormatError() {
    _classCallCheck(this, FormatError);

    return _super6.apply(this, arguments);
  }

  return FormatError;
}(BaseException);

exports.FormatError = FormatError;

var AbortException = /*#__PURE__*/function (_BaseException7) {
  _inherits(AbortException, _BaseException7);

  var _super7 = _createSuper(AbortException);

  function AbortException() {
    _classCallCheck(this, AbortException);

    return _super7.apply(this, arguments);
  }

  return AbortException;
}(BaseException);

exports.AbortException = AbortException;
var NullCharactersRegExp = /\x00/g;

function removeNullCharacters(str) {
  if (typeof str !== "string") {
    warn("The argument for removeNullCharacters must be a string.");
    return str;
  }

  return str.replace(NullCharactersRegExp, "");
}

function bytesToString(bytes) {
  assert(bytes !== null && _typeof(bytes) === "object" && bytes.length !== undefined, "Invalid argument for bytesToString");
  var length = bytes.length;
  var MAX_ARGUMENT_COUNT = 8192;

  if (length < MAX_ARGUMENT_COUNT) {
    return String.fromCharCode.apply(null, bytes);
  }

  var strBuf = [];

  for (var i = 0; i < length; i += MAX_ARGUMENT_COUNT) {
    var chunkEnd = Math.min(i + MAX_ARGUMENT_COUNT, length);
    var chunk = bytes.subarray(i, chunkEnd);
    strBuf.push(String.fromCharCode.apply(null, chunk));
  }

  return strBuf.join("");
}

function stringToBytes(str) {
  assert(typeof str === "string", "Invalid argument for stringToBytes");
  var length = str.length;
  var bytes = new Uint8Array(length);

  for (var i = 0; i < length; ++i) {
    bytes[i] = str.charCodeAt(i) & 0xff;
  }

  return bytes;
}

function arrayByteLength(arr) {
  if (arr.length !== undefined) {
    return arr.length;
  }

  assert(arr.byteLength !== undefined, "arrayByteLength - invalid argument.");
  return arr.byteLength;
}

function arraysToBytes(arr) {
  var length = arr.length;

  if (length === 1 && arr[0] instanceof Uint8Array) {
    return arr[0];
  }

  var resultLength = 0;

  for (var i = 0; i < length; i++) {
    resultLength += arrayByteLength(arr[i]);
  }

  var pos = 0;
  var data = new Uint8Array(resultLength);

  for (var _i = 0; _i < length; _i++) {
    var item = arr[_i];

    if (!(item instanceof Uint8Array)) {
      if (typeof item === "string") {
        item = stringToBytes(item);
      } else {
        item = new Uint8Array(item);
      }
    }

    var itemLength = item.byteLength;
    data.set(item, pos);
    pos += itemLength;
  }

  return data;
}

function string32(value) {
  return String.fromCharCode(value >> 24 & 0xff, value >> 16 & 0xff, value >> 8 & 0xff, value & 0xff);
}

function objectSize(obj) {
  return Object.keys(obj).length;
}

function objectFromMap(map) {
  var obj = Object.create(null);

  var _iterator = _createForOfIteratorHelper(map),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var _step$value = _slicedToArray(_step.value, 2),
          key = _step$value[0],
          value = _step$value[1];

      obj[key] = value;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  return obj;
}

function isLittleEndian() {
  var buffer8 = new Uint8Array(4);
  buffer8[0] = 1;
  var view32 = new Uint32Array(buffer8.buffer, 0, 1);
  return view32[0] === 1;
}

var IsLittleEndianCached = {
  get value() {
    return shadow(this, "value", isLittleEndian());
  }

};
exports.IsLittleEndianCached = IsLittleEndianCached;

function isEvalSupported() {
  try {
    new Function("");
    return true;
  } catch (e) {
    return false;
  }
}

var IsEvalSupportedCached = {
  get value() {
    return shadow(this, "value", isEvalSupported());
  }

};
exports.IsEvalSupportedCached = IsEvalSupportedCached;

var hexNumbers = _toConsumableArray(Array(256).keys()).map(function (n) {
  return n.toString(16).padStart(2, "0");
});

var Util = /*#__PURE__*/function () {
  function Util() {
    _classCallCheck(this, Util);
  }

  _createClass(Util, null, [{
    key: "makeHexColor",
    value: function makeHexColor(r, g, b) {
      return "#".concat(hexNumbers[r]).concat(hexNumbers[g]).concat(hexNumbers[b]);
    }
  }, {
    key: "transform",
    value: function transform(m1, m2) {
      return [m1[0] * m2[0] + m1[2] * m2[1], m1[1] * m2[0] + m1[3] * m2[1], m1[0] * m2[2] + m1[2] * m2[3], m1[1] * m2[2] + m1[3] * m2[3], m1[0] * m2[4] + m1[2] * m2[5] + m1[4], m1[1] * m2[4] + m1[3] * m2[5] + m1[5]];
    }
  }, {
    key: "applyTransform",
    value: function applyTransform(p, m) {
      var xt = p[0] * m[0] + p[1] * m[2] + m[4];
      var yt = p[0] * m[1] + p[1] * m[3] + m[5];
      return [xt, yt];
    }
  }, {
    key: "applyInverseTransform",
    value: function applyInverseTransform(p, m) {
      var d = m[0] * m[3] - m[1] * m[2];
      var xt = (p[0] * m[3] - p[1] * m[2] + m[2] * m[5] - m[4] * m[3]) / d;
      var yt = (-p[0] * m[1] + p[1] * m[0] + m[4] * m[1] - m[5] * m[0]) / d;
      return [xt, yt];
    }
  }, {
    key: "getAxialAlignedBoundingBox",
    value: function getAxialAlignedBoundingBox(r, m) {
      var p1 = Util.applyTransform(r, m);
      var p2 = Util.applyTransform(r.slice(2, 4), m);
      var p3 = Util.applyTransform([r[0], r[3]], m);
      var p4 = Util.applyTransform([r[2], r[1]], m);
      return [Math.min(p1[0], p2[0], p3[0], p4[0]), Math.min(p1[1], p2[1], p3[1], p4[1]), Math.max(p1[0], p2[0], p3[0], p4[0]), Math.max(p1[1], p2[1], p3[1], p4[1])];
    }
  }, {
    key: "inverseTransform",
    value: function inverseTransform(m) {
      var d = m[0] * m[3] - m[1] * m[2];
      return [m[3] / d, -m[1] / d, -m[2] / d, m[0] / d, (m[2] * m[5] - m[4] * m[3]) / d, (m[4] * m[1] - m[5] * m[0]) / d];
    }
  }, {
    key: "apply3dTransform",
    value: function apply3dTransform(m, v) {
      return [m[0] * v[0] + m[1] * v[1] + m[2] * v[2], m[3] * v[0] + m[4] * v[1] + m[5] * v[2], m[6] * v[0] + m[7] * v[1] + m[8] * v[2]];
    }
  }, {
    key: "singularValueDecompose2dScale",
    value: function singularValueDecompose2dScale(m) {
      var transpose = [m[0], m[2], m[1], m[3]];
      var a = m[0] * transpose[0] + m[1] * transpose[2];
      var b = m[0] * transpose[1] + m[1] * transpose[3];
      var c = m[2] * transpose[0] + m[3] * transpose[2];
      var d = m[2] * transpose[1] + m[3] * transpose[3];
      var first = (a + d) / 2;
      var second = Math.sqrt(Math.pow(a + d, 2) - 4 * (a * d - c * b)) / 2;
      var sx = first + second || 1;
      var sy = first - second || 1;
      return [Math.sqrt(sx), Math.sqrt(sy)];
    }
  }, {
    key: "normalizeRect",
    value: function normalizeRect(rect) {
      var r = rect.slice(0);

      if (rect[0] > rect[2]) {
        r[0] = rect[2];
        r[2] = rect[0];
      }

      if (rect[1] > rect[3]) {
        r[1] = rect[3];
        r[3] = rect[1];
      }

      return r;
    }
  }, {
    key: "intersect",
    value: function intersect(rect1, rect2) {
      function compare(a, b) {
        return a - b;
      }

      var orderedX = [rect1[0], rect1[2], rect2[0], rect2[2]].sort(compare);
      var orderedY = [rect1[1], rect1[3], rect2[1], rect2[3]].sort(compare);
      var result = [];
      rect1 = Util.normalizeRect(rect1);
      rect2 = Util.normalizeRect(rect2);

      if (orderedX[0] === rect1[0] && orderedX[1] === rect2[0] || orderedX[0] === rect2[0] && orderedX[1] === rect1[0]) {
        result[0] = orderedX[1];
        result[2] = orderedX[2];
      } else {
        return null;
      }

      if (orderedY[0] === rect1[1] && orderedY[1] === rect2[1] || orderedY[0] === rect2[1] && orderedY[1] === rect1[1]) {
        result[1] = orderedY[1];
        result[3] = orderedY[2];
      } else {
        return null;
      }

      return result;
    }
  }]);

  return Util;
}();

exports.Util = Util;
var PDFStringTranslateTable = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2d8, 0x2c7, 0x2c6, 0x2d9, 0x2dd, 0x2db, 0x2da, 0x2dc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2022, 0x2020, 0x2021, 0x2026, 0x2014, 0x2013, 0x192, 0x2044, 0x2039, 0x203a, 0x2212, 0x2030, 0x201e, 0x201c, 0x201d, 0x2018, 0x2019, 0x201a, 0x2122, 0xfb01, 0xfb02, 0x141, 0x152, 0x160, 0x178, 0x17d, 0x131, 0x142, 0x153, 0x161, 0x17e, 0, 0x20ac];

function stringToPDFString(str) {
  var length = str.length,
      strBuf = [];

  if (str[0] === "\xFE" && str[1] === "\xFF") {
    for (var i = 2; i < length; i += 2) {
      strBuf.push(String.fromCharCode(str.charCodeAt(i) << 8 | str.charCodeAt(i + 1)));
    }
  } else if (str[0] === "\xFF" && str[1] === "\xFE") {
    for (var _i2 = 2; _i2 < length; _i2 += 2) {
      strBuf.push(String.fromCharCode(str.charCodeAt(_i2 + 1) << 8 | str.charCodeAt(_i2)));
    }
  } else {
    for (var _i3 = 0; _i3 < length; ++_i3) {
      var code = PDFStringTranslateTable[str.charCodeAt(_i3)];
      strBuf.push(code ? String.fromCharCode(code) : str.charAt(_i3));
    }
  }

  return strBuf.join("");
}

function escapeString(str) {
  return str.replace(/([()\\\n\r])/g, function (match) {
    if (match === "\n") {
      return "\\n";
    } else if (match === "\r") {
      return "\\r";
    }

    return "\\".concat(match);
  });
}

function isAscii(str) {
  return /^[\x00-\x7F]*$/.test(str);
}

function stringToUTF16BEString(str) {
  var buf = ["\xFE\xFF"];

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char = str.charCodeAt(i);

    buf.push(String.fromCharCode(_char >> 8 & 0xff), String.fromCharCode(_char & 0xff));
  }

  return buf.join("");
}

function stringToUTF8String(str) {
  return decodeURIComponent(escape(str));
}

function utf8StringToString(str) {
  return unescape(encodeURIComponent(str));
}

function isBool(v) {
  return typeof v === "boolean";
}

function isNum(v) {
  return typeof v === "number";
}

function isString(v) {
  return typeof v === "string";
}

function isArrayBuffer(v) {
  return _typeof(v) === "object" && v !== null && v.byteLength !== undefined;
}

function isArrayEqual(arr1, arr2) {
  if (arr1.length !== arr2.length) {
    return false;
  }

  for (var i = 0, ii = arr1.length; i < ii; i++) {
    if (arr1[i] !== arr2[i]) {
      return false;
    }
  }

  return true;
}

function getModificationDate() {
  var date = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Date();
  var buffer = [date.getUTCFullYear().toString(), (date.getUTCMonth() + 1).toString().padStart(2, "0"), date.getUTCDate().toString().padStart(2, "0"), date.getUTCHours().toString().padStart(2, "0"), date.getUTCMinutes().toString().padStart(2, "0"), date.getUTCSeconds().toString().padStart(2, "0")];
  return buffer.join("");
}

function createPromiseCapability() {
  var capability = Object.create(null);
  var isSettled = false;
  Object.defineProperty(capability, "settled", {
    get: function get() {
      return isSettled;
    }
  });
  capability.promise = new Promise(function (resolve, reject) {
    capability.resolve = function (data) {
      isSettled = true;
      resolve(data);
    };

    capability.reject = function (reason) {
      isSettled = true;
      reject(reason);
    };
  });
  return capability;
}

function createObjectURL(data) {
  var contentType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "";
  var forceDataSchema = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

  if (URL.createObjectURL && !forceDataSchema) {
    return URL.createObjectURL(new Blob([data], {
      type: contentType
    }));
  }

  var digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
  var buffer = "data:".concat(contentType, ";base64,");

  for (var i = 0, ii = data.length; i < ii; i += 3) {
    var b1 = data[i] & 0xff;
    var b2 = data[i + 1] & 0xff;
    var b3 = data[i + 2] & 0xff;
    var d1 = b1 >> 2,
        d2 = (b1 & 3) << 4 | b2 >> 4;
    var d3 = i + 1 < ii ? (b2 & 0xf) << 2 | b3 >> 6 : 64;
    var d4 = i + 2 < ii ? b3 & 0x3f : 64;
    buffer += digits[d1] + digits[d2] + digits[d3] + digits[d4];
  }

  return buffer;
}

/***/ }),
/* 5 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";


var _is_node = __w_pdfjs_require__(6);

if (typeof globalThis === "undefined" || !globalThis._pdfjsCompatibilityChecked) {
  if (typeof globalThis === "undefined" || globalThis.Math !== Math) {
    globalThis = __w_pdfjs_require__(7);
  }

  globalThis._pdfjsCompatibilityChecked = true;

  (function checkNodeBtoa() {
    if (globalThis.btoa || !_is_node.isNodeJS) {
      return;
    }

    globalThis.btoa = function (chars) {
      return Buffer.from(chars, "binary").toString("base64");
    };
  })();

  (function checkNodeAtob() {
    if (globalThis.atob || !_is_node.isNodeJS) {
      return;
    }

    globalThis.atob = function (input) {
      return Buffer.from(input, "base64").toString("binary");
    };
  })();

  (function checkObjectFromEntries() {
    if (Object.fromEntries) {
      return;
    }

    __w_pdfjs_require__(53);
  })();

  (function checkPromise() {
    if (globalThis.Promise.allSettled) {
      return;
    }

    globalThis.Promise = __w_pdfjs_require__(84);
  })();

  (function checkReadableStream() {
    var isReadableStreamSupported = false;

    if (typeof ReadableStream !== "undefined") {
      try {
        new ReadableStream({
          start: function start(controller) {
            controller.close();
          }
        });
        isReadableStreamSupported = true;
      } catch (e) {}
    }

    if (isReadableStreamSupported) {
      return;
    }

    globalThis.ReadableStream = __w_pdfjs_require__(112).ReadableStream;
  })();
}

/***/ }),
/* 6 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.isNodeJS = void 0;

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var isNodeJS = (typeof process === "undefined" ? "undefined" : _typeof(process)) === "object" && process + "" === "[object process]" && !process.versions.nw && !(process.versions.electron && process.type && process.type !== "browser");
exports.isNodeJS = isNodeJS;

/***/ }),
/* 7 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(8);
module.exports = __w_pdfjs_require__(10);

/***/ }),
/* 8 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var $ = __w_pdfjs_require__(9);
var global = __w_pdfjs_require__(10);
$({ global: true }, { globalThis: global });

/***/ }),
/* 9 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var getOwnPropertyDescriptor = __w_pdfjs_require__(11).f;
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var redefine = __w_pdfjs_require__(29);
var setGlobal = __w_pdfjs_require__(30);
var copyConstructorProperties = __w_pdfjs_require__(40);
var isForced = __w_pdfjs_require__(52);
module.exports = function (options, source) {
 var TARGET = options.target;
 var GLOBAL = options.global;
 var STATIC = options.stat;
 var FORCED, target, key, targetProperty, sourceProperty, descriptor;
 if (GLOBAL) {
  target = global;
 } else if (STATIC) {
  target = global[TARGET] || setGlobal(TARGET, {});
 } else {
  target = (global[TARGET] || {}).prototype;
 }
 if (target)
  for (key in source) {
   sourceProperty = source[key];
   if (options.noTargetGet) {
    descriptor = getOwnPropertyDescriptor(target, key);
    targetProperty = descriptor && descriptor.value;
   } else
    targetProperty = target[key];
   FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
   if (!FORCED && targetProperty !== undefined) {
    if (typeof sourceProperty === typeof targetProperty)
     continue;
    copyConstructorProperties(sourceProperty, targetProperty);
   }
   if (options.sham || targetProperty && targetProperty.sham) {
    createNonEnumerableProperty(sourceProperty, 'sham', true);
   }
   redefine(target, key, sourceProperty, options);
  }
};

/***/ }),
/* 10 */
/***/ ((module) => {

var check = function (it) {
 return it && it.Math == Math && it;
};
module.exports = check(typeof globalThis == 'object' && globalThis) || check(typeof window == 'object' && window) || check(typeof self == 'object' && self) || check(typeof global == 'object' && global) || function () {
 return this;
}() || Function('return this')();

/***/ }),
/* 11 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(12);
var propertyIsEnumerableModule = __w_pdfjs_require__(14);
var createPropertyDescriptor = __w_pdfjs_require__(15);
var toIndexedObject = __w_pdfjs_require__(16);
var toPrimitive = __w_pdfjs_require__(20);
var has = __w_pdfjs_require__(22);
var IE8_DOM_DEFINE = __w_pdfjs_require__(24);
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
 O = toIndexedObject(O);
 P = toPrimitive(P, true);
 if (IE8_DOM_DEFINE)
  try {
   return $getOwnPropertyDescriptor(O, P);
  } catch (error) {
  }
 if (has(O, P))
  return createPropertyDescriptor(!propertyIsEnumerableModule.f.call(O, P), O[P]);
};

/***/ }),
/* 12 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(13);
module.exports = !fails(function () {
 return Object.defineProperty({}, 1, {
  get: function () {
   return 7;
  }
 })[1] != 7;
});

/***/ }),
/* 13 */
/***/ ((module) => {

module.exports = function (exec) {
 try {
  return !!exec();
 } catch (error) {
  return true;
 }
};

/***/ }),
/* 14 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
 var descriptor = getOwnPropertyDescriptor(this, V);
 return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;

/***/ }),
/* 15 */
/***/ ((module) => {

module.exports = function (bitmap, value) {
 return {
  enumerable: !(bitmap & 1),
  configurable: !(bitmap & 2),
  writable: !(bitmap & 4),
  value: value
 };
};

/***/ }),
/* 16 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var IndexedObject = __w_pdfjs_require__(17);
var requireObjectCoercible = __w_pdfjs_require__(19);
module.exports = function (it) {
 return IndexedObject(requireObjectCoercible(it));
};

/***/ }),
/* 17 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(13);
var classof = __w_pdfjs_require__(18);
var split = ''.split;
module.exports = fails(function () {
 return !Object('z').propertyIsEnumerable(0);
}) ? function (it) {
 return classof(it) == 'String' ? split.call(it, '') : Object(it);
} : Object;

/***/ }),
/* 18 */
/***/ ((module) => {

var toString = {}.toString;
module.exports = function (it) {
 return toString.call(it).slice(8, -1);
};

/***/ }),
/* 19 */
/***/ ((module) => {

module.exports = function (it) {
 if (it == undefined)
  throw TypeError("Can't call method on " + it);
 return it;
};

/***/ }),
/* 20 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isObject = __w_pdfjs_require__(21);
module.exports = function (input, PREFERRED_STRING) {
 if (!isObject(input))
  return input;
 var fn, val;
 if (PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input)))
  return val;
 if (typeof (fn = input.valueOf) == 'function' && !isObject(val = fn.call(input)))
  return val;
 if (!PREFERRED_STRING && typeof (fn = input.toString) == 'function' && !isObject(val = fn.call(input)))
  return val;
 throw TypeError("Can't convert object to primitive value");
};

/***/ }),
/* 21 */
/***/ ((module) => {

module.exports = function (it) {
 return typeof it === 'object' ? it !== null : typeof it === 'function';
};

/***/ }),
/* 22 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toObject = __w_pdfjs_require__(23);
var hasOwnProperty = {}.hasOwnProperty;
module.exports = Object.hasOwn || function hasOwn(it, key) {
 return hasOwnProperty.call(toObject(it), key);
};

/***/ }),
/* 23 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var requireObjectCoercible = __w_pdfjs_require__(19);
module.exports = function (argument) {
 return Object(requireObjectCoercible(argument));
};

/***/ }),
/* 24 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(12);
var fails = __w_pdfjs_require__(13);
var createElement = __w_pdfjs_require__(25);
module.exports = !DESCRIPTORS && !fails(function () {
 return Object.defineProperty(createElement('div'), 'a', {
  get: function () {
   return 7;
  }
 }).a != 7;
});

/***/ }),
/* 25 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var isObject = __w_pdfjs_require__(21);
var document = global.document;
var EXISTS = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
 return EXISTS ? document.createElement(it) : {};
};

/***/ }),
/* 26 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(12);
var definePropertyModule = __w_pdfjs_require__(27);
var createPropertyDescriptor = __w_pdfjs_require__(15);
module.exports = DESCRIPTORS ? function (object, key, value) {
 return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
 object[key] = value;
 return object;
};

/***/ }),
/* 27 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(12);
var IE8_DOM_DEFINE = __w_pdfjs_require__(24);
var anObject = __w_pdfjs_require__(28);
var toPrimitive = __w_pdfjs_require__(20);
var $defineProperty = Object.defineProperty;
exports.f = DESCRIPTORS ? $defineProperty : function defineProperty(O, P, Attributes) {
 anObject(O);
 P = toPrimitive(P, true);
 anObject(Attributes);
 if (IE8_DOM_DEFINE)
  try {
   return $defineProperty(O, P, Attributes);
  } catch (error) {
  }
 if ('get' in Attributes || 'set' in Attributes)
  throw TypeError('Accessors not supported');
 if ('value' in Attributes)
  O[P] = Attributes.value;
 return O;
};

/***/ }),
/* 28 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isObject = __w_pdfjs_require__(21);
module.exports = function (it) {
 if (!isObject(it)) {
  throw TypeError(String(it) + ' is not an object');
 }
 return it;
};

/***/ }),
/* 29 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var has = __w_pdfjs_require__(22);
var setGlobal = __w_pdfjs_require__(30);
var inspectSource = __w_pdfjs_require__(31);
var InternalStateModule = __w_pdfjs_require__(33);
var getInternalState = InternalStateModule.get;
var enforceInternalState = InternalStateModule.enforce;
var TEMPLATE = String(String).split('String');
(module.exports = function (O, key, value, options) {
 var unsafe = options ? !!options.unsafe : false;
 var simple = options ? !!options.enumerable : false;
 var noTargetGet = options ? !!options.noTargetGet : false;
 var state;
 if (typeof value == 'function') {
  if (typeof key == 'string' && !has(value, 'name')) {
   createNonEnumerableProperty(value, 'name', key);
  }
  state = enforceInternalState(value);
  if (!state.source) {
   state.source = TEMPLATE.join(typeof key == 'string' ? key : '');
  }
 }
 if (O === global) {
  if (simple)
   O[key] = value;
  else
   setGlobal(key, value);
  return;
 } else if (!unsafe) {
  delete O[key];
 } else if (!noTargetGet && O[key]) {
  simple = true;
 }
 if (simple)
  O[key] = value;
 else
  createNonEnumerableProperty(O, key, value);
})(Function.prototype, 'toString', function toString() {
 return typeof this == 'function' && getInternalState(this).source || inspectSource(this);
});

/***/ }),
/* 30 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
module.exports = function (key, value) {
 try {
  createNonEnumerableProperty(global, key, value);
 } catch (error) {
  global[key] = value;
 }
 return value;
};

/***/ }),
/* 31 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var store = __w_pdfjs_require__(32);
var functionToString = Function.toString;
if (typeof store.inspectSource != 'function') {
 store.inspectSource = function (it) {
  return functionToString.call(it);
 };
}
module.exports = store.inspectSource;

/***/ }),
/* 32 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var setGlobal = __w_pdfjs_require__(30);
var SHARED = '__core-js_shared__';
var store = global[SHARED] || setGlobal(SHARED, {});
module.exports = store;

/***/ }),
/* 33 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_WEAK_MAP = __w_pdfjs_require__(34);
var global = __w_pdfjs_require__(10);
var isObject = __w_pdfjs_require__(21);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var objectHas = __w_pdfjs_require__(22);
var shared = __w_pdfjs_require__(32);
var sharedKey = __w_pdfjs_require__(35);
var hiddenKeys = __w_pdfjs_require__(39);
var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var WeakMap = global.WeakMap;
var set, get, has;
var enforce = function (it) {
 return has(it) ? get(it) : set(it, {});
};
var getterFor = function (TYPE) {
 return function (it) {
  var state;
  if (!isObject(it) || (state = get(it)).type !== TYPE) {
   throw TypeError('Incompatible receiver, ' + TYPE + ' required');
  }
  return state;
 };
};
if (NATIVE_WEAK_MAP || shared.state) {
 var store = shared.state || (shared.state = new WeakMap());
 var wmget = store.get;
 var wmhas = store.has;
 var wmset = store.set;
 set = function (it, metadata) {
  if (wmhas.call(store, it))
   throw new TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  wmset.call(store, it, metadata);
  return metadata;
 };
 get = function (it) {
  return wmget.call(store, it) || {};
 };
 has = function (it) {
  return wmhas.call(store, it);
 };
} else {
 var STATE = sharedKey('state');
 hiddenKeys[STATE] = true;
 set = function (it, metadata) {
  if (objectHas(it, STATE))
   throw new TypeError(OBJECT_ALREADY_INITIALIZED);
  metadata.facade = it;
  createNonEnumerableProperty(it, STATE, metadata);
  return metadata;
 };
 get = function (it) {
  return objectHas(it, STATE) ? it[STATE] : {};
 };
 has = function (it) {
  return objectHas(it, STATE);
 };
}
module.exports = {
 set: set,
 get: get,
 has: has,
 enforce: enforce,
 getterFor: getterFor
};

/***/ }),
/* 34 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var inspectSource = __w_pdfjs_require__(31);
var WeakMap = global.WeakMap;
module.exports = typeof WeakMap === 'function' && /native code/.test(inspectSource(WeakMap));

/***/ }),
/* 35 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var shared = __w_pdfjs_require__(36);
var uid = __w_pdfjs_require__(38);
var keys = shared('keys');
module.exports = function (key) {
 return keys[key] || (keys[key] = uid(key));
};

/***/ }),
/* 36 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var IS_PURE = __w_pdfjs_require__(37);
var store = __w_pdfjs_require__(32);
(module.exports = function (key, value) {
 return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
 version: '3.13.1',
 mode: IS_PURE ? 'pure' : 'global',
 copyright: '© 2021 Denis Pushkarev (zloirock.ru)'
});

/***/ }),
/* 37 */
/***/ ((module) => {

module.exports = false;

/***/ }),
/* 38 */
/***/ ((module) => {

var id = 0;
var postfix = Math.random();
module.exports = function (key) {
 return 'Symbol(' + String(key === undefined ? '' : key) + ')_' + (++id + postfix).toString(36);
};

/***/ }),
/* 39 */
/***/ ((module) => {

module.exports = {};

/***/ }),
/* 40 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var has = __w_pdfjs_require__(22);
var ownKeys = __w_pdfjs_require__(41);
var getOwnPropertyDescriptorModule = __w_pdfjs_require__(11);
var definePropertyModule = __w_pdfjs_require__(27);
module.exports = function (target, source) {
 var keys = ownKeys(source);
 var defineProperty = definePropertyModule.f;
 var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
 for (var i = 0; i < keys.length; i++) {
  var key = keys[i];
  if (!has(target, key))
   defineProperty(target, key, getOwnPropertyDescriptor(source, key));
 }
};

/***/ }),
/* 41 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(42);
var getOwnPropertyNamesModule = __w_pdfjs_require__(44);
var getOwnPropertySymbolsModule = __w_pdfjs_require__(51);
var anObject = __w_pdfjs_require__(28);
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
 var keys = getOwnPropertyNamesModule.f(anObject(it));
 var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
 return getOwnPropertySymbols ? keys.concat(getOwnPropertySymbols(it)) : keys;
};

/***/ }),
/* 42 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var path = __w_pdfjs_require__(43);
var global = __w_pdfjs_require__(10);
var aFunction = function (variable) {
 return typeof variable == 'function' ? variable : undefined;
};
module.exports = function (namespace, method) {
 return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace]) : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
};

/***/ }),
/* 43 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
module.exports = global;

/***/ }),
/* 44 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

var internalObjectKeys = __w_pdfjs_require__(45);
var enumBugKeys = __w_pdfjs_require__(50);
var hiddenKeys = enumBugKeys.concat('length', 'prototype');
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
 return internalObjectKeys(O, hiddenKeys);
};

/***/ }),
/* 45 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var has = __w_pdfjs_require__(22);
var toIndexedObject = __w_pdfjs_require__(16);
var indexOf = __w_pdfjs_require__(46).indexOf;
var hiddenKeys = __w_pdfjs_require__(39);
module.exports = function (object, names) {
 var O = toIndexedObject(object);
 var i = 0;
 var result = [];
 var key;
 for (key in O)
  !has(hiddenKeys, key) && has(O, key) && result.push(key);
 while (names.length > i)
  if (has(O, key = names[i++])) {
   ~indexOf(result, key) || result.push(key);
  }
 return result;
};

/***/ }),
/* 46 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toIndexedObject = __w_pdfjs_require__(16);
var toLength = __w_pdfjs_require__(47);
var toAbsoluteIndex = __w_pdfjs_require__(49);
var createMethod = function (IS_INCLUDES) {
 return function ($this, el, fromIndex) {
  var O = toIndexedObject($this);
  var length = toLength(O.length);
  var index = toAbsoluteIndex(fromIndex, length);
  var value;
  if (IS_INCLUDES && el != el)
   while (length > index) {
    value = O[index++];
    if (value != value)
     return true;
   }
  else
   for (; length > index; index++) {
    if ((IS_INCLUDES || index in O) && O[index] === el)
     return IS_INCLUDES || index || 0;
   }
  return !IS_INCLUDES && -1;
 };
};
module.exports = {
 includes: createMethod(true),
 indexOf: createMethod(false)
};

/***/ }),
/* 47 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toInteger = __w_pdfjs_require__(48);
var min = Math.min;
module.exports = function (argument) {
 return argument > 0 ? min(toInteger(argument), 0x1FFFFFFFFFFFFF) : 0;
};

/***/ }),
/* 48 */
/***/ ((module) => {

var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (argument) {
 return isNaN(argument = +argument) ? 0 : (argument > 0 ? floor : ceil)(argument);
};

/***/ }),
/* 49 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toInteger = __w_pdfjs_require__(48);
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
 var integer = toInteger(index);
 return integer < 0 ? max(integer + length, 0) : min(integer, length);
};

/***/ }),
/* 50 */
/***/ ((module) => {

module.exports = [
 'constructor',
 'hasOwnProperty',
 'isPrototypeOf',
 'propertyIsEnumerable',
 'toLocaleString',
 'toString',
 'valueOf'
];

/***/ }),
/* 51 */
/***/ ((__unused_webpack_module, exports) => {

exports.f = Object.getOwnPropertySymbols;

/***/ }),
/* 52 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(13);
var replacement = /#|\.prototype\./;
var isForced = function (feature, detection) {
 var value = data[normalize(feature)];
 return value == POLYFILL ? true : value == NATIVE ? false : typeof detection == 'function' ? fails(detection) : !!detection;
};
var normalize = isForced.normalize = function (string) {
 return String(string).replace(replacement, '.').toLowerCase();
};
var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';
module.exports = isForced;

/***/ }),
/* 53 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(54);
__w_pdfjs_require__(74);
var path = __w_pdfjs_require__(43);
module.exports = path.Object.fromEntries;

/***/ }),
/* 54 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var toIndexedObject = __w_pdfjs_require__(16);
var addToUnscopables = __w_pdfjs_require__(55);
var Iterators = __w_pdfjs_require__(65);
var InternalStateModule = __w_pdfjs_require__(33);
var defineIterator = __w_pdfjs_require__(66);
var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
 setInternalState(this, {
  type: ARRAY_ITERATOR,
  target: toIndexedObject(iterated),
  index: 0,
  kind: kind
 });
}, function () {
 var state = getInternalState(this);
 var target = state.target;
 var kind = state.kind;
 var index = state.index++;
 if (!target || index >= target.length) {
  state.target = undefined;
  return {
   value: undefined,
   done: true
  };
 }
 if (kind == 'keys')
  return {
   value: index,
   done: false
  };
 if (kind == 'values')
  return {
   value: target[index],
   done: false
  };
 return {
  value: [
   index,
   target[index]
  ],
  done: false
 };
}, 'values');
Iterators.Arguments = Iterators.Array;
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');

/***/ }),
/* 55 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(56);
var create = __w_pdfjs_require__(61);
var definePropertyModule = __w_pdfjs_require__(27);
var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;
if (ArrayPrototype[UNSCOPABLES] == undefined) {
 definePropertyModule.f(ArrayPrototype, UNSCOPABLES, {
  configurable: true,
  value: create(null)
 });
}
module.exports = function (key) {
 ArrayPrototype[UNSCOPABLES][key] = true;
};

/***/ }),
/* 56 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var shared = __w_pdfjs_require__(36);
var has = __w_pdfjs_require__(22);
var uid = __w_pdfjs_require__(38);
var NATIVE_SYMBOL = __w_pdfjs_require__(57);
var USE_SYMBOL_AS_UID = __w_pdfjs_require__(60);
var WellKnownSymbolsStore = shared('wks');
var Symbol = global.Symbol;
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol : Symbol && Symbol.withoutSetter || uid;
module.exports = function (name) {
 if (!has(WellKnownSymbolsStore, name) || !(NATIVE_SYMBOL || typeof WellKnownSymbolsStore[name] == 'string')) {
  if (NATIVE_SYMBOL && has(Symbol, name)) {
   WellKnownSymbolsStore[name] = Symbol[name];
  } else {
   WellKnownSymbolsStore[name] = createWellKnownSymbol('Symbol.' + name);
  }
 }
 return WellKnownSymbolsStore[name];
};

/***/ }),
/* 57 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var V8_VERSION = __w_pdfjs_require__(58);
var fails = __w_pdfjs_require__(13);
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
 var symbol = Symbol();
 return !String(symbol) || !(Object(symbol) instanceof Symbol) || !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});

/***/ }),
/* 58 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var userAgent = __w_pdfjs_require__(59);
var process = global.process;
var versions = process && process.versions;
var v8 = versions && versions.v8;
var match, version;
if (v8) {
 match = v8.split('.');
 version = match[0] < 4 ? 1 : match[0] + match[1];
} else if (userAgent) {
 match = userAgent.match(/Edge\/(\d+)/);
 if (!match || match[1] >= 74) {
  match = userAgent.match(/Chrome\/(\d+)/);
  if (match)
   version = match[1];
 }
}
module.exports = version && +version;

/***/ }),
/* 59 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(42);
module.exports = getBuiltIn('navigator', 'userAgent') || '';

/***/ }),
/* 60 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var NATIVE_SYMBOL = __w_pdfjs_require__(57);
module.exports = NATIVE_SYMBOL && !Symbol.sham && typeof Symbol.iterator == 'symbol';

/***/ }),
/* 61 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
var defineProperties = __w_pdfjs_require__(62);
var enumBugKeys = __w_pdfjs_require__(50);
var hiddenKeys = __w_pdfjs_require__(39);
var html = __w_pdfjs_require__(64);
var documentCreateElement = __w_pdfjs_require__(25);
var sharedKey = __w_pdfjs_require__(35);
var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');
var EmptyConstructor = function () {
};
var scriptTag = function (content) {
 return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};
var NullProtoObjectViaActiveX = function (activeXDocument) {
 activeXDocument.write(scriptTag(''));
 activeXDocument.close();
 var temp = activeXDocument.parentWindow.Object;
 activeXDocument = null;
 return temp;
};
var NullProtoObjectViaIFrame = function () {
 var iframe = documentCreateElement('iframe');
 var JS = 'java' + SCRIPT + ':';
 var iframeDocument;
 iframe.style.display = 'none';
 html.appendChild(iframe);
 iframe.src = String(JS);
 iframeDocument = iframe.contentWindow.document;
 iframeDocument.open();
 iframeDocument.write(scriptTag('document.F=Object'));
 iframeDocument.close();
 return iframeDocument.F;
};
var activeXDocument;
var NullProtoObject = function () {
 try {
  activeXDocument = document.domain && new ActiveXObject('htmlfile');
 } catch (error) {
 }
 NullProtoObject = activeXDocument ? NullProtoObjectViaActiveX(activeXDocument) : NullProtoObjectViaIFrame();
 var length = enumBugKeys.length;
 while (length--)
  delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
 return NullProtoObject();
};
hiddenKeys[IE_PROTO] = true;
module.exports = Object.create || function create(O, Properties) {
 var result;
 if (O !== null) {
  EmptyConstructor[PROTOTYPE] = anObject(O);
  result = new EmptyConstructor();
  EmptyConstructor[PROTOTYPE] = null;
  result[IE_PROTO] = O;
 } else
  result = NullProtoObject();
 return Properties === undefined ? result : defineProperties(result, Properties);
};

/***/ }),
/* 62 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var DESCRIPTORS = __w_pdfjs_require__(12);
var definePropertyModule = __w_pdfjs_require__(27);
var anObject = __w_pdfjs_require__(28);
var objectKeys = __w_pdfjs_require__(63);
module.exports = DESCRIPTORS ? Object.defineProperties : function defineProperties(O, Properties) {
 anObject(O);
 var keys = objectKeys(Properties);
 var length = keys.length;
 var index = 0;
 var key;
 while (length > index)
  definePropertyModule.f(O, key = keys[index++], Properties[key]);
 return O;
};

/***/ }),
/* 63 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var internalObjectKeys = __w_pdfjs_require__(45);
var enumBugKeys = __w_pdfjs_require__(50);
module.exports = Object.keys || function keys(O) {
 return internalObjectKeys(O, enumBugKeys);
};

/***/ }),
/* 64 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var getBuiltIn = __w_pdfjs_require__(42);
module.exports = getBuiltIn('document', 'documentElement');

/***/ }),
/* 65 */
/***/ ((module) => {

module.exports = {};

/***/ }),
/* 66 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var createIteratorConstructor = __w_pdfjs_require__(67);
var getPrototypeOf = __w_pdfjs_require__(69);
var setPrototypeOf = __w_pdfjs_require__(72);
var setToStringTag = __w_pdfjs_require__(71);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var redefine = __w_pdfjs_require__(29);
var wellKnownSymbol = __w_pdfjs_require__(56);
var IS_PURE = __w_pdfjs_require__(37);
var Iterators = __w_pdfjs_require__(65);
var IteratorsCore = __w_pdfjs_require__(68);
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';
var returnThis = function () {
 return this;
};
module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
 createIteratorConstructor(IteratorConstructor, NAME, next);
 var getIterationMethod = function (KIND) {
  if (KIND === DEFAULT && defaultIterator)
   return defaultIterator;
  if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype)
   return IterablePrototype[KIND];
  switch (KIND) {
  case KEYS:
   return function keys() {
    return new IteratorConstructor(this, KIND);
   };
  case VALUES:
   return function values() {
    return new IteratorConstructor(this, KIND);
   };
  case ENTRIES:
   return function entries() {
    return new IteratorConstructor(this, KIND);
   };
  }
  return function () {
   return new IteratorConstructor(this);
  };
 };
 var TO_STRING_TAG = NAME + ' Iterator';
 var INCORRECT_VALUES_NAME = false;
 var IterablePrototype = Iterable.prototype;
 var nativeIterator = IterablePrototype[ITERATOR] || IterablePrototype['@@iterator'] || DEFAULT && IterablePrototype[DEFAULT];
 var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
 var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
 var CurrentIteratorPrototype, methods, KEY;
 if (anyNativeIterator) {
  CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
  if (IteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
   if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
    if (setPrototypeOf) {
     setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
    } else if (typeof CurrentIteratorPrototype[ITERATOR] != 'function') {
     createNonEnumerableProperty(CurrentIteratorPrototype, ITERATOR, returnThis);
    }
   }
   setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
   if (IS_PURE)
    Iterators[TO_STRING_TAG] = returnThis;
  }
 }
 if (DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
  INCORRECT_VALUES_NAME = true;
  defaultIterator = function values() {
   return nativeIterator.call(this);
  };
 }
 if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
  createNonEnumerableProperty(IterablePrototype, ITERATOR, defaultIterator);
 }
 Iterators[NAME] = defaultIterator;
 if (DEFAULT) {
  methods = {
   values: getIterationMethod(VALUES),
   keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
   entries: getIterationMethod(ENTRIES)
  };
  if (FORCED)
   for (KEY in methods) {
    if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
     redefine(IterablePrototype, KEY, methods[KEY]);
    }
   }
  else
   $({
    target: NAME,
    proto: true,
    forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME
   }, methods);
 }
 return methods;
};

/***/ }),
/* 67 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var IteratorPrototype = __w_pdfjs_require__(68).IteratorPrototype;
var create = __w_pdfjs_require__(61);
var createPropertyDescriptor = __w_pdfjs_require__(15);
var setToStringTag = __w_pdfjs_require__(71);
var Iterators = __w_pdfjs_require__(65);
var returnThis = function () {
 return this;
};
module.exports = function (IteratorConstructor, NAME, next) {
 var TO_STRING_TAG = NAME + ' Iterator';
 IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(1, next) });
 setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
 Iterators[TO_STRING_TAG] = returnThis;
 return IteratorConstructor;
};

/***/ }),
/* 68 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var fails = __w_pdfjs_require__(13);
var getPrototypeOf = __w_pdfjs_require__(69);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var has = __w_pdfjs_require__(22);
var wellKnownSymbol = __w_pdfjs_require__(56);
var IS_PURE = __w_pdfjs_require__(37);
var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;
var returnThis = function () {
 return this;
};
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;
if ([].keys) {
 arrayIterator = [].keys();
 if (!('next' in arrayIterator))
  BUGGY_SAFARI_ITERATORS = true;
 else {
  PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
  if (PrototypeOfArrayIteratorPrototype !== Object.prototype)
   IteratorPrototype = PrototypeOfArrayIteratorPrototype;
 }
}
var NEW_ITERATOR_PROTOTYPE = IteratorPrototype == undefined || fails(function () {
 var test = {};
 return IteratorPrototype[ITERATOR].call(test) !== test;
});
if (NEW_ITERATOR_PROTOTYPE)
 IteratorPrototype = {};
if ((!IS_PURE || NEW_ITERATOR_PROTOTYPE) && !has(IteratorPrototype, ITERATOR)) {
 createNonEnumerableProperty(IteratorPrototype, ITERATOR, returnThis);
}
module.exports = {
 IteratorPrototype: IteratorPrototype,
 BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};

/***/ }),
/* 69 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var has = __w_pdfjs_require__(22);
var toObject = __w_pdfjs_require__(23);
var sharedKey = __w_pdfjs_require__(35);
var CORRECT_PROTOTYPE_GETTER = __w_pdfjs_require__(70);
var IE_PROTO = sharedKey('IE_PROTO');
var ObjectPrototype = Object.prototype;
module.exports = CORRECT_PROTOTYPE_GETTER ? Object.getPrototypeOf : function (O) {
 O = toObject(O);
 if (has(O, IE_PROTO))
  return O[IE_PROTO];
 if (typeof O.constructor == 'function' && O instanceof O.constructor) {
  return O.constructor.prototype;
 }
 return O instanceof Object ? ObjectPrototype : null;
};

/***/ }),
/* 70 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var fails = __w_pdfjs_require__(13);
module.exports = !fails(function () {
 function F() {
 }
 F.prototype.constructor = null;
 return Object.getPrototypeOf(new F()) !== F.prototype;
});

/***/ }),
/* 71 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var defineProperty = __w_pdfjs_require__(27).f;
var has = __w_pdfjs_require__(22);
var wellKnownSymbol = __w_pdfjs_require__(56);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
module.exports = function (it, TAG, STATIC) {
 if (it && !has(it = STATIC ? it : it.prototype, TO_STRING_TAG)) {
  defineProperty(it, TO_STRING_TAG, {
   configurable: true,
   value: TAG
  });
 }
};

/***/ }),
/* 72 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
var aPossiblePrototype = __w_pdfjs_require__(73);
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function () {
 var CORRECT_SETTER = false;
 var test = {};
 var setter;
 try {
  setter = Object.getOwnPropertyDescriptor(Object.prototype, '__proto__').set;
  setter.call(test, []);
  CORRECT_SETTER = test instanceof Array;
 } catch (error) {
 }
 return function setPrototypeOf(O, proto) {
  anObject(O);
  aPossiblePrototype(proto);
  if (CORRECT_SETTER)
   setter.call(O, proto);
  else
   O.__proto__ = proto;
  return O;
 };
}() : undefined);

/***/ }),
/* 73 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var isObject = __w_pdfjs_require__(21);
module.exports = function (it) {
 if (!isObject(it) && it !== null) {
  throw TypeError("Can't set " + String(it) + ' as a prototype');
 }
 return it;
};

/***/ }),
/* 74 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var $ = __w_pdfjs_require__(9);
var iterate = __w_pdfjs_require__(75);
var createProperty = __w_pdfjs_require__(83);
$({
 target: 'Object',
 stat: true
}, {
 fromEntries: function fromEntries(iterable) {
  var obj = {};
  iterate(iterable, function (k, v) {
   createProperty(obj, k, v);
  }, { AS_ENTRIES: true });
  return obj;
 }
});

/***/ }),
/* 75 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
var isArrayIteratorMethod = __w_pdfjs_require__(76);
var toLength = __w_pdfjs_require__(47);
var bind = __w_pdfjs_require__(77);
var getIteratorMethod = __w_pdfjs_require__(79);
var iteratorClose = __w_pdfjs_require__(82);
var Result = function (stopped, result) {
 this.stopped = stopped;
 this.result = result;
};
module.exports = function (iterable, unboundFunction, options) {
 var that = options && options.that;
 var AS_ENTRIES = !!(options && options.AS_ENTRIES);
 var IS_ITERATOR = !!(options && options.IS_ITERATOR);
 var INTERRUPTED = !!(options && options.INTERRUPTED);
 var fn = bind(unboundFunction, that, 1 + AS_ENTRIES + INTERRUPTED);
 var iterator, iterFn, index, length, result, next, step;
 var stop = function (condition) {
  if (iterator)
   iteratorClose(iterator);
  return new Result(true, condition);
 };
 var callFn = function (value) {
  if (AS_ENTRIES) {
   anObject(value);
   return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
  }
  return INTERRUPTED ? fn(value, stop) : fn(value);
 };
 if (IS_ITERATOR) {
  iterator = iterable;
 } else {
  iterFn = getIteratorMethod(iterable);
  if (typeof iterFn != 'function')
   throw TypeError('Target is not iterable');
  if (isArrayIteratorMethod(iterFn)) {
   for (index = 0, length = toLength(iterable.length); length > index; index++) {
    result = callFn(iterable[index]);
    if (result && result instanceof Result)
     return result;
   }
   return new Result(false);
  }
  iterator = iterFn.call(iterable);
 }
 next = iterator.next;
 while (!(step = next.call(iterator)).done) {
  try {
   result = callFn(step.value);
  } catch (error) {
   iteratorClose(iterator);
   throw error;
  }
  if (typeof result == 'object' && result && result instanceof Result)
   return result;
 }
 return new Result(false);
};

/***/ }),
/* 76 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(56);
var Iterators = __w_pdfjs_require__(65);
var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;
module.exports = function (it) {
 return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};

/***/ }),
/* 77 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var aFunction = __w_pdfjs_require__(78);
module.exports = function (fn, that, length) {
 aFunction(fn);
 if (that === undefined)
  return fn;
 switch (length) {
 case 0:
  return function () {
   return fn.call(that);
  };
 case 1:
  return function (a) {
   return fn.call(that, a);
  };
 case 2:
  return function (a, b) {
   return fn.call(that, a, b);
  };
 case 3:
  return function (a, b, c) {
   return fn.call(that, a, b, c);
  };
 }
 return function () {
  return fn.apply(that, arguments);
 };
};

/***/ }),
/* 78 */
/***/ ((module) => {

module.exports = function (it) {
 if (typeof it != 'function') {
  throw TypeError(String(it) + ' is not a function');
 }
 return it;
};

/***/ }),
/* 79 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var classof = __w_pdfjs_require__(80);
var Iterators = __w_pdfjs_require__(65);
var wellKnownSymbol = __w_pdfjs_require__(56);
var ITERATOR = wellKnownSymbol('iterator');
module.exports = function (it) {
 if (it != undefined)
  return it[ITERATOR] || it['@@iterator'] || Iterators[classof(it)];
};

/***/ }),
/* 80 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(81);
var classofRaw = __w_pdfjs_require__(18);
var wellKnownSymbol = __w_pdfjs_require__(56);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var CORRECT_ARGUMENTS = classofRaw(function () {
 return arguments;
}()) == 'Arguments';
var tryGet = function (it, key) {
 try {
  return it[key];
 } catch (error) {
 }
};
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
 var O, tag, result;
 return it === undefined ? 'Undefined' : it === null ? 'Null' : typeof (tag = tryGet(O = Object(it), TO_STRING_TAG)) == 'string' ? tag : CORRECT_ARGUMENTS ? classofRaw(O) : (result = classofRaw(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : result;
};

/***/ }),
/* 81 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(56);
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};
test[TO_STRING_TAG] = 'z';
module.exports = String(test) === '[object z]';

/***/ }),
/* 82 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
module.exports = function (iterator) {
 var returnMethod = iterator['return'];
 if (returnMethod !== undefined) {
  return anObject(returnMethod.call(iterator)).value;
 }
};

/***/ }),
/* 83 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var toPrimitive = __w_pdfjs_require__(20);
var definePropertyModule = __w_pdfjs_require__(27);
var createPropertyDescriptor = __w_pdfjs_require__(15);
module.exports = function (object, key, value) {
 var propertyKey = toPrimitive(key);
 if (propertyKey in object)
  definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
 else
  object[propertyKey] = value;
};

/***/ }),
/* 84 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

__w_pdfjs_require__(85);
__w_pdfjs_require__(86);
__w_pdfjs_require__(88);
__w_pdfjs_require__(105);
__w_pdfjs_require__(106);
__w_pdfjs_require__(107);
__w_pdfjs_require__(108);
__w_pdfjs_require__(110);
var path = __w_pdfjs_require__(43);
module.exports = path.Promise;

/***/ }),
/* 85 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var getPrototypeOf = __w_pdfjs_require__(69);
var setPrototypeOf = __w_pdfjs_require__(72);
var create = __w_pdfjs_require__(61);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var createPropertyDescriptor = __w_pdfjs_require__(15);
var iterate = __w_pdfjs_require__(75);
var $AggregateError = function AggregateError(errors, message) {
 var that = this;
 if (!(that instanceof $AggregateError))
  return new $AggregateError(errors, message);
 if (setPrototypeOf) {
  that = setPrototypeOf(new Error(undefined), getPrototypeOf(that));
 }
 if (message !== undefined)
  createNonEnumerableProperty(that, 'message', String(message));
 var errorsArray = [];
 iterate(errors, errorsArray.push, { that: errorsArray });
 createNonEnumerableProperty(that, 'errors', errorsArray);
 return that;
};
$AggregateError.prototype = create(Error.prototype, {
 constructor: createPropertyDescriptor(5, $AggregateError),
 message: createPropertyDescriptor(5, ''),
 name: createPropertyDescriptor(5, 'AggregateError')
});
$({ global: true }, { AggregateError: $AggregateError });

/***/ }),
/* 86 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(81);
var redefine = __w_pdfjs_require__(29);
var toString = __w_pdfjs_require__(87);
if (!TO_STRING_TAG_SUPPORT) {
 redefine(Object.prototype, 'toString', toString, { unsafe: true });
}

/***/ }),
/* 87 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __w_pdfjs_require__(81);
var classof = __w_pdfjs_require__(80);
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
 return '[object ' + classof(this) + ']';
};

/***/ }),
/* 88 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var IS_PURE = __w_pdfjs_require__(37);
var global = __w_pdfjs_require__(10);
var getBuiltIn = __w_pdfjs_require__(42);
var NativePromise = __w_pdfjs_require__(89);
var redefine = __w_pdfjs_require__(29);
var redefineAll = __w_pdfjs_require__(90);
var setPrototypeOf = __w_pdfjs_require__(72);
var setToStringTag = __w_pdfjs_require__(71);
var setSpecies = __w_pdfjs_require__(91);
var isObject = __w_pdfjs_require__(21);
var aFunction = __w_pdfjs_require__(78);
var anInstance = __w_pdfjs_require__(92);
var inspectSource = __w_pdfjs_require__(31);
var iterate = __w_pdfjs_require__(75);
var checkCorrectnessOfIteration = __w_pdfjs_require__(93);
var speciesConstructor = __w_pdfjs_require__(94);
var task = __w_pdfjs_require__(95).set;
var microtask = __w_pdfjs_require__(98);
var promiseResolve = __w_pdfjs_require__(100);
var hostReportErrors = __w_pdfjs_require__(102);
var newPromiseCapabilityModule = __w_pdfjs_require__(101);
var perform = __w_pdfjs_require__(103);
var InternalStateModule = __w_pdfjs_require__(33);
var isForced = __w_pdfjs_require__(52);
var wellKnownSymbol = __w_pdfjs_require__(56);
var IS_BROWSER = __w_pdfjs_require__(104);
var IS_NODE = __w_pdfjs_require__(97);
var V8_VERSION = __w_pdfjs_require__(58);
var SPECIES = wellKnownSymbol('species');
var PROMISE = 'Promise';
var getInternalState = InternalStateModule.get;
var setInternalState = InternalStateModule.set;
var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
var NativePromisePrototype = NativePromise && NativePromise.prototype;
var PromiseConstructor = NativePromise;
var PromiseConstructorPrototype = NativePromisePrototype;
var TypeError = global.TypeError;
var document = global.document;
var process = global.process;
var newPromiseCapability = newPromiseCapabilityModule.f;
var newGenericPromiseCapability = newPromiseCapability;
var DISPATCH_EVENT = !!(document && document.createEvent && global.dispatchEvent);
var NATIVE_REJECTION_EVENT = typeof PromiseRejectionEvent == 'function';
var UNHANDLED_REJECTION = 'unhandledrejection';
var REJECTION_HANDLED = 'rejectionhandled';
var PENDING = 0;
var FULFILLED = 1;
var REJECTED = 2;
var HANDLED = 1;
var UNHANDLED = 2;
var SUBCLASSING = false;
var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;
var FORCED = isForced(PROMISE, function () {
 var GLOBAL_CORE_JS_PROMISE = inspectSource(PromiseConstructor) !== String(PromiseConstructor);
 if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66)
  return true;
 if (IS_PURE && !PromiseConstructorPrototype['finally'])
  return true;
 if (V8_VERSION >= 51 && /native code/.test(PromiseConstructor))
  return false;
 var promise = new PromiseConstructor(function (resolve) {
  resolve(1);
 });
 var FakePromise = function (exec) {
  exec(function () {
  }, function () {
  });
 };
 var constructor = promise.constructor = {};
 constructor[SPECIES] = FakePromise;
 SUBCLASSING = promise.then(function () {
 }) instanceof FakePromise;
 if (!SUBCLASSING)
  return true;
 return !GLOBAL_CORE_JS_PROMISE && IS_BROWSER && !NATIVE_REJECTION_EVENT;
});
var INCORRECT_ITERATION = FORCED || !checkCorrectnessOfIteration(function (iterable) {
 PromiseConstructor.all(iterable)['catch'](function () {
 });
});
var isThenable = function (it) {
 var then;
 return isObject(it) && typeof (then = it.then) == 'function' ? then : false;
};
var notify = function (state, isReject) {
 if (state.notified)
  return;
 state.notified = true;
 var chain = state.reactions;
 microtask(function () {
  var value = state.value;
  var ok = state.state == FULFILLED;
  var index = 0;
  while (chain.length > index) {
   var reaction = chain[index++];
   var handler = ok ? reaction.ok : reaction.fail;
   var resolve = reaction.resolve;
   var reject = reaction.reject;
   var domain = reaction.domain;
   var result, then, exited;
   try {
    if (handler) {
     if (!ok) {
      if (state.rejection === UNHANDLED)
       onHandleUnhandled(state);
      state.rejection = HANDLED;
     }
     if (handler === true)
      result = value;
     else {
      if (domain)
       domain.enter();
      result = handler(value);
      if (domain) {
       domain.exit();
       exited = true;
      }
     }
     if (result === reaction.promise) {
      reject(TypeError('Promise-chain cycle'));
     } else if (then = isThenable(result)) {
      then.call(result, resolve, reject);
     } else
      resolve(result);
    } else
     reject(value);
   } catch (error) {
    if (domain && !exited)
     domain.exit();
    reject(error);
   }
  }
  state.reactions = [];
  state.notified = false;
  if (isReject && !state.rejection)
   onUnhandled(state);
 });
};
var dispatchEvent = function (name, promise, reason) {
 var event, handler;
 if (DISPATCH_EVENT) {
  event = document.createEvent('Event');
  event.promise = promise;
  event.reason = reason;
  event.initEvent(name, false, true);
  global.dispatchEvent(event);
 } else
  event = {
   promise: promise,
   reason: reason
  };
 if (!NATIVE_REJECTION_EVENT && (handler = global['on' + name]))
  handler(event);
 else if (name === UNHANDLED_REJECTION)
  hostReportErrors('Unhandled promise rejection', reason);
};
var onUnhandled = function (state) {
 task.call(global, function () {
  var promise = state.facade;
  var value = state.value;
  var IS_UNHANDLED = isUnhandled(state);
  var result;
  if (IS_UNHANDLED) {
   result = perform(function () {
    if (IS_NODE) {
     process.emit('unhandledRejection', value, promise);
    } else
     dispatchEvent(UNHANDLED_REJECTION, promise, value);
   });
   state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
   if (result.error)
    throw result.value;
  }
 });
};
var isUnhandled = function (state) {
 return state.rejection !== HANDLED && !state.parent;
};
var onHandleUnhandled = function (state) {
 task.call(global, function () {
  var promise = state.facade;
  if (IS_NODE) {
   process.emit('rejectionHandled', promise);
  } else
   dispatchEvent(REJECTION_HANDLED, promise, state.value);
 });
};
var bind = function (fn, state, unwrap) {
 return function (value) {
  fn(state, value, unwrap);
 };
};
var internalReject = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 state.value = value;
 state.state = REJECTED;
 notify(state, true);
};
var internalResolve = function (state, value, unwrap) {
 if (state.done)
  return;
 state.done = true;
 if (unwrap)
  state = unwrap;
 try {
  if (state.facade === value)
   throw TypeError("Promise can't be resolved itself");
  var then = isThenable(value);
  if (then) {
   microtask(function () {
    var wrapper = { done: false };
    try {
     then.call(value, bind(internalResolve, wrapper, state), bind(internalReject, wrapper, state));
    } catch (error) {
     internalReject(wrapper, error, state);
    }
   });
  } else {
   state.value = value;
   state.state = FULFILLED;
   notify(state, false);
  }
 } catch (error) {
  internalReject({ done: false }, error, state);
 }
};
if (FORCED) {
 PromiseConstructor = function Promise(executor) {
  anInstance(this, PromiseConstructor, PROMISE);
  aFunction(executor);
  Internal.call(this);
  var state = getInternalState(this);
  try {
   executor(bind(internalResolve, state), bind(internalReject, state));
  } catch (error) {
   internalReject(state, error);
  }
 };
 PromiseConstructorPrototype = PromiseConstructor.prototype;
 Internal = function Promise(executor) {
  setInternalState(this, {
   type: PROMISE,
   done: false,
   notified: false,
   parent: false,
   reactions: [],
   rejection: false,
   state: PENDING,
   value: undefined
  });
 };
 Internal.prototype = redefineAll(PromiseConstructorPrototype, {
  then: function then(onFulfilled, onRejected) {
   var state = getInternalPromiseState(this);
   var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
   reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;
   reaction.fail = typeof onRejected == 'function' && onRejected;
   reaction.domain = IS_NODE ? process.domain : undefined;
   state.parent = true;
   state.reactions.push(reaction);
   if (state.state != PENDING)
    notify(state, false);
   return reaction.promise;
  },
  'catch': function (onRejected) {
   return this.then(undefined, onRejected);
  }
 });
 OwnPromiseCapability = function () {
  var promise = new Internal();
  var state = getInternalState(promise);
  this.promise = promise;
  this.resolve = bind(internalResolve, state);
  this.reject = bind(internalReject, state);
 };
 newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
  return C === PromiseConstructor || C === PromiseWrapper ? new OwnPromiseCapability(C) : newGenericPromiseCapability(C);
 };
 if (!IS_PURE && typeof NativePromise == 'function' && NativePromisePrototype !== Object.prototype) {
  nativeThen = NativePromisePrototype.then;
  if (!SUBCLASSING) {
   redefine(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
    var that = this;
    return new PromiseConstructor(function (resolve, reject) {
     nativeThen.call(that, resolve, reject);
    }).then(onFulfilled, onRejected);
   }, { unsafe: true });
   redefine(NativePromisePrototype, 'catch', PromiseConstructorPrototype['catch'], { unsafe: true });
  }
  try {
   delete NativePromisePrototype.constructor;
  } catch (error) {
  }
  if (setPrototypeOf) {
   setPrototypeOf(NativePromisePrototype, PromiseConstructorPrototype);
  }
 }
}
$({
 global: true,
 wrap: true,
 forced: FORCED
}, { Promise: PromiseConstructor });
setToStringTag(PromiseConstructor, PROMISE, false, true);
setSpecies(PROMISE);
PromiseWrapper = getBuiltIn(PROMISE);
$({
 target: PROMISE,
 stat: true,
 forced: FORCED
}, {
 reject: function reject(r) {
  var capability = newPromiseCapability(this);
  capability.reject.call(undefined, r);
  return capability.promise;
 }
});
$({
 target: PROMISE,
 stat: true,
 forced: IS_PURE || FORCED
}, {
 resolve: function resolve(x) {
  return promiseResolve(IS_PURE && this === PromiseWrapper ? PromiseConstructor : this, x);
 }
});
$({
 target: PROMISE,
 stat: true,
 forced: INCORRECT_ITERATION
}, {
 all: function all(iterable) {
  var C = this;
  var capability = newPromiseCapability(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aFunction(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    values.push(undefined);
    remaining++;
    $promiseResolve.call(C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = value;
     --remaining || resolve(values);
    }, reject);
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 },
 race: function race(iterable) {
  var C = this;
  var capability = newPromiseCapability(C);
  var reject = capability.reject;
  var result = perform(function () {
   var $promiseResolve = aFunction(C.resolve);
   iterate(iterable, function (promise) {
    $promiseResolve.call(C, promise).then(capability.resolve, reject);
   });
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 89 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
module.exports = global.Promise;

/***/ }),
/* 90 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var redefine = __w_pdfjs_require__(29);
module.exports = function (target, src, options) {
 for (var key in src)
  redefine(target, key, src[key], options);
 return target;
};

/***/ }),
/* 91 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var getBuiltIn = __w_pdfjs_require__(42);
var definePropertyModule = __w_pdfjs_require__(27);
var wellKnownSymbol = __w_pdfjs_require__(56);
var DESCRIPTORS = __w_pdfjs_require__(12);
var SPECIES = wellKnownSymbol('species');
module.exports = function (CONSTRUCTOR_NAME) {
 var Constructor = getBuiltIn(CONSTRUCTOR_NAME);
 var defineProperty = definePropertyModule.f;
 if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
  defineProperty(Constructor, SPECIES, {
   configurable: true,
   get: function () {
    return this;
   }
  });
 }
};

/***/ }),
/* 92 */
/***/ ((module) => {

module.exports = function (it, Constructor, name) {
 if (!(it instanceof Constructor)) {
  throw TypeError('Incorrect ' + (name ? name + ' ' : '') + 'invocation');
 }
 return it;
};

/***/ }),
/* 93 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var wellKnownSymbol = __w_pdfjs_require__(56);
var ITERATOR = wellKnownSymbol('iterator');
var SAFE_CLOSING = false;
try {
 var called = 0;
 var iteratorWithReturn = {
  next: function () {
   return { done: !!called++ };
  },
  'return': function () {
   SAFE_CLOSING = true;
  }
 };
 iteratorWithReturn[ITERATOR] = function () {
  return this;
 };
 Array.from(iteratorWithReturn, function () {
  throw 2;
 });
} catch (error) {
}
module.exports = function (exec, SKIP_CLOSING) {
 if (!SKIP_CLOSING && !SAFE_CLOSING)
  return false;
 var ITERATION_SUPPORT = false;
 try {
  var object = {};
  object[ITERATOR] = function () {
   return {
    next: function () {
     return { done: ITERATION_SUPPORT = true };
    }
   };
  };
  exec(object);
 } catch (error) {
 }
 return ITERATION_SUPPORT;
};

/***/ }),
/* 94 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
var aFunction = __w_pdfjs_require__(78);
var wellKnownSymbol = __w_pdfjs_require__(56);
var SPECIES = wellKnownSymbol('species');
module.exports = function (O, defaultConstructor) {
 var C = anObject(O).constructor;
 var S;
 return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? defaultConstructor : aFunction(S);
};

/***/ }),
/* 95 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var fails = __w_pdfjs_require__(13);
var bind = __w_pdfjs_require__(77);
var html = __w_pdfjs_require__(64);
var createElement = __w_pdfjs_require__(25);
var IS_IOS = __w_pdfjs_require__(96);
var IS_NODE = __w_pdfjs_require__(97);
var location = global.location;
var set = global.setImmediate;
var clear = global.clearImmediate;
var process = global.process;
var MessageChannel = global.MessageChannel;
var Dispatch = global.Dispatch;
var counter = 0;
var queue = {};
var ONREADYSTATECHANGE = 'onreadystatechange';
var defer, channel, port;
var run = function (id) {
 if (queue.hasOwnProperty(id)) {
  var fn = queue[id];
  delete queue[id];
  fn();
 }
};
var runner = function (id) {
 return function () {
  run(id);
 };
};
var listener = function (event) {
 run(event.data);
};
var post = function (id) {
 global.postMessage(id + '', location.protocol + '//' + location.host);
};
if (!set || !clear) {
 set = function setImmediate(fn) {
  var args = [];
  var i = 1;
  while (arguments.length > i)
   args.push(arguments[i++]);
  queue[++counter] = function () {
   (typeof fn == 'function' ? fn : Function(fn)).apply(undefined, args);
  };
  defer(counter);
  return counter;
 };
 clear = function clearImmediate(id) {
  delete queue[id];
 };
 if (IS_NODE) {
  defer = function (id) {
   process.nextTick(runner(id));
  };
 } else if (Dispatch && Dispatch.now) {
  defer = function (id) {
   Dispatch.now(runner(id));
  };
 } else if (MessageChannel && !IS_IOS) {
  channel = new MessageChannel();
  port = channel.port2;
  channel.port1.onmessage = listener;
  defer = bind(port.postMessage, port, 1);
 } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts && location && location.protocol !== 'file:' && !fails(post)) {
  defer = post;
  global.addEventListener('message', listener, false);
 } else if (ONREADYSTATECHANGE in createElement('script')) {
  defer = function (id) {
   html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
    html.removeChild(this);
    run(id);
   };
  };
 } else {
  defer = function (id) {
   setTimeout(runner(id), 0);
  };
 }
}
module.exports = {
 set: set,
 clear: clear
};

/***/ }),
/* 96 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var userAgent = __w_pdfjs_require__(59);
module.exports = /(?:iphone|ipod|ipad).*applewebkit/i.test(userAgent);

/***/ }),
/* 97 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var classof = __w_pdfjs_require__(18);
var global = __w_pdfjs_require__(10);
module.exports = classof(global.process) == 'process';

/***/ }),
/* 98 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var getOwnPropertyDescriptor = __w_pdfjs_require__(11).f;
var macrotask = __w_pdfjs_require__(95).set;
var IS_IOS = __w_pdfjs_require__(96);
var IS_WEBOS_WEBKIT = __w_pdfjs_require__(99);
var IS_NODE = __w_pdfjs_require__(97);
var MutationObserver = global.MutationObserver || global.WebKitMutationObserver;
var document = global.document;
var process = global.process;
var Promise = global.Promise;
var queueMicrotaskDescriptor = getOwnPropertyDescriptor(global, 'queueMicrotask');
var queueMicrotask = queueMicrotaskDescriptor && queueMicrotaskDescriptor.value;
var flush, head, last, notify, toggle, node, promise, then;
if (!queueMicrotask) {
 flush = function () {
  var parent, fn;
  if (IS_NODE && (parent = process.domain))
   parent.exit();
  while (head) {
   fn = head.fn;
   head = head.next;
   try {
    fn();
   } catch (error) {
    if (head)
     notify();
    else
     last = undefined;
    throw error;
   }
  }
  last = undefined;
  if (parent)
   parent.enter();
 };
 if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
  toggle = true;
  node = document.createTextNode('');
  new MutationObserver(flush).observe(node, { characterData: true });
  notify = function () {
   node.data = toggle = !toggle;
  };
 } else if (Promise && Promise.resolve) {
  promise = Promise.resolve(undefined);
  promise.constructor = Promise;
  then = promise.then;
  notify = function () {
   then.call(promise, flush);
  };
 } else if (IS_NODE) {
  notify = function () {
   process.nextTick(flush);
  };
 } else {
  notify = function () {
   macrotask.call(global, flush);
  };
 }
}
module.exports = queueMicrotask || function (fn) {
 var task = {
  fn: fn,
  next: undefined
 };
 if (last)
  last.next = task;
 if (!head) {
  head = task;
  notify();
 }
 last = task;
};

/***/ }),
/* 99 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var userAgent = __w_pdfjs_require__(59);
module.exports = /web0s(?!.*chrome)/i.test(userAgent);

/***/ }),
/* 100 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var anObject = __w_pdfjs_require__(28);
var isObject = __w_pdfjs_require__(21);
var newPromiseCapability = __w_pdfjs_require__(101);
module.exports = function (C, x) {
 anObject(C);
 if (isObject(x) && x.constructor === C)
  return x;
 var promiseCapability = newPromiseCapability.f(C);
 var resolve = promiseCapability.resolve;
 resolve(x);
 return promiseCapability.promise;
};

/***/ }),
/* 101 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var aFunction = __w_pdfjs_require__(78);
var PromiseCapability = function (C) {
 var resolve, reject;
 this.promise = new C(function ($$resolve, $$reject) {
  if (resolve !== undefined || reject !== undefined)
   throw TypeError('Bad Promise constructor');
  resolve = $$resolve;
  reject = $$reject;
 });
 this.resolve = aFunction(resolve);
 this.reject = aFunction(reject);
};
module.exports.f = function (C) {
 return new PromiseCapability(C);
};

/***/ }),
/* 102 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
module.exports = function (a, b) {
 var console = global.console;
 if (console && console.error) {
  arguments.length === 1 ? console.error(a) : console.error(a, b);
 }
};

/***/ }),
/* 103 */
/***/ ((module) => {

module.exports = function (exec) {
 try {
  return {
   error: false,
   value: exec()
  };
 } catch (error) {
  return {
   error: true,
   value: error
  };
 }
};

/***/ }),
/* 104 */
/***/ ((module) => {

module.exports = typeof window == 'object';

/***/ }),
/* 105 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var aFunction = __w_pdfjs_require__(78);
var newPromiseCapabilityModule = __w_pdfjs_require__(101);
var perform = __w_pdfjs_require__(103);
var iterate = __w_pdfjs_require__(75);
$({
 target: 'Promise',
 stat: true
}, {
 allSettled: function allSettled(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var promiseResolve = aFunction(C.resolve);
   var values = [];
   var counter = 0;
   var remaining = 1;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyCalled = false;
    values.push(undefined);
    remaining++;
    promiseResolve.call(C, promise).then(function (value) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'fulfilled',
      value: value
     };
     --remaining || resolve(values);
    }, function (error) {
     if (alreadyCalled)
      return;
     alreadyCalled = true;
     values[index] = {
      status: 'rejected',
      reason: error
     };
     --remaining || resolve(values);
    });
   });
   --remaining || resolve(values);
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 106 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var aFunction = __w_pdfjs_require__(78);
var getBuiltIn = __w_pdfjs_require__(42);
var newPromiseCapabilityModule = __w_pdfjs_require__(101);
var perform = __w_pdfjs_require__(103);
var iterate = __w_pdfjs_require__(75);
var PROMISE_ANY_ERROR = 'No one promise resolved';
$({
 target: 'Promise',
 stat: true
}, {
 any: function any(iterable) {
  var C = this;
  var capability = newPromiseCapabilityModule.f(C);
  var resolve = capability.resolve;
  var reject = capability.reject;
  var result = perform(function () {
   var promiseResolve = aFunction(C.resolve);
   var errors = [];
   var counter = 0;
   var remaining = 1;
   var alreadyResolved = false;
   iterate(iterable, function (promise) {
    var index = counter++;
    var alreadyRejected = false;
    errors.push(undefined);
    remaining++;
    promiseResolve.call(C, promise).then(function (value) {
     if (alreadyRejected || alreadyResolved)
      return;
     alreadyResolved = true;
     resolve(value);
    }, function (error) {
     if (alreadyRejected || alreadyResolved)
      return;
     alreadyRejected = true;
     errors[index] = error;
     --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
    });
   });
   --remaining || reject(new (getBuiltIn('AggregateError'))(errors, PROMISE_ANY_ERROR));
  });
  if (result.error)
   reject(result.value);
  return capability.promise;
 }
});

/***/ }),
/* 107 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var $ = __w_pdfjs_require__(9);
var IS_PURE = __w_pdfjs_require__(37);
var NativePromise = __w_pdfjs_require__(89);
var fails = __w_pdfjs_require__(13);
var getBuiltIn = __w_pdfjs_require__(42);
var speciesConstructor = __w_pdfjs_require__(94);
var promiseResolve = __w_pdfjs_require__(100);
var redefine = __w_pdfjs_require__(29);
var NON_GENERIC = !!NativePromise && fails(function () {
 NativePromise.prototype['finally'].call({
  then: function () {
  }
 }, function () {
 });
});
$({
 target: 'Promise',
 proto: true,
 real: true,
 forced: NON_GENERIC
}, {
 'finally': function (onFinally) {
  var C = speciesConstructor(this, getBuiltIn('Promise'));
  var isFunction = typeof onFinally == 'function';
  return this.then(isFunction ? function (x) {
   return promiseResolve(C, onFinally()).then(function () {
    return x;
   });
  } : onFinally, isFunction ? function (e) {
   return promiseResolve(C, onFinally()).then(function () {
    throw e;
   });
  } : onFinally);
 }
});
if (!IS_PURE && typeof NativePromise == 'function') {
 var method = getBuiltIn('Promise').prototype['finally'];
 if (NativePromise.prototype['finally'] !== method) {
  redefine(NativePromise.prototype, 'finally', method, { unsafe: true });
 }
}

/***/ }),
/* 108 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

"use strict";

var charAt = __w_pdfjs_require__(109).charAt;
var InternalStateModule = __w_pdfjs_require__(33);
var defineIterator = __w_pdfjs_require__(66);
var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);
defineIterator(String, 'String', function (iterated) {
 setInternalState(this, {
  type: STRING_ITERATOR,
  string: String(iterated),
  index: 0
 });
}, function next() {
 var state = getInternalState(this);
 var string = state.string;
 var index = state.index;
 var point;
 if (index >= string.length)
  return {
   value: undefined,
   done: true
  };
 point = charAt(string, index);
 state.index += point.length;
 return {
  value: point,
  done: false
 };
});

/***/ }),
/* 109 */
/***/ ((module, __unused_webpack_exports, __w_pdfjs_require__) => {

var toInteger = __w_pdfjs_require__(48);
var requireObjectCoercible = __w_pdfjs_require__(19);
var createMethod = function (CONVERT_TO_STRING) {
 return function ($this, pos) {
  var S = String(requireObjectCoercible($this));
  var position = toInteger(pos);
  var size = S.length;
  var first, second;
  if (position < 0 || position >= size)
   return CONVERT_TO_STRING ? '' : undefined;
  first = S.charCodeAt(position);
  return first < 0xD800 || first > 0xDBFF || position + 1 === size || (second = S.charCodeAt(position + 1)) < 0xDC00 || second > 0xDFFF ? CONVERT_TO_STRING ? S.charAt(position) : first : CONVERT_TO_STRING ? S.slice(position, position + 2) : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
 };
};
module.exports = {
 codeAt: createMethod(false),
 charAt: createMethod(true)
};

/***/ }),
/* 110 */
/***/ ((__unused_webpack_module, __unused_webpack_exports, __w_pdfjs_require__) => {

var global = __w_pdfjs_require__(10);
var DOMIterables = __w_pdfjs_require__(111);
var ArrayIteratorMethods = __w_pdfjs_require__(54);
var createNonEnumerableProperty = __w_pdfjs_require__(26);
var wellKnownSymbol = __w_pdfjs_require__(56);
var ITERATOR = wellKnownSymbol('iterator');
var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var ArrayValues = ArrayIteratorMethods.values;
for (var COLLECTION_NAME in DOMIterables) {
 var Collection = global[COLLECTION_NAME];
 var CollectionPrototype = Collection && Collection.prototype;
 if (CollectionPrototype) {
  if (CollectionPrototype[ITERATOR] !== ArrayValues)
   try {
    createNonEnumerableProperty(CollectionPrototype, ITERATOR, ArrayValues);
   } catch (error) {
    CollectionPrototype[ITERATOR] = ArrayValues;
   }
  if (!CollectionPrototype[TO_STRING_TAG]) {
   createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
  }
  if (DOMIterables[COLLECTION_NAME])
   for (var METHOD_NAME in ArrayIteratorMethods) {
    if (CollectionPrototype[METHOD_NAME] !== ArrayIteratorMethods[METHOD_NAME])
     try {
      createNonEnumerableProperty(CollectionPrototype, METHOD_NAME, ArrayIteratorMethods[METHOD_NAME]);
     } catch (error) {
      CollectionPrototype[METHOD_NAME] = ArrayIteratorMethods[METHOD_NAME];
     }
   }
 }
}

/***/ }),
/* 111 */
/***/ ((module) => {

module.exports = {
 CSSRuleList: 0,
 CSSStyleDeclaration: 0,
 CSSValueList: 0,
 ClientRectList: 0,
 DOMRectList: 0,
 DOMStringList: 0,
 DOMTokenList: 1,
 DataTransferItemList: 0,
 FileList: 0,
 HTMLAllCollection: 0,
 HTMLCollection: 0,
 HTMLFormElement: 0,
 HTMLSelectElement: 0,
 MediaList: 0,
 MimeTypeArray: 0,
 NamedNodeMap: 0,
 NodeList: 1,
 PaintRequestList: 0,
 Plugin: 0,
 PluginArray: 0,
 SVGLengthList: 0,
 SVGNumberList: 0,
 SVGPathSegList: 0,
 SVGPointList: 0,
 SVGStringList: 0,
 SVGTransformList: 0,
 SourceBufferList: 0,
 StyleSheetList: 0,
 TextTrackCueList: 0,
 TextTrackList: 0,
 TouchList: 0
};

/***/ }),
/* 112 */
/***/ (function(__unused_webpack_module, exports) {

(function (global, factory) {
  true ? factory(exports) : 0;
}(this, function (exports) {
 'use strict';
 var SymbolPolyfill = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol : function (description) {
  return "Symbol(" + description + ")";
 };
 function noop() {
  return undefined;
 }
 function getGlobals() {
  if (typeof self !== 'undefined') {
   return self;
  } else if (typeof window !== 'undefined') {
   return window;
  } else if (typeof global !== 'undefined') {
   return global;
  }
  return undefined;
 }
 var globals = getGlobals();
 function typeIsObject(x) {
  return typeof x === 'object' && x !== null || typeof x === 'function';
 }
 var rethrowAssertionErrorRejection = noop;
 var originalPromise = Promise;
 var originalPromiseThen = Promise.prototype.then;
 var originalPromiseResolve = Promise.resolve.bind(originalPromise);
 var originalPromiseReject = Promise.reject.bind(originalPromise);
 function newPromise(executor) {
  return new originalPromise(executor);
 }
 function promiseResolvedWith(value) {
  return originalPromiseResolve(value);
 }
 function promiseRejectedWith(reason) {
  return originalPromiseReject(reason);
 }
 function PerformPromiseThen(promise, onFulfilled, onRejected) {
  return originalPromiseThen.call(promise, onFulfilled, onRejected);
 }
 function uponPromise(promise, onFulfilled, onRejected) {
  PerformPromiseThen(PerformPromiseThen(promise, onFulfilled, onRejected), undefined, rethrowAssertionErrorRejection);
 }
 function uponFulfillment(promise, onFulfilled) {
  uponPromise(promise, onFulfilled);
 }
 function uponRejection(promise, onRejected) {
  uponPromise(promise, undefined, onRejected);
 }
 function transformPromiseWith(promise, fulfillmentHandler, rejectionHandler) {
  return PerformPromiseThen(promise, fulfillmentHandler, rejectionHandler);
 }
 function setPromiseIsHandledToTrue(promise) {
  PerformPromiseThen(promise, undefined, rethrowAssertionErrorRejection);
 }
 var queueMicrotask = function () {
  var globalQueueMicrotask = globals && globals.queueMicrotask;
  if (typeof globalQueueMicrotask === 'function') {
   return globalQueueMicrotask;
  }
  var resolvedPromise = promiseResolvedWith(undefined);
  return function (fn) {
   return PerformPromiseThen(resolvedPromise, fn);
  };
 }();
 function reflectCall(F, V, args) {
  if (typeof F !== 'function') {
   throw new TypeError('Argument is not a function');
  }
  return Function.prototype.apply.call(F, V, args);
 }
 function promiseCall(F, V, args) {
  try {
   return promiseResolvedWith(reflectCall(F, V, args));
  } catch (value) {
   return promiseRejectedWith(value);
  }
 }
 var QUEUE_MAX_ARRAY_SIZE = 16384;
 var SimpleQueue = function () {
  function SimpleQueue() {
   this._cursor = 0;
   this._size = 0;
   this._front = {
    _elements: [],
    _next: undefined
   };
   this._back = this._front;
   this._cursor = 0;
   this._size = 0;
  }
  Object.defineProperty(SimpleQueue.prototype, "length", {
   get: function () {
    return this._size;
   },
   enumerable: false,
   configurable: true
  });
  SimpleQueue.prototype.push = function (element) {
   var oldBack = this._back;
   var newBack = oldBack;
   if (oldBack._elements.length === QUEUE_MAX_ARRAY_SIZE - 1) {
    newBack = {
     _elements: [],
     _next: undefined
    };
   }
   oldBack._elements.push(element);
   if (newBack !== oldBack) {
    this._back = newBack;
    oldBack._next = newBack;
   }
   ++this._size;
  };
  SimpleQueue.prototype.shift = function () {
   var oldFront = this._front;
   var newFront = oldFront;
   var oldCursor = this._cursor;
   var newCursor = oldCursor + 1;
   var elements = oldFront._elements;
   var element = elements[oldCursor];
   if (newCursor === QUEUE_MAX_ARRAY_SIZE) {
    newFront = oldFront._next;
    newCursor = 0;
   }
   --this._size;
   this._cursor = newCursor;
   if (oldFront !== newFront) {
    this._front = newFront;
   }
   elements[oldCursor] = undefined;
   return element;
  };
  SimpleQueue.prototype.forEach = function (callback) {
   var i = this._cursor;
   var node = this._front;
   var elements = node._elements;
   while (i !== elements.length || node._next !== undefined) {
    if (i === elements.length) {
     node = node._next;
     elements = node._elements;
     i = 0;
     if (elements.length === 0) {
      break;
     }
    }
    callback(elements[i]);
    ++i;
   }
  };
  SimpleQueue.prototype.peek = function () {
   var front = this._front;
   var cursor = this._cursor;
   return front._elements[cursor];
  };
  return SimpleQueue;
 }();
 function ReadableStreamReaderGenericInitialize(reader, stream) {
  reader._ownerReadableStream = stream;
  stream._reader = reader;
  if (stream._state === 'readable') {
   defaultReaderClosedPromiseInitialize(reader);
  } else if (stream._state === 'closed') {
   defaultReaderClosedPromiseInitializeAsResolved(reader);
  } else {
   defaultReaderClosedPromiseInitializeAsRejected(reader, stream._storedError);
  }
 }
 function ReadableStreamReaderGenericCancel(reader, reason) {
  var stream = reader._ownerReadableStream;
  return ReadableStreamCancel(stream, reason);
 }
 function ReadableStreamReaderGenericRelease(reader) {
  if (reader._ownerReadableStream._state === 'readable') {
   defaultReaderClosedPromiseReject(reader, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness"));
  } else {
   defaultReaderClosedPromiseResetToRejected(reader, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness"));
  }
  reader._ownerReadableStream._reader = undefined;
  reader._ownerReadableStream = undefined;
 }
 function readerLockException(name) {
  return new TypeError('Cannot ' + name + ' a stream using a released reader');
 }
 function defaultReaderClosedPromiseInitialize(reader) {
  reader._closedPromise = newPromise(function (resolve, reject) {
   reader._closedPromise_resolve = resolve;
   reader._closedPromise_reject = reject;
  });
 }
 function defaultReaderClosedPromiseInitializeAsRejected(reader, reason) {
  defaultReaderClosedPromiseInitialize(reader);
  defaultReaderClosedPromiseReject(reader, reason);
 }
 function defaultReaderClosedPromiseInitializeAsResolved(reader) {
  defaultReaderClosedPromiseInitialize(reader);
  defaultReaderClosedPromiseResolve(reader);
 }
 function defaultReaderClosedPromiseReject(reader, reason) {
  if (reader._closedPromise_reject === undefined) {
   return;
  }
  setPromiseIsHandledToTrue(reader._closedPromise);
  reader._closedPromise_reject(reason);
  reader._closedPromise_resolve = undefined;
  reader._closedPromise_reject = undefined;
 }
 function defaultReaderClosedPromiseResetToRejected(reader, reason) {
  defaultReaderClosedPromiseInitializeAsRejected(reader, reason);
 }
 function defaultReaderClosedPromiseResolve(reader) {
  if (reader._closedPromise_resolve === undefined) {
   return;
  }
  reader._closedPromise_resolve(undefined);
  reader._closedPromise_resolve = undefined;
  reader._closedPromise_reject = undefined;
 }
 var AbortSteps = SymbolPolyfill('[[AbortSteps]]');
 var ErrorSteps = SymbolPolyfill('[[ErrorSteps]]');
 var CancelSteps = SymbolPolyfill('[[CancelSteps]]');
 var PullSteps = SymbolPolyfill('[[PullSteps]]');
 var NumberIsFinite = Number.isFinite || function (x) {
  return typeof x === 'number' && isFinite(x);
 };
 var MathTrunc = Math.trunc || function (v) {
  return v < 0 ? Math.ceil(v) : Math.floor(v);
 };
 function isDictionary(x) {
  return typeof x === 'object' || typeof x === 'function';
 }
 function assertDictionary(obj, context) {
  if (obj !== undefined && !isDictionary(obj)) {
   throw new TypeError(context + " is not an object.");
  }
 }
 function assertFunction(x, context) {
  if (typeof x !== 'function') {
   throw new TypeError(context + " is not a function.");
  }
 }
 function isObject(x) {
  return typeof x === 'object' && x !== null || typeof x === 'function';
 }
 function assertObject(x, context) {
  if (!isObject(x)) {
   throw new TypeError(context + " is not an object.");
  }
 }
 function assertRequiredArgument(x, position, context) {
  if (x === undefined) {
   throw new TypeError("Parameter " + position + " is required in '" + context + "'.");
  }
 }
 function assertRequiredField(x, field, context) {
  if (x === undefined) {
   throw new TypeError(field + " is required in '" + context + "'.");
  }
 }
 function convertUnrestrictedDouble(value) {
  return Number(value);
 }
 function censorNegativeZero(x) {
  return x === 0 ? 0 : x;
 }
 function integerPart(x) {
  return censorNegativeZero(MathTrunc(x));
 }
 function convertUnsignedLongLongWithEnforceRange(value, context) {
  var lowerBound = 0;
  var upperBound = Number.MAX_SAFE_INTEGER;
  var x = Number(value);
  x = censorNegativeZero(x);
  if (!NumberIsFinite(x)) {
   throw new TypeError(context + " is not a finite number");
  }
  x = integerPart(x);
  if (x < lowerBound || x > upperBound) {
   throw new TypeError(context + " is outside the accepted range of " + lowerBound + " to " + upperBound + ", inclusive");
  }
  if (!NumberIsFinite(x) || x === 0) {
   return 0;
  }
  return x;
 }
 function assertReadableStream(x, context) {
  if (!IsReadableStream(x)) {
   throw new TypeError(context + " is not a ReadableStream.");
  }
 }
 function AcquireReadableStreamDefaultReader(stream) {
  return new ReadableStreamDefaultReader(stream);
 }
 function ReadableStreamAddReadRequest(stream, readRequest) {
  stream._reader._readRequests.push(readRequest);
 }
 function ReadableStreamFulfillReadRequest(stream, chunk, done) {
  var reader = stream._reader;
  var readRequest = reader._readRequests.shift();
  if (done) {
   readRequest._closeSteps();
  } else {
   readRequest._chunkSteps(chunk);
  }
 }
 function ReadableStreamGetNumReadRequests(stream) {
  return stream._reader._readRequests.length;
 }
 function ReadableStreamHasDefaultReader(stream) {
  var reader = stream._reader;
  if (reader === undefined) {
   return false;
  }
  if (!IsReadableStreamDefaultReader(reader)) {
   return false;
  }
  return true;
 }
 var ReadableStreamDefaultReader = function () {
  function ReadableStreamDefaultReader(stream) {
   assertRequiredArgument(stream, 1, 'ReadableStreamDefaultReader');
   assertReadableStream(stream, 'First parameter');
   if (IsReadableStreamLocked(stream)) {
    throw new TypeError('This stream has already been locked for exclusive reading by another reader');
   }
   ReadableStreamReaderGenericInitialize(this, stream);
   this._readRequests = new SimpleQueue();
  }
  Object.defineProperty(ReadableStreamDefaultReader.prototype, "closed", {
   get: function () {
    if (!IsReadableStreamDefaultReader(this)) {
     return promiseRejectedWith(defaultReaderBrandCheckException('closed'));
    }
    return this._closedPromise;
   },
   enumerable: false,
   configurable: true
  });
  ReadableStreamDefaultReader.prototype.cancel = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsReadableStreamDefaultReader(this)) {
    return promiseRejectedWith(defaultReaderBrandCheckException('cancel'));
   }
   if (this._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('cancel'));
   }
   return ReadableStreamReaderGenericCancel(this, reason);
  };
  ReadableStreamDefaultReader.prototype.read = function () {
   if (!IsReadableStreamDefaultReader(this)) {
    return promiseRejectedWith(defaultReaderBrandCheckException('read'));
   }
   if (this._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('read from'));
   }
   var resolvePromise;
   var rejectPromise;
   var promise = newPromise(function (resolve, reject) {
    resolvePromise = resolve;
    rejectPromise = reject;
   });
   var readRequest = {
    _chunkSteps: function (chunk) {
     return resolvePromise({
      value: chunk,
      done: false
     });
    },
    _closeSteps: function () {
     return resolvePromise({
      value: undefined,
      done: true
     });
    },
    _errorSteps: function (e) {
     return rejectPromise(e);
    }
   };
   ReadableStreamDefaultReaderRead(this, readRequest);
   return promise;
  };
  ReadableStreamDefaultReader.prototype.releaseLock = function () {
   if (!IsReadableStreamDefaultReader(this)) {
    throw defaultReaderBrandCheckException('releaseLock');
   }
   if (this._ownerReadableStream === undefined) {
    return;
   }
   if (this._readRequests.length > 0) {
    throw new TypeError('Tried to release a reader lock when that reader has pending read() calls un-settled');
   }
   ReadableStreamReaderGenericRelease(this);
  };
  return ReadableStreamDefaultReader;
 }();
 Object.defineProperties(ReadableStreamDefaultReader.prototype, {
  cancel: { enumerable: true },
  read: { enumerable: true },
  releaseLock: { enumerable: true },
  closed: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableStreamDefaultReader.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableStreamDefaultReader',
   configurable: true
  });
 }
 function IsReadableStreamDefaultReader(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_readRequests')) {
   return false;
  }
  return true;
 }
 function ReadableStreamDefaultReaderRead(reader, readRequest) {
  var stream = reader._ownerReadableStream;
  stream._disturbed = true;
  if (stream._state === 'closed') {
   readRequest._closeSteps();
  } else if (stream._state === 'errored') {
   readRequest._errorSteps(stream._storedError);
  } else {
   stream._readableStreamController[PullSteps](readRequest);
  }
 }
 function defaultReaderBrandCheckException(name) {
  return new TypeError("ReadableStreamDefaultReader.prototype." + name + " can only be used on a ReadableStreamDefaultReader");
 }
 var _a;
 var AsyncIteratorPrototype;
 if (typeof SymbolPolyfill.asyncIterator === 'symbol') {
  AsyncIteratorPrototype = (_a = {}, _a[SymbolPolyfill.asyncIterator] = function () {
   return this;
  }, _a);
  Object.defineProperty(AsyncIteratorPrototype, SymbolPolyfill.asyncIterator, { enumerable: false });
 }
 var ReadableStreamAsyncIteratorImpl = function () {
  function ReadableStreamAsyncIteratorImpl(reader, preventCancel) {
   this._ongoingPromise = undefined;
   this._isFinished = false;
   this._reader = reader;
   this._preventCancel = preventCancel;
  }
  ReadableStreamAsyncIteratorImpl.prototype.next = function () {
   var _this = this;
   var nextSteps = function () {
    return _this._nextSteps();
   };
   this._ongoingPromise = this._ongoingPromise ? transformPromiseWith(this._ongoingPromise, nextSteps, nextSteps) : nextSteps();
   return this._ongoingPromise;
  };
  ReadableStreamAsyncIteratorImpl.prototype.return = function (value) {
   var _this = this;
   var returnSteps = function () {
    return _this._returnSteps(value);
   };
   return this._ongoingPromise ? transformPromiseWith(this._ongoingPromise, returnSteps, returnSteps) : returnSteps();
  };
  ReadableStreamAsyncIteratorImpl.prototype._nextSteps = function () {
   var _this = this;
   if (this._isFinished) {
    return Promise.resolve({
     value: undefined,
     done: true
    });
   }
   var reader = this._reader;
   if (reader._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('iterate'));
   }
   var resolvePromise;
   var rejectPromise;
   var promise = newPromise(function (resolve, reject) {
    resolvePromise = resolve;
    rejectPromise = reject;
   });
   var readRequest = {
    _chunkSteps: function (chunk) {
     _this._ongoingPromise = undefined;
     queueMicrotask(function () {
      return resolvePromise({
       value: chunk,
       done: false
      });
     });
    },
    _closeSteps: function () {
     _this._ongoingPromise = undefined;
     _this._isFinished = true;
     ReadableStreamReaderGenericRelease(reader);
     resolvePromise({
      value: undefined,
      done: true
     });
    },
    _errorSteps: function (reason) {
     _this._ongoingPromise = undefined;
     _this._isFinished = true;
     ReadableStreamReaderGenericRelease(reader);
     rejectPromise(reason);
    }
   };
   ReadableStreamDefaultReaderRead(reader, readRequest);
   return promise;
  };
  ReadableStreamAsyncIteratorImpl.prototype._returnSteps = function (value) {
   if (this._isFinished) {
    return Promise.resolve({
     value: value,
     done: true
    });
   }
   this._isFinished = true;
   var reader = this._reader;
   if (reader._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('finish iterating'));
   }
   if (!this._preventCancel) {
    var result = ReadableStreamReaderGenericCancel(reader, value);
    ReadableStreamReaderGenericRelease(reader);
    return transformPromiseWith(result, function () {
     return {
      value: value,
      done: true
     };
    });
   }
   ReadableStreamReaderGenericRelease(reader);
   return promiseResolvedWith({
    value: value,
    done: true
   });
  };
  return ReadableStreamAsyncIteratorImpl;
 }();
 var ReadableStreamAsyncIteratorPrototype = {
  next: function () {
   if (!IsReadableStreamAsyncIterator(this)) {
    return promiseRejectedWith(streamAsyncIteratorBrandCheckException('next'));
   }
   return this._asyncIteratorImpl.next();
  },
  return: function (value) {
   if (!IsReadableStreamAsyncIterator(this)) {
    return promiseRejectedWith(streamAsyncIteratorBrandCheckException('return'));
   }
   return this._asyncIteratorImpl.return(value);
  }
 };
 if (AsyncIteratorPrototype !== undefined) {
  Object.setPrototypeOf(ReadableStreamAsyncIteratorPrototype, AsyncIteratorPrototype);
 }
 function AcquireReadableStreamAsyncIterator(stream, preventCancel) {
  var reader = AcquireReadableStreamDefaultReader(stream);
  var impl = new ReadableStreamAsyncIteratorImpl(reader, preventCancel);
  var iterator = Object.create(ReadableStreamAsyncIteratorPrototype);
  iterator._asyncIteratorImpl = impl;
  return iterator;
 }
 function IsReadableStreamAsyncIterator(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_asyncIteratorImpl')) {
   return false;
  }
  return true;
 }
 function streamAsyncIteratorBrandCheckException(name) {
  return new TypeError("ReadableStreamAsyncIterator." + name + " can only be used on a ReadableSteamAsyncIterator");
 }
 var NumberIsNaN = Number.isNaN || function (x) {
  return x !== x;
 };
 function IsFiniteNonNegativeNumber(v) {
  if (!IsNonNegativeNumber(v)) {
   return false;
  }
  if (v === Infinity) {
   return false;
  }
  return true;
 }
 function IsNonNegativeNumber(v) {
  if (typeof v !== 'number') {
   return false;
  }
  if (NumberIsNaN(v)) {
   return false;
  }
  if (v < 0) {
   return false;
  }
  return true;
 }
 function DequeueValue(container) {
  var pair = container._queue.shift();
  container._queueTotalSize -= pair.size;
  if (container._queueTotalSize < 0) {
   container._queueTotalSize = 0;
  }
  return pair.value;
 }
 function EnqueueValueWithSize(container, value, size) {
  size = Number(size);
  if (!IsFiniteNonNegativeNumber(size)) {
   throw new RangeError('Size must be a finite, non-NaN, non-negative number.');
  }
  container._queue.push({
   value: value,
   size: size
  });
  container._queueTotalSize += size;
 }
 function PeekQueueValue(container) {
  var pair = container._queue.peek();
  return pair.value;
 }
 function ResetQueue(container) {
  container._queue = new SimpleQueue();
  container._queueTotalSize = 0;
 }
 function CreateArrayFromList(elements) {
  return elements.slice();
 }
 function CopyDataBlockBytes(dest, destOffset, src, srcOffset, n) {
  new Uint8Array(dest).set(new Uint8Array(src, srcOffset, n), destOffset);
 }
 function TransferArrayBuffer(O) {
  return O;
 }
 function IsDetachedBuffer(O) {
  return false;
 }
 var ReadableStreamBYOBRequest = function () {
  function ReadableStreamBYOBRequest() {
   throw new TypeError('Illegal constructor');
  }
  Object.defineProperty(ReadableStreamBYOBRequest.prototype, "view", {
   get: function () {
    if (!IsReadableStreamBYOBRequest(this)) {
     throw byobRequestBrandCheckException('view');
    }
    return this._view;
   },
   enumerable: false,
   configurable: true
  });
  ReadableStreamBYOBRequest.prototype.respond = function (bytesWritten) {
   if (!IsReadableStreamBYOBRequest(this)) {
    throw byobRequestBrandCheckException('respond');
   }
   assertRequiredArgument(bytesWritten, 1, 'respond');
   bytesWritten = convertUnsignedLongLongWithEnforceRange(bytesWritten, 'First parameter');
   if (this._associatedReadableByteStreamController === undefined) {
    throw new TypeError('This BYOB request has been invalidated');
   }
   if (IsDetachedBuffer(this._view.buffer));
   ReadableByteStreamControllerRespond(this._associatedReadableByteStreamController, bytesWritten);
  };
  ReadableStreamBYOBRequest.prototype.respondWithNewView = function (view) {
   if (!IsReadableStreamBYOBRequest(this)) {
    throw byobRequestBrandCheckException('respondWithNewView');
   }
   assertRequiredArgument(view, 1, 'respondWithNewView');
   if (!ArrayBuffer.isView(view)) {
    throw new TypeError('You can only respond with array buffer views');
   }
   if (view.byteLength === 0) {
    throw new TypeError('chunk must have non-zero byteLength');
   }
   if (view.buffer.byteLength === 0) {
    throw new TypeError("chunk's buffer must have non-zero byteLength");
   }
   if (this._associatedReadableByteStreamController === undefined) {
    throw new TypeError('This BYOB request has been invalidated');
   }
   ReadableByteStreamControllerRespondWithNewView(this._associatedReadableByteStreamController, view);
  };
  return ReadableStreamBYOBRequest;
 }();
 Object.defineProperties(ReadableStreamBYOBRequest.prototype, {
  respond: { enumerable: true },
  respondWithNewView: { enumerable: true },
  view: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableStreamBYOBRequest.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableStreamBYOBRequest',
   configurable: true
  });
 }
 var ReadableByteStreamController = function () {
  function ReadableByteStreamController() {
   throw new TypeError('Illegal constructor');
  }
  Object.defineProperty(ReadableByteStreamController.prototype, "byobRequest", {
   get: function () {
    if (!IsReadableByteStreamController(this)) {
     throw byteStreamControllerBrandCheckException('byobRequest');
    }
    if (this._byobRequest === null && this._pendingPullIntos.length > 0) {
     var firstDescriptor = this._pendingPullIntos.peek();
     var view = new Uint8Array(firstDescriptor.buffer, firstDescriptor.byteOffset + firstDescriptor.bytesFilled, firstDescriptor.byteLength - firstDescriptor.bytesFilled);
     var byobRequest = Object.create(ReadableStreamBYOBRequest.prototype);
     SetUpReadableStreamBYOBRequest(byobRequest, this, view);
     this._byobRequest = byobRequest;
    }
    return this._byobRequest;
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(ReadableByteStreamController.prototype, "desiredSize", {
   get: function () {
    if (!IsReadableByteStreamController(this)) {
     throw byteStreamControllerBrandCheckException('desiredSize');
    }
    return ReadableByteStreamControllerGetDesiredSize(this);
   },
   enumerable: false,
   configurable: true
  });
  ReadableByteStreamController.prototype.close = function () {
   if (!IsReadableByteStreamController(this)) {
    throw byteStreamControllerBrandCheckException('close');
   }
   if (this._closeRequested) {
    throw new TypeError('The stream has already been closed; do not close it again!');
   }
   var state = this._controlledReadableByteStream._state;
   if (state !== 'readable') {
    throw new TypeError("The stream (in " + state + " state) is not in the readable state and cannot be closed");
   }
   ReadableByteStreamControllerClose(this);
  };
  ReadableByteStreamController.prototype.enqueue = function (chunk) {
   if (!IsReadableByteStreamController(this)) {
    throw byteStreamControllerBrandCheckException('enqueue');
   }
   assertRequiredArgument(chunk, 1, 'enqueue');
   if (!ArrayBuffer.isView(chunk)) {
    throw new TypeError('chunk must be an array buffer view');
   }
   if (chunk.byteLength === 0) {
    throw new TypeError('chunk must have non-zero byteLength');
   }
   if (chunk.buffer.byteLength === 0) {
    throw new TypeError("chunk's buffer must have non-zero byteLength");
   }
   if (this._closeRequested) {
    throw new TypeError('stream is closed or draining');
   }
   var state = this._controlledReadableByteStream._state;
   if (state !== 'readable') {
    throw new TypeError("The stream (in " + state + " state) is not in the readable state and cannot be enqueued to");
   }
   ReadableByteStreamControllerEnqueue(this, chunk);
  };
  ReadableByteStreamController.prototype.error = function (e) {
   if (e === void 0) {
    e = undefined;
   }
   if (!IsReadableByteStreamController(this)) {
    throw byteStreamControllerBrandCheckException('error');
   }
   ReadableByteStreamControllerError(this, e);
  };
  ReadableByteStreamController.prototype[CancelSteps] = function (reason) {
   if (this._pendingPullIntos.length > 0) {
    var firstDescriptor = this._pendingPullIntos.peek();
    firstDescriptor.bytesFilled = 0;
   }
   ResetQueue(this);
   var result = this._cancelAlgorithm(reason);
   ReadableByteStreamControllerClearAlgorithms(this);
   return result;
  };
  ReadableByteStreamController.prototype[PullSteps] = function (readRequest) {
   var stream = this._controlledReadableByteStream;
   if (this._queueTotalSize > 0) {
    var entry = this._queue.shift();
    this._queueTotalSize -= entry.byteLength;
    ReadableByteStreamControllerHandleQueueDrain(this);
    var view = new Uint8Array(entry.buffer, entry.byteOffset, entry.byteLength);
    readRequest._chunkSteps(view);
    return;
   }
   var autoAllocateChunkSize = this._autoAllocateChunkSize;
   if (autoAllocateChunkSize !== undefined) {
    var buffer = void 0;
    try {
     buffer = new ArrayBuffer(autoAllocateChunkSize);
    } catch (bufferE) {
     readRequest._errorSteps(bufferE);
     return;
    }
    var pullIntoDescriptor = {
     buffer: buffer,
     byteOffset: 0,
     byteLength: autoAllocateChunkSize,
     bytesFilled: 0,
     elementSize: 1,
     viewConstructor: Uint8Array,
     readerType: 'default'
    };
    this._pendingPullIntos.push(pullIntoDescriptor);
   }
   ReadableStreamAddReadRequest(stream, readRequest);
   ReadableByteStreamControllerCallPullIfNeeded(this);
  };
  return ReadableByteStreamController;
 }();
 Object.defineProperties(ReadableByteStreamController.prototype, {
  close: { enumerable: true },
  enqueue: { enumerable: true },
  error: { enumerable: true },
  byobRequest: { enumerable: true },
  desiredSize: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableByteStreamController.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableByteStreamController',
   configurable: true
  });
 }
 function IsReadableByteStreamController(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_controlledReadableByteStream')) {
   return false;
  }
  return true;
 }
 function IsReadableStreamBYOBRequest(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_associatedReadableByteStreamController')) {
   return false;
  }
  return true;
 }
 function ReadableByteStreamControllerCallPullIfNeeded(controller) {
  var shouldPull = ReadableByteStreamControllerShouldCallPull(controller);
  if (!shouldPull) {
   return;
  }
  if (controller._pulling) {
   controller._pullAgain = true;
   return;
  }
  controller._pulling = true;
  var pullPromise = controller._pullAlgorithm();
  uponPromise(pullPromise, function () {
   controller._pulling = false;
   if (controller._pullAgain) {
    controller._pullAgain = false;
    ReadableByteStreamControllerCallPullIfNeeded(controller);
   }
  }, function (e) {
   ReadableByteStreamControllerError(controller, e);
  });
 }
 function ReadableByteStreamControllerClearPendingPullIntos(controller) {
  ReadableByteStreamControllerInvalidateBYOBRequest(controller);
  controller._pendingPullIntos = new SimpleQueue();
 }
 function ReadableByteStreamControllerCommitPullIntoDescriptor(stream, pullIntoDescriptor) {
  var done = false;
  if (stream._state === 'closed') {
   done = true;
  }
  var filledView = ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor);
  if (pullIntoDescriptor.readerType === 'default') {
   ReadableStreamFulfillReadRequest(stream, filledView, done);
  } else {
   ReadableStreamFulfillReadIntoRequest(stream, filledView, done);
  }
 }
 function ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor) {
  var bytesFilled = pullIntoDescriptor.bytesFilled;
  var elementSize = pullIntoDescriptor.elementSize;
  return new pullIntoDescriptor.viewConstructor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, bytesFilled / elementSize);
 }
 function ReadableByteStreamControllerEnqueueChunkToQueue(controller, buffer, byteOffset, byteLength) {
  controller._queue.push({
   buffer: buffer,
   byteOffset: byteOffset,
   byteLength: byteLength
  });
  controller._queueTotalSize += byteLength;
 }
 function ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor) {
  var elementSize = pullIntoDescriptor.elementSize;
  var currentAlignedBytes = pullIntoDescriptor.bytesFilled - pullIntoDescriptor.bytesFilled % elementSize;
  var maxBytesToCopy = Math.min(controller._queueTotalSize, pullIntoDescriptor.byteLength - pullIntoDescriptor.bytesFilled);
  var maxBytesFilled = pullIntoDescriptor.bytesFilled + maxBytesToCopy;
  var maxAlignedBytes = maxBytesFilled - maxBytesFilled % elementSize;
  var totalBytesToCopyRemaining = maxBytesToCopy;
  var ready = false;
  if (maxAlignedBytes > currentAlignedBytes) {
   totalBytesToCopyRemaining = maxAlignedBytes - pullIntoDescriptor.bytesFilled;
   ready = true;
  }
  var queue = controller._queue;
  while (totalBytesToCopyRemaining > 0) {
   var headOfQueue = queue.peek();
   var bytesToCopy = Math.min(totalBytesToCopyRemaining, headOfQueue.byteLength);
   var destStart = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;
   CopyDataBlockBytes(pullIntoDescriptor.buffer, destStart, headOfQueue.buffer, headOfQueue.byteOffset, bytesToCopy);
   if (headOfQueue.byteLength === bytesToCopy) {
    queue.shift();
   } else {
    headOfQueue.byteOffset += bytesToCopy;
    headOfQueue.byteLength -= bytesToCopy;
   }
   controller._queueTotalSize -= bytesToCopy;
   ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, bytesToCopy, pullIntoDescriptor);
   totalBytesToCopyRemaining -= bytesToCopy;
  }
  return ready;
 }
 function ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, size, pullIntoDescriptor) {
  ReadableByteStreamControllerInvalidateBYOBRequest(controller);
  pullIntoDescriptor.bytesFilled += size;
 }
 function ReadableByteStreamControllerHandleQueueDrain(controller) {
  if (controller._queueTotalSize === 0 && controller._closeRequested) {
   ReadableByteStreamControllerClearAlgorithms(controller);
   ReadableStreamClose(controller._controlledReadableByteStream);
  } else {
   ReadableByteStreamControllerCallPullIfNeeded(controller);
  }
 }
 function ReadableByteStreamControllerInvalidateBYOBRequest(controller) {
  if (controller._byobRequest === null) {
   return;
  }
  controller._byobRequest._associatedReadableByteStreamController = undefined;
  controller._byobRequest._view = null;
  controller._byobRequest = null;
 }
 function ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller) {
  while (controller._pendingPullIntos.length > 0) {
   if (controller._queueTotalSize === 0) {
    return;
   }
   var pullIntoDescriptor = controller._pendingPullIntos.peek();
   if (ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor)) {
    ReadableByteStreamControllerShiftPendingPullInto(controller);
    ReadableByteStreamControllerCommitPullIntoDescriptor(controller._controlledReadableByteStream, pullIntoDescriptor);
   }
  }
 }
 function ReadableByteStreamControllerPullInto(controller, view, readIntoRequest) {
  var stream = controller._controlledReadableByteStream;
  var elementSize = 1;
  if (view.constructor !== DataView) {
   elementSize = view.constructor.BYTES_PER_ELEMENT;
  }
  var ctor = view.constructor;
  var buffer = TransferArrayBuffer(view.buffer);
  var pullIntoDescriptor = {
   buffer: buffer,
   byteOffset: view.byteOffset,
   byteLength: view.byteLength,
   bytesFilled: 0,
   elementSize: elementSize,
   viewConstructor: ctor,
   readerType: 'byob'
  };
  if (controller._pendingPullIntos.length > 0) {
   controller._pendingPullIntos.push(pullIntoDescriptor);
   ReadableStreamAddReadIntoRequest(stream, readIntoRequest);
   return;
  }
  if (stream._state === 'closed') {
   var emptyView = new ctor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, 0);
   readIntoRequest._closeSteps(emptyView);
   return;
  }
  if (controller._queueTotalSize > 0) {
   if (ReadableByteStreamControllerFillPullIntoDescriptorFromQueue(controller, pullIntoDescriptor)) {
    var filledView = ReadableByteStreamControllerConvertPullIntoDescriptor(pullIntoDescriptor);
    ReadableByteStreamControllerHandleQueueDrain(controller);
    readIntoRequest._chunkSteps(filledView);
    return;
   }
   if (controller._closeRequested) {
    var e = new TypeError('Insufficient bytes to fill elements in the given buffer');
    ReadableByteStreamControllerError(controller, e);
    readIntoRequest._errorSteps(e);
    return;
   }
  }
  controller._pendingPullIntos.push(pullIntoDescriptor);
  ReadableStreamAddReadIntoRequest(stream, readIntoRequest);
  ReadableByteStreamControllerCallPullIfNeeded(controller);
 }
 function ReadableByteStreamControllerRespondInClosedState(controller, firstDescriptor) {
  firstDescriptor.buffer = TransferArrayBuffer(firstDescriptor.buffer);
  var stream = controller._controlledReadableByteStream;
  if (ReadableStreamHasBYOBReader(stream)) {
   while (ReadableStreamGetNumReadIntoRequests(stream) > 0) {
    var pullIntoDescriptor = ReadableByteStreamControllerShiftPendingPullInto(controller);
    ReadableByteStreamControllerCommitPullIntoDescriptor(stream, pullIntoDescriptor);
   }
  }
 }
 function ReadableByteStreamControllerRespondInReadableState(controller, bytesWritten, pullIntoDescriptor) {
  if (pullIntoDescriptor.bytesFilled + bytesWritten > pullIntoDescriptor.byteLength) {
   throw new RangeError('bytesWritten out of range');
  }
  ReadableByteStreamControllerFillHeadPullIntoDescriptor(controller, bytesWritten, pullIntoDescriptor);
  if (pullIntoDescriptor.bytesFilled < pullIntoDescriptor.elementSize) {
   return;
  }
  ReadableByteStreamControllerShiftPendingPullInto(controller);
  var remainderSize = pullIntoDescriptor.bytesFilled % pullIntoDescriptor.elementSize;
  if (remainderSize > 0) {
   var end = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;
   var remainder = pullIntoDescriptor.buffer.slice(end - remainderSize, end);
   ReadableByteStreamControllerEnqueueChunkToQueue(controller, remainder, 0, remainder.byteLength);
  }
  pullIntoDescriptor.buffer = TransferArrayBuffer(pullIntoDescriptor.buffer);
  pullIntoDescriptor.bytesFilled -= remainderSize;
  ReadableByteStreamControllerCommitPullIntoDescriptor(controller._controlledReadableByteStream, pullIntoDescriptor);
  ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller);
 }
 function ReadableByteStreamControllerRespondInternal(controller, bytesWritten) {
  var firstDescriptor = controller._pendingPullIntos.peek();
  var state = controller._controlledReadableByteStream._state;
  if (state === 'closed') {
   if (bytesWritten !== 0) {
    throw new TypeError('bytesWritten must be 0 when calling respond() on a closed stream');
   }
   ReadableByteStreamControllerRespondInClosedState(controller, firstDescriptor);
  } else {
   ReadableByteStreamControllerRespondInReadableState(controller, bytesWritten, firstDescriptor);
  }
  ReadableByteStreamControllerCallPullIfNeeded(controller);
 }
 function ReadableByteStreamControllerShiftPendingPullInto(controller) {
  var descriptor = controller._pendingPullIntos.shift();
  ReadableByteStreamControllerInvalidateBYOBRequest(controller);
  return descriptor;
 }
 function ReadableByteStreamControllerShouldCallPull(controller) {
  var stream = controller._controlledReadableByteStream;
  if (stream._state !== 'readable') {
   return false;
  }
  if (controller._closeRequested) {
   return false;
  }
  if (!controller._started) {
   return false;
  }
  if (ReadableStreamHasDefaultReader(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
   return true;
  }
  if (ReadableStreamHasBYOBReader(stream) && ReadableStreamGetNumReadIntoRequests(stream) > 0) {
   return true;
  }
  var desiredSize = ReadableByteStreamControllerGetDesiredSize(controller);
  if (desiredSize > 0) {
   return true;
  }
  return false;
 }
 function ReadableByteStreamControllerClearAlgorithms(controller) {
  controller._pullAlgorithm = undefined;
  controller._cancelAlgorithm = undefined;
 }
 function ReadableByteStreamControllerClose(controller) {
  var stream = controller._controlledReadableByteStream;
  if (controller._closeRequested || stream._state !== 'readable') {
   return;
  }
  if (controller._queueTotalSize > 0) {
   controller._closeRequested = true;
   return;
  }
  if (controller._pendingPullIntos.length > 0) {
   var firstPendingPullInto = controller._pendingPullIntos.peek();
   if (firstPendingPullInto.bytesFilled > 0) {
    var e = new TypeError('Insufficient bytes to fill elements in the given buffer');
    ReadableByteStreamControllerError(controller, e);
    throw e;
   }
  }
  ReadableByteStreamControllerClearAlgorithms(controller);
  ReadableStreamClose(stream);
 }
 function ReadableByteStreamControllerEnqueue(controller, chunk) {
  var stream = controller._controlledReadableByteStream;
  if (controller._closeRequested || stream._state !== 'readable') {
   return;
  }
  var buffer = chunk.buffer;
  var byteOffset = chunk.byteOffset;
  var byteLength = chunk.byteLength;
  var transferredBuffer = TransferArrayBuffer(buffer);
  if (ReadableStreamHasDefaultReader(stream)) {
   if (ReadableStreamGetNumReadRequests(stream) === 0) {
    ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
   } else {
    var transferredView = new Uint8Array(transferredBuffer, byteOffset, byteLength);
    ReadableStreamFulfillReadRequest(stream, transferredView, false);
   }
  } else if (ReadableStreamHasBYOBReader(stream)) {
   ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
   ReadableByteStreamControllerProcessPullIntoDescriptorsUsingQueue(controller);
  } else {
   ReadableByteStreamControllerEnqueueChunkToQueue(controller, transferredBuffer, byteOffset, byteLength);
  }
  ReadableByteStreamControllerCallPullIfNeeded(controller);
 }
 function ReadableByteStreamControllerError(controller, e) {
  var stream = controller._controlledReadableByteStream;
  if (stream._state !== 'readable') {
   return;
  }
  ReadableByteStreamControllerClearPendingPullIntos(controller);
  ResetQueue(controller);
  ReadableByteStreamControllerClearAlgorithms(controller);
  ReadableStreamError(stream, e);
 }
 function ReadableByteStreamControllerGetDesiredSize(controller) {
  var state = controller._controlledReadableByteStream._state;
  if (state === 'errored') {
   return null;
  }
  if (state === 'closed') {
   return 0;
  }
  return controller._strategyHWM - controller._queueTotalSize;
 }
 function ReadableByteStreamControllerRespond(controller, bytesWritten) {
  bytesWritten = Number(bytesWritten);
  if (!IsFiniteNonNegativeNumber(bytesWritten)) {
   throw new RangeError('bytesWritten must be a finite');
  }
  ReadableByteStreamControllerRespondInternal(controller, bytesWritten);
 }
 function ReadableByteStreamControllerRespondWithNewView(controller, view) {
  var firstDescriptor = controller._pendingPullIntos.peek();
  if (firstDescriptor.byteOffset + firstDescriptor.bytesFilled !== view.byteOffset) {
   throw new RangeError('The region specified by view does not match byobRequest');
  }
  if (firstDescriptor.byteLength !== view.byteLength) {
   throw new RangeError('The buffer of view has different capacity than byobRequest');
  }
  firstDescriptor.buffer = view.buffer;
  ReadableByteStreamControllerRespondInternal(controller, view.byteLength);
 }
 function SetUpReadableByteStreamController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, autoAllocateChunkSize) {
  controller._controlledReadableByteStream = stream;
  controller._pullAgain = false;
  controller._pulling = false;
  controller._byobRequest = null;
  controller._queue = controller._queueTotalSize = undefined;
  ResetQueue(controller);
  controller._closeRequested = false;
  controller._started = false;
  controller._strategyHWM = highWaterMark;
  controller._pullAlgorithm = pullAlgorithm;
  controller._cancelAlgorithm = cancelAlgorithm;
  controller._autoAllocateChunkSize = autoAllocateChunkSize;
  controller._pendingPullIntos = new SimpleQueue();
  stream._readableStreamController = controller;
  var startResult = startAlgorithm();
  uponPromise(promiseResolvedWith(startResult), function () {
   controller._started = true;
   ReadableByteStreamControllerCallPullIfNeeded(controller);
  }, function (r) {
   ReadableByteStreamControllerError(controller, r);
  });
 }
 function SetUpReadableByteStreamControllerFromUnderlyingSource(stream, underlyingByteSource, highWaterMark) {
  var controller = Object.create(ReadableByteStreamController.prototype);
  var startAlgorithm = function () {
   return undefined;
  };
  var pullAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  var cancelAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  if (underlyingByteSource.start !== undefined) {
   startAlgorithm = function () {
    return underlyingByteSource.start(controller);
   };
  }
  if (underlyingByteSource.pull !== undefined) {
   pullAlgorithm = function () {
    return underlyingByteSource.pull(controller);
   };
  }
  if (underlyingByteSource.cancel !== undefined) {
   cancelAlgorithm = function (reason) {
    return underlyingByteSource.cancel(reason);
   };
  }
  var autoAllocateChunkSize = underlyingByteSource.autoAllocateChunkSize;
  if (autoAllocateChunkSize === 0) {
   throw new TypeError('autoAllocateChunkSize must be greater than 0');
  }
  SetUpReadableByteStreamController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, autoAllocateChunkSize);
 }
 function SetUpReadableStreamBYOBRequest(request, controller, view) {
  request._associatedReadableByteStreamController = controller;
  request._view = view;
 }
 function byobRequestBrandCheckException(name) {
  return new TypeError("ReadableStreamBYOBRequest.prototype." + name + " can only be used on a ReadableStreamBYOBRequest");
 }
 function byteStreamControllerBrandCheckException(name) {
  return new TypeError("ReadableByteStreamController.prototype." + name + " can only be used on a ReadableByteStreamController");
 }
 function AcquireReadableStreamBYOBReader(stream) {
  return new ReadableStreamBYOBReader(stream);
 }
 function ReadableStreamAddReadIntoRequest(stream, readIntoRequest) {
  stream._reader._readIntoRequests.push(readIntoRequest);
 }
 function ReadableStreamFulfillReadIntoRequest(stream, chunk, done) {
  var reader = stream._reader;
  var readIntoRequest = reader._readIntoRequests.shift();
  if (done) {
   readIntoRequest._closeSteps(chunk);
  } else {
   readIntoRequest._chunkSteps(chunk);
  }
 }
 function ReadableStreamGetNumReadIntoRequests(stream) {
  return stream._reader._readIntoRequests.length;
 }
 function ReadableStreamHasBYOBReader(stream) {
  var reader = stream._reader;
  if (reader === undefined) {
   return false;
  }
  if (!IsReadableStreamBYOBReader(reader)) {
   return false;
  }
  return true;
 }
 var ReadableStreamBYOBReader = function () {
  function ReadableStreamBYOBReader(stream) {
   assertRequiredArgument(stream, 1, 'ReadableStreamBYOBReader');
   assertReadableStream(stream, 'First parameter');
   if (IsReadableStreamLocked(stream)) {
    throw new TypeError('This stream has already been locked for exclusive reading by another reader');
   }
   if (!IsReadableByteStreamController(stream._readableStreamController)) {
    throw new TypeError('Cannot construct a ReadableStreamBYOBReader for a stream not constructed with a byte ' + 'source');
   }
   ReadableStreamReaderGenericInitialize(this, stream);
   this._readIntoRequests = new SimpleQueue();
  }
  Object.defineProperty(ReadableStreamBYOBReader.prototype, "closed", {
   get: function () {
    if (!IsReadableStreamBYOBReader(this)) {
     return promiseRejectedWith(byobReaderBrandCheckException('closed'));
    }
    return this._closedPromise;
   },
   enumerable: false,
   configurable: true
  });
  ReadableStreamBYOBReader.prototype.cancel = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsReadableStreamBYOBReader(this)) {
    return promiseRejectedWith(byobReaderBrandCheckException('cancel'));
   }
   if (this._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('cancel'));
   }
   return ReadableStreamReaderGenericCancel(this, reason);
  };
  ReadableStreamBYOBReader.prototype.read = function (view) {
   if (!IsReadableStreamBYOBReader(this)) {
    return promiseRejectedWith(byobReaderBrandCheckException('read'));
   }
   if (!ArrayBuffer.isView(view)) {
    return promiseRejectedWith(new TypeError('view must be an array buffer view'));
   }
   if (view.byteLength === 0) {
    return promiseRejectedWith(new TypeError('view must have non-zero byteLength'));
   }
   if (view.buffer.byteLength === 0) {
    return promiseRejectedWith(new TypeError("view's buffer must have non-zero byteLength"));
   }
   if (this._ownerReadableStream === undefined) {
    return promiseRejectedWith(readerLockException('read from'));
   }
   var resolvePromise;
   var rejectPromise;
   var promise = newPromise(function (resolve, reject) {
    resolvePromise = resolve;
    rejectPromise = reject;
   });
   var readIntoRequest = {
    _chunkSteps: function (chunk) {
     return resolvePromise({
      value: chunk,
      done: false
     });
    },
    _closeSteps: function (chunk) {
     return resolvePromise({
      value: chunk,
      done: true
     });
    },
    _errorSteps: function (e) {
     return rejectPromise(e);
    }
   };
   ReadableStreamBYOBReaderRead(this, view, readIntoRequest);
   return promise;
  };
  ReadableStreamBYOBReader.prototype.releaseLock = function () {
   if (!IsReadableStreamBYOBReader(this)) {
    throw byobReaderBrandCheckException('releaseLock');
   }
   if (this._ownerReadableStream === undefined) {
    return;
   }
   if (this._readIntoRequests.length > 0) {
    throw new TypeError('Tried to release a reader lock when that reader has pending read() calls un-settled');
   }
   ReadableStreamReaderGenericRelease(this);
  };
  return ReadableStreamBYOBReader;
 }();
 Object.defineProperties(ReadableStreamBYOBReader.prototype, {
  cancel: { enumerable: true },
  read: { enumerable: true },
  releaseLock: { enumerable: true },
  closed: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableStreamBYOBReader.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableStreamBYOBReader',
   configurable: true
  });
 }
 function IsReadableStreamBYOBReader(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_readIntoRequests')) {
   return false;
  }
  return true;
 }
 function ReadableStreamBYOBReaderRead(reader, view, readIntoRequest) {
  var stream = reader._ownerReadableStream;
  stream._disturbed = true;
  if (stream._state === 'errored') {
   readIntoRequest._errorSteps(stream._storedError);
  } else {
   ReadableByteStreamControllerPullInto(stream._readableStreamController, view, readIntoRequest);
  }
 }
 function byobReaderBrandCheckException(name) {
  return new TypeError("ReadableStreamBYOBReader.prototype." + name + " can only be used on a ReadableStreamBYOBReader");
 }
 function ExtractHighWaterMark(strategy, defaultHWM) {
  var highWaterMark = strategy.highWaterMark;
  if (highWaterMark === undefined) {
   return defaultHWM;
  }
  if (NumberIsNaN(highWaterMark) || highWaterMark < 0) {
   throw new RangeError('Invalid highWaterMark');
  }
  return highWaterMark;
 }
 function ExtractSizeAlgorithm(strategy) {
  var size = strategy.size;
  if (!size) {
   return function () {
    return 1;
   };
  }
  return size;
 }
 function convertQueuingStrategy(init, context) {
  assertDictionary(init, context);
  var highWaterMark = init === null || init === void 0 ? void 0 : init.highWaterMark;
  var size = init === null || init === void 0 ? void 0 : init.size;
  return {
   highWaterMark: highWaterMark === undefined ? undefined : convertUnrestrictedDouble(highWaterMark),
   size: size === undefined ? undefined : convertQueuingStrategySize(size, context + " has member 'size' that")
  };
 }
 function convertQueuingStrategySize(fn, context) {
  assertFunction(fn, context);
  return function (chunk) {
   return convertUnrestrictedDouble(fn(chunk));
  };
 }
 function convertUnderlyingSink(original, context) {
  assertDictionary(original, context);
  var abort = original === null || original === void 0 ? void 0 : original.abort;
  var close = original === null || original === void 0 ? void 0 : original.close;
  var start = original === null || original === void 0 ? void 0 : original.start;
  var type = original === null || original === void 0 ? void 0 : original.type;
  var write = original === null || original === void 0 ? void 0 : original.write;
  return {
   abort: abort === undefined ? undefined : convertUnderlyingSinkAbortCallback(abort, original, context + " has member 'abort' that"),
   close: close === undefined ? undefined : convertUnderlyingSinkCloseCallback(close, original, context + " has member 'close' that"),
   start: start === undefined ? undefined : convertUnderlyingSinkStartCallback(start, original, context + " has member 'start' that"),
   write: write === undefined ? undefined : convertUnderlyingSinkWriteCallback(write, original, context + " has member 'write' that"),
   type: type
  };
 }
 function convertUnderlyingSinkAbortCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (reason) {
   return promiseCall(fn, original, [reason]);
  };
 }
 function convertUnderlyingSinkCloseCallback(fn, original, context) {
  assertFunction(fn, context);
  return function () {
   return promiseCall(fn, original, []);
  };
 }
 function convertUnderlyingSinkStartCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (controller) {
   return reflectCall(fn, original, [controller]);
  };
 }
 function convertUnderlyingSinkWriteCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (chunk, controller) {
   return promiseCall(fn, original, [
    chunk,
    controller
   ]);
  };
 }
 function assertWritableStream(x, context) {
  if (!IsWritableStream(x)) {
   throw new TypeError(context + " is not a WritableStream.");
  }
 }
 var WritableStream = function () {
  function WritableStream(rawUnderlyingSink, rawStrategy) {
   if (rawUnderlyingSink === void 0) {
    rawUnderlyingSink = {};
   }
   if (rawStrategy === void 0) {
    rawStrategy = {};
   }
   if (rawUnderlyingSink === undefined) {
    rawUnderlyingSink = null;
   } else {
    assertObject(rawUnderlyingSink, 'First parameter');
   }
   var strategy = convertQueuingStrategy(rawStrategy, 'Second parameter');
   var underlyingSink = convertUnderlyingSink(rawUnderlyingSink, 'First parameter');
   InitializeWritableStream(this);
   var type = underlyingSink.type;
   if (type !== undefined) {
    throw new RangeError('Invalid type is specified');
   }
   var sizeAlgorithm = ExtractSizeAlgorithm(strategy);
   var highWaterMark = ExtractHighWaterMark(strategy, 1);
   SetUpWritableStreamDefaultControllerFromUnderlyingSink(this, underlyingSink, highWaterMark, sizeAlgorithm);
  }
  Object.defineProperty(WritableStream.prototype, "locked", {
   get: function () {
    if (!IsWritableStream(this)) {
     throw streamBrandCheckException$2('locked');
    }
    return IsWritableStreamLocked(this);
   },
   enumerable: false,
   configurable: true
  });
  WritableStream.prototype.abort = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsWritableStream(this)) {
    return promiseRejectedWith(streamBrandCheckException$2('abort'));
   }
   if (IsWritableStreamLocked(this)) {
    return promiseRejectedWith(new TypeError('Cannot abort a stream that already has a writer'));
   }
   return WritableStreamAbort(this, reason);
  };
  WritableStream.prototype.close = function () {
   if (!IsWritableStream(this)) {
    return promiseRejectedWith(streamBrandCheckException$2('close'));
   }
   if (IsWritableStreamLocked(this)) {
    return promiseRejectedWith(new TypeError('Cannot close a stream that already has a writer'));
   }
   if (WritableStreamCloseQueuedOrInFlight(this)) {
    return promiseRejectedWith(new TypeError('Cannot close an already-closing stream'));
   }
   return WritableStreamClose(this);
  };
  WritableStream.prototype.getWriter = function () {
   if (!IsWritableStream(this)) {
    throw streamBrandCheckException$2('getWriter');
   }
   return AcquireWritableStreamDefaultWriter(this);
  };
  return WritableStream;
 }();
 Object.defineProperties(WritableStream.prototype, {
  abort: { enumerable: true },
  close: { enumerable: true },
  getWriter: { enumerable: true },
  locked: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(WritableStream.prototype, SymbolPolyfill.toStringTag, {
   value: 'WritableStream',
   configurable: true
  });
 }
 function AcquireWritableStreamDefaultWriter(stream) {
  return new WritableStreamDefaultWriter(stream);
 }
 function CreateWritableStream(startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm) {
  if (highWaterMark === void 0) {
   highWaterMark = 1;
  }
  if (sizeAlgorithm === void 0) {
   sizeAlgorithm = function () {
    return 1;
   };
  }
  var stream = Object.create(WritableStream.prototype);
  InitializeWritableStream(stream);
  var controller = Object.create(WritableStreamDefaultController.prototype);
  SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);
  return stream;
 }
 function InitializeWritableStream(stream) {
  stream._state = 'writable';
  stream._storedError = undefined;
  stream._writer = undefined;
  stream._writableStreamController = undefined;
  stream._writeRequests = new SimpleQueue();
  stream._inFlightWriteRequest = undefined;
  stream._closeRequest = undefined;
  stream._inFlightCloseRequest = undefined;
  stream._pendingAbortRequest = undefined;
  stream._backpressure = false;
 }
 function IsWritableStream(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_writableStreamController')) {
   return false;
  }
  return true;
 }
 function IsWritableStreamLocked(stream) {
  if (stream._writer === undefined) {
   return false;
  }
  return true;
 }
 function WritableStreamAbort(stream, reason) {
  var state = stream._state;
  if (state === 'closed' || state === 'errored') {
   return promiseResolvedWith(undefined);
  }
  if (stream._pendingAbortRequest !== undefined) {
   return stream._pendingAbortRequest._promise;
  }
  var wasAlreadyErroring = false;
  if (state === 'erroring') {
   wasAlreadyErroring = true;
   reason = undefined;
  }
  var promise = newPromise(function (resolve, reject) {
   stream._pendingAbortRequest = {
    _promise: undefined,
    _resolve: resolve,
    _reject: reject,
    _reason: reason,
    _wasAlreadyErroring: wasAlreadyErroring
   };
  });
  stream._pendingAbortRequest._promise = promise;
  if (!wasAlreadyErroring) {
   WritableStreamStartErroring(stream, reason);
  }
  return promise;
 }
 function WritableStreamClose(stream) {
  var state = stream._state;
  if (state === 'closed' || state === 'errored') {
   return promiseRejectedWith(new TypeError("The stream (in " + state + " state) is not in the writable state and cannot be closed"));
  }
  var promise = newPromise(function (resolve, reject) {
   var closeRequest = {
    _resolve: resolve,
    _reject: reject
   };
   stream._closeRequest = closeRequest;
  });
  var writer = stream._writer;
  if (writer !== undefined && stream._backpressure && state === 'writable') {
   defaultWriterReadyPromiseResolve(writer);
  }
  WritableStreamDefaultControllerClose(stream._writableStreamController);
  return promise;
 }
 function WritableStreamAddWriteRequest(stream) {
  var promise = newPromise(function (resolve, reject) {
   var writeRequest = {
    _resolve: resolve,
    _reject: reject
   };
   stream._writeRequests.push(writeRequest);
  });
  return promise;
 }
 function WritableStreamDealWithRejection(stream, error) {
  var state = stream._state;
  if (state === 'writable') {
   WritableStreamStartErroring(stream, error);
   return;
  }
  WritableStreamFinishErroring(stream);
 }
 function WritableStreamStartErroring(stream, reason) {
  var controller = stream._writableStreamController;
  stream._state = 'erroring';
  stream._storedError = reason;
  var writer = stream._writer;
  if (writer !== undefined) {
   WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, reason);
  }
  if (!WritableStreamHasOperationMarkedInFlight(stream) && controller._started) {
   WritableStreamFinishErroring(stream);
  }
 }
 function WritableStreamFinishErroring(stream) {
  stream._state = 'errored';
  stream._writableStreamController[ErrorSteps]();
  var storedError = stream._storedError;
  stream._writeRequests.forEach(function (writeRequest) {
   writeRequest._reject(storedError);
  });
  stream._writeRequests = new SimpleQueue();
  if (stream._pendingAbortRequest === undefined) {
   WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
   return;
  }
  var abortRequest = stream._pendingAbortRequest;
  stream._pendingAbortRequest = undefined;
  if (abortRequest._wasAlreadyErroring) {
   abortRequest._reject(storedError);
   WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
   return;
  }
  var promise = stream._writableStreamController[AbortSteps](abortRequest._reason);
  uponPromise(promise, function () {
   abortRequest._resolve();
   WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
  }, function (reason) {
   abortRequest._reject(reason);
   WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream);
  });
 }
 function WritableStreamFinishInFlightWrite(stream) {
  stream._inFlightWriteRequest._resolve(undefined);
  stream._inFlightWriteRequest = undefined;
 }
 function WritableStreamFinishInFlightWriteWithError(stream, error) {
  stream._inFlightWriteRequest._reject(error);
  stream._inFlightWriteRequest = undefined;
  WritableStreamDealWithRejection(stream, error);
 }
 function WritableStreamFinishInFlightClose(stream) {
  stream._inFlightCloseRequest._resolve(undefined);
  stream._inFlightCloseRequest = undefined;
  var state = stream._state;
  if (state === 'erroring') {
   stream._storedError = undefined;
   if (stream._pendingAbortRequest !== undefined) {
    stream._pendingAbortRequest._resolve();
    stream._pendingAbortRequest = undefined;
   }
  }
  stream._state = 'closed';
  var writer = stream._writer;
  if (writer !== undefined) {
   defaultWriterClosedPromiseResolve(writer);
  }
 }
 function WritableStreamFinishInFlightCloseWithError(stream, error) {
  stream._inFlightCloseRequest._reject(error);
  stream._inFlightCloseRequest = undefined;
  if (stream._pendingAbortRequest !== undefined) {
   stream._pendingAbortRequest._reject(error);
   stream._pendingAbortRequest = undefined;
  }
  WritableStreamDealWithRejection(stream, error);
 }
 function WritableStreamCloseQueuedOrInFlight(stream) {
  if (stream._closeRequest === undefined && stream._inFlightCloseRequest === undefined) {
   return false;
  }
  return true;
 }
 function WritableStreamHasOperationMarkedInFlight(stream) {
  if (stream._inFlightWriteRequest === undefined && stream._inFlightCloseRequest === undefined) {
   return false;
  }
  return true;
 }
 function WritableStreamMarkCloseRequestInFlight(stream) {
  stream._inFlightCloseRequest = stream._closeRequest;
  stream._closeRequest = undefined;
 }
 function WritableStreamMarkFirstWriteRequestInFlight(stream) {
  stream._inFlightWriteRequest = stream._writeRequests.shift();
 }
 function WritableStreamRejectCloseAndClosedPromiseIfNeeded(stream) {
  if (stream._closeRequest !== undefined) {
   stream._closeRequest._reject(stream._storedError);
   stream._closeRequest = undefined;
  }
  var writer = stream._writer;
  if (writer !== undefined) {
   defaultWriterClosedPromiseReject(writer, stream._storedError);
  }
 }
 function WritableStreamUpdateBackpressure(stream, backpressure) {
  var writer = stream._writer;
  if (writer !== undefined && backpressure !== stream._backpressure) {
   if (backpressure) {
    defaultWriterReadyPromiseReset(writer);
   } else {
    defaultWriterReadyPromiseResolve(writer);
   }
  }
  stream._backpressure = backpressure;
 }
 var WritableStreamDefaultWriter = function () {
  function WritableStreamDefaultWriter(stream) {
   assertRequiredArgument(stream, 1, 'WritableStreamDefaultWriter');
   assertWritableStream(stream, 'First parameter');
   if (IsWritableStreamLocked(stream)) {
    throw new TypeError('This stream has already been locked for exclusive writing by another writer');
   }
   this._ownerWritableStream = stream;
   stream._writer = this;
   var state = stream._state;
   if (state === 'writable') {
    if (!WritableStreamCloseQueuedOrInFlight(stream) && stream._backpressure) {
     defaultWriterReadyPromiseInitialize(this);
    } else {
     defaultWriterReadyPromiseInitializeAsResolved(this);
    }
    defaultWriterClosedPromiseInitialize(this);
   } else if (state === 'erroring') {
    defaultWriterReadyPromiseInitializeAsRejected(this, stream._storedError);
    defaultWriterClosedPromiseInitialize(this);
   } else if (state === 'closed') {
    defaultWriterReadyPromiseInitializeAsResolved(this);
    defaultWriterClosedPromiseInitializeAsResolved(this);
   } else {
    var storedError = stream._storedError;
    defaultWriterReadyPromiseInitializeAsRejected(this, storedError);
    defaultWriterClosedPromiseInitializeAsRejected(this, storedError);
   }
  }
  Object.defineProperty(WritableStreamDefaultWriter.prototype, "closed", {
   get: function () {
    if (!IsWritableStreamDefaultWriter(this)) {
     return promiseRejectedWith(defaultWriterBrandCheckException('closed'));
    }
    return this._closedPromise;
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(WritableStreamDefaultWriter.prototype, "desiredSize", {
   get: function () {
    if (!IsWritableStreamDefaultWriter(this)) {
     throw defaultWriterBrandCheckException('desiredSize');
    }
    if (this._ownerWritableStream === undefined) {
     throw defaultWriterLockException('desiredSize');
    }
    return WritableStreamDefaultWriterGetDesiredSize(this);
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(WritableStreamDefaultWriter.prototype, "ready", {
   get: function () {
    if (!IsWritableStreamDefaultWriter(this)) {
     return promiseRejectedWith(defaultWriterBrandCheckException('ready'));
    }
    return this._readyPromise;
   },
   enumerable: false,
   configurable: true
  });
  WritableStreamDefaultWriter.prototype.abort = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsWritableStreamDefaultWriter(this)) {
    return promiseRejectedWith(defaultWriterBrandCheckException('abort'));
   }
   if (this._ownerWritableStream === undefined) {
    return promiseRejectedWith(defaultWriterLockException('abort'));
   }
   return WritableStreamDefaultWriterAbort(this, reason);
  };
  WritableStreamDefaultWriter.prototype.close = function () {
   if (!IsWritableStreamDefaultWriter(this)) {
    return promiseRejectedWith(defaultWriterBrandCheckException('close'));
   }
   var stream = this._ownerWritableStream;
   if (stream === undefined) {
    return promiseRejectedWith(defaultWriterLockException('close'));
   }
   if (WritableStreamCloseQueuedOrInFlight(stream)) {
    return promiseRejectedWith(new TypeError('Cannot close an already-closing stream'));
   }
   return WritableStreamDefaultWriterClose(this);
  };
  WritableStreamDefaultWriter.prototype.releaseLock = function () {
   if (!IsWritableStreamDefaultWriter(this)) {
    throw defaultWriterBrandCheckException('releaseLock');
   }
   var stream = this._ownerWritableStream;
   if (stream === undefined) {
    return;
   }
   WritableStreamDefaultWriterRelease(this);
  };
  WritableStreamDefaultWriter.prototype.write = function (chunk) {
   if (chunk === void 0) {
    chunk = undefined;
   }
   if (!IsWritableStreamDefaultWriter(this)) {
    return promiseRejectedWith(defaultWriterBrandCheckException('write'));
   }
   if (this._ownerWritableStream === undefined) {
    return promiseRejectedWith(defaultWriterLockException('write to'));
   }
   return WritableStreamDefaultWriterWrite(this, chunk);
  };
  return WritableStreamDefaultWriter;
 }();
 Object.defineProperties(WritableStreamDefaultWriter.prototype, {
  abort: { enumerable: true },
  close: { enumerable: true },
  releaseLock: { enumerable: true },
  write: { enumerable: true },
  closed: { enumerable: true },
  desiredSize: { enumerable: true },
  ready: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(WritableStreamDefaultWriter.prototype, SymbolPolyfill.toStringTag, {
   value: 'WritableStreamDefaultWriter',
   configurable: true
  });
 }
 function IsWritableStreamDefaultWriter(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_ownerWritableStream')) {
   return false;
  }
  return true;
 }
 function WritableStreamDefaultWriterAbort(writer, reason) {
  var stream = writer._ownerWritableStream;
  return WritableStreamAbort(stream, reason);
 }
 function WritableStreamDefaultWriterClose(writer) {
  var stream = writer._ownerWritableStream;
  return WritableStreamClose(stream);
 }
 function WritableStreamDefaultWriterCloseWithErrorPropagation(writer) {
  var stream = writer._ownerWritableStream;
  var state = stream._state;
  if (WritableStreamCloseQueuedOrInFlight(stream) || state === 'closed') {
   return promiseResolvedWith(undefined);
  }
  if (state === 'errored') {
   return promiseRejectedWith(stream._storedError);
  }
  return WritableStreamDefaultWriterClose(writer);
 }
 function WritableStreamDefaultWriterEnsureClosedPromiseRejected(writer, error) {
  if (writer._closedPromiseState === 'pending') {
   defaultWriterClosedPromiseReject(writer, error);
  } else {
   defaultWriterClosedPromiseResetToRejected(writer, error);
  }
 }
 function WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, error) {
  if (writer._readyPromiseState === 'pending') {
   defaultWriterReadyPromiseReject(writer, error);
  } else {
   defaultWriterReadyPromiseResetToRejected(writer, error);
  }
 }
 function WritableStreamDefaultWriterGetDesiredSize(writer) {
  var stream = writer._ownerWritableStream;
  var state = stream._state;
  if (state === 'errored' || state === 'erroring') {
   return null;
  }
  if (state === 'closed') {
   return 0;
  }
  return WritableStreamDefaultControllerGetDesiredSize(stream._writableStreamController);
 }
 function WritableStreamDefaultWriterRelease(writer) {
  var stream = writer._ownerWritableStream;
  var releasedError = new TypeError("Writer was released and can no longer be used to monitor the stream's closedness");
  WritableStreamDefaultWriterEnsureReadyPromiseRejected(writer, releasedError);
  WritableStreamDefaultWriterEnsureClosedPromiseRejected(writer, releasedError);
  stream._writer = undefined;
  writer._ownerWritableStream = undefined;
 }
 function WritableStreamDefaultWriterWrite(writer, chunk) {
  var stream = writer._ownerWritableStream;
  var controller = stream._writableStreamController;
  var chunkSize = WritableStreamDefaultControllerGetChunkSize(controller, chunk);
  if (stream !== writer._ownerWritableStream) {
   return promiseRejectedWith(defaultWriterLockException('write to'));
  }
  var state = stream._state;
  if (state === 'errored') {
   return promiseRejectedWith(stream._storedError);
  }
  if (WritableStreamCloseQueuedOrInFlight(stream) || state === 'closed') {
   return promiseRejectedWith(new TypeError('The stream is closing or closed and cannot be written to'));
  }
  if (state === 'erroring') {
   return promiseRejectedWith(stream._storedError);
  }
  var promise = WritableStreamAddWriteRequest(stream);
  WritableStreamDefaultControllerWrite(controller, chunk, chunkSize);
  return promise;
 }
 var closeSentinel = {};
 var WritableStreamDefaultController = function () {
  function WritableStreamDefaultController() {
   throw new TypeError('Illegal constructor');
  }
  WritableStreamDefaultController.prototype.error = function (e) {
   if (e === void 0) {
    e = undefined;
   }
   if (!IsWritableStreamDefaultController(this)) {
    throw new TypeError('WritableStreamDefaultController.prototype.error can only be used on a WritableStreamDefaultController');
   }
   var state = this._controlledWritableStream._state;
   if (state !== 'writable') {
    return;
   }
   WritableStreamDefaultControllerError(this, e);
  };
  WritableStreamDefaultController.prototype[AbortSteps] = function (reason) {
   var result = this._abortAlgorithm(reason);
   WritableStreamDefaultControllerClearAlgorithms(this);
   return result;
  };
  WritableStreamDefaultController.prototype[ErrorSteps] = function () {
   ResetQueue(this);
  };
  return WritableStreamDefaultController;
 }();
 Object.defineProperties(WritableStreamDefaultController.prototype, { error: { enumerable: true } });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(WritableStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
   value: 'WritableStreamDefaultController',
   configurable: true
  });
 }
 function IsWritableStreamDefaultController(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_controlledWritableStream')) {
   return false;
  }
  return true;
 }
 function SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm) {
  controller._controlledWritableStream = stream;
  stream._writableStreamController = controller;
  controller._queue = undefined;
  controller._queueTotalSize = undefined;
  ResetQueue(controller);
  controller._started = false;
  controller._strategySizeAlgorithm = sizeAlgorithm;
  controller._strategyHWM = highWaterMark;
  controller._writeAlgorithm = writeAlgorithm;
  controller._closeAlgorithm = closeAlgorithm;
  controller._abortAlgorithm = abortAlgorithm;
  var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
  WritableStreamUpdateBackpressure(stream, backpressure);
  var startResult = startAlgorithm();
  var startPromise = promiseResolvedWith(startResult);
  uponPromise(startPromise, function () {
   controller._started = true;
   WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
  }, function (r) {
   controller._started = true;
   WritableStreamDealWithRejection(stream, r);
  });
 }
 function SetUpWritableStreamDefaultControllerFromUnderlyingSink(stream, underlyingSink, highWaterMark, sizeAlgorithm) {
  var controller = Object.create(WritableStreamDefaultController.prototype);
  var startAlgorithm = function () {
   return undefined;
  };
  var writeAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  var closeAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  var abortAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  if (underlyingSink.start !== undefined) {
   startAlgorithm = function () {
    return underlyingSink.start(controller);
   };
  }
  if (underlyingSink.write !== undefined) {
   writeAlgorithm = function (chunk) {
    return underlyingSink.write(chunk, controller);
   };
  }
  if (underlyingSink.close !== undefined) {
   closeAlgorithm = function () {
    return underlyingSink.close();
   };
  }
  if (underlyingSink.abort !== undefined) {
   abortAlgorithm = function (reason) {
    return underlyingSink.abort(reason);
   };
  }
  SetUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);
 }
 function WritableStreamDefaultControllerClearAlgorithms(controller) {
  controller._writeAlgorithm = undefined;
  controller._closeAlgorithm = undefined;
  controller._abortAlgorithm = undefined;
  controller._strategySizeAlgorithm = undefined;
 }
 function WritableStreamDefaultControllerClose(controller) {
  EnqueueValueWithSize(controller, closeSentinel, 0);
  WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
 }
 function WritableStreamDefaultControllerGetChunkSize(controller, chunk) {
  try {
   return controller._strategySizeAlgorithm(chunk);
  } catch (chunkSizeE) {
   WritableStreamDefaultControllerErrorIfNeeded(controller, chunkSizeE);
   return 1;
  }
 }
 function WritableStreamDefaultControllerGetDesiredSize(controller) {
  return controller._strategyHWM - controller._queueTotalSize;
 }
 function WritableStreamDefaultControllerWrite(controller, chunk, chunkSize) {
  try {
   EnqueueValueWithSize(controller, chunk, chunkSize);
  } catch (enqueueE) {
   WritableStreamDefaultControllerErrorIfNeeded(controller, enqueueE);
   return;
  }
  var stream = controller._controlledWritableStream;
  if (!WritableStreamCloseQueuedOrInFlight(stream) && stream._state === 'writable') {
   var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
   WritableStreamUpdateBackpressure(stream, backpressure);
  }
  WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
 }
 function WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller) {
  var stream = controller._controlledWritableStream;
  if (!controller._started) {
   return;
  }
  if (stream._inFlightWriteRequest !== undefined) {
   return;
  }
  var state = stream._state;
  if (state === 'erroring') {
   WritableStreamFinishErroring(stream);
   return;
  }
  if (controller._queue.length === 0) {
   return;
  }
  var value = PeekQueueValue(controller);
  if (value === closeSentinel) {
   WritableStreamDefaultControllerProcessClose(controller);
  } else {
   WritableStreamDefaultControllerProcessWrite(controller, value);
  }
 }
 function WritableStreamDefaultControllerErrorIfNeeded(controller, error) {
  if (controller._controlledWritableStream._state === 'writable') {
   WritableStreamDefaultControllerError(controller, error);
  }
 }
 function WritableStreamDefaultControllerProcessClose(controller) {
  var stream = controller._controlledWritableStream;
  WritableStreamMarkCloseRequestInFlight(stream);
  DequeueValue(controller);
  var sinkClosePromise = controller._closeAlgorithm();
  WritableStreamDefaultControllerClearAlgorithms(controller);
  uponPromise(sinkClosePromise, function () {
   WritableStreamFinishInFlightClose(stream);
  }, function (reason) {
   WritableStreamFinishInFlightCloseWithError(stream, reason);
  });
 }
 function WritableStreamDefaultControllerProcessWrite(controller, chunk) {
  var stream = controller._controlledWritableStream;
  WritableStreamMarkFirstWriteRequestInFlight(stream);
  var sinkWritePromise = controller._writeAlgorithm(chunk);
  uponPromise(sinkWritePromise, function () {
   WritableStreamFinishInFlightWrite(stream);
   var state = stream._state;
   DequeueValue(controller);
   if (!WritableStreamCloseQueuedOrInFlight(stream) && state === 'writable') {
    var backpressure = WritableStreamDefaultControllerGetBackpressure(controller);
    WritableStreamUpdateBackpressure(stream, backpressure);
   }
   WritableStreamDefaultControllerAdvanceQueueIfNeeded(controller);
  }, function (reason) {
   if (stream._state === 'writable') {
    WritableStreamDefaultControllerClearAlgorithms(controller);
   }
   WritableStreamFinishInFlightWriteWithError(stream, reason);
  });
 }
 function WritableStreamDefaultControllerGetBackpressure(controller) {
  var desiredSize = WritableStreamDefaultControllerGetDesiredSize(controller);
  return desiredSize <= 0;
 }
 function WritableStreamDefaultControllerError(controller, error) {
  var stream = controller._controlledWritableStream;
  WritableStreamDefaultControllerClearAlgorithms(controller);
  WritableStreamStartErroring(stream, error);
 }
 function streamBrandCheckException$2(name) {
  return new TypeError("WritableStream.prototype." + name + " can only be used on a WritableStream");
 }
 function defaultWriterBrandCheckException(name) {
  return new TypeError("WritableStreamDefaultWriter.prototype." + name + " can only be used on a WritableStreamDefaultWriter");
 }
 function defaultWriterLockException(name) {
  return new TypeError('Cannot ' + name + ' a stream using a released writer');
 }
 function defaultWriterClosedPromiseInitialize(writer) {
  writer._closedPromise = newPromise(function (resolve, reject) {
   writer._closedPromise_resolve = resolve;
   writer._closedPromise_reject = reject;
   writer._closedPromiseState = 'pending';
  });
 }
 function defaultWriterClosedPromiseInitializeAsRejected(writer, reason) {
  defaultWriterClosedPromiseInitialize(writer);
  defaultWriterClosedPromiseReject(writer, reason);
 }
 function defaultWriterClosedPromiseInitializeAsResolved(writer) {
  defaultWriterClosedPromiseInitialize(writer);
  defaultWriterClosedPromiseResolve(writer);
 }
 function defaultWriterClosedPromiseReject(writer, reason) {
  if (writer._closedPromise_reject === undefined) {
   return;
  }
  setPromiseIsHandledToTrue(writer._closedPromise);
  writer._closedPromise_reject(reason);
  writer._closedPromise_resolve = undefined;
  writer._closedPromise_reject = undefined;
  writer._closedPromiseState = 'rejected';
 }
 function defaultWriterClosedPromiseResetToRejected(writer, reason) {
  defaultWriterClosedPromiseInitializeAsRejected(writer, reason);
 }
 function defaultWriterClosedPromiseResolve(writer) {
  if (writer._closedPromise_resolve === undefined) {
   return;
  }
  writer._closedPromise_resolve(undefined);
  writer._closedPromise_resolve = undefined;
  writer._closedPromise_reject = undefined;
  writer._closedPromiseState = 'resolved';
 }
 function defaultWriterReadyPromiseInitialize(writer) {
  writer._readyPromise = newPromise(function (resolve, reject) {
   writer._readyPromise_resolve = resolve;
   writer._readyPromise_reject = reject;
  });
  writer._readyPromiseState = 'pending';
 }
 function defaultWriterReadyPromiseInitializeAsRejected(writer, reason) {
  defaultWriterReadyPromiseInitialize(writer);
  defaultWriterReadyPromiseReject(writer, reason);
 }
 function defaultWriterReadyPromiseInitializeAsResolved(writer) {
  defaultWriterReadyPromiseInitialize(writer);
  defaultWriterReadyPromiseResolve(writer);
 }
 function defaultWriterReadyPromiseReject(writer, reason) {
  if (writer._readyPromise_reject === undefined) {
   return;
  }
  setPromiseIsHandledToTrue(writer._readyPromise);
  writer._readyPromise_reject(reason);
  writer._readyPromise_resolve = undefined;
  writer._readyPromise_reject = undefined;
  writer._readyPromiseState = 'rejected';
 }
 function defaultWriterReadyPromiseReset(writer) {
  defaultWriterReadyPromiseInitialize(writer);
 }
 function defaultWriterReadyPromiseResetToRejected(writer, reason) {
  defaultWriterReadyPromiseInitializeAsRejected(writer, reason);
 }
 function defaultWriterReadyPromiseResolve(writer) {
  if (writer._readyPromise_resolve === undefined) {
   return;
  }
  writer._readyPromise_resolve(undefined);
  writer._readyPromise_resolve = undefined;
  writer._readyPromise_reject = undefined;
  writer._readyPromiseState = 'fulfilled';
 }
 function isAbortSignal(value) {
  if (typeof value !== 'object' || value === null) {
   return false;
  }
  try {
   return typeof value.aborted === 'boolean';
  } catch (_a) {
   return false;
  }
 }
 var NativeDOMException = typeof DOMException !== 'undefined' ? DOMException : undefined;
 function isDOMExceptionConstructor(ctor) {
  if (!(typeof ctor === 'function' || typeof ctor === 'object')) {
   return false;
  }
  try {
   new ctor();
   return true;
  } catch (_a) {
   return false;
  }
 }
 function createDOMExceptionPolyfill() {
  var ctor = function DOMException(message, name) {
   this.message = message || '';
   this.name = name || 'Error';
   if (Error.captureStackTrace) {
    Error.captureStackTrace(this, this.constructor);
   }
  };
  ctor.prototype = Object.create(Error.prototype);
  Object.defineProperty(ctor.prototype, 'constructor', {
   value: ctor,
   writable: true,
   configurable: true
  });
  return ctor;
 }
 var DOMException$1 = isDOMExceptionConstructor(NativeDOMException) ? NativeDOMException : createDOMExceptionPolyfill();
 function ReadableStreamPipeTo(source, dest, preventClose, preventAbort, preventCancel, signal) {
  var reader = AcquireReadableStreamDefaultReader(source);
  var writer = AcquireWritableStreamDefaultWriter(dest);
  source._disturbed = true;
  var shuttingDown = false;
  var currentWrite = promiseResolvedWith(undefined);
  return newPromise(function (resolve, reject) {
   var abortAlgorithm;
   if (signal !== undefined) {
    abortAlgorithm = function () {
     var error = new DOMException$1('Aborted', 'AbortError');
     var actions = [];
     if (!preventAbort) {
      actions.push(function () {
       if (dest._state === 'writable') {
        return WritableStreamAbort(dest, error);
       }
       return promiseResolvedWith(undefined);
      });
     }
     if (!preventCancel) {
      actions.push(function () {
       if (source._state === 'readable') {
        return ReadableStreamCancel(source, error);
       }
       return promiseResolvedWith(undefined);
      });
     }
     shutdownWithAction(function () {
      return Promise.all(actions.map(function (action) {
       return action();
      }));
     }, true, error);
    };
    if (signal.aborted) {
     abortAlgorithm();
     return;
    }
    signal.addEventListener('abort', abortAlgorithm);
   }
   function pipeLoop() {
    return newPromise(function (resolveLoop, rejectLoop) {
     function next(done) {
      if (done) {
       resolveLoop();
      } else {
       PerformPromiseThen(pipeStep(), next, rejectLoop);
      }
     }
     next(false);
    });
   }
   function pipeStep() {
    if (shuttingDown) {
     return promiseResolvedWith(true);
    }
    return PerformPromiseThen(writer._readyPromise, function () {
     return newPromise(function (resolveRead, rejectRead) {
      ReadableStreamDefaultReaderRead(reader, {
       _chunkSteps: function (chunk) {
        currentWrite = PerformPromiseThen(WritableStreamDefaultWriterWrite(writer, chunk), undefined, noop);
        resolveRead(false);
       },
       _closeSteps: function () {
        return resolveRead(true);
       },
       _errorSteps: rejectRead
      });
     });
    });
   }
   isOrBecomesErrored(source, reader._closedPromise, function (storedError) {
    if (!preventAbort) {
     shutdownWithAction(function () {
      return WritableStreamAbort(dest, storedError);
     }, true, storedError);
    } else {
     shutdown(true, storedError);
    }
   });
   isOrBecomesErrored(dest, writer._closedPromise, function (storedError) {
    if (!preventCancel) {
     shutdownWithAction(function () {
      return ReadableStreamCancel(source, storedError);
     }, true, storedError);
    } else {
     shutdown(true, storedError);
    }
   });
   isOrBecomesClosed(source, reader._closedPromise, function () {
    if (!preventClose) {
     shutdownWithAction(function () {
      return WritableStreamDefaultWriterCloseWithErrorPropagation(writer);
     });
    } else {
     shutdown();
    }
   });
   if (WritableStreamCloseQueuedOrInFlight(dest) || dest._state === 'closed') {
    var destClosed_1 = new TypeError('the destination writable stream closed before all data could be piped to it');
    if (!preventCancel) {
     shutdownWithAction(function () {
      return ReadableStreamCancel(source, destClosed_1);
     }, true, destClosed_1);
    } else {
     shutdown(true, destClosed_1);
    }
   }
   setPromiseIsHandledToTrue(pipeLoop());
   function waitForWritesToFinish() {
    var oldCurrentWrite = currentWrite;
    return PerformPromiseThen(currentWrite, function () {
     return oldCurrentWrite !== currentWrite ? waitForWritesToFinish() : undefined;
    });
   }
   function isOrBecomesErrored(stream, promise, action) {
    if (stream._state === 'errored') {
     action(stream._storedError);
    } else {
     uponRejection(promise, action);
    }
   }
   function isOrBecomesClosed(stream, promise, action) {
    if (stream._state === 'closed') {
     action();
    } else {
     uponFulfillment(promise, action);
    }
   }
   function shutdownWithAction(action, originalIsError, originalError) {
    if (shuttingDown) {
     return;
    }
    shuttingDown = true;
    if (dest._state === 'writable' && !WritableStreamCloseQueuedOrInFlight(dest)) {
     uponFulfillment(waitForWritesToFinish(), doTheRest);
    } else {
     doTheRest();
    }
    function doTheRest() {
     uponPromise(action(), function () {
      return finalize(originalIsError, originalError);
     }, function (newError) {
      return finalize(true, newError);
     });
    }
   }
   function shutdown(isError, error) {
    if (shuttingDown) {
     return;
    }
    shuttingDown = true;
    if (dest._state === 'writable' && !WritableStreamCloseQueuedOrInFlight(dest)) {
     uponFulfillment(waitForWritesToFinish(), function () {
      return finalize(isError, error);
     });
    } else {
     finalize(isError, error);
    }
   }
   function finalize(isError, error) {
    WritableStreamDefaultWriterRelease(writer);
    ReadableStreamReaderGenericRelease(reader);
    if (signal !== undefined) {
     signal.removeEventListener('abort', abortAlgorithm);
    }
    if (isError) {
     reject(error);
    } else {
     resolve(undefined);
    }
   }
  });
 }
 var ReadableStreamDefaultController = function () {
  function ReadableStreamDefaultController() {
   throw new TypeError('Illegal constructor');
  }
  Object.defineProperty(ReadableStreamDefaultController.prototype, "desiredSize", {
   get: function () {
    if (!IsReadableStreamDefaultController(this)) {
     throw defaultControllerBrandCheckException$1('desiredSize');
    }
    return ReadableStreamDefaultControllerGetDesiredSize(this);
   },
   enumerable: false,
   configurable: true
  });
  ReadableStreamDefaultController.prototype.close = function () {
   if (!IsReadableStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException$1('close');
   }
   if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(this)) {
    throw new TypeError('The stream is not in a state that permits close');
   }
   ReadableStreamDefaultControllerClose(this);
  };
  ReadableStreamDefaultController.prototype.enqueue = function (chunk) {
   if (chunk === void 0) {
    chunk = undefined;
   }
   if (!IsReadableStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException$1('enqueue');
   }
   if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(this)) {
    throw new TypeError('The stream is not in a state that permits enqueue');
   }
   return ReadableStreamDefaultControllerEnqueue(this, chunk);
  };
  ReadableStreamDefaultController.prototype.error = function (e) {
   if (e === void 0) {
    e = undefined;
   }
   if (!IsReadableStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException$1('error');
   }
   ReadableStreamDefaultControllerError(this, e);
  };
  ReadableStreamDefaultController.prototype[CancelSteps] = function (reason) {
   ResetQueue(this);
   var result = this._cancelAlgorithm(reason);
   ReadableStreamDefaultControllerClearAlgorithms(this);
   return result;
  };
  ReadableStreamDefaultController.prototype[PullSteps] = function (readRequest) {
   var stream = this._controlledReadableStream;
   if (this._queue.length > 0) {
    var chunk = DequeueValue(this);
    if (this._closeRequested && this._queue.length === 0) {
     ReadableStreamDefaultControllerClearAlgorithms(this);
     ReadableStreamClose(stream);
    } else {
     ReadableStreamDefaultControllerCallPullIfNeeded(this);
    }
    readRequest._chunkSteps(chunk);
   } else {
    ReadableStreamAddReadRequest(stream, readRequest);
    ReadableStreamDefaultControllerCallPullIfNeeded(this);
   }
  };
  return ReadableStreamDefaultController;
 }();
 Object.defineProperties(ReadableStreamDefaultController.prototype, {
  close: { enumerable: true },
  enqueue: { enumerable: true },
  error: { enumerable: true },
  desiredSize: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableStreamDefaultController',
   configurable: true
  });
 }
 function IsReadableStreamDefaultController(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_controlledReadableStream')) {
   return false;
  }
  return true;
 }
 function ReadableStreamDefaultControllerCallPullIfNeeded(controller) {
  var shouldPull = ReadableStreamDefaultControllerShouldCallPull(controller);
  if (!shouldPull) {
   return;
  }
  if (controller._pulling) {
   controller._pullAgain = true;
   return;
  }
  controller._pulling = true;
  var pullPromise = controller._pullAlgorithm();
  uponPromise(pullPromise, function () {
   controller._pulling = false;
   if (controller._pullAgain) {
    controller._pullAgain = false;
    ReadableStreamDefaultControllerCallPullIfNeeded(controller);
   }
  }, function (e) {
   ReadableStreamDefaultControllerError(controller, e);
  });
 }
 function ReadableStreamDefaultControllerShouldCallPull(controller) {
  var stream = controller._controlledReadableStream;
  if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
   return false;
  }
  if (!controller._started) {
   return false;
  }
  if (IsReadableStreamLocked(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
   return true;
  }
  var desiredSize = ReadableStreamDefaultControllerGetDesiredSize(controller);
  if (desiredSize > 0) {
   return true;
  }
  return false;
 }
 function ReadableStreamDefaultControllerClearAlgorithms(controller) {
  controller._pullAlgorithm = undefined;
  controller._cancelAlgorithm = undefined;
  controller._strategySizeAlgorithm = undefined;
 }
 function ReadableStreamDefaultControllerClose(controller) {
  if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
   return;
  }
  var stream = controller._controlledReadableStream;
  controller._closeRequested = true;
  if (controller._queue.length === 0) {
   ReadableStreamDefaultControllerClearAlgorithms(controller);
   ReadableStreamClose(stream);
  }
 }
 function ReadableStreamDefaultControllerEnqueue(controller, chunk) {
  if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(controller)) {
   return;
  }
  var stream = controller._controlledReadableStream;
  if (IsReadableStreamLocked(stream) && ReadableStreamGetNumReadRequests(stream) > 0) {
   ReadableStreamFulfillReadRequest(stream, chunk, false);
  } else {
   var chunkSize = void 0;
   try {
    chunkSize = controller._strategySizeAlgorithm(chunk);
   } catch (chunkSizeE) {
    ReadableStreamDefaultControllerError(controller, chunkSizeE);
    throw chunkSizeE;
   }
   try {
    EnqueueValueWithSize(controller, chunk, chunkSize);
   } catch (enqueueE) {
    ReadableStreamDefaultControllerError(controller, enqueueE);
    throw enqueueE;
   }
  }
  ReadableStreamDefaultControllerCallPullIfNeeded(controller);
 }
 function ReadableStreamDefaultControllerError(controller, e) {
  var stream = controller._controlledReadableStream;
  if (stream._state !== 'readable') {
   return;
  }
  ResetQueue(controller);
  ReadableStreamDefaultControllerClearAlgorithms(controller);
  ReadableStreamError(stream, e);
 }
 function ReadableStreamDefaultControllerGetDesiredSize(controller) {
  var state = controller._controlledReadableStream._state;
  if (state === 'errored') {
   return null;
  }
  if (state === 'closed') {
   return 0;
  }
  return controller._strategyHWM - controller._queueTotalSize;
 }
 function ReadableStreamDefaultControllerHasBackpressure(controller) {
  if (ReadableStreamDefaultControllerShouldCallPull(controller)) {
   return false;
  }
  return true;
 }
 function ReadableStreamDefaultControllerCanCloseOrEnqueue(controller) {
  var state = controller._controlledReadableStream._state;
  if (!controller._closeRequested && state === 'readable') {
   return true;
  }
  return false;
 }
 function SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm) {
  controller._controlledReadableStream = stream;
  controller._queue = undefined;
  controller._queueTotalSize = undefined;
  ResetQueue(controller);
  controller._started = false;
  controller._closeRequested = false;
  controller._pullAgain = false;
  controller._pulling = false;
  controller._strategySizeAlgorithm = sizeAlgorithm;
  controller._strategyHWM = highWaterMark;
  controller._pullAlgorithm = pullAlgorithm;
  controller._cancelAlgorithm = cancelAlgorithm;
  stream._readableStreamController = controller;
  var startResult = startAlgorithm();
  uponPromise(promiseResolvedWith(startResult), function () {
   controller._started = true;
   ReadableStreamDefaultControllerCallPullIfNeeded(controller);
  }, function (r) {
   ReadableStreamDefaultControllerError(controller, r);
  });
 }
 function SetUpReadableStreamDefaultControllerFromUnderlyingSource(stream, underlyingSource, highWaterMark, sizeAlgorithm) {
  var controller = Object.create(ReadableStreamDefaultController.prototype);
  var startAlgorithm = function () {
   return undefined;
  };
  var pullAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  var cancelAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  if (underlyingSource.start !== undefined) {
   startAlgorithm = function () {
    return underlyingSource.start(controller);
   };
  }
  if (underlyingSource.pull !== undefined) {
   pullAlgorithm = function () {
    return underlyingSource.pull(controller);
   };
  }
  if (underlyingSource.cancel !== undefined) {
   cancelAlgorithm = function (reason) {
    return underlyingSource.cancel(reason);
   };
  }
  SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm);
 }
 function defaultControllerBrandCheckException$1(name) {
  return new TypeError("ReadableStreamDefaultController.prototype." + name + " can only be used on a ReadableStreamDefaultController");
 }
 function ReadableStreamTee(stream, cloneForBranch2) {
  var reader = AcquireReadableStreamDefaultReader(stream);
  var reading = false;
  var canceled1 = false;
  var canceled2 = false;
  var reason1;
  var reason2;
  var branch1;
  var branch2;
  var resolveCancelPromise;
  var cancelPromise = newPromise(function (resolve) {
   resolveCancelPromise = resolve;
  });
  function pullAlgorithm() {
   if (reading) {
    return promiseResolvedWith(undefined);
   }
   reading = true;
   var readRequest = {
    _chunkSteps: function (value) {
     queueMicrotask(function () {
      reading = false;
      var value1 = value;
      var value2 = value;
      if (!canceled1) {
       ReadableStreamDefaultControllerEnqueue(branch1._readableStreamController, value1);
      }
      if (!canceled2) {
       ReadableStreamDefaultControllerEnqueue(branch2._readableStreamController, value2);
      }
     });
    },
    _closeSteps: function () {
     reading = false;
     if (!canceled1) {
      ReadableStreamDefaultControllerClose(branch1._readableStreamController);
     }
     if (!canceled2) {
      ReadableStreamDefaultControllerClose(branch2._readableStreamController);
     }
     if (!canceled1 || !canceled2) {
      resolveCancelPromise(undefined);
     }
    },
    _errorSteps: function () {
     reading = false;
    }
   };
   ReadableStreamDefaultReaderRead(reader, readRequest);
   return promiseResolvedWith(undefined);
  }
  function cancel1Algorithm(reason) {
   canceled1 = true;
   reason1 = reason;
   if (canceled2) {
    var compositeReason = CreateArrayFromList([
     reason1,
     reason2
    ]);
    var cancelResult = ReadableStreamCancel(stream, compositeReason);
    resolveCancelPromise(cancelResult);
   }
   return cancelPromise;
  }
  function cancel2Algorithm(reason) {
   canceled2 = true;
   reason2 = reason;
   if (canceled1) {
    var compositeReason = CreateArrayFromList([
     reason1,
     reason2
    ]);
    var cancelResult = ReadableStreamCancel(stream, compositeReason);
    resolveCancelPromise(cancelResult);
   }
   return cancelPromise;
  }
  function startAlgorithm() {
  }
  branch1 = CreateReadableStream(startAlgorithm, pullAlgorithm, cancel1Algorithm);
  branch2 = CreateReadableStream(startAlgorithm, pullAlgorithm, cancel2Algorithm);
  uponRejection(reader._closedPromise, function (r) {
   ReadableStreamDefaultControllerError(branch1._readableStreamController, r);
   ReadableStreamDefaultControllerError(branch2._readableStreamController, r);
   if (!canceled1 || !canceled2) {
    resolveCancelPromise(undefined);
   }
  });
  return [
   branch1,
   branch2
  ];
 }
 function convertUnderlyingDefaultOrByteSource(source, context) {
  assertDictionary(source, context);
  var original = source;
  var autoAllocateChunkSize = original === null || original === void 0 ? void 0 : original.autoAllocateChunkSize;
  var cancel = original === null || original === void 0 ? void 0 : original.cancel;
  var pull = original === null || original === void 0 ? void 0 : original.pull;
  var start = original === null || original === void 0 ? void 0 : original.start;
  var type = original === null || original === void 0 ? void 0 : original.type;
  return {
   autoAllocateChunkSize: autoAllocateChunkSize === undefined ? undefined : convertUnsignedLongLongWithEnforceRange(autoAllocateChunkSize, context + " has member 'autoAllocateChunkSize' that"),
   cancel: cancel === undefined ? undefined : convertUnderlyingSourceCancelCallback(cancel, original, context + " has member 'cancel' that"),
   pull: pull === undefined ? undefined : convertUnderlyingSourcePullCallback(pull, original, context + " has member 'pull' that"),
   start: start === undefined ? undefined : convertUnderlyingSourceStartCallback(start, original, context + " has member 'start' that"),
   type: type === undefined ? undefined : convertReadableStreamType(type, context + " has member 'type' that")
  };
 }
 function convertUnderlyingSourceCancelCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (reason) {
   return promiseCall(fn, original, [reason]);
  };
 }
 function convertUnderlyingSourcePullCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (controller) {
   return promiseCall(fn, original, [controller]);
  };
 }
 function convertUnderlyingSourceStartCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (controller) {
   return reflectCall(fn, original, [controller]);
  };
 }
 function convertReadableStreamType(type, context) {
  type = "" + type;
  if (type !== 'bytes') {
   throw new TypeError(context + " '" + type + "' is not a valid enumeration value for ReadableStreamType");
  }
  return type;
 }
 function convertReaderOptions(options, context) {
  assertDictionary(options, context);
  var mode = options === null || options === void 0 ? void 0 : options.mode;
  return { mode: mode === undefined ? undefined : convertReadableStreamReaderMode(mode, context + " has member 'mode' that") };
 }
 function convertReadableStreamReaderMode(mode, context) {
  mode = "" + mode;
  if (mode !== 'byob') {
   throw new TypeError(context + " '" + mode + "' is not a valid enumeration value for ReadableStreamReaderMode");
  }
  return mode;
 }
 function convertIteratorOptions(options, context) {
  assertDictionary(options, context);
  var preventCancel = options === null || options === void 0 ? void 0 : options.preventCancel;
  return { preventCancel: Boolean(preventCancel) };
 }
 function convertPipeOptions(options, context) {
  assertDictionary(options, context);
  var preventAbort = options === null || options === void 0 ? void 0 : options.preventAbort;
  var preventCancel = options === null || options === void 0 ? void 0 : options.preventCancel;
  var preventClose = options === null || options === void 0 ? void 0 : options.preventClose;
  var signal = options === null || options === void 0 ? void 0 : options.signal;
  if (signal !== undefined) {
   assertAbortSignal(signal, context + " has member 'signal' that");
  }
  return {
   preventAbort: Boolean(preventAbort),
   preventCancel: Boolean(preventCancel),
   preventClose: Boolean(preventClose),
   signal: signal
  };
 }
 function assertAbortSignal(signal, context) {
  if (!isAbortSignal(signal)) {
   throw new TypeError(context + " is not an AbortSignal.");
  }
 }
 function convertReadableWritablePair(pair, context) {
  assertDictionary(pair, context);
  var readable = pair === null || pair === void 0 ? void 0 : pair.readable;
  assertRequiredField(readable, 'readable', 'ReadableWritablePair');
  assertReadableStream(readable, context + " has member 'readable' that");
  var writable = pair === null || pair === void 0 ? void 0 : pair.writable;
  assertRequiredField(writable, 'writable', 'ReadableWritablePair');
  assertWritableStream(writable, context + " has member 'writable' that");
  return {
   readable: readable,
   writable: writable
  };
 }
 var ReadableStream = function () {
  function ReadableStream(rawUnderlyingSource, rawStrategy) {
   if (rawUnderlyingSource === void 0) {
    rawUnderlyingSource = {};
   }
   if (rawStrategy === void 0) {
    rawStrategy = {};
   }
   if (rawUnderlyingSource === undefined) {
    rawUnderlyingSource = null;
   } else {
    assertObject(rawUnderlyingSource, 'First parameter');
   }
   var strategy = convertQueuingStrategy(rawStrategy, 'Second parameter');
   var underlyingSource = convertUnderlyingDefaultOrByteSource(rawUnderlyingSource, 'First parameter');
   InitializeReadableStream(this);
   if (underlyingSource.type === 'bytes') {
    if (strategy.size !== undefined) {
     throw new RangeError('The strategy for a byte stream cannot have a size function');
    }
    var highWaterMark = ExtractHighWaterMark(strategy, 0);
    SetUpReadableByteStreamControllerFromUnderlyingSource(this, underlyingSource, highWaterMark);
   } else {
    var sizeAlgorithm = ExtractSizeAlgorithm(strategy);
    var highWaterMark = ExtractHighWaterMark(strategy, 1);
    SetUpReadableStreamDefaultControllerFromUnderlyingSource(this, underlyingSource, highWaterMark, sizeAlgorithm);
   }
  }
  Object.defineProperty(ReadableStream.prototype, "locked", {
   get: function () {
    if (!IsReadableStream(this)) {
     throw streamBrandCheckException$1('locked');
    }
    return IsReadableStreamLocked(this);
   },
   enumerable: false,
   configurable: true
  });
  ReadableStream.prototype.cancel = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsReadableStream(this)) {
    return promiseRejectedWith(streamBrandCheckException$1('cancel'));
   }
   if (IsReadableStreamLocked(this)) {
    return promiseRejectedWith(new TypeError('Cannot cancel a stream that already has a reader'));
   }
   return ReadableStreamCancel(this, reason);
  };
  ReadableStream.prototype.getReader = function (rawOptions) {
   if (rawOptions === void 0) {
    rawOptions = undefined;
   }
   if (!IsReadableStream(this)) {
    throw streamBrandCheckException$1('getReader');
   }
   var options = convertReaderOptions(rawOptions, 'First parameter');
   if (options.mode === undefined) {
    return AcquireReadableStreamDefaultReader(this);
   }
   return AcquireReadableStreamBYOBReader(this);
  };
  ReadableStream.prototype.pipeThrough = function (rawTransform, rawOptions) {
   if (rawOptions === void 0) {
    rawOptions = {};
   }
   if (!IsReadableStream(this)) {
    throw streamBrandCheckException$1('pipeThrough');
   }
   assertRequiredArgument(rawTransform, 1, 'pipeThrough');
   var transform = convertReadableWritablePair(rawTransform, 'First parameter');
   var options = convertPipeOptions(rawOptions, 'Second parameter');
   if (IsReadableStreamLocked(this)) {
    throw new TypeError('ReadableStream.prototype.pipeThrough cannot be used on a locked ReadableStream');
   }
   if (IsWritableStreamLocked(transform.writable)) {
    throw new TypeError('ReadableStream.prototype.pipeThrough cannot be used on a locked WritableStream');
   }
   var promise = ReadableStreamPipeTo(this, transform.writable, options.preventClose, options.preventAbort, options.preventCancel, options.signal);
   setPromiseIsHandledToTrue(promise);
   return transform.readable;
  };
  ReadableStream.prototype.pipeTo = function (destination, rawOptions) {
   if (rawOptions === void 0) {
    rawOptions = {};
   }
   if (!IsReadableStream(this)) {
    return promiseRejectedWith(streamBrandCheckException$1('pipeTo'));
   }
   if (destination === undefined) {
    return promiseRejectedWith("Parameter 1 is required in 'pipeTo'.");
   }
   if (!IsWritableStream(destination)) {
    return promiseRejectedWith(new TypeError("ReadableStream.prototype.pipeTo's first argument must be a WritableStream"));
   }
   var options;
   try {
    options = convertPipeOptions(rawOptions, 'Second parameter');
   } catch (e) {
    return promiseRejectedWith(e);
   }
   if (IsReadableStreamLocked(this)) {
    return promiseRejectedWith(new TypeError('ReadableStream.prototype.pipeTo cannot be used on a locked ReadableStream'));
   }
   if (IsWritableStreamLocked(destination)) {
    return promiseRejectedWith(new TypeError('ReadableStream.prototype.pipeTo cannot be used on a locked WritableStream'));
   }
   return ReadableStreamPipeTo(this, destination, options.preventClose, options.preventAbort, options.preventCancel, options.signal);
  };
  ReadableStream.prototype.tee = function () {
   if (!IsReadableStream(this)) {
    throw streamBrandCheckException$1('tee');
   }
   var branches = ReadableStreamTee(this);
   return CreateArrayFromList(branches);
  };
  ReadableStream.prototype.values = function (rawOptions) {
   if (rawOptions === void 0) {
    rawOptions = undefined;
   }
   if (!IsReadableStream(this)) {
    throw streamBrandCheckException$1('values');
   }
   var options = convertIteratorOptions(rawOptions, 'First parameter');
   return AcquireReadableStreamAsyncIterator(this, options.preventCancel);
  };
  return ReadableStream;
 }();
 Object.defineProperties(ReadableStream.prototype, {
  cancel: { enumerable: true },
  getReader: { enumerable: true },
  pipeThrough: { enumerable: true },
  pipeTo: { enumerable: true },
  tee: { enumerable: true },
  values: { enumerable: true },
  locked: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ReadableStream.prototype, SymbolPolyfill.toStringTag, {
   value: 'ReadableStream',
   configurable: true
  });
 }
 if (typeof SymbolPolyfill.asyncIterator === 'symbol') {
  Object.defineProperty(ReadableStream.prototype, SymbolPolyfill.asyncIterator, {
   value: ReadableStream.prototype.values,
   writable: true,
   configurable: true
  });
 }
 function CreateReadableStream(startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm) {
  if (highWaterMark === void 0) {
   highWaterMark = 1;
  }
  if (sizeAlgorithm === void 0) {
   sizeAlgorithm = function () {
    return 1;
   };
  }
  var stream = Object.create(ReadableStream.prototype);
  InitializeReadableStream(stream);
  var controller = Object.create(ReadableStreamDefaultController.prototype);
  SetUpReadableStreamDefaultController(stream, controller, startAlgorithm, pullAlgorithm, cancelAlgorithm, highWaterMark, sizeAlgorithm);
  return stream;
 }
 function InitializeReadableStream(stream) {
  stream._state = 'readable';
  stream._reader = undefined;
  stream._storedError = undefined;
  stream._disturbed = false;
 }
 function IsReadableStream(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_readableStreamController')) {
   return false;
  }
  return true;
 }
 function IsReadableStreamLocked(stream) {
  if (stream._reader === undefined) {
   return false;
  }
  return true;
 }
 function ReadableStreamCancel(stream, reason) {
  stream._disturbed = true;
  if (stream._state === 'closed') {
   return promiseResolvedWith(undefined);
  }
  if (stream._state === 'errored') {
   return promiseRejectedWith(stream._storedError);
  }
  ReadableStreamClose(stream);
  var sourceCancelPromise = stream._readableStreamController[CancelSteps](reason);
  return transformPromiseWith(sourceCancelPromise, noop);
 }
 function ReadableStreamClose(stream) {
  stream._state = 'closed';
  var reader = stream._reader;
  if (reader === undefined) {
   return;
  }
  defaultReaderClosedPromiseResolve(reader);
  if (IsReadableStreamDefaultReader(reader)) {
   reader._readRequests.forEach(function (readRequest) {
    readRequest._closeSteps();
   });
   reader._readRequests = new SimpleQueue();
  }
 }
 function ReadableStreamError(stream, e) {
  stream._state = 'errored';
  stream._storedError = e;
  var reader = stream._reader;
  if (reader === undefined) {
   return;
  }
  defaultReaderClosedPromiseReject(reader, e);
  if (IsReadableStreamDefaultReader(reader)) {
   reader._readRequests.forEach(function (readRequest) {
    readRequest._errorSteps(e);
   });
   reader._readRequests = new SimpleQueue();
  } else {
   reader._readIntoRequests.forEach(function (readIntoRequest) {
    readIntoRequest._errorSteps(e);
   });
   reader._readIntoRequests = new SimpleQueue();
  }
 }
 function streamBrandCheckException$1(name) {
  return new TypeError("ReadableStream.prototype." + name + " can only be used on a ReadableStream");
 }
 function convertQueuingStrategyInit(init, context) {
  assertDictionary(init, context);
  var highWaterMark = init === null || init === void 0 ? void 0 : init.highWaterMark;
  assertRequiredField(highWaterMark, 'highWaterMark', 'QueuingStrategyInit');
  return { highWaterMark: convertUnrestrictedDouble(highWaterMark) };
 }
 var byteLengthSizeFunction = function size(chunk) {
  return chunk.byteLength;
 };
 var ByteLengthQueuingStrategy = function () {
  function ByteLengthQueuingStrategy(options) {
   assertRequiredArgument(options, 1, 'ByteLengthQueuingStrategy');
   options = convertQueuingStrategyInit(options, 'First parameter');
   this._byteLengthQueuingStrategyHighWaterMark = options.highWaterMark;
  }
  Object.defineProperty(ByteLengthQueuingStrategy.prototype, "highWaterMark", {
   get: function () {
    if (!IsByteLengthQueuingStrategy(this)) {
     throw byteLengthBrandCheckException('highWaterMark');
    }
    return this._byteLengthQueuingStrategyHighWaterMark;
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(ByteLengthQueuingStrategy.prototype, "size", {
   get: function () {
    if (!IsByteLengthQueuingStrategy(this)) {
     throw byteLengthBrandCheckException('size');
    }
    return byteLengthSizeFunction;
   },
   enumerable: false,
   configurable: true
  });
  return ByteLengthQueuingStrategy;
 }();
 Object.defineProperties(ByteLengthQueuingStrategy.prototype, {
  highWaterMark: { enumerable: true },
  size: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(ByteLengthQueuingStrategy.prototype, SymbolPolyfill.toStringTag, {
   value: 'ByteLengthQueuingStrategy',
   configurable: true
  });
 }
 function byteLengthBrandCheckException(name) {
  return new TypeError("ByteLengthQueuingStrategy.prototype." + name + " can only be used on a ByteLengthQueuingStrategy");
 }
 function IsByteLengthQueuingStrategy(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_byteLengthQueuingStrategyHighWaterMark')) {
   return false;
  }
  return true;
 }
 var countSizeFunction = function size() {
  return 1;
 };
 var CountQueuingStrategy = function () {
  function CountQueuingStrategy(options) {
   assertRequiredArgument(options, 1, 'CountQueuingStrategy');
   options = convertQueuingStrategyInit(options, 'First parameter');
   this._countQueuingStrategyHighWaterMark = options.highWaterMark;
  }
  Object.defineProperty(CountQueuingStrategy.prototype, "highWaterMark", {
   get: function () {
    if (!IsCountQueuingStrategy(this)) {
     throw countBrandCheckException('highWaterMark');
    }
    return this._countQueuingStrategyHighWaterMark;
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(CountQueuingStrategy.prototype, "size", {
   get: function () {
    if (!IsCountQueuingStrategy(this)) {
     throw countBrandCheckException('size');
    }
    return countSizeFunction;
   },
   enumerable: false,
   configurable: true
  });
  return CountQueuingStrategy;
 }();
 Object.defineProperties(CountQueuingStrategy.prototype, {
  highWaterMark: { enumerable: true },
  size: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(CountQueuingStrategy.prototype, SymbolPolyfill.toStringTag, {
   value: 'CountQueuingStrategy',
   configurable: true
  });
 }
 function countBrandCheckException(name) {
  return new TypeError("CountQueuingStrategy.prototype." + name + " can only be used on a CountQueuingStrategy");
 }
 function IsCountQueuingStrategy(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_countQueuingStrategyHighWaterMark')) {
   return false;
  }
  return true;
 }
 function convertTransformer(original, context) {
  assertDictionary(original, context);
  var flush = original === null || original === void 0 ? void 0 : original.flush;
  var readableType = original === null || original === void 0 ? void 0 : original.readableType;
  var start = original === null || original === void 0 ? void 0 : original.start;
  var transform = original === null || original === void 0 ? void 0 : original.transform;
  var writableType = original === null || original === void 0 ? void 0 : original.writableType;
  return {
   flush: flush === undefined ? undefined : convertTransformerFlushCallback(flush, original, context + " has member 'flush' that"),
   readableType: readableType,
   start: start === undefined ? undefined : convertTransformerStartCallback(start, original, context + " has member 'start' that"),
   transform: transform === undefined ? undefined : convertTransformerTransformCallback(transform, original, context + " has member 'transform' that"),
   writableType: writableType
  };
 }
 function convertTransformerFlushCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (controller) {
   return promiseCall(fn, original, [controller]);
  };
 }
 function convertTransformerStartCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (controller) {
   return reflectCall(fn, original, [controller]);
  };
 }
 function convertTransformerTransformCallback(fn, original, context) {
  assertFunction(fn, context);
  return function (chunk, controller) {
   return promiseCall(fn, original, [
    chunk,
    controller
   ]);
  };
 }
 var TransformStream = function () {
  function TransformStream(rawTransformer, rawWritableStrategy, rawReadableStrategy) {
   if (rawTransformer === void 0) {
    rawTransformer = {};
   }
   if (rawWritableStrategy === void 0) {
    rawWritableStrategy = {};
   }
   if (rawReadableStrategy === void 0) {
    rawReadableStrategy = {};
   }
   if (rawTransformer === undefined) {
    rawTransformer = null;
   }
   var writableStrategy = convertQueuingStrategy(rawWritableStrategy, 'Second parameter');
   var readableStrategy = convertQueuingStrategy(rawReadableStrategy, 'Third parameter');
   var transformer = convertTransformer(rawTransformer, 'First parameter');
   if (transformer.readableType !== undefined) {
    throw new RangeError('Invalid readableType specified');
   }
   if (transformer.writableType !== undefined) {
    throw new RangeError('Invalid writableType specified');
   }
   var readableHighWaterMark = ExtractHighWaterMark(readableStrategy, 0);
   var readableSizeAlgorithm = ExtractSizeAlgorithm(readableStrategy);
   var writableHighWaterMark = ExtractHighWaterMark(writableStrategy, 1);
   var writableSizeAlgorithm = ExtractSizeAlgorithm(writableStrategy);
   var startPromise_resolve;
   var startPromise = newPromise(function (resolve) {
    startPromise_resolve = resolve;
   });
   InitializeTransformStream(this, startPromise, writableHighWaterMark, writableSizeAlgorithm, readableHighWaterMark, readableSizeAlgorithm);
   SetUpTransformStreamDefaultControllerFromTransformer(this, transformer);
   if (transformer.start !== undefined) {
    startPromise_resolve(transformer.start(this._transformStreamController));
   } else {
    startPromise_resolve(undefined);
   }
  }
  Object.defineProperty(TransformStream.prototype, "readable", {
   get: function () {
    if (!IsTransformStream(this)) {
     throw streamBrandCheckException('readable');
    }
    return this._readable;
   },
   enumerable: false,
   configurable: true
  });
  Object.defineProperty(TransformStream.prototype, "writable", {
   get: function () {
    if (!IsTransformStream(this)) {
     throw streamBrandCheckException('writable');
    }
    return this._writable;
   },
   enumerable: false,
   configurable: true
  });
  return TransformStream;
 }();
 Object.defineProperties(TransformStream.prototype, {
  readable: { enumerable: true },
  writable: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(TransformStream.prototype, SymbolPolyfill.toStringTag, {
   value: 'TransformStream',
   configurable: true
  });
 }
 function InitializeTransformStream(stream, startPromise, writableHighWaterMark, writableSizeAlgorithm, readableHighWaterMark, readableSizeAlgorithm) {
  function startAlgorithm() {
   return startPromise;
  }
  function writeAlgorithm(chunk) {
   return TransformStreamDefaultSinkWriteAlgorithm(stream, chunk);
  }
  function abortAlgorithm(reason) {
   return TransformStreamDefaultSinkAbortAlgorithm(stream, reason);
  }
  function closeAlgorithm() {
   return TransformStreamDefaultSinkCloseAlgorithm(stream);
  }
  stream._writable = CreateWritableStream(startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, writableHighWaterMark, writableSizeAlgorithm);
  function pullAlgorithm() {
   return TransformStreamDefaultSourcePullAlgorithm(stream);
  }
  function cancelAlgorithm(reason) {
   TransformStreamErrorWritableAndUnblockWrite(stream, reason);
   return promiseResolvedWith(undefined);
  }
  stream._readable = CreateReadableStream(startAlgorithm, pullAlgorithm, cancelAlgorithm, readableHighWaterMark, readableSizeAlgorithm);
  stream._backpressure = undefined;
  stream._backpressureChangePromise = undefined;
  stream._backpressureChangePromise_resolve = undefined;
  TransformStreamSetBackpressure(stream, true);
  stream._transformStreamController = undefined;
 }
 function IsTransformStream(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_transformStreamController')) {
   return false;
  }
  return true;
 }
 function TransformStreamError(stream, e) {
  ReadableStreamDefaultControllerError(stream._readable._readableStreamController, e);
  TransformStreamErrorWritableAndUnblockWrite(stream, e);
 }
 function TransformStreamErrorWritableAndUnblockWrite(stream, e) {
  TransformStreamDefaultControllerClearAlgorithms(stream._transformStreamController);
  WritableStreamDefaultControllerErrorIfNeeded(stream._writable._writableStreamController, e);
  if (stream._backpressure) {
   TransformStreamSetBackpressure(stream, false);
  }
 }
 function TransformStreamSetBackpressure(stream, backpressure) {
  if (stream._backpressureChangePromise !== undefined) {
   stream._backpressureChangePromise_resolve();
  }
  stream._backpressureChangePromise = newPromise(function (resolve) {
   stream._backpressureChangePromise_resolve = resolve;
  });
  stream._backpressure = backpressure;
 }
 var TransformStreamDefaultController = function () {
  function TransformStreamDefaultController() {
   throw new TypeError('Illegal constructor');
  }
  Object.defineProperty(TransformStreamDefaultController.prototype, "desiredSize", {
   get: function () {
    if (!IsTransformStreamDefaultController(this)) {
     throw defaultControllerBrandCheckException('desiredSize');
    }
    var readableController = this._controlledTransformStream._readable._readableStreamController;
    return ReadableStreamDefaultControllerGetDesiredSize(readableController);
   },
   enumerable: false,
   configurable: true
  });
  TransformStreamDefaultController.prototype.enqueue = function (chunk) {
   if (chunk === void 0) {
    chunk = undefined;
   }
   if (!IsTransformStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException('enqueue');
   }
   TransformStreamDefaultControllerEnqueue(this, chunk);
  };
  TransformStreamDefaultController.prototype.error = function (reason) {
   if (reason === void 0) {
    reason = undefined;
   }
   if (!IsTransformStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException('error');
   }
   TransformStreamDefaultControllerError(this, reason);
  };
  TransformStreamDefaultController.prototype.terminate = function () {
   if (!IsTransformStreamDefaultController(this)) {
    throw defaultControllerBrandCheckException('terminate');
   }
   TransformStreamDefaultControllerTerminate(this);
  };
  return TransformStreamDefaultController;
 }();
 Object.defineProperties(TransformStreamDefaultController.prototype, {
  enqueue: { enumerable: true },
  error: { enumerable: true },
  terminate: { enumerable: true },
  desiredSize: { enumerable: true }
 });
 if (typeof SymbolPolyfill.toStringTag === 'symbol') {
  Object.defineProperty(TransformStreamDefaultController.prototype, SymbolPolyfill.toStringTag, {
   value: 'TransformStreamDefaultController',
   configurable: true
  });
 }
 function IsTransformStreamDefaultController(x) {
  if (!typeIsObject(x)) {
   return false;
  }
  if (!Object.prototype.hasOwnProperty.call(x, '_controlledTransformStream')) {
   return false;
  }
  return true;
 }
 function SetUpTransformStreamDefaultController(stream, controller, transformAlgorithm, flushAlgorithm) {
  controller._controlledTransformStream = stream;
  stream._transformStreamController = controller;
  controller._transformAlgorithm = transformAlgorithm;
  controller._flushAlgorithm = flushAlgorithm;
 }
 function SetUpTransformStreamDefaultControllerFromTransformer(stream, transformer) {
  var controller = Object.create(TransformStreamDefaultController.prototype);
  var transformAlgorithm = function (chunk) {
   try {
    TransformStreamDefaultControllerEnqueue(controller, chunk);
    return promiseResolvedWith(undefined);
   } catch (transformResultE) {
    return promiseRejectedWith(transformResultE);
   }
  };
  var flushAlgorithm = function () {
   return promiseResolvedWith(undefined);
  };
  if (transformer.transform !== undefined) {
   transformAlgorithm = function (chunk) {
    return transformer.transform(chunk, controller);
   };
  }
  if (transformer.flush !== undefined) {
   flushAlgorithm = function () {
    return transformer.flush(controller);
   };
  }
  SetUpTransformStreamDefaultController(stream, controller, transformAlgorithm, flushAlgorithm);
 }
 function TransformStreamDefaultControllerClearAlgorithms(controller) {
  controller._transformAlgorithm = undefined;
  controller._flushAlgorithm = undefined;
 }
 function TransformStreamDefaultControllerEnqueue(controller, chunk) {
  var stream = controller._controlledTransformStream;
  var readableController = stream._readable._readableStreamController;
  if (!ReadableStreamDefaultControllerCanCloseOrEnqueue(readableController)) {
   throw new TypeError('Readable side is not in a state that permits enqueue');
  }
  try {
   ReadableStreamDefaultControllerEnqueue(readableController, chunk);
  } catch (e) {
   TransformStreamErrorWritableAndUnblockWrite(stream, e);
   throw stream._readable._storedError;
  }
  var backpressure = ReadableStreamDefaultControllerHasBackpressure(readableController);
  if (backpressure !== stream._backpressure) {
   TransformStreamSetBackpressure(stream, true);
  }
 }
 function TransformStreamDefaultControllerError(controller, e) {
  TransformStreamError(controller._controlledTransformStream, e);
 }
 function TransformStreamDefaultControllerPerformTransform(controller, chunk) {
  var transformPromise = controller._transformAlgorithm(chunk);
  return transformPromiseWith(transformPromise, undefined, function (r) {
   TransformStreamError(controller._controlledTransformStream, r);
   throw r;
  });
 }
 function TransformStreamDefaultControllerTerminate(controller) {
  var stream = controller._controlledTransformStream;
  var readableController = stream._readable._readableStreamController;
  ReadableStreamDefaultControllerClose(readableController);
  var error = new TypeError('TransformStream terminated');
  TransformStreamErrorWritableAndUnblockWrite(stream, error);
 }
 function TransformStreamDefaultSinkWriteAlgorithm(stream, chunk) {
  var controller = stream._transformStreamController;
  if (stream._backpressure) {
   var backpressureChangePromise = stream._backpressureChangePromise;
   return transformPromiseWith(backpressureChangePromise, function () {
    var writable = stream._writable;
    var state = writable._state;
    if (state === 'erroring') {
     throw writable._storedError;
    }
    return TransformStreamDefaultControllerPerformTransform(controller, chunk);
   });
  }
  return TransformStreamDefaultControllerPerformTransform(controller, chunk);
 }
 function TransformStreamDefaultSinkAbortAlgorithm(stream, reason) {
  TransformStreamError(stream, reason);
  return promiseResolvedWith(undefined);
 }
 function TransformStreamDefaultSinkCloseAlgorithm(stream) {
  var readable = stream._readable;
  var controller = stream._transformStreamController;
  var flushPromise = controller._flushAlgorithm();
  TransformStreamDefaultControllerClearAlgorithms(controller);
  return transformPromiseWith(flushPromise, function () {
   if (readable._state === 'errored') {
    throw readable._storedError;
   }
   ReadableStreamDefaultControllerClose(readable._readableStreamController);
  }, function (r) {
   TransformStreamError(stream, r);
   throw readable._storedError;
  });
 }
 function TransformStreamDefaultSourcePullAlgorithm(stream) {
  TransformStreamSetBackpressure(stream, false);
  return stream._backpressureChangePromise;
 }
 function defaultControllerBrandCheckException(name) {
  return new TypeError("TransformStreamDefaultController.prototype." + name + " can only be used on a TransformStreamDefaultController");
 }
 function streamBrandCheckException(name) {
  return new TypeError("TransformStream.prototype." + name + " can only be used on a TransformStream");
 }
 exports.ByteLengthQueuingStrategy = ByteLengthQueuingStrategy;
 exports.CountQueuingStrategy = CountQueuingStrategy;
 exports.ReadableByteStreamController = ReadableByteStreamController;
 exports.ReadableStream = ReadableStream;
 exports.ReadableStreamBYOBReader = ReadableStreamBYOBReader;
 exports.ReadableStreamBYOBRequest = ReadableStreamBYOBRequest;
 exports.ReadableStreamDefaultController = ReadableStreamDefaultController;
 exports.ReadableStreamDefaultReader = ReadableStreamDefaultReader;
 exports.TransformStream = TransformStream;
 exports.TransformStreamDefaultController = TransformStreamDefaultController;
 exports.WritableStream = WritableStream;
 exports.WritableStreamDefaultController = WritableStreamDefaultController;
 exports.WritableStreamDefaultWriter = WritableStreamDefaultWriter;
 Object.defineProperty(exports, '__esModule', { value: true });
}));

/***/ }),
/* 113 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.clearPrimitiveCaches = clearPrimitiveCaches;
exports.isCmd = isCmd;
exports.isDict = isDict;
exports.isEOF = isEOF;
exports.isName = isName;
exports.isRef = isRef;
exports.isRefsEqual = isRefsEqual;
exports.isStream = isStream;
exports.RefSetCache = exports.RefSet = exports.Ref = exports.Name = exports.EOF = exports.Dict = exports.Cmd = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _base_stream = __w_pdfjs_require__(114);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var EOF = {};
exports.EOF = EOF;

var Name = function NameClosure() {
  var nameCache = Object.create(null);

  var Name = /*#__PURE__*/function () {
    function Name(name) {
      _classCallCheck(this, Name);

      this.name = name;
    }

    _createClass(Name, null, [{
      key: "get",
      value: function get(name) {
        var nameValue = nameCache[name];
        return nameValue ? nameValue : nameCache[name] = new Name(name);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        nameCache = Object.create(null);
      }
    }]);

    return Name;
  }();

  return Name;
}();

exports.Name = Name;

var Cmd = function CmdClosure() {
  var cmdCache = Object.create(null);

  var Cmd = /*#__PURE__*/function () {
    function Cmd(cmd) {
      _classCallCheck(this, Cmd);

      this.cmd = cmd;
    }

    _createClass(Cmd, null, [{
      key: "get",
      value: function get(cmd) {
        var cmdValue = cmdCache[cmd];
        return cmdValue ? cmdValue : cmdCache[cmd] = new Cmd(cmd);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        cmdCache = Object.create(null);
      }
    }]);

    return Cmd;
  }();

  return Cmd;
}();

exports.Cmd = Cmd;

var nonSerializable = function nonSerializableClosure() {
  return nonSerializable;
};

var Dict = /*#__PURE__*/function () {
  function Dict() {
    var xref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    _classCallCheck(this, Dict);

    this._map = Object.create(null);
    this.xref = xref;
    this.objId = null;
    this.suppressEncryption = false;
    this.__nonSerializable__ = nonSerializable;
  }

  _createClass(Dict, [{
    key: "assignXref",
    value: function assignXref(newXref) {
      this.xref = newXref;
    }
  }, {
    key: "size",
    get: function get() {
      return Object.keys(this._map).length;
    }
  }, {
    key: "get",
    value: function get(key1, key2, key3) {
      var value = this._map[key1];

      if (value === undefined && key2 !== undefined) {
        value = this._map[key2];

        if (value === undefined && key3 !== undefined) {
          value = this._map[key3];
        }
      }

      if (value instanceof Ref && this.xref) {
        return this.xref.fetch(value, this.suppressEncryption);
      }

      return value;
    }
  }, {
    key: "getAsync",
    value: function () {
      var _getAsync = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(key1, key2, key3) {
        var value;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                value = this._map[key1];

                if (value === undefined && key2 !== undefined) {
                  value = this._map[key2];

                  if (value === undefined && key3 !== undefined) {
                    value = this._map[key3];
                  }
                }

                if (!(value instanceof Ref && this.xref)) {
                  _context.next = 4;
                  break;
                }

                return _context.abrupt("return", this.xref.fetchAsync(value, this.suppressEncryption));

              case 4:
                return _context.abrupt("return", value);

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getAsync(_x, _x2, _x3) {
        return _getAsync.apply(this, arguments);
      }

      return getAsync;
    }()
  }, {
    key: "getArray",
    value: function getArray(key1, key2, key3) {
      var value = this._map[key1];

      if (value === undefined && key2 !== undefined) {
        value = this._map[key2];

        if (value === undefined && key3 !== undefined) {
          value = this._map[key3];
        }
      }

      if (value instanceof Ref && this.xref) {
        value = this.xref.fetch(value, this.suppressEncryption);
      }

      if (Array.isArray(value)) {
        value = value.slice();

        for (var i = 0, ii = value.length; i < ii; i++) {
          if (value[i] instanceof Ref && this.xref) {
            value[i] = this.xref.fetch(value[i], this.suppressEncryption);
          }
        }
      }

      return value;
    }
  }, {
    key: "getRaw",
    value: function getRaw(key) {
      return this._map[key];
    }
  }, {
    key: "getKeys",
    value: function getKeys() {
      return Object.keys(this._map);
    }
  }, {
    key: "getRawValues",
    value: function getRawValues() {
      return Object.values(this._map);
    }
  }, {
    key: "set",
    value: function set(key, value) {
      this._map[key] = value;
    }
  }, {
    key: "has",
    value: function has(key) {
      return this._map[key] !== undefined;
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      for (var key in this._map) {
        callback(key, this.get(key));
      }
    }
  }], [{
    key: "empty",
    get: function get() {
      var emptyDict = new Dict(null);

      emptyDict.set = function (key, value) {
        (0, _util.unreachable)("Should not call `set` on the empty dictionary.");
      };

      return (0, _util.shadow)(this, "empty", emptyDict);
    }
  }, {
    key: "merge",
    value: function merge(_ref) {
      var xref = _ref.xref,
          dictArray = _ref.dictArray,
          _ref$mergeSubDicts = _ref.mergeSubDicts,
          mergeSubDicts = _ref$mergeSubDicts === void 0 ? false : _ref$mergeSubDicts;
      var mergedDict = new Dict(xref);

      if (!mergeSubDicts) {
        var _iterator = _createForOfIteratorHelper(dictArray),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var dict = _step.value;

            if (!(dict instanceof Dict)) {
              continue;
            }

            for (var _i = 0, _Object$entries = Object.entries(dict._map); _i < _Object$entries.length; _i++) {
              var _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
                  key = _Object$entries$_i[0],
                  value = _Object$entries$_i[1];

              if (mergedDict._map[key] === undefined) {
                mergedDict._map[key] = value;
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        return mergedDict.size > 0 ? mergedDict : Dict.empty;
      }

      var properties = new Map();

      var _iterator2 = _createForOfIteratorHelper(dictArray),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _dict = _step2.value;

          if (!(_dict instanceof Dict)) {
            continue;
          }

          for (var _i2 = 0, _Object$entries2 = Object.entries(_dict._map); _i2 < _Object$entries2.length; _i2++) {
            var _Object$entries2$_i = _slicedToArray(_Object$entries2[_i2], 2),
                _key = _Object$entries2$_i[0],
                _value = _Object$entries2$_i[1];

            var property = properties.get(_key);

            if (property === undefined) {
              property = [];
              properties.set(_key, property);
            }

            property.push(_value);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      var _iterator3 = _createForOfIteratorHelper(properties),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _step3$value = _slicedToArray(_step3.value, 2),
              name = _step3$value[0],
              values = _step3$value[1];

          if (values.length === 1 || !(values[0] instanceof Dict)) {
            mergedDict._map[name] = values[0];
            continue;
          }

          var subDict = new Dict(xref);

          var _iterator4 = _createForOfIteratorHelper(values),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var _dict2 = _step4.value;

              if (!(_dict2 instanceof Dict)) {
                continue;
              }

              for (var _i3 = 0, _Object$entries3 = Object.entries(_dict2._map); _i3 < _Object$entries3.length; _i3++) {
                var _Object$entries3$_i = _slicedToArray(_Object$entries3[_i3], 2),
                    _key2 = _Object$entries3$_i[0],
                    _value2 = _Object$entries3$_i[1];

                if (subDict._map[_key2] === undefined) {
                  subDict._map[_key2] = _value2;
                }
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }

          if (subDict.size > 0) {
            mergedDict._map[name] = subDict;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      properties.clear();
      return mergedDict.size > 0 ? mergedDict : Dict.empty;
    }
  }]);

  return Dict;
}();

exports.Dict = Dict;

var Ref = function RefClosure() {
  var refCache = Object.create(null);

  var Ref = /*#__PURE__*/function () {
    function Ref(num, gen) {
      _classCallCheck(this, Ref);

      this.num = num;
      this.gen = gen;
    }

    _createClass(Ref, [{
      key: "toString",
      value: function toString() {
        if (this.gen === 0) {
          return "".concat(this.num, "R");
        }

        return "".concat(this.num, "R").concat(this.gen);
      }
    }], [{
      key: "get",
      value: function get(num, gen) {
        var key = gen === 0 ? "".concat(num, "R") : "".concat(num, "R").concat(gen);
        var refValue = refCache[key];
        return refValue ? refValue : refCache[key] = new Ref(num, gen);
      }
    }, {
      key: "_clearCache",
      value: function _clearCache() {
        refCache = Object.create(null);
      }
    }]);

    return Ref;
  }();

  return Ref;
}();

exports.Ref = Ref;

var RefSet = /*#__PURE__*/function () {
  function RefSet() {
    var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

    _classCallCheck(this, RefSet);

    this._set = new Set(parent && parent._set);
  }

  _createClass(RefSet, [{
    key: "has",
    value: function has(ref) {
      return this._set.has(ref.toString());
    }
  }, {
    key: "put",
    value: function put(ref) {
      this._set.add(ref.toString());
    }
  }, {
    key: "remove",
    value: function remove(ref) {
      this._set["delete"](ref.toString());
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator5 = _createForOfIteratorHelper(this._set.values()),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var ref = _step5.value;
          callback(ref);
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this._set.clear();
    }
  }]);

  return RefSet;
}();

exports.RefSet = RefSet;

var RefSetCache = /*#__PURE__*/function () {
  function RefSetCache() {
    _classCallCheck(this, RefSetCache);

    this._map = new Map();
  }

  _createClass(RefSetCache, [{
    key: "size",
    get: function get() {
      return this._map.size;
    }
  }, {
    key: "get",
    value: function get(ref) {
      return this._map.get(ref.toString());
    }
  }, {
    key: "has",
    value: function has(ref) {
      return this._map.has(ref.toString());
    }
  }, {
    key: "put",
    value: function put(ref, obj) {
      this._map.set(ref.toString(), obj);
    }
  }, {
    key: "putAlias",
    value: function putAlias(ref, aliasRef) {
      this._map.set(ref.toString(), this.get(aliasRef));
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator6 = _createForOfIteratorHelper(this._map.values()),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var value = _step6.value;
          callback(value);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this._map.clear();
    }
  }]);

  return RefSetCache;
}();

exports.RefSetCache = RefSetCache;

function isEOF(v) {
  return v === EOF;
}

function isName(v, name) {
  return v instanceof Name && (name === undefined || v.name === name);
}

function isCmd(v, cmd) {
  return v instanceof Cmd && (cmd === undefined || v.cmd === cmd);
}

function isDict(v, type) {
  return v instanceof Dict && (type === undefined || isName(v.get("Type"), type));
}

function isRef(v) {
  return v instanceof Ref;
}

function isRefsEqual(v1, v2) {
  return v1.num === v2.num && v1.gen === v2.gen;
}

function isStream(v) {
  return v instanceof _base_stream.BaseStream;
}

function clearPrimitiveCaches() {
  Cmd._clearCache();

  Name._clearCache();

  Ref._clearCache();
}

/***/ }),
/* 114 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.BaseStream = void 0;

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var BaseStream = /*#__PURE__*/function () {
  function BaseStream() {
    _classCallCheck(this, BaseStream);

    if (this.constructor === BaseStream) {
      (0, _util.unreachable)("Cannot initialize BaseStream.");
    }
  }

  _createClass(BaseStream, [{
    key: "length",
    get: function get() {
      (0, _util.unreachable)("Abstract getter `length` accessed");
    }
  }, {
    key: "isEmpty",
    get: function get() {
      (0, _util.unreachable)("Abstract getter `isEmpty` accessed");
    }
  }, {
    key: "isDataLoaded",
    get: function get() {
      return (0, _util.shadow)(this, "isDataLoaded", true);
    }
  }, {
    key: "getByte",
    value: function getByte() {
      (0, _util.unreachable)("Abstract method `getByte` called");
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      (0, _util.unreachable)("Abstract method `getBytes` called");
    }
  }, {
    key: "peekByte",
    value: function peekByte() {
      var peekedByte = this.getByte();

      if (peekedByte !== -1) {
        this.pos--;
      }

      return peekedByte;
    }
  }, {
    key: "peekBytes",
    value: function peekBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.getBytes(length, forceClamped);
      this.pos -= bytes.length;
      return bytes;
    }
  }, {
    key: "getUint16",
    value: function getUint16() {
      var b0 = this.getByte();
      var b1 = this.getByte();

      if (b0 === -1 || b1 === -1) {
        return -1;
      }

      return (b0 << 8) + b1;
    }
  }, {
    key: "getInt32",
    value: function getInt32() {
      var b0 = this.getByte();
      var b1 = this.getByte();
      var b2 = this.getByte();
      var b3 = this.getByte();
      return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      (0, _util.unreachable)("Abstract method `getByteRange` called");
    }
  }, {
    key: "getString",
    value: function getString(length) {
      return (0, _util.bytesToString)(this.getBytes(length, false));
    }
  }, {
    key: "skip",
    value: function skip(n) {
      this.pos += n || 1;
    }
  }, {
    key: "reset",
    value: function reset() {
      (0, _util.unreachable)("Abstract method `reset` called");
    }
  }, {
    key: "moveStart",
    value: function moveStart() {
      (0, _util.unreachable)("Abstract method `moveStart` called");
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      (0, _util.unreachable)("Abstract method `makeSubStream` called");
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      return null;
    }
  }]);

  return BaseStream;
}();

exports.BaseStream = BaseStream;

/***/ }),
/* 115 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.NetworkPdfManager = exports.LocalPdfManager = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _chunked_stream = __w_pdfjs_require__(116);

var _core_utils = __w_pdfjs_require__(117);

var _document = __w_pdfjs_require__(119);

var _stream = __w_pdfjs_require__(118);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function parseDocBaseUrl(url) {
  if (url) {
    var absoluteUrl = (0, _util.createValidAbsoluteUrl)(url);

    if (absoluteUrl) {
      return absoluteUrl.href;
    }

    (0, _util.warn)("Invalid absolute docBaseUrl: \"".concat(url, "\"."));
  }

  return null;
}

var BasePdfManager = /*#__PURE__*/function () {
  function BasePdfManager() {
    _classCallCheck(this, BasePdfManager);

    if (this.constructor === BasePdfManager) {
      (0, _util.unreachable)("Cannot initialize BasePdfManager.");
    }
  }

  _createClass(BasePdfManager, [{
    key: "docId",
    get: function get() {
      return this._docId;
    }
  }, {
    key: "password",
    get: function get() {
      return this._password;
    }
  }, {
    key: "docBaseUrl",
    get: function get() {
      return this._docBaseUrl;
    }
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      (0, _util.unreachable)("Abstract method `onLoadedStream` called");
    }
  }, {
    key: "ensureDoc",
    value: function ensureDoc(prop, args) {
      return this.ensure(this.pdfDocument, prop, args);
    }
  }, {
    key: "ensureXRef",
    value: function ensureXRef(prop, args) {
      return this.ensure(this.pdfDocument.xref, prop, args);
    }
  }, {
    key: "ensureCatalog",
    value: function ensureCatalog(prop, args) {
      return this.ensure(this.pdfDocument.catalog, prop, args);
    }
  }, {
    key: "getPage",
    value: function getPage(pageIndex) {
      return this.pdfDocument.getPage(pageIndex);
    }
  }, {
    key: "fontFallback",
    value: function fontFallback(id, handler) {
      return this.pdfDocument.fontFallback(id, handler);
    }
  }, {
    key: "loadXfaFonts",
    value: function loadXfaFonts(handler, task) {
      return this.pdfDocument.loadXfaFonts(handler, task);
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      var manuallyTriggered = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      return this.pdfDocument.cleanup(manuallyTriggered);
    }
  }, {
    key: "ensure",
    value: function () {
      var _ensure = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(obj, prop, args) {
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                (0, _util.unreachable)("Abstract method `ensure` called");

              case 1:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function ensure(_x, _x2, _x3) {
        return _ensure.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      (0, _util.unreachable)("Abstract method `requestRange` called");
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {
      (0, _util.unreachable)("Abstract method `requestLoadedStream` called");
    }
  }, {
    key: "sendProgressiveData",
    value: function sendProgressiveData(chunk) {
      (0, _util.unreachable)("Abstract method `sendProgressiveData` called");
    }
  }, {
    key: "updatePassword",
    value: function updatePassword(password) {
      this._password = password;
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {
      (0, _util.unreachable)("Abstract method `terminate` called");
    }
  }]);

  return BasePdfManager;
}();

var LocalPdfManager = /*#__PURE__*/function (_BasePdfManager) {
  _inherits(LocalPdfManager, _BasePdfManager);

  var _super = _createSuper(LocalPdfManager);

  function LocalPdfManager(docId, data, password, evaluatorOptions, enableXfa, docBaseUrl) {
    var _this;

    _classCallCheck(this, LocalPdfManager);

    _this = _super.call(this);
    _this._docId = docId;
    _this._password = password;
    _this._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    _this.evaluatorOptions = evaluatorOptions;
    _this.enableXfa = enableXfa;
    var stream = new _stream.Stream(data);
    _this.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this), stream);
    _this._loadedStreamPromise = Promise.resolve(stream);
    return _this;
  }

  _createClass(LocalPdfManager, [{
    key: "ensure",
    value: function () {
      var _ensure2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(obj, prop, args) {
        var value;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                value = obj[prop];

                if (!(typeof value === "function")) {
                  _context2.next = 3;
                  break;
                }

                return _context2.abrupt("return", value.apply(obj, args));

              case 3:
                return _context2.abrupt("return", value);

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function ensure(_x4, _x5, _x6) {
        return _ensure2.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      return Promise.resolve();
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {}
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this._loadedStreamPromise;
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {}
  }]);

  return LocalPdfManager;
}(BasePdfManager);

exports.LocalPdfManager = LocalPdfManager;

var NetworkPdfManager = /*#__PURE__*/function (_BasePdfManager2) {
  _inherits(NetworkPdfManager, _BasePdfManager2);

  var _super2 = _createSuper(NetworkPdfManager);

  function NetworkPdfManager(docId, pdfNetworkStream, args, evaluatorOptions, enableXfa, docBaseUrl) {
    var _this2;

    _classCallCheck(this, NetworkPdfManager);

    _this2 = _super2.call(this);
    _this2._docId = docId;
    _this2._password = args.password;
    _this2._docBaseUrl = parseDocBaseUrl(docBaseUrl);
    _this2.msgHandler = args.msgHandler;
    _this2.evaluatorOptions = evaluatorOptions;
    _this2.enableXfa = enableXfa;
    _this2.streamManager = new _chunked_stream.ChunkedStreamManager(pdfNetworkStream, {
      msgHandler: args.msgHandler,
      length: args.length,
      disableAutoFetch: args.disableAutoFetch,
      rangeChunkSize: args.rangeChunkSize
    });
    _this2.pdfDocument = new _document.PDFDocument(_assertThisInitialized(_this2), _this2.streamManager.getStream());
    return _this2;
  }

  _createClass(NetworkPdfManager, [{
    key: "ensure",
    value: function () {
      var _ensure3 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(obj, prop, args) {
        var value;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.prev = 0;
                value = obj[prop];

                if (!(typeof value === "function")) {
                  _context3.next = 4;
                  break;
                }

                return _context3.abrupt("return", value.apply(obj, args));

              case 4:
                return _context3.abrupt("return", value);

              case 7:
                _context3.prev = 7;
                _context3.t0 = _context3["catch"](0);

                if (_context3.t0 instanceof _core_utils.MissingDataException) {
                  _context3.next = 11;
                  break;
                }

                throw _context3.t0;

              case 11:
                _context3.next = 13;
                return this.requestRange(_context3.t0.begin, _context3.t0.end);

              case 13:
                return _context3.abrupt("return", this.ensure(obj, prop, args));

              case 14:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[0, 7]]);
      }));

      function ensure(_x7, _x8, _x9) {
        return _ensure3.apply(this, arguments);
      }

      return ensure;
    }()
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      return this.streamManager.requestRange(begin, end);
    }
  }, {
    key: "requestLoadedStream",
    value: function requestLoadedStream() {
      this.streamManager.requestAllChunks();
    }
  }, {
    key: "sendProgressiveData",
    value: function sendProgressiveData(chunk) {
      this.streamManager.onReceiveData({
        chunk: chunk
      });
    }
  }, {
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this.streamManager.onLoadedStream();
    }
  }, {
    key: "terminate",
    value: function terminate(reason) {
      this.streamManager.abort(reason);
    }
  }]);

  return NetworkPdfManager;
}(BasePdfManager);

exports.NetworkPdfManager = NetworkPdfManager;

/***/ }),
/* 116 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ChunkedStreamManager = exports.ChunkedStream = void 0;

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(117);

var _stream = __w_pdfjs_require__(118);

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var ChunkedStream = /*#__PURE__*/function (_Stream) {
  _inherits(ChunkedStream, _Stream);

  var _super = _createSuper(ChunkedStream);

  function ChunkedStream(length, chunkSize, manager) {
    var _this;

    _classCallCheck(this, ChunkedStream);

    _this = _super.call(this, new Uint8Array(length), 0, length, null);
    _this.chunkSize = chunkSize;
    _this._loadedChunks = new Set();
    _this.numChunks = Math.ceil(length / chunkSize);
    _this.manager = manager;
    _this.progressiveDataLength = 0;
    _this.lastSuccessfulEnsureByteChunk = -1;
    return _this;
  }

  _createClass(ChunkedStream, [{
    key: "getMissingChunks",
    value: function getMissingChunks() {
      var chunks = [];

      for (var chunk = 0, n = this.numChunks; chunk < n; ++chunk) {
        if (!this._loadedChunks.has(chunk)) {
          chunks.push(chunk);
        }
      }

      return chunks;
    }
  }, {
    key: "numChunksLoaded",
    get: function get() {
      return this._loadedChunks.size;
    }
  }, {
    key: "isDataLoaded",
    get: function get() {
      return this.numChunksLoaded === this.numChunks;
    }
  }, {
    key: "onReceiveData",
    value: function onReceiveData(begin, chunk) {
      var chunkSize = this.chunkSize;

      if (begin % chunkSize !== 0) {
        throw new Error("Bad begin offset: ".concat(begin));
      }

      var end = begin + chunk.byteLength;

      if (end % chunkSize !== 0 && end !== this.bytes.length) {
        throw new Error("Bad end offset: ".concat(end));
      }

      this.bytes.set(new Uint8Array(chunk), begin);
      var beginChunk = Math.floor(begin / chunkSize);
      var endChunk = Math.floor((end - 1) / chunkSize) + 1;

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        this._loadedChunks.add(curChunk);
      }
    }
  }, {
    key: "onReceiveProgressiveData",
    value: function onReceiveProgressiveData(data) {
      var position = this.progressiveDataLength;
      var beginChunk = Math.floor(position / this.chunkSize);
      this.bytes.set(new Uint8Array(data), position);
      position += data.byteLength;
      this.progressiveDataLength = position;
      var endChunk = position >= this.end ? this.numChunks : Math.floor(position / this.chunkSize);

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        this._loadedChunks.add(curChunk);
      }
    }
  }, {
    key: "ensureByte",
    value: function ensureByte(pos) {
      if (pos < this.progressiveDataLength) {
        return;
      }

      var chunk = Math.floor(pos / this.chunkSize);

      if (chunk === this.lastSuccessfulEnsureByteChunk) {
        return;
      }

      if (!this._loadedChunks.has(chunk)) {
        throw new _core_utils.MissingDataException(pos, pos + 1);
      }

      this.lastSuccessfulEnsureByteChunk = chunk;
    }
  }, {
    key: "ensureRange",
    value: function ensureRange(begin, end) {
      if (begin >= end) {
        return;
      }

      if (end <= this.progressiveDataLength) {
        return;
      }

      var chunkSize = this.chunkSize;
      var beginChunk = Math.floor(begin / chunkSize);
      var endChunk = Math.floor((end - 1) / chunkSize) + 1;

      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        if (!this._loadedChunks.has(chunk)) {
          throw new _core_utils.MissingDataException(begin, end);
        }
      }
    }
  }, {
    key: "nextEmptyChunk",
    value: function nextEmptyChunk(beginChunk) {
      var numChunks = this.numChunks;

      for (var i = 0; i < numChunks; ++i) {
        var chunk = (beginChunk + i) % numChunks;

        if (!this._loadedChunks.has(chunk)) {
          return chunk;
        }
      }

      return null;
    }
  }, {
    key: "hasChunk",
    value: function hasChunk(chunk) {
      return this._loadedChunks.has(chunk);
    }
  }, {
    key: "getByte",
    value: function getByte() {
      var pos = this.pos;

      if (pos >= this.end) {
        return -1;
      }

      if (pos >= this.progressiveDataLength) {
        this.ensureByte(pos);
      }

      return this.bytes[this.pos++];
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        if (strEnd > this.progressiveDataLength) {
          this.ensureRange(pos, strEnd);
        }

        var _subarray = bytes.subarray(pos, strEnd);

        return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
      }

      var end = pos + length;

      if (end > strEnd) {
        end = strEnd;
      }

      if (end > this.progressiveDataLength) {
        this.ensureRange(pos, end);
      }

      this.pos = end;
      var subarray = bytes.subarray(pos, end);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      if (begin < 0) {
        begin = 0;
      }

      if (end > this.end) {
        end = this.end;
      }

      if (end > this.progressiveDataLength) {
        this.ensureRange(begin, end);
      }

      return this.bytes.subarray(begin, end);
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      if (length) {
        if (start + length > this.progressiveDataLength) {
          this.ensureRange(start, start + length);
        }
      } else {
        if (start >= this.progressiveDataLength) {
          this.ensureByte(start);
        }
      }

      function ChunkedStreamSubstream() {}

      ChunkedStreamSubstream.prototype = Object.create(this);

      ChunkedStreamSubstream.prototype.getMissingChunks = function () {
        var chunkSize = this.chunkSize;
        var beginChunk = Math.floor(this.start / chunkSize);
        var endChunk = Math.floor((this.end - 1) / chunkSize) + 1;
        var missingChunks = [];

        for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
          if (!this._loadedChunks.has(chunk)) {
            missingChunks.push(chunk);
          }
        }

        return missingChunks;
      };

      Object.defineProperty(ChunkedStreamSubstream.prototype, "isDataLoaded", {
        get: function get() {
          if (this.numChunksLoaded === this.numChunks) {
            return true;
          }

          return this.getMissingChunks().length === 0;
        },
        configurable: true
      });
      var subStream = new ChunkedStreamSubstream();
      subStream.pos = subStream.start = start;
      subStream.end = start + length || this.end;
      subStream.dict = dict;
      return subStream;
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      return [this];
    }
  }]);

  return ChunkedStream;
}(_stream.Stream);

exports.ChunkedStream = ChunkedStream;

var ChunkedStreamManager = /*#__PURE__*/function () {
  function ChunkedStreamManager(pdfNetworkStream, args) {
    _classCallCheck(this, ChunkedStreamManager);

    this.length = args.length;
    this.chunkSize = args.rangeChunkSize;
    this.stream = new ChunkedStream(this.length, this.chunkSize, this);
    this.pdfNetworkStream = pdfNetworkStream;
    this.disableAutoFetch = args.disableAutoFetch;
    this.msgHandler = args.msgHandler;
    this.currRequestId = 0;
    this._chunksNeededByRequest = new Map();
    this._requestsByChunk = new Map();
    this._promisesByRequest = new Map();
    this.progressiveDataLength = 0;
    this.aborted = false;
    this._loadedStreamCapability = (0, _util.createPromiseCapability)();
  }

  _createClass(ChunkedStreamManager, [{
    key: "onLoadedStream",
    value: function onLoadedStream() {
      return this._loadedStreamCapability.promise;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(begin, end) {
      var _this2 = this;

      var rangeReader = this.pdfNetworkStream.getRangeReader(begin, end);

      if (!rangeReader.isStreamingSupported) {
        rangeReader.onProgress = this.onProgress.bind(this);
      }

      var chunks = [],
          loaded = 0;
      var promise = new Promise(function (resolve, reject) {
        var readChunk = function readChunk(chunk) {
          try {
            if (!chunk.done) {
              var data = chunk.value;
              chunks.push(data);
              loaded += (0, _util.arrayByteLength)(data);

              if (rangeReader.isStreamingSupported) {
                _this2.onProgress({
                  loaded: loaded
                });
              }

              rangeReader.read().then(readChunk, reject);
              return;
            }

            var chunkData = (0, _util.arraysToBytes)(chunks);
            chunks = null;
            resolve(chunkData);
          } catch (e) {
            reject(e);
          }
        };

        rangeReader.read().then(readChunk, reject);
      });
      promise.then(function (data) {
        if (_this2.aborted) {
          return;
        }

        _this2.onReceiveData({
          chunk: data,
          begin: begin
        });
      });
    }
  }, {
    key: "requestAllChunks",
    value: function requestAllChunks() {
      var missingChunks = this.stream.getMissingChunks();

      this._requestChunks(missingChunks);

      return this._loadedStreamCapability.promise;
    }
  }, {
    key: "_requestChunks",
    value: function _requestChunks(chunks) {
      var _this3 = this;

      var requestId = this.currRequestId++;
      var chunksNeeded = new Set();

      this._chunksNeededByRequest.set(requestId, chunksNeeded);

      var _iterator = _createForOfIteratorHelper(chunks),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var chunk = _step.value;

          if (!this.stream.hasChunk(chunk)) {
            chunksNeeded.add(chunk);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (chunksNeeded.size === 0) {
        return Promise.resolve();
      }

      var capability = (0, _util.createPromiseCapability)();

      this._promisesByRequest.set(requestId, capability);

      var chunksToRequest = [];

      var _iterator2 = _createForOfIteratorHelper(chunksNeeded),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _chunk = _step2.value;

          var requestIds = this._requestsByChunk.get(_chunk);

          if (!requestIds) {
            requestIds = [];

            this._requestsByChunk.set(_chunk, requestIds);

            chunksToRequest.push(_chunk);
          }

          requestIds.push(requestId);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      if (chunksToRequest.length > 0) {
        var groupedChunksToRequest = this.groupChunks(chunksToRequest);

        var _iterator3 = _createForOfIteratorHelper(groupedChunksToRequest),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var groupedChunk = _step3.value;
            var begin = groupedChunk.beginChunk * this.chunkSize;
            var end = Math.min(groupedChunk.endChunk * this.chunkSize, this.length);
            this.sendRequest(begin, end);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }

      return capability.promise["catch"](function (reason) {
        if (_this3.aborted) {
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "getStream",
    value: function getStream() {
      return this.stream;
    }
  }, {
    key: "requestRange",
    value: function requestRange(begin, end) {
      end = Math.min(end, this.length);
      var beginChunk = this.getBeginChunk(begin);
      var endChunk = this.getEndChunk(end);
      var chunks = [];

      for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
        chunks.push(chunk);
      }

      return this._requestChunks(chunks);
    }
  }, {
    key: "requestRanges",
    value: function requestRanges() {
      var ranges = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var chunksToRequest = [];

      var _iterator4 = _createForOfIteratorHelper(ranges),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var range = _step4.value;
          var beginChunk = this.getBeginChunk(range.begin);
          var endChunk = this.getEndChunk(range.end);

          for (var chunk = beginChunk; chunk < endChunk; ++chunk) {
            if (!chunksToRequest.includes(chunk)) {
              chunksToRequest.push(chunk);
            }
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      chunksToRequest.sort(function (a, b) {
        return a - b;
      });
      return this._requestChunks(chunksToRequest);
    }
  }, {
    key: "groupChunks",
    value: function groupChunks(chunks) {
      var groupedChunks = [];
      var beginChunk = -1;
      var prevChunk = -1;

      for (var i = 0, ii = chunks.length; i < ii; ++i) {
        var chunk = chunks[i];

        if (beginChunk < 0) {
          beginChunk = chunk;
        }

        if (prevChunk >= 0 && prevChunk + 1 !== chunk) {
          groupedChunks.push({
            beginChunk: beginChunk,
            endChunk: prevChunk + 1
          });
          beginChunk = chunk;
        }

        if (i + 1 === chunks.length) {
          groupedChunks.push({
            beginChunk: beginChunk,
            endChunk: chunk + 1
          });
        }

        prevChunk = chunk;
      }

      return groupedChunks;
    }
  }, {
    key: "onProgress",
    value: function onProgress(args) {
      this.msgHandler.send("DocProgress", {
        loaded: this.stream.numChunksLoaded * this.chunkSize + args.loaded,
        total: this.length
      });
    }
  }, {
    key: "onReceiveData",
    value: function onReceiveData(args) {
      var chunk = args.chunk;
      var isProgressive = args.begin === undefined;
      var begin = isProgressive ? this.progressiveDataLength : args.begin;
      var end = begin + chunk.byteLength;
      var beginChunk = Math.floor(begin / this.chunkSize);
      var endChunk = end < this.length ? Math.floor(end / this.chunkSize) : Math.ceil(end / this.chunkSize);

      if (isProgressive) {
        this.stream.onReceiveProgressiveData(chunk);
        this.progressiveDataLength = end;
      } else {
        this.stream.onReceiveData(begin, chunk);
      }

      if (this.stream.isDataLoaded) {
        this._loadedStreamCapability.resolve(this.stream);
      }

      var loadedRequests = [];

      for (var curChunk = beginChunk; curChunk < endChunk; ++curChunk) {
        var requestIds = this._requestsByChunk.get(curChunk);

        if (!requestIds) {
          continue;
        }

        this._requestsByChunk["delete"](curChunk);

        var _iterator5 = _createForOfIteratorHelper(requestIds),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var requestId = _step5.value;

            var chunksNeeded = this._chunksNeededByRequest.get(requestId);

            if (chunksNeeded.has(curChunk)) {
              chunksNeeded["delete"](curChunk);
            }

            if (chunksNeeded.size > 0) {
              continue;
            }

            loadedRequests.push(requestId);
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      }

      if (!this.disableAutoFetch && this._requestsByChunk.size === 0) {
        var nextEmptyChunk;

        if (this.stream.numChunksLoaded === 1) {
          var lastChunk = this.stream.numChunks - 1;

          if (!this.stream.hasChunk(lastChunk)) {
            nextEmptyChunk = lastChunk;
          }
        } else {
          nextEmptyChunk = this.stream.nextEmptyChunk(endChunk);
        }

        if (Number.isInteger(nextEmptyChunk)) {
          this._requestChunks([nextEmptyChunk]);
        }
      }

      for (var _i = 0, _loadedRequests = loadedRequests; _i < _loadedRequests.length; _i++) {
        var _requestId = _loadedRequests[_i];

        var capability = this._promisesByRequest.get(_requestId);

        this._promisesByRequest["delete"](_requestId);

        capability.resolve();
      }

      this.msgHandler.send("DocProgress", {
        loaded: this.stream.numChunksLoaded * this.chunkSize,
        total: this.length
      });
    }
  }, {
    key: "onError",
    value: function onError(err) {
      this._loadedStreamCapability.reject(err);
    }
  }, {
    key: "getBeginChunk",
    value: function getBeginChunk(begin) {
      return Math.floor(begin / this.chunkSize);
    }
  }, {
    key: "getEndChunk",
    value: function getEndChunk(end) {
      return Math.floor((end - 1) / this.chunkSize) + 1;
    }
  }, {
    key: "abort",
    value: function abort(reason) {
      this.aborted = true;

      if (this.pdfNetworkStream) {
        this.pdfNetworkStream.cancelAllRequests(reason);
      }

      var _iterator6 = _createForOfIteratorHelper(this._promisesByRequest.values()),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var capability = _step6.value;
          capability.reject(reason);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
  }]);

  return ChunkedStreamManager;
}();

exports.ChunkedStreamManager = ChunkedStreamManager;

/***/ }),
/* 117 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.collectActions = collectActions;
exports.encodeToXmlString = encodeToXmlString;
exports.escapePDFName = escapePDFName;
exports.getArrayLookupTableFactory = getArrayLookupTableFactory;
exports.getInheritableProperty = getInheritableProperty;
exports.getLookupTableFactory = getLookupTableFactory;
exports.isWhiteSpace = isWhiteSpace;
exports.log2 = log2;
exports.parseXFAPath = parseXFAPath;
exports.readInt8 = readInt8;
exports.readUint16 = readUint16;
exports.readUint32 = readUint32;
exports.toRomanNumerals = toRomanNumerals;
exports.validateCSSFont = validateCSSFont;
exports.XRefParseException = exports.XRefEntryException = exports.MissingDataException = void 0;

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function getLookupTableFactory(initializer) {
  var lookup;
  return function () {
    if (initializer) {
      lookup = Object.create(null);
      initializer(lookup);
      initializer = null;
    }

    return lookup;
  };
}

function getArrayLookupTableFactory(initializer) {
  var lookup;
  return function () {
    if (initializer) {
      var arr = initializer();
      initializer = null;
      lookup = Object.create(null);

      for (var i = 0, ii = arr.length; i < ii; i += 2) {
        lookup[arr[i]] = arr[i + 1];
      }

      arr = null;
    }

    return lookup;
  };
}

var MissingDataException = /*#__PURE__*/function (_BaseException) {
  _inherits(MissingDataException, _BaseException);

  var _super = _createSuper(MissingDataException);

  function MissingDataException(begin, end) {
    var _this;

    _classCallCheck(this, MissingDataException);

    _this = _super.call(this, "Missing data [".concat(begin, ", ").concat(end, ")"));
    _this.begin = begin;
    _this.end = end;
    return _this;
  }

  return MissingDataException;
}(_util.BaseException);

exports.MissingDataException = MissingDataException;

var XRefEntryException = /*#__PURE__*/function (_BaseException2) {
  _inherits(XRefEntryException, _BaseException2);

  var _super2 = _createSuper(XRefEntryException);

  function XRefEntryException() {
    _classCallCheck(this, XRefEntryException);

    return _super2.apply(this, arguments);
  }

  return XRefEntryException;
}(_util.BaseException);

exports.XRefEntryException = XRefEntryException;

var XRefParseException = /*#__PURE__*/function (_BaseException3) {
  _inherits(XRefParseException, _BaseException3);

  var _super3 = _createSuper(XRefParseException);

  function XRefParseException() {
    _classCallCheck(this, XRefParseException);

    return _super3.apply(this, arguments);
  }

  return XRefParseException;
}(_util.BaseException);

exports.XRefParseException = XRefParseException;

function getInheritableProperty(_ref) {
  var dict = _ref.dict,
      key = _ref.key,
      _ref$getArray = _ref.getArray,
      getArray = _ref$getArray === void 0 ? false : _ref$getArray,
      _ref$stopWhenFound = _ref.stopWhenFound,
      stopWhenFound = _ref$stopWhenFound === void 0 ? true : _ref$stopWhenFound;
  var values;
  var visited = new _primitives.RefSet();

  while (dict instanceof _primitives.Dict && !(dict.objId && visited.has(dict.objId))) {
    if (dict.objId) {
      visited.put(dict.objId);
    }

    var value = getArray ? dict.getArray(key) : dict.get(key);

    if (value !== undefined) {
      if (stopWhenFound) {
        return value;
      }

      if (!values) {
        values = [];
      }

      values.push(value);
    }

    dict = dict.get("Parent");
  }

  return values;
}

var ROMAN_NUMBER_MAP = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"];

function toRomanNumerals(number) {
  var lowerCase = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  (0, _util.assert)(Number.isInteger(number) && number > 0, "The number should be a positive integer.");
  var romanBuf = [];
  var pos;

  while (number >= 1000) {
    number -= 1000;
    romanBuf.push("M");
  }

  pos = number / 100 | 0;
  number %= 100;
  romanBuf.push(ROMAN_NUMBER_MAP[pos]);
  pos = number / 10 | 0;
  number %= 10;
  romanBuf.push(ROMAN_NUMBER_MAP[10 + pos]);
  romanBuf.push(ROMAN_NUMBER_MAP[20 + number]);
  var romanStr = romanBuf.join("");
  return lowerCase ? romanStr.toLowerCase() : romanStr;
}

function log2(x) {
  if (x <= 0) {
    return 0;
  }

  return Math.ceil(Math.log2(x));
}

function readInt8(data, offset) {
  return data[offset] << 24 >> 24;
}

function readUint16(data, offset) {
  return data[offset] << 8 | data[offset + 1];
}

function readUint32(data, offset) {
  return (data[offset] << 24 | data[offset + 1] << 16 | data[offset + 2] << 8 | data[offset + 3]) >>> 0;
}

function isWhiteSpace(ch) {
  return ch === 0x20 || ch === 0x09 || ch === 0x0d || ch === 0x0a;
}

function parseXFAPath(path) {
  var positionPattern = /(.+)\[([0-9]+)\]$/;
  return path.split(".").map(function (component) {
    var m = component.match(positionPattern);

    if (m) {
      return {
        name: m[1],
        pos: parseInt(m[2], 10)
      };
    }

    return {
      name: component,
      pos: 0
    };
  });
}

function escapePDFName(str) {
  var buffer = [];
  var start = 0;

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char = str.charCodeAt(i);

    if (_char < 0x21 || _char > 0x7e || _char === 0x23 || _char === 0x28 || _char === 0x29 || _char === 0x3c || _char === 0x3e || _char === 0x5b || _char === 0x5d || _char === 0x7b || _char === 0x7d || _char === 0x2f || _char === 0x25) {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push("#".concat(_char.toString(16)));
      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function _collectJS(entry, xref, list, parents) {
  if (!entry) {
    return;
  }

  var parent = null;

  if ((0, _primitives.isRef)(entry)) {
    if (parents.has(entry)) {
      return;
    }

    parent = entry;
    parents.put(parent);
    entry = xref.fetch(entry);
  }

  if (Array.isArray(entry)) {
    var _iterator = _createForOfIteratorHelper(entry),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var element = _step.value;

        _collectJS(element, xref, list, parents);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  } else if (entry instanceof _primitives.Dict) {
    if ((0, _primitives.isName)(entry.get("S"), "JavaScript") && entry.has("JS")) {
      var js = entry.get("JS");
      var code;

      if ((0, _primitives.isStream)(js)) {
        code = js.getString();
      } else {
        code = js;
      }

      code = (0, _util.stringToPDFString)(code);

      if (code) {
        list.push(code);
      }
    }

    _collectJS(entry.getRaw("Next"), xref, list, parents);
  }

  if (parent) {
    parents.remove(parent);
  }
}

function collectActions(xref, dict, eventType) {
  var actions = Object.create(null);
  var additionalActionsDicts = getInheritableProperty({
    dict: dict,
    key: "AA",
    stopWhenFound: false
  });

  if (additionalActionsDicts) {
    for (var i = additionalActionsDicts.length - 1; i >= 0; i--) {
      var additionalActions = additionalActionsDicts[i];

      if (!(additionalActions instanceof _primitives.Dict)) {
        continue;
      }

      var _iterator2 = _createForOfIteratorHelper(additionalActions.getKeys()),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var key = _step2.value;
          var action = eventType[key];

          if (!action) {
            continue;
          }

          var actionDict = additionalActions.getRaw(key);
          var parents = new _primitives.RefSet();
          var list = [];

          _collectJS(actionDict, xref, list, parents);

          if (list.length > 0) {
            actions[action] = list;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }

  if (dict.has("A")) {
    var _actionDict = dict.get("A");

    var _parents = new _primitives.RefSet();

    var _list = [];

    _collectJS(_actionDict, xref, _list, _parents);

    if (_list.length > 0) {
      actions.Action = _list;
    }
  }

  return (0, _util.objectSize)(actions) > 0 ? actions : null;
}

var XMLEntities = {
  0x3c: "&lt;",
  0x3e: "&gt;",
  0x26: "&amp;",
  0x22: "&quot;",
  0x27: "&apos;"
};

function encodeToXmlString(str) {
  var buffer = [];
  var start = 0;

  for (var i = 0, ii = str.length; i < ii; i++) {
    var _char2 = str.codePointAt(i);

    if (0x20 <= _char2 && _char2 <= 0x7e) {
      var entity = XMLEntities[_char2];

      if (entity) {
        if (start < i) {
          buffer.push(str.substring(start, i));
        }

        buffer.push(entity);
        start = i + 1;
      }
    } else {
      if (start < i) {
        buffer.push(str.substring(start, i));
      }

      buffer.push("&#x".concat(_char2.toString(16).toUpperCase(), ";"));

      if (_char2 > 0xd7ff && (_char2 < 0xe000 || _char2 > 0xfffd)) {
        i++;
      }

      start = i + 1;
    }
  }

  if (buffer.length === 0) {
    return str;
  }

  if (start < str.length) {
    buffer.push(str.substring(start, str.length));
  }

  return buffer.join("");
}

function validateCSSFont(cssFontInfo) {
  var DEFAULT_CSS_FONT_OBLIQUE = "14";
  var DEFAULT_CSS_FONT_WEIGHT = "400";
  var CSS_FONT_WEIGHT_VALUES = new Set(["100", "200", "300", "400", "500", "600", "700", "800", "900", "1000", "normal", "bold", "bolder", "lighter"]);
  var fontFamily = cssFontInfo.fontFamily,
      fontWeight = cssFontInfo.fontWeight,
      italicAngle = cssFontInfo.italicAngle;

  if (/^".*"$/.test(fontFamily)) {
    if (/[^\\]"/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)("XFA - FontFamily contains some unescaped \": ".concat(fontFamily, "."));
      return false;
    }
  } else if (/^'.*'$/.test(fontFamily)) {
    if (/[^\\]'/.test(fontFamily.slice(1, fontFamily.length - 1))) {
      (0, _util.warn)("XFA - FontFamily contains some unescaped ': ".concat(fontFamily, "."));
      return false;
    }
  } else {
    var _iterator3 = _createForOfIteratorHelper(fontFamily.split(/[ \t]+/)),
        _step3;

    try {
      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
        var ident = _step3.value;

        if (/^([0-9]|(-([0-9]|-)))/.test(ident) || !/^[a-zA-Z0-9\-_\\]+$/.test(ident)) {
          (0, _util.warn)("XFA - FontFamily contains some invalid <custom-ident>: ".concat(fontFamily, "."));
          return false;
        }
      }
    } catch (err) {
      _iterator3.e(err);
    } finally {
      _iterator3.f();
    }
  }

  var weight = fontWeight ? fontWeight.toString() : "";
  cssFontInfo.fontWeight = CSS_FONT_WEIGHT_VALUES.has(weight) ? weight : DEFAULT_CSS_FONT_WEIGHT;
  var angle = parseFloat(italicAngle);
  cssFontInfo.italicAngle = isNaN(angle) || angle < -90 || angle > 90 ? DEFAULT_CSS_FONT_OBLIQUE : italicAngle.toString();
  return true;
}

/***/ }),
/* 118 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StringStream = exports.Stream = exports.NullStream = void 0;

var _base_stream = __w_pdfjs_require__(114);

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Stream = /*#__PURE__*/function (_BaseStream) {
  _inherits(Stream, _BaseStream);

  var _super = _createSuper(Stream);

  function Stream(arrayBuffer, start, length, dict) {
    var _this;

    _classCallCheck(this, Stream);

    _this = _super.call(this);
    _this.bytes = arrayBuffer instanceof Uint8Array ? arrayBuffer : new Uint8Array(arrayBuffer);
    _this.start = start || 0;
    _this.pos = _this.start;
    _this.end = start + length || _this.bytes.length;
    _this.dict = dict;
    return _this;
  }

  _createClass(Stream, [{
    key: "length",
    get: function get() {
      return this.end - this.start;
    }
  }, {
    key: "isEmpty",
    get: function get() {
      return this.length === 0;
    }
  }, {
    key: "getByte",
    value: function getByte() {
      if (this.pos >= this.end) {
        return -1;
      }

      return this.bytes[this.pos++];
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var bytes = this.bytes;
      var pos = this.pos;
      var strEnd = this.end;

      if (!length) {
        var _subarray = bytes.subarray(pos, strEnd);

        return forceClamped ? new Uint8ClampedArray(_subarray) : _subarray;
      }

      var end = pos + length;

      if (end > strEnd) {
        end = strEnd;
      }

      this.pos = end;
      var subarray = bytes.subarray(pos, end);
      return forceClamped ? new Uint8ClampedArray(subarray) : subarray;
    }
  }, {
    key: "getByteRange",
    value: function getByteRange(begin, end) {
      if (begin < 0) {
        begin = 0;
      }

      if (end > this.end) {
        end = this.end;
      }

      return this.bytes.subarray(begin, end);
    }
  }, {
    key: "reset",
    value: function reset() {
      this.pos = this.start;
    }
  }, {
    key: "moveStart",
    value: function moveStart() {
      this.start = this.pos;
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      return new Stream(this.bytes.buffer, start, length, dict);
    }
  }]);

  return Stream;
}(_base_stream.BaseStream);

exports.Stream = Stream;

var StringStream = /*#__PURE__*/function (_Stream) {
  _inherits(StringStream, _Stream);

  var _super2 = _createSuper(StringStream);

  function StringStream(str) {
    _classCallCheck(this, StringStream);

    return _super2.call(this, (0, _util.stringToBytes)(str));
  }

  return StringStream;
}(Stream);

exports.StringStream = StringStream;

var NullStream = /*#__PURE__*/function (_Stream2) {
  _inherits(NullStream, _Stream2);

  var _super3 = _createSuper(NullStream);

  function NullStream() {
    _classCallCheck(this, NullStream);

    return _super3.call(this, new Uint8Array(0));
  }

  return NullStream;
}(Stream);

exports.NullStream = NullStream;

/***/ }),
/* 119 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PDFDocument = exports.Page = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

var _core_utils = __w_pdfjs_require__(117);

var _stream = __w_pdfjs_require__(118);

var _annotation = __w_pdfjs_require__(120);

var _base_stream = __w_pdfjs_require__(114);

var _crypto = __w_pdfjs_require__(173);

var _catalog = __w_pdfjs_require__(165);

var _parser = __w_pdfjs_require__(125);

var _object_loader = __w_pdfjs_require__(171);

var _operator_list = __w_pdfjs_require__(163);

var _evaluator = __w_pdfjs_require__(123);

var _decode_stream = __w_pdfjs_require__(127);

var _struct_tree = __w_pdfjs_require__(170);

var _factory = __w_pdfjs_require__(175);

var _xref = __w_pdfjs_require__(196);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DEFAULT_USER_UNIT = 1.0;
var LETTER_SIZE_MEDIABOX = [0, 0, 612, 792];

var Page = /*#__PURE__*/function () {
  function Page(_ref) {
    var pdfManager = _ref.pdfManager,
        xref = _ref.xref,
        pageIndex = _ref.pageIndex,
        pageDict = _ref.pageDict,
        ref = _ref.ref,
        globalIdFactory = _ref.globalIdFactory,
        fontCache = _ref.fontCache,
        builtInCMapCache = _ref.builtInCMapCache,
        globalImageCache = _ref.globalImageCache,
        nonBlendModesSet = _ref.nonBlendModesSet,
        xfaFactory = _ref.xfaFactory;

    _classCallCheck(this, Page);

    this.pdfManager = pdfManager;
    this.pageIndex = pageIndex;
    this.pageDict = pageDict;
    this.xref = xref;
    this.ref = ref;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.globalImageCache = globalImageCache;
    this.nonBlendModesSet = nonBlendModesSet;
    this.evaluatorOptions = pdfManager.evaluatorOptions;
    this.resourcesPromise = null;
    this.xfaFactory = xfaFactory;
    var idCounters = {
      obj: 0
    };

    this._localIdFactory = /*#__PURE__*/function (_globalIdFactory) {
      _inherits(_class, _globalIdFactory);

      var _super = _createSuper(_class);

      function _class() {
        _classCallCheck(this, _class);

        return _super.apply(this, arguments);
      }

      _createClass(_class, null, [{
        key: "createObjId",
        value: function createObjId() {
          return "p".concat(pageIndex, "_").concat(++idCounters.obj);
        }
      }, {
        key: "getPageObjId",
        value: function getPageObjId() {
          return "page".concat(ref.toString());
        }
      }]);

      return _class;
    }(globalIdFactory);
  }

  _createClass(Page, [{
    key: "_getInheritableProperty",
    value: function _getInheritableProperty(key) {
      var getArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var value = (0, _core_utils.getInheritableProperty)({
        dict: this.pageDict,
        key: key,
        getArray: getArray,
        stopWhenFound: false
      });

      if (!Array.isArray(value)) {
        return value;
      }

      if (value.length === 1 || !(0, _primitives.isDict)(value[0])) {
        return value[0];
      }

      return _primitives.Dict.merge({
        xref: this.xref,
        dictArray: value
      });
    }
  }, {
    key: "content",
    get: function get() {
      return this.pageDict.getArray("Contents");
    }
  }, {
    key: "resources",
    get: function get() {
      return (0, _util.shadow)(this, "resources", this._getInheritableProperty("Resources") || _primitives.Dict.empty);
    }
  }, {
    key: "_getBoundingBox",
    value: function _getBoundingBox(name) {
      if (this.xfaData) {
        var _this$xfaData$attribu = this.xfaData.attributes.style,
            width = _this$xfaData$attribu.width,
            height = _this$xfaData$attribu.height;
        return [0, 0, parseInt(width), parseInt(height)];
      }

      var box = this._getInheritableProperty(name, true);

      if (Array.isArray(box) && box.length === 4) {
        if (box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
          return box;
        }

        (0, _util.warn)("Empty /".concat(name, " entry."));
      }

      return null;
    }
  }, {
    key: "mediaBox",
    get: function get() {
      return (0, _util.shadow)(this, "mediaBox", this._getBoundingBox("MediaBox") || LETTER_SIZE_MEDIABOX);
    }
  }, {
    key: "cropBox",
    get: function get() {
      return (0, _util.shadow)(this, "cropBox", this._getBoundingBox("CropBox") || this.mediaBox);
    }
  }, {
    key: "userUnit",
    get: function get() {
      var obj = this.pageDict.get("UserUnit");

      if (!(0, _util.isNum)(obj) || obj <= 0) {
        obj = DEFAULT_USER_UNIT;
      }

      return (0, _util.shadow)(this, "userUnit", obj);
    }
  }, {
    key: "view",
    get: function get() {
      var cropBox = this.cropBox,
          mediaBox = this.mediaBox;
      var view;

      if (cropBox === mediaBox || (0, _util.isArrayEqual)(cropBox, mediaBox)) {
        view = mediaBox;
      } else {
        var box = _util.Util.intersect(cropBox, mediaBox);

        if (box && box[2] - box[0] !== 0 && box[3] - box[1] !== 0) {
          view = box;
        } else {
          (0, _util.warn)("Empty /CropBox and /MediaBox intersection.");
        }
      }

      return (0, _util.shadow)(this, "view", view || mediaBox);
    }
  }, {
    key: "rotate",
    get: function get() {
      var rotate = this._getInheritableProperty("Rotate") || 0;

      if (rotate % 90 !== 0) {
        rotate = 0;
      } else if (rotate >= 360) {
        rotate = rotate % 360;
      } else if (rotate < 0) {
        rotate = (rotate % 360 + 360) % 360;
      }

      return (0, _util.shadow)(this, "rotate", rotate);
    }
  }, {
    key: "getContentStream",
    value: function getContentStream() {
      return this.pdfManager.ensure(this, "content").then(function (content) {
        if (content instanceof _base_stream.BaseStream) {
          return content;
        }

        if (Array.isArray(content)) {
          return new _decode_stream.StreamsSequenceStream(content);
        }

        return new _stream.NullStream();
      });
    }
  }, {
    key: "xfaData",
    get: function get() {
      if (this.xfaFactory) {
        return (0, _util.shadow)(this, "xfaData", this.xfaFactory.getPage(this.pageIndex));
      }

      return (0, _util.shadow)(this, "xfaData", null);
    }
  }, {
    key: "save",
    value: function save(handler, task, annotationStorage) {
      var partialEvaluator = new _evaluator.PartialEvaluator({
        xref: this.xref,
        handler: handler,
        pageIndex: this.pageIndex,
        idFactory: this._localIdFactory,
        fontCache: this.fontCache,
        builtInCMapCache: this.builtInCMapCache,
        globalImageCache: this.globalImageCache,
        options: this.evaluatorOptions
      });
      return this._parsedAnnotations.then(function (annotations) {
        var newRefsPromises = [];

        var _iterator = _createForOfIteratorHelper(annotations),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var annotation = _step.value;

            if (!annotation.mustBePrinted(annotationStorage)) {
              continue;
            }

            newRefsPromises.push(annotation.save(partialEvaluator, task, annotationStorage)["catch"](function (reason) {
              (0, _util.warn)("save - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
              return null;
            }));
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        return Promise.all(newRefsPromises);
      });
    }
  }, {
    key: "loadResources",
    value: function loadResources(keys) {
      var _this = this;

      if (!this.resourcesPromise) {
        this.resourcesPromise = this.pdfManager.ensure(this, "resources");
      }

      return this.resourcesPromise.then(function () {
        var objectLoader = new _object_loader.ObjectLoader(_this.resources, keys, _this.xref);
        return objectLoader.load();
      });
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(_ref2) {
      var _this2 = this;

      var handler = _ref2.handler,
          sink = _ref2.sink,
          task = _ref2.task,
          intent = _ref2.intent,
          renderInteractiveForms = _ref2.renderInteractiveForms,
          annotationStorage = _ref2.annotationStorage;
      var contentStreamPromise = this.getContentStream();
      var resourcesPromise = this.loadResources(["ColorSpace", "ExtGState", "Font", "Pattern", "Properties", "Shading", "XObject"]);
      var partialEvaluator = new _evaluator.PartialEvaluator({
        xref: this.xref,
        handler: handler,
        pageIndex: this.pageIndex,
        idFactory: this._localIdFactory,
        fontCache: this.fontCache,
        builtInCMapCache: this.builtInCMapCache,
        globalImageCache: this.globalImageCache,
        options: this.evaluatorOptions
      });
      var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
      var pageListPromise = dataPromises.then(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 1),
            contentStream = _ref4[0];

        var opList = new _operator_list.OperatorList(intent, sink);
        handler.send("StartRenderPage", {
          transparency: partialEvaluator.hasBlendModes(_this2.resources, _this2.nonBlendModesSet),
          pageIndex: _this2.pageIndex,
          intent: intent
        });
        return partialEvaluator.getOperatorList({
          stream: contentStream,
          task: task,
          resources: _this2.resources,
          operatorList: opList
        }).then(function () {
          return opList;
        });
      });
      return Promise.all([pageListPromise, this._parsedAnnotations]).then(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
            pageOpList = _ref6[0],
            annotations = _ref6[1];

        if (annotations.length === 0) {
          pageOpList.flush(true);
          return {
            length: pageOpList.totalLength
          };
        }

        var opListPromises = [];

        var _iterator2 = _createForOfIteratorHelper(annotations),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var annotation = _step2.value;

            if (intent === "display" && annotation.mustBeViewed(annotationStorage) || intent === "print" && annotation.mustBePrinted(annotationStorage)) {
              opListPromises.push(annotation.getOperatorList(partialEvaluator, task, renderInteractiveForms, annotationStorage)["catch"](function (reason) {
                (0, _util.warn)("getOperatorList - ignoring annotation data during " + "\"".concat(task.name, "\" task: \"").concat(reason, "\"."));
                return null;
              }));
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }

        return Promise.all(opListPromises).then(function (opLists) {
          pageOpList.addOp(_util.OPS.beginAnnotations, []);

          var _iterator3 = _createForOfIteratorHelper(opLists),
              _step3;

          try {
            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
              var opList = _step3.value;
              pageOpList.addOpList(opList);
            }
          } catch (err) {
            _iterator3.e(err);
          } finally {
            _iterator3.f();
          }

          pageOpList.addOp(_util.OPS.endAnnotations, []);
          pageOpList.flush(true);
          return {
            length: pageOpList.totalLength
          };
        });
      });
    }
  }, {
    key: "extractTextContent",
    value: function extractTextContent(_ref7) {
      var _this3 = this;

      var handler = _ref7.handler,
          task = _ref7.task,
          normalizeWhitespace = _ref7.normalizeWhitespace,
          includeMarkedContent = _ref7.includeMarkedContent,
          sink = _ref7.sink,
          combineTextItems = _ref7.combineTextItems;
      var contentStreamPromise = this.getContentStream();
      var resourcesPromise = this.loadResources(["ExtGState", "Font", "Properties", "XObject"]);
      var dataPromises = Promise.all([contentStreamPromise, resourcesPromise]);
      return dataPromises.then(function (_ref8) {
        var _ref9 = _slicedToArray(_ref8, 1),
            contentStream = _ref9[0];

        var partialEvaluator = new _evaluator.PartialEvaluator({
          xref: _this3.xref,
          handler: handler,
          pageIndex: _this3.pageIndex,
          idFactory: _this3._localIdFactory,
          fontCache: _this3.fontCache,
          builtInCMapCache: _this3.builtInCMapCache,
          globalImageCache: _this3.globalImageCache,
          options: _this3.evaluatorOptions
        });
        return partialEvaluator.getTextContent({
          stream: contentStream,
          task: task,
          resources: _this3.resources,
          normalizeWhitespace: normalizeWhitespace,
          includeMarkedContent: includeMarkedContent,
          combineTextItems: combineTextItems,
          sink: sink
        });
      });
    }
  }, {
    key: "getStructTree",
    value: function () {
      var _getStructTree = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee() {
        var structTreeRoot, structTree;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.pdfManager.ensureCatalog("structTreeRoot");

              case 2:
                structTreeRoot = _context.sent;

                if (structTreeRoot) {
                  _context.next = 5;
                  break;
                }

                return _context.abrupt("return", null);

              case 5:
                _context.next = 7;
                return this.pdfManager.ensure(this, "_parseStructTree", [structTreeRoot]);

              case 7:
                structTree = _context.sent;
                return _context.abrupt("return", structTree.serializable);

              case 9:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getStructTree() {
        return _getStructTree.apply(this, arguments);
      }

      return getStructTree;
    }()
  }, {
    key: "_parseStructTree",
    value: function _parseStructTree(structTreeRoot) {
      var tree = new _struct_tree.StructTreePage(structTreeRoot, this.pageDict);
      tree.parse();
      return tree;
    }
  }, {
    key: "getAnnotationsData",
    value: function getAnnotationsData(intent) {
      return this._parsedAnnotations.then(function (annotations) {
        var annotationsData = [];

        for (var i = 0, ii = annotations.length; i < ii; i++) {
          if (!intent || intent === "display" && annotations[i].viewable || intent === "print" && annotations[i].printable) {
            annotationsData.push(annotations[i].data);
          }
        }

        return annotationsData;
      });
    }
  }, {
    key: "annotations",
    get: function get() {
      var annots = this._getInheritableProperty("Annots");

      return (0, _util.shadow)(this, "annotations", Array.isArray(annots) ? annots : []);
    }
  }, {
    key: "_parsedAnnotations",
    get: function get() {
      var _this4 = this;

      var parsedAnnotations = this.pdfManager.ensure(this, "annotations").then(function () {
        var annotationPromises = [];

        var _iterator4 = _createForOfIteratorHelper(_this4.annotations),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var annotationRef = _step4.value;
            annotationPromises.push(_annotation.AnnotationFactory.create(_this4.xref, annotationRef, _this4.pdfManager, _this4._localIdFactory, false)["catch"](function (reason) {
              (0, _util.warn)("_parsedAnnotations: \"".concat(reason, "\"."));
              return null;
            }));
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }

        return Promise.all(annotationPromises).then(function (annotations) {
          return annotations.filter(function (annotation) {
            return !!annotation;
          });
        });
      });
      return (0, _util.shadow)(this, "_parsedAnnotations", parsedAnnotations);
    }
  }, {
    key: "jsActions",
    get: function get() {
      var actions = (0, _core_utils.collectActions)(this.xref, this.pageDict, _util.PageActionEventType);
      return (0, _util.shadow)(this, "jsActions", actions);
    }
  }]);

  return Page;
}();

exports.Page = Page;
var PDF_HEADER_SIGNATURE = new Uint8Array([0x25, 0x50, 0x44, 0x46, 0x2d]);
var STARTXREF_SIGNATURE = new Uint8Array([0x73, 0x74, 0x61, 0x72, 0x74, 0x78, 0x72, 0x65, 0x66]);
var ENDOBJ_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x6f, 0x62, 0x6a]);
var FINGERPRINT_FIRST_BYTES = 1024;
var EMPTY_FINGERPRINT = "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00";
var PDF_HEADER_VERSION_REGEXP = /^[1-9]\.[0-9]$/;

function find(stream, signature) {
  var limit = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1024;
  var backwards = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  var signatureLength = signature.length;
  var scanBytes = stream.peekBytes(limit);
  var scanLength = scanBytes.length - signatureLength;

  if (scanLength <= 0) {
    return false;
  }

  if (backwards) {
    var signatureEnd = signatureLength - 1;
    var pos = scanBytes.length - 1;

    while (pos >= signatureEnd) {
      var j = 0;

      while (j < signatureLength && scanBytes[pos - j] === signature[signatureEnd - j]) {
        j++;
      }

      if (j >= signatureLength) {
        stream.pos += pos - signatureEnd;
        return true;
      }

      pos--;
    }
  } else {
    var _pos = 0;

    while (_pos <= scanLength) {
      var _j = 0;

      while (_j < signatureLength && scanBytes[_pos + _j] === signature[_j]) {
        _j++;
      }

      if (_j >= signatureLength) {
        stream.pos += _pos;
        return true;
      }

      _pos++;
    }
  }

  return false;
}

var PDFDocument = /*#__PURE__*/function () {
  function PDFDocument(pdfManager, arg) {
    _classCallCheck(this, PDFDocument);

    var stream;

    if ((0, _primitives.isStream)(arg)) {
      stream = arg;
    } else if ((0, _util.isArrayBuffer)(arg)) {
      stream = new _stream.Stream(arg);
    } else {
      throw new Error("PDFDocument: Unknown argument type");
    }

    if (stream.length <= 0) {
      throw new _util.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");
    }

    this.pdfManager = pdfManager;
    this.stream = stream;
    this.xref = new _xref.XRef(stream, pdfManager);
    this._pagePromises = [];
    this._version = null;
    var idCounters = {
      font: 0
    };

    this._globalIdFactory = /*#__PURE__*/function () {
      function _class2() {
        _classCallCheck(this, _class2);
      }

      _createClass(_class2, null, [{
        key: "getDocId",
        value: function getDocId() {
          return "g_".concat(pdfManager.docId);
        }
      }, {
        key: "createFontId",
        value: function createFontId() {
          return "f".concat(++idCounters.font);
        }
      }, {
        key: "createObjId",
        value: function createObjId() {
          (0, _util.unreachable)("Abstract method `createObjId` called.");
        }
      }, {
        key: "getPageObjId",
        value: function getPageObjId() {
          (0, _util.unreachable)("Abstract method `getPageObjId` called.");
        }
      }]);

      return _class2;
    }();
  }

  _createClass(PDFDocument, [{
    key: "parse",
    value: function parse(recoveryMode) {
      this.xref.parse(recoveryMode);
      this.catalog = new _catalog.Catalog(this.pdfManager, this.xref);

      if (this.catalog.version) {
        this._version = this.catalog.version;
      }
    }
  }, {
    key: "linearization",
    get: function get() {
      var linearization = null;

      try {
        linearization = _parser.Linearization.create(this.stream);
      } catch (err) {
        if (err instanceof _core_utils.MissingDataException) {
          throw err;
        }

        (0, _util.info)(err);
      }

      return (0, _util.shadow)(this, "linearization", linearization);
    }
  }, {
    key: "startXRef",
    get: function get() {
      var stream = this.stream;
      var startXRef = 0;

      if (this.linearization) {
        stream.reset();

        if (find(stream, ENDOBJ_SIGNATURE)) {
          startXRef = stream.pos + 6 - stream.start;
        }
      } else {
        var step = 1024;
        var startXRefLength = STARTXREF_SIGNATURE.length;
        var found = false,
            pos = stream.end;

        while (!found && pos > 0) {
          pos -= step - startXRefLength;

          if (pos < 0) {
            pos = 0;
          }

          stream.pos = pos;
          found = find(stream, STARTXREF_SIGNATURE, step, true);
        }

        if (found) {
          stream.skip(9);
          var ch;

          do {
            ch = stream.getByte();
          } while ((0, _core_utils.isWhiteSpace)(ch));

          var str = "";

          while (ch >= 0x20 && ch <= 0x39) {
            str += String.fromCharCode(ch);
            ch = stream.getByte();
          }

          startXRef = parseInt(str, 10);

          if (isNaN(startXRef)) {
            startXRef = 0;
          }
        }
      }

      return (0, _util.shadow)(this, "startXRef", startXRef);
    }
  }, {
    key: "checkHeader",
    value: function checkHeader() {
      var stream = this.stream;
      stream.reset();

      if (!find(stream, PDF_HEADER_SIGNATURE)) {
        return;
      }

      stream.moveStart();
      var MAX_PDF_VERSION_LENGTH = 12;
      var version = "",
          ch;

      while ((ch = stream.getByte()) > 0x20) {
        if (version.length >= MAX_PDF_VERSION_LENGTH) {
          break;
        }

        version += String.fromCharCode(ch);
      }

      if (!this._version) {
        this._version = version.substring(5);
      }
    }
  }, {
    key: "parseStartXRef",
    value: function parseStartXRef() {
      this.xref.setStartXRef(this.startXRef);
    }
  }, {
    key: "numPages",
    get: function get() {
      if (this.xfaFactory) {
        return (0, _util.shadow)(this, "numPages", this.xfaFactory.numberPages);
      }

      var linearization = this.linearization;
      var num = linearization ? linearization.numPages : this.catalog.numPages;
      return (0, _util.shadow)(this, "numPages", num);
    }
  }, {
    key: "_hasOnlyDocumentSignatures",
    value: function _hasOnlyDocumentSignatures(fields) {
      var _this5 = this;

      var recursionDepth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var RECURSION_LIMIT = 10;

      if (!Array.isArray(fields)) {
        return false;
      }

      return fields.every(function (field) {
        field = _this5.xref.fetchIfRef(field);

        if (!(field instanceof _primitives.Dict)) {
          return false;
        }

        if (field.has("Kids")) {
          if (++recursionDepth > RECURSION_LIMIT) {
            (0, _util.warn)("_hasOnlyDocumentSignatures: maximum recursion depth reached");
            return false;
          }

          return _this5._hasOnlyDocumentSignatures(field.get("Kids"), recursionDepth);
        }

        var isSignature = (0, _primitives.isName)(field.get("FT"), "Sig");
        var rectangle = field.get("Rect");
        var isInvisible = Array.isArray(rectangle) && rectangle.every(function (value) {
          return value === 0;
        });
        return isSignature && isInvisible;
      });
    }
  }, {
    key: "xfaData",
    get: function get() {
      var acroForm = this.catalog.acroForm;

      if (!acroForm) {
        return null;
      }

      var xfa = acroForm.get("XFA");
      var entries = {
        "xdp:xdp": "",
        template: "",
        datasets: "",
        config: "",
        connectionSet: "",
        localeSet: "",
        stylesheet: "",
        "/xdp:xdp": ""
      };

      if ((0, _primitives.isStream)(xfa) && !xfa.isEmpty) {
        try {
          entries["xdp:xdp"] = (0, _util.stringToUTF8String)(xfa.getString());
          return entries;
        } catch (_) {
          (0, _util.warn)("XFA - Invalid utf-8 string.");
          return null;
        }
      }

      if (!Array.isArray(xfa) || xfa.length === 0) {
        return null;
      }

      for (var i = 0, ii = xfa.length; i < ii; i += 2) {
        var name = void 0;

        if (i === 0) {
          name = "xdp:xdp";
        } else if (i === ii - 2) {
          name = "/xdp:xdp";
        } else {
          name = xfa[i];
        }

        if (!entries.hasOwnProperty(name)) {
          continue;
        }

        var data = this.xref.fetchIfRef(xfa[i + 1]);

        if (!(0, _primitives.isStream)(data) || data.isEmpty) {
          continue;
        }

        try {
          entries[name] = (0, _util.stringToUTF8String)(data.getString());
        } catch (_) {
          (0, _util.warn)("XFA - Invalid utf-8 string.");
          return null;
        }
      }

      return entries;
    }
  }, {
    key: "xfaFactory",
    get: function get() {
      if (this.pdfManager.enableXfa && this.formInfo.hasXfa && !this.formInfo.hasAcroForm) {
        var data = this.xfaData;
        return (0, _util.shadow)(this, "xfaFactory", data ? new _factory.XFAFactory(data) : null);
      }

      return (0, _util.shadow)(this, "xfaFaxtory", null);
    }
  }, {
    key: "isPureXfa",
    get: function get() {
      return this.xfaFactory !== null;
    }
  }, {
    key: "loadXfaFonts",
    value: function () {
      var _loadXfaFonts = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(handler, task) {
        var acroForm, resources, objectLoader, fontRes, partialEvaluator, operatorList, initialState, fonts, promises, _iterator5, _step5, _step5$value, fontName, font, descriptor, fontFamily, fontWeight, italicAngle, cssFontInfo;

        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.pdfManager.ensureCatalog("acroForm");

              case 2:
                acroForm = _context2.sent;

                if (acroForm) {
                  _context2.next = 5;
                  break;
                }

                return _context2.abrupt("return");

              case 5:
                _context2.next = 7;
                return acroForm.getAsync("DR");

              case 7:
                resources = _context2.sent;

                if (resources instanceof _primitives.Dict) {
                  _context2.next = 10;
                  break;
                }

                return _context2.abrupt("return");

              case 10:
                objectLoader = new _object_loader.ObjectLoader(resources, ["Font"], this.xref);
                _context2.next = 13;
                return objectLoader.load();

              case 13:
                fontRes = resources.get("Font");

                if (fontRes instanceof _primitives.Dict) {
                  _context2.next = 16;
                  break;
                }

                return _context2.abrupt("return");

              case 16:
                partialEvaluator = new _evaluator.PartialEvaluator({
                  xref: this.xref,
                  handler: handler,
                  pageIndex: -1,
                  idFactory: this._globalIdFactory,
                  fontCache: this.catalog.fontCache,
                  builtInCMapCache: this.catalog.builtInCMapCache
                });
                operatorList = new _operator_list.OperatorList();
                initialState = {
                  font: null,
                  clone: function clone() {
                    return this;
                  }
                };
                fonts = new Map();
                fontRes.forEach(function (fontName, font) {
                  fonts.set(fontName, font);
                });
                promises = [];
                _iterator5 = _createForOfIteratorHelper(fonts);
                _context2.prev = 23;

                _iterator5.s();

              case 25:
                if ((_step5 = _iterator5.n()).done) {
                  _context2.next = 39;
                  break;
                }

                _step5$value = _slicedToArray(_step5.value, 2), fontName = _step5$value[0], font = _step5$value[1];
                descriptor = font.get("FontDescriptor");

                if (descriptor instanceof _primitives.Dict) {
                  _context2.next = 30;
                  break;
                }

                return _context2.abrupt("continue", 37);

              case 30:
                fontFamily = descriptor.get("FontFamily");
                fontWeight = descriptor.get("FontWeight");
                italicAngle = -descriptor.get("ItalicAngle");
                cssFontInfo = {
                  fontFamily: fontFamily,
                  fontWeight: fontWeight,
                  italicAngle: italicAngle
                };

                if ((0, _core_utils.validateCSSFont)(cssFontInfo)) {
                  _context2.next = 36;
                  break;
                }

                return _context2.abrupt("continue", 37);

              case 36:
                promises.push(partialEvaluator.handleSetFont(resources, [_primitives.Name.get(fontName), 1], null, operatorList, task, initialState, null, cssFontInfo)["catch"](function (reason) {
                  (0, _util.warn)("loadXfaFonts: \"".concat(reason, "\"."));
                  return null;
                }));

              case 37:
                _context2.next = 25;
                break;

              case 39:
                _context2.next = 44;
                break;

              case 41:
                _context2.prev = 41;
                _context2.t0 = _context2["catch"](23);

                _iterator5.e(_context2.t0);

              case 44:
                _context2.prev = 44;

                _iterator5.f();

                return _context2.finish(44);

              case 47:
                _context2.next = 49;
                return Promise.all(promises);

              case 49:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[23, 41, 44, 47]]);
      }));

      function loadXfaFonts(_x, _x2) {
        return _loadXfaFonts.apply(this, arguments);
      }

      return loadXfaFonts;
    }()
  }, {
    key: "formInfo",
    get: function get() {
      var formInfo = {
        hasFields: false,
        hasAcroForm: false,
        hasXfa: false,
        hasSignatures: false
      };
      var acroForm = this.catalog.acroForm;

      if (!acroForm) {
        return (0, _util.shadow)(this, "formInfo", formInfo);
      }

      try {
        var fields = acroForm.get("Fields");
        var hasFields = Array.isArray(fields) && fields.length > 0;
        formInfo.hasFields = hasFields;
        var xfa = acroForm.get("XFA");
        formInfo.hasXfa = Array.isArray(xfa) && xfa.length > 0 || (0, _primitives.isStream)(xfa) && !xfa.isEmpty;
        var sigFlags = acroForm.get("SigFlags");
        var hasSignatures = !!(sigFlags & 0x1);

        var hasOnlyDocumentSignatures = hasSignatures && this._hasOnlyDocumentSignatures(fields);

        formInfo.hasAcroForm = hasFields && !hasOnlyDocumentSignatures;
        formInfo.hasSignatures = hasSignatures;
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }

        (0, _util.warn)("Cannot fetch form information: \"".concat(ex, "\"."));
      }

      return (0, _util.shadow)(this, "formInfo", formInfo);
    }
  }, {
    key: "documentInfo",
    get: function get() {
      var DocumentInfoValidators = {
        Title: _util.isString,
        Author: _util.isString,
        Subject: _util.isString,
        Keywords: _util.isString,
        Creator: _util.isString,
        Producer: _util.isString,
        CreationDate: _util.isString,
        ModDate: _util.isString,
        Trapped: _primitives.isName
      };
      var version = this._version;

      if (typeof version !== "string" || !PDF_HEADER_VERSION_REGEXP.test(version)) {
        (0, _util.warn)("Invalid PDF header version number: ".concat(version));
        version = null;
      }

      var docInfo = {
        PDFFormatVersion: version,
        IsLinearized: !!this.linearization,
        IsAcroFormPresent: this.formInfo.hasAcroForm,
        IsXFAPresent: this.formInfo.hasXfa,
        IsCollectionPresent: !!this.catalog.collection,
        IsSignaturesPresent: this.formInfo.hasSignatures
      };
      var infoDict;

      try {
        infoDict = this.xref.trailer.get("Info");
      } catch (err) {
        if (err instanceof _core_utils.MissingDataException) {
          throw err;
        }

        (0, _util.info)("The document information dictionary is invalid.");
      }

      if ((0, _primitives.isDict)(infoDict)) {
        var _iterator6 = _createForOfIteratorHelper(infoDict.getKeys()),
            _step6;

        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var key = _step6.value;
            var value = infoDict.get(key);

            if (DocumentInfoValidators[key]) {
              if (DocumentInfoValidators[key](value)) {
                docInfo[key] = typeof value !== "string" ? value : (0, _util.stringToPDFString)(value);
              } else {
                (0, _util.info)("Bad value in document info for \"".concat(key, "\"."));
              }
            } else if (typeof key === "string") {
              var customValue = void 0;

              if ((0, _util.isString)(value)) {
                customValue = (0, _util.stringToPDFString)(value);
              } else if ((0, _primitives.isName)(value) || (0, _util.isNum)(value) || (0, _util.isBool)(value)) {
                customValue = value;
              } else {
                (0, _util.info)("Unsupported value in document info for (custom) \"".concat(key, "\"."));
                continue;
              }

              if (!docInfo.Custom) {
                docInfo.Custom = Object.create(null);
              }

              docInfo.Custom[key] = customValue;
            }
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }
      }

      return (0, _util.shadow)(this, "documentInfo", docInfo);
    }
  }, {
    key: "fingerprint",
    get: function get() {
      var hash;
      var idArray = this.xref.trailer.get("ID");

      if (Array.isArray(idArray) && idArray[0] && (0, _util.isString)(idArray[0]) && idArray[0] !== EMPTY_FINGERPRINT) {
        hash = (0, _util.stringToBytes)(idArray[0]);
      } else {
        hash = (0, _crypto.calculateMD5)(this.stream.getByteRange(0, FINGERPRINT_FIRST_BYTES), 0, FINGERPRINT_FIRST_BYTES);
      }

      var fingerprintBuf = [];

      for (var i = 0, ii = hash.length; i < ii; i++) {
        var hex = hash[i].toString(16);
        fingerprintBuf.push(hex.padStart(2, "0"));
      }

      return (0, _util.shadow)(this, "fingerprint", fingerprintBuf.join(""));
    }
  }, {
    key: "_getLinearizationPage",
    value: function _getLinearizationPage(pageIndex) {
      var catalog = this.catalog,
          linearization = this.linearization;

      var ref = _primitives.Ref.get(linearization.objectNumberFirst, 0);

      return this.xref.fetchAsync(ref).then(function (obj) {
        if ((0, _primitives.isDict)(obj, "Page") || (0, _primitives.isDict)(obj) && !obj.has("Type") && obj.has("Contents")) {
          if (ref && !catalog.pageKidsCountCache.has(ref)) {
            catalog.pageKidsCountCache.put(ref, 1);
          }

          return [obj, ref];
        }

        throw new _util.FormatError("The Linearization dictionary doesn't point " + "to a valid Page dictionary.");
      })["catch"](function (reason) {
        (0, _util.info)(reason);
        return catalog.getPageDict(pageIndex);
      });
    }
  }, {
    key: "getPage",
    value: function getPage(pageIndex) {
      var _this6 = this;

      if (this._pagePromises[pageIndex] !== undefined) {
        return this._pagePromises[pageIndex];
      }

      var catalog = this.catalog,
          linearization = this.linearization;

      if (this.xfaFactory) {
        return Promise.resolve(new Page({
          pdfManager: this.pdfManager,
          xref: this.xref,
          pageIndex: pageIndex,
          pageDict: _primitives.Dict.empty,
          ref: null,
          globalIdFactory: this._globalIdFactory,
          fontCache: catalog.fontCache,
          builtInCMapCache: catalog.builtInCMapCache,
          globalImageCache: catalog.globalImageCache,
          nonBlendModesSet: catalog.nonBlendModesSet,
          xfaFactory: this.xfaFactory
        }));
      }

      var promise = linearization && linearization.pageFirst === pageIndex ? this._getLinearizationPage(pageIndex) : catalog.getPageDict(pageIndex);
      return this._pagePromises[pageIndex] = promise.then(function (_ref10) {
        var _ref11 = _slicedToArray(_ref10, 2),
            pageDict = _ref11[0],
            ref = _ref11[1];

        return new Page({
          pdfManager: _this6.pdfManager,
          xref: _this6.xref,
          pageIndex: pageIndex,
          pageDict: pageDict,
          ref: ref,
          globalIdFactory: _this6._globalIdFactory,
          fontCache: catalog.fontCache,
          builtInCMapCache: catalog.builtInCMapCache,
          globalImageCache: catalog.globalImageCache,
          nonBlendModesSet: catalog.nonBlendModesSet,
          xfaFactory: null
        });
      });
    }
  }, {
    key: "checkFirstPage",
    value: function checkFirstPage() {
      var _this7 = this;

      return this.getPage(0)["catch"]( /*#__PURE__*/function () {
        var _ref12 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(reason) {
          return _regenerator["default"].wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  if (!(reason instanceof _core_utils.XRefEntryException)) {
                    _context3.next = 5;
                    break;
                  }

                  _this7._pagePromises.length = 0;
                  _context3.next = 4;
                  return _this7.cleanup();

                case 4:
                  throw new _core_utils.XRefParseException();

                case 5:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        }));

        return function (_x3) {
          return _ref12.apply(this, arguments);
        };
      }());
    }
  }, {
    key: "fontFallback",
    value: function fontFallback(id, handler) {
      return this.catalog.fontFallback(id, handler);
    }
  }, {
    key: "cleanup",
    value: function () {
      var _cleanup = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4() {
        var manuallyTriggered,
            _args4 = arguments;
        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                manuallyTriggered = _args4.length > 0 && _args4[0] !== undefined ? _args4[0] : false;
                return _context4.abrupt("return", this.catalog ? this.catalog.cleanup(manuallyTriggered) : (0, _primitives.clearPrimitiveCaches)());

              case 2:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function cleanup() {
        return _cleanup.apply(this, arguments);
      }

      return cleanup;
    }()
  }, {
    key: "_collectFieldObjects",
    value: function _collectFieldObjects(name, fieldRef, promises) {
      var field = this.xref.fetchIfRef(fieldRef);

      if (field.has("T")) {
        var partName = (0, _util.stringToPDFString)(field.get("T"));

        if (name === "") {
          name = partName;
        } else {
          name = "".concat(name, ".").concat(partName);
        }
      }

      if (!promises.has(name)) {
        promises.set(name, []);
      }

      promises.get(name).push(_annotation.AnnotationFactory.create(this.xref, fieldRef, this.pdfManager, this._localIdFactory, true).then(function (annotation) {
        return annotation && annotation.getFieldObject();
      })["catch"](function (reason) {
        (0, _util.warn)("_collectFieldObjects: \"".concat(reason, "\"."));
        return null;
      }));

      if (field.has("Kids")) {
        var kids = field.get("Kids");

        var _iterator7 = _createForOfIteratorHelper(kids),
            _step7;

        try {
          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
            var kid = _step7.value;

            this._collectFieldObjects(name, kid, promises);
          }
        } catch (err) {
          _iterator7.e(err);
        } finally {
          _iterator7.f();
        }
      }
    }
  }, {
    key: "fieldObjects",
    get: function get() {
      if (!this.formInfo.hasFields) {
        return (0, _util.shadow)(this, "fieldObjects", Promise.resolve(null));
      }

      var allFields = Object.create(null);
      var fieldPromises = new Map();

      var _iterator8 = _createForOfIteratorHelper(this.catalog.acroForm.get("Fields")),
          _step8;

      try {
        for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
          var fieldRef = _step8.value;

          this._collectFieldObjects("", fieldRef, fieldPromises);
        }
      } catch (err) {
        _iterator8.e(err);
      } finally {
        _iterator8.f();
      }

      var allPromises = [];

      var _iterator9 = _createForOfIteratorHelper(fieldPromises),
          _step9;

      try {
        var _loop = function _loop() {
          var _step9$value = _slicedToArray(_step9.value, 2),
              name = _step9$value[0],
              promises = _step9$value[1];

          allPromises.push(Promise.all(promises).then(function (fields) {
            fields = fields.filter(function (field) {
              return !!field;
            });

            if (fields.length > 0) {
              allFields[name] = fields;
            }
          }));
        };

        for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator9.e(err);
      } finally {
        _iterator9.f();
      }

      return (0, _util.shadow)(this, "fieldObjects", Promise.all(allPromises).then(function () {
        return allFields;
      }));
    }
  }, {
    key: "hasJSActions",
    get: function get() {
      var promise = this.pdfManager.ensureDoc("_parseHasJSActions");
      return (0, _util.shadow)(this, "hasJSActions", promise);
    }
  }, {
    key: "_parseHasJSActions",
    value: function () {
      var _parseHasJSActions2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5() {
        var _yield$Promise$all, _yield$Promise$all2, catalogJsActions, fieldObjects;

        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                _context5.next = 2;
                return Promise.all([this.pdfManager.ensureCatalog("jsActions"), this.pdfManager.ensureDoc("fieldObjects")]);

              case 2:
                _yield$Promise$all = _context5.sent;
                _yield$Promise$all2 = _slicedToArray(_yield$Promise$all, 2);
                catalogJsActions = _yield$Promise$all2[0];
                fieldObjects = _yield$Promise$all2[1];

                if (!catalogJsActions) {
                  _context5.next = 8;
                  break;
                }

                return _context5.abrupt("return", true);

              case 8:
                if (!fieldObjects) {
                  _context5.next = 10;
                  break;
                }

                return _context5.abrupt("return", Object.values(fieldObjects).some(function (fieldObject) {
                  return fieldObject.some(function (object) {
                    return object.actions !== null;
                  });
                }));

              case 10:
                return _context5.abrupt("return", false);

              case 11:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function _parseHasJSActions() {
        return _parseHasJSActions2.apply(this, arguments);
      }

      return _parseHasJSActions;
    }()
  }, {
    key: "calculationOrderIds",
    get: function get() {
      var acroForm = this.catalog.acroForm;

      if (!acroForm || !acroForm.has("CO")) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      var calculationOrder = acroForm.get("CO");

      if (!Array.isArray(calculationOrder) || calculationOrder.length === 0) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      var ids = calculationOrder.filter(_primitives.isRef).map(function (ref) {
        return ref.toString();
      });

      if (ids.length === 0) {
        return (0, _util.shadow)(this, "calculationOrderIds", null);
      }

      return (0, _util.shadow)(this, "calculationOrderIds", ids);
    }
  }]);

  return PDFDocument;
}();

exports.PDFDocument = PDFDocument;

/***/ }),
/* 120 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.getQuadPoints = getQuadPoints;
exports.MarkupAnnotation = exports.AnnotationFactory = exports.AnnotationBorderStyle = exports.Annotation = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(117);

var _default_appearance = __w_pdfjs_require__(121);

var _primitives = __w_pdfjs_require__(113);

var _catalog = __w_pdfjs_require__(165);

var _colorspace = __w_pdfjs_require__(122);

var _file_spec = __w_pdfjs_require__(167);

var _object_loader = __w_pdfjs_require__(171);

var _operator_list = __w_pdfjs_require__(163);

var _stream = __w_pdfjs_require__(118);

var _writer = __w_pdfjs_require__(172);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var AnnotationFactory = /*#__PURE__*/function () {
  function AnnotationFactory() {
    _classCallCheck(this, AnnotationFactory);
  }

  _createClass(AnnotationFactory, null, [{
    key: "create",
    value: function create(xref, ref, pdfManager, idFactory, collectFields) {
      var _this = this;

      return Promise.all([pdfManager.ensureCatalog("acroForm"), collectFields ? this._getPageIndex(xref, ref, pdfManager) : -1]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            acroForm = _ref2[0],
            pageIndex = _ref2[1];

        return pdfManager.ensure(_this, "_create", [xref, ref, pdfManager, idFactory, acroForm, collectFields, pageIndex]);
      });
    }
  }, {
    key: "_create",
    value: function _create(xref, ref, pdfManager, idFactory, acroForm, collectFields) {
      var pageIndex = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : -1;
      var dict = xref.fetchIfRef(ref);

      if (!(0, _primitives.isDict)(dict)) {
        return undefined;
      }

      var id = (0, _primitives.isRef)(ref) ? ref.toString() : "annot_".concat(idFactory.createObjId());
      var subtype = dict.get("Subtype");
      subtype = (0, _primitives.isName)(subtype) ? subtype.name : null;
      var parameters = {
        xref: xref,
        ref: ref,
        dict: dict,
        subtype: subtype,
        id: id,
        pdfManager: pdfManager,
        acroForm: acroForm instanceof _primitives.Dict ? acroForm : _primitives.Dict.empty,
        collectFields: collectFields,
        pageIndex: pageIndex
      };

      switch (subtype) {
        case "Link":
          return new LinkAnnotation(parameters);

        case "Text":
          return new TextAnnotation(parameters);

        case "Widget":
          var fieldType = (0, _core_utils.getInheritableProperty)({
            dict: dict,
            key: "FT"
          });
          fieldType = (0, _primitives.isName)(fieldType) ? fieldType.name : null;

          switch (fieldType) {
            case "Tx":
              return new TextWidgetAnnotation(parameters);

            case "Btn":
              return new ButtonWidgetAnnotation(parameters);

            case "Ch":
              return new ChoiceWidgetAnnotation(parameters);

            case "Sig":
              return new SignatureWidgetAnnotation(parameters);
          }

          (0, _util.warn)("Unimplemented widget field type \"".concat(fieldType, "\", ") + "falling back to base field type.");
          return new WidgetAnnotation(parameters);

        case "Popup":
          return new PopupAnnotation(parameters);

        case "FreeText":
          return new FreeTextAnnotation(parameters);

        case "Line":
          return new LineAnnotation(parameters);

        case "Square":
          return new SquareAnnotation(parameters);

        case "Circle":
          return new CircleAnnotation(parameters);

        case "PolyLine":
          return new PolylineAnnotation(parameters);

        case "Polygon":
          return new PolygonAnnotation(parameters);

        case "Caret":
          return new CaretAnnotation(parameters);

        case "Ink":
          return new InkAnnotation(parameters);

        case "Highlight":
          return new HighlightAnnotation(parameters);

        case "Underline":
          return new UnderlineAnnotation(parameters);

        case "Squiggly":
          return new SquigglyAnnotation(parameters);

        case "StrikeOut":
          return new StrikeOutAnnotation(parameters);

        case "Stamp":
          return new StampAnnotation(parameters);

        case "FileAttachment":
          return new FileAttachmentAnnotation(parameters);

        default:
          if (!collectFields) {
            if (!subtype) {
              (0, _util.warn)("Annotation is missing the required /Subtype.");
            } else {
              (0, _util.warn)("Unimplemented annotation type \"".concat(subtype, "\", ") + "falling back to base annotation.");
            }
          }

          return new Annotation(parameters);
      }
    }
  }, {
    key: "_getPageIndex",
    value: function () {
      var _getPageIndex2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(xref, ref, pdfManager) {
        var annotDict, pageRef, pageIndex;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return xref.fetchIfRefAsync(ref);

              case 3:
                annotDict = _context.sent;

                if ((0, _primitives.isDict)(annotDict)) {
                  _context.next = 6;
                  break;
                }

                return _context.abrupt("return", -1);

              case 6:
                pageRef = annotDict.getRaw("P");

                if ((0, _primitives.isRef)(pageRef)) {
                  _context.next = 9;
                  break;
                }

                return _context.abrupt("return", -1);

              case 9:
                _context.next = 11;
                return pdfManager.ensureCatalog("getPageIndex", [pageRef]);

              case 11:
                pageIndex = _context.sent;
                return _context.abrupt("return", pageIndex);

              case 15:
                _context.prev = 15;
                _context.t0 = _context["catch"](0);
                (0, _util.warn)("_getPageIndex: \"".concat(_context.t0, "\"."));
                return _context.abrupt("return", -1);

              case 19:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 15]]);
      }));

      function _getPageIndex(_x, _x2, _x3) {
        return _getPageIndex2.apply(this, arguments);
      }

      return _getPageIndex;
    }()
  }]);

  return AnnotationFactory;
}();

exports.AnnotationFactory = AnnotationFactory;

function getRgbColor(color) {
  var rgbColor = new Uint8ClampedArray(3);

  if (!Array.isArray(color)) {
    return rgbColor;
  }

  switch (color.length) {
    case 0:
      return null;

    case 1:
      _colorspace.ColorSpace.singletons.gray.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 3:
      _colorspace.ColorSpace.singletons.rgb.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    case 4:
      _colorspace.ColorSpace.singletons.cmyk.getRgbItem(color, 0, rgbColor, 0);

      return rgbColor;

    default:
      return rgbColor;
  }
}

function getQuadPoints(dict, rect) {
  if (!dict.has("QuadPoints")) {
    return null;
  }

  var quadPoints = dict.getArray("QuadPoints");

  if (!Array.isArray(quadPoints) || quadPoints.length === 0 || quadPoints.length % 8 > 0) {
    return null;
  }

  var quadPointsLists = [];

  for (var i = 0, ii = quadPoints.length / 8; i < ii; i++) {
    quadPointsLists.push([]);

    for (var j = i * 8, jj = i * 8 + 8; j < jj; j += 2) {
      var x = quadPoints[j];
      var y = quadPoints[j + 1];

      if (rect !== null && (x < rect[0] || x > rect[2] || y < rect[1] || y > rect[3])) {
        return null;
      }

      quadPointsLists[i].push({
        x: x,
        y: y
      });
    }
  }

  return quadPointsLists.map(function (quadPointsList) {
    var _quadPointsList$reduc = quadPointsList.reduce(function (_ref3, quadPoint) {
      var _ref4 = _slicedToArray(_ref3, 4),
          mX = _ref4[0],
          MX = _ref4[1],
          mY = _ref4[2],
          MY = _ref4[3];

      return [Math.min(mX, quadPoint.x), Math.max(MX, quadPoint.x), Math.min(mY, quadPoint.y), Math.max(MY, quadPoint.y)];
    }, [Number.MAX_VALUE, Number.MIN_VALUE, Number.MAX_VALUE, Number.MIN_VALUE]),
        _quadPointsList$reduc2 = _slicedToArray(_quadPointsList$reduc, 4),
        minX = _quadPointsList$reduc2[0],
        maxX = _quadPointsList$reduc2[1],
        minY = _quadPointsList$reduc2[2],
        maxY = _quadPointsList$reduc2[3];

    return [{
      x: minX,
      y: maxY
    }, {
      x: maxX,
      y: maxY
    }, {
      x: minX,
      y: minY
    }, {
      x: maxX,
      y: minY
    }];
  });
}

function getTransformMatrix(rect, bbox, matrix) {
  var _Util$getAxialAligned = _util.Util.getAxialAlignedBoundingBox(bbox, matrix),
      _Util$getAxialAligned2 = _slicedToArray(_Util$getAxialAligned, 4),
      minX = _Util$getAxialAligned2[0],
      minY = _Util$getAxialAligned2[1],
      maxX = _Util$getAxialAligned2[2],
      maxY = _Util$getAxialAligned2[3];

  if (minX === maxX || minY === maxY) {
    return [1, 0, 0, 1, rect[0], rect[1]];
  }

  var xRatio = (rect[2] - rect[0]) / (maxX - minX);
  var yRatio = (rect[3] - rect[1]) / (maxY - minY);
  return [xRatio, 0, 0, yRatio, rect[0] - minX * xRatio, rect[1] - minY * yRatio];
}

var Annotation = /*#__PURE__*/function () {
  function Annotation(params) {
    _classCallCheck(this, Annotation);

    var dict = params.dict;
    this.setContents(dict.get("Contents"));
    this.setModificationDate(dict.get("M"));
    this.setFlags(dict.get("F"));
    this.setRectangle(dict.getArray("Rect"));
    this.setColor(dict.getArray("C"));
    this.setBorderStyle(dict);
    this.setAppearance(dict);
    this._streams = [];

    if (this.appearance) {
      this._streams.push(this.appearance);
    }

    this.data = {
      annotationFlags: this.flags,
      borderStyle: this.borderStyle,
      color: this.color,
      contents: this.contents,
      hasAppearance: !!this.appearance,
      id: params.id,
      modificationDate: this.modificationDate,
      rect: this.rectangle,
      subtype: params.subtype
    };

    if (params.collectFields) {
      var kids = dict.get("Kids");

      if (Array.isArray(kids)) {
        var kidIds = [];

        var _iterator = _createForOfIteratorHelper(kids),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var kid = _step.value;

            if ((0, _primitives.isRef)(kid)) {
              kidIds.push(kid.toString());
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        if (kidIds.length !== 0) {
          this.data.kidIds = kidIds;
        }
      }

      this.data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
      this.data.fieldName = this._constructFieldName(dict);
      this.data.pageIndex = params.pageIndex;
    }

    this._fallbackFontDict = null;
  }

  _createClass(Annotation, [{
    key: "_hasFlag",
    value: function _hasFlag(flags, flag) {
      return !!(flags & flag);
    }
  }, {
    key: "_isViewable",
    value: function _isViewable(flags) {
      return !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE) && !this._hasFlag(flags, _util.AnnotationFlag.NOVIEW);
    }
  }, {
    key: "_isPrintable",
    value: function _isPrintable(flags) {
      return this._hasFlag(flags, _util.AnnotationFlag.PRINT) && !this._hasFlag(flags, _util.AnnotationFlag.INVISIBLE);
    }
  }, {
    key: "mustBeViewed",
    value: function mustBeViewed(annotationStorage) {
      var storageEntry = annotationStorage && annotationStorage.get(this.data.id);

      if (storageEntry && storageEntry.hidden !== undefined) {
        return !storageEntry.hidden;
      }

      return this.viewable && !this._hasFlag(this.flags, _util.AnnotationFlag.HIDDEN);
    }
  }, {
    key: "mustBePrinted",
    value: function mustBePrinted(annotationStorage) {
      var storageEntry = annotationStorage && annotationStorage.get(this.data.id);

      if (storageEntry && storageEntry.print !== undefined) {
        return storageEntry.print;
      }

      return this.printable;
    }
  }, {
    key: "viewable",
    get: function get() {
      if (this.data.quadPoints === null) {
        return false;
      }

      if (this.flags === 0) {
        return true;
      }

      return this._isViewable(this.flags);
    }
  }, {
    key: "printable",
    get: function get() {
      if (this.data.quadPoints === null) {
        return false;
      }

      if (this.flags === 0) {
        return false;
      }

      return this._isPrintable(this.flags);
    }
  }, {
    key: "setContents",
    value: function setContents(contents) {
      this.contents = (0, _util.stringToPDFString)(contents || "");
    }
  }, {
    key: "setModificationDate",
    value: function setModificationDate(modificationDate) {
      this.modificationDate = (0, _util.isString)(modificationDate) ? modificationDate : null;
    }
  }, {
    key: "setFlags",
    value: function setFlags(flags) {
      this.flags = Number.isInteger(flags) && flags > 0 ? flags : 0;
    }
  }, {
    key: "hasFlag",
    value: function hasFlag(flag) {
      return this._hasFlag(this.flags, flag);
    }
  }, {
    key: "setRectangle",
    value: function setRectangle(rectangle) {
      if (Array.isArray(rectangle) && rectangle.length === 4) {
        this.rectangle = _util.Util.normalizeRect(rectangle);
      } else {
        this.rectangle = [0, 0, 0, 0];
      }
    }
  }, {
    key: "setColor",
    value: function setColor(color) {
      this.color = getRgbColor(color);
    }
  }, {
    key: "setBorderStyle",
    value: function setBorderStyle(borderStyle) {
      this.borderStyle = new AnnotationBorderStyle();

      if (!(0, _primitives.isDict)(borderStyle)) {
        return;
      }

      if (borderStyle.has("BS")) {
        var dict = borderStyle.get("BS");
        var dictType = dict.get("Type");

        if (!dictType || (0, _primitives.isName)(dictType, "Border")) {
          this.borderStyle.setWidth(dict.get("W"), this.rectangle);
          this.borderStyle.setStyle(dict.get("S"));
          this.borderStyle.setDashArray(dict.getArray("D"));
        }
      } else if (borderStyle.has("Border")) {
        var array = borderStyle.getArray("Border");

        if (Array.isArray(array) && array.length >= 3) {
          this.borderStyle.setHorizontalCornerRadius(array[0]);
          this.borderStyle.setVerticalCornerRadius(array[1]);
          this.borderStyle.setWidth(array[2], this.rectangle);

          if (array.length === 4) {
            this.borderStyle.setDashArray(array[3]);
          }
        }
      } else {
        this.borderStyle.setWidth(0);
      }
    }
  }, {
    key: "setAppearance",
    value: function setAppearance(dict) {
      this.appearance = null;
      var appearanceStates = dict.get("AP");

      if (!(0, _primitives.isDict)(appearanceStates)) {
        return;
      }

      var normalAppearanceState = appearanceStates.get("N");

      if ((0, _primitives.isStream)(normalAppearanceState)) {
        this.appearance = normalAppearanceState;
        return;
      }

      if (!(0, _primitives.isDict)(normalAppearanceState)) {
        return;
      }

      var as = dict.get("AS");

      if (!(0, _primitives.isName)(as) || !normalAppearanceState.has(as.name)) {
        return;
      }

      this.appearance = normalAppearanceState.get(as.name);
    }
  }, {
    key: "loadResources",
    value: function loadResources(keys) {
      return this.appearance.dict.getAsync("Resources").then(function (resources) {
        if (!resources) {
          return undefined;
        }

        var objectLoader = new _object_loader.ObjectLoader(resources, keys, resources.xref);
        return objectLoader.load().then(function () {
          return resources;
        });
      });
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(evaluator, task, renderForms, annotationStorage) {
      var _this2 = this;

      if (!this.appearance) {
        return Promise.resolve(new _operator_list.OperatorList());
      }

      var appearance = this.appearance;
      var data = this.data;
      var appearanceDict = appearance.dict;
      var resourcesPromise = this.loadResources(["ExtGState", "ColorSpace", "Pattern", "Shading", "XObject", "Font"]);
      var bbox = appearanceDict.getArray("BBox") || [0, 0, 1, 1];
      var matrix = appearanceDict.getArray("Matrix") || [1, 0, 0, 1, 0, 0];
      var transform = getTransformMatrix(data.rect, bbox, matrix);
      return resourcesPromise.then(function (resources) {
        var opList = new _operator_list.OperatorList();
        opList.addOp(_util.OPS.beginAnnotation, [data.rect, transform, matrix]);
        return evaluator.getOperatorList({
          stream: appearance,
          task: task,
          resources: resources,
          operatorList: opList,
          fallbackFontDict: _this2._fallbackFontDict
        }).then(function () {
          opList.addOp(_util.OPS.endAnnotation, []);

          _this2.reset();

          return opList;
        });
      });
    }
  }, {
    key: "save",
    value: function () {
      var _save = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(evaluator, task, annotationStorage) {
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                return _context2.abrupt("return", null);

              case 1:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function save(_x4, _x5, _x6) {
        return _save.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      if (this.data.kidIds) {
        return {
          id: this.data.id,
          actions: this.data.actions,
          name: this.data.fieldName,
          type: "",
          kidIds: this.data.kidIds,
          page: this.data.pageIndex
        };
      }

      return null;
    }
  }, {
    key: "reset",
    value: function reset() {
      var _iterator2 = _createForOfIteratorHelper(this._streams),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var stream = _step2.value;
          stream.reset();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "_constructFieldName",
    value: function _constructFieldName(dict) {
      if (!dict.has("T") && !dict.has("Parent")) {
        (0, _util.warn)("Unknown field name, falling back to empty field name.");
        return "";
      }

      if (!dict.has("Parent")) {
        return (0, _util.stringToPDFString)(dict.get("T"));
      }

      var fieldName = [];

      if (dict.has("T")) {
        fieldName.unshift((0, _util.stringToPDFString)(dict.get("T")));
      }

      var loopDict = dict;
      var visited = new _primitives.RefSet();

      if (dict.objId) {
        visited.put(dict.objId);
      }

      while (loopDict.has("Parent")) {
        loopDict = loopDict.get("Parent");

        if (!(loopDict instanceof _primitives.Dict) || loopDict.objId && visited.has(loopDict.objId)) {
          break;
        }

        if (loopDict.objId) {
          visited.put(loopDict.objId);
        }

        if (loopDict.has("T")) {
          fieldName.unshift((0, _util.stringToPDFString)(loopDict.get("T")));
        }
      }

      return fieldName.join(".");
    }
  }]);

  return Annotation;
}();

exports.Annotation = Annotation;

var AnnotationBorderStyle = /*#__PURE__*/function () {
  function AnnotationBorderStyle() {
    _classCallCheck(this, AnnotationBorderStyle);

    this.width = 1;
    this.style = _util.AnnotationBorderStyleType.SOLID;
    this.dashArray = [3];
    this.horizontalCornerRadius = 0;
    this.verticalCornerRadius = 0;
  }

  _createClass(AnnotationBorderStyle, [{
    key: "setWidth",
    value: function setWidth(width) {
      var rect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0, 0, 0];

      if ((0, _primitives.isName)(width)) {
        this.width = 0;
        return;
      }

      if (Number.isInteger(width)) {
        if (width > 0) {
          var maxWidth = (rect[2] - rect[0]) / 2;
          var maxHeight = (rect[3] - rect[1]) / 2;

          if (maxWidth > 0 && maxHeight > 0 && (width > maxWidth || width > maxHeight)) {
            (0, _util.warn)("AnnotationBorderStyle.setWidth - ignoring width: ".concat(width));
            width = 1;
          }
        }

        this.width = width;
      }
    }
  }, {
    key: "setStyle",
    value: function setStyle(style) {
      if (!(0, _primitives.isName)(style)) {
        return;
      }

      switch (style.name) {
        case "S":
          this.style = _util.AnnotationBorderStyleType.SOLID;
          break;

        case "D":
          this.style = _util.AnnotationBorderStyleType.DASHED;
          break;

        case "B":
          this.style = _util.AnnotationBorderStyleType.BEVELED;
          break;

        case "I":
          this.style = _util.AnnotationBorderStyleType.INSET;
          break;

        case "U":
          this.style = _util.AnnotationBorderStyleType.UNDERLINE;
          break;

        default:
          break;
      }
    }
  }, {
    key: "setDashArray",
    value: function setDashArray(dashArray) {
      if (Array.isArray(dashArray) && dashArray.length > 0) {
        var isValid = true;
        var allZeros = true;

        var _iterator3 = _createForOfIteratorHelper(dashArray),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var element = _step3.value;
            var validNumber = +element >= 0;

            if (!validNumber) {
              isValid = false;
              break;
            } else if (element > 0) {
              allZeros = false;
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        if (isValid && !allZeros) {
          this.dashArray = dashArray;
        } else {
          this.width = 0;
        }
      } else if (dashArray) {
        this.width = 0;
      }
    }
  }, {
    key: "setHorizontalCornerRadius",
    value: function setHorizontalCornerRadius(radius) {
      if (Number.isInteger(radius)) {
        this.horizontalCornerRadius = radius;
      }
    }
  }, {
    key: "setVerticalCornerRadius",
    value: function setVerticalCornerRadius(radius) {
      if (Number.isInteger(radius)) {
        this.verticalCornerRadius = radius;
      }
    }
  }]);

  return AnnotationBorderStyle;
}();

exports.AnnotationBorderStyle = AnnotationBorderStyle;

var MarkupAnnotation = /*#__PURE__*/function (_Annotation) {
  _inherits(MarkupAnnotation, _Annotation);

  var _super = _createSuper(MarkupAnnotation);

  function MarkupAnnotation(parameters) {
    var _this3;

    _classCallCheck(this, MarkupAnnotation);

    _this3 = _super.call(this, parameters);
    var dict = parameters.dict;

    if (dict.has("IRT")) {
      var rawIRT = dict.getRaw("IRT");
      _this3.data.inReplyTo = (0, _primitives.isRef)(rawIRT) ? rawIRT.toString() : null;
      var rt = dict.get("RT");
      _this3.data.replyType = (0, _primitives.isName)(rt) ? rt.name : _util.AnnotationReplyType.REPLY;
    }

    if (_this3.data.replyType === _util.AnnotationReplyType.GROUP) {
      var parent = dict.get("IRT");
      _this3.data.title = (0, _util.stringToPDFString)(parent.get("T") || "");

      _this3.setContents(parent.get("Contents"));

      _this3.data.contents = _this3.contents;

      if (!parent.has("CreationDate")) {
        _this3.data.creationDate = null;
      } else {
        _this3.setCreationDate(parent.get("CreationDate"));

        _this3.data.creationDate = _this3.creationDate;
      }

      if (!parent.has("M")) {
        _this3.data.modificationDate = null;
      } else {
        _this3.setModificationDate(parent.get("M"));

        _this3.data.modificationDate = _this3.modificationDate;
      }

      _this3.data.hasPopup = parent.has("Popup");

      if (!parent.has("C")) {
        _this3.data.color = null;
      } else {
        _this3.setColor(parent.getArray("C"));

        _this3.data.color = _this3.color;
      }
    } else {
      _this3.data.title = (0, _util.stringToPDFString)(dict.get("T") || "");

      _this3.setCreationDate(dict.get("CreationDate"));

      _this3.data.creationDate = _this3.creationDate;
      _this3.data.hasPopup = dict.has("Popup");

      if (!dict.has("C")) {
        _this3.data.color = null;
      }
    }

    return _this3;
  }

  _createClass(MarkupAnnotation, [{
    key: "setCreationDate",
    value: function setCreationDate(creationDate) {
      this.creationDate = (0, _util.isString)(creationDate) ? creationDate : null;
    }
  }, {
    key: "_setDefaultAppearance",
    value: function _setDefaultAppearance(_ref5) {
      var xref = _ref5.xref,
          extra = _ref5.extra,
          strokeColor = _ref5.strokeColor,
          fillColor = _ref5.fillColor,
          blendMode = _ref5.blendMode,
          strokeAlpha = _ref5.strokeAlpha,
          fillAlpha = _ref5.fillAlpha,
          pointsCallback = _ref5.pointsCallback;
      var minX = Number.MAX_VALUE;
      var minY = Number.MAX_VALUE;
      var maxX = Number.MIN_VALUE;
      var maxY = Number.MIN_VALUE;
      var buffer = ["q"];

      if (extra) {
        buffer.push(extra);
      }

      if (strokeColor) {
        buffer.push("".concat(strokeColor[0], " ").concat(strokeColor[1], " ").concat(strokeColor[2], " RG"));
      }

      if (fillColor) {
        buffer.push("".concat(fillColor[0], " ").concat(fillColor[1], " ").concat(fillColor[2], " rg"));
      }

      var pointsArray = this.data.quadPoints;

      if (!pointsArray) {
        pointsArray = [[{
          x: this.rectangle[0],
          y: this.rectangle[3]
        }, {
          x: this.rectangle[2],
          y: this.rectangle[3]
        }, {
          x: this.rectangle[0],
          y: this.rectangle[1]
        }, {
          x: this.rectangle[2],
          y: this.rectangle[1]
        }]];
      }

      var _iterator4 = _createForOfIteratorHelper(pointsArray),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var points = _step4.value;

          var _pointsCallback = pointsCallback(buffer, points),
              _pointsCallback2 = _slicedToArray(_pointsCallback, 4),
              mX = _pointsCallback2[0],
              MX = _pointsCallback2[1],
              mY = _pointsCallback2[2],
              MY = _pointsCallback2[3];

          minX = Math.min(minX, mX);
          maxX = Math.max(maxX, MX);
          minY = Math.min(minY, mY);
          maxY = Math.max(maxY, MY);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      buffer.push("Q");
      var formDict = new _primitives.Dict(xref);
      var appearanceStreamDict = new _primitives.Dict(xref);
      appearanceStreamDict.set("Subtype", _primitives.Name.get("Form"));
      var appearanceStream = new _stream.StringStream(buffer.join(" "));
      appearanceStream.dict = appearanceStreamDict;
      formDict.set("Fm0", appearanceStream);
      var gsDict = new _primitives.Dict(xref);

      if (blendMode) {
        gsDict.set("BM", _primitives.Name.get(blendMode));
      }

      if (typeof strokeAlpha === "number") {
        gsDict.set("CA", strokeAlpha);
      }

      if (typeof fillAlpha === "number") {
        gsDict.set("ca", fillAlpha);
      }

      var stateDict = new _primitives.Dict(xref);
      stateDict.set("GS0", gsDict);
      var resources = new _primitives.Dict(xref);
      resources.set("ExtGState", stateDict);
      resources.set("XObject", formDict);
      var appearanceDict = new _primitives.Dict(xref);
      appearanceDict.set("Resources", resources);
      var bbox = this.data.rect = [minX, minY, maxX, maxY];
      appearanceDict.set("BBox", bbox);
      this.appearance = new _stream.StringStream("/GS0 gs /Fm0 Do");
      this.appearance.dict = appearanceDict;

      this._streams.push(this.appearance, appearanceStream);
    }
  }]);

  return MarkupAnnotation;
}(Annotation);

exports.MarkupAnnotation = MarkupAnnotation;

var WidgetAnnotation = /*#__PURE__*/function (_Annotation2) {
  _inherits(WidgetAnnotation, _Annotation2);

  var _super2 = _createSuper(WidgetAnnotation);

  function WidgetAnnotation(params) {
    var _this4;

    _classCallCheck(this, WidgetAnnotation);

    _this4 = _super2.call(this, params);
    var dict = params.dict;
    var data = _this4.data;
    _this4.ref = params.ref;
    data.annotationType = _util.AnnotationType.WIDGET;

    if (data.fieldName === undefined) {
      data.fieldName = _this4._constructFieldName(dict);
    }

    if (data.actions === undefined) {
      data.actions = (0, _core_utils.collectActions)(params.xref, dict, _util.AnnotationActionEventType);
    }

    var fieldValue = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "V",
      getArray: true
    });
    data.fieldValue = _this4._decodeFormValue(fieldValue);
    var defaultFieldValue = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DV",
      getArray: true
    });
    data.defaultFieldValue = _this4._decodeFormValue(defaultFieldValue);
    data.alternativeText = (0, _util.stringToPDFString)(dict.get("TU") || "");
    var defaultAppearance = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DA"
    }) || params.acroForm.get("DA");
    _this4._defaultAppearance = (0, _util.isString)(defaultAppearance) ? defaultAppearance : "";
    data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(_this4._defaultAppearance);
    var fieldType = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "FT"
    });
    data.fieldType = (0, _primitives.isName)(fieldType) ? fieldType.name : null;
    var localResources = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "DR"
    });
    var acroFormResources = params.acroForm.get("DR");

    var appearanceResources = _this4.appearance && _this4.appearance.dict.get("Resources");

    _this4._fieldResources = {
      localResources: localResources,
      acroFormResources: acroFormResources,
      appearanceResources: appearanceResources,
      mergedResources: _primitives.Dict.merge({
        xref: params.xref,
        dictArray: [localResources, appearanceResources, acroFormResources],
        mergeSubDicts: true
      })
    };
    data.fieldFlags = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "Ff"
    });

    if (!Number.isInteger(data.fieldFlags) || data.fieldFlags < 0) {
      data.fieldFlags = 0;
    }

    data.readOnly = _this4.hasFieldFlag(_util.AnnotationFieldFlag.READONLY);
    data.hidden = _this4._hasFlag(data.annotationFlags, _util.AnnotationFlag.HIDDEN);
    return _this4;
  }

  _createClass(WidgetAnnotation, [{
    key: "_decodeFormValue",
    value: function _decodeFormValue(formValue) {
      if (Array.isArray(formValue)) {
        return formValue.filter(function (item) {
          return (0, _util.isString)(item);
        }).map(function (item) {
          return (0, _util.stringToPDFString)(item);
        });
      } else if ((0, _primitives.isName)(formValue)) {
        return (0, _util.stringToPDFString)(formValue.name);
      } else if ((0, _util.isString)(formValue)) {
        return (0, _util.stringToPDFString)(formValue);
      }

      return null;
    }
  }, {
    key: "hasFieldFlag",
    value: function hasFieldFlag(flag) {
      return !!(this.data.fieldFlags & flag);
    }
  }, {
    key: "getOperatorList",
    value: function getOperatorList(evaluator, task, renderForms, annotationStorage) {
      var _this5 = this;

      if (renderForms && !(this instanceof SignatureWidgetAnnotation)) {
        return Promise.resolve(new _operator_list.OperatorList());
      }

      if (!this._hasText) {
        return _get(_getPrototypeOf(WidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, renderForms, annotationStorage);
      }

      return this._getAppearance(evaluator, task, annotationStorage).then(function (content) {
        if (_this5.appearance && content === null) {
          return _get(_getPrototypeOf(WidgetAnnotation.prototype), "getOperatorList", _this5).call(_this5, evaluator, task, renderForms, annotationStorage);
        }

        var operatorList = new _operator_list.OperatorList();

        if (!_this5._defaultAppearance || content === null) {
          return operatorList;
        }

        var matrix = [1, 0, 0, 1, 0, 0];
        var bbox = [0, 0, _this5.data.rect[2] - _this5.data.rect[0], _this5.data.rect[3] - _this5.data.rect[1]];
        var transform = getTransformMatrix(_this5.data.rect, bbox, matrix);
        operatorList.addOp(_util.OPS.beginAnnotation, [_this5.data.rect, transform, matrix]);
        var stream = new _stream.StringStream(content);
        return evaluator.getOperatorList({
          stream: stream,
          task: task,
          resources: _this5._fieldResources.mergedResources,
          operatorList: operatorList
        }).then(function () {
          operatorList.addOp(_util.OPS.endAnnotation, []);
          return operatorList;
        });
      });
    }
  }, {
    key: "save",
    value: function () {
      var _save2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(evaluator, task, annotationStorage) {
        var storageEntry, value, appearance, xref, dict, bbox, xfa, newRef, AP, encrypt, originalTransform, newTransform, appearanceDict, bufferOriginal, bufferNew;
        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                if (annotationStorage) {
                  _context3.next = 2;
                  break;
                }

                return _context3.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === this.data.fieldValue || value === undefined)) {
                  _context3.next = 6;
                  break;
                }

                return _context3.abrupt("return", null);

              case 6:
                _context3.next = 8;
                return this._getAppearance(evaluator, task, annotationStorage);

              case 8:
                appearance = _context3.sent;

                if (!(appearance === null)) {
                  _context3.next = 11;
                  break;
                }

                return _context3.abrupt("return", null);

              case 11:
                xref = evaluator.xref;
                dict = xref.fetchIfRef(this.ref);

                if ((0, _primitives.isDict)(dict)) {
                  _context3.next = 15;
                  break;
                }

                return _context3.abrupt("return", null);

              case 15:
                bbox = [0, 0, this.data.rect[2] - this.data.rect[0], this.data.rect[3] - this.data.rect[1]];
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value
                };
                newRef = xref.getNewRef();
                AP = new _primitives.Dict(xref);
                AP.set("N", newRef);
                encrypt = xref.encrypt;
                originalTransform = null;
                newTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                  newTransform = encrypt.createCipherTransform(newRef.num, newRef.gen);
                  appearance = newTransform.encryptString(appearance);
                }

                dict.set("V", (0, _util.isAscii)(value) ? value : (0, _util.stringToUTF16BEString)(value));
                dict.set("AP", AP);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                appearanceDict = new _primitives.Dict(xref);
                appearanceDict.set("Length", appearance.length);
                appearanceDict.set("Subtype", _primitives.Name.get("Form"));
                appearanceDict.set("Resources", this._getSaveFieldResources(xref));
                appearanceDict.set("BBox", bbox);
                bufferOriginal = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, bufferOriginal, originalTransform);
                bufferOriginal.push("\nendobj\n");
                bufferNew = ["".concat(newRef.num, " ").concat(newRef.gen, " obj\n")];
                (0, _writer.writeDict)(appearanceDict, bufferNew, newTransform);
                bufferNew.push(" stream\n", appearance, "\nendstream\nendobj\n");
                return _context3.abrupt("return", [{
                  ref: this.ref,
                  data: bufferOriginal.join(""),
                  xfa: xfa
                }, {
                  ref: newRef,
                  data: bufferNew.join(""),
                  xfa: null
                }]);

              case 39:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function save(_x7, _x8, _x9) {
        return _save2.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "_getAppearance",
    value: function () {
      var _getAppearance2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(evaluator, task, annotationStorage) {
        var isPassword, storageEntry, value, lineCount, defaultPadding, hPadding, totalHeight, totalWidth, _this$_computeFontSiz, _this$_computeFontSiz2, defaultAppearance, fontSize, font, descent, vPadding, alignment, encodedString, renderedText;

        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                isPassword = this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD);

                if (!(!annotationStorage || isPassword)) {
                  _context4.next = 3;
                  break;
                }

                return _context4.abrupt("return", null);

              case 3:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context4.next = 7;
                  break;
                }

                return _context4.abrupt("return", null);

              case 7:
                value = value.trim();

                if (!(value === "")) {
                  _context4.next = 10;
                  break;
                }

                return _context4.abrupt("return", "");

              case 10:
                lineCount = -1;

                if (this.data.multiLine) {
                  lineCount = value.split(/\r\n|\r|\n/).length;
                }

                defaultPadding = 2;
                hPadding = defaultPadding;
                totalHeight = this.data.rect[3] - this.data.rect[1];
                totalWidth = this.data.rect[2] - this.data.rect[0];

                if (!this._defaultAppearance) {
                  this.data.defaultAppearanceData = (0, _default_appearance.parseDefaultAppearance)(this._defaultAppearance = "/Helvetica 0 Tf 0 g");
                }

                _this$_computeFontSiz = this._computeFontSize(totalHeight, lineCount), _this$_computeFontSiz2 = _slicedToArray(_this$_computeFontSiz, 2), defaultAppearance = _this$_computeFontSiz2[0], fontSize = _this$_computeFontSiz2[1];
                _context4.next = 20;
                return this._getFontData(evaluator, task);

              case 20:
                font = _context4.sent;
                descent = font.descent;

                if (isNaN(descent)) {
                  descent = 0;
                }

                vPadding = defaultPadding + Math.abs(descent) * fontSize;
                alignment = this.data.textAlignment;

                if (!this.data.multiLine) {
                  _context4.next = 27;
                  break;
                }

                return _context4.abrupt("return", this._getMultilineAppearance(defaultAppearance, value, font, fontSize, totalWidth, totalHeight, alignment, hPadding, vPadding));

              case 27:
                encodedString = font.encodeString(value).join("");

                if (!this.data.comb) {
                  _context4.next = 30;
                  break;
                }

                return _context4.abrupt("return", this._getCombAppearance(defaultAppearance, font, encodedString, totalWidth, hPadding, vPadding));

              case 30:
                if (!(alignment === 0 || alignment > 2)) {
                  _context4.next = 32;
                  break;
                }

                return _context4.abrupt("return", "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 ".concat(hPadding, " ").concat(vPadding, " Tm (").concat((0, _util.escapeString)(encodedString), ") Tj") + " ET Q EMC");

              case 32:
                renderedText = this._renderText(encodedString, font, fontSize, totalWidth, alignment, hPadding, vPadding);
                return _context4.abrupt("return", "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 0 0 Tm ".concat(renderedText) + " ET Q EMC");

              case 34:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function _getAppearance(_x10, _x11, _x12) {
        return _getAppearance2.apply(this, arguments);
      }

      return _getAppearance;
    }()
  }, {
    key: "_getFontData",
    value: function () {
      var _getFontData2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5(evaluator, task) {
        var operatorList, initialState, _this$data$defaultApp, fontName, fontSize;

        return _regenerator["default"].wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                operatorList = new _operator_list.OperatorList();
                initialState = {
                  font: null,
                  clone: function clone() {
                    return this;
                  }
                };
                _this$data$defaultApp = this.data.defaultAppearanceData, fontName = _this$data$defaultApp.fontName, fontSize = _this$data$defaultApp.fontSize;
                _context5.next = 5;
                return evaluator.handleSetFont(this._fieldResources.mergedResources, [fontName && _primitives.Name.get(fontName), fontSize], null, operatorList, task, initialState, null);

              case 5:
                return _context5.abrupt("return", initialState.font);

              case 6:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function _getFontData(_x13, _x14) {
        return _getFontData2.apply(this, arguments);
      }

      return _getFontData;
    }()
  }, {
    key: "_computeFontSize",
    value: function _computeFontSize(height, lineCount) {
      var fontSize = this.data.defaultAppearanceData.fontSize;

      if (!fontSize) {
        var roundWithOneDigit = function roundWithOneDigit(x) {
          return Math.round(x * 10) / 10;
        };

        var FONT_FACTOR = 0.8;

        if (lineCount === -1) {
          fontSize = roundWithOneDigit(FONT_FACTOR * height);
        } else {
          fontSize = 10;
          var lineHeight = fontSize / FONT_FACTOR;
          var numberOfLines = Math.round(height / lineHeight);
          numberOfLines = Math.max(numberOfLines, lineCount);
          lineHeight = height / numberOfLines;
          fontSize = roundWithOneDigit(FONT_FACTOR * lineHeight);
        }

        var _this$data$defaultApp2 = this.data.defaultAppearanceData,
            fontName = _this$data$defaultApp2.fontName,
            fontColor = _this$data$defaultApp2.fontColor;
        this._defaultAppearance = (0, _default_appearance.createDefaultAppearance)({
          fontSize: fontSize,
          fontName: fontName,
          fontColor: fontColor
        });
      }

      return [this._defaultAppearance, fontSize];
    }
  }, {
    key: "_renderText",
    value: function _renderText(text, font, fontSize, totalWidth, alignment, hPadding, vPadding) {
      var glyphs = font.charsToGlyphs(text);
      var scale = fontSize / 1000;
      var width = 0;

      var _iterator5 = _createForOfIteratorHelper(glyphs),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var glyph = _step5.value;
          width += glyph.width * scale;
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }

      var shift;

      if (alignment === 1) {
        shift = (totalWidth - width) / 2;
      } else if (alignment === 2) {
        shift = totalWidth - width - hPadding;
      } else {
        shift = hPadding;
      }

      shift = shift.toFixed(2);
      vPadding = vPadding.toFixed(2);
      return "".concat(shift, " ").concat(vPadding, " Td (").concat((0, _util.escapeString)(text), ") Tj");
    }
  }, {
    key: "_getSaveFieldResources",
    value: function _getSaveFieldResources(xref) {
      var _this$_fieldResources = this._fieldResources,
          localResources = _this$_fieldResources.localResources,
          appearanceResources = _this$_fieldResources.appearanceResources,
          acroFormResources = _this$_fieldResources.acroFormResources;
      var fontName = this.data.defaultAppearanceData && this.data.defaultAppearanceData.fontName;

      if (!fontName) {
        return localResources || _primitives.Dict.empty;
      }

      for (var _i2 = 0, _arr2 = [localResources, appearanceResources]; _i2 < _arr2.length; _i2++) {
        var resources = _arr2[_i2];

        if (resources instanceof _primitives.Dict) {
          var localFont = resources.get("Font");

          if (localFont instanceof _primitives.Dict && localFont.has(fontName)) {
            return resources;
          }
        }
      }

      if (acroFormResources instanceof _primitives.Dict) {
        var acroFormFont = acroFormResources.get("Font");

        if (acroFormFont instanceof _primitives.Dict && acroFormFont.has(fontName)) {
          var subFontDict = new _primitives.Dict(xref);
          subFontDict.set(fontName, acroFormFont.getRaw(fontName));
          var subResourcesDict = new _primitives.Dict(xref);
          subResourcesDict.set("Font", subFontDict);
          return _primitives.Dict.merge({
            xref: xref,
            dictArray: [subResourcesDict, localResources],
            mergeSubDicts: true
          });
        }
      }

      return localResources || _primitives.Dict.empty;
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      return null;
    }
  }]);

  return WidgetAnnotation;
}(Annotation);

var TextWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation) {
  _inherits(TextWidgetAnnotation, _WidgetAnnotation);

  var _super3 = _createSuper(TextWidgetAnnotation);

  function TextWidgetAnnotation(params) {
    var _this6;

    _classCallCheck(this, TextWidgetAnnotation);

    _this6 = _super3.call(this, params);
    _this6._hasText = true;
    var dict = params.dict;

    if (!(0, _util.isString)(_this6.data.fieldValue)) {
      _this6.data.fieldValue = "";
    }

    var alignment = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "Q"
    });

    if (!Number.isInteger(alignment) || alignment < 0 || alignment > 2) {
      alignment = null;
    }

    _this6.data.textAlignment = alignment;
    var maximumLength = (0, _core_utils.getInheritableProperty)({
      dict: dict,
      key: "MaxLen"
    });

    if (!Number.isInteger(maximumLength) || maximumLength < 0) {
      maximumLength = null;
    }

    _this6.data.maxLen = maximumLength;
    _this6.data.multiLine = _this6.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE);
    _this6.data.comb = _this6.hasFieldFlag(_util.AnnotationFieldFlag.COMB) && !_this6.hasFieldFlag(_util.AnnotationFieldFlag.MULTILINE) && !_this6.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD) && !_this6.hasFieldFlag(_util.AnnotationFieldFlag.FILESELECT) && _this6.data.maxLen !== null;
    return _this6;
  }

  _createClass(TextWidgetAnnotation, [{
    key: "_getCombAppearance",
    value: function _getCombAppearance(defaultAppearance, font, text, width, hPadding, vPadding) {
      var combWidth = (width / this.data.maxLen).toFixed(2);
      var buf = [];
      var positions = font.getCharPositions(text);

      var _iterator6 = _createForOfIteratorHelper(positions),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var _step6$value = _slicedToArray(_step6.value, 2),
              start = _step6$value[0],
              end = _step6$value[1];

          buf.push("(".concat((0, _util.escapeString)(text.substring(start, end)), ") Tj"));
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      var renderedComb = buf.join(" ".concat(combWidth, " 0 Td "));
      return "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 ".concat(hPadding, " ").concat(vPadding, " Tm ").concat(renderedComb) + " ET Q EMC";
    }
  }, {
    key: "_getMultilineAppearance",
    value: function _getMultilineAppearance(defaultAppearance, text, font, fontSize, width, height, alignment, hPadding, vPadding) {
      var lines = text.split(/\r\n|\r|\n/);
      var buf = [];
      var totalWidth = width - 2 * hPadding;

      var _iterator7 = _createForOfIteratorHelper(lines),
          _step7;

      try {
        for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
          var line = _step7.value;

          var chunks = this._splitLine(line, font, fontSize, totalWidth);

          var _iterator8 = _createForOfIteratorHelper(chunks),
              _step8;

          try {
            for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
              var chunk = _step8.value;
              var padding = buf.length === 0 ? hPadding : 0;
              buf.push(this._renderText(chunk, font, fontSize, width, alignment, padding, -fontSize));
            }
          } catch (err) {
            _iterator8.e(err);
          } finally {
            _iterator8.f();
          }
        }
      } catch (err) {
        _iterator7.e(err);
      } finally {
        _iterator7.f();
      }

      var renderedText = buf.join("\n");
      return "/Tx BMC q BT " + defaultAppearance + " 1 0 0 1 0 ".concat(height, " Tm ").concat(renderedText) + " ET Q EMC";
    }
  }, {
    key: "_splitLine",
    value: function _splitLine(line, font, fontSize, width) {
      line = font.encodeString(line).join("");
      var glyphs = font.charsToGlyphs(line);

      if (glyphs.length <= 1) {
        return [line];
      }

      var positions = font.getCharPositions(line);
      var scale = fontSize / 1000;
      var chunks = [];
      var lastSpacePosInStringStart = -1,
          lastSpacePosInStringEnd = -1,
          lastSpacePos = -1,
          startChunk = 0,
          currentWidth = 0;

      for (var i = 0, ii = glyphs.length; i < ii; i++) {
        var _positions$i = _slicedToArray(positions[i], 2),
            start = _positions$i[0],
            end = _positions$i[1];

        var glyph = glyphs[i];
        var glyphWidth = glyph.width * scale;

        if (glyph.unicode === " ") {
          if (currentWidth + glyphWidth > width) {
            chunks.push(line.substring(startChunk, start));
            startChunk = start;
            currentWidth = glyphWidth;
            lastSpacePosInStringStart = -1;
            lastSpacePos = -1;
          } else {
            currentWidth += glyphWidth;
            lastSpacePosInStringStart = start;
            lastSpacePosInStringEnd = end;
            lastSpacePos = i;
          }
        } else {
          if (currentWidth + glyphWidth > width) {
            if (lastSpacePosInStringStart !== -1) {
              chunks.push(line.substring(startChunk, lastSpacePosInStringEnd));
              startChunk = lastSpacePosInStringEnd;
              i = lastSpacePos + 1;
              lastSpacePosInStringStart = -1;
              currentWidth = 0;
            } else {
              chunks.push(line.substring(startChunk, start));
              startChunk = start;
              currentWidth = glyphWidth;
            }
          } else {
            currentWidth += glyphWidth;
          }
        }
      }

      if (startChunk < line.length) {
        chunks.push(line.substring(startChunk, line.length));
      }

      return chunks;
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      return {
        id: this.data.id,
        value: this.data.fieldValue,
        defaultValue: this.data.defaultFieldValue,
        multiline: this.data.multiLine,
        password: this.hasFieldFlag(_util.AnnotationFieldFlag.PASSWORD),
        charLimit: this.data.maxLen,
        comb: this.data.comb,
        editable: !this.data.readOnly,
        hidden: this.data.hidden,
        name: this.data.fieldName,
        rect: this.data.rect,
        actions: this.data.actions,
        page: this.data.pageIndex,
        type: "text"
      };
    }
  }]);

  return TextWidgetAnnotation;
}(WidgetAnnotation);

var ButtonWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation2) {
  _inherits(ButtonWidgetAnnotation, _WidgetAnnotation2);

  var _super4 = _createSuper(ButtonWidgetAnnotation);

  function ButtonWidgetAnnotation(params) {
    var _this7;

    _classCallCheck(this, ButtonWidgetAnnotation);

    _this7 = _super4.call(this, params);
    _this7.checkedAppearance = null;
    _this7.uncheckedAppearance = null;
    _this7.data.checkBox = !_this7.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !_this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this7.data.radioButton = _this7.hasFieldFlag(_util.AnnotationFieldFlag.RADIO) && !_this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this7.data.pushButton = _this7.hasFieldFlag(_util.AnnotationFieldFlag.PUSHBUTTON);
    _this7.data.isTooltipOnly = false;

    if (_this7.data.checkBox) {
      _this7._processCheckBox(params);
    } else if (_this7.data.radioButton) {
      _this7._processRadioButton(params);
    } else if (_this7.data.pushButton) {
      _this7._processPushButton(params);
    } else {
      (0, _util.warn)("Invalid field flags for button widget annotation");
    }

    return _this7;
  }

  _createClass(ButtonWidgetAnnotation, [{
    key: "getOperatorList",
    value: function getOperatorList(evaluator, task, renderForms, annotationStorage) {
      if (this.data.pushButton) {
        return _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, false, annotationStorage);
      }

      if (annotationStorage) {
        var storageEntry = annotationStorage.get(this.data.id);
        var value = storageEntry && storageEntry.value;

        if (value === undefined) {
          return _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, renderForms, annotationStorage);
        }

        var appearance;

        if (value) {
          appearance = this.checkedAppearance;
        } else {
          appearance = this.uncheckedAppearance;
        }

        if (appearance) {
          var savedAppearance = this.appearance;
          this.appearance = appearance;

          var operatorList = _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, renderForms, annotationStorage);

          this.appearance = savedAppearance;
          return operatorList;
        }

        return Promise.resolve(new _operator_list.OperatorList());
      }

      return _get(_getPrototypeOf(ButtonWidgetAnnotation.prototype), "getOperatorList", this).call(this, evaluator, task, renderForms, annotationStorage);
    }
  }, {
    key: "save",
    value: function () {
      var _save3 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee6(evaluator, task, annotationStorage) {
        return _regenerator["default"].wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                if (!this.data.checkBox) {
                  _context6.next = 2;
                  break;
                }

                return _context6.abrupt("return", this._saveCheckbox(evaluator, task, annotationStorage));

              case 2:
                if (!this.data.radioButton) {
                  _context6.next = 4;
                  break;
                }

                return _context6.abrupt("return", this._saveRadioButton(evaluator, task, annotationStorage));

              case 4:
                return _context6.abrupt("return", null);

              case 5:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function save(_x15, _x16, _x17) {
        return _save3.apply(this, arguments);
      }

      return save;
    }()
  }, {
    key: "_saveCheckbox",
    value: function () {
      var _saveCheckbox2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee7(evaluator, task, annotationStorage) {
        var storageEntry, value, defaultValue, dict, xfa, name, encrypt, originalTransform, buffer;
        return _regenerator["default"].wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                if (annotationStorage) {
                  _context7.next = 2;
                  break;
                }

                return _context7.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context7.next = 6;
                  break;
                }

                return _context7.abrupt("return", null);

              case 6:
                defaultValue = this.data.fieldValue && this.data.fieldValue !== "Off";

                if (!(defaultValue === value)) {
                  _context7.next = 9;
                  break;
                }

                return _context7.abrupt("return", null);

              case 9:
                dict = evaluator.xref.fetchIfRef(this.ref);

                if ((0, _primitives.isDict)(dict)) {
                  _context7.next = 12;
                  break;
                }

                return _context7.abrupt("return", null);

              case 12:
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value ? this.data.exportValue : ""
                };
                name = _primitives.Name.get(value ? this.data.exportValue : "Off");
                dict.set("V", name);
                dict.set("AS", name);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                encrypt = evaluator.xref.encrypt;
                originalTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                }

                buffer = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, buffer, originalTransform);
                buffer.push("\nendobj\n");
                return _context7.abrupt("return", [{
                  ref: this.ref,
                  data: buffer.join(""),
                  xfa: xfa
                }]);

              case 24:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this);
      }));

      function _saveCheckbox(_x18, _x19, _x20) {
        return _saveCheckbox2.apply(this, arguments);
      }

      return _saveCheckbox;
    }()
  }, {
    key: "_saveRadioButton",
    value: function () {
      var _saveRadioButton2 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee8(evaluator, task, annotationStorage) {
        var storageEntry, value, defaultValue, dict, xfa, name, parentBuffer, encrypt, parent, parentTransform, originalTransform, buffer, newRefs;
        return _regenerator["default"].wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                if (annotationStorage) {
                  _context8.next = 2;
                  break;
                }

                return _context8.abrupt("return", null);

              case 2:
                storageEntry = annotationStorage.get(this.data.id);
                value = storageEntry && storageEntry.value;

                if (!(value === undefined)) {
                  _context8.next = 6;
                  break;
                }

                return _context8.abrupt("return", null);

              case 6:
                defaultValue = this.data.fieldValue === this.data.buttonValue;

                if (!(defaultValue === value)) {
                  _context8.next = 9;
                  break;
                }

                return _context8.abrupt("return", null);

              case 9:
                dict = evaluator.xref.fetchIfRef(this.ref);

                if ((0, _primitives.isDict)(dict)) {
                  _context8.next = 12;
                  break;
                }

                return _context8.abrupt("return", null);

              case 12:
                xfa = {
                  path: (0, _util.stringToPDFString)(dict.get("T") || ""),
                  value: value ? this.data.buttonValue : ""
                };
                name = _primitives.Name.get(value ? this.data.buttonValue : "Off");
                parentBuffer = null;
                encrypt = evaluator.xref.encrypt;

                if (value) {
                  if ((0, _primitives.isRef)(this.parent)) {
                    parent = evaluator.xref.fetch(this.parent);
                    parentTransform = null;

                    if (encrypt) {
                      parentTransform = encrypt.createCipherTransform(this.parent.num, this.parent.gen);
                    }

                    parent.set("V", name);
                    parentBuffer = ["".concat(this.parent.num, " ").concat(this.parent.gen, " obj\n")];
                    (0, _writer.writeDict)(parent, parentBuffer, parentTransform);
                    parentBuffer.push("\nendobj\n");
                  } else if ((0, _primitives.isDict)(this.parent)) {
                    this.parent.set("V", name);
                  }
                }

                dict.set("AS", name);
                dict.set("M", "D:".concat((0, _util.getModificationDate)()));
                originalTransform = null;

                if (encrypt) {
                  originalTransform = encrypt.createCipherTransform(this.ref.num, this.ref.gen);
                }

                buffer = ["".concat(this.ref.num, " ").concat(this.ref.gen, " obj\n")];
                (0, _writer.writeDict)(dict, buffer, originalTransform);
                buffer.push("\nendobj\n");
                newRefs = [{
                  ref: this.ref,
                  data: buffer.join(""),
                  xfa: xfa
                }];

                if (parentBuffer !== null) {
                  newRefs.push({
                    ref: this.parent,
                    data: parentBuffer.join(""),
                    xfa: null
                  });
                }

                return _context8.abrupt("return", newRefs);

              case 27:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function _saveRadioButton(_x21, _x22, _x23) {
        return _saveRadioButton2.apply(this, arguments);
      }

      return _saveRadioButton;
    }()
  }, {
    key: "_processCheckBox",
    value: function _processCheckBox(params) {
      var customAppearance = params.dict.get("AP");

      if (!(0, _primitives.isDict)(customAppearance)) {
        return;
      }

      var normalAppearance = customAppearance.get("N");

      if (!(0, _primitives.isDict)(normalAppearance)) {
        return;
      }

      var exportValues = normalAppearance.getKeys();

      if (!exportValues.includes("Off")) {
        exportValues.push("Off");
      }

      if (exportValues.length !== 2) {
        return;
      }

      this.data.exportValue = exportValues[0] === "Off" ? exportValues[1] : exportValues[0];
      this.checkedAppearance = normalAppearance.get(this.data.exportValue);
      this.uncheckedAppearance = normalAppearance.get("Off") || null;

      this._streams.push(this.checkedAppearance);

      if (this.uncheckedAppearance) {
        this._streams.push(this.uncheckedAppearance);
      }

      this._fallbackFontDict = this.fallbackFontDict;
    }
  }, {
    key: "_processRadioButton",
    value: function _processRadioButton(params) {
      this.data.fieldValue = this.data.buttonValue = null;
      var fieldParent = params.dict.get("Parent");

      if ((0, _primitives.isDict)(fieldParent)) {
        this.parent = params.dict.getRaw("Parent");
        var fieldParentValue = fieldParent.get("V");

        if ((0, _primitives.isName)(fieldParentValue)) {
          this.data.fieldValue = this._decodeFormValue(fieldParentValue);
        }
      }

      var appearanceStates = params.dict.get("AP");

      if (!(0, _primitives.isDict)(appearanceStates)) {
        return;
      }

      var normalAppearance = appearanceStates.get("N");

      if (!(0, _primitives.isDict)(normalAppearance)) {
        return;
      }

      var _iterator9 = _createForOfIteratorHelper(normalAppearance.getKeys()),
          _step9;

      try {
        for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
          var key = _step9.value;

          if (key !== "Off") {
            this.data.buttonValue = this._decodeFormValue(key);
            break;
          }
        }
      } catch (err) {
        _iterator9.e(err);
      } finally {
        _iterator9.f();
      }

      this.checkedAppearance = normalAppearance.get(this.data.buttonValue);
      this.uncheckedAppearance = normalAppearance.get("Off") || null;

      this._streams.push(this.checkedAppearance);

      if (this.uncheckedAppearance) {
        this._streams.push(this.uncheckedAppearance);
      }

      this._fallbackFontDict = this.fallbackFontDict;
    }
  }, {
    key: "_processPushButton",
    value: function _processPushButton(params) {
      if (!params.dict.has("A") && !params.dict.has("AA") && !this.data.alternativeText) {
        (0, _util.warn)("Push buttons without action dictionaries are not supported");
        return;
      }

      this.data.isTooltipOnly = !params.dict.has("A") && !params.dict.has("AA");

      _catalog.Catalog.parseDestDictionary({
        destDict: params.dict,
        resultObj: this.data,
        docBaseUrl: params.pdfManager.docBaseUrl
      });
    }
  }, {
    key: "getFieldObject",
    value: function getFieldObject() {
      var type = "button";
      var exportValues;

      if (this.data.checkBox) {
        type = "checkbox";
        exportValues = this.data.exportValue;
      } else if (this.data.radioButton) {
        type = "radiobutton";
        exportValues = this.data.buttonValue;
      }

      return {
        id: this.data.id,
        value: this.data.fieldValue || "Off",
        defaultValue: this.data.defaultFieldValue,
        exportValues: exportValues,
        editable: !this.data.readOnly,
        name: this.data.fieldName,
        rect: this.data.rect,
        hidden: this.data.hidden,
        actions: this.data.actions,
        page: this.data.pageIndex,
        type: type
      };
    }
  }, {
    key: "fallbackFontDict",
    get: function get() {
      var dict = new _primitives.Dict();
      dict.set("BaseFont", _primitives.Name.get("ZapfDingbats"));
      dict.set("Type", _primitives.Name.get("FallbackType"));
      dict.set("Subtype", _primitives.Name.get("FallbackType"));
      dict.set("Encoding", _primitives.Name.get("ZapfDingbatsEncoding"));
      return (0, _util.shadow)(this, "fallbackFontDict", dict);
    }
  }]);

  return ButtonWidgetAnnotation;
}(WidgetAnnotation);

var ChoiceWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation3) {
  _inherits(ChoiceWidgetAnnotation, _WidgetAnnotation3);

  var _super5 = _createSuper(ChoiceWidgetAnnotation);

  function ChoiceWidgetAnnotation(params) {
    var _this8;

    _classCallCheck(this, ChoiceWidgetAnnotation);

    _this8 = _super5.call(this, params);
    _this8.data.options = [];
    var options = (0, _core_utils.getInheritableProperty)({
      dict: params.dict,
      key: "Opt"
    });

    if (Array.isArray(options)) {
      var xref = params.xref;

      for (var i = 0, ii = options.length; i < ii; i++) {
        var option = xref.fetchIfRef(options[i]);
        var isOptionArray = Array.isArray(option);
        _this8.data.options[i] = {
          exportValue: _this8._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[0]) : option),
          displayValue: _this8._decodeFormValue(isOptionArray ? xref.fetchIfRef(option[1]) : option)
        };
      }
    }

    if ((0, _util.isString)(_this8.data.fieldValue)) {
      _this8.data.fieldValue = [_this8.data.fieldValue];
    } else if (!_this8.data.fieldValue) {
      _this8.data.fieldValue = [];
    }

    _this8.data.combo = _this8.hasFieldFlag(_util.AnnotationFieldFlag.COMBO);
    _this8.data.multiSelect = _this8.hasFieldFlag(_util.AnnotationFieldFlag.MULTISELECT);
    _this8._hasText = true;
    return _this8;
  }

  _createClass(ChoiceWidgetAnnotation, [{
    key: "getFieldObject",
    value: function getFieldObject() {
      var type = this.data.combo ? "combobox" : "listbox";
      var value = this.data.fieldValue.length > 0 ? this.data.fieldValue[0] : null;
      return {
        id: this.data.id,
        value: value,
        defaultValue: this.data.defaultFieldValue,
        editable: !this.data.readOnly,
        name: this.data.fieldName,
        rect: this.data.rect,
        numItems: this.data.fieldValue.length,
        multipleSelection: this.data.multiSelect,
        hidden: this.data.hidden,
        actions: this.data.actions,
        items: this.data.options,
        page: this.data.pageIndex,
        type: type
      };
    }
  }]);

  return ChoiceWidgetAnnotation;
}(WidgetAnnotation);

var SignatureWidgetAnnotation = /*#__PURE__*/function (_WidgetAnnotation4) {
  _inherits(SignatureWidgetAnnotation, _WidgetAnnotation4);

  var _super6 = _createSuper(SignatureWidgetAnnotation);

  function SignatureWidgetAnnotation(params) {
    var _this9;

    _classCallCheck(this, SignatureWidgetAnnotation);

    _this9 = _super6.call(this, params);
    _this9.data.fieldValue = null;
    return _this9;
  }

  _createClass(SignatureWidgetAnnotation, [{
    key: "getFieldObject",
    value: function getFieldObject() {
      return {
        id: this.data.id,
        value: null,
        page: this.data.pageIndex,
        type: "signature"
      };
    }
  }]);

  return SignatureWidgetAnnotation;
}(WidgetAnnotation);

var TextAnnotation = /*#__PURE__*/function (_MarkupAnnotation) {
  _inherits(TextAnnotation, _MarkupAnnotation);

  var _super7 = _createSuper(TextAnnotation);

  function TextAnnotation(parameters) {
    var _this10;

    _classCallCheck(this, TextAnnotation);

    var DEFAULT_ICON_SIZE = 22;
    _this10 = _super7.call(this, parameters);
    var dict = parameters.dict;
    _this10.data.annotationType = _util.AnnotationType.TEXT;

    if (_this10.data.hasAppearance) {
      _this10.data.name = "NoIcon";
    } else {
      _this10.data.rect[1] = _this10.data.rect[3] - DEFAULT_ICON_SIZE;
      _this10.data.rect[2] = _this10.data.rect[0] + DEFAULT_ICON_SIZE;
      _this10.data.name = dict.has("Name") ? dict.get("Name").name : "Note";
    }

    if (dict.has("State")) {
      _this10.data.state = dict.get("State") || null;
      _this10.data.stateModel = dict.get("StateModel") || null;
    } else {
      _this10.data.state = null;
      _this10.data.stateModel = null;
    }

    return _this10;
  }

  return TextAnnotation;
}(MarkupAnnotation);

var LinkAnnotation = /*#__PURE__*/function (_Annotation3) {
  _inherits(LinkAnnotation, _Annotation3);

  var _super8 = _createSuper(LinkAnnotation);

  function LinkAnnotation(params) {
    var _this11;

    _classCallCheck(this, LinkAnnotation);

    _this11 = _super8.call(this, params);
    _this11.data.annotationType = _util.AnnotationType.LINK;
    var quadPoints = getQuadPoints(params.dict, _this11.rectangle);

    if (quadPoints) {
      _this11.data.quadPoints = quadPoints;
    }

    _catalog.Catalog.parseDestDictionary({
      destDict: params.dict,
      resultObj: _this11.data,
      docBaseUrl: params.pdfManager.docBaseUrl
    });

    return _this11;
  }

  return LinkAnnotation;
}(Annotation);

var PopupAnnotation = /*#__PURE__*/function (_Annotation4) {
  _inherits(PopupAnnotation, _Annotation4);

  var _super9 = _createSuper(PopupAnnotation);

  function PopupAnnotation(parameters) {
    var _this12;

    _classCallCheck(this, PopupAnnotation);

    _this12 = _super9.call(this, parameters);
    _this12.data.annotationType = _util.AnnotationType.POPUP;
    var parentItem = parameters.dict.get("Parent");

    if (!parentItem) {
      (0, _util.warn)("Popup annotation has a missing or invalid parent annotation.");
      return _possibleConstructorReturn(_this12);
    }

    var parentSubtype = parentItem.get("Subtype");
    _this12.data.parentType = (0, _primitives.isName)(parentSubtype) ? parentSubtype.name : null;
    var rawParent = parameters.dict.getRaw("Parent");
    _this12.data.parentId = (0, _primitives.isRef)(rawParent) ? rawParent.toString() : null;
    var parentRect = parentItem.getArray("Rect");

    if (Array.isArray(parentRect) && parentRect.length === 4) {
      _this12.data.parentRect = _util.Util.normalizeRect(parentRect);
    } else {
      _this12.data.parentRect = [0, 0, 0, 0];
    }

    var rt = parentItem.get("RT");

    if ((0, _primitives.isName)(rt, _util.AnnotationReplyType.GROUP)) {
      parentItem = parentItem.get("IRT");
    }

    if (!parentItem.has("M")) {
      _this12.data.modificationDate = null;
    } else {
      _this12.setModificationDate(parentItem.get("M"));

      _this12.data.modificationDate = _this12.modificationDate;
    }

    if (!parentItem.has("C")) {
      _this12.data.color = null;
    } else {
      _this12.setColor(parentItem.getArray("C"));

      _this12.data.color = _this12.color;
    }

    if (!_this12.viewable) {
      var parentFlags = parentItem.get("F");

      if (_this12._isViewable(parentFlags)) {
        _this12.setFlags(parentFlags);
      }
    }

    _this12.data.title = (0, _util.stringToPDFString)(parentItem.get("T") || "");
    _this12.data.contents = (0, _util.stringToPDFString)(parentItem.get("Contents") || "");
    return _this12;
  }

  return PopupAnnotation;
}(Annotation);

var FreeTextAnnotation = /*#__PURE__*/function (_MarkupAnnotation2) {
  _inherits(FreeTextAnnotation, _MarkupAnnotation2);

  var _super10 = _createSuper(FreeTextAnnotation);

  function FreeTextAnnotation(parameters) {
    var _this13;

    _classCallCheck(this, FreeTextAnnotation);

    _this13 = _super10.call(this, parameters);
    _this13.data.annotationType = _util.AnnotationType.FREETEXT;
    return _this13;
  }

  return FreeTextAnnotation;
}(MarkupAnnotation);

var LineAnnotation = /*#__PURE__*/function (_MarkupAnnotation3) {
  _inherits(LineAnnotation, _MarkupAnnotation3);

  var _super11 = _createSuper(LineAnnotation);

  function LineAnnotation(parameters) {
    var _this14;

    _classCallCheck(this, LineAnnotation);

    _this14 = _super11.call(this, parameters);
    _this14.data.annotationType = _util.AnnotationType.LINE;
    var lineCoordinates = parameters.dict.getArray("L");
    _this14.data.lineCoordinates = _util.Util.normalizeRect(lineCoordinates);

    if (!_this14.appearance) {
      var strokeColor = _this14.color ? Array.from(_this14.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;
      var borderWidth = _this14.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [_this14.data.lineCoordinates[0] - borderAdjust, _this14.data.lineCoordinates[1] - borderAdjust, _this14.data.lineCoordinates[2] + borderAdjust, _this14.data.lineCoordinates[3] + borderAdjust];

      if (!_util.Util.intersect(_this14.rectangle, bbox)) {
        _this14.rectangle = bbox;
      }

      _this14._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          buffer.push("".concat(lineCoordinates[0], " ").concat(lineCoordinates[1], " m"), "".concat(lineCoordinates[2], " ").concat(lineCoordinates[3], " l"), "S");
          return [points[0].x - borderWidth, points[1].x + borderWidth, points[3].y - borderWidth, points[1].y + borderWidth];
        }
      });
    }

    return _this14;
  }

  return LineAnnotation;
}(MarkupAnnotation);

var SquareAnnotation = /*#__PURE__*/function (_MarkupAnnotation4) {
  _inherits(SquareAnnotation, _MarkupAnnotation4);

  var _super12 = _createSuper(SquareAnnotation);

  function SquareAnnotation(parameters) {
    var _this15;

    _classCallCheck(this, SquareAnnotation);

    _this15 = _super12.call(this, parameters);
    _this15.data.annotationType = _util.AnnotationType.SQUARE;

    if (!_this15.appearance) {
      var strokeColor = _this15.color ? Array.from(_this15.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null,
          interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;

      _this15._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(_this15.borderStyle.width, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var x = points[2].x + _this15.borderStyle.width / 2;
          var y = points[2].y + _this15.borderStyle.width / 2;
          var width = points[3].x - points[2].x - _this15.borderStyle.width;
          var height = points[1].y - points[3].y - _this15.borderStyle.width;
          buffer.push("".concat(x, " ").concat(y, " ").concat(width, " ").concat(height, " re"));

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this15;
  }

  return SquareAnnotation;
}(MarkupAnnotation);

var CircleAnnotation = /*#__PURE__*/function (_MarkupAnnotation5) {
  _inherits(CircleAnnotation, _MarkupAnnotation5);

  var _super13 = _createSuper(CircleAnnotation);

  function CircleAnnotation(parameters) {
    var _this16;

    _classCallCheck(this, CircleAnnotation);

    _this16 = _super13.call(this, parameters);
    _this16.data.annotationType = _util.AnnotationType.CIRCLE;

    if (!_this16.appearance) {
      var strokeColor = _this16.color ? Array.from(_this16.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var fillColor = null;
      var interiorColor = parameters.dict.getArray("IC");

      if (interiorColor) {
        interiorColor = getRgbColor(interiorColor);
        fillColor = interiorColor ? Array.from(interiorColor).map(function (c) {
          return c / 255;
        }) : null;
      }

      var fillAlpha = fillColor ? strokeAlpha : null;
      var controlPointsDistance = 4 / 3 * Math.tan(Math.PI / (2 * 4));

      _this16._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(_this16.borderStyle.width, " w"),
        strokeColor: strokeColor,
        fillColor: fillColor,
        strokeAlpha: strokeAlpha,
        fillAlpha: fillAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var x0 = points[0].x + _this16.borderStyle.width / 2;
          var y0 = points[0].y - _this16.borderStyle.width / 2;
          var x1 = points[3].x - _this16.borderStyle.width / 2;
          var y1 = points[3].y + _this16.borderStyle.width / 2;
          var xMid = x0 + (x1 - x0) / 2;
          var yMid = y0 + (y1 - y0) / 2;
          var xOffset = (x1 - x0) / 2 * controlPointsDistance;
          var yOffset = (y1 - y0) / 2 * controlPointsDistance;
          buffer.push("".concat(xMid, " ").concat(y1, " m"), "".concat(xMid + xOffset, " ").concat(y1, " ").concat(x1, " ").concat(yMid + yOffset, " ").concat(x1, " ").concat(yMid, " c"), "".concat(x1, " ").concat(yMid - yOffset, " ").concat(xMid + xOffset, " ").concat(y0, " ").concat(xMid, " ").concat(y0, " c"), "".concat(xMid - xOffset, " ").concat(y0, " ").concat(x0, " ").concat(yMid - yOffset, " ").concat(x0, " ").concat(yMid, " c"), "".concat(x0, " ").concat(yMid + yOffset, " ").concat(xMid - xOffset, " ").concat(y1, " ").concat(xMid, " ").concat(y1, " c"), "h");

          if (fillColor) {
            buffer.push("B");
          } else {
            buffer.push("S");
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this16;
  }

  return CircleAnnotation;
}(MarkupAnnotation);

var PolylineAnnotation = /*#__PURE__*/function (_MarkupAnnotation6) {
  _inherits(PolylineAnnotation, _MarkupAnnotation6);

  var _super14 = _createSuper(PolylineAnnotation);

  function PolylineAnnotation(parameters) {
    var _this17;

    _classCallCheck(this, PolylineAnnotation);

    _this17 = _super14.call(this, parameters);
    _this17.data.annotationType = _util.AnnotationType.POLYLINE;
    _this17.data.vertices = [];
    var rawVertices = parameters.dict.getArray("Vertices");

    if (!Array.isArray(rawVertices)) {
      return _possibleConstructorReturn(_this17);
    }

    for (var i = 0, ii = rawVertices.length; i < ii; i += 2) {
      _this17.data.vertices.push({
        x: rawVertices[i],
        y: rawVertices[i + 1]
      });
    }

    if (!_this17.appearance) {
      var strokeColor = _this17.color ? Array.from(_this17.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var borderWidth = _this17.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [Infinity, Infinity, -Infinity, -Infinity];

      var _iterator10 = _createForOfIteratorHelper(_this17.data.vertices),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var vertex = _step10.value;
          bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
          bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
          bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
          bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      if (!_util.Util.intersect(_this17.rectangle, bbox)) {
        _this17.rectangle = bbox;
      }

      _this17._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        strokeAlpha: strokeAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var vertices = _this17.data.vertices;

          for (var _i3 = 0, _ii = vertices.length; _i3 < _ii; _i3++) {
            buffer.push("".concat(vertices[_i3].x, " ").concat(vertices[_i3].y, " ").concat(_i3 === 0 ? "m" : "l"));
          }

          buffer.push("S");
          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this17;
  }

  return PolylineAnnotation;
}(MarkupAnnotation);

var PolygonAnnotation = /*#__PURE__*/function (_PolylineAnnotation) {
  _inherits(PolygonAnnotation, _PolylineAnnotation);

  var _super15 = _createSuper(PolygonAnnotation);

  function PolygonAnnotation(parameters) {
    var _this18;

    _classCallCheck(this, PolygonAnnotation);

    _this18 = _super15.call(this, parameters);
    _this18.data.annotationType = _util.AnnotationType.POLYGON;
    return _this18;
  }

  return PolygonAnnotation;
}(PolylineAnnotation);

var CaretAnnotation = /*#__PURE__*/function (_MarkupAnnotation7) {
  _inherits(CaretAnnotation, _MarkupAnnotation7);

  var _super16 = _createSuper(CaretAnnotation);

  function CaretAnnotation(parameters) {
    var _this19;

    _classCallCheck(this, CaretAnnotation);

    _this19 = _super16.call(this, parameters);
    _this19.data.annotationType = _util.AnnotationType.CARET;
    return _this19;
  }

  return CaretAnnotation;
}(MarkupAnnotation);

var InkAnnotation = /*#__PURE__*/function (_MarkupAnnotation8) {
  _inherits(InkAnnotation, _MarkupAnnotation8);

  var _super17 = _createSuper(InkAnnotation);

  function InkAnnotation(parameters) {
    var _this20;

    _classCallCheck(this, InkAnnotation);

    _this20 = _super17.call(this, parameters);
    _this20.data.annotationType = _util.AnnotationType.INK;
    _this20.data.inkLists = [];
    var rawInkLists = parameters.dict.getArray("InkList");

    if (!Array.isArray(rawInkLists)) {
      return _possibleConstructorReturn(_this20);
    }

    var xref = parameters.xref;

    for (var i = 0, ii = rawInkLists.length; i < ii; ++i) {
      _this20.data.inkLists.push([]);

      for (var j = 0, jj = rawInkLists[i].length; j < jj; j += 2) {
        _this20.data.inkLists[i].push({
          x: xref.fetchIfRef(rawInkLists[i][j]),
          y: xref.fetchIfRef(rawInkLists[i][j + 1])
        });
      }
    }

    if (!_this20.appearance) {
      var strokeColor = _this20.color ? Array.from(_this20.color).map(function (c) {
        return c / 255;
      }) : [0, 0, 0];
      var strokeAlpha = parameters.dict.get("CA");
      var borderWidth = _this20.borderStyle.width || 1,
          borderAdjust = 2 * borderWidth;
      var bbox = [Infinity, Infinity, -Infinity, -Infinity];

      var _iterator11 = _createForOfIteratorHelper(_this20.data.inkLists),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var inkLists = _step11.value;

          var _iterator13 = _createForOfIteratorHelper(inkLists),
              _step13;

          try {
            for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
              var vertex = _step13.value;
              bbox[0] = Math.min(bbox[0], vertex.x - borderAdjust);
              bbox[1] = Math.min(bbox[1], vertex.y - borderAdjust);
              bbox[2] = Math.max(bbox[2], vertex.x + borderAdjust);
              bbox[3] = Math.max(bbox[3], vertex.y + borderAdjust);
            }
          } catch (err) {
            _iterator13.e(err);
          } finally {
            _iterator13.f();
          }
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      if (!_util.Util.intersect(_this20.rectangle, bbox)) {
        _this20.rectangle = bbox;
      }

      _this20._setDefaultAppearance({
        xref: parameters.xref,
        extra: "".concat(borderWidth, " w"),
        strokeColor: strokeColor,
        strokeAlpha: strokeAlpha,
        pointsCallback: function pointsCallback(buffer, points) {
          var _iterator12 = _createForOfIteratorHelper(_this20.data.inkLists),
              _step12;

          try {
            for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
              var inkList = _step12.value;

              for (var _i4 = 0, _ii2 = inkList.length; _i4 < _ii2; _i4++) {
                buffer.push("".concat(inkList[_i4].x, " ").concat(inkList[_i4].y, " ").concat(_i4 === 0 ? "m" : "l"));
              }

              buffer.push("S");
            }
          } catch (err) {
            _iterator12.e(err);
          } finally {
            _iterator12.f();
          }

          return [points[0].x, points[1].x, points[3].y, points[1].y];
        }
      });
    }

    return _this20;
  }

  return InkAnnotation;
}(MarkupAnnotation);

var HighlightAnnotation = /*#__PURE__*/function (_MarkupAnnotation9) {
  _inherits(HighlightAnnotation, _MarkupAnnotation9);

  var _super18 = _createSuper(HighlightAnnotation);

  function HighlightAnnotation(parameters) {
    var _this21;

    _classCallCheck(this, HighlightAnnotation);

    _this21 = _super18.call(this, parameters);
    _this21.data.annotationType = _util.AnnotationType.HIGHLIGHT;
    var quadPoints = _this21.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      var resources = _this21.appearance && _this21.appearance.dict.get("Resources");

      if (!_this21.appearance || !(resources && resources.has("ExtGState"))) {
        if (_this21.appearance) {
          (0, _util.warn)("HighlightAnnotation - ignoring built-in appearance stream.");
        }

        var fillColor = _this21.color ? Array.from(_this21.color).map(function (c) {
          return c / 255;
        }) : [1, 1, 0];
        var fillAlpha = parameters.dict.get("CA");

        _this21._setDefaultAppearance({
          xref: parameters.xref,
          fillColor: fillColor,
          blendMode: "Multiply",
          fillAlpha: fillAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat(points[0].x, " ").concat(points[0].y, " m"), "".concat(points[1].x, " ").concat(points[1].y, " l"), "".concat(points[3].x, " ").concat(points[3].y, " l"), "".concat(points[2].x, " ").concat(points[2].y, " l"), "f");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this21.data.hasPopup = false;
    }

    return _this21;
  }

  return HighlightAnnotation;
}(MarkupAnnotation);

var UnderlineAnnotation = /*#__PURE__*/function (_MarkupAnnotation10) {
  _inherits(UnderlineAnnotation, _MarkupAnnotation10);

  var _super19 = _createSuper(UnderlineAnnotation);

  function UnderlineAnnotation(parameters) {
    var _this22;

    _classCallCheck(this, UnderlineAnnotation);

    _this22 = _super19.call(this, parameters);
    _this22.data.annotationType = _util.AnnotationType.UNDERLINE;
    var quadPoints = _this22.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this22.appearance) {
        var strokeColor = _this22.color ? Array.from(_this22.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this22._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat(points[2].x, " ").concat(points[2].y, " m"), "".concat(points[3].x, " ").concat(points[3].y, " l"), "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this22.data.hasPopup = false;
    }

    return _this22;
  }

  return UnderlineAnnotation;
}(MarkupAnnotation);

var SquigglyAnnotation = /*#__PURE__*/function (_MarkupAnnotation11) {
  _inherits(SquigglyAnnotation, _MarkupAnnotation11);

  var _super20 = _createSuper(SquigglyAnnotation);

  function SquigglyAnnotation(parameters) {
    var _this23;

    _classCallCheck(this, SquigglyAnnotation);

    _this23 = _super20.call(this, parameters);
    _this23.data.annotationType = _util.AnnotationType.SQUIGGLY;
    var quadPoints = _this23.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this23.appearance) {
        var strokeColor = _this23.color ? Array.from(_this23.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this23._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            var dy = (points[0].y - points[2].y) / 6;
            var shift = dy;
            var x = points[2].x;
            var y = points[2].y;
            var xEnd = points[3].x;
            buffer.push("".concat(x, " ").concat(y + shift, " m"));

            do {
              x += 2;
              shift = shift === 0 ? dy : 0;
              buffer.push("".concat(x, " ").concat(y + shift, " l"));
            } while (x < xEnd);

            buffer.push("S");
            return [points[2].x, xEnd, y - 2 * dy, y + 2 * dy];
          }
        });
      }
    } else {
      _this23.data.hasPopup = false;
    }

    return _this23;
  }

  return SquigglyAnnotation;
}(MarkupAnnotation);

var StrikeOutAnnotation = /*#__PURE__*/function (_MarkupAnnotation12) {
  _inherits(StrikeOutAnnotation, _MarkupAnnotation12);

  var _super21 = _createSuper(StrikeOutAnnotation);

  function StrikeOutAnnotation(parameters) {
    var _this24;

    _classCallCheck(this, StrikeOutAnnotation);

    _this24 = _super21.call(this, parameters);
    _this24.data.annotationType = _util.AnnotationType.STRIKEOUT;
    var quadPoints = _this24.data.quadPoints = getQuadPoints(parameters.dict, null);

    if (quadPoints) {
      if (!_this24.appearance) {
        var strokeColor = _this24.color ? Array.from(_this24.color).map(function (c) {
          return c / 255;
        }) : [0, 0, 0];
        var strokeAlpha = parameters.dict.get("CA");

        _this24._setDefaultAppearance({
          xref: parameters.xref,
          extra: "[] 0 d 1 w",
          strokeColor: strokeColor,
          strokeAlpha: strokeAlpha,
          pointsCallback: function pointsCallback(buffer, points) {
            buffer.push("".concat((points[0].x + points[2].x) / 2, " ") + "".concat((points[0].y + points[2].y) / 2, " m"), "".concat((points[1].x + points[3].x) / 2, " ") + "".concat((points[1].y + points[3].y) / 2, " l"), "S");
            return [points[0].x, points[1].x, points[3].y, points[1].y];
          }
        });
      }
    } else {
      _this24.data.hasPopup = false;
    }

    return _this24;
  }

  return StrikeOutAnnotation;
}(MarkupAnnotation);

var StampAnnotation = /*#__PURE__*/function (_MarkupAnnotation13) {
  _inherits(StampAnnotation, _MarkupAnnotation13);

  var _super22 = _createSuper(StampAnnotation);

  function StampAnnotation(parameters) {
    var _this25;

    _classCallCheck(this, StampAnnotation);

    _this25 = _super22.call(this, parameters);
    _this25.data.annotationType = _util.AnnotationType.STAMP;
    return _this25;
  }

  return StampAnnotation;
}(MarkupAnnotation);

var FileAttachmentAnnotation = /*#__PURE__*/function (_MarkupAnnotation14) {
  _inherits(FileAttachmentAnnotation, _MarkupAnnotation14);

  var _super23 = _createSuper(FileAttachmentAnnotation);

  function FileAttachmentAnnotation(parameters) {
    var _this26;

    _classCallCheck(this, FileAttachmentAnnotation);

    _this26 = _super23.call(this, parameters);
    var file = new _file_spec.FileSpec(parameters.dict.get("FS"), parameters.xref);
    _this26.data.annotationType = _util.AnnotationType.FILEATTACHMENT;
    _this26.data.file = file.serializable;
    return _this26;
  }

  return FileAttachmentAnnotation;
}(MarkupAnnotation);

/***/ }),
/* 121 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.createDefaultAppearance = createDefaultAppearance;
exports.parseDefaultAppearance = parseDefaultAppearance;

var _util = __w_pdfjs_require__(4);

var _colorspace = __w_pdfjs_require__(122);

var _core_utils = __w_pdfjs_require__(117);

var _evaluator = __w_pdfjs_require__(123);

var _primitives = __w_pdfjs_require__(113);

var _stream = __w_pdfjs_require__(118);

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var DefaultAppearanceEvaluator = /*#__PURE__*/function (_EvaluatorPreprocesso) {
  _inherits(DefaultAppearanceEvaluator, _EvaluatorPreprocesso);

  var _super = _createSuper(DefaultAppearanceEvaluator);

  function DefaultAppearanceEvaluator(str) {
    _classCallCheck(this, DefaultAppearanceEvaluator);

    return _super.call(this, new _stream.StringStream(str));
  }

  _createClass(DefaultAppearanceEvaluator, [{
    key: "parse",
    value: function parse() {
      var operation = {
        fn: 0,
        args: []
      };
      var result = {
        fontSize: 0,
        fontName: "",
        fontColor: new Uint8ClampedArray(3)
      };

      try {
        while (true) {
          operation.args.length = 0;

          if (!this.read(operation)) {
            break;
          }

          if (this.savedStatesDepth !== 0) {
            continue;
          }

          var fn = operation.fn,
              args = operation.args;

          switch (fn | 0) {
            case _util.OPS.setFont:
              var _args = _slicedToArray(args, 2),
                  fontName = _args[0],
                  fontSize = _args[1];

              if (fontName instanceof _primitives.Name) {
                result.fontName = fontName.name;
              }

              if (typeof fontSize === "number" && fontSize > 0) {
                result.fontSize = fontSize;
              }

              break;

            case _util.OPS.setFillRGBColor:
              _colorspace.ColorSpace.singletons.rgb.getRgbItem(args, 0, result.fontColor, 0);

              break;

            case _util.OPS.setFillGray:
              _colorspace.ColorSpace.singletons.gray.getRgbItem(args, 0, result.fontColor, 0);

              break;

            case _util.OPS.setFillColorSpace:
              _colorspace.ColorSpace.singletons.cmyk.getRgbItem(args, 0, result.fontColor, 0);

              break;
          }
        }
      } catch (reason) {
        (0, _util.warn)("parseDefaultAppearance - ignoring errors: \"".concat(reason, "\"."));
      }

      return result;
    }
  }]);

  return DefaultAppearanceEvaluator;
}(_evaluator.EvaluatorPreprocessor);

function parseDefaultAppearance(str) {
  return new DefaultAppearanceEvaluator(str).parse();
}

function createDefaultAppearance(_ref) {
  var fontSize = _ref.fontSize,
      fontName = _ref.fontName,
      fontColor = _ref.fontColor;
  var colorCmd;

  if (fontColor.every(function (c) {
    return c === 0;
  })) {
    colorCmd = "0 g";
  } else {
    colorCmd = Array.from(fontColor).map(function (c) {
      return (c / 255).toFixed(2);
    }).join(" ") + " rg";
  }

  return "/".concat((0, _core_utils.escapePDFName)(fontName), " ").concat(fontSize, " Tf ").concat(colorCmd);
}

/***/ }),
/* 122 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ColorSpace = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

var _core_utils = __w_pdfjs_require__(117);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function resizeRgbImage(src, dest, w1, h1, w2, h2, alpha01) {
  var COMPONENTS = 3;
  alpha01 = alpha01 !== 1 ? 0 : alpha01;
  var xRatio = w1 / w2;
  var yRatio = h1 / h2;
  var newIndex = 0,
      oldIndex;
  var xScaled = new Uint16Array(w2);
  var w1Scanline = w1 * COMPONENTS;

  for (var i = 0; i < w2; i++) {
    xScaled[i] = Math.floor(i * xRatio) * COMPONENTS;
  }

  for (var _i = 0; _i < h2; _i++) {
    var py = Math.floor(_i * yRatio) * w1Scanline;

    for (var j = 0; j < w2; j++) {
      oldIndex = py + xScaled[j];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      dest[newIndex++] = src[oldIndex++];
      newIndex += alpha01;
    }
  }
}

var ColorSpace = /*#__PURE__*/function () {
  function ColorSpace(name, numComps) {
    _classCallCheck(this, ColorSpace);

    if (this.constructor === ColorSpace) {
      (0, _util.unreachable)("Cannot initialize ColorSpace.");
    }

    this.name = name;
    this.numComps = numComps;
  }

  _createClass(ColorSpace, [{
    key: "getRgb",
    value: function getRgb(src, srcOffset) {
      var rgb = new Uint8ClampedArray(3);
      this.getRgbItem(src, srcOffset, rgb, 0);
      return rgb;
    }
  }, {
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      (0, _util.unreachable)("Should not call ColorSpace.getRgbItem");
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      (0, _util.unreachable)("Should not call ColorSpace.getRgbBuffer");
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      (0, _util.unreachable)("Should not call ColorSpace.getOutputLength");
    }
  }, {
    key: "isPassthrough",
    value: function isPassthrough(bits) {
      return false;
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      return ColorSpace.isDefaultDecode(decodeMap, this.numComps);
    }
  }, {
    key: "fillRgb",
    value: function fillRgb(dest, originalWidth, originalHeight, width, height, actualHeight, bpc, comps, alpha01) {
      var count = originalWidth * originalHeight;
      var rgbBuf = null;
      var numComponentColors = 1 << bpc;
      var needsResizing = originalHeight !== height || originalWidth !== width;

      if (this.isPassthrough(bpc)) {
        rgbBuf = comps;
      } else if (this.numComps === 1 && count > numComponentColors && this.name !== "DeviceGray" && this.name !== "DeviceRGB") {
        var allColors = bpc <= 8 ? new Uint8Array(numComponentColors) : new Uint16Array(numComponentColors);

        for (var i = 0; i < numComponentColors; i++) {
          allColors[i] = i;
        }

        var colorMap = new Uint8ClampedArray(numComponentColors * 3);
        this.getRgbBuffer(allColors, 0, numComponentColors, colorMap, 0, bpc, 0);

        if (!needsResizing) {
          var destPos = 0;

          for (var _i2 = 0; _i2 < count; ++_i2) {
            var key = comps[_i2] * 3;
            dest[destPos++] = colorMap[key];
            dest[destPos++] = colorMap[key + 1];
            dest[destPos++] = colorMap[key + 2];
            destPos += alpha01;
          }
        } else {
          rgbBuf = new Uint8Array(count * 3);
          var rgbPos = 0;

          for (var _i3 = 0; _i3 < count; ++_i3) {
            var _key = comps[_i3] * 3;

            rgbBuf[rgbPos++] = colorMap[_key];
            rgbBuf[rgbPos++] = colorMap[_key + 1];
            rgbBuf[rgbPos++] = colorMap[_key + 2];
          }
        }
      } else {
        if (!needsResizing) {
          this.getRgbBuffer(comps, 0, width * actualHeight, dest, 0, bpc, alpha01);
        } else {
          rgbBuf = new Uint8ClampedArray(count * 3);
          this.getRgbBuffer(comps, 0, count, rgbBuf, 0, bpc, 0);
        }
      }

      if (rgbBuf) {
        if (needsResizing) {
          resizeRgbImage(rgbBuf, dest, originalWidth, originalHeight, width, height, alpha01);
        } else {
          var _destPos = 0,
              _rgbPos = 0;

          for (var _i4 = 0, ii = width * actualHeight; _i4 < ii; _i4++) {
            dest[_destPos++] = rgbBuf[_rgbPos++];
            dest[_destPos++] = rgbBuf[_rgbPos++];
            dest[_destPos++] = rgbBuf[_rgbPos++];
            _destPos += alpha01;
          }
        }
      }
    }
  }, {
    key: "usesZeroToOneRange",
    get: function get() {
      return (0, _util.shadow)(this, "usesZeroToOneRange", true);
    }
  }], [{
    key: "_cache",
    value: function _cache(cacheKey, xref, localColorSpaceCache, parsedColorSpace) {
      if (!localColorSpaceCache) {
        throw new Error('ColorSpace._cache - expected "localColorSpaceCache" argument.');
      }

      if (!parsedColorSpace) {
        throw new Error('ColorSpace._cache - expected "parsedColorSpace" argument.');
      }

      var csName, csRef;

      if (cacheKey instanceof _primitives.Ref) {
        csRef = cacheKey;
        cacheKey = xref.fetch(cacheKey);
      }

      if (cacheKey instanceof _primitives.Name) {
        csName = cacheKey.name;
      }

      if (csName || csRef) {
        localColorSpaceCache.set(csName, csRef, parsedColorSpace);
      }
    }
  }, {
    key: "getCached",
    value: function getCached(cacheKey, xref, localColorSpaceCache) {
      if (!localColorSpaceCache) {
        throw new Error('ColorSpace.getCached - expected "localColorSpaceCache" argument.');
      }

      if (cacheKey instanceof _primitives.Ref) {
        var localColorSpace = localColorSpaceCache.getByRef(cacheKey);

        if (localColorSpace) {
          return localColorSpace;
        }

        try {
          cacheKey = xref.fetch(cacheKey);
        } catch (ex) {
          if (ex instanceof _core_utils.MissingDataException) {
            throw ex;
          }
        }
      }

      if (cacheKey instanceof _primitives.Name) {
        var _localColorSpace = localColorSpaceCache.getByName(cacheKey.name);

        if (_localColorSpace) {
          return _localColorSpace;
        }
      }

      return null;
    }
  }, {
    key: "parseAsync",
    value: function () {
      var _parseAsync = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(_ref) {
        var cs, xref, _ref$resources, resources, pdfFunctionFactory, localColorSpaceCache, parsedColorSpace;

        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cs = _ref.cs, xref = _ref.xref, _ref$resources = _ref.resources, resources = _ref$resources === void 0 ? null : _ref$resources, pdfFunctionFactory = _ref.pdfFunctionFactory, localColorSpaceCache = _ref.localColorSpaceCache;
                parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

                this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

                return _context.abrupt("return", parsedColorSpace);

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function parseAsync(_x) {
        return _parseAsync.apply(this, arguments);
      }

      return parseAsync;
    }()
  }, {
    key: "parse",
    value: function parse(_ref2) {
      var cs = _ref2.cs,
          xref = _ref2.xref,
          _ref2$resources = _ref2.resources,
          resources = _ref2$resources === void 0 ? null : _ref2$resources,
          pdfFunctionFactory = _ref2.pdfFunctionFactory,
          localColorSpaceCache = _ref2.localColorSpaceCache;
      var cachedColorSpace = this.getCached(cs, xref, localColorSpaceCache);

      if (cachedColorSpace) {
        return cachedColorSpace;
      }

      var parsedColorSpace = this._parse(cs, xref, resources, pdfFunctionFactory);

      this._cache(cs, xref, localColorSpaceCache, parsedColorSpace);

      return parsedColorSpace;
    }
  }, {
    key: "_parse",
    value: function _parse(cs, xref) {
      var resources = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      var pdfFunctionFactory = arguments.length > 3 ? arguments[3] : undefined;
      cs = xref.fetchIfRef(cs);

      if ((0, _primitives.isName)(cs)) {
        switch (cs.name) {
          case "DeviceGray":
          case "G":
            return this.singletons.gray;

          case "DeviceRGB":
          case "RGB":
            return this.singletons.rgb;

          case "DeviceCMYK":
          case "CMYK":
            return this.singletons.cmyk;

          case "Pattern":
            return new PatternCS(null);

          default:
            if ((0, _primitives.isDict)(resources)) {
              var colorSpaces = resources.get("ColorSpace");

              if ((0, _primitives.isDict)(colorSpaces)) {
                var resourcesCS = colorSpaces.get(cs.name);

                if (resourcesCS) {
                  if ((0, _primitives.isName)(resourcesCS)) {
                    return this._parse(resourcesCS, xref, resources, pdfFunctionFactory);
                  }

                  cs = resourcesCS;
                  break;
                }
              }
            }

            throw new _util.FormatError("Unrecognized ColorSpace: ".concat(cs.name));
        }
      }

      if (Array.isArray(cs)) {
        var mode = xref.fetchIfRef(cs[0]).name;
        var params, numComps, baseCS, whitePoint, blackPoint, gamma;

        switch (mode) {
          case "DeviceGray":
          case "G":
            return this.singletons.gray;

          case "DeviceRGB":
          case "RGB":
            return this.singletons.rgb;

          case "DeviceCMYK":
          case "CMYK":
            return this.singletons.cmyk;

          case "CalGray":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            gamma = params.get("Gamma");
            return new CalGrayCS(whitePoint, blackPoint, gamma);

          case "CalRGB":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            gamma = params.getArray("Gamma");
            var matrix = params.getArray("Matrix");
            return new CalRGBCS(whitePoint, blackPoint, gamma, matrix);

          case "ICCBased":
            var stream = xref.fetchIfRef(cs[1]);
            var dict = stream.dict;
            numComps = dict.get("N");
            var alt = dict.get("Alternate");

            if (alt) {
              var altCS = this._parse(alt, xref, resources, pdfFunctionFactory);

              if (altCS.numComps === numComps) {
                return altCS;
              }

              (0, _util.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.");
            }

            if (numComps === 1) {
              return this.singletons.gray;
            } else if (numComps === 3) {
              return this.singletons.rgb;
            } else if (numComps === 4) {
              return this.singletons.cmyk;
            }

            break;

          case "Pattern":
            baseCS = cs[1] || null;

            if (baseCS) {
              baseCS = this._parse(baseCS, xref, resources, pdfFunctionFactory);
            }

            return new PatternCS(baseCS);

          case "Indexed":
          case "I":
            baseCS = this._parse(cs[1], xref, resources, pdfFunctionFactory);
            var hiVal = xref.fetchIfRef(cs[2]) + 1;
            var lookup = xref.fetchIfRef(cs[3]);
            return new IndexedCS(baseCS, hiVal, lookup);

          case "Separation":
          case "DeviceN":
            var name = xref.fetchIfRef(cs[1]);
            numComps = Array.isArray(name) ? name.length : 1;
            baseCS = this._parse(cs[2], xref, resources, pdfFunctionFactory);
            var tintFn = pdfFunctionFactory.create(cs[3]);
            return new AlternateCS(numComps, baseCS, tintFn);

          case "Lab":
            params = xref.fetchIfRef(cs[1]);
            whitePoint = params.getArray("WhitePoint");
            blackPoint = params.getArray("BlackPoint");
            var range = params.getArray("Range");
            return new LabCS(whitePoint, blackPoint, range);

          default:
            throw new _util.FormatError("Unimplemented ColorSpace object: ".concat(mode));
        }
      }

      throw new _util.FormatError("Unrecognized ColorSpace object: ".concat(cs));
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decode, numComps) {
      if (!Array.isArray(decode)) {
        return true;
      }

      if (numComps * 2 !== decode.length) {
        (0, _util.warn)("The decode map is not the correct length");
        return true;
      }

      for (var i = 0, ii = decode.length; i < ii; i += 2) {
        if (decode[i] !== 0 || decode[i + 1] !== 1) {
          return false;
        }
      }

      return true;
    }
  }, {
    key: "singletons",
    get: function get() {
      return (0, _util.shadow)(this, "singletons", {
        get gray() {
          return (0, _util.shadow)(this, "gray", new DeviceGrayCS());
        },

        get rgb() {
          return (0, _util.shadow)(this, "rgb", new DeviceRgbCS());
        },

        get cmyk() {
          return (0, _util.shadow)(this, "cmyk", new DeviceCmykCS());
        }

      });
    }
  }]);

  return ColorSpace;
}();

exports.ColorSpace = ColorSpace;

var AlternateCS = /*#__PURE__*/function (_ColorSpace) {
  _inherits(AlternateCS, _ColorSpace);

  var _super = _createSuper(AlternateCS);

  function AlternateCS(numComps, base, tintFn) {
    var _this;

    _classCallCheck(this, AlternateCS);

    _this = _super.call(this, "Alternate", numComps);
    _this.base = base;
    _this.tintFn = tintFn;
    _this.tmpBuf = new Float32Array(base.numComps);
    return _this;
  }

  _createClass(AlternateCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var tmpBuf = this.tmpBuf;
      this.tintFn(src, srcOffset, tmpBuf, 0);
      this.base.getRgbItem(tmpBuf, 0, dest, destOffset);
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var tintFn = this.tintFn;
      var base = this.base;
      var scale = 1 / ((1 << bits) - 1);
      var baseNumComps = base.numComps;
      var usesZeroToOneRange = base.usesZeroToOneRange;
      var isPassthrough = (base.isPassthrough(8) || !usesZeroToOneRange) && alpha01 === 0;
      var pos = isPassthrough ? destOffset : 0;
      var baseBuf = isPassthrough ? dest : new Uint8ClampedArray(baseNumComps * count);
      var numComps = this.numComps;
      var scaled = new Float32Array(numComps);
      var tinted = new Float32Array(baseNumComps);
      var i, j;

      for (i = 0; i < count; i++) {
        for (j = 0; j < numComps; j++) {
          scaled[j] = src[srcOffset++] * scale;
        }

        tintFn(scaled, 0, tinted, 0);

        if (usesZeroToOneRange) {
          for (j = 0; j < baseNumComps; j++) {
            baseBuf[pos++] = tinted[j] * 255;
          }
        } else {
          base.getRgbItem(tinted, 0, baseBuf, pos);
          pos += baseNumComps;
        }
      }

      if (!isPassthrough) {
        base.getRgbBuffer(baseBuf, 0, count, dest, destOffset, 8, alpha01);
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return this.base.getOutputLength(inputLength * this.base.numComps / this.numComps, alpha01);
    }
  }]);

  return AlternateCS;
}(ColorSpace);

var PatternCS = /*#__PURE__*/function (_ColorSpace2) {
  _inherits(PatternCS, _ColorSpace2);

  var _super2 = _createSuper(PatternCS);

  function PatternCS(baseCS) {
    var _this2;

    _classCallCheck(this, PatternCS);

    _this2 = _super2.call(this, "Pattern", null);
    _this2.base = baseCS;
    return _this2;
  }

  _createClass(PatternCS, [{
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      (0, _util.unreachable)("Should not call PatternCS.isDefaultDecode");
    }
  }]);

  return PatternCS;
}(ColorSpace);

var IndexedCS = /*#__PURE__*/function (_ColorSpace3) {
  _inherits(IndexedCS, _ColorSpace3);

  var _super3 = _createSuper(IndexedCS);

  function IndexedCS(base, highVal, lookup) {
    var _this3;

    _classCallCheck(this, IndexedCS);

    _this3 = _super3.call(this, "Indexed", 1);
    _this3.base = base;
    _this3.highVal = highVal;
    var length = base.numComps * highVal;
    _this3.lookup = new Uint8Array(length);

    if ((0, _primitives.isStream)(lookup)) {
      var bytes = lookup.getBytes(length);

      _this3.lookup.set(bytes);
    } else if (typeof lookup === "string") {
      for (var i = 0; i < length; ++i) {
        _this3.lookup[i] = lookup.charCodeAt(i) & 0xff;
      }
    } else {
      throw new _util.FormatError("IndexedCS - unrecognized lookup table: ".concat(lookup));
    }

    return _this3;
  }

  _createClass(IndexedCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var numComps = this.base.numComps;
      var start = src[srcOffset] * numComps;
      this.base.getRgbBuffer(this.lookup, start, 1, dest, destOffset, 8, 0);
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var base = this.base;
      var numComps = base.numComps;
      var outputDelta = base.getOutputLength(numComps, alpha01);
      var lookup = this.lookup;

      for (var i = 0; i < count; ++i) {
        var lookupPos = src[srcOffset++] * numComps;
        base.getRgbBuffer(lookup, lookupPos, 1, dest, destOffset, 8, alpha01);
        destOffset += outputDelta;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return this.base.getOutputLength(inputLength * this.base.numComps, alpha01);
    }
  }, {
    key: "isDefaultDecode",
    value: function isDefaultDecode(decodeMap, bpc) {
      if (!Array.isArray(decodeMap)) {
        return true;
      }

      if (decodeMap.length !== 2) {
        (0, _util.warn)("Decode map length is not correct");
        return true;
      }

      if (!Number.isInteger(bpc) || bpc < 1) {
        (0, _util.warn)("Bits per component is not correct");
        return true;
      }

      return decodeMap[0] === 0 && decodeMap[1] === (1 << bpc) - 1;
    }
  }]);

  return IndexedCS;
}(ColorSpace);

var DeviceGrayCS = /*#__PURE__*/function (_ColorSpace4) {
  _inherits(DeviceGrayCS, _ColorSpace4);

  var _super4 = _createSuper(DeviceGrayCS);

  function DeviceGrayCS() {
    _classCallCheck(this, DeviceGrayCS);

    return _super4.call(this, "DeviceGray", 1);
  }

  _createClass(DeviceGrayCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      var c = src[srcOffset] * 255;
      dest[destOffset] = dest[destOffset + 1] = dest[destOffset + 2] = c;
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      var scale = 255 / ((1 << bits) - 1);
      var j = srcOffset,
          q = destOffset;

      for (var i = 0; i < count; ++i) {
        var c = scale * src[j++];
        dest[q++] = c;
        dest[q++] = c;
        dest[q++] = c;
        q += alpha01;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01);
    }
  }]);

  return DeviceGrayCS;
}(ColorSpace);

var DeviceRgbCS = /*#__PURE__*/function (_ColorSpace5) {
  _inherits(DeviceRgbCS, _ColorSpace5);

  var _super5 = _createSuper(DeviceRgbCS);

  function DeviceRgbCS() {
    _classCallCheck(this, DeviceRgbCS);

    return _super5.call(this, "DeviceRGB", 3);
  }

  _createClass(DeviceRgbCS, [{
    key: "getRgbItem",
    value: function getRgbItem(src, srcOffset, dest, destOffset) {
      dest[destOffset] = src[srcOffset] * 255;
      dest[destOffset + 1] = src[srcOffset + 1] * 255;
      dest[destOffset + 2] = src[srcOffset + 2] * 255;
    }
  }, {
    key: "getRgbBuffer",
    value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
      if (bits === 8 && alpha01 === 0) {
        dest.set(src.subarray(srcOffset, srcOffset + count * 3), destOffset);
        return;
      }

      var scale = 255 / ((1 << bits) - 1);
      var j = srcOffset,
          q = destOffset;

      for (var i = 0; i < count; ++i) {
        dest[q++] = scale * src[j++];
        dest[q++] = scale * src[j++];
        dest[q++] = scale * src[j++];
        q += alpha01;
      }
    }
  }, {
    key: "getOutputLength",
    value: function getOutputLength(inputLength, alpha01) {
      return inputLength * (3 + alpha01) / 3 | 0;
    }
  }, {
    key: "isPassthrough",
    value: function isPassthrough(bits) {
      return bits === 8;
    }
  }]);

  return DeviceRgbCS;
}(ColorSpace);

var DeviceCmykCS = function DeviceCmykCSClosure() {
  function convertToRgb(src, srcOffset, srcScale, dest, destOffset) {
    var c = src[srcOffset] * srcScale;
    var m = src[srcOffset + 1] * srcScale;
    var y = src[srcOffset + 2] * srcScale;
    var k = src[srcOffset + 3] * srcScale;
    dest[destOffset] = 255 + c * (-4.387332384609988 * c + 54.48615194189176 * m + 18.82290502165302 * y + 212.25662451639585 * k + -285.2331026137004) + m * (1.7149763477362134 * m - 5.6096736904047315 * y + -17.873870861415444 * k - 5.497006427196366) + y * (-2.5217340131683033 * y - 21.248923337353073 * k + 17.5119270841813) + k * (-21.86122147463605 * k - 189.48180835922747);
    dest[destOffset + 1] = 255 + c * (8.841041422036149 * c + 60.118027045597366 * m + 6.871425592049007 * y + 31.159100130055922 * k + -79.2970844816548) + m * (-15.310361306967817 * m + 17.575251261109482 * y + 131.35250912493976 * k - 190.9453302588951) + y * (4.444339102852739 * y + 9.8632861493405 * k - 24.86741582555878) + k * (-20.737325471181034 * k - 187.80453709719578);
    dest[destOffset + 2] = 255 + c * (0.8842522430003296 * c + 8.078677503112928 * m + 30.89978309703729 * y - 0.23883238689178934 * k + -14.183576799673286) + m * (10.49593273432072 * m + 63.02378494754052 * y + 50.606957656360734 * k - 112.23884253719248) + y * (0.03296041114873217 * y + 115.60384449646641 * k + -193.58209356861505) + k * (-22.33816807309886 * k - 180.12613974708367);
  }

  var DeviceCmykCS = /*#__PURE__*/function (_ColorSpace6) {
    _inherits(DeviceCmykCS, _ColorSpace6);

    var _super6 = _createSuper(DeviceCmykCS);

    function DeviceCmykCS() {
      _classCallCheck(this, DeviceCmykCS);

      return _super6.call(this, "DeviceCMYK", 4);
    }

    _createClass(DeviceCmykCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(src, srcOffset, 1, dest, destOffset);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; i++) {
          convertToRgb(src, srcOffset, scale, dest, destOffset);
          srcOffset += 4;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength / 4 * (3 + alpha01) | 0;
      }
    }]);

    return DeviceCmykCS;
  }(ColorSpace);

  return DeviceCmykCS;
}();

var CalGrayCS = function CalGrayCSClosure() {
  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    var A = src[srcOffset] * scale;
    var AG = Math.pow(A, cs.G);
    var L = cs.YW * AG;
    var val = Math.max(295.8 * Math.pow(L, 0.333333333333333333) - 40.8, 0);
    dest[destOffset] = val;
    dest[destOffset + 1] = val;
    dest[destOffset + 2] = val;
  }

  var CalGrayCS = /*#__PURE__*/function (_ColorSpace7) {
    _inherits(CalGrayCS, _ColorSpace7);

    var _super7 = _createSuper(CalGrayCS);

    function CalGrayCS(whitePoint, blackPoint, gamma) {
      var _this4;

      _classCallCheck(this, CalGrayCS);

      _this4 = _super7.call(this, "CalGray", 1);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalGray");
      }

      blackPoint = blackPoint || [0, 0, 0];
      gamma = gamma || 1;
      _this4.XW = whitePoint[0];
      _this4.YW = whitePoint[1];
      _this4.ZW = whitePoint[2];
      _this4.XB = blackPoint[0];
      _this4.YB = blackPoint[1];
      _this4.ZB = blackPoint[2];
      _this4.G = gamma;

      if (_this4.XW < 0 || _this4.ZW < 0 || _this4.YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this4.name) + ", no fallback available");
      }

      if (_this4.XB < 0 || _this4.YB < 0 || _this4.ZB < 0) {
        (0, _util.info)("Invalid BlackPoint for ".concat(_this4.name, ", falling back to default."));
        _this4.XB = _this4.YB = _this4.ZB = 0;
      }

      if (_this4.XB !== 0 || _this4.YB !== 0 || _this4.ZB !== 0) {
        (0, _util.warn)("".concat(_this4.name, ", BlackPoint: XB: ").concat(_this4.XB, ", YB: ").concat(_this4.YB, ", ") + "ZB: ".concat(_this4.ZB, ", only default values are supported."));
      }

      if (_this4.G < 1) {
        (0, _util.info)("Invalid Gamma: ".concat(_this4.G, " for ").concat(_this4.name, ", ") + "falling back to default.");
        _this4.G = 1;
      }

      return _this4;
    }

    _createClass(CalGrayCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, dest, destOffset, 1);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; ++i) {
          convertToRgb(this, src, srcOffset, dest, destOffset, scale);
          srcOffset += 1;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01);
      }
    }]);

    return CalGrayCS;
  }(ColorSpace);

  return CalGrayCS;
}();

var CalRGBCS = function CalRGBCSClosure() {
  var BRADFORD_SCALE_MATRIX = new Float32Array([0.8951, 0.2664, -0.1614, -0.7502, 1.7135, 0.0367, 0.0389, -0.0685, 1.0296]);
  var BRADFORD_SCALE_INVERSE_MATRIX = new Float32Array([0.9869929, -0.1470543, 0.1599627, 0.4323053, 0.5183603, 0.0492912, -0.0085287, 0.0400428, 0.9684867]);
  var SRGB_D65_XYZ_TO_RGB_MATRIX = new Float32Array([3.2404542, -1.5371385, -0.4985314, -0.9692660, 1.8760108, 0.0415560, 0.0556434, -0.2040259, 1.0572252]);
  var FLAT_WHITEPOINT_MATRIX = new Float32Array([1, 1, 1]);
  var tempNormalizeMatrix = new Float32Array(3);
  var tempConvertMatrix1 = new Float32Array(3);
  var tempConvertMatrix2 = new Float32Array(3);
  var DECODE_L_CONSTANT = Math.pow((8 + 16) / 116, 3) / 8.0;

  function matrixProduct(a, b, result) {
    result[0] = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    result[1] = a[3] * b[0] + a[4] * b[1] + a[5] * b[2];
    result[2] = a[6] * b[0] + a[7] * b[1] + a[8] * b[2];
  }

  function convertToFlat(sourceWhitePoint, LMS, result) {
    result[0] = LMS[0] * 1 / sourceWhitePoint[0];
    result[1] = LMS[1] * 1 / sourceWhitePoint[1];
    result[2] = LMS[2] * 1 / sourceWhitePoint[2];
  }

  function convertToD65(sourceWhitePoint, LMS, result) {
    var D65X = 0.95047;
    var D65Y = 1;
    var D65Z = 1.08883;
    result[0] = LMS[0] * D65X / sourceWhitePoint[0];
    result[1] = LMS[1] * D65Y / sourceWhitePoint[1];
    result[2] = LMS[2] * D65Z / sourceWhitePoint[2];
  }

  function sRGBTransferFunction(color) {
    if (color <= 0.0031308) {
      return adjustToRange(0, 1, 12.92 * color);
    }

    if (color >= 0.99554525) {
      return 1;
    }

    return adjustToRange(0, 1, (1 + 0.055) * Math.pow(color, 1 / 2.4) - 0.055);
  }

  function adjustToRange(min, max, value) {
    return Math.max(min, Math.min(max, value));
  }

  function decodeL(L) {
    if (L < 0) {
      return -decodeL(-L);
    }

    if (L > 8.0) {
      return Math.pow((L + 16) / 116, 3);
    }

    return L * DECODE_L_CONSTANT;
  }

  function compensateBlackPoint(sourceBlackPoint, XYZ_Flat, result) {
    if (sourceBlackPoint[0] === 0 && sourceBlackPoint[1] === 0 && sourceBlackPoint[2] === 0) {
      result[0] = XYZ_Flat[0];
      result[1] = XYZ_Flat[1];
      result[2] = XYZ_Flat[2];
      return;
    }

    var zeroDecodeL = decodeL(0);
    var X_DST = zeroDecodeL;
    var X_SRC = decodeL(sourceBlackPoint[0]);
    var Y_DST = zeroDecodeL;
    var Y_SRC = decodeL(sourceBlackPoint[1]);
    var Z_DST = zeroDecodeL;
    var Z_SRC = decodeL(sourceBlackPoint[2]);
    var X_Scale = (1 - X_DST) / (1 - X_SRC);
    var X_Offset = 1 - X_Scale;
    var Y_Scale = (1 - Y_DST) / (1 - Y_SRC);
    var Y_Offset = 1 - Y_Scale;
    var Z_Scale = (1 - Z_DST) / (1 - Z_SRC);
    var Z_Offset = 1 - Z_Scale;
    result[0] = XYZ_Flat[0] * X_Scale + X_Offset;
    result[1] = XYZ_Flat[1] * Y_Scale + Y_Offset;
    result[2] = XYZ_Flat[2] * Z_Scale + Z_Offset;
  }

  function normalizeWhitePointToFlat(sourceWhitePoint, XYZ_In, result) {
    if (sourceWhitePoint[0] === 1 && sourceWhitePoint[2] === 1) {
      result[0] = XYZ_In[0];
      result[1] = XYZ_In[1];
      result[2] = XYZ_In[2];
      return;
    }

    var LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    var LMS_Flat = tempNormalizeMatrix;
    convertToFlat(sourceWhitePoint, LMS, LMS_Flat);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_Flat, result);
  }

  function normalizeWhitePointToD65(sourceWhitePoint, XYZ_In, result) {
    var LMS = result;
    matrixProduct(BRADFORD_SCALE_MATRIX, XYZ_In, LMS);
    var LMS_D65 = tempNormalizeMatrix;
    convertToD65(sourceWhitePoint, LMS, LMS_D65);
    matrixProduct(BRADFORD_SCALE_INVERSE_MATRIX, LMS_D65, result);
  }

  function convertToRgb(cs, src, srcOffset, dest, destOffset, scale) {
    var A = adjustToRange(0, 1, src[srcOffset] * scale);
    var B = adjustToRange(0, 1, src[srcOffset + 1] * scale);
    var C = adjustToRange(0, 1, src[srcOffset + 2] * scale);
    var AGR = A === 1 ? 1 : Math.pow(A, cs.GR);
    var BGG = B === 1 ? 1 : Math.pow(B, cs.GG);
    var CGB = C === 1 ? 1 : Math.pow(C, cs.GB);
    var X = cs.MXA * AGR + cs.MXB * BGG + cs.MXC * CGB;
    var Y = cs.MYA * AGR + cs.MYB * BGG + cs.MYC * CGB;
    var Z = cs.MZA * AGR + cs.MZB * BGG + cs.MZC * CGB;
    var XYZ = tempConvertMatrix1;
    XYZ[0] = X;
    XYZ[1] = Y;
    XYZ[2] = Z;
    var XYZ_Flat = tempConvertMatrix2;
    normalizeWhitePointToFlat(cs.whitePoint, XYZ, XYZ_Flat);
    var XYZ_Black = tempConvertMatrix1;
    compensateBlackPoint(cs.blackPoint, XYZ_Flat, XYZ_Black);
    var XYZ_D65 = tempConvertMatrix2;
    normalizeWhitePointToD65(FLAT_WHITEPOINT_MATRIX, XYZ_Black, XYZ_D65);
    var SRGB = tempConvertMatrix1;
    matrixProduct(SRGB_D65_XYZ_TO_RGB_MATRIX, XYZ_D65, SRGB);
    dest[destOffset] = sRGBTransferFunction(SRGB[0]) * 255;
    dest[destOffset + 1] = sRGBTransferFunction(SRGB[1]) * 255;
    dest[destOffset + 2] = sRGBTransferFunction(SRGB[2]) * 255;
  }

  var CalRGBCS = /*#__PURE__*/function (_ColorSpace8) {
    _inherits(CalRGBCS, _ColorSpace8);

    var _super8 = _createSuper(CalRGBCS);

    function CalRGBCS(whitePoint, blackPoint, gamma, matrix) {
      var _this5;

      _classCallCheck(this, CalRGBCS);

      _this5 = _super8.call(this, "CalRGB", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space CalRGB");
      }

      blackPoint = blackPoint || new Float32Array(3);
      gamma = gamma || new Float32Array([1, 1, 1]);
      matrix = matrix || new Float32Array([1, 0, 0, 0, 1, 0, 0, 0, 1]);
      var XW = whitePoint[0];
      var YW = whitePoint[1];
      var ZW = whitePoint[2];
      _this5.whitePoint = whitePoint;
      var XB = blackPoint[0];
      var YB = blackPoint[1];
      var ZB = blackPoint[2];
      _this5.blackPoint = blackPoint;
      _this5.GR = gamma[0];
      _this5.GG = gamma[1];
      _this5.GB = gamma[2];
      _this5.MXA = matrix[0];
      _this5.MYA = matrix[1];
      _this5.MZA = matrix[2];
      _this5.MXB = matrix[3];
      _this5.MYB = matrix[4];
      _this5.MZB = matrix[5];
      _this5.MXC = matrix[6];
      _this5.MYC = matrix[7];
      _this5.MZC = matrix[8];

      if (XW < 0 || ZW < 0 || YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components for ".concat(_this5.name) + ", no fallback available");
      }

      if (XB < 0 || YB < 0 || ZB < 0) {
        (0, _util.info)("Invalid BlackPoint for ".concat(_this5.name, " [").concat(XB, ", ").concat(YB, ", ").concat(ZB, "], ") + "falling back to default.");
        _this5.blackPoint = new Float32Array(3);
      }

      if (_this5.GR < 0 || _this5.GG < 0 || _this5.GB < 0) {
        (0, _util.info)("Invalid Gamma [".concat(_this5.GR, ", ").concat(_this5.GG, ", ").concat(_this5.GB, "] for ") + "".concat(_this5.name, ", falling back to default."));
        _this5.GR = _this5.GG = _this5.GB = 1;
      }

      return _this5;
    }

    _createClass(CalRGBCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, dest, destOffset, 1);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var scale = 1 / ((1 << bits) - 1);

        for (var i = 0; i < count; ++i) {
          convertToRgb(this, src, srcOffset, dest, destOffset, scale);
          srcOffset += 3;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01) / 3 | 0;
      }
    }]);

    return CalRGBCS;
  }(ColorSpace);

  return CalRGBCS;
}();

var LabCS = function LabCSClosure() {
  function fn_g(x) {
    var result;

    if (x >= 6 / 29) {
      result = Math.pow(x, 3);
    } else {
      result = 108 / 841 * (x - 4 / 29);
    }

    return result;
  }

  function decode(value, high1, low2, high2) {
    return low2 + value * (high2 - low2) / high1;
  }

  function convertToRgb(cs, src, srcOffset, maxVal, dest, destOffset) {
    var Ls = src[srcOffset];
    var as = src[srcOffset + 1];
    var bs = src[srcOffset + 2];

    if (maxVal !== false) {
      Ls = decode(Ls, maxVal, 0, 100);
      as = decode(as, maxVal, cs.amin, cs.amax);
      bs = decode(bs, maxVal, cs.bmin, cs.bmax);
    }

    if (as > cs.amax) {
      as = cs.amax;
    } else if (as < cs.amin) {
      as = cs.amin;
    }

    if (bs > cs.bmax) {
      bs = cs.bmax;
    } else if (bs < cs.bmin) {
      bs = cs.bmin;
    }

    var M = (Ls + 16) / 116;
    var L = M + as / 500;
    var N = M - bs / 200;
    var X = cs.XW * fn_g(L);
    var Y = cs.YW * fn_g(M);
    var Z = cs.ZW * fn_g(N);
    var r, g, b;

    if (cs.ZW < 1) {
      r = X * 3.1339 + Y * -1.617 + Z * -0.4906;
      g = X * -0.9785 + Y * 1.916 + Z * 0.0333;
      b = X * 0.072 + Y * -0.229 + Z * 1.4057;
    } else {
      r = X * 3.2406 + Y * -1.5372 + Z * -0.4986;
      g = X * -0.9689 + Y * 1.8758 + Z * 0.0415;
      b = X * 0.0557 + Y * -0.204 + Z * 1.057;
    }

    dest[destOffset] = Math.sqrt(r) * 255;
    dest[destOffset + 1] = Math.sqrt(g) * 255;
    dest[destOffset + 2] = Math.sqrt(b) * 255;
  }

  var LabCS = /*#__PURE__*/function (_ColorSpace9) {
    _inherits(LabCS, _ColorSpace9);

    var _super9 = _createSuper(LabCS);

    function LabCS(whitePoint, blackPoint, range) {
      var _this6;

      _classCallCheck(this, LabCS);

      _this6 = _super9.call(this, "Lab", 3);

      if (!whitePoint) {
        throw new _util.FormatError("WhitePoint missing - required for color space Lab");
      }

      blackPoint = blackPoint || [0, 0, 0];
      range = range || [-100, 100, -100, 100];
      _this6.XW = whitePoint[0];
      _this6.YW = whitePoint[1];
      _this6.ZW = whitePoint[2];
      _this6.amin = range[0];
      _this6.amax = range[1];
      _this6.bmin = range[2];
      _this6.bmax = range[3];
      _this6.XB = blackPoint[0];
      _this6.YB = blackPoint[1];
      _this6.ZB = blackPoint[2];

      if (_this6.XW < 0 || _this6.ZW < 0 || _this6.YW !== 1) {
        throw new _util.FormatError("Invalid WhitePoint components, no fallback available");
      }

      if (_this6.XB < 0 || _this6.YB < 0 || _this6.ZB < 0) {
        (0, _util.info)("Invalid BlackPoint, falling back to default");
        _this6.XB = _this6.YB = _this6.ZB = 0;
      }

      if (_this6.amin > _this6.amax || _this6.bmin > _this6.bmax) {
        (0, _util.info)("Invalid Range, falling back to defaults");
        _this6.amin = -100;
        _this6.amax = 100;
        _this6.bmin = -100;
        _this6.bmax = 100;
      }

      return _this6;
    }

    _createClass(LabCS, [{
      key: "getRgbItem",
      value: function getRgbItem(src, srcOffset, dest, destOffset) {
        convertToRgb(this, src, srcOffset, false, dest, destOffset);
      }
    }, {
      key: "getRgbBuffer",
      value: function getRgbBuffer(src, srcOffset, count, dest, destOffset, bits, alpha01) {
        var maxVal = (1 << bits) - 1;

        for (var i = 0; i < count; i++) {
          convertToRgb(this, src, srcOffset, maxVal, dest, destOffset);
          srcOffset += 3;
          destOffset += 3 + alpha01;
        }
      }
    }, {
      key: "getOutputLength",
      value: function getOutputLength(inputLength, alpha01) {
        return inputLength * (3 + alpha01) / 3 | 0;
      }
    }, {
      key: "isDefaultDecode",
      value: function isDefaultDecode(decodeMap, bpc) {
        return true;
      }
    }, {
      key: "usesZeroToOneRange",
      get: function get() {
        return (0, _util.shadow)(this, "usesZeroToOneRange", false);
      }
    }]);

    return LabCS;
  }(ColorSpace);

  return LabCS;
}();

/***/ }),
/* 123 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.PartialEvaluator = exports.EvaluatorPreprocessor = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _cmap = __w_pdfjs_require__(124);

var _primitives = __w_pdfjs_require__(113);

var _fonts = __w_pdfjs_require__(142);

var _fonts_utils = __w_pdfjs_require__(146);

var _encodings = __w_pdfjs_require__(145);

var _unicode = __w_pdfjs_require__(148);

var _standard_fonts = __w_pdfjs_require__(149);

var _pattern = __w_pdfjs_require__(156);

var _to_unicode_map = __w_pdfjs_require__(150);

var _function = __w_pdfjs_require__(157);

var _parser = __w_pdfjs_require__(125);

var _image_utils = __w_pdfjs_require__(159);

var _bidi = __w_pdfjs_require__(160);

var _colorspace = __w_pdfjs_require__(122);

var _decode_stream = __w_pdfjs_require__(127);

var _glyphlist = __w_pdfjs_require__(147);

var _core_utils = __w_pdfjs_require__(117);

var _metrics = __w_pdfjs_require__(161);

var _murmurhash = __w_pdfjs_require__(162);

var _stream = __w_pdfjs_require__(118);

var _operator_list = __w_pdfjs_require__(163);

var _image = __w_pdfjs_require__(164);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { var _i = arr && (typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]); if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var DefaultPartialEvaluatorOptions = Object.freeze({
  maxImageSize: -1,
  disableFontFace: false,
  ignoreErrors: false,
  isEvalSupported: true,
  fontExtraProperties: false
});
var PatternType = {
  TILING: 1,
  SHADING: 2
};
var deferred = Promise.resolve();

function normalizeBlendMode(value) {
  var parsingArray = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  if (Array.isArray(value)) {
    for (var i = 0, ii = value.length; i < ii; i++) {
      var maybeBM = normalizeBlendMode(value[i], true);

      if (maybeBM) {
        return maybeBM;
      }
    }

    (0, _util.warn)("Unsupported blend mode Array: ".concat(value));
    return "source-over";
  }

  if (!(0, _primitives.isName)(value)) {
    if (parsingArray) {
      return null;
    }

    return "source-over";
  }

  switch (value.name) {
    case "Normal":
    case "Compatible":
      return "source-over";

    case "Multiply":
      return "multiply";

    case "Screen":
      return "screen";

    case "Overlay":
      return "overlay";

    case "Darken":
      return "darken";

    case "Lighten":
      return "lighten";

    case "ColorDodge":
      return "color-dodge";

    case "ColorBurn":
      return "color-burn";

    case "HardLight":
      return "hard-light";

    case "SoftLight":
      return "soft-light";

    case "Difference":
      return "difference";

    case "Exclusion":
      return "exclusion";

    case "Hue":
      return "hue";

    case "Saturation":
      return "saturation";

    case "Color":
      return "color";

    case "Luminosity":
      return "luminosity";
  }

  if (parsingArray) {
    return null;
  }

  (0, _util.warn)("Unsupported blend mode: ".concat(value.name));
  return "source-over";
}

var TimeSlotManager = /*#__PURE__*/function () {
  function TimeSlotManager() {
    _classCallCheck(this, TimeSlotManager);

    this.reset();
  }

  _createClass(TimeSlotManager, [{
    key: "check",
    value: function check() {
      if (++this.checked < TimeSlotManager.CHECK_TIME_EVERY) {
        return false;
      }

      this.checked = 0;
      return this.endTime <= Date.now();
    }
  }, {
    key: "reset",
    value: function reset() {
      this.endTime = Date.now() + TimeSlotManager.TIME_SLOT_DURATION_MS;
      this.checked = 0;
    }
  }], [{
    key: "TIME_SLOT_DURATION_MS",
    get: function get() {
      return (0, _util.shadow)(this, "TIME_SLOT_DURATION_MS", 20);
    }
  }, {
    key: "CHECK_TIME_EVERY",
    get: function get() {
      return (0, _util.shadow)(this, "CHECK_TIME_EVERY", 100);
    }
  }]);

  return TimeSlotManager;
}();

var PartialEvaluator = /*#__PURE__*/function () {
  function PartialEvaluator(_ref) {
    var xref = _ref.xref,
        handler = _ref.handler,
        pageIndex = _ref.pageIndex,
        idFactory = _ref.idFactory,
        fontCache = _ref.fontCache,
        builtInCMapCache = _ref.builtInCMapCache,
        globalImageCache = _ref.globalImageCache,
        _ref$options = _ref.options,
        options = _ref$options === void 0 ? null : _ref$options;

    _classCallCheck(this, PartialEvaluator);

    this.xref = xref;
    this.handler = handler;
    this.pageIndex = pageIndex;
    this.idFactory = idFactory;
    this.fontCache = fontCache;
    this.builtInCMapCache = builtInCMapCache;
    this.globalImageCache = globalImageCache;
    this.options = options || DefaultPartialEvaluatorOptions;
    this.parsingType3Font = false;
    this._fetchBuiltInCMapBound = this.fetchBuiltInCMap.bind(this);
  }

  _createClass(PartialEvaluator, [{
    key: "_pdfFunctionFactory",
    get: function get() {
      var pdfFunctionFactory = new _function.PDFFunctionFactory({
        xref: this.xref,
        isEvalSupported: this.options.isEvalSupported
      });
      return (0, _util.shadow)(this, "_pdfFunctionFactory", pdfFunctionFactory);
    }
  }, {
    key: "clone",
    value: function clone() {
      var newOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DefaultPartialEvaluatorOptions;
      var newEvaluator = Object.create(this);
      newEvaluator.options = newOptions;
      return newEvaluator;
    }
  }, {
    key: "hasBlendModes",
    value: function hasBlendModes(resources, nonBlendModesSet) {
      if (!(resources instanceof _primitives.Dict)) {
        return false;
      }

      if (resources.objId && nonBlendModesSet.has(resources.objId)) {
        return false;
      }

      var processed = new _primitives.RefSet(nonBlendModesSet);

      if (resources.objId) {
        processed.put(resources.objId);
      }

      var nodes = [resources],
          xref = this.xref;

      while (nodes.length) {
        var node = nodes.shift();
        var graphicStates = node.get("ExtGState");

        if (graphicStates instanceof _primitives.Dict) {
          var _iterator = _createForOfIteratorHelper(graphicStates.getRawValues()),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var graphicState = _step.value;

              if (graphicState instanceof _primitives.Ref) {
                if (processed.has(graphicState)) {
                  continue;
                }

                try {
                  graphicState = xref.fetch(graphicState);
                } catch (ex) {
                  processed.put(graphicState);
                  (0, _util.info)("hasBlendModes - ignoring ExtGState: \"".concat(ex, "\"."));
                  continue;
                }
              }

              if (!(graphicState instanceof _primitives.Dict)) {
                continue;
              }

              if (graphicState.objId) {
                processed.put(graphicState.objId);
              }

              var bm = graphicState.get("BM");

              if (bm instanceof _primitives.Name) {
                if (bm.name !== "Normal") {
                  return true;
                }

                continue;
              }

              if (bm !== undefined && Array.isArray(bm)) {
                var _iterator2 = _createForOfIteratorHelper(bm),
                    _step2;

                try {
                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    var element = _step2.value;

                    if (element instanceof _primitives.Name && element.name !== "Normal") {
                      return true;
                    }
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }

        var xObjects = node.get("XObject");

        if (!(xObjects instanceof _primitives.Dict)) {
          continue;
        }

        var _iterator3 = _createForOfIteratorHelper(xObjects.getRawValues()),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var xObject = _step3.value;

            if (xObject instanceof _primitives.Ref) {
              if (processed.has(xObject)) {
                continue;
              }

              try {
                xObject = xref.fetch(xObject);
              } catch (ex) {
                processed.put(xObject);
                (0, _util.info)("hasBlendModes - ignoring XObject: \"".concat(ex, "\"."));
                continue;
              }
            }

            if (!(0, _primitives.isStream)(xObject)) {
              continue;
            }

            if (xObject.dict.objId) {
              processed.put(xObject.dict.objId);
            }

            var xResources = xObject.dict.get("Resources");

            if (!(xResources instanceof _primitives.Dict)) {
              continue;
            }

            if (xResources.objId && processed.has(xResources.objId)) {
              continue;
            }

            nodes.push(xResources);

            if (xResources.objId) {
              processed.put(xResources.objId);
            }
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }

      processed.forEach(function (ref) {
        nonBlendModesSet.put(ref);
      });
      return false;
    }
  }, {
    key: "fetchBuiltInCMap",
    value: function () {
      var _fetchBuiltInCMap = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(name) {
        var cachedData, readableStream, reader, data;
        return _regenerator["default"].wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                cachedData = this.builtInCMapCache.get(name);

                if (!cachedData) {
                  _context.next = 3;
                  break;
                }

                return _context.abrupt("return", cachedData);

              case 3:
                readableStream = this.handler.sendWithStream("FetchBuiltInCMap", {
                  name: name
                });
                reader = readableStream.getReader();
                _context.next = 7;
                return new Promise(function (resolve, reject) {
                  function pump() {
                    reader.read().then(function (_ref2) {
                      var value = _ref2.value,
                          done = _ref2.done;

                      if (done) {
                        return;
                      }

                      resolve(value);
                      pump();
                    }, reject);
                  }

                  pump();
                });

              case 7:
                data = _context.sent;

                if (data.compressionType !== _util.CMapCompressionType.NONE) {
                  this.builtInCMapCache.set(name, data);
                }

                return _context.abrupt("return", data);

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function fetchBuiltInCMap(_x) {
        return _fetchBuiltInCMap.apply(this, arguments);
      }

      return fetchBuiltInCMap;
    }()
  }, {
    key: "buildFormXObject",
    value: function () {
      var _buildFormXObject = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2(resources, xobj, smask, operatorList, task, initialState, localColorSpaceCache) {
        var dict, matrix, bbox, optionalContent, groupOptions, group, groupSubtype, colorSpace, cs, cachedColorSpace;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                dict = xobj.dict;
                matrix = dict.getArray("Matrix");
                bbox = dict.getArray("BBox");

                if (Array.isArray(bbox) && bbox.length === 4) {
                  bbox = _util.Util.normalizeRect(bbox);
                } else {
                  bbox = null;
                }

                optionalContent = null;

                if (!dict.has("OC")) {
                  _context2.next = 10;
                  break;
                }

                _context2.next = 8;
                return this.parseMarkedContentProps(dict.get("OC"), resources);

              case 8:
                optionalContent = _context2.sent;
                operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", optionalContent]);

              case 10:
                group = dict.get("Group");

                if (!group) {
                  _context2.next = 30;
                  break;
                }

                groupOptions = {
                  matrix: matrix,
                  bbox: bbox,
                  smask: smask,
                  isolated: false,
                  knockout: false
                };
                groupSubtype = group.get("S");
                colorSpace = null;

                if (!(0, _primitives.isName)(groupSubtype, "Transparency")) {
                  _context2.next = 28;
                  break;
                }

                groupOptions.isolated = group.get("I") || false;
                groupOptions.knockout = group.get("K") || false;

                if (!group.has("CS")) {
                  _context2.next = 28;
                  break;
                }

                cs = group.getRaw("CS");
                cachedColorSpace = _colorspace.ColorSpace.getCached(cs, this.xref, localColorSpaceCache);

                if (!cachedColorSpace) {
                  _context2.next = 25;
                  break;
                }

                colorSpace = cachedColorSpace;
                _context2.next = 28;
                break;

              case 25:
                _context2.next = 27;
                return this.parseColorSpace({
                  cs: cs,
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                });

              case 27:
                colorSpace = _context2.sent;

              case 28:
                if (smask && smask.backdrop) {
                  colorSpace = colorSpace || _colorspace.ColorSpace.singletons.rgb;
                  smask.backdrop = colorSpace.getRgb(smask.backdrop, 0);
                }

                operatorList.addOp(_util.OPS.beginGroup, [groupOptions]);

              case 30:
                operatorList.addOp(_util.OPS.paintFormXObjectBegin, [matrix, bbox]);
                return _context2.abrupt("return", this.getOperatorList({
                  stream: xobj,
                  task: task,
                  resources: dict.get("Resources") || resources,
                  operatorList: operatorList,
                  initialState: initialState
                }).then(function () {
                  operatorList.addOp(_util.OPS.paintFormXObjectEnd, []);

                  if (group) {
                    operatorList.addOp(_util.OPS.endGroup, [groupOptions]);
                  }

                  if (optionalContent) {
                    operatorList.addOp(_util.OPS.endMarkedContent, []);
                  }
                }));

              case 32:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function buildFormXObject(_x2, _x3, _x4, _x5, _x6, _x7, _x8) {
        return _buildFormXObject.apply(this, arguments);
      }

      return buildFormXObject;
    }()
  }, {
    key: "_sendImgData",
    value: function _sendImgData(objId, imgData) {
      var cacheGlobally = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var transfers = imgData ? [imgData.data.buffer] : null;

      if (this.parsingType3Font || cacheGlobally) {
        return this.handler.send("commonobj", [objId, "Image", imgData], transfers);
      }

      return this.handler.send("obj", [objId, this.pageIndex, "Image", imgData], transfers);
    }
  }, {
    key: "buildPaintImageXObject",
    value: function () {
      var _buildPaintImageXObject = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(_ref3) {
        var _this = this;

        var resources, image, _ref3$isInline, isInline, operatorList, cacheKey, localImageCache, localColorSpaceCache, dict, imageRef, w, h, maxImageSize, imageMask, imgData, args, width, height, bitStrideLength, imgArray, decode, softMask, mask, SMALL_IMAGE_DIMENSIONS, imageObj, objId, cacheGlobally;

        return _regenerator["default"].wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                resources = _ref3.resources, image = _ref3.image, _ref3$isInline = _ref3.isInline, isInline = _ref3$isInline === void 0 ? false : _ref3$isInline, operatorList = _ref3.operatorList, cacheKey = _ref3.cacheKey, localImageCache = _ref3.localImageCache, localColorSpaceCache = _ref3.localColorSpaceCache;
                dict = image.dict;
                imageRef = dict.objId;
                w = dict.get("Width", "W");
                h = dict.get("Height", "H");

                if (!(!(w && (0, _util.isNum)(w)) || !(h && (0, _util.isNum)(h)))) {
                  _context3.next = 8;
                  break;
                }

                (0, _util.warn)("Image dimensions are missing, or not numbers.");
                return _context3.abrupt("return", undefined);

              case 8:
                maxImageSize = this.options.maxImageSize;

                if (!(maxImageSize !== -1 && w * h > maxImageSize)) {
                  _context3.next = 12;
                  break;
                }

                (0, _util.warn)("Image exceeded maximum allowed size and was removed.");
                return _context3.abrupt("return", undefined);

              case 12:
                imageMask = dict.get("ImageMask", "IM") || false;

                if (!imageMask) {
                  _context3.next = 25;
                  break;
                }

                width = dict.get("Width", "W");
                height = dict.get("Height", "H");
                bitStrideLength = width + 7 >> 3;
                imgArray = image.getBytes(bitStrideLength * height, true);
                decode = dict.getArray("Decode", "D");
                imgData = _image.PDFImage.createMask({
                  imgArray: imgArray,
                  width: width,
                  height: height,
                  imageIsFromDecodeStream: image instanceof _decode_stream.DecodeStream,
                  inverseDecode: !!decode && decode[0] > 0
                });
                imgData.cached = !!cacheKey;
                args = [imgData];
                operatorList.addOp(_util.OPS.paintImageMaskXObject, args);

                if (cacheKey) {
                  localImageCache.set(cacheKey, imageRef, {
                    fn: _util.OPS.paintImageMaskXObject,
                    args: args
                  });
                }

                return _context3.abrupt("return", undefined);

              case 25:
                softMask = dict.get("SMask", "SM") || false;
                mask = dict.get("Mask") || false;
                SMALL_IMAGE_DIMENSIONS = 200;

                if (!(isInline && !softMask && !mask && w + h < SMALL_IMAGE_DIMENSIONS)) {
                  _context3.next = 33;
                  break;
                }

                imageObj = new _image.PDFImage({
                  xref: this.xref,
                  res: resources,
                  image: image,
                  isInline: isInline,
                  pdfFunctionFactory: this._pdfFunctionFactory,
                  localColorSpaceCache: localColorSpaceCache
                });
                imgData = imageObj.createImageData(true);
                operatorList.addOp(_util.OPS.paintInlineImageXObject, [imgData]);
                return _context3.abrupt("return", undefined);

              case 33:
                objId = "img_".concat(this.idFactory.createObjId()), cacheGlobally = false;

                if (this.parsingType3Font) {
                  objId = "".concat(this.idFactory.getDocId(), "_type3_").concat(objId);
                } else if (imageRef) {
                  cacheGlobally = this.globalImageCache.shouldCache(imageRef, this.pageIndex);

                  if (cacheGlobally) {
                    objId = "".concat(this.idFactory.getDocId(), "_").concat(objId);
                  }
                }

                operatorList.addDependency(objId);
                args = [objId, w, h];

                _image.PDFImage.buildImage({
                  xref: this.xref,
                  res: resources,
                  image: image,
                  isInline: isInline,
                  pdfFunctionFactory: this._pdfFunctionFactory,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (imageObj) {
                  imgData = imageObj.createImageData(false);

                  if (cacheKey && imageRef && cacheGlobally) {
                    _this.globalImageCache.addByteSize(imageRef, imgData.data.length);
                  }

                  return _this._sendImgData(objId, imgData, cacheGlobally);
                })["catch"](function (reason) {
                  (0, _util.warn)("Unable to decode image \"".concat(objId, "\": \"").concat(reason, "\"."));
                  return _this._sendImgData(objId, null, cacheGlobally);
                });

                operatorList.addOp(_util.OPS.paintImageXObject, args);

                if (cacheKey) {
                  localImageCache.set(cacheKey, imageRef, {
                    fn: _util.OPS.paintImageXObject,
                    args: args
                  });

                  if (imageRef) {
                    (0, _util.assert)(!isInline, "Cannot cache an inline image globally.");
                    this.globalImageCache.addPageIndex(imageRef, this.pageIndex);

                    if (cacheGlobally) {
                      this.globalImageCache.setData(imageRef, {
                        objId: objId,
                        fn: _util.OPS.paintImageXObject,
                        args: args,
                        byteSize: 0
                      });
                    }
                  }
                }

                return _context3.abrupt("return", undefined);

              case 41:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function buildPaintImageXObject(_x9) {
        return _buildPaintImageXObject.apply(this, arguments);
      }

      return buildPaintImageXObject;
    }()
  }, {
    key: "handleSMask",
    value: function handleSMask(smask, resources, operatorList, task, stateManager, localColorSpaceCache) {
      var smaskContent = smask.get("G");
      var smaskOptions = {
        subtype: smask.get("S").name,
        backdrop: smask.get("BC")
      };
      var transferObj = smask.get("TR");

      if ((0, _function.isPDFFunction)(transferObj)) {
        var transferFn = this._pdfFunctionFactory.create(transferObj);

        var transferMap = new Uint8Array(256);
        var tmp = new Float32Array(1);

        for (var i = 0; i < 256; i++) {
          tmp[0] = i / 255;
          transferFn(tmp, 0, tmp, 0);
          transferMap[i] = tmp[0] * 255 | 0;
        }

        smaskOptions.transferMap = transferMap;
      }

      return this.buildFormXObject(resources, smaskContent, smaskOptions, operatorList, task, stateManager.state.clone(), localColorSpaceCache);
    }
  }, {
    key: "handleTransferFunction",
    value: function handleTransferFunction(tr) {
      var transferArray;

      if (Array.isArray(tr)) {
        transferArray = tr;
      } else if ((0, _function.isPDFFunction)(tr)) {
        transferArray = [tr];
      } else {
        return null;
      }

      var transferMaps = [];
      var numFns = 0,
          numEffectfulFns = 0;

      var _iterator4 = _createForOfIteratorHelper(transferArray),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var entry = _step4.value;
          var transferObj = this.xref.fetchIfRef(entry);
          numFns++;

          if ((0, _primitives.isName)(transferObj, "Identity")) {
            transferMaps.push(null);
            continue;
          } else if (!(0, _function.isPDFFunction)(transferObj)) {
            return null;
          }

          var transferFn = this._pdfFunctionFactory.create(transferObj);

          var transferMap = new Uint8Array(256),
              tmp = new Float32Array(1);

          for (var j = 0; j < 256; j++) {
            tmp[0] = j / 255;
            transferFn(tmp, 0, tmp, 0);
            transferMap[j] = tmp[0] * 255 | 0;
          }

          transferMaps.push(transferMap);
          numEffectfulFns++;
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      if (!(numFns === 1 || numFns === 4)) {
        return null;
      }

      if (numEffectfulFns === 0) {
        return null;
      }

      return transferMaps;
    }
  }, {
    key: "handleTilingType",
    value: function handleTilingType(fn, color, resources, pattern, patternDict, operatorList, task, cacheKey, localTilingPatternCache) {
      var _this2 = this;

      var tilingOpList = new _operator_list.OperatorList();

      var patternResources = _primitives.Dict.merge({
        xref: this.xref,
        dictArray: [patternDict.get("Resources"), resources]
      });

      return this.getOperatorList({
        stream: pattern,
        task: task,
        resources: patternResources,
        operatorList: tilingOpList
      }).then(function () {
        var operatorListIR = tilingOpList.getIR();
        var tilingPatternIR = (0, _pattern.getTilingPatternIR)(operatorListIR, patternDict, color);
        operatorList.addDependencies(tilingOpList.dependencies);
        operatorList.addOp(fn, tilingPatternIR);

        if (cacheKey) {
          localTilingPatternCache.set(cacheKey, patternDict.objId, {
            operatorListIR: operatorListIR,
            dict: patternDict
          });
        }
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this2.options.ignoreErrors) {
          _this2.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorTilingPattern
          });

          (0, _util.warn)("handleTilingType - ignoring pattern: \"".concat(reason, "\"."));
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "handleSetFont",
    value: function handleSetFont(resources, fontArgs, fontRef, operatorList, task, state) {
      var _this3 = this;

      var fallbackFontDict = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
      var cssFontInfo = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : null;
      var fontName = fontArgs && fontArgs[0] instanceof _primitives.Name ? fontArgs[0].name : null;
      return this.loadFont(fontName, fontRef, resources, fallbackFontDict, cssFontInfo).then(function (translated) {
        if (!translated.font.isType3Font) {
          return translated;
        }

        return translated.loadType3Data(_this3, resources, task).then(function () {
          operatorList.addDependencies(translated.type3Dependencies);
          return translated;
        })["catch"](function (reason) {
          _this3.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorFontLoadType3
          });

          return new TranslatedFont({
            loadedName: "g_font_error",
            font: new _fonts.ErrorFont("Type3 font load error: ".concat(reason)),
            dict: translated.font,
            evaluatorOptions: _this3.options
          });
        });
      }).then(function (translated) {
        state.font = translated.font;
        translated.send(_this3.handler);
        return translated.loadedName;
      });
    }
  }, {
    key: "handleText",
    value: function handleText(chars, state) {
      var font = state.font;
      var glyphs = font.charsToGlyphs(chars);

      if (font.data) {
        var isAddToPathSet = !!(state.textRenderingMode & _util.TextRenderingMode.ADD_TO_PATH_FLAG);

        if (isAddToPathSet || state.fillColorSpace.name === "Pattern" || font.disableFontFace || this.options.disableFontFace) {
          PartialEvaluator.buildFontPaths(font, glyphs, this.handler, this.options);
        }
      }

      return glyphs;
    }
  }, {
    key: "ensureStateFont",
    value: function ensureStateFont(state) {
      if (state.font) {
        return;
      }

      var reason = new _util.FormatError("Missing setFont (Tf) operator before text rendering operator.");

      if (this.options.ignoreErrors) {
        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontState
        });
        (0, _util.warn)("ensureStateFont: \"".concat(reason, "\"."));
        return;
      }

      throw reason;
    }
  }, {
    key: "setGState",
    value: function () {
      var _setGState = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(_ref4) {
        var _this4 = this;

        var resources, gState, operatorList, cacheKey, task, stateManager, localGStateCache, localColorSpaceCache, gStateRef, isSimpleGState, gStateObj, gStateKeys, promise, _loop, i, ii;

        return _regenerator["default"].wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                resources = _ref4.resources, gState = _ref4.gState, operatorList = _ref4.operatorList, cacheKey = _ref4.cacheKey, task = _ref4.task, stateManager = _ref4.stateManager, localGStateCache = _ref4.localGStateCache, localColorSpaceCache = _ref4.localColorSpaceCache;
                gStateRef = gState.objId;
                isSimpleGState = true;
                gStateObj = [];
                gStateKeys = gState.getKeys();
                promise = Promise.resolve();

                _loop = function _loop(i, ii) {
                  var key = gStateKeys[i];
                  var value = gState.get(key);

                  switch (key) {
                    case "Type":
                      break;

                    case "LW":
                    case "LC":
                    case "LJ":
                    case "ML":
                    case "D":
                    case "RI":
                    case "FL":
                    case "CA":
                    case "ca":
                      gStateObj.push([key, value]);
                      break;

                    case "Font":
                      isSimpleGState = false;
                      promise = promise.then(function () {
                        return _this4.handleSetFont(resources, null, value[0], operatorList, task, stateManager.state).then(function (loadedName) {
                          operatorList.addDependency(loadedName);
                          gStateObj.push([key, [loadedName, value[1]]]);
                        });
                      });
                      break;

                    case "BM":
                      gStateObj.push([key, normalizeBlendMode(value)]);
                      break;

                    case "SMask":
                      if ((0, _primitives.isName)(value, "None")) {
                        gStateObj.push([key, false]);
                        break;
                      }

                      if ((0, _primitives.isDict)(value)) {
                        isSimpleGState = false;
                        promise = promise.then(function () {
                          return _this4.handleSMask(value, resources, operatorList, task, stateManager, localColorSpaceCache);
                        });
                        gStateObj.push([key, true]);
                      } else {
                        (0, _util.warn)("Unsupported SMask type");
                      }

                      break;

                    case "TR":
                      var transferMaps = _this4.handleTransferFunction(value);

                      gStateObj.push([key, transferMaps]);
                      break;

                    case "OP":
                    case "op":
                    case "OPM":
                    case "BG":
                    case "BG2":
                    case "UCR":
                    case "UCR2":
                    case "TR2":
                    case "HT":
                    case "SM":
                    case "SA":
                    case "AIS":
                    case "TK":
                      (0, _util.info)("graphic state operator " + key);
                      break;

                    default:
                      (0, _util.info)("Unknown graphic state operator " + key);
                      break;
                  }
                };

                for (i = 0, ii = gStateKeys.length; i < ii; i++) {
                  _loop(i, ii);
                }

                return _context4.abrupt("return", promise.then(function () {
                  if (gStateObj.length > 0) {
                    operatorList.addOp(_util.OPS.setGState, [gStateObj]);
                  }

                  if (isSimpleGState) {
                    localGStateCache.set(cacheKey, gStateRef, gStateObj);
                  }
                }));

              case 9:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));

      function setGState(_x10) {
        return _setGState.apply(this, arguments);
      }

      return setGState;
    }()
  }, {
    key: "loadFont",
    value: function loadFont(fontName, font, resources) {
      var _this5 = this;

      var fallbackFontDict = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      var cssFontInfo = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

      var errorFont = /*#__PURE__*/function () {
        var _ref5 = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5() {
          return _regenerator["default"].wrap(function _callee5$(_context5) {
            while (1) {
              switch (_context5.prev = _context5.next) {
                case 0:
                  return _context5.abrupt("return", new TranslatedFont({
                    loadedName: "g_font_error",
                    font: new _fonts.ErrorFont("Font \"".concat(fontName, "\" is not available.")),
                    dict: font,
                    evaluatorOptions: _this5.options
                  }));

                case 1:
                case "end":
                  return _context5.stop();
              }
            }
          }, _callee5);
        }));

        return function errorFont() {
          return _ref5.apply(this, arguments);
        };
      }();

      var xref = this.xref;
      var fontRef;

      if (font) {
        if (!(0, _primitives.isRef)(font)) {
          throw new _util.FormatError('The "font" object should be a reference.');
        }

        fontRef = font;
      } else {
        var fontRes = resources.get("Font");

        if (fontRes) {
          fontRef = fontRes.getRaw(fontName);
        }
      }

      if (!fontRef) {
        var partialMsg = "Font \"".concat(fontName || font && font.toString(), "\" is not available");

        if (!this.options.ignoreErrors && !this.parsingType3Font) {
          (0, _util.warn)("".concat(partialMsg, "."));
          return errorFont();
        }

        this.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontMissing
        });
        (0, _util.warn)("".concat(partialMsg, " -- attempting to fallback to a default font."));

        if (fallbackFontDict) {
          fontRef = fallbackFontDict;
        } else {
          fontRef = PartialEvaluator.fallbackFontDict;
        }
      }

      if (this.fontCache.has(fontRef)) {
        return this.fontCache.get(fontRef);
      }

      font = xref.fetchIfRef(fontRef);

      if (!(0, _primitives.isDict)(font)) {
        return errorFont();
      }

      if (font.cacheKey && this.fontCache.has(font.cacheKey)) {
        return this.fontCache.get(font.cacheKey);
      }

      var fontCapability = (0, _util.createPromiseCapability)();
      var preEvaluatedFont;

      try {
        preEvaluatedFont = this.preEvaluateFont(font);
        preEvaluatedFont.cssFontInfo = cssFontInfo;
      } catch (reason) {
        (0, _util.warn)("loadFont - preEvaluateFont failed: \"".concat(reason, "\"."));
        return errorFont();
      }

      var _preEvaluatedFont = preEvaluatedFont,
          descriptor = _preEvaluatedFont.descriptor,
          hash = _preEvaluatedFont.hash;
      var fontRefIsRef = (0, _primitives.isRef)(fontRef);
      var fontID;

      if (fontRefIsRef) {
        fontID = "f".concat(fontRef.toString());
      }

      if (hash && (0, _primitives.isDict)(descriptor)) {
        if (!descriptor.fontAliases) {
          descriptor.fontAliases = Object.create(null);
        }

        var fontAliases = descriptor.fontAliases;

        if (fontAliases[hash]) {
          var aliasFontRef = fontAliases[hash].aliasRef;

          if (fontRefIsRef && aliasFontRef && this.fontCache.has(aliasFontRef)) {
            this.fontCache.putAlias(fontRef, aliasFontRef);
            return this.fontCache.get(fontRef);
          }
        } else {
          fontAliases[hash] = {
            fontID: this.idFactory.createFontId()
          };
        }

        if (fontRefIsRef) {
          fontAliases[hash].aliasRef = fontRef;
        }

        fontID = fontAliases[hash].fontID;
      }

      if (fontRefIsRef) {
        this.fontCache.put(fontRef, fontCapability.promise);
      } else {
        if (!fontID) {
          fontID = this.idFactory.createFontId();
        }

        font.cacheKey = "cacheKey_".concat(fontID);
        this.fontCache.put(font.cacheKey, fontCapability.promise);
      }

      (0, _util.assert)(fontID && fontID.startsWith("f"), 'The "fontID" must be (correctly) defined.');
      font.loadedName = "".concat(this.idFactory.getDocId(), "_").concat(fontID);
      this.translateFont(preEvaluatedFont).then(function (translatedFont) {
        if (translatedFont.fontType !== undefined) {
          var xrefFontStats = xref.stats.fontTypes;
          xrefFontStats[translatedFont.fontType] = true;
        }

        fontCapability.resolve(new TranslatedFont({
          loadedName: font.loadedName,
          font: translatedFont,
          dict: font,
          evaluatorOptions: _this5.options
        }));
      })["catch"](function (reason) {
        _this5.handler.send("UnsupportedFeature", {
          featureId: _util.UNSUPPORTED_FEATURES.errorFontTranslate
        });

        (0, _util.warn)("loadFont - translateFont failed: \"".concat(reason, "\"."));

        try {
          var fontFile3 = descriptor && descriptor.get("FontFile3");
          var subtype = fontFile3 && fontFile3.get("Subtype");
          var fontType = (0, _fonts_utils.getFontType)(preEvaluatedFont.type, subtype && subtype.name);
          var xrefFontStats = xref.stats.fontTypes;
          xrefFontStats[fontType] = true;
        } catch (ex) {}

        fontCapability.resolve(new TranslatedFont({
          loadedName: font.loadedName,
          font: new _fonts.ErrorFont(reason instanceof Error ? reason.message : reason),
          dict: font,
          evaluatorOptions: _this5.options
        }));
      });
      return fontCapability.promise;
    }
  }, {
    key: "buildPath",
    value: function buildPath(operatorList, fn, args) {
      var parsingText = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      var lastIndex = operatorList.length - 1;

      if (!args) {
        args = [];
      }

      if (lastIndex < 0 || operatorList.fnArray[lastIndex] !== _util.OPS.constructPath) {
        if (parsingText) {
          (0, _util.warn)("Encountered path operator \"".concat(fn, "\" inside of a text object."));
          operatorList.addOp(_util.OPS.save, null);
        }

        operatorList.addOp(_util.OPS.constructPath, [[fn], args]);

        if (parsingText) {
          operatorList.addOp(_util.OPS.restore, null);
        }
      } else {
        var opArgs = operatorList.argsArray[lastIndex];
        opArgs[0].push(fn);
        Array.prototype.push.apply(opArgs[1], args);
      }
    }
  }, {
    key: "parseColorSpace",
    value: function parseColorSpace(_ref6) {
      var _this6 = this;

      var cs = _ref6.cs,
          resources = _ref6.resources,
          localColorSpaceCache = _ref6.localColorSpaceCache;
      return _colorspace.ColorSpace.parseAsync({
        cs: cs,
        xref: this.xref,
        resources: resources,
        pdfFunctionFactory: this._pdfFunctionFactory,
        localColorSpaceCache: localColorSpaceCache
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return null;
        }

        if (_this6.options.ignoreErrors) {
          _this6.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorColorSpace
          });

          (0, _util.warn)("parseColorSpace - ignoring ColorSpace: \"".concat(reason, "\"."));
          return null;
        }

        throw reason;
      });
    }
  }, {
    key: "handleColorN",
    value: function handleColorN(operatorList, fn, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache) {
      var patternName = args.pop();

      if (patternName instanceof _primitives.Name) {
        var name = patternName.name;
        var localTilingPattern = localTilingPatternCache.getByName(name);

        if (localTilingPattern) {
          try {
            var color = cs.base ? cs.base.getRgb(args, 0) : null;
            var tilingPatternIR = (0, _pattern.getTilingPatternIR)(localTilingPattern.operatorListIR, localTilingPattern.dict, color);
            operatorList.addOp(fn, tilingPatternIR);
            return undefined;
          } catch (ex) {}
        }

        var pattern = patterns.get(name);

        if (pattern) {
          var dict = (0, _primitives.isStream)(pattern) ? pattern.dict : pattern;
          var typeNum = dict.get("PatternType");

          if (typeNum === PatternType.TILING) {
            var _color = cs.base ? cs.base.getRgb(args, 0) : null;

            return this.handleTilingType(fn, _color, resources, pattern, dict, operatorList, task, name, localTilingPatternCache);
          } else if (typeNum === PatternType.SHADING) {
            var shading = dict.get("Shading");
            var matrix = dict.getArray("Matrix");
            pattern = _pattern.Pattern.parseShading(shading, matrix, this.xref, resources, this.handler, this._pdfFunctionFactory, localColorSpaceCache);
            operatorList.addOp(fn, pattern.getIR());
            return undefined;
          }

          throw new _util.FormatError("Unknown PatternType: ".concat(typeNum));
        }
      }

      throw new _util.FormatError("Unknown PatternName: ".concat(patternName));
    }
  }, {
    key: "_parseVisibilityExpression",
    value: function _parseVisibilityExpression(array, nestingCounter, currentResult) {
      var MAX_NESTING = 10;

      if (++nestingCounter > MAX_NESTING) {
        (0, _util.warn)("Visibility expression is too deeply nested");
        return;
      }

      var length = array.length;
      var operator = this.xref.fetchIfRef(array[0]);

      if (length < 2 || !(0, _primitives.isName)(operator)) {
        (0, _util.warn)("Invalid visibility expression");
        return;
      }

      switch (operator.name) {
        case "And":
        case "Or":
        case "Not":
          currentResult.push(operator.name);
          break;

        default:
          (0, _util.warn)("Invalid operator ".concat(operator.name, " in visibility expression"));
          return;
      }

      for (var i = 1; i < length; i++) {
        var raw = array[i];
        var object = this.xref.fetchIfRef(raw);

        if (Array.isArray(object)) {
          var nestedResult = [];
          currentResult.push(nestedResult);

          this._parseVisibilityExpression(object, nestingCounter, nestedResult);
        } else if ((0, _primitives.isRef)(raw)) {
          currentResult.push(raw.toString());
        }
      }
    }
  }, {
    key: "parseMarkedContentProps",
    value: function () {
      var _parseMarkedContentProps = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee6(contentProperties, resources) {
        var optionalContent, properties, optionalContentType, expression, result, optionalContentGroups, groupIds, _iterator5, _step5, ocg;

        return _regenerator["default"].wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                if (!(0, _primitives.isName)(contentProperties)) {
                  _context6.next = 5;
                  break;
                }

                properties = resources.get("Properties");
                optionalContent = properties.get(contentProperties.name);
                _context6.next = 10;
                break;

              case 5:
                if (!(0, _primitives.isDict)(contentProperties)) {
                  _context6.next = 9;
                  break;
                }

                optionalContent = contentProperties;
                _context6.next = 10;
                break;

              case 9:
                throw new _util.FormatError("Optional content properties malformed.");

              case 10:
                optionalContentType = optionalContent.get("Type").name;

                if (!(optionalContentType === "OCG")) {
                  _context6.next = 15;
                  break;
                }

                return _context6.abrupt("return", {
                  type: optionalContentType,
                  id: optionalContent.objId
                });

              case 15:
                if (!(optionalContentType === "OCMD")) {
                  _context6.next = 31;
                  break;
                }

                expression = optionalContent.get("VE");

                if (!Array.isArray(expression)) {
                  _context6.next = 22;
                  break;
                }

                result = [];

                this._parseVisibilityExpression(expression, 0, result);

                if (!(result.length > 0)) {
                  _context6.next = 22;
                  break;
                }

                return _context6.abrupt("return", {
                  type: "OCMD",
                  expression: result
                });

              case 22:
                optionalContentGroups = optionalContent.get("OCGs");

                if (!(Array.isArray(optionalContentGroups) || (0, _primitives.isDict)(optionalContentGroups))) {
                  _context6.next = 29;
                  break;
                }

                groupIds = [];

                if (Array.isArray(optionalContentGroups)) {
                  _iterator5 = _createForOfIteratorHelper(optionalContentGroups);

                  try {
                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                      ocg = _step5.value;
                      groupIds.push(ocg.toString());
                    }
                  } catch (err) {
                    _iterator5.e(err);
                  } finally {
                    _iterator5.f();
                  }
                } else {
                  groupIds.push(optionalContentGroups.objId);
                }

                return _context6.abrupt("return", {
                  type: optionalContentType,
                  ids: groupIds,
                  policy: (0, _primitives.isName)(optionalContent.get("P")) ? optionalContent.get("P").name : null,
                  expression: null
                });

              case 29:
                if (!(0, _primitives.isRef)(optionalContentGroups)) {
                  _context6.next = 31;
                  break;
                }

                return _context6.abrupt("return", {
                  type: optionalContentType,
                  id: optionalContentGroups.toString()
                });

              case 31:
                return _context6.abrupt("return", null);

              case 32:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function parseMarkedContentProps(_x11, _x12) {
        return _parseMarkedContentProps.apply(this, arguments);
      }

      return parseMarkedContentProps;
    }()
  }, {
    key: "getOperatorList",
    value: function getOperatorList(_ref7) {
      var _this7 = this;

      var stream = _ref7.stream,
          task = _ref7.task,
          resources = _ref7.resources,
          operatorList = _ref7.operatorList,
          _ref7$initialState = _ref7.initialState,
          initialState = _ref7$initialState === void 0 ? null : _ref7$initialState,
          _ref7$fallbackFontDic = _ref7.fallbackFontDict,
          fallbackFontDict = _ref7$fallbackFontDic === void 0 ? null : _ref7$fallbackFontDic;
      resources = resources || _primitives.Dict.empty;
      initialState = initialState || new EvalState();

      if (!operatorList) {
        throw new Error('getOperatorList: missing "operatorList" parameter');
      }

      var self = this;
      var xref = this.xref;
      var parsingText = false;
      var localImageCache = new _image_utils.LocalImageCache();
      var localColorSpaceCache = new _image_utils.LocalColorSpaceCache();
      var localGStateCache = new _image_utils.LocalGStateCache();
      var localTilingPatternCache = new _image_utils.LocalTilingPatternCache();

      var xobjs = resources.get("XObject") || _primitives.Dict.empty;

      var patterns = resources.get("Pattern") || _primitives.Dict.empty;

      var stateManager = new StateManager(initialState);
      var preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
      var timeSlotManager = new TimeSlotManager();

      function closePendingRestoreOPS(argument) {
        for (var i = 0, ii = preprocessor.savedStatesDepth; i < ii; i++) {
          operatorList.addOp(_util.OPS.restore, []);
        }
      }

      return new Promise(function promiseBody(resolve, reject) {
        var next = function next(promise) {
          Promise.all([promise, operatorList.ready]).then(function () {
            try {
              promiseBody(resolve, reject);
            } catch (ex) {
              reject(ex);
            }
          }, reject);
        };

        task.ensureNotTerminated();
        timeSlotManager.reset();
        var operation = {};
        var stop, i, ii, cs, name;

        while (!(stop = timeSlotManager.check())) {
          operation.args = null;

          if (!preprocessor.read(operation)) {
            break;
          }

          var args = operation.args;
          var fn = operation.fn;

          switch (fn | 0) {
            case _util.OPS.paintXObject:
              name = args[0].name;

              if (name) {
                var localImage = localImageCache.getByName(name);

                if (localImage) {
                  operatorList.addOp(localImage.fn, localImage.args);
                  args = null;
                  continue;
                }
              }

              next(new Promise(function (resolveXObject, rejectXObject) {
                if (!name) {
                  throw new _util.FormatError("XObject must be referred to by name.");
                }

                var xobj = xobjs.getRaw(name);

                if (xobj instanceof _primitives.Ref) {
                  var _localImage = localImageCache.getByRef(xobj);

                  if (_localImage) {
                    operatorList.addOp(_localImage.fn, _localImage.args);
                    resolveXObject();
                    return;
                  }

                  var globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                  if (globalImage) {
                    operatorList.addDependency(globalImage.objId);
                    operatorList.addOp(globalImage.fn, globalImage.args);
                    resolveXObject();
                    return;
                  }

                  xobj = xref.fetch(xobj);
                }

                if (!(0, _primitives.isStream)(xobj)) {
                  throw new _util.FormatError("XObject should be a stream");
                }

                var type = xobj.dict.get("Subtype");

                if (!(0, _primitives.isName)(type)) {
                  throw new _util.FormatError("XObject should have a Name subtype");
                }

                if (type.name === "Form") {
                  stateManager.save();
                  self.buildFormXObject(resources, xobj, null, operatorList, task, stateManager.state.clone(), localColorSpaceCache).then(function () {
                    stateManager.restore();
                    resolveXObject();
                  }, rejectXObject);
                  return;
                } else if (type.name === "Image") {
                  self.buildPaintImageXObject({
                    resources: resources,
                    image: xobj,
                    operatorList: operatorList,
                    cacheKey: name,
                    localImageCache: localImageCache,
                    localColorSpaceCache: localColorSpaceCache
                  }).then(resolveXObject, rejectXObject);
                  return;
                } else if (type.name === "PS") {
                  (0, _util.info)("Ignored XObject subtype PS");
                } else {
                  throw new _util.FormatError("Unhandled XObject subtype ".concat(type.name));
                }

                resolveXObject();
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  self.handler.send("UnsupportedFeature", {
                    featureId: _util.UNSUPPORTED_FEATURES.errorXObject
                  });
                  (0, _util.warn)("getOperatorList - ignoring XObject: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.setFont:
              var fontSize = args[1];
              next(self.handleSetFont(resources, args, null, operatorList, task, stateManager.state, fallbackFontDict).then(function (loadedName) {
                operatorList.addDependency(loadedName);
                operatorList.addOp(_util.OPS.setFont, [loadedName, fontSize]);
              }));
              return;

            case _util.OPS.beginText:
              parsingText = true;
              break;

            case _util.OPS.endText:
              parsingText = false;
              break;

            case _util.OPS.endInlineImage:
              var cacheKey = args[0].cacheKey;

              if (cacheKey) {
                var _localImage2 = localImageCache.getByName(cacheKey);

                if (_localImage2) {
                  operatorList.addOp(_localImage2.fn, _localImage2.args);
                  args = null;
                  continue;
                }
              }

              next(self.buildPaintImageXObject({
                resources: resources,
                image: args[0],
                isInline: true,
                operatorList: operatorList,
                cacheKey: cacheKey,
                localImageCache: localImageCache,
                localColorSpaceCache: localColorSpaceCache
              }));
              return;

            case _util.OPS.showText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              args[0] = self.handleText(args[0], stateManager.state);
              break;

            case _util.OPS.showSpacedText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              var arr = args[0];
              var combinedGlyphs = [];
              var arrLength = arr.length;
              var state = stateManager.state;

              for (i = 0; i < arrLength; ++i) {
                var arrItem = arr[i];

                if ((0, _util.isString)(arrItem)) {
                  Array.prototype.push.apply(combinedGlyphs, self.handleText(arrItem, state));
                } else if ((0, _util.isNum)(arrItem)) {
                  combinedGlyphs.push(arrItem);
                }
              }

              args[0] = combinedGlyphs;
              fn = _util.OPS.showText;
              break;

            case _util.OPS.nextLineShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              operatorList.addOp(_util.OPS.nextLine);
              args[0] = self.handleText(args[0], stateManager.state);
              fn = _util.OPS.showText;
              break;

            case _util.OPS.nextLineSetSpacingShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              operatorList.addOp(_util.OPS.nextLine);
              operatorList.addOp(_util.OPS.setWordSpacing, [args.shift()]);
              operatorList.addOp(_util.OPS.setCharSpacing, [args.shift()]);
              args[0] = self.handleText(args[0], stateManager.state);
              fn = _util.OPS.showText;
              break;

            case _util.OPS.setTextRenderingMode:
              stateManager.state.textRenderingMode = args[0];
              break;

            case _util.OPS.setFillColorSpace:
              {
                var cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

                if (cachedColorSpace) {
                  stateManager.state.fillColorSpace = cachedColorSpace;
                  continue;
                }

                next(self.parseColorSpace({
                  cs: args[0],
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (colorSpace) {
                  if (colorSpace) {
                    stateManager.state.fillColorSpace = colorSpace;
                  }
                }));
                return;
              }

            case _util.OPS.setStrokeColorSpace:
              {
                var _cachedColorSpace = _colorspace.ColorSpace.getCached(args[0], xref, localColorSpaceCache);

                if (_cachedColorSpace) {
                  stateManager.state.strokeColorSpace = _cachedColorSpace;
                  continue;
                }

                next(self.parseColorSpace({
                  cs: args[0],
                  resources: resources,
                  localColorSpaceCache: localColorSpaceCache
                }).then(function (colorSpace) {
                  if (colorSpace) {
                    stateManager.state.strokeColorSpace = colorSpace;
                  }
                }));
                return;
              }

            case _util.OPS.setFillColor:
              cs = stateManager.state.fillColorSpace;
              args = cs.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeColor:
              cs = stateManager.state.strokeColorSpace;
              args = cs.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillGray:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.gray;
              args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeGray:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.gray;
              args = _colorspace.ColorSpace.singletons.gray.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillCMYKColor:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.cmyk;
              args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeCMYKColor:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.cmyk;
              args = _colorspace.ColorSpace.singletons.cmyk.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.setFillRGBColor:
              stateManager.state.fillColorSpace = _colorspace.ColorSpace.singletons.rgb;
              args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
              break;

            case _util.OPS.setStrokeRGBColor:
              stateManager.state.strokeColorSpace = _colorspace.ColorSpace.singletons.rgb;
              args = _colorspace.ColorSpace.singletons.rgb.getRgb(args, 0);
              break;

            case _util.OPS.setFillColorN:
              cs = stateManager.state.fillColorSpace;

              if (cs.name === "Pattern") {
                next(self.handleColorN(operatorList, _util.OPS.setFillColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache));
                return;
              }

              args = cs.getRgb(args, 0);
              fn = _util.OPS.setFillRGBColor;
              break;

            case _util.OPS.setStrokeColorN:
              cs = stateManager.state.strokeColorSpace;

              if (cs.name === "Pattern") {
                next(self.handleColorN(operatorList, _util.OPS.setStrokeColorN, args, cs, patterns, resources, task, localColorSpaceCache, localTilingPatternCache));
                return;
              }

              args = cs.getRgb(args, 0);
              fn = _util.OPS.setStrokeRGBColor;
              break;

            case _util.OPS.shadingFill:
              var shadingRes = resources.get("Shading");

              if (!shadingRes) {
                throw new _util.FormatError("No shading resource found");
              }

              var shading = shadingRes.get(args[0].name);

              if (!shading) {
                throw new _util.FormatError("No shading object found");
              }

              var shadingFill = _pattern.Pattern.parseShading(shading, null, xref, resources, self.handler, self._pdfFunctionFactory, localColorSpaceCache);

              var patternIR = shadingFill.getIR();
              args = [patternIR];
              fn = _util.OPS.shadingFill;
              break;

            case _util.OPS.setGState:
              name = args[0].name;

              if (name) {
                var localGStateObj = localGStateCache.getByName(name);

                if (localGStateObj) {
                  if (localGStateObj.length > 0) {
                    operatorList.addOp(_util.OPS.setGState, [localGStateObj]);
                  }

                  args = null;
                  continue;
                }
              }

              next(new Promise(function (resolveGState, rejectGState) {
                if (!name) {
                  throw new _util.FormatError("GState must be referred to by name.");
                }

                var extGState = resources.get("ExtGState");

                if (!(extGState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("ExtGState should be a dictionary.");
                }

                var gState = extGState.get(name);

                if (!(gState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("GState should be a dictionary.");
                }

                self.setGState({
                  resources: resources,
                  gState: gState,
                  operatorList: operatorList,
                  cacheKey: name,
                  task: task,
                  stateManager: stateManager,
                  localGStateCache: localGStateCache,
                  localColorSpaceCache: localColorSpaceCache
                }).then(resolveGState, rejectGState);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  self.handler.send("UnsupportedFeature", {
                    featureId: _util.UNSUPPORTED_FEATURES.errorExtGState
                  });
                  (0, _util.warn)("getOperatorList - ignoring ExtGState: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.moveTo:
            case _util.OPS.lineTo:
            case _util.OPS.curveTo:
            case _util.OPS.curveTo2:
            case _util.OPS.curveTo3:
            case _util.OPS.closePath:
            case _util.OPS.rectangle:
              self.buildPath(operatorList, fn, args, parsingText);
              continue;

            case _util.OPS.markPoint:
            case _util.OPS.markPointProps:
            case _util.OPS.beginCompat:
            case _util.OPS.endCompat:
              continue;

            case _util.OPS.beginMarkedContentProps:
              if (!(0, _primitives.isName)(args[0])) {
                (0, _util.warn)("Expected name for beginMarkedContentProps arg0=".concat(args[0]));
                continue;
              }

              if (args[0].name === "OC") {
                next(self.parseMarkedContentProps(args[1], resources).then(function (data) {
                  operatorList.addOp(_util.OPS.beginMarkedContentProps, ["OC", data]);
                })["catch"](function (reason) {
                  if (reason instanceof _util.AbortException) {
                    return;
                  }

                  if (self.options.ignoreErrors) {
                    self.handler.send("UnsupportedFeature", {
                      featureId: _util.UNSUPPORTED_FEATURES.errorMarkedContent
                    });
                    (0, _util.warn)("getOperatorList - ignoring beginMarkedContentProps: \"".concat(reason, "\"."));
                    return;
                  }

                  throw reason;
                }));
                return;
              }

              args = [args[0].name, args[1] instanceof _primitives.Dict ? args[1].get("MCID") : null];
              break;

            case _util.OPS.beginMarkedContent:
            case _util.OPS.endMarkedContent:
            default:
              if (args !== null) {
                for (i = 0, ii = args.length; i < ii; i++) {
                  if (args[i] instanceof _primitives.Dict) {
                    break;
                  }
                }

                if (i < ii) {
                  (0, _util.warn)("getOperatorList - ignoring operator: " + fn);
                  continue;
                }
              }

          }

          operatorList.addOp(fn, args);
        }

        if (stop) {
          next(deferred);
          return;
        }

        closePendingRestoreOPS();
        resolve();
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this7.options.ignoreErrors) {
          _this7.handler.send("UnsupportedFeature", {
            featureId: _util.UNSUPPORTED_FEATURES.errorOperatorList
          });

          (0, _util.warn)("getOperatorList - ignoring errors during \"".concat(task.name, "\" ") + "task: \"".concat(reason, "\"."));
          closePendingRestoreOPS();
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "getTextContent",
    value: function getTextContent(_ref8) {
      var _this8 = this;

      var stream = _ref8.stream,
          task = _ref8.task,
          resources = _ref8.resources,
          _ref8$stateManager = _ref8.stateManager,
          stateManager = _ref8$stateManager === void 0 ? null : _ref8$stateManager,
          _ref8$normalizeWhites = _ref8.normalizeWhitespace,
          normalizeWhitespace = _ref8$normalizeWhites === void 0 ? false : _ref8$normalizeWhites,
          _ref8$combineTextItem = _ref8.combineTextItems,
          combineTextItems = _ref8$combineTextItem === void 0 ? false : _ref8$combineTextItem,
          _ref8$includeMarkedCo = _ref8.includeMarkedContent,
          includeMarkedContent = _ref8$includeMarkedCo === void 0 ? false : _ref8$includeMarkedCo,
          sink = _ref8.sink,
          _ref8$seenStyles = _ref8.seenStyles,
          seenStyles = _ref8$seenStyles === void 0 ? new Set() : _ref8$seenStyles;
      resources = resources || _primitives.Dict.empty;
      stateManager = stateManager || new StateManager(new TextState());
      var WhitespaceRegexp = /\s/g;
      var textContent = {
        items: [],
        styles: Object.create(null)
      };
      var textContentItem = {
        initialized: false,
        str: [],
        totalWidth: 0,
        totalHeight: 0,
        width: 0,
        height: 0,
        vertical: false,
        lastCharSize: 0,
        prevTransform: null,
        textAdvanceScale: 0,
        spaceWidth: 0,
        spaceInFlowMin: 0,
        spaceInFlowMax: 0,
        trackingSpaceMin: Infinity,
        transform: null,
        fontName: null,
        hasEOL: false,
        isLastCharWhiteSpace: false
      };
      var TRACKING_SPACE_FACTOR = 0.3;
      var SPACE_IN_FLOW_MIN_FACTOR = 0.3;
      var SPACE_IN_FLOW_MAX_FACTOR = 1.3;
      var self = this;
      var xref = this.xref;
      var showSpacedTextBuffer = [];
      var xobjs = null;
      var emptyXObjectCache = new _image_utils.LocalImageCache();
      var emptyGStateCache = new _image_utils.LocalGStateCache();
      var preprocessor = new EvaluatorPreprocessor(stream, xref, stateManager);
      var textState;

      function getCurrentTextTransform() {
        var font = textState.font;
        var tsm = [textState.fontSize * textState.textHScale, 0, 0, textState.fontSize, 0, textState.textRise];

        if (font.isType3Font && textState.fontSize <= 1 && !(0, _util.isArrayEqual)(textState.fontMatrix, _util.FONT_IDENTITY_MATRIX)) {
          var glyphHeight = font.bbox[3] - font.bbox[1];

          if (glyphHeight > 0) {
            tsm[3] *= glyphHeight * textState.fontMatrix[3];
          }
        }

        return _util.Util.transform(textState.ctm, _util.Util.transform(textState.textMatrix, tsm));
      }

      function ensureTextContentItem() {
        if (textContentItem.initialized) {
          return textContentItem;
        }

        var font = textState.font,
            loadedName = font.loadedName;

        if (!seenStyles.has(loadedName)) {
          seenStyles.add(loadedName);
          textContent.styles[loadedName] = {
            fontFamily: font.fallbackName,
            ascent: font.ascent,
            descent: font.descent,
            vertical: font.vertical
          };
        }

        textContentItem.fontName = loadedName;
        var trm = textContentItem.transform = getCurrentTextTransform();

        if (!font.vertical) {
          textContentItem.width = textContentItem.totalWidth = 0;
          textContentItem.height = textContentItem.totalHeight = Math.hypot(trm[2], trm[3]);
          textContentItem.vertical = false;
        } else {
          textContentItem.width = textContentItem.totalWidth = Math.hypot(trm[0], trm[1]);
          textContentItem.height = textContentItem.totalHeight = 0;
          textContentItem.vertical = true;
        }

        var scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
        var scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
        textContentItem.textAdvanceScale = scaleCtmX * scaleLineX;
        textContentItem.lastCharSize = textContentItem.lastCharSize || 0;
        var spaceWidth = font.spaceWidth / 1000 * textState.fontSize;

        if (spaceWidth) {
          textContentItem.spaceWidth = spaceWidth;
          textContentItem.trackingSpaceMin = spaceWidth * TRACKING_SPACE_FACTOR;
          textContentItem.spaceInFlowMin = spaceWidth * SPACE_IN_FLOW_MIN_FACTOR;
          textContentItem.spaceInFlowMax = spaceWidth * SPACE_IN_FLOW_MAX_FACTOR;
        } else {
          textContentItem.spaceWidth = 0;
          textContentItem.trackingSpaceMin = Infinity;
        }

        textContentItem.hasEOL = false;
        textContentItem.initialized = true;
        return textContentItem;
      }

      function updateAdvanceScale() {
        if (!textContentItem.initialized) {
          return;
        }

        var scaleLineX = Math.hypot(textState.textLineMatrix[0], textState.textLineMatrix[1]);
        var scaleCtmX = Math.hypot(textState.ctm[0], textState.ctm[1]);
        var scaleFactor = scaleCtmX * scaleLineX;

        if (scaleFactor === textContentItem.textAdvanceScale) {
          return;
        }

        if (!textContentItem.vertical) {
          textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
          textContentItem.width = 0;
        } else {
          textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
          textContentItem.height = 0;
        }

        textContentItem.textAdvanceScale = scaleFactor;
      }

      function replaceWhitespace(str) {
        var ii = str.length;
        var i = 0,
            code;

        while (i < ii && (code = str.charCodeAt(i)) >= 0x20 && code <= 0x7f) {
          i++;
        }

        return i < ii ? str.replace(WhitespaceRegexp, " ") : str;
      }

      function runBidiTransform(textChunk) {
        var text = textChunk.str.join("");
        var bidiResult = (0, _bidi.bidi)(text, -1, textChunk.vertical);
        var str = normalizeWhitespace ? replaceWhitespace(bidiResult.str) : bidiResult.str;
        return {
          str: str,
          dir: bidiResult.dir,
          width: textChunk.totalWidth,
          height: textChunk.totalHeight,
          transform: textChunk.transform,
          fontName: textChunk.fontName,
          hasEOL: textChunk.hasEOL
        };
      }

      function handleSetFont(fontName, fontRef) {
        return self.loadFont(fontName, fontRef, resources).then(function (translated) {
          textState.font = translated.font;
          textState.fontMatrix = translated.font.fontMatrix || _util.FONT_IDENTITY_MATRIX;
        });
      }

      function compareWithLastPosition(fontSize) {
        if (!combineTextItems || !textState.font || !textContentItem.prevTransform) {
          return;
        }

        var currentTransform = getCurrentTextTransform();
        var posX = currentTransform[4];
        var posY = currentTransform[5];
        var lastPosX = textContentItem.prevTransform[4];
        var lastPosY = textContentItem.prevTransform[5];

        if (lastPosX === posX && lastPosY === posY) {
          return;
        }

        var advanceX = (posX - lastPosX) / textContentItem.textAdvanceScale;
        var advanceY = (posY - lastPosY) / textContentItem.textAdvanceScale;
        var HALF_LAST_CHAR = -0.5 * textContentItem.lastCharSize;

        if (textState.font.vertical) {
          if (Math.abs(advanceX) > textContentItem.width / textContentItem.textAdvanceScale) {
            appendEOL();
            return;
          }

          if (HALF_LAST_CHAR > advanceY) {
            return;
          }

          if (advanceY > textContentItem.trackingSpaceMin) {
            textContentItem.height += advanceY;
          } else if (!addFakeSpaces(advanceY, 0, textContentItem.prevTransform)) {
            if (textContentItem.str.length === 0) {
              textContent.items.push({
                str: " ",
                dir: "ltr",
                width: 0,
                height: advanceY,
                transform: textContentItem.prevTransform,
                fontName: textContentItem.fontName,
                hasEOL: false
              });
              textContentItem.isLastCharWhiteSpace = true;
            } else {
              textContentItem.height += advanceY;
            }
          }

          return;
        }

        if (Math.abs(advanceY) > textContentItem.height / textContentItem.textAdvanceScale) {
          appendEOL();
          return;
        }

        if (HALF_LAST_CHAR > advanceX) {
          return;
        }

        if (advanceX <= textContentItem.trackingSpaceMin) {
          textContentItem.width += advanceX;
        } else if (!addFakeSpaces(advanceX, 0, textContentItem.prevTransform)) {
          if (textContentItem.str.length === 0) {
            textContent.items.push({
              str: " ",
              dir: "ltr",
              width: advanceX,
              height: 0,
              transform: textContentItem.prevTransform,
              fontName: textContentItem.fontName,
              hasEOL: false
            });
            textContentItem.isLastCharWhiteSpace = true;
          } else {
            textContentItem.width += advanceX;
          }
        }
      }

      function buildTextContentItem(_ref9) {
        var chars = _ref9.chars,
            extraSpacing = _ref9.extraSpacing,
            isFirstChunk = _ref9.isFirstChunk;
        var font = textState.font;

        if (!chars) {
          var charSpacing = textState.charSpacing + extraSpacing;

          if (charSpacing) {
            if (!font.vertical) {
              textState.translateTextMatrix(charSpacing * textState.textHScale, 0);
            } else {
              textState.translateTextMatrix(0, charSpacing);
            }
          }

          return;
        }

        var NormalizedUnicodes = (0, _unicode.getNormalizedUnicodes)();
        var glyphs = font.charsToGlyphs(chars);
        var scale = textState.fontMatrix[0] * textState.fontSize;

        if (isFirstChunk) {
          compareWithLastPosition(scale);
        }

        var textChunk = ensureTextContentItem();
        var size = 0;
        var lastCharSize = 0;

        for (var i = 0, ii = glyphs.length; i < ii; i++) {
          var glyph = glyphs[i];

          var _charSpacing = textState.charSpacing + (i === ii - 1 ? extraSpacing : 0);

          var glyphUnicode = glyph.unicode;

          if (glyph.isSpace) {
            _charSpacing += textState.wordSpacing;
            textChunk.isLastCharWhiteSpace = true;
          } else {
            glyphUnicode = NormalizedUnicodes[glyphUnicode] || glyphUnicode;
            glyphUnicode = (0, _unicode.reverseIfRtl)(glyphUnicode);
            textChunk.isLastCharWhiteSpace = false;
          }

          textChunk.str.push(glyphUnicode);
          var glyphWidth = font.vertical && glyph.vmetric ? glyph.vmetric[0] : glyph.width;
          var scaledDim = glyphWidth * scale;

          if (!font.vertical) {
            scaledDim *= textState.textHScale;
            textState.translateTextMatrix(scaledDim, 0);
          } else {
            textState.translateTextMatrix(0, scaledDim);
            scaledDim = Math.abs(scaledDim);
          }

          size += scaledDim;

          if (_charSpacing) {
            if (!font.vertical) {
              _charSpacing *= textState.textHScale;
            }

            scaledDim += _charSpacing;
            var wasSplit = _charSpacing > textContentItem.trackingSpaceMin && addFakeSpaces(_charSpacing, size);

            if (!font.vertical) {
              textState.translateTextMatrix(_charSpacing, 0);
            } else {
              textState.translateTextMatrix(0, _charSpacing);
            }

            if (wasSplit) {
              textChunk = ensureTextContentItem();
              size = 0;
            } else {
              size += _charSpacing;
            }
          }

          lastCharSize = scaledDim;
        }

        textChunk.lastCharSize = lastCharSize;

        if (!font.vertical) {
          textChunk.width += size;
        } else {
          textChunk.height += size;
        }

        textChunk.prevTransform = getCurrentTextTransform();
      }

      function appendEOL() {
        if (textContentItem.initialized) {
          textContentItem.hasEOL = true;
          flushTextContentItem();
        } else if (textContent.items.length > 0) {
          textContent.items[textContent.items.length - 1].hasEOL = true;
        } else {
          textContent.items.push({
            str: "",
            dir: "ltr",
            width: 0,
            height: 0,
            transform: getCurrentTextTransform(),
            fontName: textState.font.loadedName,
            hasEOL: true
          });
        }

        textContentItem.isLastCharWhiteSpace = false;
        textContentItem.lastCharSize = 0;
      }

      function addFakeSpaces(width, size) {
        var transf = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

        if (textContentItem.spaceInFlowMin <= width && width <= textContentItem.spaceInFlowMax) {
          if (textContentItem.initialized) {
            textContentItem.str.push(" ");
            textContentItem.isLastCharWhiteSpace = true;
          }

          return false;
        }

        var fontName = textContentItem.fontName;
        var height = 0;
        width *= textContentItem.textAdvanceScale;

        if (!textContentItem.vertical) {
          textContentItem.width += size;
        } else {
          textContentItem.height += size;
          height = width;
          width = 0;
        }

        flushTextContentItem();

        if (textContentItem.isLastCharWhiteSpace) {
          return true;
        }

        textContentItem.isLastCharWhiteSpace = true;
        textContent.items.push({
          str: " ",
          dir: "ltr",
          width: width,
          height: height,
          transform: transf ? transf : getCurrentTextTransform(),
          fontName: fontName,
          hasEOL: false
        });
        return true;
      }

      function flushTextContentItem() {
        if (!textContentItem.initialized || !textContentItem.str) {
          return;
        }

        if (!textContentItem.vertical) {
          textContentItem.totalWidth += textContentItem.width * textContentItem.textAdvanceScale;
        } else {
          textContentItem.totalHeight += textContentItem.height * textContentItem.textAdvanceScale;
        }

        textContent.items.push(runBidiTransform(textContentItem));
        textContentItem.initialized = false;
        textContentItem.str.length = 0;
      }

      function enqueueChunk() {
        var length = textContent.items.length;

        if (length > 0) {
          sink.enqueue(textContent, length);
          textContent.items = [];
          textContent.styles = Object.create(null);
        }
      }

      var timeSlotManager = new TimeSlotManager();
      return new Promise(function promiseBody(resolve, reject) {
        var next = function next(promise) {
          enqueueChunk();
          Promise.all([promise, sink.ready]).then(function () {
            try {
              promiseBody(resolve, reject);
            } catch (ex) {
              reject(ex);
            }
          }, reject);
        };

        task.ensureNotTerminated();
        timeSlotManager.reset();
        var operation = {};
        var stop,
            args = [];

        while (!(stop = timeSlotManager.check())) {
          args.length = 0;
          operation.args = args;

          if (!preprocessor.read(operation)) {
            break;
          }

          textState = stateManager.state;
          var fn = operation.fn;
          args = operation.args;

          switch (fn | 0) {
            case _util.OPS.setFont:
              var fontNameArg = args[0].name,
                  fontSizeArg = args[1];

              if (textState.font && fontNameArg === textState.fontName && fontSizeArg === textState.fontSize) {
                break;
              }

              flushTextContentItem();
              textState.fontName = fontNameArg;
              textState.fontSize = fontSizeArg;
              next(handleSetFont(fontNameArg, null));
              return;

            case _util.OPS.setTextRise:
              flushTextContentItem();
              textState.textRise = args[0];
              break;

            case _util.OPS.setHScale:
              flushTextContentItem();
              textState.textHScale = args[0] / 100;
              break;

            case _util.OPS.setLeading:
              flushTextContentItem();
              textState.leading = args[0];
              break;

            case _util.OPS.moveText:
              textState.translateTextLineMatrix(args[0], args[1]);
              textState.textMatrix = textState.textLineMatrix.slice();
              break;

            case _util.OPS.setLeadingMoveText:
              flushTextContentItem();
              textState.leading = -args[1];
              textState.translateTextLineMatrix(args[0], args[1]);
              textState.textMatrix = textState.textLineMatrix.slice();
              break;

            case _util.OPS.nextLine:
              appendEOL();
              textState.carriageReturn();
              break;

            case _util.OPS.setTextMatrix:
              textState.setTextMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
              textState.setTextLineMatrix(args[0], args[1], args[2], args[3], args[4], args[5]);
              updateAdvanceScale();
              break;

            case _util.OPS.setCharSpacing:
              textState.charSpacing = args[0];
              break;

            case _util.OPS.setWordSpacing:
              textState.wordSpacing = args[0];
              break;

            case _util.OPS.beginText:
              flushTextContentItem();
              textState.textMatrix = _util.IDENTITY_MATRIX.slice();
              textState.textLineMatrix = _util.IDENTITY_MATRIX.slice();
              break;

            case _util.OPS.showSpacedText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              var spaceFactor = (textState.font.vertical ? 1 : -1) * textState.fontSize / 1000;
              var elements = args[0];
              var isFirstChunk = true;

              for (var i = 0, ii = elements.length; i < ii - 1; i++) {
                var _item = elements[i];

                if (typeof _item === "string") {
                  showSpacedTextBuffer.push(_item);
                } else if (typeof _item === "number" && _item !== 0) {
                  var str = showSpacedTextBuffer.join("");
                  showSpacedTextBuffer.length = 0;
                  buildTextContentItem({
                    chars: str,
                    extraSpacing: _item * spaceFactor,
                    isFirstChunk: isFirstChunk
                  });

                  if (str && isFirstChunk) {
                    isFirstChunk = false;
                  }
                }
              }

              var item = elements[elements.length - 1];

              if (typeof item === "string") {
                showSpacedTextBuffer.push(item);
              }

              if (showSpacedTextBuffer.length > 0) {
                var _str = showSpacedTextBuffer.join("");

                showSpacedTextBuffer.length = 0;
                buildTextContentItem({
                  chars: _str,
                  extraSpacing: 0,
                  isFirstChunk: isFirstChunk
                });
              }

              break;

            case _util.OPS.showText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              buildTextContentItem({
                chars: args[0],
                extraSpacing: 0,
                isFirstChunk: true
              });
              break;

            case _util.OPS.nextLineShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              textContentItem.hasEOL = true;
              flushTextContentItem();
              textState.carriageReturn();
              buildTextContentItem({
                chars: args[0],
                extraSpacing: 0,
                isFirstChunk: true
              });
              break;

            case _util.OPS.nextLineSetSpacingShowText:
              if (!stateManager.state.font) {
                self.ensureStateFont(stateManager.state);
                continue;
              }

              textContentItem.hasEOL = true;
              flushTextContentItem();
              textState.wordSpacing = args[0];
              textState.charSpacing = args[1];
              textState.carriageReturn();
              buildTextContentItem({
                chars: args[2],
                extraSpacing: 0,
                isFirstChunk: true
              });
              break;

            case _util.OPS.paintXObject:
              flushTextContentItem();

              if (!xobjs) {
                xobjs = resources.get("XObject") || _primitives.Dict.empty;
              }

              var name = args[0].name;

              if (name && emptyXObjectCache.getByName(name)) {
                break;
              }

              next(new Promise(function (resolveXObject, rejectXObject) {
                if (!name) {
                  throw new _util.FormatError("XObject must be referred to by name.");
                }

                var xobj = xobjs.getRaw(name);

                if (xobj instanceof _primitives.Ref) {
                  if (emptyXObjectCache.getByRef(xobj)) {
                    resolveXObject();
                    return;
                  }

                  var globalImage = self.globalImageCache.getData(xobj, self.pageIndex);

                  if (globalImage) {
                    resolveXObject();
                    return;
                  }

                  xobj = xref.fetch(xobj);
                }

                if (!(0, _primitives.isStream)(xobj)) {
                  throw new _util.FormatError("XObject should be a stream");
                }

                var type = xobj.dict.get("Subtype");

                if (!(0, _primitives.isName)(type)) {
                  throw new _util.FormatError("XObject should have a Name subtype");
                }

                if (type.name !== "Form") {
                  emptyXObjectCache.set(name, xobj.dict.objId, true);
                  resolveXObject();
                  return;
                }

                var currentState = stateManager.state.clone();
                var xObjStateManager = new StateManager(currentState);
                var matrix = xobj.dict.getArray("Matrix");

                if (Array.isArray(matrix) && matrix.length === 6) {
                  xObjStateManager.transform(matrix);
                }

                enqueueChunk();
                var sinkWrapper = {
                  enqueueInvoked: false,
                  enqueue: function enqueue(chunk, size) {
                    this.enqueueInvoked = true;
                    sink.enqueue(chunk, size);
                  },

                  get desiredSize() {
                    return sink.desiredSize;
                  },

                  get ready() {
                    return sink.ready;
                  }

                };
                self.getTextContent({
                  stream: xobj,
                  task: task,
                  resources: xobj.dict.get("Resources") || resources,
                  stateManager: xObjStateManager,
                  normalizeWhitespace: normalizeWhitespace,
                  combineTextItems: combineTextItems,
                  includeMarkedContent: includeMarkedContent,
                  sink: sinkWrapper,
                  seenStyles: seenStyles
                }).then(function () {
                  if (!sinkWrapper.enqueueInvoked) {
                    emptyXObjectCache.set(name, xobj.dict.objId, true);
                  }

                  resolveXObject();
                }, rejectXObject);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  (0, _util.warn)("getTextContent - ignoring XObject: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.setGState:
              name = args[0].name;

              if (name && emptyGStateCache.getByName(name)) {
                break;
              }

              next(new Promise(function (resolveGState, rejectGState) {
                if (!name) {
                  throw new _util.FormatError("GState must be referred to by name.");
                }

                var extGState = resources.get("ExtGState");

                if (!(extGState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("ExtGState should be a dictionary.");
                }

                var gState = extGState.get(name);

                if (!(gState instanceof _primitives.Dict)) {
                  throw new _util.FormatError("GState should be a dictionary.");
                }

                var gStateFont = gState.get("Font");

                if (!gStateFont) {
                  emptyGStateCache.set(name, gState.objId, true);
                  resolveGState();
                  return;
                }

                flushTextContentItem();
                textState.fontName = null;
                textState.fontSize = gStateFont[1];
                handleSetFont(null, gStateFont[0]).then(resolveGState, rejectGState);
              })["catch"](function (reason) {
                if (reason instanceof _util.AbortException) {
                  return;
                }

                if (self.options.ignoreErrors) {
                  (0, _util.warn)("getTextContent - ignoring ExtGState: \"".concat(reason, "\"."));
                  return;
                }

                throw reason;
              }));
              return;

            case _util.OPS.beginMarkedContent:
              if (includeMarkedContent) {
                textContent.items.push({
                  type: "beginMarkedContent",
                  tag: (0, _primitives.isName)(args[0]) ? args[0].name : null
                });
              }

              break;

            case _util.OPS.beginMarkedContentProps:
              if (includeMarkedContent) {
                flushTextContentItem();
                var mcid = null;

                if ((0, _primitives.isDict)(args[1])) {
                  mcid = args[1].get("MCID");
                }

                textContent.items.push({
                  type: "beginMarkedContentProps",
                  id: Number.isInteger(mcid) ? "".concat(self.idFactory.getPageObjId(), "_mcid").concat(mcid) : null,
                  tag: (0, _primitives.isName)(args[0]) ? args[0].name : null
                });
              }

              break;

            case _util.OPS.endMarkedContent:
              if (includeMarkedContent) {
                flushTextContentItem();
                textContent.items.push({
                  type: "endMarkedContent"
                });
              }

              break;
          }

          if (textContent.items.length >= sink.desiredSize) {
            stop = true;
            break;
          }
        }

        if (stop) {
          next(deferred);
          return;
        }

        flushTextContentItem();
        enqueueChunk();
        resolve();
      })["catch"](function (reason) {
        if (reason instanceof _util.AbortException) {
          return;
        }

        if (_this8.options.ignoreErrors) {
          (0, _util.warn)("getTextContent - ignoring errors during \"".concat(task.name, "\" ") + "task: \"".concat(reason, "\"."));
          flushTextContentItem();
          enqueueChunk();
          return;
        }

        throw reason;
      });
    }
  }, {
    key: "extractDataStructures",
    value: function extractDataStructures(dict, baseDict, properties) {
      var _this9 = this;

      var xref = this.xref;
      var cidToGidBytes;
      var toUnicodePromise = this.readToUnicode(properties.toUnicode || dict.get("ToUnicode") || baseDict.get("ToUnicode"));

      if (properties.composite) {
        var cidSystemInfo = dict.get("CIDSystemInfo");

        if ((0, _primitives.isDict)(cidSystemInfo)) {
          properties.cidSystemInfo = {
            registry: (0, _util.stringToPDFString)(cidSystemInfo.get("Registry")),
            ordering: (0, _util.stringToPDFString)(cidSystemInfo.get("Ordering")),
            supplement: cidSystemInfo.get("Supplement")
          };
        }

        var cidToGidMap = dict.get("CIDToGIDMap");

        if ((0, _primitives.isStream)(cidToGidMap)) {
          cidToGidBytes = cidToGidMap.getBytes();
        }
      }

      var differences = [];
      var baseEncodingName = null;
      var encoding;

      if (dict.has("Encoding")) {
        encoding = dict.get("Encoding");

        if ((0, _primitives.isDict)(encoding)) {
          baseEncodingName = encoding.get("BaseEncoding");
          baseEncodingName = (0, _primitives.isName)(baseEncodingName) ? baseEncodingName.name : null;

          if (encoding.has("Differences")) {
            var diffEncoding = encoding.get("Differences");
            var index = 0;

            for (var j = 0, jj = diffEncoding.length; j < jj; j++) {
              var data = xref.fetchIfRef(diffEncoding[j]);

              if ((0, _util.isNum)(data)) {
                index = data;
              } else if ((0, _primitives.isName)(data)) {
                differences[index++] = data.name;
              } else {
                throw new _util.FormatError("Invalid entry in 'Differences' array: ".concat(data));
              }
            }
          }
        } else if ((0, _primitives.isName)(encoding)) {
          baseEncodingName = encoding.name;
        } else {
          throw new _util.FormatError("Encoding is not a Name nor a Dict");
        }

        if (baseEncodingName !== "MacRomanEncoding" && baseEncodingName !== "MacExpertEncoding" && baseEncodingName !== "WinAnsiEncoding") {
          baseEncodingName = null;
        }
      }

      if (baseEncodingName) {
        properties.defaultEncoding = (0, _encodings.getEncoding)(baseEncodingName);
      } else {
        var isSymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Symbolic);
        var isNonsymbolicFont = !!(properties.flags & _fonts_utils.FontFlags.Nonsymbolic);
        encoding = _encodings.StandardEncoding;

        if (properties.type === "TrueType" && !isNonsymbolicFont) {
          encoding = _encodings.WinAnsiEncoding;
        }

        if (isSymbolicFont) {
          encoding = _encodings.MacRomanEncoding;

          if (!properties.file) {
            if (/Symbol/i.test(properties.name)) {
              encoding = _encodings.SymbolSetEncoding;
            } else if (/Dingbats|Wingdings/i.test(properties.name)) {
              encoding = _encodings.ZapfDingbatsEncoding;
            }
          }
        }

        properties.defaultEncoding = encoding;
      }

      properties.differences = differences;
      properties.baseEncodingName = baseEncodingName;
      properties.hasEncoding = !!baseEncodingName || differences.length > 0;
      properties.dict = dict;
      return toUnicodePromise.then(function (readToUnicode) {
        properties.toUnicode = readToUnicode;
        return _this9.buildToUnicode(properties);
      }).then(function (builtToUnicode) {
        properties.toUnicode = builtToUnicode;

        if (cidToGidBytes) {
          properties.cidToGidMap = _this9.readCidToGidMap(cidToGidBytes, builtToUnicode);
        }

        return properties;
      });
    }
  }, {
    key: "_buildSimpleFontToUnicode",
    value: function _buildSimpleFontToUnicode(properties) {
      var forceGlyphs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      (0, _util.assert)(!properties.composite, "Must be a simple font.");
      var toUnicode = [];
      var encoding = properties.defaultEncoding.slice();
      var baseEncodingName = properties.baseEncodingName;
      var differences = properties.differences;

      for (var charcode in differences) {
        var glyphName = differences[charcode];

        if (glyphName === ".notdef") {
          continue;
        }

        encoding[charcode] = glyphName;
      }

      var glyphsUnicodeMap = (0, _glyphlist.getGlyphsUnicode)();

      for (var _charcode in encoding) {
        var _glyphName = encoding[_charcode];

        if (_glyphName === "") {
          continue;
        } else if (glyphsUnicodeMap[_glyphName] === undefined) {
          var code = 0;

          switch (_glyphName[0]) {
            case "G":
              if (_glyphName.length === 3) {
                code = parseInt(_glyphName.substring(1), 16);
              }

              break;

            case "g":
              if (_glyphName.length === 5) {
                code = parseInt(_glyphName.substring(1), 16);
              }

              break;

            case "C":
            case "c":
              if (_glyphName.length >= 3 && _glyphName.length <= 4) {
                var codeStr = _glyphName.substring(1);

                if (forceGlyphs) {
                  code = parseInt(codeStr, 16);
                  break;
                }

                code = +codeStr;

                if (Number.isNaN(code) && Number.isInteger(parseInt(codeStr, 16))) {
                  return this._buildSimpleFontToUnicode(properties, true);
                }
              }

              break;

            default:
              var unicode = (0, _unicode.getUnicodeForGlyph)(_glyphName, glyphsUnicodeMap);

              if (unicode !== -1) {
                code = unicode;
              }

          }

          if (code > 0 && code <= 0x10ffff && Number.isInteger(code)) {
            if (baseEncodingName && code === +_charcode) {
              var baseEncoding = (0, _encodings.getEncoding)(baseEncodingName);

              if (baseEncoding && (_glyphName = baseEncoding[_charcode])) {
                toUnicode[_charcode] = String.fromCharCode(glyphsUnicodeMap[_glyphName]);
                continue;
              }
            }

            toUnicode[_charcode] = String.fromCodePoint(code);
          }

          continue;
        }

        toUnicode[_charcode] = String.fromCharCode(glyphsUnicodeMap[_glyphName]);
      }

      return new _to_unicode_map.ToUnicodeMap(toUnicode);
    }
  }, {
    key: "buildToUnicode",
    value: function buildToUnicode(properties) {
      properties.hasIncludedToUnicodeMap = !!properties.toUnicode && properties.toUnicode.length > 0;

      if (properties.hasIncludedToUnicodeMap) {
        if (!properties.composite && properties.hasEncoding) {
          properties.fallbackToUnicode = this._buildSimpleFontToUnicode(properties);
        }

        return Promise.resolve(properties.toUnicode);
      }

      if (!properties.composite) {
        return Promise.resolve(this._buildSimpleFontToUnicode(properties));
      }

      if (properties.composite && (properties.cMap.builtInCMap && !(properties.cMap instanceof _cmap.IdentityCMap) || properties.cidSystemInfo.registry === "Adobe" && (properties.cidSystemInfo.ordering === "GB1" || properties.cidSystemInfo.ordering === "CNS1" || properties.cidSystemInfo.ordering === "Japan1" || properties.cidSystemInfo.ordering === "Korea1"))) {
        var registry = properties.cidSystemInfo.registry;
        var ordering = properties.cidSystemInfo.ordering;

        var ucs2CMapName = _primitives.Name.get(registry + "-" + ordering + "-UCS2");

        return _cmap.CMapFactory.create({
          encoding: ucs2CMapName,
          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
          useCMap: null
        }).then(function (ucs2CMap) {
          var cMap = properties.cMap;
          var toUnicode = [];
          cMap.forEach(function (charcode, cid) {
            if (cid > 0xffff) {
              throw new _util.FormatError("Max size of CID is 65,535");
            }

            var ucs2 = ucs2CMap.lookup(cid);

            if (ucs2) {
              toUnicode[charcode] = String.fromCharCode((ucs2.charCodeAt(0) << 8) + ucs2.charCodeAt(1));
            }
          });
          return new _to_unicode_map.ToUnicodeMap(toUnicode);
        });
      }

      return Promise.resolve(new _to_unicode_map.IdentityToUnicodeMap(properties.firstChar, properties.lastChar));
    }
  }, {
    key: "readToUnicode",
    value: function readToUnicode(cmapObj) {
      var _this10 = this;

      if (!cmapObj) {
        return Promise.resolve(null);
      }

      if ((0, _primitives.isName)(cmapObj)) {
        return _cmap.CMapFactory.create({
          encoding: cmapObj,
          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
          useCMap: null
        }).then(function (cmap) {
          if (cmap instanceof _cmap.IdentityCMap) {
            return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
          }

          return new _to_unicode_map.ToUnicodeMap(cmap.getMap());
        });
      } else if ((0, _primitives.isStream)(cmapObj)) {
        return _cmap.CMapFactory.create({
          encoding: cmapObj,
          fetchBuiltInCMap: this._fetchBuiltInCMapBound,
          useCMap: null
        }).then(function (cmap) {
          if (cmap instanceof _cmap.IdentityCMap) {
            return new _to_unicode_map.IdentityToUnicodeMap(0, 0xffff);
          }

          var map = new Array(cmap.length);
          cmap.forEach(function (charCode, token) {
            var str = [];

            for (var k = 0; k < token.length; k += 2) {
              var w1 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);

              if ((w1 & 0xf800) !== 0xd800) {
                str.push(w1);
                continue;
              }

              k += 2;
              var w2 = token.charCodeAt(k) << 8 | token.charCodeAt(k + 1);
              str.push(((w1 & 0x3ff) << 10) + (w2 & 0x3ff) + 0x10000);
            }

            map[charCode] = String.fromCodePoint.apply(String, str);
          });
          return new _to_unicode_map.ToUnicodeMap(map);
        }, function (reason) {
          if (reason instanceof _util.AbortException) {
            return null;
          }

          if (_this10.options.ignoreErrors) {
            _this10.handler.send("UnsupportedFeature", {
              featureId: _util.UNSUPPORTED_FEATURES.errorFontToUnicode
            });

            (0, _util.warn)("readToUnicode - ignoring ToUnicode data: \"".concat(reason, "\"."));
            return null;
          }

          throw reason;
        });
      }

      return Promise.resolve(null);
    }
  }, {
    key: "readCidToGidMap",
    value: function readCidToGidMap(glyphsData, toUnicode) {
      var result = [];

      for (var j = 0, jj = glyphsData.length; j < jj; j++) {
        var glyphID = glyphsData[j++] << 8 | glyphsData[j];
        var code = j >> 1;

        if (glyphID === 0 && !toUnicode.has(code)) {
          continue;
        }

        result[code] = glyphID;
      }

      return result;
    }
  }, {
    key: "extractWidths",
    value: function extractWidths(dict, descriptor, properties) {
      var xref = this.xref;
      var glyphsWidths = [];
      var defaultWidth = 0;
      var glyphsVMetrics = [];
      var defaultVMetrics;
      var i, ii, j, jj, start, code, widths;

      if (properties.composite) {
        defaultWidth = dict.has("DW") ? dict.get("DW") : 1000;
        widths = dict.get("W");

        if (widths) {
          for (i = 0, ii = widths.length; i < ii; i++) {
            start = xref.fetchIfRef(widths[i++]);
            code = xref.fetchIfRef(widths[i]);

            if (Array.isArray(code)) {
              for (j = 0, jj = code.length; j < jj; j++) {
                glyphsWidths[start++] = xref.fetchIfRef(code[j]);
              }
            } else {
              var width = xref.fetchIfRef(widths[++i]);

              for (j = start; j <= code; j++) {
                glyphsWidths[j] = width;
              }
            }
          }
        }

        if (properties.vertical) {
          var vmetrics = dict.getArray("DW2") || [880, -1000];
          defaultVMetrics = [vmetrics[1], defaultWidth * 0.5, vmetrics[0]];
          vmetrics = dict.get("W2");

          if (vmetrics) {
            for (i = 0, ii = vmetrics.length; i < ii; i++) {
              start = xref.fetchIfRef(vmetrics[i++]);
              code = xref.fetchIfRef(vmetrics[i]);

              if (Array.isArray(code)) {
                for (j = 0, jj = code.length; j < jj; j++) {
                  glyphsVMetrics[start++] = [xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j++]), xref.fetchIfRef(code[j])];
                }
              } else {
                var vmetric = [xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i]), xref.fetchIfRef(vmetrics[++i])];

                for (j = start; j <= code; j++) {
                  glyphsVMetrics[j] = vmetric;
                }
              }
            }
          }
        }
      } else {
        var firstChar = properties.firstChar;
        widths = dict.get("Widths");

        if (widths) {
          j = firstChar;

          for (i = 0, ii = widths.length; i < ii; i++) {
            glyphsWidths[j++] = xref.fetchIfRef(widths[i]);
          }

          defaultWidth = parseFloat(descriptor.get("MissingWidth")) || 0;
        } else {
          var baseFontName = dict.get("BaseFont");

          if ((0, _primitives.isName)(baseFontName)) {
            var metrics = this.getBaseFontMetrics(baseFontName.name);
            glyphsWidths = this.buildCharCodeToWidth(metrics.widths, properties);
            defaultWidth = metrics.defaultWidth;
          }
        }
      }

      var isMonospace = true;
      var firstWidth = defaultWidth;

      for (var glyph in glyphsWidths) {
        var glyphWidth = glyphsWidths[glyph];

        if (!glyphWidth) {
          continue;
        }

        if (!firstWidth) {
          firstWidth = glyphWidth;
          continue;
        }

        if (firstWidth !== glyphWidth) {
          isMonospace = false;
          break;
        }
      }

      if (isMonospace) {
        properties.flags |= _fonts_utils.FontFlags.FixedPitch;
      }

      properties.defaultWidth = defaultWidth;
      properties.widths = glyphsWidths;
      properties.defaultVMetrics = defaultVMetrics;
      properties.vmetrics = glyphsVMetrics;
    }
  }, {
    key: "isSerifFont",
    value: function isSerifFont(baseFontName) {
      var fontNameWoStyle = baseFontName.split("-")[0];
      return fontNameWoStyle in (0, _standard_fonts.getSerifFonts)() || fontNameWoStyle.search(/serif/gi) !== -1;
    }
  }, {
    key: "getBaseFontMetrics",
    value: function getBaseFontMetrics(name) {
      var defaultWidth = 0;
      var widths = Object.create(null);
      var monospace = false;
      var stdFontMap = (0, _standard_fonts.getStdFontMap)();
      var lookupName = stdFontMap[name] || name;
      var Metrics = (0, _metrics.getMetrics)();

      if (!(lookupName in Metrics)) {
        if (this.isSerifFont(name)) {
          lookupName = "Times-Roman";
        } else {
          lookupName = "Helvetica";
        }
      }

      var glyphWidths = Metrics[lookupName];

      if ((0, _util.isNum)(glyphWidths)) {
        defaultWidth = glyphWidths;
        monospace = true;
      } else {
        widths = glyphWidths();
      }

      return {
        defaultWidth: defaultWidth,
        monospace: monospace,
        widths: widths
      };
    }
  }, {
    key: "buildCharCodeToWidth",
    value: function buildCharCodeToWidth(widthsByGlyphName, properties) {
      var widths = Object.create(null);
      var differences = properties.differences;
      var encoding = properties.defaultEncoding;

      for (var charCode = 0; charCode < 256; charCode++) {
        if (charCode in differences && widthsByGlyphName[differences[charCode]]) {
          widths[charCode] = widthsByGlyphName[differences[charCode]];
          continue;
        }

        if (charCode in encoding && widthsByGlyphName[encoding[charCode]]) {
          widths[charCode] = widthsByGlyphName[encoding[charCode]];
          continue;
        }
      }

      return widths;
    }
  }, {
    key: "preEvaluateFont",
    value: function preEvaluateFont(dict) {
      var baseDict = dict;
      var type = dict.get("Subtype");

      if (!(0, _primitives.isName)(type)) {
        throw new _util.FormatError("invalid font Subtype");
      }

      var composite = false;
      var hash, toUnicode;

      if (type.name === "Type0") {
        var df = dict.get("DescendantFonts");

        if (!df) {
          throw new _util.FormatError("Descendant fonts are not specified");
        }

        dict = Array.isArray(df) ? this.xref.fetchIfRef(df[0]) : df;

        if (!(dict instanceof _primitives.Dict)) {
          throw new _util.FormatError("Descendant font is not a dictionary.");
        }

        type = dict.get("Subtype");

        if (!(0, _primitives.isName)(type)) {
          throw new _util.FormatError("invalid font Subtype");
        }

        composite = true;
      }

      var firstChar = dict.get("FirstChar") || 0,
          lastChar = dict.get("LastChar") || (composite ? 0xffff : 0xff);
      var descriptor = dict.get("FontDescriptor");

      if (descriptor) {
        hash = new _murmurhash.MurmurHash3_64();
        var encoding = baseDict.getRaw("Encoding");

        if ((0, _primitives.isName)(encoding)) {
          hash.update(encoding.name);
        } else if ((0, _primitives.isRef)(encoding)) {
          hash.update(encoding.toString());
        } else if ((0, _primitives.isDict)(encoding)) {
          var _iterator6 = _createForOfIteratorHelper(encoding.getRawValues()),
              _step6;

          try {
            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
              var entry = _step6.value;

              if ((0, _primitives.isName)(entry)) {
                hash.update(entry.name);
              } else if ((0, _primitives.isRef)(entry)) {
                hash.update(entry.toString());
              } else if (Array.isArray(entry)) {
                var diffLength = entry.length,
                    diffBuf = new Array(diffLength);

                for (var j = 0; j < diffLength; j++) {
                  var diffEntry = entry[j];

                  if ((0, _primitives.isName)(diffEntry)) {
                    diffBuf[j] = diffEntry.name;
                  } else if ((0, _util.isNum)(diffEntry) || (0, _primitives.isRef)(diffEntry)) {
                    diffBuf[j] = diffEntry.toString();
                  }
                }

                hash.update(diffBuf.join());
              }
            }
          } catch (err) {
            _iterator6.e(err);
          } finally {
            _iterator6.f();
          }
        }

        hash.update("".concat(firstChar, "-").concat(lastChar));
        toUnicode = dict.get("ToUnicode") || baseDict.get("ToUnicode");

        if ((0, _primitives.isStream)(toUnicode)) {
          var stream = toUnicode.str || toUnicode;
          var uint8array = stream.buffer ? new Uint8Array(stream.buffer.buffer, 0, stream.bufferLength) : new Uint8Array(stream.bytes.buffer, stream.start, stream.end - stream.start);
          hash.update(uint8array);
        } else if ((0, _primitives.isName)(toUnicode)) {
          hash.update(toUnicode.name);
        }

        var widths = dict.get("Widths") || baseDict.get("Widths");

        if (Array.isArray(widths)) {
          var widthsBuf = [];

          var _iterator7 = _createForOfIteratorHelper(widths),
              _step7;

          try {
            for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
              var _entry = _step7.value;

              if ((0, _util.isNum)(_entry) || (0, _primitives.isRef)(_entry)) {
                widthsBuf.push(_entry.toString());
              }
            }
          } catch (err) {
            _iterator7.e(err);
          } finally {
            _iterator7.f();
          }

          hash.update(widthsBuf.join());
        }

        if (composite) {
          hash.update("compositeFont");
          var compositeWidths = dict.get("W") || baseDict.get("W");

          if (Array.isArray(compositeWidths)) {
            var _widthsBuf = [];

            var _iterator8 = _createForOfIteratorHelper(compositeWidths),
                _step8;

            try {
              for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                var _entry2 = _step8.value;

                if ((0, _util.isNum)(_entry2) || (0, _primitives.isRef)(_entry2)) {
                  _widthsBuf.push(_entry2.toString());
                } else if (Array.isArray(_entry2)) {
                  var subWidthsBuf = [];

                  var _iterator9 = _createForOfIteratorHelper(_entry2),
                      _step9;

                  try {
                    for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
                      var element = _step9.value;

                      if ((0, _util.isNum)(element) || (0, _primitives.isRef)(element)) {
                        subWidthsBuf.push(element.toString());
                      }
                    }
                  } catch (err) {
                    _iterator9.e(err);
                  } finally {
                    _iterator9.f();
                  }

                  _widthsBuf.push("[".concat(subWidthsBuf.join(), "]"));
                }
              }
            } catch (err) {
              _iterator8.e(err);
            } finally {
              _iterator8.f();
            }

            hash.update(_widthsBuf.join());
          }
        }
      }

      return {
        descriptor: descriptor,
        dict: dict,
        baseDict: baseDict,
        composite: composite,
        type: type.name,
        firstChar: firstChar,
        lastChar: lastChar,
        toUnicode: toUnicode,
        hash: hash ? hash.hexdigest() : ""
      };
    }
  }, {
    key: "translateFont",
    value: function () {
      var _translateFont = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee7(_ref10) {
        var _this11 = this;

        var descriptor, dict, baseDict, composite, type, firstChar, lastChar, toUnicode, cssFontInfo, isType3Font, properties, baseFontName, metrics, fontNameWoStyle, flags, widths, fontName, baseFont, fontNameStr, baseFontStr, fontFile, subtype, length1, length2, length3, subtypeEntry, cidEncoding, cMap;
        return _regenerator["default"].wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                descriptor = _ref10.descriptor, dict = _ref10.dict, baseDict = _ref10.baseDict, composite = _ref10.composite, type = _ref10.type, firstChar = _ref10.firstChar, lastChar = _ref10.lastChar, toUnicode = _ref10.toUnicode, cssFontInfo = _ref10.cssFontInfo;
                isType3Font = type === "Type3";

                if (descriptor) {
                  _context7.next = 19;
                  break;
                }

                if (!isType3Font) {
                  _context7.next = 9;
                  break;
                }

                descriptor = new _primitives.Dict(null);
                descriptor.set("FontName", _primitives.Name.get(type));
                descriptor.set("FontBBox", dict.getArray("FontBBox") || [0, 0, 0, 0]);
                _context7.next = 19;
                break;

              case 9:
                baseFontName = dict.get("BaseFont");

                if ((0, _primitives.isName)(baseFontName)) {
                  _context7.next = 12;
                  break;
                }

                throw new _util.FormatError("Base font is not specified");

              case 12:
                baseFontName = baseFontName.name.replace(/[,_]/g, "-");
                metrics = this.getBaseFontMetrics(baseFontName);
                fontNameWoStyle = baseFontName.split("-")[0];
                flags = (this.isSerifFont(fontNameWoStyle) ? _fonts_utils.FontFlags.Serif : 0) | (metrics.monospace ? _fonts_utils.FontFlags.FixedPitch : 0) | ((0, _standard_fonts.getSymbolsFonts)()[fontNameWoStyle] ? _fonts_utils.FontFlags.Symbolic : _fonts_utils.FontFlags.Nonsymbolic);
                properties = {
                  type: type,
                  name: baseFontName,
                  widths: metrics.widths,
                  defaultWidth: metrics.defaultWidth,
                  flags: flags,
                  firstChar: firstChar,
                  lastChar: lastChar,
                  toUnicode: toUnicode,
                  isType3Font: isType3Font
                };
                widths = dict.get("Widths");
                return _context7.abrupt("return", this.extractDataStructures(dict, dict, properties).then(function (newProperties) {
                  if (widths) {
                    var glyphWidths = [];
                    var j = firstChar;

                    for (var i = 0, ii = widths.length; i < ii; i++) {
                      glyphWidths[j++] = _this11.xref.fetchIfRef(widths[i]);
                    }

                    newProperties.widths = glyphWidths;
                  } else {
                    newProperties.widths = _this11.buildCharCodeToWidth(metrics.widths, newProperties);
                  }

                  return new _fonts.Font(baseFontName, null, newProperties);
                }));

              case 19:
                fontName = descriptor.get("FontName");
                baseFont = dict.get("BaseFont");

                if ((0, _util.isString)(fontName)) {
                  fontName = _primitives.Name.get(fontName);
                }

                if ((0, _util.isString)(baseFont)) {
                  baseFont = _primitives.Name.get(baseFont);
                }

                if (!isType3Font) {
                  fontNameStr = fontName && fontName.name;
                  baseFontStr = baseFont && baseFont.name;

                  if (fontNameStr !== baseFontStr) {
                    (0, _util.info)("The FontDescriptor's FontName is \"".concat(fontNameStr, "\" but ") + "should be the same as the Font's BaseFont \"".concat(baseFontStr, "\"."));

                    if (fontNameStr && baseFontStr && baseFontStr.startsWith(fontNameStr)) {
                      fontName = baseFont;
                    }
                  }
                }

                fontName = fontName || baseFont;

                if ((0, _primitives.isName)(fontName)) {
                  _context7.next = 27;
                  break;
                }

                throw new _util.FormatError("invalid font name");

              case 27:
                _context7.prev = 27;
                fontFile = descriptor.get("FontFile", "FontFile2", "FontFile3");
                _context7.next = 37;
                break;

              case 31:
                _context7.prev = 31;
                _context7.t0 = _context7["catch"](27);

                if (this.options.ignoreErrors) {
                  _context7.next = 35;
                  break;
                }

                throw _context7.t0;

              case 35:
                (0, _util.warn)("translateFont - fetching \"".concat(fontName.name, "\" font file: \"").concat(_context7.t0, "\"."));
                fontFile = new _stream.NullStream();

              case 37:
                if (fontFile) {
                  if (fontFile.dict) {
                    subtypeEntry = fontFile.dict.get("Subtype");

                    if (subtypeEntry instanceof _primitives.Name) {
                      subtype = subtypeEntry.name;
                    }

                    length1 = fontFile.dict.get("Length1");
                    length2 = fontFile.dict.get("Length2");
                    length3 = fontFile.dict.get("Length3");
                  }
                }

                properties = {
                  type: type,
                  name: fontName.name,
                  subtype: subtype,
                  file: fontFile,
                  length1: length1,
                  length2: length2,
                  length3: length3,
                  loadedName: baseDict.loadedName,
                  composite: composite,
                  fixedPitch: false,
                  fontMatrix: dict.getArray("FontMatrix") || _util.FONT_IDENTITY_MATRIX,
                  firstChar: firstChar,
                  lastChar: lastChar,
                  toUnicode: toUnicode,
                  bbox: descriptor.getArray("FontBBox"),
                  ascent: descriptor.get("Ascent"),
                  descent: descriptor.get("Descent"),
                  xHeight: descriptor.get("XHeight"),
                  capHeight: descriptor.get("CapHeight"),
                  flags: descriptor.get("Flags"),
                  italicAngle: descriptor.get("ItalicAngle"),
                  isType3Font: isType3Font,
                  cssFontInfo: cssFontInfo
                };

                if (!composite) {
                  _context7.next = 47;
                  break;
                }

                cidEncoding = baseDict.get("Encoding");

                if ((0, _primitives.isName)(cidEncoding)) {
                  properties.cidEncoding = cidEncoding.name;
                }

                _context7.next = 44;
                return _cmap.CMapFactory.create({
                  encoding: cidEncoding,
                  fetchBuiltInCMap: this._fetchBuiltInCMapBound,
                  useCMap: null
                });

              case 44:
                cMap = _context7.sent;
                properties.cMap = cMap;
                properties.vertical = properties.cMap.vertical;

              case 47:
                return _context7.abrupt("return", this.extractDataStructures(dict, baseDict, properties).then(function (newProperties) {
                  _this11.extractWidths(dict, descriptor, newProperties);

                  return new _fonts.Font(fontName.name, fontFile, newProperties);
                }));

              case 48:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this, [[27, 31]]);
      }));

      function translateFont(_x13) {
        return _translateFont.apply(this, arguments);
      }

      return translateFont;
    }()
  }], [{
    key: "buildFontPaths",
    value: function buildFontPaths(font, glyphs, handler, evaluatorOptions) {
      function buildPath(fontChar) {
        var glyphName = "".concat(font.loadedName, "_path_").concat(fontChar);

        try {
          if (font.renderer.hasBuiltPath(fontChar)) {
            return;
          }

          handler.send("commonobj", [glyphName, "FontPath", font.renderer.getPathJs(fontChar)]);
        } catch (reason) {
          if (evaluatorOptions.ignoreErrors) {
            handler.send("UnsupportedFeature", {
              featureId: _util.UNSUPPORTED_FEATURES.errorFontBuildPath
            });
            (0, _util.warn)("buildFontPaths - ignoring ".concat(glyphName, " glyph: \"").concat(reason, "\"."));
            return;
          }

          throw reason;
        }
      }

      var _iterator10 = _createForOfIteratorHelper(glyphs),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var glyph = _step10.value;
          buildPath(glyph.fontChar);
          var accent = glyph.accent;

          if (accent && accent.fontChar) {
            buildPath(accent.fontChar);
          }
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }
    }
  }, {
    key: "fallbackFontDict",
    get: function get() {
      var dict = new _primitives.Dict();
      dict.set("BaseFont", _primitives.Name.get("PDFJS-FallbackFont"));
      dict.set("Type", _primitives.Name.get("FallbackType"));
      dict.set("Subtype", _primitives.Name.get("FallbackType"));
      dict.set("Encoding", _primitives.Name.get("WinAnsiEncoding"));
      return (0, _util.shadow)(this, "fallbackFontDict", dict);
    }
  }]);

  return PartialEvaluator;
}();

exports.PartialEvaluator = PartialEvaluator;

var TranslatedFont = /*#__PURE__*/function () {
  function TranslatedFont(_ref11) {
    var loadedName = _ref11.loadedName,
        font = _ref11.font,
        dict = _ref11.dict,
        evaluatorOptions = _ref11.evaluatorOptions;

    _classCallCheck(this, TranslatedFont);

    this.loadedName = loadedName;
    this.font = font;
    this.dict = dict;
    this._evaluatorOptions = evaluatorOptions || DefaultPartialEvaluatorOptions;
    this.type3Loaded = null;
    this.type3Dependencies = font.isType3Font ? new Set() : null;
    this.sent = false;
  }

  _createClass(TranslatedFont, [{
    key: "send",
    value: function send(handler) {
      if (this.sent) {
        return;
      }

      this.sent = true;
      handler.send("commonobj", [this.loadedName, "Font", this.font.exportData(this._evaluatorOptions.fontExtraProperties)]);
    }
  }, {
    key: "fallback",
    value: function fallback(handler) {
      if (!this.font.data) {
        return;
      }

      this.font.disableFontFace = true;
      PartialEvaluator.buildFontPaths(this.font, this.font.glyphCacheValues, handler, this._evaluatorOptions);
    }
  }, {
    key: "loadType3Data",
    value: function loadType3Data(evaluator, resources, task) {
      var _this12 = this;

      if (this.type3Loaded) {
        return this.type3Loaded;
      }

      if (!this.font.isType3Font) {
        throw new Error("Must be a Type3 font.");
      }

      var type3Options = Object.create(evaluator.options);
      type3Options.ignoreErrors = false;
      var type3Evaluator = evaluator.clone(type3Options);
      type3Evaluator.parsingType3Font = true;
      var translatedFont = this.font,
          type3Dependencies = this.type3Dependencies;
      var loadCharProcsPromise = Promise.resolve();
      var charProcs = this.dict.get("CharProcs");
      var fontResources = this.dict.get("Resources") || resources;
      var charProcOperatorList = Object.create(null);

      var _iterator11 = _createForOfIteratorHelper(charProcs.getKeys()),
          _step11;

      try {
        var _loop2 = function _loop2() {
          var key = _step11.value;
          loadCharProcsPromise = loadCharProcsPromise.then(function () {
            var glyphStream = charProcs.get(key);
            var operatorList = new _operator_list.OperatorList();
            return type3Evaluator.getOperatorList({
              stream: glyphStream,
              task: task,
              resources: fontResources,
              operatorList: operatorList
            }).then(function () {
              if (operatorList.fnArray[0] === _util.OPS.setCharWidthAndBounds) {
                _this12._removeType3ColorOperators(operatorList);
              }

              charProcOperatorList[key] = operatorList.getIR();

              var _iterator12 = _createForOfIteratorHelper(operatorList.dependencies),
                  _step12;

              try {
                for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
                  var dependency = _step12.value;
                  type3Dependencies.add(dependency);
                }
              } catch (err) {
                _iterator12.e(err);
              } finally {
                _iterator12.f();
              }
            })["catch"](function (reason) {
              (0, _util.warn)("Type3 font resource \"".concat(key, "\" is not available."));
              var dummyOperatorList = new _operator_list.OperatorList();
              charProcOperatorList[key] = dummyOperatorList.getIR();
            });
          });
        };

        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          _loop2();
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      this.type3Loaded = loadCharProcsPromise.then(function () {
        translatedFont.charProcOperatorList = charProcOperatorList;
      });
      return this.type3Loaded;
    }
  }, {
    key: "_removeType3ColorOperators",
    value: function _removeType3ColorOperators(operatorList) {
      var i = 1,
          ii = operatorList.length;

      while (i < ii) {
        switch (operatorList.fnArray[i]) {
          case _util.OPS.setStrokeColorSpace:
          case _util.OPS.setFillColorSpace:
          case _util.OPS.setStrokeColor:
          case _util.OPS.setStrokeColorN:
          case _util.OPS.setFillColor:
          case _util.OPS.setFillColorN:
          case _util.OPS.setStrokeGray:
          case _util.OPS.setFillGray:
          case _util.OPS.setStrokeRGBColor:
          case _util.OPS.setFillRGBColor:
          case _util.OPS.setStrokeCMYKColor:
          case _util.OPS.setFillCMYKColor:
          case _util.OPS.shadingFill:
          case _util.OPS.setRenderingIntent:
            operatorList.fnArray.splice(i, 1);
            operatorList.argsArray.splice(i, 1);
            ii--;
            continue;

          case _util.OPS.setGState:
            var _operatorList$argsArr = _slicedToArray(operatorList.argsArray[i], 1),
                _gStateObj = _operatorList$argsArr[0];

            var j = 0,
                jj = _gStateObj.length;

            while (j < jj) {
              var _gStateObj$j = _slicedToArray(_gStateObj[j], 1),
                  gStateKey = _gStateObj$j[0];

              switch (gStateKey) {
                case "TR":
                case "TR2":
                case "HT":
                case "BG":
                case "BG2":
                case "UCR":
                case "UCR2":
                  _gStateObj.splice(j, 1);

                  jj--;
                  continue;
              }

              j++;
            }

            break;
        }

        i++;
      }
    }
  }]);

  return TranslatedFont;
}();

var StateManager = /*#__PURE__*/function () {
  function StateManager() {
    var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new EvalState();

    _classCallCheck(this, StateManager);

    this.state = initialState;
    this.stateStack = [];
  }

  _createClass(StateManager, [{
    key: "save",
    value: function save() {
      var old = this.state;
      this.stateStack.push(this.state);
      this.state = old.clone();
    }
  }, {
    key: "restore",
    value: function restore() {
      var prev = this.stateStack.pop();

      if (prev) {
        this.state = prev;
      }
    }
  }, {
    key: "transform",
    value: function transform(args) {
      this.state.ctm = _util.Util.transform(this.state.ctm, args);
    }
  }]);

  return StateManager;
}();

var TextState = /*#__PURE__*/function () {
  function TextState() {
    _classCallCheck(this, TextState);

    this.ctm = new Float32Array(_util.IDENTITY_MATRIX);
    this.fontName = null;
    this.fontSize = 0;
    this.font = null;
    this.fontMatrix = _util.FONT_IDENTITY_MATRIX;
    this.textMatrix = _util.IDENTITY_MATRIX.slice();
    this.textLineMatrix = _util.IDENTITY_MATRIX.slice();
    this.charSpacing = 0;
    this.wordSpacing = 0;
    this.leading = 0;
    this.textHScale = 1;
    this.textRise = 0;
  }

  _createClass(TextState, [{
    key: "setTextMatrix",
    value: function setTextMatrix(a, b, c, d, e, f) {
      var m = this.textMatrix;
      m[0] = a;
      m[1] = b;
      m[2] = c;
      m[3] = d;
      m[4] = e;
      m[5] = f;
    }
  }, {
    key: "setTextLineMatrix",
    value: function setTextLineMatrix(a, b, c, d, e, f) {
      var m = this.textLineMatrix;
      m[0] = a;
      m[1] = b;
      m[2] = c;
      m[3] = d;
      m[4] = e;
      m[5] = f;
    }
  }, {
    key: "translateTextMatrix",
    value: function translateTextMatrix(x, y) {
      var m = this.textMatrix;
      m[4] = m[0] * x + m[2] * y + m[4];
      m[5] = m[1] * x + m[3] * y + m[5];
    }
  }, {
    key: "translateTextLineMatrix",
    value: function translateTextLineMatrix(x, y) {
      var m = this.textLineMatrix;
      m[4] = m[0] * x + m[2] * y + m[4];
      m[5] = m[1] * x + m[3] * y + m[5];
    }
  }, {
    key: "carriageReturn",
    value: function carriageReturn() {
      this.translateTextLineMatrix(0, -this.leading);
      this.textMatrix = this.textLineMatrix.slice();
    }
  }, {
    key: "clone",
    value: function clone() {
      var clone = Object.create(this);
      clone.textMatrix = this.textMatrix.slice();
      clone.textLineMatrix = this.textLineMatrix.slice();
      clone.fontMatrix = this.fontMatrix.slice();
      return clone;
    }
  }]);

  return TextState;
}();

var EvalState = /*#__PURE__*/function () {
  function EvalState() {
    _classCallCheck(this, EvalState);

    this.ctm = new Float32Array(_util.IDENTITY_MATRIX);
    this.font = null;
    this.textRenderingMode = _util.TextRenderingMode.FILL;
    this.fillColorSpace = _colorspace.ColorSpace.singletons.gray;
    this.strokeColorSpace = _colorspace.ColorSpace.singletons.gray;
  }

  _createClass(EvalState, [{
    key: "clone",
    value: function clone() {
      return Object.create(this);
    }
  }]);

  return EvalState;
}();

var EvaluatorPreprocessor = /*#__PURE__*/function () {
  function EvaluatorPreprocessor(stream, xref) {
    var stateManager = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new StateManager();

    _classCallCheck(this, EvaluatorPreprocessor);

    this.parser = new _parser.Parser({
      lexer: new _parser.Lexer(stream, EvaluatorPreprocessor.opMap),
      xref: xref
    });
    this.stateManager = stateManager;
    this.nonProcessedArgs = [];
    this._numInvalidPathOPS = 0;
  }

  _createClass(EvaluatorPreprocessor, [{
    key: "savedStatesDepth",
    get: function get() {
      return this.stateManager.stateStack.length;
    }
  }, {
    key: "read",
    value: function read(operation) {
      var args = operation.args;

      while (true) {
        var obj = this.parser.getObj();

        if (obj instanceof _primitives.Cmd) {
          var cmd = obj.cmd;
          var opSpec = EvaluatorPreprocessor.opMap[cmd];

          if (!opSpec) {
            (0, _util.warn)("Unknown command \"".concat(cmd, "\"."));
            continue;
          }

          var fn = opSpec.id;
          var numArgs = opSpec.numArgs;
          var argsLength = args !== null ? args.length : 0;

          if (!opSpec.variableArgs) {
            if (argsLength !== numArgs) {
              var nonProcessedArgs = this.nonProcessedArgs;

              while (argsLength > numArgs) {
                nonProcessedArgs.push(args.shift());
                argsLength--;
              }

              while (argsLength < numArgs && nonProcessedArgs.length !== 0) {
                if (args === null) {
                  args = [];
                }

                args.unshift(nonProcessedArgs.pop());
                argsLength++;
              }
            }

            if (argsLength < numArgs) {
              var partialMsg = "command ".concat(cmd, ": expected ").concat(numArgs, " args, ") + "but received ".concat(argsLength, " args.");

              if (fn >= _util.OPS.moveTo && fn <= _util.OPS.endPath && ++this._numInvalidPathOPS > EvaluatorPreprocessor.MAX_INVALID_PATH_OPS) {
                throw new _util.FormatError("Invalid ".concat(partialMsg));
              }

              (0, _util.warn)("Skipping ".concat(partialMsg));

              if (args !== null) {
                args.length = 0;
              }

              continue;
            }
          } else if (argsLength > numArgs) {
            (0, _util.info)("Command ".concat(cmd, ": expected [0, ").concat(numArgs, "] args, ") + "but received ".concat(argsLength, " args."));
          }

          this.preprocessCommand(fn, args);
          operation.fn = fn;
          operation.args = args;
          return true;
        }

        if (obj === _primitives.EOF) {
          return false;
        }

        if (obj !== null) {
          if (args === null) {
            args = [];
          }

          args.push(obj);

          if (args.length > 33) {
            throw new _util.FormatError("Too many arguments");
          }
        }
      }
    }
  }, {
    key: "preprocessCommand",
    value: function preprocessCommand(fn, args) {
      switch (fn | 0) {
        case _util.OPS.save:
          this.stateManager.save();
          break;

        case _util.OPS.restore:
          this.stateManager.restore();
          break;

        case _util.OPS.transform:
          this.stateManager.transform(args);
          break;
      }
    }
  }], [{
    key: "opMap",
    get: function get() {
      var getOPMap = (0, _core_utils.getLookupTableFactory)(function (t) {
        t.w = {
          id: _util.OPS.setLineWidth,
          numArgs: 1,
          variableArgs: false
        };
        t.J = {
          id: _util.OPS.setLineCap,
          numArgs: 1,
          variableArgs: false
        };
        t.j = {
          id: _util.OPS.setLineJoin,
          numArgs: 1,
          variableArgs: false
        };
        t.M = {
          id: _util.OPS.setMiterLimit,
          numArgs: 1,
          variableArgs: false
        };
        t.d = {
          id: _util.OPS.setDash,
          numArgs: 2,
          variableArgs: false
        };
        t.ri = {
          id: _util.OPS.setRenderingIntent,
          numArgs: 1,
          variableArgs: false
        };
        t.i = {
          id: _util.OPS.setFlatness,
          numArgs: 1,
          variableArgs: false
        };
        t.gs = {
          id: _util.OPS.setGState,
          numArgs: 1,
          variableArgs: false
        };
        t.q = {
          id: _util.OPS.save,
          numArgs: 0,
          variableArgs: false
        };
        t.Q = {
          id: _util.OPS.restore,
          numArgs: 0,
          variableArgs: false
        };
        t.cm = {
          id: _util.OPS.transform,
          numArgs: 6,
          variableArgs: false
        };
        t.m = {
          id: _util.OPS.moveTo,
          numArgs: 2,
          variableArgs: false
        };
        t.l = {
          id: _util.OPS.lineTo,
          numArgs: 2,
          variableArgs: false
        };
        t.c = {
          id: _util.OPS.curveTo,
          numArgs: 6,
          variableArgs: false
        };
        t.v = {
          id: _util.OPS.curveTo2,
          numArgs: 4,
          variableArgs: false
        };
        t.y = {
          id: _util.OPS.curveTo3,
          numArgs: 4,
          variableArgs: false
        };
        t.h = {
          id: _util.OPS.closePath,
          numArgs: 0,
          variableArgs: false
        };
        t.re = {
          id: _util.OPS.rectangle,
          numArgs: 4,
          variableArgs: false
        };
        t.S = {
          id: _util.OPS.stroke,
          numArgs: 0,
          variableArgs: false
        };
        t.s = {
          id: _util.OPS.closeStroke,
          numArgs: 0,
          variableArgs: false
        };
        t.f = {
          id: _util.OPS.fill,
          numArgs: 0,
          variableArgs: false
        };
        t.F = {
          id: _util.OPS.fill,
          numArgs: 0,
          variableArgs: false
        };
        t["f*"] = {
          id: _util.OPS.eoFill,
          numArgs: 0,
          variableArgs: false
        };
        t.B = {
          id: _util.OPS.fillStroke,
          numArgs: 0,
          variableArgs: false
        };
        t["B*"] = {
          id: _util.OPS.eoFillStroke,
          numArgs: 0,
          variableArgs: false
        };
        t.b = {
          id: _util.OPS.closeFillStroke,
          numArgs: 0,
          variableArgs: false
        };
        t["b*"] = {
          id: _util.OPS.closeEOFillStroke,
          numArgs: 0,
          variableArgs: false
        };
        t.n = {
          id: _util.OPS.endPath,
          numArgs: 0,
          variableArgs: false
        };
        t.W = {
          id: _util.OPS.clip,
          numArgs: 0,
          variableArgs: false
        };
        t["W*"] = {
          id: _util.OPS.eoClip,
          numArgs: 0,
          variableArgs: false
        };
        t.BT = {
          id: _util.OPS.beginText,
          numArgs: 0,
          variableArgs: false
        };
        t.ET = {
          id: _util.OPS.endText,
          numArgs: 0,
          variableArgs: false
        };
        t.Tc = {
          id: _util.OPS.setCharSpacing,
          numArgs: 1,
          variableArgs: false
        };
        t.Tw = {
          id: _util.OPS.setWordSpacing,
          numArgs: 1,
          variableArgs: false
        };
        t.Tz = {
          id: _util.OPS.setHScale,
          numArgs: 1,
          variableArgs: false
        };
        t.TL = {
          id: _util.OPS.setLeading,
          numArgs: 1,
          variableArgs: false
        };
        t.Tf = {
          id: _util.OPS.setFont,
          numArgs: 2,
          variableArgs: false
        };
        t.Tr = {
          id: _util.OPS.setTextRenderingMode,
          numArgs: 1,
          variableArgs: false
        };
        t.Ts = {
          id: _util.OPS.setTextRise,
          numArgs: 1,
          variableArgs: false
        };
        t.Td = {
          id: _util.OPS.moveText,
          numArgs: 2,
          variableArgs: false
        };
        t.TD = {
          id: _util.OPS.setLeadingMoveText,
          numArgs: 2,
          variableArgs: false
        };
        t.Tm = {
          id: _util.OPS.setTextMatrix,
          numArgs: 6,
          variableArgs: false
        };
        t["T*"] = {
          id: _util.OPS.nextLine,
          numArgs: 0,
          variableArgs: false
        };
        t.Tj = {
          id: _util.OPS.showText,
          numArgs: 1,
          variableArgs: false
        };
        t.TJ = {
          id: _util.OPS.showSpacedText,
          numArgs: 1,
          variableArgs: false
        };
        t["'"] = {
          id: _util.OPS.nextLineShowText,
          numArgs: 1,
          variableArgs: false
        };
        t['"'] = {
          id: _util.OPS.nextLineSetSpacingShowText,
          numArgs: 3,
          variableArgs: false
        };
        t.d0 = {
          id: _util.OPS.setCharWidth,
          numArgs: 2,
          variableArgs: false
        };
        t.d1 = {
          id: _util.OPS.setCharWidthAndBounds,
          numArgs: 6,
          variableArgs: false
        };
        t.CS = {
          id: _util.OPS.setStrokeColorSpace,
          numArgs: 1,
          variableArgs: false
        };
        t.cs = {
          id: _util.OPS.setFillColorSpace,
          numArgs: 1,
          variableArgs: false
        };
        t.SC = {
          id: _util.OPS.setStrokeColor,
          numArgs: 4,
          variableArgs: true
        };
        t.SCN = {
          id: _util.OPS.setStrokeColorN,
          numArgs: 33,
          variableArgs: true
        };
        t.sc = {
          id: _util.OPS.setFillColor,
          numArgs: 4,
          variableArgs: true
        };
        t.scn = {
          id: _util.OPS.setFillColorN,
          numArgs: 33,
          variableArgs: true
        };
        t.G = {
          id: _util.OPS.setStrokeGray,
          numArgs: 1,
          variableArgs: false
        };
        t.g = {
          id: _util.OPS.setFillGray,
          numArgs: 1,
          variableArgs: false
        };
        t.RG = {
          id: _util.OPS.setStrokeRGBColor,
          numArgs: 3,
          variableArgs: false
        };
        t.rg = {
          id: _util.OPS.setFillRGBColor,
          numArgs: 3,
          variableArgs: false
        };
        t.K = {
          id: _util.OPS.setStrokeCMYKColor,
          numArgs: 4,
          variableArgs: false
        };
        t.k = {
          id: _util.OPS.setFillCMYKColor,
          numArgs: 4,
          variableArgs: false
        };
        t.sh = {
          id: _util.OPS.shadingFill,
          numArgs: 1,
          variableArgs: false
        };
        t.BI = {
          id: _util.OPS.beginInlineImage,
          numArgs: 0,
          variableArgs: false
        };
        t.ID = {
          id: _util.OPS.beginImageData,
          numArgs: 0,
          variableArgs: false
        };
        t.EI = {
          id: _util.OPS.endInlineImage,
          numArgs: 1,
          variableArgs: false
        };
        t.Do = {
          id: _util.OPS.paintXObject,
          numArgs: 1,
          variableArgs: false
        };
        t.MP = {
          id: _util.OPS.markPoint,
          numArgs: 1,
          variableArgs: false
        };
        t.DP = {
          id: _util.OPS.markPointProps,
          numArgs: 2,
          variableArgs: false
        };
        t.BMC = {
          id: _util.OPS.beginMarkedContent,
          numArgs: 1,
          variableArgs: false
        };
        t.BDC = {
          id: _util.OPS.beginMarkedContentProps,
          numArgs: 2,
          variableArgs: false
        };
        t.EMC = {
          id: _util.OPS.endMarkedContent,
          numArgs: 0,
          variableArgs: false
        };
        t.BX = {
          id: _util.OPS.beginCompat,
          numArgs: 0,
          variableArgs: false
        };
        t.EX = {
          id: _util.OPS.endCompat,
          numArgs: 0,
          variableArgs: false
        };
        t.BM = null;
        t.BD = null;
        t["true"] = null;
        t.fa = null;
        t.fal = null;
        t.fals = null;
        t["false"] = null;
        t.nu = null;
        t.nul = null;
        t["null"] = null;
      });
      return (0, _util.shadow)(this, "opMap", getOPMap());
    }
  }, {
    key: "MAX_INVALID_PATH_OPS",
    get: function get() {
      return (0, _util.shadow)(this, "MAX_INVALID_PATH_OPS", 20);
    }
  }]);

  return EvaluatorPreprocessor;
}();

exports.EvaluatorPreprocessor = EvaluatorPreprocessor;

/***/ }),
/* 124 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.IdentityCMap = exports.CMapFactory = exports.CMap = void 0;

var _regenerator = _interopRequireDefault(__w_pdfjs_require__(2));

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

var _parser = __w_pdfjs_require__(125);

var _core_utils = __w_pdfjs_require__(117);

var _stream = __w_pdfjs_require__(118);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var BUILT_IN_CMAPS = ["Adobe-GB1-UCS2", "Adobe-CNS1-UCS2", "Adobe-Japan1-UCS2", "Adobe-Korea1-UCS2", "78-EUC-H", "78-EUC-V", "78-H", "78-RKSJ-H", "78-RKSJ-V", "78-V", "78ms-RKSJ-H", "78ms-RKSJ-V", "83pv-RKSJ-H", "90ms-RKSJ-H", "90ms-RKSJ-V", "90msp-RKSJ-H", "90msp-RKSJ-V", "90pv-RKSJ-H", "90pv-RKSJ-V", "Add-H", "Add-RKSJ-H", "Add-RKSJ-V", "Add-V", "Adobe-CNS1-0", "Adobe-CNS1-1", "Adobe-CNS1-2", "Adobe-CNS1-3", "Adobe-CNS1-4", "Adobe-CNS1-5", "Adobe-CNS1-6", "Adobe-GB1-0", "Adobe-GB1-1", "Adobe-GB1-2", "Adobe-GB1-3", "Adobe-GB1-4", "Adobe-GB1-5", "Adobe-Japan1-0", "Adobe-Japan1-1", "Adobe-Japan1-2", "Adobe-Japan1-3", "Adobe-Japan1-4", "Adobe-Japan1-5", "Adobe-Japan1-6", "Adobe-Korea1-0", "Adobe-Korea1-1", "Adobe-Korea1-2", "B5-H", "B5-V", "B5pc-H", "B5pc-V", "CNS-EUC-H", "CNS-EUC-V", "CNS1-H", "CNS1-V", "CNS2-H", "CNS2-V", "ETHK-B5-H", "ETHK-B5-V", "ETen-B5-H", "ETen-B5-V", "ETenms-B5-H", "ETenms-B5-V", "EUC-H", "EUC-V", "Ext-H", "Ext-RKSJ-H", "Ext-RKSJ-V", "Ext-V", "GB-EUC-H", "GB-EUC-V", "GB-H", "GB-V", "GBK-EUC-H", "GBK-EUC-V", "GBK2K-H", "GBK2K-V", "GBKp-EUC-H", "GBKp-EUC-V", "GBT-EUC-H", "GBT-EUC-V", "GBT-H", "GBT-V", "GBTpc-EUC-H", "GBTpc-EUC-V", "GBpc-EUC-H", "GBpc-EUC-V", "H", "HKdla-B5-H", "HKdla-B5-V", "HKdlb-B5-H", "HKdlb-B5-V", "HKgccs-B5-H", "HKgccs-B5-V", "HKm314-B5-H", "HKm314-B5-V", "HKm471-B5-H", "HKm471-B5-V", "HKscs-B5-H", "HKscs-B5-V", "Hankaku", "Hiragana", "KSC-EUC-H", "KSC-EUC-V", "KSC-H", "KSC-Johab-H", "KSC-Johab-V", "KSC-V", "KSCms-UHC-H", "KSCms-UHC-HW-H", "KSCms-UHC-HW-V", "KSCms-UHC-V", "KSCpc-EUC-H", "KSCpc-EUC-V", "Katakana", "NWP-H", "NWP-V", "RKSJ-H", "RKSJ-V", "Roman", "UniCNS-UCS2-H", "UniCNS-UCS2-V", "UniCNS-UTF16-H", "UniCNS-UTF16-V", "UniCNS-UTF32-H", "UniCNS-UTF32-V", "UniCNS-UTF8-H", "UniCNS-UTF8-V", "UniGB-UCS2-H", "UniGB-UCS2-V", "UniGB-UTF16-H", "UniGB-UTF16-V", "UniGB-UTF32-H", "UniGB-UTF32-V", "UniGB-UTF8-H", "UniGB-UTF8-V", "UniJIS-UCS2-H", "UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-V", "UniJIS-UCS2-V", "UniJIS-UTF16-H", "UniJIS-UTF16-V", "UniJIS-UTF32-H", "UniJIS-UTF32-V", "UniJIS-UTF8-H", "UniJIS-UTF8-V", "UniJIS2004-UTF16-H", "UniJIS2004-UTF16-V", "UniJIS2004-UTF32-H", "UniJIS2004-UTF32-V", "UniJIS2004-UTF8-H", "UniJIS2004-UTF8-V", "UniJISPro-UCS2-HW-V", "UniJISPro-UCS2-V", "UniJISPro-UTF8-V", "UniJISX0213-UTF32-H", "UniJISX0213-UTF32-V", "UniJISX02132004-UTF32-H", "UniJISX02132004-UTF32-V", "UniKS-UCS2-H", "UniKS-UCS2-V", "UniKS-UTF16-H", "UniKS-UTF16-V", "UniKS-UTF32-H", "UniKS-UTF32-V", "UniKS-UTF8-H", "UniKS-UTF8-V", "V", "WP-Symbol"];
var MAX_MAP_RANGE = Math.pow(2, 24) - 1;

var CMap = /*#__PURE__*/function () {
  function CMap() {
    var builtInCMap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

    _classCallCheck(this, CMap);

    this.codespaceRanges = [[], [], [], []];
    this.numCodespaceRanges = 0;
    this._map = [];
    this.name = "";
    this.vertical = false;
    this.useCMap = null;
    this.builtInCMap = builtInCMap;
  }

  _createClass(CMap, [{
    key: "addCodespaceRange",
    value: function addCodespaceRange(n, low, high) {
      this.codespaceRanges[n - 1].push(low, high);
      this.numCodespaceRanges++;
    }
  }, {
    key: "mapCidRange",
    value: function mapCidRange(low, high, dstLow) {
      if (high - low > MAX_MAP_RANGE) {
        throw new Error("mapCidRange - ignoring data above MAX_MAP_RANGE.");
      }

      while (low <= high) {
        this._map[low++] = dstLow++;
      }
    }
  }, {
    key: "mapBfRange",
    value: function mapBfRange(low, high, dstLow) {
      if (high - low > MAX_MAP_RANGE) {
        throw new Error("mapBfRange - ignoring data above MAX_MAP_RANGE.");
      }

      var lastByte = dstLow.length - 1;

      while (low <= high) {
        this._map[low++] = dstLow;
        dstLow = dstLow.substring(0, lastByte) + String.fromCharCode(dstLow.charCodeAt(lastByte) + 1);
      }
    }
  }, {
    key: "mapBfRangeToArray",
    value: function mapBfRangeToArray(low, high, array) {
      if (high - low > MAX_MAP_RANGE) {
        throw new Error("mapBfRangeToArray - ignoring data above MAX_MAP_RANGE.");
      }

      var ii = array.length;
      var i = 0;

      while (low <= high && i < ii) {
        this._map[low] = array[i++];
        ++low;
      }
    }
  }, {
    key: "mapOne",
    value: function mapOne(src, dst) {
      this._map[src] = dst;
    }
  }, {
    key: "lookup",
    value: function lookup(code) {
      return this._map[code];
    }
  }, {
    key: "contains",
    value: function contains(code) {
      return this._map[code] !== undefined;
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var map = this._map;
      var length = map.length;

      if (length <= 0x10000) {
        for (var i = 0; i < length; i++) {
          if (map[i] !== undefined) {
            callback(i, map[i]);
          }
        }
      } else {
        for (var _i in map) {
          callback(_i, map[_i]);
        }
      }
    }
  }, {
    key: "charCodeOf",
    value: function charCodeOf(value) {
      var map = this._map;

      if (map.length <= 0x10000) {
        return map.indexOf(value);
      }

      for (var charCode in map) {
        if (map[charCode] === value) {
          return charCode | 0;
        }
      }

      return -1;
    }
  }, {
    key: "getMap",
    value: function getMap() {
      return this._map;
    }
  }, {
    key: "readCharCode",
    value: function readCharCode(str, offset, out) {
      var c = 0;
      var codespaceRanges = this.codespaceRanges;

      for (var n = 0, nn = codespaceRanges.length; n < nn; n++) {
        c = (c << 8 | str.charCodeAt(offset + n)) >>> 0;
        var codespaceRange = codespaceRanges[n];

        for (var k = 0, kk = codespaceRange.length; k < kk;) {
          var low = codespaceRange[k++];
          var high = codespaceRange[k++];

          if (c >= low && c <= high) {
            out.charcode = c;
            out.length = n + 1;
            return;
          }
        }
      }

      out.charcode = 0;
      out.length = 1;
    }
  }, {
    key: "getCharCodeLength",
    value: function getCharCodeLength(charCode) {
      var codespaceRanges = this.codespaceRanges;

      for (var n = 0, nn = codespaceRanges.length; n < nn; n++) {
        var codespaceRange = codespaceRanges[n];

        for (var k = 0, kk = codespaceRange.length; k < kk;) {
          var low = codespaceRange[k++];
          var high = codespaceRange[k++];

          if (charCode >= low && charCode <= high) {
            return n + 1;
          }
        }
      }

      return 1;
    }
  }, {
    key: "length",
    get: function get() {
      return this._map.length;
    }
  }, {
    key: "isIdentityCMap",
    get: function get() {
      if (!(this.name === "Identity-H" || this.name === "Identity-V")) {
        return false;
      }

      if (this._map.length !== 0x10000) {
        return false;
      }

      for (var i = 0; i < 0x10000; i++) {
        if (this._map[i] !== i) {
          return false;
        }
      }

      return true;
    }
  }]);

  return CMap;
}();

exports.CMap = CMap;

var IdentityCMap = /*#__PURE__*/function (_CMap) {
  _inherits(IdentityCMap, _CMap);

  var _super = _createSuper(IdentityCMap);

  function IdentityCMap(vertical, n) {
    var _this;

    _classCallCheck(this, IdentityCMap);

    _this = _super.call(this);
    _this.vertical = vertical;

    _this.addCodespaceRange(n, 0, 0xffff);

    return _this;
  }

  _createClass(IdentityCMap, [{
    key: "mapCidRange",
    value: function mapCidRange(low, high, dstLow) {
      (0, _util.unreachable)("should not call mapCidRange");
    }
  }, {
    key: "mapBfRange",
    value: function mapBfRange(low, high, dstLow) {
      (0, _util.unreachable)("should not call mapBfRange");
    }
  }, {
    key: "mapBfRangeToArray",
    value: function mapBfRangeToArray(low, high, array) {
      (0, _util.unreachable)("should not call mapBfRangeToArray");
    }
  }, {
    key: "mapOne",
    value: function mapOne(src, dst) {
      (0, _util.unreachable)("should not call mapCidOne");
    }
  }, {
    key: "lookup",
    value: function lookup(code) {
      return Number.isInteger(code) && code <= 0xffff ? code : undefined;
    }
  }, {
    key: "contains",
    value: function contains(code) {
      return Number.isInteger(code) && code <= 0xffff;
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      for (var i = 0; i <= 0xffff; i++) {
        callback(i, i);
      }
    }
  }, {
    key: "charCodeOf",
    value: function charCodeOf(value) {
      return Number.isInteger(value) && value <= 0xffff ? value : -1;
    }
  }, {
    key: "getMap",
    value: function getMap() {
      var map = new Array(0x10000);

      for (var i = 0; i <= 0xffff; i++) {
        map[i] = i;
      }

      return map;
    }
  }, {
    key: "length",
    get: function get() {
      return 0x10000;
    }
  }, {
    key: "isIdentityCMap",
    get: function get() {
      (0, _util.unreachable)("should not access .isIdentityCMap");
    }
  }]);

  return IdentityCMap;
}(CMap);

exports.IdentityCMap = IdentityCMap;

var BinaryCMapReader = function BinaryCMapReaderClosure() {
  function hexToInt(a, size) {
    var n = 0;

    for (var i = 0; i <= size; i++) {
      n = n << 8 | a[i];
    }

    return n >>> 0;
  }

  function hexToStr(a, size) {
    if (size === 1) {
      return String.fromCharCode(a[0], a[1]);
    }

    if (size === 3) {
      return String.fromCharCode(a[0], a[1], a[2], a[3]);
    }

    return String.fromCharCode.apply(null, a.subarray(0, size + 1));
  }

  function addHex(a, b, size) {
    var c = 0;

    for (var i = size; i >= 0; i--) {
      c += a[i] + b[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  function incHex(a, size) {
    var c = 1;

    for (var i = size; i >= 0 && c > 0; i--) {
      c += a[i];
      a[i] = c & 255;
      c >>= 8;
    }
  }

  var MAX_NUM_SIZE = 16;
  var MAX_ENCODED_NUM_SIZE = 19;

  var BinaryCMapStream = /*#__PURE__*/function () {
    function BinaryCMapStream(data) {
      _classCallCheck(this, BinaryCMapStream);

      this.buffer = data;
      this.pos = 0;
      this.end = data.length;
      this.tmpBuf = new Uint8Array(MAX_ENCODED_NUM_SIZE);
    }

    _createClass(BinaryCMapStream, [{
      key: "readByte",
      value: function readByte() {
        if (this.pos >= this.end) {
          return -1;
        }

        return this.buffer[this.pos++];
      }
    }, {
      key: "readNumber",
      value: function readNumber() {
        var n = 0;
        var last;

        do {
          var b = this.readByte();

          if (b < 0) {
            throw new _util.FormatError("unexpected EOF in bcmap");
          }

          last = !(b & 0x80);
          n = n << 7 | b & 0x7f;
        } while (!last);

        return n;
      }
    }, {
      key: "readSigned",
      value: function readSigned() {
        var n = this.readNumber();
        return n & 1 ? ~(n >>> 1) : n >>> 1;
      }
    }, {
      key: "readHex",
      value: function readHex(num, size) {
        num.set(this.buffer.subarray(this.pos, this.pos + size + 1));
        this.pos += size + 1;
      }
    }, {
      key: "readHexNumber",
      value: function readHexNumber(num, size) {
        var last;
        var stack = this.tmpBuf;
        var sp = 0;

        do {
          var b = this.readByte();

          if (b < 0) {
            throw new _util.FormatError("unexpected EOF in bcmap");
          }

          last = !(b & 0x80);
          stack[sp++] = b & 0x7f;
        } while (!last);

        var i = size,
            buffer = 0,
            bufferSize = 0;

        while (i >= 0) {
          while (bufferSize < 8 && stack.length > 0) {
            buffer = stack[--sp] << bufferSize | buffer;
            bufferSize += 7;
          }

          num[i] = buffer & 255;
          i--;
          buffer >>= 8;
          bufferSize -= 8;
        }
      }
    }, {
      key: "readHexSigned",
      value: function readHexSigned(num, size) {
        this.readHexNumber(num, size);
        var sign = num[size] & 1 ? 255 : 0;
        var c = 0;

        for (var i = 0; i <= size; i++) {
          c = (c & 1) << 8 | num[i];
          num[i] = c >> 1 ^ sign;
        }
      }
    }, {
      key: "readString",
      value: function readString() {
        var len = this.readNumber();
        var s = "";

        for (var i = 0; i < len; i++) {
          s += String.fromCharCode(this.readNumber());
        }

        return s;
      }
    }]);

    return BinaryCMapStream;
  }();

  var BinaryCMapReader = /*#__PURE__*/function () {
    function BinaryCMapReader() {
      _classCallCheck(this, BinaryCMapReader);
    }

    _createClass(BinaryCMapReader, [{
      key: "process",
      value: function () {
        var _process = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee(data, cMap, extend) {
          var stream, header, useCMap, start, end, _char, charCode, tmp, code, b, type, sequence, dataSize, ucs2DataSize, subitemsCount, i, _i2, _i3, _i4, _i5, _i6;

          return _regenerator["default"].wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  stream = new BinaryCMapStream(data);
                  header = stream.readByte();
                  cMap.vertical = !!(header & 1);
                  useCMap = null;
                  start = new Uint8Array(MAX_NUM_SIZE);
                  end = new Uint8Array(MAX_NUM_SIZE);
                  _char = new Uint8Array(MAX_NUM_SIZE);
                  charCode = new Uint8Array(MAX_NUM_SIZE);
                  tmp = new Uint8Array(MAX_NUM_SIZE);

                case 9:
                  if (!((b = stream.readByte()) >= 0)) {
                    _context.next = 68;
                    break;
                  }

                  type = b >> 5;

                  if (!(type === 7)) {
                    _context.next = 20;
                    break;
                  }

                  _context.t0 = b & 0x1f;
                  _context.next = _context.t0 === 0 ? 15 : _context.t0 === 1 ? 17 : 19;
                  break;

                case 15:
                  stream.readString();
                  return _context.abrupt("break", 19);

                case 17:
                  useCMap = stream.readString();
                  return _context.abrupt("break", 19);

                case 19:
                  return _context.abrupt("continue", 9);

                case 20:
                  sequence = !!(b & 0x10);
                  dataSize = b & 15;

                  if (!(dataSize + 1 > MAX_NUM_SIZE)) {
                    _context.next = 24;
                    break;
                  }

                  throw new Error("BinaryCMapReader.process: Invalid dataSize.");

                case 24:
                  ucs2DataSize = 1;
                  subitemsCount = stream.readNumber();
                  _context.t1 = type;
                  _context.next = _context.t1 === 0 ? 29 : _context.t1 === 1 ? 35 : _context.t1 === 2 ? 41 : _context.t1 === 3 ? 46 : _context.t1 === 4 ? 53 : _context.t1 === 5 ? 58 : 65;
                  break;

                case 29:
                  stream.readHex(start, dataSize);
                  stream.readHexNumber(end, dataSize);
                  addHex(end, start, dataSize);
                  cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize), hexToInt(end, dataSize));

                  for (i = 1; i < subitemsCount; i++) {
                    incHex(end, dataSize);
                    stream.readHexNumber(start, dataSize);
                    addHex(start, end, dataSize);
                    stream.readHexNumber(end, dataSize);
                    addHex(end, start, dataSize);
                    cMap.addCodespaceRange(dataSize + 1, hexToInt(start, dataSize), hexToInt(end, dataSize));
                  }

                  return _context.abrupt("break", 66);

                case 35:
                  stream.readHex(start, dataSize);
                  stream.readHexNumber(end, dataSize);
                  addHex(end, start, dataSize);
                  stream.readNumber();

                  for (_i2 = 1; _i2 < subitemsCount; _i2++) {
                    incHex(end, dataSize);
                    stream.readHexNumber(start, dataSize);
                    addHex(start, end, dataSize);
                    stream.readHexNumber(end, dataSize);
                    addHex(end, start, dataSize);
                    stream.readNumber();
                  }

                  return _context.abrupt("break", 66);

                case 41:
                  stream.readHex(_char, dataSize);
                  code = stream.readNumber();
                  cMap.mapOne(hexToInt(_char, dataSize), code);

                  for (_i3 = 1; _i3 < subitemsCount; _i3++) {
                    incHex(_char, dataSize);

                    if (!sequence) {
                      stream.readHexNumber(tmp, dataSize);
                      addHex(_char, tmp, dataSize);
                    }

                    code = stream.readSigned() + (code + 1);
                    cMap.mapOne(hexToInt(_char, dataSize), code);
                  }

                  return _context.abrupt("break", 66);

                case 46:
                  stream.readHex(start, dataSize);
                  stream.readHexNumber(end, dataSize);
                  addHex(end, start, dataSize);
                  code = stream.readNumber();
                  cMap.mapCidRange(hexToInt(start, dataSize), hexToInt(end, dataSize), code);

                  for (_i4 = 1; _i4 < subitemsCount; _i4++) {
                    incHex(end, dataSize);

                    if (!sequence) {
                      stream.readHexNumber(start, dataSize);
                      addHex(start, end, dataSize);
                    } else {
                      start.set(end);
                    }

                    stream.readHexNumber(end, dataSize);
                    addHex(end, start, dataSize);
                    code = stream.readNumber();
                    cMap.mapCidRange(hexToInt(start, dataSize), hexToInt(end, dataSize), code);
                  }

                  return _context.abrupt("break", 66);

                case 53:
                  stream.readHex(_char, ucs2DataSize);
                  stream.readHex(charCode, dataSize);
                  cMap.mapOne(hexToInt(_char, ucs2DataSize), hexToStr(charCode, dataSize));

                  for (_i5 = 1; _i5 < subitemsCount; _i5++) {
                    incHex(_char, ucs2DataSize);

                    if (!sequence) {
                      stream.readHexNumber(tmp, ucs2DataSize);
                      addHex(_char, tmp, ucs2DataSize);
                    }

                    incHex(charCode, dataSize);
                    stream.readHexSigned(tmp, dataSize);
                    addHex(charCode, tmp, dataSize);
                    cMap.mapOne(hexToInt(_char, ucs2DataSize), hexToStr(charCode, dataSize));
                  }

                  return _context.abrupt("break", 66);

                case 58:
                  stream.readHex(start, ucs2DataSize);
                  stream.readHexNumber(end, ucs2DataSize);
                  addHex(end, start, ucs2DataSize);
                  stream.readHex(charCode, dataSize);
                  cMap.mapBfRange(hexToInt(start, ucs2DataSize), hexToInt(end, ucs2DataSize), hexToStr(charCode, dataSize));

                  for (_i6 = 1; _i6 < subitemsCount; _i6++) {
                    incHex(end, ucs2DataSize);

                    if (!sequence) {
                      stream.readHexNumber(start, ucs2DataSize);
                      addHex(start, end, ucs2DataSize);
                    } else {
                      start.set(end);
                    }

                    stream.readHexNumber(end, ucs2DataSize);
                    addHex(end, start, ucs2DataSize);
                    stream.readHex(charCode, dataSize);
                    cMap.mapBfRange(hexToInt(start, ucs2DataSize), hexToInt(end, ucs2DataSize), hexToStr(charCode, dataSize));
                  }

                  return _context.abrupt("break", 66);

                case 65:
                  throw new Error("BinaryCMapReader.process - unknown type: ".concat(type));

                case 66:
                  _context.next = 9;
                  break;

                case 68:
                  if (!useCMap) {
                    _context.next = 70;
                    break;
                  }

                  return _context.abrupt("return", extend(useCMap));

                case 70:
                  return _context.abrupt("return", cMap);

                case 71:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        function process(_x, _x2, _x3) {
          return _process.apply(this, arguments);
        }

        return process;
      }()
    }]);

    return BinaryCMapReader;
  }();

  return BinaryCMapReader;
}();

var CMapFactory = function CMapFactoryClosure() {
  function strToInt(str) {
    var a = 0;

    for (var i = 0; i < str.length; i++) {
      a = a << 8 | str.charCodeAt(i);
    }

    return a >>> 0;
  }

  function expectString(obj) {
    if (!(0, _util.isString)(obj)) {
      throw new _util.FormatError("Malformed CMap: expected string.");
    }
  }

  function expectInt(obj) {
    if (!Number.isInteger(obj)) {
      throw new _util.FormatError("Malformed CMap: expected int.");
    }
  }

  function parseBfChar(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();

      if ((0, _primitives.isEOF)(obj)) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endbfchar")) {
        return;
      }

      expectString(obj);
      var src = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      var dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseBfRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();

      if ((0, _primitives.isEOF)(obj)) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endbfrange")) {
        return;
      }

      expectString(obj);
      var low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      var high = strToInt(obj);
      obj = lexer.getObj();

      if (Number.isInteger(obj) || (0, _util.isString)(obj)) {
        var dstLow = Number.isInteger(obj) ? String.fromCharCode(obj) : obj;
        cMap.mapBfRange(low, high, dstLow);
      } else if ((0, _primitives.isCmd)(obj, "[")) {
        obj = lexer.getObj();
        var array = [];

        while (!(0, _primitives.isCmd)(obj, "]") && !(0, _primitives.isEOF)(obj)) {
          array.push(obj);
          obj = lexer.getObj();
        }

        cMap.mapBfRangeToArray(low, high, array);
      } else {
        break;
      }
    }

    throw new _util.FormatError("Invalid bf range.");
  }

  function parseCidChar(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();

      if ((0, _primitives.isEOF)(obj)) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcidchar")) {
        return;
      }

      expectString(obj);
      var src = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      var dst = obj;
      cMap.mapOne(src, dst);
    }
  }

  function parseCidRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();

      if ((0, _primitives.isEOF)(obj)) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcidrange")) {
        return;
      }

      expectString(obj);
      var low = strToInt(obj);
      obj = lexer.getObj();
      expectString(obj);
      var high = strToInt(obj);
      obj = lexer.getObj();
      expectInt(obj);
      var dstLow = obj;
      cMap.mapCidRange(low, high, dstLow);
    }
  }

  function parseCodespaceRange(cMap, lexer) {
    while (true) {
      var obj = lexer.getObj();

      if ((0, _primitives.isEOF)(obj)) {
        break;
      }

      if ((0, _primitives.isCmd)(obj, "endcodespacerange")) {
        return;
      }

      if (!(0, _util.isString)(obj)) {
        break;
      }

      var low = strToInt(obj);
      obj = lexer.getObj();

      if (!(0, _util.isString)(obj)) {
        break;
      }

      var high = strToInt(obj);
      cMap.addCodespaceRange(obj.length, low, high);
    }

    throw new _util.FormatError("Invalid codespace range.");
  }

  function parseWMode(cMap, lexer) {
    var obj = lexer.getObj();

    if (Number.isInteger(obj)) {
      cMap.vertical = !!obj;
    }
  }

  function parseCMapName(cMap, lexer) {
    var obj = lexer.getObj();

    if ((0, _primitives.isName)(obj) && (0, _util.isString)(obj.name)) {
      cMap.name = obj.name;
    }
  }

  function parseCMap(_x4, _x5, _x6, _x7) {
    return _parseCMap.apply(this, arguments);
  }

  function _parseCMap() {
    _parseCMap = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee3(cMap, lexer, fetchBuiltInCMap, useCMap) {
      var previous, embeddedUseCMap, obj;
      return _regenerator["default"].wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              if (false) {}

              _context3.prev = 1;
              obj = lexer.getObj();

              if (!(0, _primitives.isEOF)(obj)) {
                _context3.next = 7;
                break;
              }

              return _context3.abrupt("break", 39);

            case 7:
              if (!(0, _primitives.isName)(obj)) {
                _context3.next = 12;
                break;
              }

              if (obj.name === "WMode") {
                parseWMode(cMap, lexer);
              } else if (obj.name === "CMapName") {
                parseCMapName(cMap, lexer);
              }

              previous = obj;
              _context3.next = 29;
              break;

            case 12:
              if (!(0, _primitives.isCmd)(obj)) {
                _context3.next = 29;
                break;
              }

              _context3.t0 = obj.cmd;
              _context3.next = _context3.t0 === "endcmap" ? 16 : _context3.t0 === "usecmap" ? 17 : _context3.t0 === "begincodespacerange" ? 19 : _context3.t0 === "beginbfchar" ? 21 : _context3.t0 === "begincidchar" ? 23 : _context3.t0 === "beginbfrange" ? 25 : _context3.t0 === "begincidrange" ? 27 : 29;
              break;

            case 16:
              return _context3.abrupt("break", 39);

            case 17:
              if ((0, _primitives.isName)(previous)) {
                embeddedUseCMap = previous.name;
              }

              return _context3.abrupt("break", 29);

            case 19:
              parseCodespaceRange(cMap, lexer);
              return _context3.abrupt("break", 29);

            case 21:
              parseBfChar(cMap, lexer);
              return _context3.abrupt("break", 29);

            case 23:
              parseCidChar(cMap, lexer);
              return _context3.abrupt("break", 29);

            case 25:
              parseBfRange(cMap, lexer);
              return _context3.abrupt("break", 29);

            case 27:
              parseCidRange(cMap, lexer);
              return _context3.abrupt("break", 29);

            case 29:
              _context3.next = 37;
              break;

            case 31:
              _context3.prev = 31;
              _context3.t1 = _context3["catch"](1);

              if (!(_context3.t1 instanceof _core_utils.MissingDataException)) {
                _context3.next = 35;
                break;
              }

              throw _context3.t1;

            case 35:
              (0, _util.warn)("Invalid cMap data: " + _context3.t1);
              return _context3.abrupt("continue", 0);

            case 37:
              _context3.next = 0;
              break;

            case 39:
              if (!useCMap && embeddedUseCMap) {
                useCMap = embeddedUseCMap;
              }

              if (!useCMap) {
                _context3.next = 42;
                break;
              }

              return _context3.abrupt("return", extendCMap(cMap, fetchBuiltInCMap, useCMap));

            case 42:
              return _context3.abrupt("return", cMap);

            case 43:
            case "end":
              return _context3.stop();
          }
        }
      }, _callee3, null, [[1, 31]]);
    }));
    return _parseCMap.apply(this, arguments);
  }

  function extendCMap(_x8, _x9, _x10) {
    return _extendCMap.apply(this, arguments);
  }

  function _extendCMap() {
    _extendCMap = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee4(cMap, fetchBuiltInCMap, useCMap) {
      var useCodespaceRanges, i;
      return _regenerator["default"].wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return createBuiltInCMap(useCMap, fetchBuiltInCMap);

            case 2:
              cMap.useCMap = _context4.sent;

              if (cMap.numCodespaceRanges === 0) {
                useCodespaceRanges = cMap.useCMap.codespaceRanges;

                for (i = 0; i < useCodespaceRanges.length; i++) {
                  cMap.codespaceRanges[i] = useCodespaceRanges[i].slice();
                }

                cMap.numCodespaceRanges = cMap.useCMap.numCodespaceRanges;
              }

              cMap.useCMap.forEach(function (key, value) {
                if (!cMap.contains(key)) {
                  cMap.mapOne(key, cMap.useCMap.lookup(key));
                }
              });
              return _context4.abrupt("return", cMap);

            case 6:
            case "end":
              return _context4.stop();
          }
        }
      }, _callee4);
    }));
    return _extendCMap.apply(this, arguments);
  }

  function createBuiltInCMap(_x11, _x12) {
    return _createBuiltInCMap.apply(this, arguments);
  }

  function _createBuiltInCMap() {
    _createBuiltInCMap = _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee5(name, fetchBuiltInCMap) {
      var _yield$fetchBuiltInCM, cMapData, compressionType, cMap, lexer;

      return _regenerator["default"].wrap(function _callee5$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              if (!(name === "Identity-H")) {
                _context5.next = 4;
                break;
              }

              return _context5.abrupt("return", new IdentityCMap(false, 2));

            case 4:
              if (!(name === "Identity-V")) {
                _context5.next = 6;
                break;
              }

              return _context5.abrupt("return", new IdentityCMap(true, 2));

            case 6:
              if (BUILT_IN_CMAPS.includes(name)) {
                _context5.next = 8;
                break;
              }

              throw new Error("Unknown CMap name: " + name);

            case 8:
              if (fetchBuiltInCMap) {
                _context5.next = 10;
                break;
              }

              throw new Error("Built-in CMap parameters are not provided.");

            case 10:
              _context5.next = 12;
              return fetchBuiltInCMap(name);

            case 12:
              _yield$fetchBuiltInCM = _context5.sent;
              cMapData = _yield$fetchBuiltInCM.cMapData;
              compressionType = _yield$fetchBuiltInCM.compressionType;
              cMap = new CMap(true);

              if (!(compressionType === _util.CMapCompressionType.BINARY)) {
                _context5.next = 18;
                break;
              }

              return _context5.abrupt("return", new BinaryCMapReader().process(cMapData, cMap, function (useCMap) {
                return extendCMap(cMap, fetchBuiltInCMap, useCMap);
              }));

            case 18:
              if (!(compressionType === _util.CMapCompressionType.NONE)) {
                _context5.next = 21;
                break;
              }

              lexer = new _parser.Lexer(new _stream.Stream(cMapData));
              return _context5.abrupt("return", parseCMap(cMap, lexer, fetchBuiltInCMap, null));

            case 21:
              throw new Error("TODO: Only BINARY/NONE CMap compression is currently supported.");

            case 22:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee5);
    }));
    return _createBuiltInCMap.apply(this, arguments);
  }

  return {
    create: function create(params) {
      return _asyncToGenerator( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
        var encoding, fetchBuiltInCMap, useCMap, parsedCMap;
        return _regenerator["default"].wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                encoding = params.encoding;
                fetchBuiltInCMap = params.fetchBuiltInCMap;
                useCMap = params.useCMap;

                if (!(0, _primitives.isName)(encoding)) {
                  _context2.next = 7;
                  break;
                }

                return _context2.abrupt("return", createBuiltInCMap(encoding.name, fetchBuiltInCMap));

              case 7:
                if (!(0, _primitives.isStream)(encoding)) {
                  _context2.next = 14;
                  break;
                }

                _context2.next = 10;
                return parseCMap(new CMap(), new _parser.Lexer(encoding), fetchBuiltInCMap, useCMap);

              case 10:
                parsedCMap = _context2.sent;

                if (!parsedCMap.isIdentityCMap) {
                  _context2.next = 13;
                  break;
                }

                return _context2.abrupt("return", createBuiltInCMap(parsedCMap.name, fetchBuiltInCMap));

              case 13:
                return _context2.abrupt("return", parsedCMap);

              case 14:
                throw new Error("Encoding required.");

              case 15:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }))();
    }
  };
}();

exports.CMapFactory = CMapFactory;

/***/ }),
/* 125 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Parser = exports.Linearization = exports.Lexer = void 0;

var _util = __w_pdfjs_require__(4);

var _primitives = __w_pdfjs_require__(113);

var _core_utils = __w_pdfjs_require__(117);

var _ascii_85_stream = __w_pdfjs_require__(126);

var _ascii_hex_stream = __w_pdfjs_require__(128);

var _ccitt_stream = __w_pdfjs_require__(129);

var _flate_stream = __w_pdfjs_require__(131);

var _jbig2_stream = __w_pdfjs_require__(132);

var _jpeg_stream = __w_pdfjs_require__(135);

var _jpx_stream = __w_pdfjs_require__(137);

var _lzw_stream = __w_pdfjs_require__(139);

var _stream = __w_pdfjs_require__(118);

var _predictor_stream = __w_pdfjs_require__(140);

var _run_length_stream = __w_pdfjs_require__(141);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var MAX_LENGTH_TO_CACHE = 1000;
var MAX_ADLER32_LENGTH = 5552;

function computeAdler32(bytes) {
  var bytesLength = bytes.length;
  var a = 1,
      b = 0;

  for (var i = 0; i < bytesLength; ++i) {
    a += bytes[i] & 0xff;
    b += a;
  }

  return b % 65521 << 16 | a % 65521;
}

var Parser = /*#__PURE__*/function () {
  function Parser(_ref) {
    var lexer = _ref.lexer,
        xref = _ref.xref,
        _ref$allowStreams = _ref.allowStreams,
        allowStreams = _ref$allowStreams === void 0 ? false : _ref$allowStreams,
        _ref$recoveryMode = _ref.recoveryMode,
        recoveryMode = _ref$recoveryMode === void 0 ? false : _ref$recoveryMode;

    _classCallCheck(this, Parser);

    this.lexer = lexer;
    this.xref = xref;
    this.allowStreams = allowStreams;
    this.recoveryMode = recoveryMode;
    this.imageCache = Object.create(null);
    this.refill();
  }

  _createClass(Parser, [{
    key: "refill",
    value: function refill() {
      this.buf1 = this.lexer.getObj();
      this.buf2 = this.lexer.getObj();
    }
  }, {
    key: "shift",
    value: function shift() {
      if (this.buf2 instanceof _primitives.Cmd && this.buf2.cmd === "ID") {
        this.buf1 = this.buf2;
        this.buf2 = null;
      } else {
        this.buf1 = this.buf2;
        this.buf2 = this.lexer.getObj();
      }
    }
  }, {
    key: "tryShift",
    value: function tryShift() {
      try {
        this.shift();
        return true;
      } catch (e) {
        if (e instanceof _core_utils.MissingDataException) {
          throw e;
        }

        return false;
      }
    }
  }, {
    key: "getObj",
    value: function getObj() {
      var cipherTransform = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var buf1 = this.buf1;
      this.shift();

      if (buf1 instanceof _primitives.Cmd) {
        switch (buf1.cmd) {
          case "BI":
            return this.makeInlineImage(cipherTransform);

          case "[":
            var array = [];

            while (!(0, _primitives.isCmd)(this.buf1, "]") && !(0, _primitives.isEOF)(this.buf1)) {
              array.push(this.getObj(cipherTransform));
            }

            if ((0, _primitives.isEOF)(this.buf1)) {
              if (!this.recoveryMode) {
                throw new _util.FormatError("End of file inside array");
              }

              return array;
            }

            this.shift();
            return array;

          case "<<":
            var dict = new _primitives.Dict(this.xref);

            while (!(0, _primitives.isCmd)(this.buf1, ">>") && !(0, _primitives.isEOF)(this.buf1)) {
              if (!(0, _primitives.isName)(this.buf1)) {
                (0, _util.info)("Malformed dictionary: key must be a name object");
                this.shift();
                continue;
              }

              var key = this.buf1.name;
              this.shift();

              if ((0, _primitives.isEOF)(this.buf1)) {
                break;
              }

              dict.set(key, this.getObj(cipherTransform));
            }

            if ((0, _primitives.isEOF)(this.buf1)) {
              if (!this.recoveryMode) {
                throw new _util.FormatError("End of file inside dictionary");
              }

              return dict;
            }

            if ((0, _primitives.isCmd)(this.buf2, "stream")) {
              return this.allowStreams ? this.makeStream(dict, cipherTransform) : dict;
            }

            this.shift();
            return dict;

          default:
            return buf1;
        }
      }

      if (Number.isInteger(buf1)) {
        if (Number.isInteger(this.buf1) && (0, _primitives.isCmd)(this.buf2, "R")) {
          var ref = _primitives.Ref.get(buf1, this.buf1);

          this.shift();
          this.shift();
          return ref;
        }

        return buf1;
      }

      if (typeof buf1 === "string") {
        if (cipherTransform) {
          return cipherTransform.decryptString(buf1);
        }

        return buf1;
      }

      return buf1;
    }
  }, {
    key: "findDefaultInlineStreamEnd",
    value: function findDefaultInlineStreamEnd(stream) {
      var E = 0x45,
          I = 0x49,
          SPACE = 0x20,
          LF = 0xa,
          CR = 0xd,
          NUL = 0x0;
      var lexer = this.lexer,
          startPos = stream.pos,
          n = 10;
      var state = 0,
          ch,
          maybeEIPos;

      while ((ch = stream.getByte()) !== -1) {
        if (state === 0) {
          state = ch === E ? 1 : 0;
        } else if (state === 1) {
          state = ch === I ? 2 : 0;
        } else {
          (0, _util.assert)(state === 2, "findDefaultInlineStreamEnd - invalid state.");

          if (ch === SPACE || ch === LF || ch === CR) {
            maybeEIPos = stream.pos;
            var followingBytes = stream.peekBytes(n);

            for (var i = 0, ii = followingBytes.length; i < ii; i++) {
              ch = followingBytes[i];

              if (ch === NUL && followingBytes[i + 1] !== NUL) {
                continue;
              }

              if (ch !== LF && ch !== CR && (ch < SPACE || ch > 0x7f)) {
                state = 0;
                break;
              }
            }

            if (state !== 2) {
              continue;
            }

            if (lexer.knownCommands) {
              var nextObj = lexer.peekObj();

              if (nextObj instanceof _primitives.Cmd && !lexer.knownCommands[nextObj.cmd]) {
                state = 0;
              }
            } else {
              (0, _util.warn)("findDefaultInlineStreamEnd - `lexer.knownCommands` is undefined.");
            }

            if (state === 2) {
              break;
            }
          } else {
            state = 0;
          }
        }
      }

      if (ch === -1) {
        (0, _util.warn)("findDefaultInlineStreamEnd: " + "Reached the end of the stream without finding a valid EI marker");

        if (maybeEIPos) {
          (0, _util.warn)('... trying to recover by using the last "EI" occurrence.');
          stream.skip(-(stream.pos - maybeEIPos));
        }
      }

      var endOffset = 4;
      stream.skip(-endOffset);
      ch = stream.peekByte();
      stream.skip(endOffset);

      if (!(0, _core_utils.isWhiteSpace)(ch)) {
        endOffset--;
      }

      return stream.pos - endOffset - startPos;
    }
  }, {
    key: "findDCTDecodeInlineStreamEnd",
    value: function findDCTDecodeInlineStreamEnd(stream) {
      var startPos = stream.pos;
      var foundEOI = false,
          b,
          markerLength;

      while ((b = stream.getByte()) !== -1) {
        if (b !== 0xff) {
          continue;
        }

        switch (stream.getByte()) {
          case 0x00:
            break;

          case 0xff:
            stream.skip(-1);
            break;

          case 0xd9:
            foundEOI = true;
            break;

          case 0xc0:
          case 0xc1:
          case 0xc2:
          case 0xc3:
          case 0xc5:
          case 0xc6:
          case 0xc7:
          case 0xc9:
          case 0xca:
          case 0xcb:
          case 0xcd:
          case 0xce:
          case 0xcf:
          case 0xc4:
          case 0xcc:
          case 0xda:
          case 0xdb:
          case 0xdc:
          case 0xdd:
          case 0xde:
          case 0xdf:
          case 0xe0:
          case 0xe1:
          case 0xe2:
          case 0xe3:
          case 0xe4:
          case 0xe5:
          case 0xe6:
          case 0xe7:
          case 0xe8:
          case 0xe9:
          case 0xea:
          case 0xeb:
          case 0xec:
          case 0xed:
          case 0xee:
          case 0xef:
          case 0xfe:
            markerLength = stream.getUint16();

            if (markerLength > 2) {
              stream.skip(markerLength - 2);
            } else {
              stream.skip(-2);
            }

            break;
        }

        if (foundEOI) {
          break;
        }
      }

      var length = stream.pos - startPos;

      if (b === -1) {
        (0, _util.warn)("Inline DCTDecode image stream: " + "EOI marker not found, searching for /EI/ instead.");
        stream.skip(-length);
        return this.findDefaultInlineStreamEnd(stream);
      }

      this.inlineStreamSkipEI(stream);
      return length;
    }
  }, {
    key: "findASCII85DecodeInlineStreamEnd",
    value: function findASCII85DecodeInlineStreamEnd(stream) {
      var TILDE = 0x7e,
          GT = 0x3e;
      var startPos = stream.pos;
      var ch;

      while ((ch = stream.getByte()) !== -1) {
        if (ch === TILDE) {
          var tildePos = stream.pos;
          ch = stream.peekByte();

          while ((0, _core_utils.isWhiteSpace)(ch)) {
            stream.skip();
            ch = stream.peekByte();
          }

          if (ch === GT) {
            stream.skip();
            break;
          }

          if (stream.pos > tildePos) {
            var maybeEI = stream.peekBytes(2);

            if (maybeEI[0] === 0x45 && maybeEI[1] === 0x49) {
              break;
            }
          }
        }
      }

      var length = stream.pos - startPos;

      if (ch === -1) {
        (0, _util.warn)("Inline ASCII85Decode image stream: " + "EOD marker not found, searching for /EI/ instead.");
        stream.skip(-length);
        return this.findDefaultInlineStreamEnd(stream);
      }

      this.inlineStreamSkipEI(stream);
      return length;
    }
  }, {
    key: "findASCIIHexDecodeInlineStreamEnd",
    value: function findASCIIHexDecodeInlineStreamEnd(stream) {
      var GT = 0x3e;
      var startPos = stream.pos;
      var ch;

      while ((ch = stream.getByte()) !== -1) {
        if (ch === GT) {
          break;
        }
      }

      var length = stream.pos - startPos;

      if (ch === -1) {
        (0, _util.warn)("Inline ASCIIHexDecode image stream: " + "EOD marker not found, searching for /EI/ instead.");
        stream.skip(-length);
        return this.findDefaultInlineStreamEnd(stream);
      }

      this.inlineStreamSkipEI(stream);
      return length;
    }
  }, {
    key: "inlineStreamSkipEI",
    value: function inlineStreamSkipEI(stream) {
      var E = 0x45,
          I = 0x49;
      var state = 0,
          ch;

      while ((ch = stream.getByte()) !== -1) {
        if (state === 0) {
          state = ch === E ? 1 : 0;
        } else if (state === 1) {
          state = ch === I ? 2 : 0;
        } else if (state === 2) {
          break;
        }
      }
    }
  }, {
    key: "makeInlineImage",
    value: function makeInlineImage(cipherTransform) {
      var lexer = this.lexer;
      var stream = lexer.stream;
      var dict = new _primitives.Dict(this.xref);
      var dictLength;

      while (!(0, _primitives.isCmd)(this.buf1, "ID") && !(0, _primitives.isEOF)(this.buf1)) {
        if (!(0, _primitives.isName)(this.buf1)) {
          throw new _util.FormatError("Dictionary key must be a name object");
        }

        var key = this.buf1.name;
        this.shift();

        if ((0, _primitives.isEOF)(this.buf1)) {
          break;
        }

        dict.set(key, this.getObj(cipherTransform));
      }

      if (lexer.beginInlineImagePos !== -1) {
        dictLength = stream.pos - lexer.beginInlineImagePos;
      }

      var filter = dict.get("Filter", "F");
      var filterName;

      if ((0, _primitives.isName)(filter)) {
        filterName = filter.name;
      } else if (Array.isArray(filter)) {
        var filterZero = this.xref.fetchIfRef(filter[0]);

        if ((0, _primitives.isName)(filterZero)) {
          filterName = filterZero.name;
        }
      }

      var startPos = stream.pos;
      var length;

      if (filterName === "DCTDecode" || filterName === "DCT") {
        length = this.findDCTDecodeInlineStreamEnd(stream);
      } else if (filterName === "ASCII85Decode" || filterName === "A85") {
        length = this.findASCII85DecodeInlineStreamEnd(stream);
      } else if (filterName === "ASCIIHexDecode" || filterName === "AHx") {
        length = this.findASCIIHexDecodeInlineStreamEnd(stream);
      } else {
        length = this.findDefaultInlineStreamEnd(stream);
      }

      var imageStream = stream.makeSubStream(startPos, length, dict);
      var cacheKey;

      if (length < MAX_LENGTH_TO_CACHE && dictLength < MAX_ADLER32_LENGTH) {
        var imageBytes = imageStream.getBytes();
        imageStream.reset();
        var initialStreamPos = stream.pos;
        stream.pos = lexer.beginInlineImagePos;
        var dictBytes = stream.getBytes(dictLength);
        stream.pos = initialStreamPos;
        cacheKey = computeAdler32(imageBytes) + "_" + computeAdler32(dictBytes);
        var cacheEntry = this.imageCache[cacheKey];

        if (cacheEntry !== undefined) {
          this.buf2 = _primitives.Cmd.get("EI");
          this.shift();
          cacheEntry.reset();
          return cacheEntry;
        }
      }

      if (cipherTransform) {
        imageStream = cipherTransform.createStream(imageStream, length);
      }

      imageStream = this.filter(imageStream, dict, length);
      imageStream.dict = dict;

      if (cacheKey !== undefined) {
        imageStream.cacheKey = "inline_".concat(length, "_").concat(cacheKey);
        this.imageCache[cacheKey] = imageStream;
      }

      this.buf2 = _primitives.Cmd.get("EI");
      this.shift();
      return imageStream;
    }
  }, {
    key: "_findStreamLength",
    value: function _findStreamLength(startPos, signature) {
      var stream = this.lexer.stream;
      stream.pos = startPos;
      var SCAN_BLOCK_LENGTH = 2048;
      var signatureLength = signature.length;

      while (stream.pos < stream.end) {
        var scanBytes = stream.peekBytes(SCAN_BLOCK_LENGTH);
        var scanLength = scanBytes.length - signatureLength;

        if (scanLength <= 0) {
          break;
        }

        var pos = 0;

        while (pos < scanLength) {
          var j = 0;

          while (j < signatureLength && scanBytes[pos + j] === signature[j]) {
            j++;
          }

          if (j >= signatureLength) {
            stream.pos += pos;
            return stream.pos - startPos;
          }

          pos++;
        }

        stream.pos += scanLength;
      }

      return -1;
    }
  }, {
    key: "makeStream",
    value: function makeStream(dict, cipherTransform) {
      var lexer = this.lexer;
      var stream = lexer.stream;
      lexer.skipToNextLine();
      var startPos = stream.pos - 1;
      var length = dict.get("Length");

      if (!Number.isInteger(length)) {
        (0, _util.info)("Bad length \"".concat(length, "\" in stream"));
        length = 0;
      }

      stream.pos = startPos + length;
      lexer.nextChar();

      if (this.tryShift() && (0, _primitives.isCmd)(this.buf2, "endstream")) {
        this.shift();
      } else {
        var ENDSTREAM_SIGNATURE = new Uint8Array([0x65, 0x6e, 0x64, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d]);

        var actualLength = this._findStreamLength(startPos, ENDSTREAM_SIGNATURE);

        if (actualLength < 0) {
          var MAX_TRUNCATION = 1;

          for (var i = 1; i <= MAX_TRUNCATION; i++) {
            var end = ENDSTREAM_SIGNATURE.length - i;
            var TRUNCATED_SIGNATURE = ENDSTREAM_SIGNATURE.slice(0, end);

            var maybeLength = this._findStreamLength(startPos, TRUNCATED_SIGNATURE);

            if (maybeLength >= 0) {
              var lastByte = stream.peekBytes(end + 1)[end];

              if (!(0, _core_utils.isWhiteSpace)(lastByte)) {
                break;
              }

              (0, _util.info)("Found \"".concat((0, _util.bytesToString)(TRUNCATED_SIGNATURE), "\" when ") + "searching for endstream command.");
              actualLength = maybeLength;
              break;
            }
          }

          if (actualLength < 0) {
            throw new _util.FormatError("Missing endstream command.");
          }
        }

        length = actualLength;
        lexer.nextChar();
        this.shift();
        this.shift();
      }

      this.shift();
      stream = stream.makeSubStream(startPos, length, dict);

      if (cipherTransform) {
        stream = cipherTransform.createStream(stream, length);
      }

      stream = this.filter(stream, dict, length);
      stream.dict = dict;
      return stream;
    }
  }, {
    key: "filter",
    value: function filter(stream, dict, length) {
      var filter = dict.get("Filter", "F");
      var params = dict.get("DecodeParms", "DP");

      if ((0, _primitives.isName)(filter)) {
        if (Array.isArray(params)) {
          (0, _util.warn)("/DecodeParms should not contain an Array, " + "when /Filter contains a Name.");
        }

        return this.makeFilter(stream, filter.name, length, params);
      }

      var maybeLength = length;

      if (Array.isArray(filter)) {
        var filterArray = filter;
        var paramsArray = params;

        for (var i = 0, ii = filterArray.length; i < ii; ++i) {
          filter = this.xref.fetchIfRef(filterArray[i]);

          if (!(0, _primitives.isName)(filter)) {
            throw new _util.FormatError("Bad filter name \"".concat(filter, "\""));
          }

          params = null;

          if (Array.isArray(paramsArray) && i in paramsArray) {
            params = this.xref.fetchIfRef(paramsArray[i]);
          }

          stream = this.makeFilter(stream, filter.name, maybeLength, params);
          maybeLength = null;
        }
      }

      return stream;
    }
  }, {
    key: "makeFilter",
    value: function makeFilter(stream, name, maybeLength, params) {
      if (maybeLength === 0) {
        (0, _util.warn)("Empty \"".concat(name, "\" stream."));
        return new _stream.NullStream();
      }

      try {
        var xrefStreamStats = this.xref.stats.streamTypes;

        if (name === "FlateDecode" || name === "Fl") {
          xrefStreamStats[_util.StreamType.FLATE] = true;

          if (params) {
            return new _predictor_stream.PredictorStream(new _flate_stream.FlateStream(stream, maybeLength), maybeLength, params);
          }

          return new _flate_stream.FlateStream(stream, maybeLength);
        }

        if (name === "LZWDecode" || name === "LZW") {
          xrefStreamStats[_util.StreamType.LZW] = true;
          var earlyChange = 1;

          if (params) {
            if (params.has("EarlyChange")) {
              earlyChange = params.get("EarlyChange");
            }

            return new _predictor_stream.PredictorStream(new _lzw_stream.LZWStream(stream, maybeLength, earlyChange), maybeLength, params);
          }

          return new _lzw_stream.LZWStream(stream, maybeLength, earlyChange);
        }

        if (name === "DCTDecode" || name === "DCT") {
          xrefStreamStats[_util.StreamType.DCT] = true;
          return new _jpeg_stream.JpegStream(stream, maybeLength, params);
        }

        if (name === "JPXDecode" || name === "JPX") {
          xrefStreamStats[_util.StreamType.JPX] = true;
          return new _jpx_stream.JpxStream(stream, maybeLength, params);
        }

        if (name === "ASCII85Decode" || name === "A85") {
          xrefStreamStats[_util.StreamType.A85] = true;
          return new _ascii_85_stream.Ascii85Stream(stream, maybeLength);
        }

        if (name === "ASCIIHexDecode" || name === "AHx") {
          xrefStreamStats[_util.StreamType.AHX] = true;
          return new _ascii_hex_stream.AsciiHexStream(stream, maybeLength);
        }

        if (name === "CCITTFaxDecode" || name === "CCF") {
          xrefStreamStats[_util.StreamType.CCF] = true;
          return new _ccitt_stream.CCITTFaxStream(stream, maybeLength, params);
        }

        if (name === "RunLengthDecode" || name === "RL") {
          xrefStreamStats[_util.StreamType.RLX] = true;
          return new _run_length_stream.RunLengthStream(stream, maybeLength);
        }

        if (name === "JBIG2Decode") {
          xrefStreamStats[_util.StreamType.JBIG] = true;
          return new _jbig2_stream.Jbig2Stream(stream, maybeLength, params);
        }

        (0, _util.warn)("Filter \"".concat(name, "\" is not supported."));
        return stream;
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }

        (0, _util.warn)("Invalid stream: \"".concat(ex, "\""));
        return new _stream.NullStream();
      }
    }
  }]);

  return Parser;
}();

exports.Parser = Parser;
var specialChars = [1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 2, 0, 0, 2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];

function toHexDigit(ch) {
  if (ch >= 0x30 && ch <= 0x39) {
    return ch & 0x0f;
  }

  if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
    return (ch & 0x0f) + 9;
  }

  return -1;
}

var Lexer = /*#__PURE__*/function () {
  function Lexer(stream) {
    var knownCommands = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

    _classCallCheck(this, Lexer);

    this.stream = stream;
    this.nextChar();
    this.strBuf = [];
    this.knownCommands = knownCommands;
    this._hexStringNumWarn = 0;
    this.beginInlineImagePos = -1;
  }

  _createClass(Lexer, [{
    key: "nextChar",
    value: function nextChar() {
      return this.currentChar = this.stream.getByte();
    }
  }, {
    key: "peekChar",
    value: function peekChar() {
      return this.stream.peekByte();
    }
  }, {
    key: "getNumber",
    value: function getNumber() {
      var ch = this.currentChar;
      var eNotation = false;
      var divideBy = 0;
      var sign = 0;

      if (ch === 0x2d) {
        sign = -1;
        ch = this.nextChar();

        if (ch === 0x2d) {
          ch = this.nextChar();
        }
      } else if (ch === 0x2b) {
        sign = 1;
        ch = this.nextChar();
      }

      if (ch === 0x0a || ch === 0x0d) {
        do {
          ch = this.nextChar();
        } while (ch === 0x0a || ch === 0x0d);
      }

      if (ch === 0x2e) {
        divideBy = 10;
        ch = this.nextChar();
      }

      if (ch < 0x30 || ch > 0x39) {
        if (divideBy === 10 && sign === 0 && ((0, _core_utils.isWhiteSpace)(ch) || ch === -1)) {
          (0, _util.warn)("Lexer.getNumber - treating a single decimal point as zero.");
          return 0;
        }

        throw new _util.FormatError("Invalid number: ".concat(String.fromCharCode(ch), " (charCode ").concat(ch, ")"));
      }

      sign = sign || 1;
      var baseValue = ch - 0x30;
      var powerValue = 0;
      var powerValueSign = 1;

      while ((ch = this.nextChar()) >= 0) {
        if (ch >= 0x30 && ch <= 0x39) {
          var currentDigit = ch - 0x30;

          if (eNotation) {
            powerValue = powerValue * 10 + currentDigit;
          } else {
            if (divideBy !== 0) {
              divideBy *= 10;
            }

            baseValue = baseValue * 10 + currentDigit;
          }
        } else if (ch === 0x2e) {
          if (divideBy === 0) {
            divideBy = 1;
          } else {
            break;
          }
        } else if (ch === 0x2d) {
          (0, _util.warn)("Badly formatted number: minus sign in the middle");
        } else if (ch === 0x45 || ch === 0x65) {
          ch = this.peekChar();

          if (ch === 0x2b || ch === 0x2d) {
            powerValueSign = ch === 0x2d ? -1 : 1;
            this.nextChar();
          } else if (ch < 0x30 || ch > 0x39) {
            break;
          }

          eNotation = true;
        } else {
          break;
        }
      }

      if (divideBy !== 0) {
        baseValue /= divideBy;
      }

      if (eNotation) {
        baseValue *= Math.pow(10, powerValueSign * powerValue);
      }

      return sign * baseValue;
    }
  }, {
    key: "getString",
    value: function getString() {
      var numParen = 1;
      var done = false;
      var strBuf = this.strBuf;
      strBuf.length = 0;
      var ch = this.nextChar();

      while (true) {
        var charBuffered = false;

        switch (ch | 0) {
          case -1:
            (0, _util.warn)("Unterminated string");
            done = true;
            break;

          case 0x28:
            ++numParen;
            strBuf.push("(");
            break;

          case 0x29:
            if (--numParen === 0) {
              this.nextChar();
              done = true;
            } else {
              strBuf.push(")");
            }

            break;

          case 0x5c:
            ch = this.nextChar();

            switch (ch) {
              case -1:
                (0, _util.warn)("Unterminated string");
                done = true;
                break;

              case 0x6e:
                strBuf.push("\n");
                break;

              case 0x72:
                strBuf.push("\r");
                break;

              case 0x74:
                strBuf.push("\t");
                break;

              case 0x62:
                strBuf.push("\b");
                break;

              case 0x66:
                strBuf.push("\f");
                break;

              case 0x5c:
              case 0x28:
              case 0x29:
                strBuf.push(String.fromCharCode(ch));
                break;

              case 0x30:
              case 0x31:
              case 0x32:
              case 0x33:
              case 0x34:
              case 0x35:
              case 0x36:
              case 0x37:
                var x = ch & 0x0f;
                ch = this.nextChar();
                charBuffered = true;

                if (ch >= 0x30 && ch <= 0x37) {
                  x = (x << 3) + (ch & 0x0f);
                  ch = this.nextChar();

                  if (ch >= 0x30 && ch <= 0x37) {
                    charBuffered = false;
                    x = (x << 3) + (ch & 0x0f);
                  }
                }

                strBuf.push(String.fromCharCode(x));
                break;

              case 0x0d:
                if (this.peekChar() === 0x0a) {
                  this.nextChar();
                }

                break;

              case 0x0a:
                break;

              default:
                strBuf.push(String.fromCharCode(ch));
                break;
            }

            break;

          default:
            strBuf.push(String.fromCharCode(ch));
            break;
        }

        if (done) {
          break;
        }

        if (!charBuffered) {
          ch = this.nextChar();
        }
      }

      return strBuf.join("");
    }
  }, {
    key: "getName",
    value: function getName() {
      var ch, previousCh;
      var strBuf = this.strBuf;
      strBuf.length = 0;

      while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
        if (ch === 0x23) {
          ch = this.nextChar();

          if (specialChars[ch]) {
            (0, _util.warn)("Lexer_getName: " + "NUMBER SIGN (#) should be followed by a hexadecimal number.");
            strBuf.push("#");
            break;
          }

          var x = toHexDigit(ch);

          if (x !== -1) {
            previousCh = ch;
            ch = this.nextChar();
            var x2 = toHexDigit(ch);

            if (x2 === -1) {
              (0, _util.warn)("Lexer_getName: Illegal digit (".concat(String.fromCharCode(ch), ") ") + "in hexadecimal number.");
              strBuf.push("#", String.fromCharCode(previousCh));

              if (specialChars[ch]) {
                break;
              }

              strBuf.push(String.fromCharCode(ch));
              continue;
            }

            strBuf.push(String.fromCharCode(x << 4 | x2));
          } else {
            strBuf.push("#", String.fromCharCode(ch));
          }
        } else {
          strBuf.push(String.fromCharCode(ch));
        }
      }

      if (strBuf.length > 127) {
        (0, _util.warn)("Name token is longer than allowed by the spec: ".concat(strBuf.length));
      }

      return _primitives.Name.get(strBuf.join(""));
    }
  }, {
    key: "_hexStringWarn",
    value: function _hexStringWarn(ch) {
      var MAX_HEX_STRING_NUM_WARN = 5;

      if (this._hexStringNumWarn++ === MAX_HEX_STRING_NUM_WARN) {
        (0, _util.warn)("getHexString - ignoring additional invalid characters.");
        return;
      }

      if (this._hexStringNumWarn > MAX_HEX_STRING_NUM_WARN) {
        return;
      }

      (0, _util.warn)("getHexString - ignoring invalid character: ".concat(ch));
    }
  }, {
    key: "getHexString",
    value: function getHexString() {
      var strBuf = this.strBuf;
      strBuf.length = 0;
      var ch = this.currentChar;
      var isFirstHex = true;
      var firstDigit, secondDigit;
      this._hexStringNumWarn = 0;

      while (true) {
        if (ch < 0) {
          (0, _util.warn)("Unterminated hex string");
          break;
        } else if (ch === 0x3e) {
          this.nextChar();
          break;
        } else if (specialChars[ch] === 1) {
          ch = this.nextChar();
          continue;
        } else {
          if (isFirstHex) {
            firstDigit = toHexDigit(ch);

            if (firstDigit === -1) {
              this._hexStringWarn(ch);

              ch = this.nextChar();
              continue;
            }
          } else {
            secondDigit = toHexDigit(ch);

            if (secondDigit === -1) {
              this._hexStringWarn(ch);

              ch = this.nextChar();
              continue;
            }

            strBuf.push(String.fromCharCode(firstDigit << 4 | secondDigit));
          }

          isFirstHex = !isFirstHex;
          ch = this.nextChar();
        }
      }

      return strBuf.join("");
    }
  }, {
    key: "getObj",
    value: function getObj() {
      var comment = false;
      var ch = this.currentChar;

      while (true) {
        if (ch < 0) {
          return _primitives.EOF;
        }

        if (comment) {
          if (ch === 0x0a || ch === 0x0d) {
            comment = false;
          }
        } else if (ch === 0x25) {
          comment = true;
        } else if (specialChars[ch] !== 1) {
          break;
        }

        ch = this.nextChar();
      }

      switch (ch | 0) {
        case 0x30:
        case 0x31:
        case 0x32:
        case 0x33:
        case 0x34:
        case 0x35:
        case 0x36:
        case 0x37:
        case 0x38:
        case 0x39:
        case 0x2b:
        case 0x2d:
        case 0x2e:
          return this.getNumber();

        case 0x28:
          return this.getString();

        case 0x2f:
          return this.getName();

        case 0x5b:
          this.nextChar();
          return _primitives.Cmd.get("[");

        case 0x5d:
          this.nextChar();
          return _primitives.Cmd.get("]");

        case 0x3c:
          ch = this.nextChar();

          if (ch === 0x3c) {
            this.nextChar();
            return _primitives.Cmd.get("<<");
          }

          return this.getHexString();

        case 0x3e:
          ch = this.nextChar();

          if (ch === 0x3e) {
            this.nextChar();
            return _primitives.Cmd.get(">>");
          }

          return _primitives.Cmd.get(">");

        case 0x7b:
          this.nextChar();
          return _primitives.Cmd.get("{");

        case 0x7d:
          this.nextChar();
          return _primitives.Cmd.get("}");

        case 0x29:
          this.nextChar();
          throw new _util.FormatError("Illegal character: ".concat(ch));
      }

      var str = String.fromCharCode(ch);
      var knownCommands = this.knownCommands;
      var knownCommandFound = knownCommands && knownCommands[str] !== undefined;

      while ((ch = this.nextChar()) >= 0 && !specialChars[ch]) {
        var possibleCommand = str + String.fromCharCode(ch);

        if (knownCommandFound && knownCommands[possibleCommand] === undefined) {
          break;
        }

        if (str.length === 128) {
          throw new _util.FormatError("Command token too long: ".concat(str.length));
        }

        str = possibleCommand;
        knownCommandFound = knownCommands && knownCommands[str] !== undefined;
      }

      if (str === "true") {
        return true;
      }

      if (str === "false") {
        return false;
      }

      if (str === "null") {
        return null;
      }

      if (str === "BI") {
        this.beginInlineImagePos = this.stream.pos;
      }

      return _primitives.Cmd.get(str);
    }
  }, {
    key: "peekObj",
    value: function peekObj() {
      var streamPos = this.stream.pos,
          currentChar = this.currentChar,
          beginInlineImagePos = this.beginInlineImagePos;
      var nextObj;

      try {
        nextObj = this.getObj();
      } catch (ex) {
        if (ex instanceof _core_utils.MissingDataException) {
          throw ex;
        }

        (0, _util.warn)("peekObj: ".concat(ex));
      }

      this.stream.pos = streamPos;
      this.currentChar = currentChar;
      this.beginInlineImagePos = beginInlineImagePos;
      return nextObj;
    }
  }, {
    key: "skipToNextLine",
    value: function skipToNextLine() {
      var ch = this.currentChar;

      while (ch >= 0) {
        if (ch === 0x0d) {
          ch = this.nextChar();

          if (ch === 0x0a) {
            this.nextChar();
          }

          break;
        } else if (ch === 0x0a) {
          this.nextChar();
          break;
        }

        ch = this.nextChar();
      }
    }
  }]);

  return Lexer;
}();

exports.Lexer = Lexer;

var Linearization = /*#__PURE__*/function () {
  function Linearization() {
    _classCallCheck(this, Linearization);
  }

  _createClass(Linearization, null, [{
    key: "create",
    value: function create(stream) {
      function getInt(linDict, name) {
        var allowZeroValue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        var obj = linDict.get(name);

        if (Number.isInteger(obj) && (allowZeroValue ? obj >= 0 : obj > 0)) {
          return obj;
        }

        throw new Error("The \"".concat(name, "\" parameter in the linearization ") + "dictionary is invalid.");
      }

      function getHints(linDict) {
        var hints = linDict.get("H");
        var hintsLength;

        if (Array.isArray(hints) && ((hintsLength = hints.length) === 2 || hintsLength === 4)) {
          for (var index = 0; index < hintsLength; index++) {
            var hint = hints[index];

            if (!(Number.isInteger(hint) && hint > 0)) {
              throw new Error("Hint (".concat(index, ") in the linearization dictionary is invalid."));
            }
          }

          return hints;
        }

        throw new Error("Hint array in the linearization dictionary is invalid.");
      }

      var parser = new Parser({
        lexer: new Lexer(stream),
        xref: null
      });
      var obj1 = parser.getObj();
      var obj2 = parser.getObj();
      var obj3 = parser.getObj();
      var linDict = parser.getObj();
      var obj, length;

      if (!(Number.isInteger(obj1) && Number.isInteger(obj2) && (0, _primitives.isCmd)(obj3, "obj") && (0, _primitives.isDict)(linDict) && (0, _util.isNum)(obj = linDict.get("Linearized")) && obj > 0)) {
        return null;
      } else if ((length = getInt(linDict, "L")) !== stream.length) {
        throw new Error('The "L" parameter in the linearization dictionary ' + "does not equal the stream length.");
      }

      return {
        length: length,
        hints: getHints(linDict),
        objectNumberFirst: getInt(linDict, "O"),
        endFirst: getInt(linDict, "E"),
        numPages: getInt(linDict, "N"),
        mainXRefEntriesOffset: getInt(linDict, "T"),
        pageFirst: linDict.has("P") ? getInt(linDict, "P", true) : 0
      };
    }
  }]);

  return Linearization;
}();

exports.Linearization = Linearization;

/***/ }),
/* 126 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Ascii85Stream = void 0;

var _decode_stream = __w_pdfjs_require__(127);

var _core_utils = __w_pdfjs_require__(117);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Ascii85Stream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(Ascii85Stream, _DecodeStream);

  var _super = _createSuper(Ascii85Stream);

  function Ascii85Stream(str, maybeLength) {
    var _this;

    _classCallCheck(this, Ascii85Stream);

    if (maybeLength) {
      maybeLength = 0.8 * maybeLength;
    }

    _this = _super.call(this, maybeLength);
    _this.str = str;
    _this.dict = str.dict;
    _this.input = new Uint8Array(5);
    return _this;
  }

  _createClass(Ascii85Stream, [{
    key: "readBlock",
    value: function readBlock() {
      var TILDA_CHAR = 0x7e;
      var Z_LOWER_CHAR = 0x7a;
      var EOF = -1;
      var str = this.str;
      var c = str.getByte();

      while ((0, _core_utils.isWhiteSpace)(c)) {
        c = str.getByte();
      }

      if (c === EOF || c === TILDA_CHAR) {
        this.eof = true;
        return;
      }

      var bufferLength = this.bufferLength;
      var buffer, i;

      if (c === Z_LOWER_CHAR) {
        buffer = this.ensureBuffer(bufferLength + 4);

        for (i = 0; i < 4; ++i) {
          buffer[bufferLength + i] = 0;
        }

        this.bufferLength += 4;
      } else {
        var input = this.input;
        input[0] = c;

        for (i = 1; i < 5; ++i) {
          c = str.getByte();

          while ((0, _core_utils.isWhiteSpace)(c)) {
            c = str.getByte();
          }

          input[i] = c;

          if (c === EOF || c === TILDA_CHAR) {
            break;
          }
        }

        buffer = this.ensureBuffer(bufferLength + i - 1);
        this.bufferLength += i - 1;

        if (i < 5) {
          for (; i < 5; ++i) {
            input[i] = 0x21 + 84;
          }

          this.eof = true;
        }

        var t = 0;

        for (i = 0; i < 5; ++i) {
          t = t * 85 + (input[i] - 0x21);
        }

        for (i = 3; i >= 0; --i) {
          buffer[bufferLength + i] = t & 0xff;
          t >>= 8;
        }
      }
    }
  }]);

  return Ascii85Stream;
}(_decode_stream.DecodeStream);

exports.Ascii85Stream = Ascii85Stream;

/***/ }),
/* 127 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.StreamsSequenceStream = exports.DecodeStream = void 0;

var _base_stream = __w_pdfjs_require__(114);

var _stream = __w_pdfjs_require__(118);

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var emptyBuffer = new Uint8Array(0);

var DecodeStream = /*#__PURE__*/function (_BaseStream) {
  _inherits(DecodeStream, _BaseStream);

  var _super = _createSuper(DecodeStream);

  function DecodeStream(maybeMinBufferLength) {
    var _this;

    _classCallCheck(this, DecodeStream);

    _this = _super.call(this);
    _this._rawMinBufferLength = maybeMinBufferLength || 0;
    _this.pos = 0;
    _this.bufferLength = 0;
    _this.eof = false;
    _this.buffer = emptyBuffer;
    _this.minBufferLength = 512;

    if (maybeMinBufferLength) {
      while (_this.minBufferLength < maybeMinBufferLength) {
        _this.minBufferLength *= 2;
      }
    }

    return _this;
  }

  _createClass(DecodeStream, [{
    key: "isEmpty",
    get: function get() {
      while (!this.eof && this.bufferLength === 0) {
        this.readBlock();
      }

      return this.bufferLength === 0;
    }
  }, {
    key: "ensureBuffer",
    value: function ensureBuffer(requested) {
      var buffer = this.buffer;

      if (requested <= buffer.byteLength) {
        return buffer;
      }

      var size = this.minBufferLength;

      while (size < requested) {
        size *= 2;
      }

      var buffer2 = new Uint8Array(size);
      buffer2.set(buffer);
      return this.buffer = buffer2;
    }
  }, {
    key: "getByte",
    value: function getByte() {
      var pos = this.pos;

      while (this.bufferLength <= pos) {
        if (this.eof) {
          return -1;
        }

        this.readBlock();
      }

      return this.buffer[this.pos++];
    }
  }, {
    key: "getBytes",
    value: function getBytes(length) {
      var forceClamped = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var pos = this.pos;
      var end;

      if (length) {
        this.ensureBuffer(pos + length);
        end = pos + length;

        while (!this.eof && this.bufferLength < end) {
          this.readBlock();
        }

        var bufEnd = this.bufferLength;

        if (end > bufEnd) {
          end = bufEnd;
        }
      } else {
        while (!this.eof) {
          this.readBlock();
        }

        end = this.bufferLength;
      }

      this.pos = end;
      var subarray = this.buffer.subarray(pos, end);
      return forceClamped && !(subarray instanceof Uint8ClampedArray) ? new Uint8ClampedArray(subarray) : subarray;
    }
  }, {
    key: "reset",
    value: function reset() {
      this.pos = 0;
    }
  }, {
    key: "makeSubStream",
    value: function makeSubStream(start, length) {
      var dict = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      if (length === undefined) {
        while (!this.eof) {
          this.readBlock();
        }
      } else {
        var end = start + length;

        while (this.bufferLength <= end && !this.eof) {
          this.readBlock();
        }
      }

      return new _stream.Stream(this.buffer, start, length, dict);
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      return this.str ? this.str.getBaseStreams() : null;
    }
  }]);

  return DecodeStream;
}(_base_stream.BaseStream);

exports.DecodeStream = DecodeStream;

var StreamsSequenceStream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(StreamsSequenceStream, _DecodeStream);

  var _super2 = _createSuper(StreamsSequenceStream);

  function StreamsSequenceStream(streams) {
    var _this2;

    _classCallCheck(this, StreamsSequenceStream);

    var maybeLength = 0;

    var _iterator = _createForOfIteratorHelper(streams),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var stream = _step.value;
        maybeLength += stream instanceof DecodeStream ? stream._rawMinBufferLength : stream.length;
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    _this2 = _super2.call(this, maybeLength);
    _this2.streams = streams;
    return _this2;
  }

  _createClass(StreamsSequenceStream, [{
    key: "readBlock",
    value: function readBlock() {
      var streams = this.streams;

      if (streams.length === 0) {
        this.eof = true;
        return;
      }

      var stream = streams.shift();
      var chunk = stream.getBytes();
      var bufferLength = this.bufferLength;
      var newLength = bufferLength + chunk.length;
      var buffer = this.ensureBuffer(newLength);
      buffer.set(chunk, bufferLength);
      this.bufferLength = newLength;
    }
  }, {
    key: "getBaseStreams",
    value: function getBaseStreams() {
      var baseStreamsBuf = [];

      var _iterator2 = _createForOfIteratorHelper(this.streams),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var stream = _step2.value;
          var baseStreams = stream.getBaseStreams();

          if (baseStreams) {
            baseStreamsBuf.push.apply(baseStreamsBuf, _toConsumableArray(baseStreams));
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      return baseStreamsBuf.length > 0 ? baseStreamsBuf : null;
    }
  }]);

  return StreamsSequenceStream;
}(DecodeStream);

exports.StreamsSequenceStream = StreamsSequenceStream;

/***/ }),
/* 128 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AsciiHexStream = void 0;

var _decode_stream = __w_pdfjs_require__(127);

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var AsciiHexStream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(AsciiHexStream, _DecodeStream);

  var _super = _createSuper(AsciiHexStream);

  function AsciiHexStream(str, maybeLength) {
    var _this;

    _classCallCheck(this, AsciiHexStream);

    if (maybeLength) {
      maybeLength = 0.5 * maybeLength;
    }

    _this = _super.call(this, maybeLength);
    _this.str = str;
    _this.dict = str.dict;
    _this.firstDigit = -1;
    return _this;
  }

  _createClass(AsciiHexStream, [{
    key: "readBlock",
    value: function readBlock() {
      var UPSTREAM_BLOCK_SIZE = 8000;
      var bytes = this.str.getBytes(UPSTREAM_BLOCK_SIZE);

      if (!bytes.length) {
        this.eof = true;
        return;
      }

      var maxDecodeLength = bytes.length + 1 >> 1;
      var buffer = this.ensureBuffer(this.bufferLength + maxDecodeLength);
      var bufferLength = this.bufferLength;
      var firstDigit = this.firstDigit;

      var _iterator = _createForOfIteratorHelper(bytes),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var ch = _step.value;
          var digit = void 0;

          if (ch >= 0x30 && ch <= 0x39) {
            digit = ch & 0x0f;
          } else if (ch >= 0x41 && ch <= 0x46 || ch >= 0x61 && ch <= 0x66) {
            digit = (ch & 0x0f) + 9;
          } else if (ch === 0x3e) {
            this.eof = true;
            break;
          } else {
            continue;
          }

          if (firstDigit < 0) {
            firstDigit = digit;
          } else {
            buffer[bufferLength++] = firstDigit << 4 | digit;
            firstDigit = -1;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (firstDigit >= 0 && this.eof) {
        buffer[bufferLength++] = firstDigit << 4;
        firstDigit = -1;
      }

      this.firstDigit = firstDigit;
      this.bufferLength = bufferLength;
    }
  }]);

  return AsciiHexStream;
}(_decode_stream.DecodeStream);

exports.AsciiHexStream = AsciiHexStream;

/***/ }),
/* 129 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CCITTFaxStream = void 0;

var _primitives = __w_pdfjs_require__(113);

var _ccitt = __w_pdfjs_require__(130);

var _decode_stream = __w_pdfjs_require__(127);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var CCITTFaxStream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(CCITTFaxStream, _DecodeStream);

  var _super = _createSuper(CCITTFaxStream);

  function CCITTFaxStream(str, maybeLength, params) {
    var _this;

    _classCallCheck(this, CCITTFaxStream);

    _this = _super.call(this, maybeLength);
    _this.str = str;
    _this.dict = str.dict;

    if (!(0, _primitives.isDict)(params)) {
      params = _primitives.Dict.empty;
    }

    var source = {
      next: function next() {
        return str.getByte();
      }
    };
    _this.ccittFaxDecoder = new _ccitt.CCITTFaxDecoder(source, {
      K: params.get("K"),
      EndOfLine: params.get("EndOfLine"),
      EncodedByteAlign: params.get("EncodedByteAlign"),
      Columns: params.get("Columns"),
      Rows: params.get("Rows"),
      EndOfBlock: params.get("EndOfBlock"),
      BlackIs1: params.get("BlackIs1")
    });
    return _this;
  }

  _createClass(CCITTFaxStream, [{
    key: "readBlock",
    value: function readBlock() {
      while (!this.eof) {
        var c = this.ccittFaxDecoder.readNextChar();

        if (c === -1) {
          this.eof = true;
          return;
        }

        this.ensureBuffer(this.bufferLength + 1);
        this.buffer[this.bufferLength++] = c;
      }
    }
  }]);

  return CCITTFaxStream;
}(_decode_stream.DecodeStream);

exports.CCITTFaxStream = CCITTFaxStream;

/***/ }),
/* 130 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.CCITTFaxDecoder = void 0;

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var ccittEOL = -2;
var ccittEOF = -1;
var twoDimPass = 0;
var twoDimHoriz = 1;
var twoDimVert0 = 2;
var twoDimVertR1 = 3;
var twoDimVertL1 = 4;
var twoDimVertR2 = 5;
var twoDimVertL2 = 6;
var twoDimVertR3 = 7;
var twoDimVertL3 = 8;
var twoDimTable = [[-1, -1], [-1, -1], [7, twoDimVertL3], [7, twoDimVertR3], [6, twoDimVertL2], [6, twoDimVertL2], [6, twoDimVertR2], [6, twoDimVertR2], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [4, twoDimPass], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimHoriz], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertL1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [3, twoDimVertR1], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0], [1, twoDimVert0]];
var whiteTable1 = [[-1, -1], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [12, 1984], [12, 2048], [12, 2112], [12, 2176], [12, 2240], [12, 2304], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [12, 2368], [12, 2432], [12, 2496], [12, 2560]];
var whiteTable2 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [8, 29], [8, 29], [8, 30], [8, 30], [8, 45], [8, 45], [8, 46], [8, 46], [7, 22], [7, 22], [7, 22], [7, 22], [7, 23], [7, 23], [7, 23], [7, 23], [8, 47], [8, 47], [8, 48], [8, 48], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [6, 13], [7, 20], [7, 20], [7, 20], [7, 20], [8, 33], [8, 33], [8, 34], [8, 34], [8, 35], [8, 35], [8, 36], [8, 36], [8, 37], [8, 37], [8, 38], [8, 38], [7, 19], [7, 19], [7, 19], [7, 19], [8, 31], [8, 31], [8, 32], [8, 32], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [6, 12], [8, 53], [8, 53], [8, 54], [8, 54], [7, 26], [7, 26], [7, 26], [7, 26], [8, 39], [8, 39], [8, 40], [8, 40], [8, 41], [8, 41], [8, 42], [8, 42], [8, 43], [8, 43], [8, 44], [8, 44], [7, 21], [7, 21], [7, 21], [7, 21], [7, 28], [7, 28], [7, 28], [7, 28], [8, 61], [8, 61], [8, 62], [8, 62], [8, 63], [8, 63], [8, 0], [8, 0], [8, 320], [8, 320], [8, 384], [8, 384], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 10], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [5, 11], [7, 27], [7, 27], [7, 27], [7, 27], [8, 59], [8, 59], [8, 60], [8, 60], [9, 1472], [9, 1536], [9, 1600], [9, 1728], [7, 18], [7, 18], [7, 18], [7, 18], [7, 24], [7, 24], [7, 24], [7, 24], [8, 49], [8, 49], [8, 50], [8, 50], [8, 51], [8, 51], [8, 52], [8, 52], [7, 25], [7, 25], [7, 25], [7, 25], [8, 55], [8, 55], [8, 56], [8, 56], [8, 57], [8, 57], [8, 58], [8, 58], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 192], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [6, 1664], [8, 448], [8, 448], [8, 512], [8, 512], [9, 704], [9, 768], [8, 640], [8, 640], [8, 576], [8, 576], [9, 832], [9, 896], [9, 960], [9, 1024], [9, 1088], [9, 1152], [9, 1216], [9, 1280], [9, 1344], [9, 1408], [7, 256], [7, 256], [7, 256], [7, 256], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 2], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 128], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 8], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [5, 9], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 16], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [6, 17], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 4], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [4, 5], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 14], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [6, 15], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [5, 64], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 6], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7], [4, 7]];
var blackTable1 = [[-1, -1], [-1, -1], [12, ccittEOL], [12, ccittEOL], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [-1, -1], [11, 1792], [11, 1792], [11, 1792], [11, 1792], [12, 1984], [12, 1984], [12, 2048], [12, 2048], [12, 2112], [12, 2112], [12, 2176], [12, 2176], [12, 2240], [12, 2240], [12, 2304], [12, 2304], [11, 1856], [11, 1856], [11, 1856], [11, 1856], [11, 1920], [11, 1920], [11, 1920], [11, 1920], [12, 2368], [12, 2368], [12, 2432], [12, 2432], [12, 2496], [12, 2496], [12, 2560], [12, 2560], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [10, 18], [12, 52], [12, 52], [13, 640], [13, 704], [13, 768], [13, 832], [12, 55], [12, 55], [12, 56], [12, 56], [13, 1280], [13, 1344], [13, 1408], [13, 1472], [12, 59], [12, 59], [12, 60], [12, 60], [13, 1536], [13, 1600], [11, 24], [11, 24], [11, 24], [11, 24], [11, 25], [11, 25], [11, 25], [11, 25], [13, 1664], [13, 1728], [12, 320], [12, 320], [12, 384], [12, 384], [12, 448], [12, 448], [13, 512], [13, 576], [12, 53], [12, 53], [12, 54], [12, 54], [13, 896], [13, 960], [13, 1024], [13, 1088], [13, 1152], [13, 1216], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64], [10, 64]];
var blackTable2 = [[8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [8, 13], [11, 23], [11, 23], [12, 50], [12, 51], [12, 44], [12, 45], [12, 46], [12, 47], [12, 57], [12, 58], [12, 61], [12, 256], [10, 16], [10, 16], [10, 16], [10, 16], [10, 17], [10, 17], [10, 17], [10, 17], [12, 48], [12, 49], [12, 62], [12, 63], [12, 30], [12, 31], [12, 32], [12, 33], [12, 40], [12, 41], [11, 22], [11, 22], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [8, 14], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 10], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [7, 11], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [9, 15], [12, 128], [12, 192], [12, 26], [12, 27], [12, 28], [12, 29], [11, 19], [11, 19], [11, 20], [11, 20], [12, 34], [12, 35], [12, 36], [12, 37], [12, 38], [12, 39], [11, 21], [11, 21], [12, 42], [12, 43], [10, 0], [10, 0], [10, 0], [10, 0], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12], [7, 12]];
var blackTable3 = [[-1, -1], [-1, -1], [-1, -1], [-1, -1], [6, 9], [6, 8], [5, 7], [5, 7], [4, 6], [4, 6], [4, 6], [4, 6], [4, 5], [4, 5], [4, 5], [4, 5], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 1], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [3, 4], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 3], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2], [2, 2]];

var CCITTFaxDecoder = /*#__PURE__*/function () {
  function CCITTFaxDecoder(source) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, CCITTFaxDecoder);

    if (!source || typeof source.next !== "function") {
      throw new Error('CCITTFaxDecoder - invalid "source" parameter.');
    }

    this.source = source;
    this.eof = false;
    this.encoding = options.K || 0;
    this.eoline = options.EndOfLine || false;
    this.byteAlign = options.EncodedByteAlign || false;
    this.columns = options.Columns || 1728;
    this.rows = options.Rows || 0;
    var eoblock = options.EndOfBlock;

    if (eoblock === null || eoblock === undefined) {
      eoblock = true;
    }

    this.eoblock = eoblock;
    this.black = options.BlackIs1 || false;
    this.codingLine = new Uint32Array(this.columns + 1);
    this.refLine = new Uint32Array(this.columns + 2);
    this.codingLine[0] = this.columns;
    this.codingPos = 0;
    this.row = 0;
    this.nextLine2D = this.encoding < 0;
    this.inputBits = 0;
    this.inputBuf = 0;
    this.outputBits = 0;
    this.rowsDone = false;
    var code1;

    while ((code1 = this._lookBits(12)) === 0) {
      this._eatBits(1);
    }

    if (code1 === 1) {
      this._eatBits(12);
    }

    if (this.encoding > 0) {
      this.nextLine2D = !this._lookBits(1);

      this._eatBits(1);
    }
  }

  _createClass(CCITTFaxDecoder, [{
    key: "readNextChar",
    value: function readNextChar() {
      if (this.eof) {
        return -1;
      }

      var refLine = this.refLine;
      var codingLine = this.codingLine;
      var columns = this.columns;
      var refPos, blackPixels, bits, i;

      if (this.outputBits === 0) {
        if (this.rowsDone) {
          this.eof = true;
        }

        if (this.eof) {
          return -1;
        }

        this.err = false;
        var code1, code2, code3;

        if (this.nextLine2D) {
          for (i = 0; codingLine[i] < columns; ++i) {
            refLine[i] = codingLine[i];
          }

          refLine[i++] = columns;
          refLine[i] = columns;
          codingLine[0] = 0;
          this.codingPos = 0;
          refPos = 0;
          blackPixels = 0;

          while (codingLine[this.codingPos] < columns) {
            code1 = this._getTwoDimCode();

            switch (code1) {
              case twoDimPass:
                this._addPixels(refLine[refPos + 1], blackPixels);

                if (refLine[refPos + 1] < columns) {
                  refPos += 2;
                }

                break;

              case twoDimHoriz:
                code1 = code2 = 0;

                if (blackPixels) {
                  do {
                    code1 += code3 = this._getBlackCode();
                  } while (code3 >= 64);

                  do {
                    code2 += code3 = this._getWhiteCode();
                  } while (code3 >= 64);
                } else {
                  do {
                    code1 += code3 = this._getWhiteCode();
                  } while (code3 >= 64);

                  do {
                    code2 += code3 = this._getBlackCode();
                  } while (code3 >= 64);
                }

                this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

                if (codingLine[this.codingPos] < columns) {
                  this._addPixels(codingLine[this.codingPos] + code2, blackPixels ^ 1);
                }

                while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                  refPos += 2;
                }

                break;

              case twoDimVertR3:
                this._addPixels(refLine[refPos] + 3, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  ++refPos;

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVertR2:
                this._addPixels(refLine[refPos] + 2, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  ++refPos;

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVertR1:
                this._addPixels(refLine[refPos] + 1, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  ++refPos;

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVert0:
                this._addPixels(refLine[refPos], blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  ++refPos;

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVertL3:
                this._addPixelsNeg(refLine[refPos] - 3, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  if (refPos > 0) {
                    --refPos;
                  } else {
                    ++refPos;
                  }

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVertL2:
                this._addPixelsNeg(refLine[refPos] - 2, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  if (refPos > 0) {
                    --refPos;
                  } else {
                    ++refPos;
                  }

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case twoDimVertL1:
                this._addPixelsNeg(refLine[refPos] - 1, blackPixels);

                blackPixels ^= 1;

                if (codingLine[this.codingPos] < columns) {
                  if (refPos > 0) {
                    --refPos;
                  } else {
                    ++refPos;
                  }

                  while (refLine[refPos] <= codingLine[this.codingPos] && refLine[refPos] < columns) {
                    refPos += 2;
                  }
                }

                break;

              case ccittEOF:
                this._addPixels(columns, 0);

                this.eof = true;
                break;

              default:
                (0, _util.info)("bad 2d code");

                this._addPixels(columns, 0);

                this.err = true;
            }
          }
        } else {
          codingLine[0] = 0;
          this.codingPos = 0;
          blackPixels = 0;

          while (codingLine[this.codingPos] < columns) {
            code1 = 0;

            if (blackPixels) {
              do {
                code1 += code3 = this._getBlackCode();
              } while (code3 >= 64);
            } else {
              do {
                code1 += code3 = this._getWhiteCode();
              } while (code3 >= 64);
            }

            this._addPixels(codingLine[this.codingPos] + code1, blackPixels);

            blackPixels ^= 1;
          }
        }

        var gotEOL = false;

        if (this.byteAlign) {
          this.inputBits &= ~7;
        }

        if (!this.eoblock && this.row === this.rows - 1) {
          this.rowsDone = true;
        } else {
          code1 = this._lookBits(12);

          if (this.eoline) {
            while (code1 !== ccittEOF && code1 !== 1) {
              this._eatBits(1);

              code1 = this._lookBits(12);
            }
          } else {
            while (code1 === 0) {
              this._eatBits(1);

              code1 = this._lookBits(12);
            }
          }

          if (code1 === 1) {
            this._eatBits(12);

            gotEOL = true;
          } else if (code1 === ccittEOF) {
            this.eof = true;
          }
        }

        if (!this.eof && this.encoding > 0 && !this.rowsDone) {
          this.nextLine2D = !this._lookBits(1);

          this._eatBits(1);
        }

        if (this.eoblock && gotEOL && this.byteAlign) {
          code1 = this._lookBits(12);

          if (code1 === 1) {
            this._eatBits(12);

            if (this.encoding > 0) {
              this._lookBits(1);

              this._eatBits(1);
            }

            if (this.encoding >= 0) {
              for (i = 0; i < 4; ++i) {
                code1 = this._lookBits(12);

                if (code1 !== 1) {
                  (0, _util.info)("bad rtc code: " + code1);
                }

                this._eatBits(12);

                if (this.encoding > 0) {
                  this._lookBits(1);

                  this._eatBits(1);
                }
              }
            }

            this.eof = true;
          }
        } else if (this.err && this.eoline) {
          while (true) {
            code1 = this._lookBits(13);

            if (code1 === ccittEOF) {
              this.eof = true;
              return -1;
            }

            if (code1 >> 1 === 1) {
              break;
            }

            this._eatBits(1);
          }

          this._eatBits(12);

          if (this.encoding > 0) {
            this._eatBits(1);

            this.nextLine2D = !(code1 & 1);
          }
        }

        if (codingLine[0] > 0) {
          this.outputBits = codingLine[this.codingPos = 0];
        } else {
          this.outputBits = codingLine[this.codingPos = 1];
        }

        this.row++;
      }

      var c;

      if (this.outputBits >= 8) {
        c = this.codingPos & 1 ? 0 : 0xff;
        this.outputBits -= 8;

        if (this.outputBits === 0 && codingLine[this.codingPos] < columns) {
          this.codingPos++;
          this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
        }
      } else {
        bits = 8;
        c = 0;

        do {
          if (this.outputBits > bits) {
            c <<= bits;

            if (!(this.codingPos & 1)) {
              c |= 0xff >> 8 - bits;
            }

            this.outputBits -= bits;
            bits = 0;
          } else {
            c <<= this.outputBits;

            if (!(this.codingPos & 1)) {
              c |= 0xff >> 8 - this.outputBits;
            }

            bits -= this.outputBits;
            this.outputBits = 0;

            if (codingLine[this.codingPos] < columns) {
              this.codingPos++;
              this.outputBits = codingLine[this.codingPos] - codingLine[this.codingPos - 1];
            } else if (bits > 0) {
              c <<= bits;
              bits = 0;
            }
          }
        } while (bits);
      }

      if (this.black) {
        c ^= 0xff;
      }

      return c;
    }
  }, {
    key: "_addPixels",
    value: function _addPixels(a1, blackPixels) {
      var codingLine = this.codingLine;
      var codingPos = this.codingPos;

      if (a1 > codingLine[codingPos]) {
        if (a1 > this.columns) {
          (0, _util.info)("row is wrong length");
          this.err = true;
          a1 = this.columns;
        }

        if (codingPos & 1 ^ blackPixels) {
          ++codingPos;
        }

        codingLine[codingPos] = a1;
      }

      this.codingPos = codingPos;
    }
  }, {
    key: "_addPixelsNeg",
    value: function _addPixelsNeg(a1, blackPixels) {
      var codingLine = this.codingLine;
      var codingPos = this.codingPos;

      if (a1 > codingLine[codingPos]) {
        if (a1 > this.columns) {
          (0, _util.info)("row is wrong length");
          this.err = true;
          a1 = this.columns;
        }

        if (codingPos & 1 ^ blackPixels) {
          ++codingPos;
        }

        codingLine[codingPos] = a1;
      } else if (a1 < codingLine[codingPos]) {
        if (a1 < 0) {
          (0, _util.info)("invalid code");
          this.err = true;
          a1 = 0;
        }

        while (codingPos > 0 && a1 < codingLine[codingPos - 1]) {
          --codingPos;
        }

        codingLine[codingPos] = a1;
      }

      this.codingPos = codingPos;
    }
  }, {
    key: "_findTableCode",
    value: function _findTableCode(start, end, table, limit) {
      var limitValue = limit || 0;

      for (var i = start; i <= end; ++i) {
        var code = this._lookBits(i);

        if (code === ccittEOF) {
          return [true, 1, false];
        }

        if (i < end) {
          code <<= end - i;
        }

        if (!limitValue || code >= limitValue) {
          var p = table[code - limitValue];

          if (p[0] === i) {
            this._eatBits(i);

            return [true, p[1], true];
          }
        }
      }

      return [false, 0, false];
    }
  }, {
    key: "_getTwoDimCode",
    value: function _getTwoDimCode() {
      var code = 0;
      var p;

      if (this.eoblock) {
        code = this._lookBits(7);
        p = twoDimTable[code];

        if (p && p[0] > 0) {
          this._eatBits(p[0]);

          return p[1];
        }
      } else {
        var result = this._findTableCode(1, 7, twoDimTable);

        if (result[0] && result[2]) {
          return result[1];
        }
      }

      (0, _util.info)("Bad two dim code");
      return ccittEOF;
    }
  }, {
    key: "_getWhiteCode",
    value: function _getWhiteCode() {
      var code = 0;
      var p;

      if (this.eoblock) {
        code = this._lookBits(12);

        if (code === ccittEOF) {
          return 1;
        }

        if (code >> 5 === 0) {
          p = whiteTable1[code];
        } else {
          p = whiteTable2[code >> 3];
        }

        if (p[0] > 0) {
          this._eatBits(p[0]);

          return p[1];
        }
      } else {
        var result = this._findTableCode(1, 9, whiteTable2);

        if (result[0]) {
          return result[1];
        }

        result = this._findTableCode(11, 12, whiteTable1);

        if (result[0]) {
          return result[1];
        }
      }

      (0, _util.info)("bad white code");

      this._eatBits(1);

      return 1;
    }
  }, {
    key: "_getBlackCode",
    value: function _getBlackCode() {
      var code, p;

      if (this.eoblock) {
        code = this._lookBits(13);

        if (code === ccittEOF) {
          return 1;
        }

        if (code >> 7 === 0) {
          p = blackTable1[code];
        } else if (code >> 9 === 0 && code >> 7 !== 0) {
          p = blackTable2[(code >> 1) - 64];
        } else {
          p = blackTable3[code >> 7];
        }

        if (p[0] > 0) {
          this._eatBits(p[0]);

          return p[1];
        }
      } else {
        var result = this._findTableCode(2, 6, blackTable3);

        if (result[0]) {
          return result[1];
        }

        result = this._findTableCode(7, 12, blackTable2, 64);

        if (result[0]) {
          return result[1];
        }

        result = this._findTableCode(10, 13, blackTable1);

        if (result[0]) {
          return result[1];
        }
      }

      (0, _util.info)("bad black code");

      this._eatBits(1);

      return 1;
    }
  }, {
    key: "_lookBits",
    value: function _lookBits(n) {
      var c;

      while (this.inputBits < n) {
        if ((c = this.source.next()) === -1) {
          if (this.inputBits === 0) {
            return ccittEOF;
          }

          return this.inputBuf << n - this.inputBits & 0xffff >> 16 - n;
        }

        this.inputBuf = this.inputBuf << 8 | c;
        this.inputBits += 8;
      }

      return this.inputBuf >> this.inputBits - n & 0xffff >> 16 - n;
    }
  }, {
    key: "_eatBits",
    value: function _eatBits(n) {
      if ((this.inputBits -= n) < 0) {
        this.inputBits = 0;
      }
    }
  }]);

  return CCITTFaxDecoder;
}();

exports.CCITTFaxDecoder = CCITTFaxDecoder;

/***/ }),
/* 131 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.FlateStream = void 0;

var _decode_stream = __w_pdfjs_require__(127);

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var codeLenCodeMap = new Int32Array([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
var lengthDecode = new Int32Array([0x00003, 0x00004, 0x00005, 0x00006, 0x00007, 0x00008, 0x00009, 0x0000a, 0x1000b, 0x1000d, 0x1000f, 0x10011, 0x20013, 0x20017, 0x2001b, 0x2001f, 0x30023, 0x3002b, 0x30033, 0x3003b, 0x40043, 0x40053, 0x40063, 0x40073, 0x50083, 0x500a3, 0x500c3, 0x500e3, 0x00102, 0x00102, 0x00102]);
var distDecode = new Int32Array([0x00001, 0x00002, 0x00003, 0x00004, 0x10005, 0x10007, 0x20009, 0x2000d, 0x30011, 0x30019, 0x40021, 0x40031, 0x50041, 0x50061, 0x60081, 0x600c1, 0x70101, 0x70181, 0x80201, 0x80301, 0x90401, 0x90601, 0xa0801, 0xa0c01, 0xb1001, 0xb1801, 0xc2001, 0xc3001, 0xd4001, 0xd6001]);
var fixedLitCodeTab = [new Int32Array([0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c0, 0x70108, 0x80060, 0x80020, 0x900a0, 0x80000, 0x80080, 0x80040, 0x900e0, 0x70104, 0x80058, 0x80018, 0x90090, 0x70114, 0x80078, 0x80038, 0x900d0, 0x7010c, 0x80068, 0x80028, 0x900b0, 0x80008, 0x80088, 0x80048, 0x900f0, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c8, 0x7010a, 0x80064, 0x80024, 0x900a8, 0x80004, 0x80084, 0x80044, 0x900e8, 0x70106, 0x8005c, 0x8001c, 0x90098, 0x70116, 0x8007c, 0x8003c, 0x900d8, 0x7010e, 0x8006c, 0x8002c, 0x900b8, 0x8000c, 0x8008c, 0x8004c, 0x900f8, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c4, 0x70109, 0x80062, 0x80022, 0x900a4, 0x80002, 0x80082, 0x80042, 0x900e4, 0x70105, 0x8005a, 0x8001a, 0x90094, 0x70115, 0x8007a, 0x8003a, 0x900d4, 0x7010d, 0x8006a, 0x8002a, 0x900b4, 0x8000a, 0x8008a, 0x8004a, 0x900f4, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cc, 0x7010b, 0x80066, 0x80026, 0x900ac, 0x80006, 0x80086, 0x80046, 0x900ec, 0x70107, 0x8005e, 0x8001e, 0x9009c, 0x70117, 0x8007e, 0x8003e, 0x900dc, 0x7010f, 0x8006e, 0x8002e, 0x900bc, 0x8000e, 0x8008e, 0x8004e, 0x900fc, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c2, 0x70108, 0x80061, 0x80021, 0x900a2, 0x80001, 0x80081, 0x80041, 0x900e2, 0x70104, 0x80059, 0x80019, 0x90092, 0x70114, 0x80079, 0x80039, 0x900d2, 0x7010c, 0x80069, 0x80029, 0x900b2, 0x80009, 0x80089, 0x80049, 0x900f2, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900ca, 0x7010a, 0x80065, 0x80025, 0x900aa, 0x80005, 0x80085, 0x80045, 0x900ea, 0x70106, 0x8005d, 0x8001d, 0x9009a, 0x70116, 0x8007d, 0x8003d, 0x900da, 0x7010e, 0x8006d, 0x8002d, 0x900ba, 0x8000d, 0x8008d, 0x8004d, 0x900fa, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c6, 0x70109, 0x80063, 0x80023, 0x900a6, 0x80003, 0x80083, 0x80043, 0x900e6, 0x70105, 0x8005b, 0x8001b, 0x90096, 0x70115, 0x8007b, 0x8003b, 0x900d6, 0x7010d, 0x8006b, 0x8002b, 0x900b6, 0x8000b, 0x8008b, 0x8004b, 0x900f6, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900ce, 0x7010b, 0x80067, 0x80027, 0x900ae, 0x80007, 0x80087, 0x80047, 0x900ee, 0x70107, 0x8005f, 0x8001f, 0x9009e, 0x70117, 0x8007f, 0x8003f, 0x900de, 0x7010f, 0x8006f, 0x8002f, 0x900be, 0x8000f, 0x8008f, 0x8004f, 0x900fe, 0x70100, 0x80050, 0x80010, 0x80118, 0x70110, 0x80070, 0x80030, 0x900c1, 0x70108, 0x80060, 0x80020, 0x900a1, 0x80000, 0x80080, 0x80040, 0x900e1, 0x70104, 0x80058, 0x80018, 0x90091, 0x70114, 0x80078, 0x80038, 0x900d1, 0x7010c, 0x80068, 0x80028, 0x900b1, 0x80008, 0x80088, 0x80048, 0x900f1, 0x70102, 0x80054, 0x80014, 0x8011c, 0x70112, 0x80074, 0x80034, 0x900c9, 0x7010a, 0x80064, 0x80024, 0x900a9, 0x80004, 0x80084, 0x80044, 0x900e9, 0x70106, 0x8005c, 0x8001c, 0x90099, 0x70116, 0x8007c, 0x8003c, 0x900d9, 0x7010e, 0x8006c, 0x8002c, 0x900b9, 0x8000c, 0x8008c, 0x8004c, 0x900f9, 0x70101, 0x80052, 0x80012, 0x8011a, 0x70111, 0x80072, 0x80032, 0x900c5, 0x70109, 0x80062, 0x80022, 0x900a5, 0x80002, 0x80082, 0x80042, 0x900e5, 0x70105, 0x8005a, 0x8001a, 0x90095, 0x70115, 0x8007a, 0x8003a, 0x900d5, 0x7010d, 0x8006a, 0x8002a, 0x900b5, 0x8000a, 0x8008a, 0x8004a, 0x900f5, 0x70103, 0x80056, 0x80016, 0x8011e, 0x70113, 0x80076, 0x80036, 0x900cd, 0x7010b, 0x80066, 0x80026, 0x900ad, 0x80006, 0x80086, 0x80046, 0x900ed, 0x70107, 0x8005e, 0x8001e, 0x9009d, 0x70117, 0x8007e, 0x8003e, 0x900dd, 0x7010f, 0x8006e, 0x8002e, 0x900bd, 0x8000e, 0x8008e, 0x8004e, 0x900fd, 0x70100, 0x80051, 0x80011, 0x80119, 0x70110, 0x80071, 0x80031, 0x900c3, 0x70108, 0x80061, 0x80021, 0x900a3, 0x80001, 0x80081, 0x80041, 0x900e3, 0x70104, 0x80059, 0x80019, 0x90093, 0x70114, 0x80079, 0x80039, 0x900d3, 0x7010c, 0x80069, 0x80029, 0x900b3, 0x80009, 0x80089, 0x80049, 0x900f3, 0x70102, 0x80055, 0x80015, 0x8011d, 0x70112, 0x80075, 0x80035, 0x900cb, 0x7010a, 0x80065, 0x80025, 0x900ab, 0x80005, 0x80085, 0x80045, 0x900eb, 0x70106, 0x8005d, 0x8001d, 0x9009b, 0x70116, 0x8007d, 0x8003d, 0x900db, 0x7010e, 0x8006d, 0x8002d, 0x900bb, 0x8000d, 0x8008d, 0x8004d, 0x900fb, 0x70101, 0x80053, 0x80013, 0x8011b, 0x70111, 0x80073, 0x80033, 0x900c7, 0x70109, 0x80063, 0x80023, 0x900a7, 0x80003, 0x80083, 0x80043, 0x900e7, 0x70105, 0x8005b, 0x8001b, 0x90097, 0x70115, 0x8007b, 0x8003b, 0x900d7, 0x7010d, 0x8006b, 0x8002b, 0x900b7, 0x8000b, 0x8008b, 0x8004b, 0x900f7, 0x70103, 0x80057, 0x80017, 0x8011f, 0x70113, 0x80077, 0x80037, 0x900cf, 0x7010b, 0x80067, 0x80027, 0x900af, 0x80007, 0x80087, 0x80047, 0x900ef, 0x70107, 0x8005f, 0x8001f, 0x9009f, 0x70117, 0x8007f, 0x8003f, 0x900df, 0x7010f, 0x8006f, 0x8002f, 0x900bf, 0x8000f, 0x8008f, 0x8004f, 0x900ff]), 9];
var fixedDistCodeTab = [new Int32Array([0x50000, 0x50010, 0x50008, 0x50018, 0x50004, 0x50014, 0x5000c, 0x5001c, 0x50002, 0x50012, 0x5000a, 0x5001a, 0x50006, 0x50016, 0x5000e, 0x00000, 0x50001, 0x50011, 0x50009, 0x50019, 0x50005, 0x50015, 0x5000d, 0x5001d, 0x50003, 0x50013, 0x5000b, 0x5001b, 0x50007, 0x50017, 0x5000f, 0x00000]), 5];

var FlateStream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(FlateStream, _DecodeStream);

  var _super = _createSuper(FlateStream);

  function FlateStream(str, maybeLength) {
    var _this;

    _classCallCheck(this, FlateStream);

    _this = _super.call(this, maybeLength);
    _this.str = str;
    _this.dict = str.dict;
    var cmf = str.getByte();
    var flg = str.getByte();

    if (cmf === -1 || flg === -1) {
      throw new _util.FormatError("Invalid header in flate stream: ".concat(cmf, ", ").concat(flg));
    }

    if ((cmf & 0x0f) !== 0x08) {
      throw new _util.FormatError("Unknown compression method in flate stream: ".concat(cmf, ", ").concat(flg));
    }

    if (((cmf << 8) + flg) % 31 !== 0) {
      throw new _util.FormatError("Bad FCHECK in flate stream: ".concat(cmf, ", ").concat(flg));
    }

    if (flg & 0x20) {
      throw new _util.FormatError("FDICT bit set in flate stream: ".concat(cmf, ", ").concat(flg));
    }

    _this.codeSize = 0;
    _this.codeBuf = 0;
    return _this;
  }

  _createClass(FlateStream, [{
    key: "getBits",
    value: function getBits(bits) {
      var str = this.str;
      var codeSize = this.codeSize;
      var codeBuf = this.codeBuf;
      var b;

      while (codeSize < bits) {
        if ((b = str.getByte()) === -1) {
          throw new _util.FormatError("Bad encoding in flate stream");
        }

        codeBuf |= b << codeSize;
        codeSize += 8;
      }

      b = codeBuf & (1 << bits) - 1;
      this.codeBuf = codeBuf >> bits;
      this.codeSize = codeSize -= bits;
      return b;
    }
  }, {
    key: "getCode",
    value: function getCode(table) {
      var str = this.str;
      var codes = table[0];
      var maxLen = table[1];
      var codeSize = this.codeSize;
      var codeBuf = this.codeBuf;
      var b;

      while (codeSize < maxLen) {
        if ((b = str.getByte()) === -1) {
          break;
        }

        codeBuf |= b << codeSize;
        codeSize += 8;
      }

      var code = codes[codeBuf & (1 << maxLen) - 1];
      var codeLen = code >> 16;
      var codeVal = code & 0xffff;

      if (codeLen < 1 || codeSize < codeLen) {
        throw new _util.FormatError("Bad encoding in flate stream");
      }

      this.codeBuf = codeBuf >> codeLen;
      this.codeSize = codeSize - codeLen;
      return codeVal;
    }
  }, {
    key: "generateHuffmanTable",
    value: function generateHuffmanTable(lengths) {
      var n = lengths.length;
      var maxLen = 0;
      var i;

      for (i = 0; i < n; ++i) {
        if (lengths[i] > maxLen) {
          maxLen = lengths[i];
        }
      }

      var size = 1 << maxLen;
      var codes = new Int32Array(size);

      for (var len = 1, code = 0, skip = 2; len <= maxLen; ++len, code <<= 1, skip <<= 1) {
        for (var val = 0; val < n; ++val) {
          if (lengths[val] === len) {
            var code2 = 0;
            var t = code;

            for (i = 0; i < len; ++i) {
              code2 = code2 << 1 | t & 1;
              t >>= 1;
            }

            for (i = code2; i < size; i += skip) {
              codes[i] = len << 16 | val;
            }

            ++code;
          }
        }
      }

      return [codes, maxLen];
    }
  }, {
    key: "readBlock",
    value: function readBlock() {
      var buffer, len;
      var str = this.str;
      var hdr = this.getBits(3);

      if (hdr & 1) {
        this.eof = true;
      }

      hdr >>= 1;

      if (hdr === 0) {
        var b;

        if ((b = str.getByte()) === -1) {
          throw new _util.FormatError("Bad block header in flate stream");
        }

        var blockLen = b;

        if ((b = str.getByte()) === -1) {
          throw new _util.FormatError("Bad block header in flate stream");
        }

        blockLen |= b << 8;

        if ((b = str.getByte()) === -1) {
          throw new _util.FormatError("Bad block header in flate stream");
        }

        var check = b;

        if ((b = str.getByte()) === -1) {
          throw new _util.FormatError("Bad block header in flate stream");
        }

        check |= b << 8;

        if (check !== (~blockLen & 0xffff) && (blockLen !== 0 || check !== 0)) {
          throw new _util.FormatError("Bad uncompressed block length in flate stream");
        }

        this.codeBuf = 0;
        this.codeSize = 0;
        var bufferLength = this.bufferLength,
            end = bufferLength + blockLen;
        buffer = this.ensureBuffer(end);
        this.bufferLength = end;

        if (blockLen === 0) {
          if (str.peekByte() === -1) {
            this.eof = true;
          }
        } else {
          var block = str.getBytes(blockLen);
          buffer.set(block, bufferLength);

          if (block.length < blockLen) {
            this.eof = true;
          }
        }

        return;
      }

      var litCodeTable;
      var distCodeTable;

      if (hdr === 1) {
        litCodeTable = fixedLitCodeTab;
        distCodeTable = fixedDistCodeTab;
      } else if (hdr === 2) {
        var numLitCodes = this.getBits(5) + 257;
        var numDistCodes = this.getBits(5) + 1;
        var numCodeLenCodes = this.getBits(4) + 4;
        var codeLenCodeLengths = new Uint8Array(codeLenCodeMap.length);
        var i;

        for (i = 0; i < numCodeLenCodes; ++i) {
          codeLenCodeLengths[codeLenCodeMap[i]] = this.getBits(3);
        }

        var codeLenCodeTab = this.generateHuffmanTable(codeLenCodeLengths);
        len = 0;
        i = 0;
        var codes = numLitCodes + numDistCodes;
        var codeLengths = new Uint8Array(codes);
        var bitsLength, bitsOffset, what;

        while (i < codes) {
          var code = this.getCode(codeLenCodeTab);

          if (code === 16) {
            bitsLength = 2;
            bitsOffset = 3;
            what = len;
          } else if (code === 17) {
            bitsLength = 3;
            bitsOffset = 3;
            what = len = 0;
          } else if (code === 18) {
            bitsLength = 7;
            bitsOffset = 11;
            what = len = 0;
          } else {
            codeLengths[i++] = len = code;
            continue;
          }

          var repeatLength = this.getBits(bitsLength) + bitsOffset;

          while (repeatLength-- > 0) {
            codeLengths[i++] = what;
          }
        }

        litCodeTable = this.generateHuffmanTable(codeLengths.subarray(0, numLitCodes));
        distCodeTable = this.generateHuffmanTable(codeLengths.subarray(numLitCodes, codes));
      } else {
        throw new _util.FormatError("Unknown block type in flate stream");
      }

      buffer = this.buffer;
      var limit = buffer ? buffer.length : 0;
      var pos = this.bufferLength;

      while (true) {
        var code1 = this.getCode(litCodeTable);

        if (code1 < 256) {
          if (pos + 1 >= limit) {
            buffer = this.ensureBuffer(pos + 1);
            limit = buffer.length;
          }

          buffer[pos++] = code1;
          continue;
        }

        if (code1 === 256) {
          this.bufferLength = pos;
          return;
        }

        code1 -= 257;
        code1 = lengthDecode[code1];
        var code2 = code1 >> 16;

        if (code2 > 0) {
          code2 = this.getBits(code2);
        }

        len = (code1 & 0xffff) + code2;
        code1 = this.getCode(distCodeTable);
        code1 = distDecode[code1];
        code2 = code1 >> 16;

        if (code2 > 0) {
          code2 = this.getBits(code2);
        }

        var dist = (code1 & 0xffff) + code2;

        if (pos + len >= limit) {
          buffer = this.ensureBuffer(pos + len);
          limit = buffer.length;
        }

        for (var k = 0; k < len; ++k, ++pos) {
          buffer[pos] = buffer[pos - dist];
        }
      }
    }
  }]);

  return FlateStream;
}(_decode_stream.DecodeStream);

exports.FlateStream = FlateStream;

/***/ }),
/* 132 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Jbig2Stream = void 0;

var _primitives = __w_pdfjs_require__(113);

var _decode_stream = __w_pdfjs_require__(127);

var _jbig = __w_pdfjs_require__(133);

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Jbig2Stream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(Jbig2Stream, _DecodeStream);

  var _super = _createSuper(Jbig2Stream);

  function Jbig2Stream(stream, maybeLength, params) {
    var _this;

    _classCallCheck(this, Jbig2Stream);

    _this = _super.call(this, maybeLength);
    _this.stream = stream;
    _this.dict = stream.dict;
    _this.maybeLength = maybeLength;
    _this.params = params;
    return _this;
  }

  _createClass(Jbig2Stream, [{
    key: "bytes",
    get: function get() {
      return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
    }
  }, {
    key: "ensureBuffer",
    value: function ensureBuffer(requested) {}
  }, {
    key: "readBlock",
    value: function readBlock() {
      if (this.eof) {
        return;
      }

      var jbig2Image = new _jbig.Jbig2Image();
      var chunks = [];

      if ((0, _primitives.isDict)(this.params)) {
        var globalsStream = this.params.get("JBIG2Globals");

        if ((0, _primitives.isStream)(globalsStream)) {
          var globals = globalsStream.getBytes();
          chunks.push({
            data: globals,
            start: 0,
            end: globals.length
          });
        }
      }

      chunks.push({
        data: this.bytes,
        start: 0,
        end: this.bytes.length
      });
      var data = jbig2Image.parseChunks(chunks);
      var dataLength = data.length;

      for (var i = 0; i < dataLength; i++) {
        data[i] ^= 0xff;
      }

      this.buffer = data;
      this.bufferLength = dataLength;
      this.eof = true;
    }
  }]);

  return Jbig2Stream;
}(_decode_stream.DecodeStream);

exports.Jbig2Stream = Jbig2Stream;

/***/ }),
/* 133 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Jbig2Image = void 0;

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(117);

var _arithmetic_decoder = __w_pdfjs_require__(134);

var _ccitt = __w_pdfjs_require__(130);

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var Jbig2Error = /*#__PURE__*/function (_BaseException) {
  _inherits(Jbig2Error, _BaseException);

  var _super = _createSuper(Jbig2Error);

  function Jbig2Error(msg) {
    _classCallCheck(this, Jbig2Error);

    return _super.call(this, "JBIG2 error: ".concat(msg));
  }

  return Jbig2Error;
}(_util.BaseException);

var ContextCache = /*#__PURE__*/function () {
  function ContextCache() {
    _classCallCheck(this, ContextCache);
  }

  _createClass(ContextCache, [{
    key: "getContexts",
    value: function getContexts(id) {
      if (id in this) {
        return this[id];
      }

      return this[id] = new Int8Array(1 << 16);
    }
  }]);

  return ContextCache;
}();

var DecodingContext = /*#__PURE__*/function () {
  function DecodingContext(data, start, end) {
    _classCallCheck(this, DecodingContext);

    this.data = data;
    this.start = start;
    this.end = end;
  }

  _createClass(DecodingContext, [{
    key: "decoder",
    get: function get() {
      var decoder = new _arithmetic_decoder.ArithmeticDecoder(this.data, this.start, this.end);
      return (0, _util.shadow)(this, "decoder", decoder);
    }
  }, {
    key: "contextCache",
    get: function get() {
      var cache = new ContextCache();
      return (0, _util.shadow)(this, "contextCache", cache);
    }
  }]);

  return DecodingContext;
}();

function decodeInteger(contextCache, procedure, decoder) {
  var contexts = contextCache.getContexts(procedure);
  var prev = 1;

  function readBits(length) {
    var v = 0;

    for (var i = 0; i < length; i++) {
      var bit = decoder.readBit(contexts, prev);
      prev = prev < 256 ? prev << 1 | bit : (prev << 1 | bit) & 511 | 256;
      v = v << 1 | bit;
    }

    return v >>> 0;
  }

  var sign = readBits(1);
  var value = readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(1) ? readBits(32) + 4436 : readBits(12) + 340 : readBits(8) + 84 : readBits(6) + 20 : readBits(4) + 4 : readBits(2);

  if (sign === 0) {
    return value;
  } else if (value > 0) {
    return -value;
  }

  return null;
}

function decodeIAID(contextCache, decoder, codeLength) {
  var contexts = contextCache.getContexts("IAID");
  var prev = 1;

  for (var i = 0; i < codeLength; i++) {
    var bit = decoder.readBit(contexts, prev);
    prev = prev << 1 | bit;
  }

  if (codeLength < 31) {
    return prev & (1 << codeLength) - 1;
  }

  return prev & 0x7fffffff;
}

var SegmentTypes = ["SymbolDictionary", null, null, null, "IntermediateTextRegion", null, "ImmediateTextRegion", "ImmediateLosslessTextRegion", null, null, null, null, null, null, null, null, "PatternDictionary", null, null, null, "IntermediateHalftoneRegion", null, "ImmediateHalftoneRegion", "ImmediateLosslessHalftoneRegion", null, null, null, null, null, null, null, null, null, null, null, null, "IntermediateGenericRegion", null, "ImmediateGenericRegion", "ImmediateLosslessGenericRegion", "IntermediateGenericRefinementRegion", null, "ImmediateGenericRefinementRegion", "ImmediateLosslessGenericRefinementRegion", null, null, null, null, "PageInformation", "EndOfPage", "EndOfStripe", "EndOfFile", "Profiles", "Tables", null, null, null, null, null, null, null, null, "Extension"];
var CodingTemplates = [[{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: 2,
  y: -1
}, {
  x: -4,
  y: 0
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: 2,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: 2,
  y: -1
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -1,
  y: -2
}, {
  x: 0,
  y: -2
}, {
  x: 1,
  y: -2
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}], [{
  x: -3,
  y: -1
}, {
  x: -2,
  y: -1
}, {
  x: -1,
  y: -1
}, {
  x: 0,
  y: -1
}, {
  x: 1,
  y: -1
}, {
  x: -4,
  y: 0
}, {
  x: -3,
  y: 0
}, {
  x: -2,
  y: 0
}, {
  x: -1,
  y: 0
}]];
var RefinementTemplates = [{
  coding: [{
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }],
  reference: [{
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }, {
    x: 0,
    y: 0
  }, {
    x: 1,
    y: 0
  }, {
    x: -1,
    y: 1
  }, {
    x: 0,
    y: 1
  }, {
    x: 1,
    y: 1
  }]
}, {
  coding: [{
    x: -1,
    y: -1
  }, {
    x: 0,
    y: -1
  }, {
    x: 1,
    y: -1
  }, {
    x: -1,
    y: 0
  }],
  reference: [{
    x: 0,
    y: -1
  }, {
    x: -1,
    y: 0
  }, {
    x: 0,
    y: 0
  }, {
    x: 1,
    y: 0
  }, {
    x: 0,
    y: 1
  }, {
    x: 1,
    y: 1
  }]
}];
var ReusedContexts = [0x9b25, 0x0795, 0x00e5, 0x0195];
var RefinementReusedContexts = [0x0020, 0x0008];

function decodeBitmapTemplate0(width, height, decodingContext) {
  var decoder = decodingContext.decoder;
  var contexts = decodingContext.contextCache.getContexts("GB");
  var bitmap = [];
  var contextLabel, i, j, pixel, row, row1, row2;
  var OLD_PIXEL_MASK = 0x7bf7;

  for (i = 0; i < height; i++) {
    row = bitmap[i] = new Uint8Array(width);
    row1 = i < 1 ? row : bitmap[i - 1];
    row2 = i < 2 ? row : bitmap[i - 2];
    contextLabel = row2[0] << 13 | row2[1] << 12 | row2[2] << 11 | row1[0] << 7 | row1[1] << 6 | row1[2] << 5 | row1[3] << 4;

    for (j = 0; j < width; j++) {
      row[j] = pixel = decoder.readBit(contexts, contextLabel);
      contextLabel = (contextLabel & OLD_PIXEL_MASK) << 1 | (j + 3 < width ? row2[j + 3] << 11 : 0) | (j + 4 < width ? row1[j + 4] << 4 : 0) | pixel;
    }
  }

  return bitmap;
}

function decodeBitmap(mmr, width, height, templateIndex, prediction, skip, at, decodingContext) {
  if (mmr) {
    var input = new Reader(decodingContext.data, decodingContext.start, decodingContext.end);
    return decodeMMRBitmap(input, width, height, false);
  }

  if (templateIndex === 0 && !skip && !prediction && at.length === 4 && at[0].x === 3 && at[0].y === -1 && at[1].x === -3 && at[1].y === -1 && at[2].x === 2 && at[2].y === -2 && at[3].x === -2 && at[3].y === -2) {
    return decodeBitmapTemplate0(width, height, decodingContext);
  }

  var useskip = !!skip;
  var template = CodingTemplates[templateIndex].concat(at);
  template.sort(function (a, b) {
    return a.y - b.y || a.x - b.x;
  });
  var templateLength = template.length;
  var templateX = new Int8Array(templateLength);
  var templateY = new Int8Array(templateLength);
  var changingTemplateEntries = [];
  var reuseMask = 0,
      minX = 0,
      maxX = 0,
      minY = 0;
  var c, k;

  for (k = 0; k < templateLength; k++) {
    templateX[k] = template[k].x;
    templateY[k] = template[k].y;
    minX = Math.min(minX, template[k].x);
    maxX = Math.max(maxX, template[k].x);
    minY = Math.min(minY, template[k].y);

    if (k < templateLength - 1 && template[k].y === template[k + 1].y && template[k].x === template[k + 1].x - 1) {
      reuseMask |= 1 << templateLength - 1 - k;
    } else {
      changingTemplateEntries.push(k);
    }
  }

  var changingEntriesLength = changingTemplateEntries.length;
  var changingTemplateX = new Int8Array(changingEntriesLength);
  var changingTemplateY = new Int8Array(changingEntriesLength);
  var changingTemplateBit = new Uint16Array(changingEntriesLength);

  for (c = 0; c < changingEntriesLength; c++) {
    k = changingTemplateEntries[c];
    changingTemplateX[c] = template[k].x;
    changingTemplateY[c] = template[k].y;
    changingTemplateBit[c] = 1 << templateLength - 1 - k;
  }

  var sbb_left = -minX;
  var sbb_top = -minY;
  var sbb_right = width - maxX;
  var pseudoPixelContext = ReusedContexts[templateIndex];
  var row = new Uint8Array(width);
  var bitmap = [];
  var decoder = decodingContext.decoder;
  var contexts = decodingContext.contextCache.getContexts("GB");
  var ltp = 0,
      j,
      i0,
      j0,
      contextLabel = 0,
      bit,
      shift;

  for (var i = 0; i < height; i++) {
    if (prediction) {
      var sltp = decoder.readBit(contexts, pseudoPixelContext);
      ltp ^= sltp;

      if (ltp) {
        bitmap.push(row);
        continue;
      }
    }

    row = new Uint8Array(row);
    bitmap.push(row);

    for (j = 0; j < width; j++) {
      if (useskip && skip[i][j]) {
        row[j] = 0;
        continue;
      }

      if (j >= sbb_left && j < sbb_right && i >= sbb_top) {
        contextLabel = contextLabel << 1 & reuseMask;

        for (k = 0; k < changingEntriesLength; k++) {
          i0 = i + changingTemplateY[k];
          j0 = j + changingTemplateX[k];
          bit = bitmap[i0][j0];

          if (bit) {
            bit = changingTemplateBit[k];
            contextLabel |= bit;
          }
        }
      } else {
        contextLabel = 0;
        shift = templateLength - 1;

        for (k = 0; k < templateLength; k++, shift--) {
          j0 = j + templateX[k];

          if (j0 >= 0 && j0 < width) {
            i0 = i + templateY[k];

            if (i0 >= 0) {
              bit = bitmap[i0][j0];

              if (bit) {
                contextLabel |= bit << shift;
              }
            }
          }
        }
      }

      var pixel = decoder.readBit(contexts, contextLabel);
      row[j] = pixel;
    }
  }

  return bitmap;
}

function decodeRefinement(width, height, templateIndex, referenceBitmap, offsetX, offsetY, prediction, at, decodingContext) {
  var codingTemplate = RefinementTemplates[templateIndex].coding;

  if (templateIndex === 0) {
    codingTemplate = codingTemplate.concat([at[0]]);
  }

  var codingTemplateLength = codingTemplate.length;
  var codingTemplateX = new Int32Array(codingTemplateLength);
  var codingTemplateY = new Int32Array(codingTemplateLength);
  var k;

  for (k = 0; k < codingTemplateLength; k++) {
    codingTemplateX[k] = codingTemplate[k].x;
    codingTemplateY[k] = codingTemplate[k].y;
  }

  var referenceTemplate = RefinementTemplates[templateIndex].reference;

  if (templateIndex === 0) {
    referenceTemplate = referenceTemplate.concat([at[1]]);
  }

  var referenceTemplateLength = referenceTemplate.length;
  var referenceTemplateX = new Int32Array(referenceTemplateLength);
  var referenceTemplateY = new Int32Array(referenceTemplateLength);

  for (k = 0; k < referenceTemplateLength; k++) {
    referenceTemplateX[k] = referenceTemplate[k].x;
    referenceTemplateY[k] = referenceTemplate[k].y;
  }

  var referenceWidth = referenceBitmap[0].length;
  var referenceHeight = referenceBitmap.length;
  var pseudoPixelContext = RefinementReusedContexts[templateIndex];
  var bitmap = [];
  var decoder = decodingContext.decoder;
  var contexts = decodingContext.contextCache.getContexts("GR");
  var ltp = 0;

  for (var i = 0; i < height; i++) {
    if (prediction) {
      var sltp = decoder.readBit(contexts, pseudoPixelContext);
      ltp ^= sltp;

      if (ltp) {
        throw new Jbig2Error("prediction is not supported");
      }
    }

    var row = new Uint8Array(width);
    bitmap.push(row);

    for (var j = 0; j < width; j++) {
      var i0 = void 0,
          j0 = void 0;
      var contextLabel = 0;

      for (k = 0; k < codingTemplateLength; k++) {
        i0 = i + codingTemplateY[k];
        j0 = j + codingTemplateX[k];

        if (i0 < 0 || j0 < 0 || j0 >= width) {
          contextLabel <<= 1;
        } else {
          contextLabel = contextLabel << 1 | bitmap[i0][j0];
        }
      }

      for (k = 0; k < referenceTemplateLength; k++) {
        i0 = i + referenceTemplateY[k] - offsetY;
        j0 = j + referenceTemplateX[k] - offsetX;

        if (i0 < 0 || i0 >= referenceHeight || j0 < 0 || j0 >= referenceWidth) {
          contextLabel <<= 1;
        } else {
          contextLabel = contextLabel << 1 | referenceBitmap[i0][j0];
        }
      }

      var pixel = decoder.readBit(contexts, contextLabel);
      row[j] = pixel;
    }
  }

  return bitmap;
}

function decodeSymbolDictionary(huffman, refinement, symbols, numberOfNewSymbols, numberOfExportedSymbols, huffmanTables, templateIndex, at, refinementTemplateIndex, refinementAt, decodingContext, huffmanInput) {
  if (huffman && refinement) {
    throw new Jbig2Error("symbol refinement with Huffman is not supported");
  }

  var newSymbols = [];
  var currentHeight = 0;
  var symbolCodeLength = (0, _core_utils.log2)(symbols.length + numberOfNewSymbols);
  var decoder = decodingContext.decoder;
  var contextCache = decodingContext.contextCache;
  var tableB1, symbolWidths;

  if (huffman) {
    tableB1 = getStandardTable(1);
    symbolWidths = [];
    symbolCodeLength = Math.max(symbolCodeLength, 1);
  }

  while (newSymbols.length < numberOfNewSymbols) {
    var deltaHeight = huffman ? huffmanTables.tableDeltaHeight.decode(huffmanInput) : decodeInteger(contextCache, "IADH", decoder);
    currentHeight += deltaHeight;
    var currentWidth = 0,
        totalWidth = 0;
    var firstSymbol = huffman ? symbolWidths.length : 0;

    while (true) {
      var deltaWidth = huffman ? huffmanTables.tableDeltaWidth.decode(huffmanInput) : decodeInteger(contextCache, "IADW", decoder);

      if (deltaWidth === null) {
        break;
      }

      currentWidth += deltaWidth;
      totalWidth += currentWidth;
      var bitmap = void 0;

      if (refinement) {
        var numberOfInstances = decodeInteger(contextCache, "IAAI", decoder);

        if (numberOfInstances > 1) {
          bitmap = decodeTextRegion(huffman, refinement, currentWidth, currentHeight, 0, numberOfInstances, 1, symbols.concat(newSymbols), symbolCodeLength, 0, 0, 1, 0, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext, 0, huffmanInput);
        } else {
          var symbolId = decodeIAID(contextCache, decoder, symbolCodeLength);
          var rdx = decodeInteger(contextCache, "IARDX", decoder);
          var rdy = decodeInteger(contextCache, "IARDY", decoder);
          var symbol = symbolId < symbols.length ? symbols[symbolId] : newSymbols[symbolId - symbols.length];
          bitmap = decodeRefinement(currentWidth, currentHeight, refinementTemplateIndex, symbol, rdx, rdy, false, refinementAt, decodingContext);
        }

        newSymbols.push(bitmap);
      } else if (huffman) {
        symbolWidths.push(currentWidth);
      } else {
        bitmap = decodeBitmap(false, currentWidth, currentHeight, templateIndex, false, null, at, decodingContext);
        newSymbols.push(bitmap);
      }
    }

    if (huffman && !refinement) {
      var bitmapSize = huffmanTables.tableBitmapSize.decode(huffmanInput);
      huffmanInput.byteAlign();
      var collectiveBitmap = void 0;

      if (bitmapSize === 0) {
        collectiveBitmap = readUncompressedBitmap(huffmanInput, totalWidth, currentHeight);
      } else {
        var originalEnd = huffmanInput.end;
        var bitmapEnd = huffmanInput.position + bitmapSize;
        huffmanInput.end = bitmapEnd;
        collectiveBitmap = decodeMMRBitmap(huffmanInput, totalWidth, currentHeight, false);
        huffmanInput.end = originalEnd;
        huffmanInput.position = bitmapEnd;
      }

      var numberOfSymbolsDecoded = symbolWidths.length;

      if (firstSymbol === numberOfSymbolsDecoded - 1) {
        newSymbols.push(collectiveBitmap);
      } else {
        var _i = void 0,
            y = void 0,
            xMin = 0,
            xMax = void 0,
            bitmapWidth = void 0,
            symbolBitmap = void 0;

        for (_i = firstSymbol; _i < numberOfSymbolsDecoded; _i++) {
          bitmapWidth = symbolWidths[_i];
          xMax = xMin + bitmapWidth;
          symbolBitmap = [];

          for (y = 0; y < currentHeight; y++) {
            symbolBitmap.push(collectiveBitmap[y].subarray(xMin, xMax));
          }

          newSymbols.push(symbolBitmap);
          xMin = xMax;
        }
      }
    }
  }

  var exportedSymbols = [],
      flags = [];
  var currentFlag = false,
      i,
      ii;
  var totalSymbolsLength = symbols.length + numberOfNewSymbols;

  while (flags.length < totalSymbolsLength) {
    var runLength = huffman ? tableB1.decode(huffmanInput) : decodeInteger(contextCache, "IAEX", decoder);

    while (runLength--) {
      flags.push(currentFlag);
    }

    currentFlag = !currentFlag;
  }

  for (i = 0, ii = symbols.length; i < ii; i++) {
    if (flags[i]) {
      exportedSymbols.push(symbols[i]);
    }
  }

  for (var j = 0; j < numberOfNewSymbols; i++, j++) {
    if (flags[i]) {
      exportedSymbols.push(newSymbols[j]);
    }
  }

  return exportedSymbols;
}

function decodeTextRegion(huffman, refinement, width, height, defaultPixelValue, numberOfSymbolInstances, stripSize, inputSymbols, symbolCodeLength, transposed, dsOffset, referenceCorner, combinationOperator, huffmanTables, refinementTemplateIndex, refinementAt, decodingContext, logStripSize, huffmanInput) {
  if (huffman && refinement) {
    throw new Jbig2Error("refinement with Huffman is not supported");
  }

  var bitmap = [];
  var i, row;

  for (i = 0; i < height; i++) {
    row = new Uint8Array(width);

    if (defaultPixelValue) {
      for (var j = 0; j < width; j++) {
        row[j] = defaultPixelValue;
      }
    }

    bitmap.push(row);
  }

  var decoder = decodingContext.decoder;
  var contextCache = decodingContext.contextCache;
  var stripT = huffman ? -huffmanTables.tableDeltaT.decode(huffmanInput) : -decodeInteger(contextCache, "IADT", decoder);
  var firstS = 0;
  i = 0;

  while (i < numberOfSymbolInstances) {
    var deltaT = huffman ? huffmanTables.tableDeltaT.decode(huffmanInput) : decodeInteger(contextCache, "IADT", decoder);
    stripT += deltaT;
    var deltaFirstS = huffman ? huffmanTables.tableFirstS.decode(huffmanInput) : decodeInteger(contextCache, "IAFS", decoder);
    firstS += deltaFirstS;
    var currentS = firstS;

    do {
      var currentT = 0;

      if (stripSize > 1) {
        currentT = huffman ? huffmanInput.readBits(logStripSize) : decodeInteger(contextCache, "IAIT", decoder);
      }

      var t = stripSize * stripT + currentT;
      var symbolId = huffman ? huffmanTables.symbolIDTable.decode(huffmanInput) : decodeIAID(contextCache, decoder, symbolCodeLength);
      var applyRefinement = refinement && (huffman ? huffmanInput.readBit() : decodeInteger(contextCache, "IARI", decoder));
      var symbolBitmap = inputSymbols[symbolId];
      var symbolWidth = symbolBitmap[0].length;
      var symbolHeight = symbolBitmap.length;

      if (applyRefinement) {
        var rdw = decodeInteger(contextCache, "IARDW", decoder);
        var rdh = decodeInteger(contextCache, "IARDH", decoder);
        var rdx = decodeInteger(contextCache, "IARDX", decoder);
        var rdy = decodeInteger(contextCache, "IARDY", decoder);
        symbolWidth += rdw;
        symbolHeight += rdh;
        symbolBitmap = decodeRefinement(symbolWidth, symbolHeight, refinementTemplateIndex, symbolBitmap, (rdw >> 1) + rdx, (rdh >> 1) + rdy, false, refinementAt, decodingContext);
      }

      var offsetT = t - (referenceCorner & 1 ? 0 : symbolHeight - 1);
      var offsetS = currentS - (referenceCorner & 2 ? symbolWidth - 1 : 0);
      var s2 = void 0,
          t2 = void 0,
          symbolRow = void 0;

      if (transposed) {
        for (s2 = 0; s2 < symbolHeight; s2++) {
          row = bitmap[offsetS + s2];

          if (!row) {
            continue;
          }

          symbolRow = symbolBitmap[s2];
          var maxWidth = Math.min(width - offsetT, symbolWidth);

          switch (combinationOperator) {
            case 0:
              for (t2 = 0; t2 < maxWidth; t2++) {
                row[offsetT + t2] |= symbolRow[t2];
              }

              break;

            case 2:
              for (t2 = 0; t2 < maxWidth; t2++) {
                row[offsetT + t2] ^= symbolRow[t2];
              }

              break;

            default:
              throw new Jbig2Error("operator ".concat(combinationOperator, " is not supported"));
          }
        }

        currentS += symbolHeight - 1;
      } else {
        for (t2 = 0; t2 < symbolHeight; t2++) {
          row = bitmap[offsetT + t2];

          if (!row) {
            continue;
          }

          symbolRow = symbolBitmap[t2];

          switch (combinationOperator) {
            case 0:
              for (s2 = 0; s2 < symbolWidth; s2++) {
                row[offsetS + s2] |= symbolRow[s2];
              }

              break;

            case 2:
              for (s2 = 0; s2 < symbolWidth; s2++) {
                row[offsetS + s2] ^= symbolRow[s2];
              }

              break;

            default:
              throw new Jbig2Error("operator ".concat(combinationOperator, " is not supported"));
          }
        }

        currentS += symbolWidth - 1;
      }

      i++;
      var deltaS = huffman ? huffmanTables.tableDeltaS.decode(huffmanInput) : decodeInteger(contextCache, "IADS", decoder);

      if (deltaS === null) {
        break;
      }

      currentS += deltaS + dsOffset;
    } while (true);
  }

  return bitmap;
}

function decodePatternDictionary(mmr, patternWidth, patternHeight, maxPatternIndex, template, decodingContext) {
  var at = [];

  if (!mmr) {
    at.push({
      x: -patternWidth,
      y: 0
    });

    if (template === 0) {
      at.push({
        x: -3,
        y: -1
      }, {
        x: 2,
        y: -2
      }, {
        x: -2,
        y: -2
      });
    }
  }

  var collectiveWidth = (maxPatternIndex + 1) * patternWidth;
  var collectiveBitmap = decodeBitmap(mmr, collectiveWidth, patternHeight, template, false, null, at, decodingContext);
  var patterns = [];

  for (var i = 0; i <= maxPatternIndex; i++) {
    var patternBitmap = [];
    var xMin = patternWidth * i;
    var xMax = xMin + patternWidth;

    for (var y = 0; y < patternHeight; y++) {
      patternBitmap.push(collectiveBitmap[y].subarray(xMin, xMax));
    }

    patterns.push(patternBitmap);
  }

  return patterns;
}

function decodeHalftoneRegion(mmr, patterns, template, regionWidth, regionHeight, defaultPixelValue, enableSkip, combinationOperator, gridWidth, gridHeight, gridOffsetX, gridOffsetY, gridVectorX, gridVectorY, decodingContext) {
  var skip = null;

  if (enableSkip) {
    throw new Jbig2Error("skip is not supported");
  }

  if (combinationOperator !== 0) {
    throw new Jbig2Error("operator \"".concat(combinationOperator, "\" is not supported in halftone region"));
  }

  var regionBitmap = [];
  var i, j, row;

  for (i = 0; i < regionHeight; i++) {
    row = new Uint8Array(regionWidth);

    if (defaultPixelValue) {
      for (j = 0; j < regionWidth; j++) {
        row[j] = defaultPixelValue;
      }
    }

    regionBitmap.push(row);
  }

  var numberOfPatterns = patterns.length;
  var pattern0 = patterns[0];
  var patternWidth = pattern0[0].length,
      patternHeight = pattern0.length;
  var bitsPerValue = (0, _core_utils.log2)(numberOfPatterns);
  var at = [];

  if (!mmr) {
    at.push({
      x: template <= 1 ? 3 : 2,
      y: -1
    });

    if (template === 0) {
      at.push({
        x: -3,
        y: -1
      }, {
        x: 2,
        y: -2
      }, {
        x: -2,
        y: -2
      });
    }
  }

  var grayScaleBitPlanes = [];
  var mmrInput, bitmap;

  if (mmr) {
    mmrInput = new Reader(decodingContext.data, decodingContext.start, decodingContext.end);
  }

  for (i = bitsPerValue - 1; i >= 0; i--) {
    if (mmr) {
      bitmap = decodeMMRBitmap(mmrInput, gridWidth, gridHeight, true);
    } else {
      bitmap = decodeBitmap(false, gridWidth, gridHeight, template, false, skip, at, decodingContext);
    }

    grayScaleBitPlanes[i] = bitmap;
  }

  var mg, ng, bit, patternIndex, patternBitmap, x, y, patternRow, regionRow;

  for (mg = 0; mg < gridHeight; mg++) {
    for (ng = 0; ng < gridWidth; ng++) {
      bit = 0;
      patternIndex = 0;

      for (j = bitsPerValue - 1; j >= 0; j--) {
        bit = grayScaleBitPlanes[j][mg][ng] ^ bit;
        patternIndex |= bit << j;
      }

      patternBitmap = patterns[patternIndex];
      x = gridOffsetX + mg * gridVectorY + ng * gridVectorX >> 8;
      y = gridOffsetY + mg * gridVectorX - ng * gridVectorY >> 8;

      if (x >= 0 && x + patternWidth <= regionWidth && y >= 0 && y + patternHeight <= regionHeight) {
        for (i = 0; i < patternHeight; i++) {
          regionRow = regionBitmap[y + i];
          patternRow = patternBitmap[i];

          for (j = 0; j < patternWidth; j++) {
            regionRow[x + j] |= patternRow[j];
          }
        }
      } else {
        var regionX = void 0,
            regionY = void 0;

        for (i = 0; i < patternHeight; i++) {
          regionY = y + i;

          if (regionY < 0 || regionY >= regionHeight) {
            continue;
          }

          regionRow = regionBitmap[regionY];
          patternRow = patternBitmap[i];

          for (j = 0; j < patternWidth; j++) {
            regionX = x + j;

            if (regionX >= 0 && regionX < regionWidth) {
              regionRow[regionX] |= patternRow[j];
            }
          }
        }
      }
    }
  }

  return regionBitmap;
}

function readSegmentHeader(data, start) {
  var segmentHeader = {};
  segmentHeader.number = (0, _core_utils.readUint32)(data, start);
  var flags = data[start + 4];
  var segmentType = flags & 0x3f;

  if (!SegmentTypes[segmentType]) {
    throw new Jbig2Error("invalid segment type: " + segmentType);
  }

  segmentHeader.type = segmentType;
  segmentHeader.typeName = SegmentTypes[segmentType];
  segmentHeader.deferredNonRetain = !!(flags & 0x80);
  var pageAssociationFieldSize = !!(flags & 0x40);
  var referredFlags = data[start + 5];
  var referredToCount = referredFlags >> 5 & 7;
  var retainBits = [referredFlags & 31];
  var position = start + 6;

  if (referredFlags === 7) {
    referredToCount = (0, _core_utils.readUint32)(data, position - 1) & 0x1fffffff;
    position += 3;
    var bytes = referredToCount + 7 >> 3;
    retainBits[0] = data[position++];

    while (--bytes > 0) {
      retainBits.push(data[position++]);
    }
  } else if (referredFlags === 5 || referredFlags === 6) {
    throw new Jbig2Error("invalid referred-to flags");
  }

  segmentHeader.retainBits = retainBits;
  var referredToSegmentNumberSize = 4;

  if (segmentHeader.number <= 256) {
    referredToSegmentNumberSize = 1;
  } else if (segmentHeader.number <= 65536) {
    referredToSegmentNumberSize = 2;
  }

  var referredTo = [];
  var i, ii;

  for (i = 0; i < referredToCount; i++) {
    var number = void 0;

    if (referredToSegmentNumberSize === 1) {
      number = data[position];
    } else if (referredToSegmentNumberSize === 2) {
      number = (0, _core_utils.readUint16)(data, position);
    } else {
      number = (0, _core_utils.readUint32)(data, position);
    }

    referredTo.push(number);
    position += referredToSegmentNumberSize;
  }

  segmentHeader.referredTo = referredTo;

  if (!pageAssociationFieldSize) {
    segmentHeader.pageAssociation = data[position++];
  } else {
    segmentHeader.pageAssociation = (0, _core_utils.readUint32)(data, position);
    position += 4;
  }

  segmentHeader.length = (0, _core_utils.readUint32)(data, position);
  position += 4;

  if (segmentHeader.length === 0xffffffff) {
    if (segmentType === 38) {
      var genericRegionInfo = readRegionSegmentInformation(data, position);
      var genericRegionSegmentFlags = data[position + RegionSegmentInformationFieldLength];
      var genericRegionMmr = !!(genericRegionSegmentFlags & 1);
      var searchPatternLength = 6;
      var searchPattern = new Uint8Array(searchPatternLength);

      if (!genericRegionMmr) {
        searchPattern[0] = 0xff;
        searchPattern[1] = 0xac;
      }

      searchPattern[2] = genericRegionInfo.height >>> 24 & 0xff;
      searchPattern[3] = genericRegionInfo.height >> 16 & 0xff;
      searchPattern[4] = genericRegionInfo.height >> 8 & 0xff;
      searchPattern[5] = genericRegionInfo.height & 0xff;

      for (i = position, ii = data.length; i < ii; i++) {
        var j = 0;

        while (j < searchPatternLength && searchPattern[j] === data[i + j]) {
          j++;
        }

        if (j === searchPatternLength) {
          segmentHeader.length = i + searchPatternLength;
          break;
        }
      }

      if (segmentHeader.length === 0xffffffff) {
        throw new Jbig2Error("segment end was not found");
      }
    } else {
      throw new Jbig2Error("invalid unknown segment length");
    }
  }

  segmentHeader.headerEnd = position;
  return segmentHeader;
}

function readSegments(header, data, start, end) {
  var segments = [];
  var position = start;

  while (position < end) {
    var segmentHeader = readSegmentHeader(data, position);
    position = segmentHeader.headerEnd;
    var segment = {
      header: segmentHeader,
      data: data
    };

    if (!header.randomAccess) {
      segment.start = position;
      position += segmentHeader.length;
      segment.end = position;
    }

    segments.push(segment);

    if (segmentHeader.type === 51) {
      break;
    }
  }

  if (header.randomAccess) {
    for (var i = 0, ii = segments.length; i < ii; i++) {
      segments[i].start = position;
      position += segments[i].header.length;
      segments[i].end = position;
    }
  }

  return segments;
}

function readRegionSegmentInformation(data, start) {
  return {
    width: (0, _core_utils.readUint32)(data, start),
    height: (0, _core_utils.readUint32)(data, start + 4),
    x: (0, _core_utils.readUint32)(data, start + 8),
    y: (0, _core_utils.readUint32)(data, start + 12),
    combinationOperator: data[start + 16] & 7
  };
}

var RegionSegmentInformationFieldLength = 17;

function processSegment(segment, visitor) {
  var header = segment.header;
  var data = segment.data,
      end = segment.end;
  var position = segment.start;
  var args, at, i, atLength;

  switch (header.type) {
    case 0:
      var dictionary = {};
      var dictionaryFlags = (0, _core_utils.readUint16)(data, position);
      dictionary.huffman = !!(dictionaryFlags & 1);
      dictionary.refinement = !!(dictionaryFlags & 2);
      dictionary.huffmanDHSelector = dictionaryFlags >> 2 & 3;
      dictionary.huffmanDWSelector = dictionaryFlags >> 4 & 3;
      dictionary.bitmapSizeSelector = dictionaryFlags >> 6 & 1;
      dictionary.aggregationInstancesSelector = dictionaryFlags >> 7 & 1;
      dictionary.bitmapCodingContextUsed = !!(dictionaryFlags & 256);
      dictionary.bitmapCodingContextRetained = !!(dictionaryFlags & 512);
      dictionary.template = dictionaryFlags >> 10 & 3;
      dictionary.refinementTemplate = dictionaryFlags >> 12 & 1;
      position += 2;

      if (!dictionary.huffman) {
        atLength = dictionary.template === 0 ? 4 : 1;
        at = [];

        for (i = 0; i < atLength; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        dictionary.at = at;
      }

      if (dictionary.refinement && !dictionary.refinementTemplate) {
        at = [];

        for (i = 0; i < 2; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        dictionary.refinementAt = at;
      }

      dictionary.numberOfExportedSymbols = (0, _core_utils.readUint32)(data, position);
      position += 4;
      dictionary.numberOfNewSymbols = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [dictionary, header.number, header.referredTo, data, position, end];
      break;

    case 6:
    case 7:
      var textRegion = {};
      textRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      var textRegionSegmentFlags = (0, _core_utils.readUint16)(data, position);
      position += 2;
      textRegion.huffman = !!(textRegionSegmentFlags & 1);
      textRegion.refinement = !!(textRegionSegmentFlags & 2);
      textRegion.logStripSize = textRegionSegmentFlags >> 2 & 3;
      textRegion.stripSize = 1 << textRegion.logStripSize;
      textRegion.referenceCorner = textRegionSegmentFlags >> 4 & 3;
      textRegion.transposed = !!(textRegionSegmentFlags & 64);
      textRegion.combinationOperator = textRegionSegmentFlags >> 7 & 3;
      textRegion.defaultPixelValue = textRegionSegmentFlags >> 9 & 1;
      textRegion.dsOffset = textRegionSegmentFlags << 17 >> 27;
      textRegion.refinementTemplate = textRegionSegmentFlags >> 15 & 1;

      if (textRegion.huffman) {
        var textRegionHuffmanFlags = (0, _core_utils.readUint16)(data, position);
        position += 2;
        textRegion.huffmanFS = textRegionHuffmanFlags & 3;
        textRegion.huffmanDS = textRegionHuffmanFlags >> 2 & 3;
        textRegion.huffmanDT = textRegionHuffmanFlags >> 4 & 3;
        textRegion.huffmanRefinementDW = textRegionHuffmanFlags >> 6 & 3;
        textRegion.huffmanRefinementDH = textRegionHuffmanFlags >> 8 & 3;
        textRegion.huffmanRefinementDX = textRegionHuffmanFlags >> 10 & 3;
        textRegion.huffmanRefinementDY = textRegionHuffmanFlags >> 12 & 3;
        textRegion.huffmanRefinementSizeSelector = !!(textRegionHuffmanFlags & 0x4000);
      }

      if (textRegion.refinement && !textRegion.refinementTemplate) {
        at = [];

        for (i = 0; i < 2; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        textRegion.refinementAt = at;
      }

      textRegion.numberOfSymbolInstances = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [textRegion, header.referredTo, data, position, end];
      break;

    case 16:
      var patternDictionary = {};
      var patternDictionaryFlags = data[position++];
      patternDictionary.mmr = !!(patternDictionaryFlags & 1);
      patternDictionary.template = patternDictionaryFlags >> 1 & 3;
      patternDictionary.patternWidth = data[position++];
      patternDictionary.patternHeight = data[position++];
      patternDictionary.maxPatternIndex = (0, _core_utils.readUint32)(data, position);
      position += 4;
      args = [patternDictionary, header.number, data, position, end];
      break;

    case 22:
    case 23:
      var halftoneRegion = {};
      halftoneRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      var halftoneRegionFlags = data[position++];
      halftoneRegion.mmr = !!(halftoneRegionFlags & 1);
      halftoneRegion.template = halftoneRegionFlags >> 1 & 3;
      halftoneRegion.enableSkip = !!(halftoneRegionFlags & 8);
      halftoneRegion.combinationOperator = halftoneRegionFlags >> 4 & 7;
      halftoneRegion.defaultPixelValue = halftoneRegionFlags >> 7 & 1;
      halftoneRegion.gridWidth = (0, _core_utils.readUint32)(data, position);
      position += 4;
      halftoneRegion.gridHeight = (0, _core_utils.readUint32)(data, position);
      position += 4;
      halftoneRegion.gridOffsetX = (0, _core_utils.readUint32)(data, position) & 0xffffffff;
      position += 4;
      halftoneRegion.gridOffsetY = (0, _core_utils.readUint32)(data, position) & 0xffffffff;
      position += 4;
      halftoneRegion.gridVectorX = (0, _core_utils.readUint16)(data, position);
      position += 2;
      halftoneRegion.gridVectorY = (0, _core_utils.readUint16)(data, position);
      position += 2;
      args = [halftoneRegion, header.referredTo, data, position, end];
      break;

    case 38:
    case 39:
      var genericRegion = {};
      genericRegion.info = readRegionSegmentInformation(data, position);
      position += RegionSegmentInformationFieldLength;
      var genericRegionSegmentFlags = data[position++];
      genericRegion.mmr = !!(genericRegionSegmentFlags & 1);
      genericRegion.template = genericRegionSegmentFlags >> 1 & 3;
      genericRegion.prediction = !!(genericRegionSegmentFlags & 8);

      if (!genericRegion.mmr) {
        atLength = genericRegion.template === 0 ? 4 : 1;
        at = [];

        for (i = 0; i < atLength; i++) {
          at.push({
            x: (0, _core_utils.readInt8)(data, position),
            y: (0, _core_utils.readInt8)(data, position + 1)
          });
          position += 2;
        }

        genericRegion.at = at;
      }

      args = [genericRegion, data, position, end];
      break;

    case 48:
      var pageInfo = {
        width: (0, _core_utils.readUint32)(data, position),
        height: (0, _core_utils.readUint32)(data, position + 4),
        resolutionX: (0, _core_utils.readUint32)(data, position + 8),
        resolutionY: (0, _core_utils.readUint32)(data, position + 12)
      };

      if (pageInfo.height === 0xffffffff) {
        delete pageInfo.height;
      }

      var pageSegmentFlags = data[position + 16];
      (0, _core_utils.readUint16)(data, position + 17);
      pageInfo.lossless = !!(pageSegmentFlags & 1);
      pageInfo.refinement = !!(pageSegmentFlags & 2);
      pageInfo.defaultPixelValue = pageSegmentFlags >> 2 & 1;
      pageInfo.combinationOperator = pageSegmentFlags >> 3 & 3;
      pageInfo.requiresBuffer = !!(pageSegmentFlags & 32);
      pageInfo.combinationOperatorOverride = !!(pageSegmentFlags & 64);
      args = [pageInfo];
      break;

    case 49:
      break;

    case 50:
      break;

    case 51:
      break;

    case 53:
      args = [header.number, data, position, end];
      break;

    case 62:
      break;

    default:
      throw new Jbig2Error("segment type ".concat(header.typeName, "(").concat(header.type, ")") + " is not implemented");
  }

  var callbackName = "on" + header.typeName;

  if (callbackName in visitor) {
    visitor[callbackName].apply(visitor, args);
  }
}

function processSegments(segments, visitor) {
  for (var i = 0, ii = segments.length; i < ii; i++) {
    processSegment(segments[i], visitor);
  }
}

function parseJbig2Chunks(chunks) {
  var visitor = new SimpleSegmentVisitor();

  for (var i = 0, ii = chunks.length; i < ii; i++) {
    var chunk = chunks[i];
    var segments = readSegments({}, chunk.data, chunk.start, chunk.end);
    processSegments(segments, visitor);
  }

  return visitor.buffer;
}

function parseJbig2(data) {
  var end = data.length;
  var position = 0;

  if (data[position] !== 0x97 || data[position + 1] !== 0x4a || data[position + 2] !== 0x42 || data[position + 3] !== 0x32 || data[position + 4] !== 0x0d || data[position + 5] !== 0x0a || data[position + 6] !== 0x1a || data[position + 7] !== 0x0a) {
    throw new Jbig2Error("parseJbig2 - invalid header.");
  }

  var header = Object.create(null);
  position += 8;
  var flags = data[position++];
  header.randomAccess = !(flags & 1);

  if (!(flags & 2)) {
    header.numberOfPages = (0, _core_utils.readUint32)(data, position);
    position += 4;
  }

  var segments = readSegments(header, data, position, end);
  var visitor = new SimpleSegmentVisitor();
  processSegments(segments, visitor);
  var _visitor$currentPageI = visitor.currentPageInfo,
      width = _visitor$currentPageI.width,
      height = _visitor$currentPageI.height;
  var bitPacked = visitor.buffer;
  var imgData = new Uint8ClampedArray(width * height);
  var q = 0,
      k = 0;

  for (var i = 0; i < height; i++) {
    var mask = 0,
        buffer = void 0;

    for (var j = 0; j < width; j++) {
      if (!mask) {
        mask = 128;
        buffer = bitPacked[k++];
      }

      imgData[q++] = buffer & mask ? 0 : 255;
      mask >>= 1;
    }
  }

  return {
    imgData: imgData,
    width: width,
    height: height
  };
}

var SimpleSegmentVisitor = /*#__PURE__*/function () {
  function SimpleSegmentVisitor() {
    _classCallCheck(this, SimpleSegmentVisitor);
  }

  _createClass(SimpleSegmentVisitor, [{
    key: "onPageInformation",
    value: function onPageInformation(info) {
      this.currentPageInfo = info;
      var rowSize = info.width + 7 >> 3;
      var buffer = new Uint8ClampedArray(rowSize * info.height);

      if (info.defaultPixelValue) {
        for (var i = 0, ii = buffer.length; i < ii; i++) {
          buffer[i] = 0xff;
        }
      }

      this.buffer = buffer;
    }
  }, {
    key: "drawBitmap",
    value: function drawBitmap(regionInfo, bitmap) {
      var pageInfo = this.currentPageInfo;
      var width = regionInfo.width,
          height = regionInfo.height;
      var rowSize = pageInfo.width + 7 >> 3;
      var combinationOperator = pageInfo.combinationOperatorOverride ? regionInfo.combinationOperator : pageInfo.combinationOperator;
      var buffer = this.buffer;
      var mask0 = 128 >> (regionInfo.x & 7);
      var offset0 = regionInfo.y * rowSize + (regionInfo.x >> 3);
      var i, j, mask, offset;

      switch (combinationOperator) {
        case 0:
          for (i = 0; i < height; i++) {
            mask = mask0;
            offset = offset0;

            for (j = 0; j < width; j++) {
              if (bitmap[i][j]) {
                buffer[offset] |= mask;
              }

              mask >>= 1;

              if (!mask) {
                mask = 128;
                offset++;
              }
            }

            offset0 += rowSize;
          }

          break;

        case 2:
          for (i = 0; i < height; i++) {
            mask = mask0;
            offset = offset0;

            for (j = 0; j < width; j++) {
              if (bitmap[i][j]) {
                buffer[offset] ^= mask;
              }

              mask >>= 1;

              if (!mask) {
                mask = 128;
                offset++;
              }
            }

            offset0 += rowSize;
          }

          break;

        default:
          throw new Jbig2Error("operator ".concat(combinationOperator, " is not supported"));
      }
    }
  }, {
    key: "onImmediateGenericRegion",
    value: function onImmediateGenericRegion(region, data, start, end) {
      var regionInfo = region.info;
      var decodingContext = new DecodingContext(data, start, end);
      var bitmap = decodeBitmap(region.mmr, regionInfo.width, regionInfo.height, region.template, region.prediction, null, region.at, decodingContext);
      this.drawBitmap(regionInfo, bitmap);
    }
  }, {
    key: "onImmediateLosslessGenericRegion",
    value: function onImmediateLosslessGenericRegion() {
      this.onImmediateGenericRegion.apply(this, arguments);
    }
  }, {
    key: "onSymbolDictionary",
    value: function onSymbolDictionary(dictionary, currentSegment, referredSegments, data, start, end) {
      var huffmanTables, huffmanInput;

      if (dictionary.huffman) {
        huffmanTables = getSymbolDictionaryHuffmanTables(dictionary, referredSegments, this.customTables);
        huffmanInput = new Reader(data, start, end);
      }

      var symbols = this.symbols;

      if (!symbols) {
        this.symbols = symbols = {};
      }

      var inputSymbols = [];

      for (var i = 0, ii = referredSegments.length; i < ii; i++) {
        var referredSymbols = symbols[referredSegments[i]];

        if (referredSymbols) {
          inputSymbols = inputSymbols.concat(referredSymbols);
        }
      }

      var decodingContext = new DecodingContext(data, start, end);
      symbols[currentSegment] = decodeSymbolDictionary(dictionary.huffman, dictionary.refinement, inputSymbols, dictionary.numberOfNewSymbols, dictionary.numberOfExportedSymbols, huffmanTables, dictionary.template, dictionary.at, dictionary.refinementTemplate, dictionary.refinementAt, decodingContext, huffmanInput);
    }
  }, {
    key: "onImmediateTextRegion",
    value: function onImmediateTextRegion(region, referredSegments, data, start, end) {
      var regionInfo = region.info;
      var huffmanTables, huffmanInput;
      var symbols = this.symbols;
      var inputSymbols = [];

      for (var i = 0, ii = referredSegments.length; i < ii; i++) {
        var referredSymbols = symbols[referredSegments[i]];

        if (referredSymbols) {
          inputSymbols = inputSymbols.concat(referredSymbols);
        }
      }

      var symbolCodeLength = (0, _core_utils.log2)(inputSymbols.length);

      if (region.huffman) {
        huffmanInput = new Reader(data, start, end);
        huffmanTables = getTextRegionHuffmanTables(region, referredSegments, this.customTables, inputSymbols.length, huffmanInput);
      }

      var decodingContext = new DecodingContext(data, start, end);
      var bitmap = decodeTextRegion(region.huffman, region.refinement, regionInfo.width, regionInfo.height, region.defaultPixelValue, region.numberOfSymbolInstances, region.stripSize, inputSymbols, symbolCodeLength, region.transposed, region.dsOffset, region.referenceCorner, region.combinationOperator, huffmanTables, region.refinementTemplate, region.refinementAt, decodingContext, region.logStripSize, huffmanInput);
      this.drawBitmap(regionInfo, bitmap);
    }
  }, {
    key: "onImmediateLosslessTextRegion",
    value: function onImmediateLosslessTextRegion() {
      this.onImmediateTextRegion.apply(this, arguments);
    }
  }, {
    key: "onPatternDictionary",
    value: function onPatternDictionary(dictionary, currentSegment, data, start, end) {
      var patterns = this.patterns;

      if (!patterns) {
        this.patterns = patterns = {};
      }

      var decodingContext = new DecodingContext(data, start, end);
      patterns[currentSegment] = decodePatternDictionary(dictionary.mmr, dictionary.patternWidth, dictionary.patternHeight, dictionary.maxPatternIndex, dictionary.template, decodingContext);
    }
  }, {
    key: "onImmediateHalftoneRegion",
    value: function onImmediateHalftoneRegion(region, referredSegments, data, start, end) {
      var patterns = this.patterns[referredSegments[0]];
      var regionInfo = region.info;
      var decodingContext = new DecodingContext(data, start, end);
      var bitmap = decodeHalftoneRegion(region.mmr, patterns, region.template, regionInfo.width, regionInfo.height, region.defaultPixelValue, region.enableSkip, region.combinationOperator, region.gridWidth, region.gridHeight, region.gridOffsetX, region.gridOffsetY, region.gridVectorX, region.gridVectorY, decodingContext);
      this.drawBitmap(regionInfo, bitmap);
    }
  }, {
    key: "onImmediateLosslessHalftoneRegion",
    value: function onImmediateLosslessHalftoneRegion() {
      this.onImmediateHalftoneRegion.apply(this, arguments);
    }
  }, {
    key: "onTables",
    value: function onTables(currentSegment, data, start, end) {
      var customTables = this.customTables;

      if (!customTables) {
        this.customTables = customTables = {};
      }

      customTables[currentSegment] = decodeTablesSegment(data, start, end);
    }
  }]);

  return SimpleSegmentVisitor;
}();

var HuffmanLine = function HuffmanLine(lineData) {
  _classCallCheck(this, HuffmanLine);

  if (lineData.length === 2) {
    this.isOOB = true;
    this.rangeLow = 0;
    this.prefixLength = lineData[0];
    this.rangeLength = 0;
    this.prefixCode = lineData[1];
    this.isLowerRange = false;
  } else {
    this.isOOB = false;
    this.rangeLow = lineData[0];
    this.prefixLength = lineData[1];
    this.rangeLength = lineData[2];
    this.prefixCode = lineData[3];
    this.isLowerRange = lineData[4] === "lower";
  }
};

var HuffmanTreeNode = /*#__PURE__*/function () {
  function HuffmanTreeNode(line) {
    _classCallCheck(this, HuffmanTreeNode);

    this.children = [];

    if (line) {
      this.isLeaf = true;
      this.rangeLength = line.rangeLength;
      this.rangeLow = line.rangeLow;
      this.isLowerRange = line.isLowerRange;
      this.isOOB = line.isOOB;
    } else {
      this.isLeaf = false;
    }
  }

  _createClass(HuffmanTreeNode, [{
    key: "buildTree",
    value: function buildTree(line, shift) {
      var bit = line.prefixCode >> shift & 1;

      if (shift <= 0) {
        this.children[bit] = new HuffmanTreeNode(line);
      } else {
        var node = this.children[bit];

        if (!node) {
          this.children[bit] = node = new HuffmanTreeNode(null);
        }

        node.buildTree(line, shift - 1);
      }
    }
  }, {
    key: "decodeNode",
    value: function decodeNode(reader) {
      if (this.isLeaf) {
        if (this.isOOB) {
          return null;
        }

        var htOffset = reader.readBits(this.rangeLength);
        return this.rangeLow + (this.isLowerRange ? -htOffset : htOffset);
      }

      var node = this.children[reader.readBit()];

      if (!node) {
        throw new Jbig2Error("invalid Huffman data");
      }

      return node.decodeNode(reader);
    }
  }]);

  return HuffmanTreeNode;
}();

var HuffmanTable = /*#__PURE__*/function () {
  function HuffmanTable(lines, prefixCodesDone) {
    _classCallCheck(this, HuffmanTable);

    if (!prefixCodesDone) {
      this.assignPrefixCodes(lines);
    }

    this.rootNode = new HuffmanTreeNode(null);

    for (var i = 0, ii = lines.length; i < ii; i++) {
      var line = lines[i];

      if (line.prefixLength > 0) {
        this.rootNode.buildTree(line, line.prefixLength - 1);
      }
    }
  }

  _createClass(HuffmanTable, [{
    key: "decode",
    value: function decode(reader) {
      return this.rootNode.decodeNode(reader);
    }
  }, {
    key: "assignPrefixCodes",
    value: function assignPrefixCodes(lines) {
      var linesLength = lines.length;
      var prefixLengthMax = 0;

      for (var i = 0; i < linesLength; i++) {
        prefixLengthMax = Math.max(prefixLengthMax, lines[i].prefixLength);
      }

      var histogram = new Uint32Array(prefixLengthMax + 1);

      for (var _i2 = 0; _i2 < linesLength; _i2++) {
        histogram[lines[_i2].prefixLength]++;
      }

      var currentLength = 1,
          firstCode = 0,
          currentCode,
          currentTemp,
          line;
      histogram[0] = 0;

      while (currentLength <= prefixLengthMax) {
        firstCode = firstCode + histogram[currentLength - 1] << 1;
        currentCode = firstCode;
        currentTemp = 0;

        while (currentTemp < linesLength) {
          line = lines[currentTemp];

          if (line.prefixLength === currentLength) {
            line.prefixCode = currentCode;
            currentCode++;
          }

          currentTemp++;
        }

        currentLength++;
      }
    }
  }]);

  return HuffmanTable;
}();

function decodeTablesSegment(data, start, end) {
  var flags = data[start];
  var lowestValue = (0, _core_utils.readUint32)(data, start + 1) & 0xffffffff;
  var highestValue = (0, _core_utils.readUint32)(data, start + 5) & 0xffffffff;
  var reader = new Reader(data, start + 9, end);
  var prefixSizeBits = (flags >> 1 & 7) + 1;
  var rangeSizeBits = (flags >> 4 & 7) + 1;
  var lines = [];
  var prefixLength,
      rangeLength,
      currentRangeLow = lowestValue;

  do {
    prefixLength = reader.readBits(prefixSizeBits);
    rangeLength = reader.readBits(rangeSizeBits);
    lines.push(new HuffmanLine([currentRangeLow, prefixLength, rangeLength, 0]));
    currentRangeLow += 1 << rangeLength;
  } while (currentRangeLow < highestValue);

  prefixLength = reader.readBits(prefixSizeBits);
  lines.push(new HuffmanLine([lowestValue - 1, prefixLength, 32, 0, "lower"]));
  prefixLength = reader.readBits(prefixSizeBits);
  lines.push(new HuffmanLine([highestValue, prefixLength, 32, 0]));

  if (flags & 1) {
    prefixLength = reader.readBits(prefixSizeBits);
    lines.push(new HuffmanLine([prefixLength, 0]));
  }

  return new HuffmanTable(lines, false);
}

var standardTablesCache = {};

function getStandardTable(number) {
  var table = standardTablesCache[number];

  if (table) {
    return table;
  }

  var lines;

  switch (number) {
    case 1:
      lines = [[0, 1, 4, 0x0], [16, 2, 8, 0x2], [272, 3, 16, 0x6], [65808, 3, 32, 0x7]];
      break;

    case 2:
      lines = [[0, 1, 0, 0x0], [1, 2, 0, 0x2], [2, 3, 0, 0x6], [3, 4, 3, 0xe], [11, 5, 6, 0x1e], [75, 6, 32, 0x3e], [6, 0x3f]];
      break;

    case 3:
      lines = [[-256, 8, 8, 0xfe], [0, 1, 0, 0x0], [1, 2, 0, 0x2], [2, 3, 0, 0x6], [3, 4, 3, 0xe], [11, 5, 6, 0x1e], [-257, 8, 32, 0xff, "lower"], [75, 7, 32, 0x7e], [6, 0x3e]];
      break;

    case 4:
      lines = [[1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 0, 0x6], [4, 4, 3, 0xe], [12, 5, 6, 0x1e], [76, 5, 32, 0x1f]];
      break;

    case 5:
      lines = [[-255, 7, 8, 0x7e], [1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 0, 0x6], [4, 4, 3, 0xe], [12, 5, 6, 0x1e], [-256, 7, 32, 0x7f, "lower"], [76, 6, 32, 0x3e]];
      break;

    case 6:
      lines = [[-2048, 5, 10, 0x1c], [-1024, 4, 9, 0x8], [-512, 4, 8, 0x9], [-256, 4, 7, 0xa], [-128, 5, 6, 0x1d], [-64, 5, 5, 0x1e], [-32, 4, 5, 0xb], [0, 2, 7, 0x0], [128, 3, 7, 0x2], [256, 3, 8, 0x3], [512, 4, 9, 0xc], [1024, 4, 10, 0xd], [-2049, 6, 32, 0x3e, "lower"], [2048, 6, 32, 0x3f]];
      break;

    case 7:
      lines = [[-1024, 4, 9, 0x8], [-512, 3, 8, 0x0], [-256, 4, 7, 0x9], [-128, 5, 6, 0x1a], [-64, 5, 5, 0x1b], [-32, 4, 5, 0xa], [0, 4, 5, 0xb], [32, 5, 5, 0x1c], [64, 5, 6, 0x1d], [128, 4, 7, 0xc], [256, 3, 8, 0x1], [512, 3, 9, 0x2], [1024, 3, 10, 0x3], [-1025, 5, 32, 0x1e, "lower"], [2048, 5, 32, 0x1f]];
      break;

    case 8:
      lines = [[-15, 8, 3, 0xfc], [-7, 9, 1, 0x1fc], [-5, 8, 1, 0xfd], [-3, 9, 0, 0x1fd], [-2, 7, 0, 0x7c], [-1, 4, 0, 0xa], [0, 2, 1, 0x0], [2, 5, 0, 0x1a], [3, 6, 0, 0x3a], [4, 3, 4, 0x4], [20, 6, 1, 0x3b], [22, 4, 4, 0xb], [38, 4, 5, 0xc], [70, 5, 6, 0x1b], [134, 5, 7, 0x1c], [262, 6, 7, 0x3c], [390, 7, 8, 0x7d], [646, 6, 10, 0x3d], [-16, 9, 32, 0x1fe, "lower"], [1670, 9, 32, 0x1ff], [2, 0x1]];
      break;

    case 9:
      lines = [[-31, 8, 4, 0xfc], [-15, 9, 2, 0x1fc], [-11, 8, 2, 0xfd], [-7, 9, 1, 0x1fd], [-5, 7, 1, 0x7c], [-3, 4, 1, 0xa], [-1, 3, 1, 0x2], [1, 3, 1, 0x3], [3, 5, 1, 0x1a], [5, 6, 1, 0x3a], [7, 3, 5, 0x4], [39, 6, 2, 0x3b], [43, 4, 5, 0xb], [75, 4, 6, 0xc], [139, 5, 7, 0x1b], [267, 5, 8, 0x1c], [523, 6, 8, 0x3c], [779, 7, 9, 0x7d], [1291, 6, 11, 0x3d], [-32, 9, 32, 0x1fe, "lower"], [3339, 9, 32, 0x1ff], [2, 0x0]];
      break;

    case 10:
      lines = [[-21, 7, 4, 0x7a], [-5, 8, 0, 0xfc], [-4, 7, 0, 0x7b], [-3, 5, 0, 0x18], [-2, 2, 2, 0x0], [2, 5, 0, 0x19], [3, 6, 0, 0x36], [4, 7, 0, 0x7c], [5, 8, 0, 0xfd], [6, 2, 6, 0x1], [70, 5, 5, 0x1a], [102, 6, 5, 0x37], [134, 6, 6, 0x38], [198, 6, 7, 0x39], [326, 6, 8, 0x3a], [582, 6, 9, 0x3b], [1094, 6, 10, 0x3c], [2118, 7, 11, 0x7d], [-22, 8, 32, 0xfe, "lower"], [4166, 8, 32, 0xff], [2, 0x2]];
      break;

    case 11:
      lines = [[1, 1, 0, 0x0], [2, 2, 1, 0x2], [4, 4, 0, 0xc], [5, 4, 1, 0xd], [7, 5, 1, 0x1c], [9, 5, 2, 0x1d], [13, 6, 2, 0x3c], [17, 7, 2, 0x7a], [21, 7, 3, 0x7b], [29, 7, 4, 0x7c], [45, 7, 5, 0x7d], [77, 7, 6, 0x7e], [141, 7, 32, 0x7f]];
      break;

    case 12:
      lines = [[1, 1, 0, 0x0], [2, 2, 0, 0x2], [3, 3, 1, 0x6], [5, 5, 0, 0x1c], [6, 5, 1, 0x1d], [8, 6, 1, 0x3c], [10, 7, 0, 0x7a], [11, 7, 1, 0x7b], [13, 7, 2, 0x7c], [17, 7, 3, 0x7d], [25, 7, 4, 0x7e], [41, 8, 5, 0xfe], [73, 8, 32, 0xff]];
      break;

    case 13:
      lines = [[1, 1, 0, 0x0], [2, 3, 0, 0x4], [3, 4, 0, 0xc], [4, 5, 0, 0x1c], [5, 4, 1, 0xd], [7, 3, 3, 0x5], [15, 6, 1, 0x3a], [17, 6, 2, 0x3b], [21, 6, 3, 0x3c], [29, 6, 4, 0x3d], [45, 6, 5, 0x3e], [77, 7, 6, 0x7e], [141, 7, 32, 0x7f]];
      break;

    case 14:
      lines = [[-2, 3, 0, 0x4], [-1, 3, 0, 0x5], [0, 1, 0, 0x0], [1, 3, 0, 0x6], [2, 3, 0, 0x7]];
      break;

    case 15:
      lines = [[-24, 7, 4, 0x7c], [-8, 6, 2, 0x3c], [-4, 5, 1, 0x1c], [-2, 4, 0, 0xc], [-1, 3, 0, 0x4], [0, 1, 0, 0x0], [1, 3, 0, 0x5], [2, 4, 0, 0xd], [3, 5, 1, 0x1d], [5, 6, 2, 0x3d], [9, 7, 4, 0x7d], [-25, 7, 32, 0x7e, "lower"], [25, 7, 32, 0x7f]];
      break;

    default:
      throw new Jbig2Error("standard table B.".concat(number, " does not exist"));
  }

  for (var i = 0, ii = lines.length; i < ii; i++) {
    lines[i] = new HuffmanLine(lines[i]);
  }

  table = new HuffmanTable(lines, true);
  standardTablesCache[number] = table;
  return table;
}

var Reader = /*#__PURE__*/function () {
  function Reader(data, start, end) {
    _classCallCheck(this, Reader);

    this.data = data;
    this.start = start;
    this.end = end;
    this.position = start;
    this.shift = -1;
    this.currentByte = 0;
  }

  _createClass(Reader, [{
    key: "readBit",
    value: function readBit() {
      if (this.shift < 0) {
        if (this.position >= this.end) {
          throw new Jbig2Error("end of data while reading bit");
        }

        this.currentByte = this.data[this.position++];
        this.shift = 7;
      }

      var bit = this.currentByte >> this.shift & 1;
      this.shift--;
      return bit;
    }
  }, {
    key: "readBits",
    value: function readBits(numBits) {
      var result = 0,
          i;

      for (i = numBits - 1; i >= 0; i--) {
        result |= this.readBit() << i;
      }

      return result;
    }
  }, {
    key: "byteAlign",
    value: function byteAlign() {
      this.shift = -1;
    }
  }, {
    key: "next",
    value: function next() {
      if (this.position >= this.end) {
        return -1;
      }

      return this.data[this.position++];
    }
  }]);

  return Reader;
}();

function getCustomHuffmanTable(index, referredTo, customTables) {
  var currentIndex = 0;

  for (var i = 0, ii = referredTo.length; i < ii; i++) {
    var table = customTables[referredTo[i]];

    if (table) {
      if (index === currentIndex) {
        return table;
      }

      currentIndex++;
    }
  }

  throw new Jbig2Error("can't find custom Huffman table");
}

function getTextRegionHuffmanTables(textRegion, referredTo, customTables, numberOfSymbols, reader) {
  var codes = [];

  for (var i = 0; i <= 34; i++) {
    var codeLength = reader.readBits(4);
    codes.push(new HuffmanLine([i, codeLength, 0, 0]));
  }

  var runCodesTable = new HuffmanTable(codes, false);
  codes.length = 0;

  for (var _i3 = 0; _i3 < numberOfSymbols;) {
    var _codeLength = runCodesTable.decode(reader);

    if (_codeLength >= 32) {
      var repeatedLength = void 0,
          numberOfRepeats = void 0,
          j = void 0;

      switch (_codeLength) {
        case 32:
          if (_i3 === 0) {
            throw new Jbig2Error("no previous value in symbol ID table");
          }

          numberOfRepeats = reader.readBits(2) + 3;
          repeatedLength = codes[_i3 - 1].prefixLength;
          break;

        case 33:
          numberOfRepeats = reader.readBits(3) + 3;
          repeatedLength = 0;
          break;

        case 34:
          numberOfRepeats = reader.readBits(7) + 11;
          repeatedLength = 0;
          break;

        default:
          throw new Jbig2Error("invalid code length in symbol ID table");
      }

      for (j = 0; j < numberOfRepeats; j++) {
        codes.push(new HuffmanLine([_i3, repeatedLength, 0, 0]));
        _i3++;
      }
    } else {
      codes.push(new HuffmanLine([_i3, _codeLength, 0, 0]));
      _i3++;
    }
  }

  reader.byteAlign();
  var symbolIDTable = new HuffmanTable(codes, false);
  var customIndex = 0,
      tableFirstS,
      tableDeltaS,
      tableDeltaT;

  switch (textRegion.huffmanFS) {
    case 0:
    case 1:
      tableFirstS = getStandardTable(textRegion.huffmanFS + 6);
      break;

    case 3:
      tableFirstS = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman FS selector");
  }

  switch (textRegion.huffmanDS) {
    case 0:
    case 1:
    case 2:
      tableDeltaS = getStandardTable(textRegion.huffmanDS + 8);
      break;

    case 3:
      tableDeltaS = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DS selector");
  }

  switch (textRegion.huffmanDT) {
    case 0:
    case 1:
    case 2:
      tableDeltaT = getStandardTable(textRegion.huffmanDT + 11);
      break;

    case 3:
      tableDeltaT = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DT selector");
  }

  if (textRegion.refinement) {
    throw new Jbig2Error("refinement with Huffman is not supported");
  }

  return {
    symbolIDTable: symbolIDTable,
    tableFirstS: tableFirstS,
    tableDeltaS: tableDeltaS,
    tableDeltaT: tableDeltaT
  };
}

function getSymbolDictionaryHuffmanTables(dictionary, referredTo, customTables) {
  var customIndex = 0,
      tableDeltaHeight,
      tableDeltaWidth;

  switch (dictionary.huffmanDHSelector) {
    case 0:
    case 1:
      tableDeltaHeight = getStandardTable(dictionary.huffmanDHSelector + 4);
      break;

    case 3:
      tableDeltaHeight = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DH selector");
  }

  switch (dictionary.huffmanDWSelector) {
    case 0:
    case 1:
      tableDeltaWidth = getStandardTable(dictionary.huffmanDWSelector + 2);
      break;

    case 3:
      tableDeltaWidth = getCustomHuffmanTable(customIndex, referredTo, customTables);
      customIndex++;
      break;

    default:
      throw new Jbig2Error("invalid Huffman DW selector");
  }

  var tableBitmapSize, tableAggregateInstances;

  if (dictionary.bitmapSizeSelector) {
    tableBitmapSize = getCustomHuffmanTable(customIndex, referredTo, customTables);
    customIndex++;
  } else {
    tableBitmapSize = getStandardTable(1);
  }

  if (dictionary.aggregationInstancesSelector) {
    tableAggregateInstances = getCustomHuffmanTable(customIndex, referredTo, customTables);
  } else {
    tableAggregateInstances = getStandardTable(1);
  }

  return {
    tableDeltaHeight: tableDeltaHeight,
    tableDeltaWidth: tableDeltaWidth,
    tableBitmapSize: tableBitmapSize,
    tableAggregateInstances: tableAggregateInstances
  };
}

function readUncompressedBitmap(reader, width, height) {
  var bitmap = [];

  for (var y = 0; y < height; y++) {
    var row = new Uint8Array(width);
    bitmap.push(row);

    for (var x = 0; x < width; x++) {
      row[x] = reader.readBit();
    }

    reader.byteAlign();
  }

  return bitmap;
}

function decodeMMRBitmap(input, width, height, endOfBlock) {
  var params = {
    K: -1,
    Columns: width,
    Rows: height,
    BlackIs1: true,
    EndOfBlock: endOfBlock
  };
  var decoder = new _ccitt.CCITTFaxDecoder(input, params);
  var bitmap = [];
  var currentByte,
      eof = false;

  for (var y = 0; y < height; y++) {
    var row = new Uint8Array(width);
    bitmap.push(row);
    var shift = -1;

    for (var x = 0; x < width; x++) {
      if (shift < 0) {
        currentByte = decoder.readNextChar();

        if (currentByte === -1) {
          currentByte = 0;
          eof = true;
        }

        shift = 7;
      }

      row[x] = currentByte >> shift & 1;
      shift--;
    }
  }

  if (endOfBlock && !eof) {
    var lookForEOFLimit = 5;

    for (var i = 0; i < lookForEOFLimit; i++) {
      if (decoder.readNextChar() === -1) {
        break;
      }
    }
  }

  return bitmap;
}

var Jbig2Image = /*#__PURE__*/function () {
  function Jbig2Image() {
    _classCallCheck(this, Jbig2Image);
  }

  _createClass(Jbig2Image, [{
    key: "parseChunks",
    value: function parseChunks(chunks) {
      return parseJbig2Chunks(chunks);
    }
  }, {
    key: "parse",
    value: function parse(data) {
      var _parseJbig = parseJbig2(data),
          imgData = _parseJbig.imgData,
          width = _parseJbig.width,
          height = _parseJbig.height;

      this.width = width;
      this.height = height;
      return imgData;
    }
  }]);

  return Jbig2Image;
}();

exports.Jbig2Image = Jbig2Image;

/***/ }),
/* 134 */
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ArithmeticDecoder = void 0;

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var QeTable = [{
  qe: 0x5601,
  nmps: 1,
  nlps: 1,
  switchFlag: 1
}, {
  qe: 0x3401,
  nmps: 2,
  nlps: 6,
  switchFlag: 0
}, {
  qe: 0x1801,
  nmps: 3,
  nlps: 9,
  switchFlag: 0
}, {
  qe: 0x0ac1,
  nmps: 4,
  nlps: 12,
  switchFlag: 0
}, {
  qe: 0x0521,
  nmps: 5,
  nlps: 29,
  switchFlag: 0
}, {
  qe: 0x0221,
  nmps: 38,
  nlps: 33,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 7,
  nlps: 6,
  switchFlag: 1
}, {
  qe: 0x5401,
  nmps: 8,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x4801,
  nmps: 9,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x3801,
  nmps: 10,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x3001,
  nmps: 11,
  nlps: 17,
  switchFlag: 0
}, {
  qe: 0x2401,
  nmps: 12,
  nlps: 18,
  switchFlag: 0
}, {
  qe: 0x1c01,
  nmps: 13,
  nlps: 20,
  switchFlag: 0
}, {
  qe: 0x1601,
  nmps: 29,
  nlps: 21,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 15,
  nlps: 14,
  switchFlag: 1
}, {
  qe: 0x5401,
  nmps: 16,
  nlps: 14,
  switchFlag: 0
}, {
  qe: 0x5101,
  nmps: 17,
  nlps: 15,
  switchFlag: 0
}, {
  qe: 0x4801,
  nmps: 18,
  nlps: 16,
  switchFlag: 0
}, {
  qe: 0x3801,
  nmps: 19,
  nlps: 17,
  switchFlag: 0
}, {
  qe: 0x3401,
  nmps: 20,
  nlps: 18,
  switchFlag: 0
}, {
  qe: 0x3001,
  nmps: 21,
  nlps: 19,
  switchFlag: 0
}, {
  qe: 0x2801,
  nmps: 22,
  nlps: 19,
  switchFlag: 0
}, {
  qe: 0x2401,
  nmps: 23,
  nlps: 20,
  switchFlag: 0
}, {
  qe: 0x2201,
  nmps: 24,
  nlps: 21,
  switchFlag: 0
}, {
  qe: 0x1c01,
  nmps: 25,
  nlps: 22,
  switchFlag: 0
}, {
  qe: 0x1801,
  nmps: 26,
  nlps: 23,
  switchFlag: 0
}, {
  qe: 0x1601,
  nmps: 27,
  nlps: 24,
  switchFlag: 0
}, {
  qe: 0x1401,
  nmps: 28,
  nlps: 25,
  switchFlag: 0
}, {
  qe: 0x1201,
  nmps: 29,
  nlps: 26,
  switchFlag: 0
}, {
  qe: 0x1101,
  nmps: 30,
  nlps: 27,
  switchFlag: 0
}, {
  qe: 0x0ac1,
  nmps: 31,
  nlps: 28,
  switchFlag: 0
}, {
  qe: 0x09c1,
  nmps: 32,
  nlps: 29,
  switchFlag: 0
}, {
  qe: 0x08a1,
  nmps: 33,
  nlps: 30,
  switchFlag: 0
}, {
  qe: 0x0521,
  nmps: 34,
  nlps: 31,
  switchFlag: 0
}, {
  qe: 0x0441,
  nmps: 35,
  nlps: 32,
  switchFlag: 0
}, {
  qe: 0x02a1,
  nmps: 36,
  nlps: 33,
  switchFlag: 0
}, {
  qe: 0x0221,
  nmps: 37,
  nlps: 34,
  switchFlag: 0
}, {
  qe: 0x0141,
  nmps: 38,
  nlps: 35,
  switchFlag: 0
}, {
  qe: 0x0111,
  nmps: 39,
  nlps: 36,
  switchFlag: 0
}, {
  qe: 0x0085,
  nmps: 40,
  nlps: 37,
  switchFlag: 0
}, {
  qe: 0x0049,
  nmps: 41,
  nlps: 38,
  switchFlag: 0
}, {
  qe: 0x0025,
  nmps: 42,
  nlps: 39,
  switchFlag: 0
}, {
  qe: 0x0015,
  nmps: 43,
  nlps: 40,
  switchFlag: 0
}, {
  qe: 0x0009,
  nmps: 44,
  nlps: 41,
  switchFlag: 0
}, {
  qe: 0x0005,
  nmps: 45,
  nlps: 42,
  switchFlag: 0
}, {
  qe: 0x0001,
  nmps: 45,
  nlps: 43,
  switchFlag: 0
}, {
  qe: 0x5601,
  nmps: 46,
  nlps: 46,
  switchFlag: 0
}];

var ArithmeticDecoder = /*#__PURE__*/function () {
  function ArithmeticDecoder(data, start, end) {
    _classCallCheck(this, ArithmeticDecoder);

    this.data = data;
    this.bp = start;
    this.dataEnd = end;
    this.chigh = data[start];
    this.clow = 0;
    this.byteIn();
    this.chigh = this.chigh << 7 & 0xffff | this.clow >> 9 & 0x7f;
    this.clow = this.clow << 7 & 0xffff;
    this.ct -= 7;
    this.a = 0x8000;
  }

  _createClass(ArithmeticDecoder, [{
    key: "byteIn",
    value: function byteIn() {
      var data = this.data;
      var bp = this.bp;

      if (data[bp] === 0xff) {
        if (data[bp + 1] > 0x8f) {
          this.clow += 0xff00;
          this.ct = 8;
        } else {
          bp++;
          this.clow += data[bp] << 9;
          this.ct = 7;
          this.bp = bp;
        }
      } else {
        bp++;
        this.clow += bp < this.dataEnd ? data[bp] << 8 : 0xff00;
        this.ct = 8;
        this.bp = bp;
      }

      if (this.clow > 0xffff) {
        this.chigh += this.clow >> 16;
        this.clow &= 0xffff;
      }
    }
  }, {
    key: "readBit",
    value: function readBit(contexts, pos) {
      var cx_index = contexts[pos] >> 1,
          cx_mps = contexts[pos] & 1;
      var qeTableIcx = QeTable[cx_index];
      var qeIcx = qeTableIcx.qe;
      var d;
      var a = this.a - qeIcx;

      if (this.chigh < qeIcx) {
        if (a < qeIcx) {
          a = qeIcx;
          d = cx_mps;
          cx_index = qeTableIcx.nmps;
        } else {
          a = qeIcx;
          d = 1 ^ cx_mps;

          if (qeTableIcx.switchFlag === 1) {
            cx_mps = d;
          }

          cx_index = qeTableIcx.nlps;
        }
      } else {
        this.chigh -= qeIcx;

        if ((a & 0x8000) !== 0) {
          this.a = a;
          return cx_mps;
        }

        if (a < qeIcx) {
          d = 1 ^ cx_mps;

          if (qeTableIcx.switchFlag === 1) {
            cx_mps = d;
          }

          cx_index = qeTableIcx.nlps;
        } else {
          d = cx_mps;
          cx_index = qeTableIcx.nmps;
        }
      }

      do {
        if (this.ct === 0) {
          this.byteIn();
        }

        a <<= 1;
        this.chigh = this.chigh << 1 & 0xffff | this.clow >> 15 & 1;
        this.clow = this.clow << 1 & 0xffff;
        this.ct--;
      } while ((a & 0x8000) === 0);

      this.a = a;
      contexts[pos] = cx_index << 1 | cx_mps;
      return d;
    }
  }]);

  return ArithmeticDecoder;
}();

exports.ArithmeticDecoder = ArithmeticDecoder;

/***/ }),
/* 135 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpegStream = void 0;

var _decode_stream = __w_pdfjs_require__(127);

var _primitives = __w_pdfjs_require__(113);

var _jpg = __w_pdfjs_require__(136);

var _util = __w_pdfjs_require__(4);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var JpegStream = /*#__PURE__*/function (_DecodeStream) {
  _inherits(JpegStream, _DecodeStream);

  var _super = _createSuper(JpegStream);

  function JpegStream(stream, maybeLength, params) {
    var _this;

    _classCallCheck(this, JpegStream);

    var ch;

    while ((ch = stream.getByte()) !== -1) {
      if (ch === 0xff) {
        stream.skip(-1);
        break;
      }
    }

    _this = _super.call(this, maybeLength);
    _this.stream = stream;
    _this.dict = stream.dict;
    _this.maybeLength = maybeLength;
    _this.params = params;
    return _this;
  }

  _createClass(JpegStream, [{
    key: "bytes",
    get: function get() {
      return (0, _util.shadow)(this, "bytes", this.stream.getBytes(this.maybeLength));
    }
  }, {
    key: "ensureBuffer",
    value: function ensureBuffer(requested) {}
  }, {
    key: "readBlock",
    value: function readBlock() {
      if (this.eof) {
        return;
      }

      var jpegOptions = {
        decodeTransform: undefined,
        colorTransform: undefined
      };
      var decodeArr = this.dict.getArray("Decode", "D");

      if (this.forceRGB && Array.isArray(decodeArr)) {
        var bitsPerComponent = this.dict.get("BitsPerComponent") || 8;
        var decodeArrLength = decodeArr.length;
        var transform = new Int32Array(decodeArrLength);
        var transformNeeded = false;
        var maxValue = (1 << bitsPerComponent) - 1;

        for (var i = 0; i < decodeArrLength; i += 2) {
          transform[i] = (decodeArr[i + 1] - decodeArr[i]) * 256 | 0;
          transform[i + 1] = decodeArr[i] * maxValue | 0;

          if (transform[i] !== 256 || transform[i + 1] !== 0) {
            transformNeeded = true;
          }
        }

        if (transformNeeded) {
          jpegOptions.decodeTransform = transform;
        }
      }

      if ((0, _primitives.isDict)(this.params)) {
        var colorTransform = this.params.get("ColorTransform");

        if (Number.isInteger(colorTransform)) {
          jpegOptions.colorTransform = colorTransform;
        }
      }

      var jpegImage = new _jpg.JpegImage(jpegOptions);
      jpegImage.parse(this.bytes);
      var data = jpegImage.getData({
        width: this.drawWidth,
        height: this.drawHeight,
        forceRGB: this.forceRGB,
        isSourcePDF: true
      });
      this.buffer = data;
      this.bufferLength = data.length;
      this.eof = true;
    }
  }]);

  return JpegStream;
}(_decode_stream.DecodeStream);

exports.JpegStream = JpegStream;

/***/ }),
/* 136 */
/***/ ((__unused_webpack_module, exports, __w_pdfjs_require__) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.JpegImage = void 0;

var _util = __w_pdfjs_require__(4);

var _core_utils = __w_pdfjs_require__(117);

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var JpegError = /*#__PURE__*/function (_BaseException) {
  _inherits(JpegError, _BaseException);

  var _super = _createSuper(JpegError);

  function JpegError(msg) {
    _classCallCheck(this, JpegError);

    return _super.call(this, "JPEG error: ".concat(msg));
  }

  return JpegError;
}(_util.BaseException);

var DNLMarkerError = /*#__PURE__*/function (_BaseException2) {
  _inherits(DNLMarkerError, _BaseException2);

  var _super2 = _createSuper(DNLMarkerError);

  function DNLMarkerError(message, scanLines) {
    var _this;

    _classCallCheck(this, DNLMarkerError);

    _this = _super2.call(this, message);
    _this.scanLines = scanLines;
    return _this;
  }

  return DNLMarkerError;
}(_util.BaseException);

var EOIMarkerError = /*#__PURE__*/function (_BaseException3) {
  _inherits(EOIMarkerError, _BaseException3);

  var _super3 = _createSuper(EOIMarkerError);

  function EOIMarkerError() {
    _classCallCheck(this, EOIMarkerError);

    return _super3.apply(this, arguments);
  }

  return EOIMarkerError;
}(_util.BaseException);

var dctZigZag = new Uint8Array([0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63]);
var dctCos1 = 4017;
var dctSin1 = 799;
var dctCos3 = 3406;
var dctSin3 = 2276;
var dctCos6 = 1567;
var dctSin6 = 3784;
var dctSqrt2 = 5793;
var dctSqrt1d2 = 2896;

function buildHuffmanTable(codeLengths, values) {
  var k = 0,
      i,
      j,
      length = 16;

  while (length > 0 && !codeLengths[length - 1]) {
    length--;
  }

  var code = [{
    children: [],
    index: 0
  }];
  var p = code[0],
      q;

  for (i = 0; i < length; i++) {
    for (j = 0; j < codeLengths[i]; j++) {
      p = code.pop();
      p.children[p.index] = values[k];

      while (p.index > 0) {
        p = code.pop();
      }

      p.index++;
      code.push(p);

      while (code.length <= i) {
        code.push(q = {
          children: [],
          index: 0
        });
        p.children[p.index] = q.children;
        p = q;
      }

      k++;
    }

    if (i + 1 < length) {
      code.push(q = {
        children: [],
        index: 0
      });
      p.children[p.index] = q.children;
      p = q;
    }
  }

  return code[0].children;
}

function getBlockBufferOffset(component, row, col) {
  return 64 * ((component.blocksPerLine + 1) * row + col);
}

function decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successivePrev, successive) {
  var parseDNLMarker = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : false;
  var mcusPerLine = frame.mcusPerLine;
  var progressive = frame.progressive;
  var startOffset = offset;
  var bitsData = 0,
      bitsCount = 0;

  function readBit() {
    if (bitsCount > 0) {
      bitsCount--;
      return bitsData >> bitsCount & 1;
    }

    bitsData = data[offset++];

    if (bitsData === 0xff) {
      var nextByte = data[offset++];

      if (nextByte) {
        if (nextByte === 0xdc && parseDNLMarker) {
          offset += 2;
          var scanLines = (0, _core_utils.readUint16)(data, offset);
          offset += 2;

          if (scanLines > 0 && scanLines !== frame.scanLines) {
            throw new DNLMarkerError("Found DNL marker (0xFFDC) while parsing scan data", scanLines);
          }
        } else if (nextByte === 0xd9) {
          if (parseDNLMarker) {
            var maybeScanLines = blockRow * (frame.precision === 8 ? 8 : 0);

            if (maybeScanLines > 0 && Math.round(frame.scanLines / maybeScanLines) >= 10) {
              throw new DNLMarkerError("Found EOI marker (0xFFD9) while parsing scan data, " + "possibly caused by incorrect `scanLines` parameter", maybeScanLines);
            }
          }

          throw new EOIMarkerError("Found EOI marker (0xFFD9) while parsing scan data");
        }

        throw new JpegError("unexpected marker ".concat((bitsData << 8 | nextByte).toString(16)));
      }
    }

    bitsCount = 7;
    return bitsData >>> 7;
  }

  function decodeHuffman(tree) {
    var node = tree;

    while (true) {
      node = node[readBit()];

      switch (_typeof(node)) {
        case "number":
          return node;

        case "object":
          continue;
      }

      throw new JpegError("invalid huffman sequence");
    }
  }

  function receive(length) {
    var n = 0;

    while (length > 0) {
      n = n << 1 | readBit();
      length--;
    }

    return n;
  }

  function receiveAndExtend(length) {
    if (length === 1) {
      return readBit() === 1 ? 1 : -1;
    }

    var n = receive(length);

    if (n >= 1 << length - 1) {
      return n;
    }

    return n + (-1 << length) + 1;
  }

  function decodeBaseline(component, blockOffset) {
    var t = decodeHuffman(component.huffmanTableDC);
    var diff = t === 0 ? 0 : receiveAndExtend(t);
    component.blockData[blockOffset] = component.pred += diff;
    var k = 1;

    while (k < 64) {
      var rs = decodeHuffman(component.huffmanTableAC);
      var s = rs & 15,
          r = rs >> 4;

      if (s === 0) {
        if (r < 15) {
          break;
        }

        k += 16;
        continue;
      }

      k += r;
      var z = dctZigZag[k];
      component.blockData[blockOffset + z] = receiveAndExtend(s);
      k++;
    }
  }

  function decodeDCFirst(component, blockOffset) {
    var t = decodeHuffman(component.huffmanTableDC);
    var diff = t === 0 ? 0 : receiveAndExtend(t) << successive;
    component.blockData[blockOffset] = component.pred += diff;
  }

  function decodeDCSuccessive(component, blockOffset) {
    component.blockData[blockOffset] |= readBit() << successive;
  }

  var eobrun = 0;

  function decodeACFirst(component, blockOffset) {
    if (eobrun > 0) {
      eobrun--;
      return;
    }

    var k = spectralStart;
    var e = spectralEnd;

    while (k <= e) {
      var rs = decodeHuffman(component.huffmanTableAC);
      var s = rs & 15,
          r = rs >> 4;

      if (s === 0) {
        if (r < 15) {
          eobrun = receive(r) + (1 << r) - 1;
          break;
        }

        k += 16;
        continue;
      }

      k += r;
      var z = dctZigZag[k];
      component.blockData[blockOffset + z] = receiveAndExtend(s) * (1 << successive);
      k++;
    }
  }

  var successiveACState = 0,
      successiveACNextValue;

  function decodeACSuccessive(component, blockOffset) {
    var k = spectralStart;
    var e = spectralEnd;
    var r = 0;
    var s;
    var rs;

    while (k <= e) {
      var offsetZ = blockOffset + dctZigZag[k];
      var sign = component.blockData[offsetZ] < 0 ? -1 : 1;

      switch (successiveACState) {
        case 0:
          rs = decodeHuffman(component.huffmanTableAC);
          s = rs & 15;
          r = rs >> 4;

          if (s === 0) {
            if (r < 15) {
              eobrun = receive(r) + (1 << r);
              successiveACState = 4;
            } else {
              r = 16;
              successiveACState = 1;
            }
          } else {
            if (s !== 1) {
              throw new JpegError("invalid ACn encoding");
            }

            successiveACNextValue = receiveAndExtend(s);
            successiveACState = r ? 2 : 3;
          }

          continue;

        case 1:
        case 2:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          } else {
            r--;

            if (r === 0) {
              successiveACState = successiveACState === 2 ? 3 : 0;
            }
          }

          break;

        case 3:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          } else {
            component.blockData[offsetZ] = successiveACNextValue << successive;
            successiveACState = 0;
          }

          break;

        case 4:
          if (component.blockData[offsetZ]) {
            component.blockData[offsetZ] += sign * (readBit() << successive);
          }

          break;
      }

      k++;
    }

    if (successiveACState === 4) {
      eobrun--;

      if (eobrun === 0) {
        successiveACState = 0;
      }
    }
  }

  var blockRow = 0;

  function decodeMcu(component, decode, mcu, row, col) {
    var mcuRow = mcu / mcusPerLine | 0;
    var mcuCol = mcu % mcusPerLine;
    blockRow = mcuRow * component.v + row;
    var blockCol = mcuCol * component.h + col;
    var blockOffset = getBlockBufferOffset(component, blockRow, blockCol);
    decode(component, blockOffset);
  }

  function decodeBlock(component, decode, mcu) {
    blockRow = mcu / component.blocksPerLine | 0;
    var blockCol = mcu % component.blocksPerLine;
    var blockOffset = getBlockBufferOffset(component, blockRow, blockCol);
    decode(component, blockOffset);
  }

  var componentsLength = components.length;
  var component, i, j, k, n;
  var decodeFn;

  if (progressive) {
    if (spectralStart === 0) {
      decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
    } else {
      decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
    }
  } else {
    decodeFn = decodeBaseline;
  }

  var mcu = 0,
      fileMarker;
  var mcuExpected;

  if (componentsLength === 1) {
    mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
  } else {
    mcuExpected = mcusPerLine * frame.mcusPerColumn;
  }

  var h, v;

  while (mcu <= mcuExpected) {
    var mcuToRead = resetInterval ? Math.min(mcuExpected - mcu, resetInterval) : mcuExpected;

    if (mcuToRead > 0) {
      for (i = 0; i < componentsLength; i++) {
        components[i].pred = 0;
      }

      eobrun = 0;

      if (componentsLength === 1) {
        component = components[0];

        for (n = 0; n < mcuToRead; n++) {
          decodeBlock(component, decodeFn, mcu);
          mcu++;
        }
      } else {
        for (n = 0; n < mcuToRead; n++) {
          for (i = 0; i < componentsLength; i++) {
            component = components[i];
            h = component.h;
            v = component.v;

            for (j = 0; j < v; j++) {
              for (k = 0; k < h; k++) {
                decodeMcu(component, decodeFn, mcu, j, k);
              }
            }
          }

          mcu++;
        }
      }
    }

    bitsCount = 0;
    fileMarker = findNextFileMarker(data, offset);

    if (!fileMarker) {
      break;
    }

    if (fileMarker.invalid) {
      var partialMsg = mcuToRead > 0 ? "unexpected" : "excessive";
      (0, _util.warn)("decodeScan - ".concat(partialMsg, " MCU data, current marker is: ").concat(fileMarker.invalid));
      offset = fileMarker.offset;
    }

    if (fileMarker.marker >= 0xffd0 && fileMarker.marker <= 0xffd7) {
      offset += 2;
    } else {
      break;
    }
  }

  return offset - startOffset;
}

function quantizeAndInverse(component, blockBufferOffset, p) {
  var qt = component.quantizationTable,
      blockData = component.blockData;
  var v0, v1, v2, v3, v4, v5, v6, v7;
  var p0, p1, p2, p3, p4, p5, p6, p7;
  var t;

  if (!qt) {
    throw new JpegError("missing required Quantization Table.");
  }

  for (var row = 0; row < 64; row += 8) {
    p0 = blockData[blockBufferOffset + row];
    p1 = blockData[blockBufferOffset + row + 1];
    p2 = blockData[blockBufferOffset + row + 2];
    p3 = blockData[blockBufferOffset + row + 3];
    p4 = blockData[blockBufferOffset + row + 4];
    p5 = blockData[blockBufferOffset + row + 5];
    p6 = blockData[blockBufferOffset + row + 6];
    p7 = blockData[blockBufferOffset + row + 7];
    p0 *= qt[row];

    if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
      t = dctSqrt2 * p0 + 512 >> 10;
      p[row] = t;
      p[row + 1] = t;
      p[row + 2] = t;
      p[row + 3] = t;
      p[row + 4] = t;
      p[row + 5] = t;
      p[row + 6] = t;
      p[row + 7] = t;
      continue;
    }

    p1 *= qt[row + 1];
    p2 *= qt[row + 2];
    p3 *= qt[row + 3];
    p4 *= qt[row + 4];
    p5 *= qt[row + 5];
    p6 *= qt[row + 6];
    p7 *= qt[row + 7];
    v0 = dctSqrt2 * p0 + 128 >> 8;
    v1 = dctSqrt2 * p4 + 128 >> 8;
    v2 = p2;
    v3 = p6;
    v4 = dctSqrt1d2 * (p1 - p7) + 128 >> 8;
    v7 = dctSqrt1d2 * (p1 + p7) + 128 >> 8;
    v5 = p3 << 4;
    v6 = p5 << 4;
    v0 = v0 + v1 + 1 >> 1;
    v1 = v0 - v1;
    t = v2 * dctSin6 + v3 * dctCos6 + 128 >> 8;
    v2 = v2 * dctCos6 - v3 * dctSin6 + 128 >> 8;
    v3 = t;
    v4 = v4 + v6 + 1 >> 1;
    v6 = v4 - v6;
    v7 = v7 + v5 + 1 >> 1;
    v5 = v7 - v5;
    v0 = v0 + v3 + 1 >> 1;
    v3 = v0 - v3;
    v1 = v1 + v2 + 1 >> 1;
    v2 = v1 - v2;
    t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
    v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
    v7 = t;
    t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
    v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
    v6 = t;
    p[row] = v0 + v7;
    p[row + 7] = v0 - v7;
    p[row + 1] = v1 + v6;
    p[row + 6] = v1 - v6;
    p[row + 2] = v2 + v5;
    p[row + 5] = v2 - v5;
    p[row + 3] = v3 + v4;
    p[row + 4] = v3 - v4;
  }

  for (var col = 0; col < 8; ++col) {
    p0 = p[col];
    p1 = p[col + 8];
    p2 = p[col + 16];
    p3 = p[col + 24];
    p4 = p[col + 32];
    p5 = p[col + 40];
    p6 = p[col + 48];
    p7 = p[col + 56];

    if ((p1 | p2 | p3 | p4 | p5 | p6 | p7) === 0) {
      t = dctSqrt2 * p0 + 8192 >> 14;

      if (t < -2040) {
        t = 0;
      } else if (t >= 2024) {
        t = 255;
      } else {
        t = t + 2056 >> 4;
      }

      blockData[blockBufferOffset + col] = t;
      blockData[blockBufferOffset + col + 8] = t;
      blockData[blockBufferOffset + col + 16] = t;
      blockData[blockBufferOffset + col + 24] = t;
      blockData[blockBufferOffset + col + 32] = t;
      blockData[blockBufferOffset + col + 40] = t;
      blockData[blockBufferOffset + col + 48] = t;
      blockData[blockBufferOffset + col + 56] = t;
      continue;
    }

    v0 = dctSqrt2 * p0 + 2048 >> 12;
    v1 = dctSqrt2 * p4 + 2048 >> 12;
    v2 = p2;
    v3 = p6;
    v4 = dctSqrt1d2 * (p1 - p7) + 2048 >> 12;
    v7 = dctSqrt1d2 * (p1 + p7) + 2048 >> 12;
    v5 = p3;
    v6 = p5;
    v0 = (v0 + v1 + 1 >> 1) + 4112;
    v1 = v0 - v1;
    t = v2 * dctSin6 + v3 * dctCos6 + 2048 >> 12;
    v2 = v2 * dctCos6 - v3 * dctSin6 + 2048 >> 12;
    v3 = t;
    v4 = v4 + v6 + 1 >> 1;
    v6 = v4 - v6;
    v7 = v7 + v5 + 1 >> 1;
    v5 = v7 - v5;
    v0 = v0 + v3 + 1 >> 1;
    v3 = v0 - v3;
    v1 = v1 + v2 + 1 >> 1;
    v2 = v1 - v2;
    t = v4 * dctSin3 + v7 * dctCos3 + 2048 >> 12;
    v4 = v4 * dctCos3 - v7 * dctSin3 + 2048 >> 12;
    v7 = t;
    t = v5 * dctSin1 + v6 * dctCos1 + 2048 >> 12;
    v5 = v5 * dctCos1 - v6 * dctSin1 + 2048 >> 12;
    v6 = t;
    p0 = v0 + v7;
    p7 = v0 - v7;
    p1 = v1 + v6;
    p6 = v1 - v6;
    p2 = v2 + v5;
    p5 = v2 - v5;
    p3 = v3 + v4;
    p4 = v3 - v4;

    if (p0 < 16) {
      p0 = 0;
    } else if (p0 >= 4080) {
      p0 = 255;
    } else {
      p0 >>= 4;
    }

    if (p1 < 16) {
      p1 = 0;
    } else if (p1 >= 4080) {
      p1 = 255;
    } else {
      p1 >>= 4;
    }

    if (p2 < 16) {
      p2 = 0;
    } else if (p2 >= 4080) {
      p2 = 255;
    } else {
      p2 >>= 4;
    }

    if (p3 < 16) {
      p3 = 0;
    } else if (p3 >= 4080) {
      p3 = 255;
    } else {
      p3 >>= 4;
    }

    if (p4 < 16) {
      p4 = 0;
    } else if (p4 >= 4080) {
      p4 = 255;
    } else {
      p4 >>= 4;
    }

    if (p5 < 16) {
      p5 = 0;
    } else if (p5 >= 4080) {
      p5 = 255;
    } else {
      p5 >>= 4;
    }

    if (p6 < 16) {
      p6 = 0;
    } else if (p6 >= 4080) {
      p6 = 255;
    } else {
      p6 >>= 4;
    }

    if (p7 < 16) {
      p7 = 0;
    } else if (p7 >= 4080) {
      p7 = 255;
    } else {
      p7 >>= 4;
    }

    blockData[blockBufferOffset + col] = p0;
    blockData[blockBufferOffset + col + 8] = p1;
    blockData[blockBufferOffset + col + 16] = p2;
    blockData[blockBufferOffset + col + 24] = p3;
    blockData[blockBufferOffset + col + 32] = p4;
    blockData[blockBufferOffset + col + 40] = p5;
    blockData[blockBufferOffset + col + 48] = p6;
    blockData[blockBufferOffset + col + 56] = p7;
  }
}

function buildComponentData(frame, component) {
  var blocksPerLine = component.blocksPerLine;
  var blocksPerColumn = component.blocksPerColumn;
  var computationBuffer = new Int16Array(64);

  for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
    for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
      var offset = getBlockBufferOffset(component, blockRow, blockCol);
      quantizeAndInverse(component, offset, computationBuffer);
    }
  }

  return component.blockData;
}

function findNextFileMarker(data, currentPos) {
  var startPos = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : currentPos;
  var maxPos = data.length - 1;
  var newPos = startPos < currentPos ? startPos : currentPos;

  if (currentPos >= maxPos) {
    return null;
  }

  var currentMarker = (0, _core_utils.readUint16)(data, currentPos);

  if (currentMarker >= 0xffc0 && currentMarker <= 0xfffe) {
    return {
      invalid: null,
      marker: currentMarker,
      offset: currentPos
    };
  }

  var newMarker = (0, _core_utils.readUint16)(data, newPos);

  while (!(newMarker >= 0xffc0 && newMarker <= 0xfffe)) {
    if (++newPos >= maxPos) {
      return null;
    }

    newMarker = (0, _core_utils.readUint16)(data, newPos);
  }

  return {
    invalid: currentMarker.toString(16),
    marker: newMarker,
    offset: newPos
  };
}

var JpegImage = /*#__PURE__*/function () {
  function JpegImage() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$decodeTransform = _ref.decodeTransform,
        decodeTransform = _ref$decodeTransform === void 0 ? null : _ref$decodeTransform,
        _ref$colorTransform = _ref.colorTransform,
        colorTransform = _ref$colorTransform === void 0 ? -1 : _ref$colorTransform;

    _classCallCheck(this, JpegImage);

    this._decodeTransform = decodeTransform;
    this._colorTransform = colorTransform;
  }

  _createClass(JpegImage, [{
    key: "parse",
    value: function parse(data) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$dnlScanLines = _ref2.dnlScanLines,
          dnlScanLines = _ref2$dnlScanLines === void 0 ? null : _ref2$dnlScanLines;

      function readDataBlock() {
        var length = (0, _core_utils.readUint16)(data, offset);
        offset += 2;
        var endOffset = offset + length - 2;
        var fileMarker = findNextFileMarker(data, endOffset, offset);

        if (fileMarker && fileMarker.invalid) {
          (0, _util.warn)("readDataBlock - incorrect length, current marker is: " + fileMarker.invalid);
          endOffset = fileMarker.offset;
        }

        var array = data.subarray(offset, endOffset);
        offset += array.length;
        return array;
      }

      function prepareComponents(frame) {
        var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / frame.maxH);
        var mcusPerColumn = Math.ceil(frame.scanLines / 8 / frame.maxV);

        for (var i = 0, ii = frame.components.length; i < ii; i++) {
          var component = frame.components[i];
          var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / frame.maxH);
          var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines / 8) * component.v / frame.maxV);
          var blocksPerLineForMcu = mcusPerLine * component.h;
          var blocksPerColumnForMcu = mcusPerColumn * component.v;
          var blocksBufferSize = 64 * blocksPerColumnForMcu * (blocksPerLineForMcu + 1);
          component.blockData = new Int16Array(blocksBufferSize);
          component.blocksPerLine = blocksPerLine;
          component.blocksPerColumn = blocksPerColumn;
        }

        frame.mcusPerLine = mcusPerLine;
        frame.mcusPerColumn = mcusPerColumn;
      }

      var offset = 0;
      var jfif = null;
      var adobe = null;
      var frame, resetInterval;
      var numSOSMarkers = 0;
      var quantizationTables = [];
      var huffmanTablesAC = [],
          huffmanTablesDC = [];
      var fileMarker = (0, _core_utils.readUint16)(data, offset);
      offset += 2;

      if (fileMarker !== 0xffd8) {
        throw new JpegError("SOI not found");
      }

      fileMarker = (0, _core_utils.readUint16)(data, offset);
      offset += 2;

      markerLoop: while (fileMarker !== 0xffd9) {
        var i = void 0,
            j = void 0,
            l = void 0;

        switch (fileMarker) {
          case 0xffe0:
          case 0xffe1:
          case 0xffe2:
          case 0xffe3:
          case 0xffe4:
          case 0xffe5:
          case 0xffe6:
          case 0xffe7:
          case 0xffe8:
          case 0xffe9:
          case 0xffea:
          case 0xffeb:
          case 0xffec:
          case 0xffed:
          case 0xffee:
          case 0xffef:
          case 0xfffe:
            var appData = readDataBlock();

            if (fileMarker === 0xffe0) {
              if (appData[0] === 0x4a && appData[1] === 0x46 && appData[2] === 0x49 && appData[3] === 0x46 && appData[4] === 0) {
                jfif = {
                  version: {
                    major: appData[5],
                    minor: appData[6]
                  },
                  densityUnits: appData[7],
                  xDensity: appData[8] << 8 | appData[9],
                  yDensity: appData[10] << 8 | appData[11],
                  thumbWidth: appData[12],
                  thumbHeight: appData[13],
                  thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
                };
              }
            }

            if (fileMarker === 0xffee) {
              if (appData[0] === 0x41 && appData[1] === 0x64 && appData[2] === 0x6f && appData[3] === 0x62 && appData[4] === 0x65) {
                adobe = {
                  version: appData[5] << 8 | appData[6],
                  flags0: appData[7] << 8 | appData[8],
                  flags1: appData[9] << 8 | appData[10],
                  transformCode: appData[11]
                };
              }
            }

            break;

          case 0xffdb:
            var quantizationTablesLength = (0, _core_utils.readUint16)(data, offset);
            offset += 2;
            var quantizationTablesEnd = quantizationTablesLength + offset - 2;
            var z = void 0;

            while (offset < quantizationTablesEnd) {
              var quantizationTableSpec = data[offset++];
              var tableData = new Uint16Array(64);

              if (quantizationTableSpec >> 4 === 0) {
                for (j = 0; j < 64; j++) {
                  z = dctZigZag[j];
                  tableData[z] = data[offset++];
                }
              } else if (quantizationTableSpec >> 4 === 1) {
                for (j = 0; j < 64; j++) {
                  z = dctZigZag[j];
                  tableData[z] = (0, _core_utils.readUint16)(data, offset);
                  offset += 2;
                }
              } else {
                throw new JpegError("DQT - invalid table spec");
              }

              quantizationTables[quantizationTableSpec & 15] = tableData;
            }

            break;

          case 0xffc0:
          case 0xffc1:
          case 0xffc2:
            if (frame) {
              throw new JpegError("Only single frame JPEGs supported");
            }

            offset += 2;
            frame = {};
            frame.extended = fileMarker === 0xffc1;
            frame.progressive = fileMarker === 0xffc2;
            frame.precision = data[offset++];
            var sofScanLines = (0, _core_utils.readUint16)(data, offset);
            offset += 2;
            frame.scanLines = dnlScanLines || sofScanLines;
            frame.samplesPerLine = (0, _core_utils.readUint16)(data, offset);
            offset += 2;
            frame.components = [];
            frame.componentIds = {};
            var componentsCount = data[offset++];
            var maxH = 0,
                maxV = 0;

            for (i = 0; i < componentsCount; i++) {
              var componentId = data[offset];
              var h = data[offset + 1] >> 4;
              var v = data[offset + 1] & 15;

              if (maxH < h) {
                maxH = h;
              }

              if (maxV < v) {
                maxV = v;
              }

              var qId = data[offset + 2];
              l = frame.components.push({
                h: h,
                v: v,
                quantizationId: qId,
                quantizationTable: null
              });
              frame.componentIds[componentId] = l - 1;
              offset += 3;
            }

            frame.maxH = maxH;
            frame.maxV = maxV;
            prepareComponents(frame);
            break;

          case 0xffc4:
            var huffmanLength = (0, _core_utils.readUint16)(data, offset);
            offset += 2;

            for (i = 2; i < huffmanLength;) {
              var huffmanTableSpec = data[offset++];
              var codeLengths = new Uint8Array(16);
              var codeLengthSum = 0;

              for (j = 0; j < 16; j++, offset++) {
                codeLengthSum += codeLengths[j] = data[offset];
              }

              var huffmanValues = new Uint8Array(codeLengthSum);

              for (j = 0; j < codeLengthSum; j++, offset++) {
                huffmanValues[j] = data[offset];
              }

              i += 17 + codeLengthSum;
              (huffmanTableSpec >> 4 === 0 ? huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] = buildHuffmanTable(codeLengths, huffmanValues);
            }

            break;

          case 0xffdd:
            offset += 2;
            resetInterval = (0, _core_utils.readUint16)(data, offset);
            offset += 2;
            break;

          case 0xffda:
            var parseDNLMarker = ++numSOSMarkers === 1 && !dnlScanLines;
            offset += 2;
            var selectorsCount = data[offset++],
                components = [];

            for (i = 0; i < selectorsCount; i++) {
              var index = data[offset++];
              var componentIndex = frame.componentIds[index];
              var component = frame.components[componentIndex];
              component.index = index;
              var tableSpec = data[offset++];
              component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
              component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
              components.push(component);
            }

            var spectralStart = data[offset++],
                spectralEnd = data[offset++],
                successiveApproximation = data[offset++];

            try {
              var processed = decodeScan(data, offset, frame, components, resetInterval, spectralStart, spectralEnd, successiveApproximation >> 4, successiveApproximation & 15, parseDNLMarker);
              offset += processed;
            } catch (ex) {
              if (ex instanceof DNLMarkerError) {
                (0, _util.warn)("".concat(ex.message, " -- attempting to re-parse the JPEG image."));
                return this.parse(data, {
                  dnlScanLines: ex.scanLines
                });
              } else if (ex instanceof EOIMarkerError) {
                (0, _util.warn)("".concat(ex.message, " -- ignoring the rest of the image data."));
                break markerLoop;
              }

              throw ex;
            }

            break;

          case 0xffdc:
            offset += 4;
            break;

          case 0xffff:
            if (data[offset] !== 0xff) {
              offset--;
            }

            break;

          default:
            var nextFileMarker = findNextFileMarker(data, offset - 2, offset - 3);

            if (nextFileMarker && nextFileMarker.invalid) {
              (0, _util.warn)("JpegImage.parse - unexpected data, current marker is: " + nextFileMarker.invalid);
              offset = nextFileMarker.offset;
              break;
            }

            if (!nextFileMarker || offset >= data.length - 1) {
              (0, _util.warn)("JpegImage.parse - reached the end of the image data " + "without finding an EOI marker (0xFFD9).");
              break markerLoop;
            }

            throw new JpegError("JpegImage.parse - unknown marker: " + fileMarker.toString(16));
        }

        fileMarker = (0, _core_utils.readUint16)(data, offset);
        offset += 2;
      }

      this.width = frame.samplesPerLine;
      this.height = frame.scanLines;
      this.jfif = jfif;
      this.adobe = adobe;
      this.components = [];

      for (var _i = 0, ii = frame.components.length; _i < ii; _i++) {
        var _component = frame.components[_i];
        var quantizationTable = quantizationTables[_component.quantizationId];

        if (quantizationTable) {
          _component.quantizationTable = quantizationTable;
        }

        this.components.push({
          index: _component.index,
          output: buildComponentData(frame, _component),
          scaleX: _component.h / frame.maxH,
          scaleY: _component.v / frame.maxV,
          blocksPerLine: _component.blocksPerLine,
          blocksPerColumn: _component.blocksPerColumn
        });
      }

      this.numComponents = this.components.length;
      return undefined;
    }
  }, {
    key: "_getLinearizedBlockData",
    value: function _getLinearizedBlockData(width, height) {
      var isSourcePDF = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var scaleX = this.width / width,
          scaleY = this.height / height;
      var component, componentScaleX, componentScaleY, blocksPerScanline;
      var x, y, i, j, k;
      var index;
      var offset = 0;
      var output;
      var numComponents = this.components.length;
      var dataLength = width * height * numComponents;
      var data = new Uint8ClampedArray(dataLength);
      var xScaleBlockOffset = new Uint32Array(width);
      var mask3LSB = 0xfffffff8;
      var lastComponentScaleX;

      for (i = 0; i < numComponents; i++) {
        component = this.components[i];
        componentScaleX = component.scaleX * scaleX;
        componentScaleY = component.scaleY * scaleY;
        offset = i;
        output = component.output;
        blocksPerScanline = component.blocksPerLine + 1 << 3;

        if (componentScaleX !== lastComponentScaleX) {
          for (x = 0; x < width; x++) {
            j = 0 | x * componentScaleX;
            xScaleBlockOffset[x] = (j & mask3LSB) << 3 | j & 7;
          }

          lastComponentScaleX = componentScaleX;
        }

        for (y = 0; y < height; y++) {
          j = 0 | y * componentScaleY;
          index = blocksPerScanline * (j & mask3LSB) | (j & 7) << 3;

          for (x = 0; x < width; x++) {
            data[offset] = output[index + xScaleBlockOffset[x]];
            offset += numComponents;
          }
        }
      }

      var transform = this._decodeTransform;

      if (!isSourcePDF && numComponents === 4 && !transform) {
        transform = new Int32Array([-256, 255, -256, 255, -256, 255, -256, 255]);
      }

      if (transform) {
        for (i = 0; i < dataLength;) {
          for (j = 0, k = 0; j < numComponents; j++, i++, k += 2) {
            data[i] = (data[i] * transform[k] >> 8) + transform[k + 1];
          }
        }
      }

      return data;
    }
  }, {
    key: "_isColorConversionNeeded",
    get: function get() {
      if (this.adobe) {
        return !!this.adobe.transformCode;
      }

      if (this.numComponents === 3) {
        if (this._colorTransform === 0) {
          return false;
        } else if (this.components[0].index === 0x52 && this.components[1].index === 0x47 && this.components[2].index === 0x42) {
          return false;
        }

        return true;
      }

      if (this._colorTransform === 1) {
        return true;
      }

      return false;
    }
  }, {
    key: "_convertYccToRgb",
    value: function _convertYccToRgb(data) {
      var Y, Cb, Cr;

      for (var i = 0, length = data.length; i < length; i += 3) {
        Y = data[i];
        Cb = data[i + 1];
        Cr = data[i + 2];
        data[i] = Y - 179.456 + 1.402 * Cr;
        data[i + 1] = Y + 135.459 - 0.344 * Cb - 0.714 * Cr;
        data[i + 2] = Y - 226.816 + 1.772 * Cb;
      }

      return data;
    }
  }, {
    key: "_convertYcckToRgb",
    value: function _convertYcckToRgb(data) {
      var Y, Cb, Cr, k;
      var offset = 0;

      for (var i = 0, length = data.length; i < length; i += 4) {
        Y = data[i];
        Cb = data[i + 1];
        Cr = data[i + 2];
        k = data[i + 3];
        data[offset++] = -122.67195406894 + Cb * (-6.60635669420364e-5 * Cb + 0.000437130475926232 * Cr - 5.4080610064599e-5 * Y + 0.00048449797120281 * k - 0.154362151871126) + Cr * (-0.000957964378445773 * Cr + 0.000817076911346625 * Y - 0.00477271405408747 * k + 1.53380253221734) + Y * (0.000961250184130688 * Y - 0.00266257332283933 * k + 0.48357088451265) + k * (-0.000336197177618394 * k + 0.484791561490776);
        data[offset++] = 107.268039397724 + Cb * (2.19927104525741e-5 * Cb - 0.000640992018297945 * Cr + 0.000659397001245577 * Y + 0.000426105652938837 * k - 0.176491792462875) + Cr * (-0.000778269941513683 * Cr + 0.00130872261408275 * Y + 0.000770482631801132 * k - 0.151051492775562) + Y * (0.00126935368114843 * Y - 0.00265090189010898 * k + 0.25802910206845) + k * (-0.000318913117588328 * k - 0.213742400323665);
        data[offset++] = -20.810012546947 + Cb * (-0.000570115196973677 * Cb - 2.63409051004589e-5 * Cr + 0.0020741088115012 * Y - 0.00288260236853442 * k + 0.814272968359295) + Cr * (-1.53496057440975e-5 * Cr - 0.000132689043961446 * Y + 0.000560833691242812 * k - 0.195152027534049) + Y * (0.00174418132927582 * Y - 0.00255243321439347 * k + 0.116935020465145) + k * (-0.000343531996510555 * k + 0.24165260232407);
      }

      return data.subarray(0, offset)